/**
 * TradingView Advanced Charts
 * @packageDocumentation
 * @module Charting Library
 */
// Generated by dts-bundle-generator v7.0.0

declare const dateFormatFunctions: {
  readonly "dd MMM 'yy": (date: Date, local: boolean) => string;
  readonly "MMM 'yy": (date: Date, local: boolean) => string;
  readonly "MMM dd, yyyy": (date: Date, local: boolean) => string;
  readonly "MMM yyyy": (date: Date, local: boolean) => string;
  readonly "MMM dd": (date: Date, local: boolean) => string;
  readonly "dd MMM": (date: Date, local: boolean) => string;
  readonly "yyyy-MM-dd": (date: Date, local: boolean) => string;
  readonly "yy-MM-dd": (date: Date, local: boolean) => string;
  readonly "yy/MM/dd": (date: Date, local: boolean) => string;
  readonly "yyyy/MM/dd": (date: Date, local: boolean) => string;
  readonly "dd-MM-yyyy": (date: Date, local: boolean) => string;
  readonly "dd-MM-yy": (date: Date, local: boolean) => string;
  readonly "dd/MM/yy": (date: Date, local: boolean) => string;
  readonly "dd/MM/yyyy": (date: Date, local: boolean) => string;
  readonly "MM/dd/yy": (date: Date, local: boolean) => string;
  readonly "MM/dd/yyyy": (date: Date, local: boolean) => string;
};

declare enum HHistDirection {
  LeftToRight = "left_to_right",
  RightToLeft = "right_to_left",
}
declare enum LineStudyPlotStyle {
  /**
   * Line plot style.
   */
  Line = 0,
  /**
   * Histogram plot style.
   */
  Histogram = 1,
  /**
   * Cross plot style.
   */
  Cross = 3,
  /**
   * Area plot style.
   */
  Area = 4,
  /**
   * Column plot style.
   */
  Columns = 5,
  /**
   * Circles plot style.
   */
  Circles = 6,
  /**
   * Line with breaks plot style.
   */
  LineWithBreaks = 7,
  /**
   * Area with breaks plot style.
   */
  AreaWithBreaks = 8,
  /**
   * Step line plot style.
   */
  StepLine = 9,
  /**
   * Step line with diamonds plot style.
   */
  StepLineWithDiamonds = 10,
  /**
   * Step line with breaks, like LineWithBreaks
   */
  StepLineWithBreaks = 11,
}
declare enum LineStyle {
  /**
   * Solid line style.
   */
  Solid = 0,
  /**
   * Dotted line style.
   */
  Dotted = 1,
  /**
   * Dashed line style.
   */
  Dashed = 2,
}
declare enum MarkLocation {
  AboveBar = "AboveBar",
  BelowBar = "BelowBar",
  Top = "Top",
  Bottom = "Bottom",
  Right = "Right",
  Left = "Left",
  Absolute = "Absolute",
  AbsoluteUp = "AbsoluteUp",
  AbsoluteDown = "AbsoluteDown",
}
declare enum OrderOrPositionMessageType {
  Information = "information",
  Warning = "warning",
  Error = "error",
}
declare enum PlotSymbolSize {
  Auto = "auto",
  Tiny = "tiny",
  Small = "small",
  Normal = "normal",
  Large = "large",
  Huge = "huge",
}
declare enum StopType {
  StopLoss = 0,
  TrailingStop = 1,
}
export declare const enum ActionId {
  ChartAddIndicatorToAllCharts = "Chart.AddIndicatorToAllCharts",
  ChartAddSymbolToWatchList = "Chart.AddSymbolToWatchList",
  ChartApplyIndicatorsToAllCharts = "Chart.ApplyIndicatorsToAllCharts",
  ChartChangeTimeZone = "Chart.ChangeTimeZone",
  ChartClipboardCopyPrice = "Chart.Clipboard.CopyPrice",
  ChartClipboardCopyLineTools = "Chart.Clipboard.CopyLineTools",
  ChartClipboardCopySource = "Chart.Clipboard.CopySource",
  ChartClipboardPasteSource = "Chart.Clipboard.PasteSource",
  ChartCrosshairLockVerticalCursor = "Chart.Crosshair.LockVerticalCursor",
  ChartCrosshairPlusButtonDrawHorizontalLine = "Chart.Crosshair.PlusButton.DrawHorizontalLine",
  ChartCustomActionId = "Chart.CustomActionId",
  ChartDialogsShowChangeInterval = "Chart.Dialogs.ShowChangeInterval",
  ChartDialogsShowChangeSymbol = "Chart.Dialogs.ShowChangeSymbol",
  ChartDialogsShowCompareOrAddSymbol = "Chart.Dialogs.ShowCompareOrAddSymbol",
  ChartDialogsShowGeneralSettings = "Chart.Dialogs.ShowGeneralSettings",
  ChartDialogsShowGeneralSettingsLegendTab = "Chart.Dialogs.ShowGeneralSettings.LegendTab",
  ChartDialogsShowGeneralSettingsSymbolTab = "Chart.Dialogs.ShowGeneralSettings.SymbolTab",
  ChartDialogsShowGeneralScalesTab = "Chart.Dialogs.ShowGeneralSettings.ScalesTab",
  ChartDialogsShowGoToDate = "Chart.Dialogs.ShowGoToDate",
  ChartDialogsShowInsertIndicators = "Chart.Dialogs.ShowInsertIndicators",
  ChartDialogsShowSymbolInfo = "Chart.Dialogs.ShowSymbolInfo",
  ChartDrawingToolbarToggleVisibility = "Chart.DrawingToolbar.ToggleVisibility",
  ChartExternalActionId = "Chart.ExternalActionId",
  ChartFavoriteDrawingToolsToolbarHide = "Chart.FavoriteDrawingToolsToolbar.Hide",
  ChartIndicatorShowSettingsDialog = "Chart.Indicator.ShowSettingsDialog",
  ChartLegendToggleLastDayChangeValuesVisibility = "Chart.Legend.ToggleLastDayChangeValuesVisibility",
  ChartLegendToggleBarChangeValuesVisibility = "Chart.Legend.ToggleBarChangeValuesVisibility",
  ChartLegendTogglePriceSourceVisibility = "Chart.Legend.TogglePriceSourceVisibility",
  ChartLegendToggleIndicatorArgumentsVisibility = "Chart.Legend.ToggleIndicatorArgumentsVisibility",
  ChartLegendToggleIndicatorTitlesVisibility = "Chart.Legend.ToggleIndicatorTitlesVisibility",
  ChartLegendToggleIndicatorValuesVisibility = "Chart.Legend.ToggleIndicatorValuesVisibility",
  ChartLegendToggleOhlcValuesVisibility = "Chart.Legend.ToggleOhlcValuesVisibility",
  ChartLegendToggleOpenMarketStatusVisibility = "Chart.Legend.ToggleOpenMarketStatusVisibility",
  ChartLegendToggleSymbolVisibility = "Chart.Legend.ToggleSymbolVisibility",
  ChartLegendToggleVolumeVisibility = "Chart.Legend.ToggleVolumeVisibility",
  ChartLines = "Chart.Lines",
  ChartLinesToggleBidAskLinesVisibility = "Chart.Lines.ToggleBidAskLinesVisibility",
  ChartLinesToggleHighLowLinesVisibility = "Chart.Lines.ToggleHighLowLinesVisibility",
  ChartLinesToggleAverageLineVisibility = "Chart.Lines.ToggleAverageLineVisibility",
  ChartLinesToggleSeriesPrevCloseLineVisibility = "Chart.Lines.ToggleSeriesPrevCloseLineVisibility",
  ChartLinesToggleSeriesPriceLineVisibility = "Chart.Lines.ToggleSeriesPriceLineVisibility",
  ChartLineToolBarsPatternToggleFlipped = "Chart.LineTool.BarsPattern.ToggleFlipped",
  ChartLineToolBarsPatternToggleMirrored = "Chart.LineTool.BarsPattern.ToggleMirrored",
  ChartLineToolClone = "Chart.LineTool.Clone",
  ChartLineToolCreateLimitOrderFromState = "Chart.LineTool.CreateLimitOrderFromState",
  ChartLineToolElliotChangeDegreeProperty = "Chart.LineTool.Elliot.ChangeDegreeProperty",
  ChartLineToolNoSync = "Chart.LineTool.NoSync",
  ChartLineToolPitchforkChangeTypeToInside = "Chart.LineTool.Pitchfork.ChangeTypeToInside",
  ChartLineToolPitchforkChangeTypeToModifiedSchiff = "Chart.LineTool.Pitchfork.ChangeTypeToModifiedSchiff",
  ChartLineToolPitchforkChangeTypeToOriginal = "Chart.LineTool.Pitchfork.ChangeTypeToOriginal",
  ChartLineToolPitchforkChangeTypeToSchiff = "Chart.LineTool.Pitchfork.ChangeTypeToSchiff",
  ChartLineToolSyncInLayout = "Chart.LineTool.SyncInLayout",
  ChartLineToolTemplates = "Chart.LineTool.Templates",
  ChartLineToolTemplatesApply = "Chart.LineTool.Templates.Apply",
  ChartLineToolTemplatesApplyDefaults = "Chart.LineTool.Templates.ApplyDefaults",
  ChartLineToolTemplatesSaveAs = "Chart.LineTool.Templates.SaveAs",
  ChartLineToolToolbarChangeFontSizeProperty = "Chart.LineTool.Toolbar.ChangeFontSizeProperty",
  ChartLineToolToolbarChangeLineStyleToDashed = "Chart.LineTool.Toolbar.ChangeLineStyleToDashed",
  ChartLineToolToolbarChangeLineStyleToDotted = "Chart.LineTool.Toolbar.ChangeLineStyleToDotted",
  ChartLineToolToolbarChangeLineStyleToSolid = "Chart.LineTool.Toolbar.ChangeLineStyleToSolid",
  ChartMarksToggleVisibility = "Chart.Marks.ToggleVisibility",
  ChartMoveChartInLayout = "Chart.MoveChartInLayout",
  ChartMoveChartInLayoutBack = "Chart.MoveChartInLayout.Back",
  ChartMoveChartInLayoutForward = "Chart.MoveChartInLayout.Forward",
  ChartObjectTreeShow = "Chart.ObjectTree.Show",
  ChartDataWindowShow = "Chart.DataWindow.Show",
  ChartPaneControlsDeletePane = "Chart.PaneControls.DeletePane",
  ChartPaneControlsMaximizePane = "Chart.PaneControls.MaximizePane",
  ChartPaneControlsMinimizePane = "Chart.PaneControls.MinimizePane",
  ChartPaneControlsMovePaneDown = "Chart.PaneControls.MovePaneDown",
  ChartPaneControlsMovePaneUp = "Chart.PaneControls.MovePaneUp",
  ChartPaneControlsCollapsePane = "Chart.PaneControls.CollapsePane",
  ChartPaneControlsRestorePane = "Chart.PaneControls.RestorePane",
  ChartPriceScaleLabels = "Chart.PriceScale.Labels",
  ChartPriceScaleLabelsToggleBidAskLabelsVisibility = "Chart.PriceScale.Labels.ToggleBidAskLabelsVisibility",
  ChartPriceScaleLabelsToggleHighLowPriceLabelsVisibility = "Chart.PriceScale.Labels.ToggleHighLowPriceLabelsVisibility",
  ChartPriceScaleLabelsToggleAveragePriceLabelVisibility = "Chart.PriceScale.Labels.ToggleAveragePriceLabelVisibility",
  ChartPriceScaleLabelsToggleIndicatorsNameLabelsVisibility = "Chart.PriceScale.Labels.ToggleIndicatorsNameLabelsVisibility",
  ChartPriceScaleLabelsToggleIndicatorsValueLabelsVisibility = "Chart.PriceScale.Labels.ToggleIndicatorsValueLabelsVisibility",
  ChartPriceScaleLabelsToggleNoOverlappingLabelsVisibility = "Chart.PriceScale.Labels.ToggleNoOverlappingLabelsVisibility",
  ChartPriceScaleLabelsToggleSeriesLastValueVisibility = "Chart.PriceScale.Labels.ToggleSeriesLastValueVisibility",
  ChartPriceScaleLabelsToggleSymbolNameLabelsVisibility = "Chart.PriceScale.Labels.ToggleSymbolNameLabelsVisibility",
  ChartPriceScaleLabelsToggleSymbolPrevCloseValueVisibility = "Chart.PriceScale.Labels.ToggleSymbolPrevCloseValueVisibility",
  ChartPriceScaleMergeAllScales = "Chart.PriceScale.MergeAllScales",
  ChartPriceScaleMergeAllScalesToLeft = "Chart.PriceScale.MergeAllScalesToLeft",
  ChartPriceScaleMergeAllScalesToRight = "Chart.PriceScale.MergeAllScalesToRight",
  ChartPriceScaleMoveToLeft = "Chart.PriceScale.MoveToLeft",
  ChartPriceScaleMoveToRight = "Chart.PriceScale.MoveToRight",
  ChartPriceScaleReset = "Chart.PriceScale.Reset",
  ChartPriceScaleToggleAddOrderPlusButtonVisibility = "Chart.PriceScale.ToggleAddOrderPlusButtonVisibility",
  ChartPriceScaleToggleAutoScale = "Chart.PriceScale.ToggleAutoScale",
  ChartPriceScaleToggleAutoScaleSeriesOnly = "Chart.PriceScale.ToggleAutoScaleSeriesOnly",
  ChartPriceScaleToggleCountdownToBarCloseVisibility = "Chart.PriceScale.ToggleCountdownToBarCloseVisibility",
  ChartPriceScaleToggleIndexedTo100 = "Chart.PriceScale.ToggleIndexedTo100",
  ChartPriceScaleToggleInvertScale = "Chart.PriceScale.ToggleInvertScale",
  ChartPriceScaleToggleLogarithmic = "Chart.PriceScale.ToggleLogarithmic",
  ChartPriceScaleTogglePercentage = "Chart.PriceScale.TogglePercentage",
  ChartPriceScaleToggleRegular = "Chart.PriceScale.ToggleRegular",
  ChartRedo = "Chart.Redo",
  ChartRemoveAllIndicators = "Chart.RemoveAllIndicators",
  ChartRemoveAllIndicatorsAndLineTools = "Chart.RemoveAllIndicatorsAndLineTools",
  ChartRemoveAllLineTools = "Chart.RemoveAllLineTools",
  ChartScalesReset = "Chart.Scales.Reset",
  ChartScalesToggleLockPriceToBarRatio = "Chart.Scales.ToggleLockPriceToBarRatio",
  ChartScrollToLineTool = "Chart.ScrollToLineTool",
  ChartSelectedObjectHide = "Chart.SelectedObject.Hide",
  ChartSelectedObjectRemove = "Chart.SelectedObject.Remove",
  ChartSelectedObjectShow = "Chart.SelectedObject.Show",
  ChartSelectedObjectShowSettingsDialog = "Chart.SelectedObject.ShowSettingsDialog",
  ChartSelectedObjectToggleLocked = "Chart.SelectedObject.ToggleLocked",
  ChartSeriesPriceScaleToggleAutoScale = "Chart.Series.PriceScale.ToggleAutoScale",
  ChartSeriesPriceScaleToggleIndexedTo100 = "Chart.Series.PriceScale.ToggleIndexedTo100",
  ChartSeriesPriceScaleToggleInvertPriceScale = "Chart.Series.PriceScale.ToggleInvertPriceScale",
  ChartSeriesPriceScaleToggleLogarithmic = "Chart.Series.PriceScale.ToggleLogarithmic",
  ChartSeriesPriceScaleTogglePercentage = "Chart.Series.PriceScale.TogglePercentage",
  ChartSeriesPriceScaleToggleRegular = "Chart.Series.PriceScale.ToggleRegular",
  ChartSessionBreaksToggleVisibility = "Chart.SessionBreaks.ToggleVisibility",
  ChartSetSession = "Chart.SetSession",
  ChartSourceChangePriceScale = "Chart.Source.ChangePriceScale",
  ChartSourceMergeDown = "Chart.Source.MergeDown",
  ChartSourceMergeUp = "Chart.Source.MergeUp",
  ChartSourceMoveToNoScale = "Chart.Source.MoveToNoScale",
  ChartSourceMoveToOtherScale = "Chart.Source.MoveToOtherScale",
  ChartSourceMoveToPane = "Chart.Source.MoveToPane",
  ChartSourceUnmergeDown = "Chart.Source.UnmergeDown",
  ChartSourceUnmergeUp = "Chart.Source.UnmergeUp",
  ChartSourceVisualOrder = "Chart.Source.VisualOrder",
  ChartSourceVisualOrderBringForward = "Chart.Source.VisualOrder.BringForward",
  ChartSourceVisualOrderBringToFront = "Chart.Source.VisualOrder.BringToFront",
  ChartSourceVisualOrderSendBackward = "Chart.Source.VisualOrder.SendBackward",
  ChartSourceVisualOrderSendToBack = "Chart.Source.VisualOrder.SendToBack",
  ChartSourceResetInputPoints = "Chart.Source.ResetInputPoints",
  ChartTimeScaleReset = "Chart.TimeScale.Reset",
  ChartUndo = "Chart.Undo",
  ChartSourceIntervalsVisibility = "Chart.Source.IntervalsVisibility",
  ChartSourceIntervalsVisibilityCurrentAndAbove = "Chart.Source.IntervalsVisibility.CurrentAndAbove",
  ChartSourceIntervalsVisibilityCurrentAndBelow = "Chart.Source.IntervalsVisibility.CurrentAndBelow",
  ChartSourceIntervalsVisibilityOnlyCurrent = "Chart.Source.IntervalsVisibility.Current",
  ChartSourceIntervalsVisibilityAll = "Chart.Source.IntervalsVisibility.All",
  ObjectsTreeCreateGroup = "ObjectsTree.CreateGroup",
  ObjectsTreeRemoveItem = "ObjectsTree.RemoveItem",
  ObjectsTreeRenameItem = "ObjectsTree.RenameItem",
  ObjectsTreeToggleItemLocked = "ObjectsTree.ToggleItemLocked",
  ObjectsTreeToggleItemVisibility = "ObjectsTree.ToggleItemVisibility",
  TradingCancelOrder = "Trading.CancelOrder",
  TradingClosePosition = "Trading.ClosePosition",
  TradingCustomActionId = "Trading.CustomActionId",
  TradingDOMPlaceLimitOrder = "Trading.DOMPlaceLimitOrder",
  TradingDOMPlaceMarketOrder = "Trading.DOMPlaceMarketOrder",
  TradingDOMPlaceStopLimitOrder = "Trading.DOMPlaceStopLimitOrder",
  TradingDOMPlaceStopOrder = "Trading.DOMPlaceStopOrder",
  TradingEditOrder = "Trading.EditOrder",
  TradingModifyPosition = "Trading.ModifyPosition",
  TradingReversePosition = "Trading.ReversePosition",
  TradingSellBuyButtonsToggleVisibility = "Trading.SellBuyButtonsToggleVisibility",
  TradingTradeFromChart = "Trading.TradeFromChart",
  TradingNoOverlapMode = "Trading.NoOverlapMode",
  WatchlistAddSelectedSymbolsToCompare = "Watchlist.AddSelectedSymbolsToCompare ",
  WatchlistAddSymbolToCompare = "Watchlist.AddSymbolToCompare",
  WatchlistAddSymbolToSection = "Watchlist.AddSymbolToSection",
  WatchlistAddSymbol = "Watchlist.AddSymbol",
  WatchlistRemoveSection = "Watchlist.RemoveSection",
  WatchlistRenameSection = "Watchlist.RenameSection",
}
export declare const enum ChartStyle {
  Bar = 0,
  Candle = 1,
  Line = 2,
  Area = 3,
  Renko = 4,
  Kagi = 5,
  PnF = 6,
  LineBreak = 7,
  HeikinAshi = 8,
  HollowCandle = 9,
  Baseline = 10,
  HiLo = 12,
  Column = 13,
  LineWithMarkers = 14,
  Stepline = 15,
  HLCArea = 16,
}
/**
 * Mode to clear the marks on the chart.
 */
export declare const enum ClearMarksMode {
  /** Will clear both bar marks AND timescale marks - default value */
  All = 0,
  /** Will only clear bar marks */
  BarMarks = 1,
  /** Will only clear timescale marks */
  TimeScaleMarks = 2,
}
export declare const enum ConnectionStatus {
  Connected = 1,
  Connecting = 2,
  Disconnected = 3,
  Error = 4,
}
/**
 * Filled area type.
 */
export declare const enum FilledAreaType {
  /**
   * Filled area type for plots.
   */
  TypePlots = "plot_plot",
  /**
   * Filled area type for bands.
   */
  TypeHlines = "hline_hline",
}
/**
 * Market status for the symbol.
 */
export declare const enum MarketStatus {
  Open = "market",
  Pre = "pre_market",
  Post = "post_market",
  Close = "out_of_session",
  Holiday = "holiday",
}
export declare const enum MenuItemType {
  Separator = "separator",
  Action = "action",
}
export declare const enum NotificationType {
  Error = 0,
  Success = 1,
}
export declare const enum OhlcStudyPlotStyle {
  OhlcBars = "ohlc_bars",
  OhlcCandles = "ohlc_candles",
}
export declare const enum OrderStatus {
  Canceled = 1,
  Filled = 2,
  Inactive = 3,
  Placing = 4,
  Rejected = 5,
  Working = 6,
}
export declare const enum OrderStatusFilter {
  All = 0,
  Canceled = 1,
  Filled = 2,
  Inactive = 3,
  Rejected = 5,
  Working = 6,
}
export declare const enum OrderTicketFocusControl {
  LimitPrice = 1,
  StopPrice = 2,
  TakeProfit = 3,
  StopLoss = 4,
  Quantity = 5,
}
export declare const enum OrderType {
  Limit = 1,
  Market = 2,
  Stop = 3,
  StopLimit = 4,
}
/**
 * Plot line style
 */
export declare const enum OverrideLineStyle {
  /**
   * Solid line style.
   */
  Solid = 0,
  /**
   * Dotted line style.
   */
  Dotted = 1,
  /**
   * Dashed line style.
   */
  Dashed = 2,
}
/**
 * Last value label mode.
 */
export declare const enum OverridePriceAxisLastValueMode {
  /**
   * Price and % value.
   */
  LastPriceAndPercentageValue = 0,
  /**
   * Value according to scale.
   */
  LastValueAccordingToScale = 1,
}
export declare const enum ParentType {
  Order = 1,
  Position = 2,
  IndividualPosition = 3,
}
export declare const enum PriceScaleMode {
  /** Normal mode of the price scale */
  Normal = 0,
  /** Logarithmic mode of the price scale */
  Log = 1,
  /** Percentage mode of the price scale */
  Percentage = 2,
  /** Indexed to 100 mode of the price scale */
  IndexedTo100 = 3,
}
export declare const enum SeriesType {
  Bars = 0,
  Candles = 1,
  Line = 2,
  Area = 3,
  HeikenAshi = 8,
  HollowCandles = 9,
  Baseline = 10,
  HiLo = 12,
  Column = 13,
  LineWithMarkers = 14,
  Stepline = 15,
  HLCArea = 16,
  Renko = 4,
  Kagi = 5,
  PointAndFigure = 6,
  LineBreak = 7,
}
export declare const enum Side {
  Buy = 1,
  Sell = -1,
}
/**
 * Enumeration of the built-in formatters for the Account Manager columns.
 * Refer to the [Value formatters](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/value-formatters.md) section for more information.
 */
export declare const enum StandardFormatterName {
  Date = "date",
  DateOrDateTime = "dateOrDateTime",
  Default = "default",
  Fixed = "fixed",
  FixedInCurrency = "fixedInCurrency",
  VariablePrecision = "variablePrecision",
  FormatQuantity = "formatQuantity",
  FormatPrice = "formatPrice",
  FormatPriceForexSup = "formatPriceForexSup",
  IntegerSeparated = "integerSeparated",
  LocalDate = "localDate",
  LocalDateOrDateTime = "localDateOrDateTime",
  Percentage = "percentage",
  Pips = "pips",
  Profit = "profit",
  ProfitInInstrumentCurrency = "profitInInstrumentCurrency",
  Side = "side",
  PositionSide = "positionSide",
  Status = "status",
  Symbol = "symbol",
  Text = "text",
  Type = "type",
  MarginPercent = "marginPercent",
  Empty = "empty",
}
export declare const enum StudyInputType {
  Integer = "integer",
  Float = "float",
  Price = "price",
  Bool = "bool",
  Text = "text",
  Symbol = "symbol",
  Session = "session",
  Source = "source",
  Resolution = "resolution",
  Time = "time",
  BarTime = "bar_time",
  Color = "color",
  Textarea = "text_area",
}
export declare const enum StudyPlotDisplayTarget {
  None = 0,
  Pane = 1,
  DataWindow = 2,
  PriceScale = 4,
  StatusLine = 8,
  All = 15,
}
export declare const enum StudyPlotType {
  Line = "line",
  Colorer = "colorer",
  BarColorer = "bar_colorer",
  BgColorer = "bg_colorer",
  TextColorer = "text_colorer",
  OhlcColorer = "ohlc_colorer",
  CandleWickColorer = "wick_colorer",
  CandleBorderColorer = "border_colorer",
  UpColorer = "up_colorer",
  DownColorer = "down_colorer",
  Shapes = "shapes",
  Chars = "chars",
  Arrows = "arrows",
  Data = "data",
  DataOffset = "dataoffset",
  OhlcOpen = "ohlc_open",
  OhlcHigh = "ohlc_high",
  OhlcLow = "ohlc_low",
  OhlcClose = "ohlc_close",
}
export declare const enum StudyTargetPriceScale {
  Right = 0,
  Left = 1,
  NoScale = 2,
}
export declare const enum TimeFrameType {
  PeriodBack = "period-back",
  TimeRange = "time-range",
}
export declare const enum TimeHoursFormat {
  TwentyFourHours = "24-hours",
  TwelveHours = "12-hours",
}
export declare const enum VisibilityType {
  AlwaysOn = "alwaysOn",
  VisibleOnMouseOver = "visibleOnMouseOver",
  AlwaysOff = "alwaysOff",
}
export declare const widget: ChartingLibraryWidgetConstructor;
/**
 * Returns a build version string. For example "CL v23.012 (internal id e0d59dc3 @ 2022-08-23T06:07:00.808Z)".
 *
 * @returns The build version string.
 */
export declare function version(): string;
/**
 * This is the generic type useful for declaring a nominal type,
 * which does not structurally matches with the base type and
 * the other types declared over the same base type
 *
 * Usage:
 * @example
 * type Index = Nominal<number, 'Index'>;
 * // let i: Index = 42; // this fails to compile
 * let i: Index = 42 as Index; // OK
 * @example
 * type TagName = Nominal<string, 'TagName'>;
 */
export declare type Nominal<T, Name extends string> = T & {
  [Symbol.species]: Name;
};
/**
 * Override properties for the Abcd drawing tool.
 */
export interface AbcdLineToolOverrides {
  /** Default value: `false` */
  "linetoolabcd.bold": boolean;
  /** Default value: `#089981` */
  "linetoolabcd.color": string;
  /** Default value: `12` */
  "linetoolabcd.fontsize": number;
  /** Default value: `false` */
  "linetoolabcd.italic": boolean;
  /** Default value: `2` */
  "linetoolabcd.linewidth": number;
  /** Default value: `#ffffff` */
  "linetoolabcd.textcolor": string;
}
/**
 * Overrides for the 'Accelerator Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AcceleratorOscillatorIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `histogram` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#000080` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Defines a whitelist / blacklist of studies or drawing tools.
 */
export interface AccessList {
  /**
   * List type.
   * Supported values are:
   * `black` (all listed items should be disabled),
   * `white` (only the listed items should be enabled).
   */
  type: "black" | "white";
  /** Array of items which should be considered part of the access list */
  tools: AccessListItem[];
}
export interface AccessListItem {
  /**
   * Name of the study / drawing tool.
   * Use the same name as seen in the UI for drawings,
   * and use the same names as in the pop-ups for indicators.
   */
  name: string;
  /**
   * Whether this study should be visible but look as if it's disabled.
   * If the study is grayed out and user clicks it, then the `onGrayedObjectClicked` function is called.
   */
  grayed?: boolean;
}
/** Column properties for the [Account Manager](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md) pages. */
export interface AccountManagerColumnBase<
  TFormatterName extends StandardFormatterName | FormatterName
> {
  /** Column title. It will be displayed in the table's header row. */
  label: string;
  /**
   * Horizontal alignment of the cell value. The default value is `left`.
   *
   * | Alignment    |   Description  |
   * |--------------|----------------|
   * | left         | It aligns the cell value to the left. |
   * | right        | It aligns the cell value to the right. |
   */
  alignment?: CellAlignment;
  /** Unique column identifier. */
  id: string;
  /**
   * Defines a formatter to be applied for data formatting, which can either belong to the `StandardFormatterName` or `FormatterName` type.
   * If no specific formatter is set, the value is displayed as is.
   *
   * Default formatter names are enumerated in {@link StandardFormatterName}.
   * Refer to the [Default formatters](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/value-formatters.md#default-formatters) section to see the full list of formatters.
   *
   * You can also create custom formatters using the {@link AccountManagerInfo.customFormatters} property.
   */
  formatter?: TFormatterName;
  /**
   * The `dataFields` array contains fields from an order/position data object.
   * `dataFields` is used to generate the values displayed in a column.
   * The displayed value in the column updates only when the corresponding values in the data object change.
   *
   * If no {@link formatter} is specified, the displayed values will be space-separated in the column.
   * When a `formatter` is defined, it processes only the specified values.
   * If an empty array is assigned to `dataFields`, the `formatter` will receive the entire data object.
   *
   * **Example**
   *
   * - For a column with `dataFields` set as `['avgPrice', 'qty']`, the displayed value updates only when the `avgPrice` or `qty` values in the data object change.
   * - For a column with an empty `dataFields` array, the displayed value updates if any values in the data object change.
   */
  dataFields: TFormatterName extends StandardFormatterName
    ? StandardFormattersDependenciesMapping[TFormatterName]
    : string[];
  /**
   * Data object key that is used for data sorting.
   *
   * If `sortProp` is not provided, the first element of the `dataFields` array will be used.
   * If the `dataFields` array is empty, the column sorting will be unavailable.
   */
  sortProp?: string;
  /** When set to `true` will prevent column sorting. */
  notSortable?: boolean;
  /** Tooltip string for the column. */
  help?: string;
  /**
   * `highlightDiff` can be set with [`StandardFormatterName.FormatPrice`](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/value-formatters.md#formatPrice)
   * and [`StandardFormatterName.FormatPriceForexSup`](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/value-formatters.md#formatPriceForexSup) formatters to highlight the changes of the field.
   * If `highlightDiff is `true`, the custom formatters will also get previous values.
   */
  highlightDiff?: boolean;
  /** Setting `notHideable` to `true` prevents the column from being hidden. */
  notHideable?: boolean;
  /** Setting `hideByDefault` to `true` hides the column by default. */
  hideByDefault?: boolean;
  /** Key of the row object that is used to get the tooltip to display when hovering over a cell.
   * The tooltip property refers to an object whose keys are property names and
   * values are the corresponding tooltips.
   */
  tooltipProperty?: string;
  /** If set to `true`, the first character of every word in the sentence in the column
   * will be capitalized. The default value is `true`.
   */
  isCapitalize?: boolean;
  /** Setting `showZeroValues` to `true` hides any zero values. The default value is `true`. */
  showZeroValues?: boolean;
}
/**
 * The information object that is used to build the [Account Manager](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md).
 */
export interface AccountManagerInfo {
  /** Name of the broker */
  accountTitle: string;
  /**
   * Custom fields that are always displayed at the top-right corner of the Account Manager.
   * Refer to the [Account Summary row](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md#account-summary-row) section for more information.
   */
  summary: AccountManagerSummaryField[];
  /**
   * An optional array for defining [custom formatters](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/value-formatters.md#custom-formatters).
   * Each formatter description is an object with the following fields:
   *
   * - `name` ({@link FormatterName}): Unique formatter name.
   *
   * - `formatText` ({@link TableFormatTextFunction}):
   * Function that is used for formatting a cell value to a string.
   * The `formatText` field is required because it is used to generate exported data.
   * You can return an empty string if you do not need this function.
   *
   * - `formatElement` ({@link CustomTableFormatElementFunction} | `undefined`):
   * Optional function that is used for formatting a cell value to a string or an HTML element.
   *
   * If the `formatElement` function is provided, it only handles the formatting of displayed values.
   * Otherwise the `formatText` function is used.
   * For optimal performance, it is recommended to only use `formatText` if you intend to display only string values.
   *
   * **Example**
   * ```ts
   * {
   *     name: 'closeButton' as FormatterName, // Typecast to FormatterName. Use constant in real code
   *     formatText: () => '', // Returns an empty string because we don't need to display this in the exported data
   *     formatElement: ({ values: [id] }: TableFormatterInputs<[id: string]>) => {
   *         const button = document.createElement('button');
   *
   *         button.innerText = 'Close';
   *
   *         button.addEventListener('click', () => {
   *             event.stopPropagation();
   *
   *             closePosition(id);
   *         });
   *
   *         return button;
   *     },
   * }
   * ```
   */
  customFormatters?: CustomTableElementFormatter[];
  /** An array of data objects that create columns for the [Orders](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md#orders-and-positions) page.
   * You can display any field of an {@link Order}
   * or add your own fields to an order object and display them.
   */
  orderColumns: OrderTableColumn[];
  /** Optional sorting of the orders table. */
  orderColumnsSorting?: SortingParameters;
  /**
   * An array of data objects that create columns for the [History](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md#history) page where all orders from previous sessions are shown.
   * Note that this page is only shown
   * if you set the {@link BrokerConfigFlags.supportOrdersHistory} to `true`
   * and implement the {@link IBrokerTerminal.ordersHistory} method.
   */
  historyColumns?: AccountManagerColumn[];
  /** Optional sorting of the table on the [History](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md#history) page. */
  historyColumnsSorting?: SortingParameters;
  /**
   * An array of data objects that create columns for the [Positions](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md#orders-and-positions) page.
   * You can display any field of a {@link Position}
   * or add your own fields to a position object and display them.
   */
  positionColumns?: AccountManagerColumn[];
  /**
   * You can display any field of an {@link IndividualPosition}
   * or add your own fields to an individualPosition object and display them.
   */
  individualPositionColumns?: AccountManagerColumn[];
  /** Adds [custom pages](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md#custom-pages) to the Account Manager. Each page is a set of tables. */
  pages: AccountManagerPage[];
  /** Optional list of statuses to be used in the orders filter. Default list is used if it hasn't been set. */
  possibleOrderStatuses?: OrderStatus[];
  /** Margin used */
  marginUsed?: IWatchedValue<number>;
  /**
   * Optional function to create a custom context menu.
   * @param contextMenuEvent - MouseEvent or TouchEvent object passed by a browser
   * @param activePageActions - array of `ActionMetaInfo` items for the current page
   * @returns `Promise` that is resolved with an array of `ActionMetaInfo`
   */
  contextMenuActions?(
    contextMenuEvent: MouseEvent | TouchEvent,
    activePageActions: ActionMetaInfo[]
  ): Promise<ActionMetaInfo[]>;
}
/** A description of an additional Account Manager tab. */
export interface AccountManagerPage {
  /** Unique identifier of a page */
  id: string;
  /** Page title. It is the tab name. */
  title: string;
  /** It is possible to display one or more tables in this tab. */
  tables: AccountManagerTable[];
}
/** Custom field that will always be shown above the pages of the Account manager */
export interface AccountManagerSummaryField {
  /** Text to display for the summary field */
  text: string;
  /** A WatchedValue object that can be used to read the state of field. */
  wValue: IWatchedValueReadonly<any>;
  /**
   * Name of the formatter to be used for data formatting. If `formatter` is not
   * set the value is displayed as is. Formatter can be a default or a custom one.
   */
  formatter?: StandardFormatterName;
  /** Optional parameter which can be set to display the field by default. */
  isDefault?: boolean;
}
/**
 * Account Summary table meta-info
 * **NOTE**: make sure that you have a unique string `id` field in each row to identify it.
 */
export interface AccountManagerTable {
  /** Unique identifier of a table. */
  id: string;
  /** Optional title of a table. */
  title?: string;
  /** Table columns */
  columns: AccountManagerColumn[];
  /** Optional sorting of the table. If set, then the table will be sorted by these parameters, if the user has not enabled sorting by a specific column. */
  initialSorting?: SortingParameters;
  /** This delegate is used to watch the data changes and update the table.
   * Pass new account manager data row by row to the `fire` method of the delegate.
   */
  changeDelegate: ISubscription<(data: {}) => void>;
  /** Option flags for the table. */
  flags?: AccountManagerTableFlags;
  /**
   * This function is used to request table data. It should return Promise (or Deferred) and resolve it with an array of data rows.
   *
   * Each row is an object. Keys of this object are column names with the corresponding values.
   *
   * There is a predefined field `isTotalRow` which can be used to mark a row that should be at the bottom of the table.
   * @param paginationLastId - Last pagination id
   */
  getData(paginationLastId?: string | number): Promise<{}[]>;
}
/** Boolean options for the account manager table */
export interface AccountManagerTableFlags {
  /** Does the table support pagination */
  supportPagination?: boolean;
}
export interface AccountMetainfo {
  /**
   * Account ID
   */
  id: AccountId;
  /**
   * Account Name
   */
  name: string;
  /**
   * Currency
   */
  currency?: string;
  /**
   * Currency Sign (Prefix)
   */
  currencySign?: string;
}
/**
 * Overrides for the 'Accumulation/Distribution' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AccumulationDistributionIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Accumulative Swing Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AccumulativeSwingIndexIndicatorOverrides {
  /** Default value: `15` */
  "asi.display": number;
  /** Default value: `0` */
  "asi.linestyle": number;
  /** Default value: `1` */
  "asi.linewidth": number;
  /** Default value: `line` */
  "asi.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "asi.trackprice": boolean;
  /** Default value: `0` */
  "asi.transparency": number;
  /** Default value: `#2196F3` */
  "asi.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface ActionDescription {
  /** Displayed text for action */
  text?: "-" | string;
  /** Is a menu separator */
  separator?: boolean;
  /** Keyboard shortcut for the action. Displayed as hint text. */
  shortcut?: string;
  /** Tooltip text to be displayed when hovering over the action item. */
  tooltip?: string;
  /** Value of the checkbox. */
  checked?: boolean;
  /** Getter to retrieve the current checkbox value. */
  checkedStateSource?: () => boolean;
  /** Whether menu action represents a checkbox state. Set it to true if you need a checkbox. */
  checkable?: boolean;
  /** Whether the action is enabled. Set to false to disabled the action. */
  enabled?: boolean;
  /** External link (url) which will be opened upon clicking the menu item. */
  externalLink?: boolean;
  /**
   * A string of SVG icon for an action. A string should be a string representation of SVG (not a path/URL).
   */
  icon?: string;
}
/** Menu action which provides a callback function to be executed. Action is executed when user clicks the item. */
export interface ActionDescriptionWithCallback extends ActionDescription {
  /** Action to be executed when user clicks the menu item. */
  action: (a?: ActionDescription) => void;
}
export interface ActionOptions
  extends Partial<OmitActionId<ActionState>>,
    Pick<ActionState, "actionId"> {
  /**
   * A function which will be called when an action should be executed (e.g. when a user clicks on the item).
   */
  onExecute?: OnActionExecuteHandler;
}
export interface ActionState {
  /**
   * Human-readable, non-unique ID of an action item. Similar to {@link label}, but language-agnostic.
   */
  actionId: ActionId;
  /** Is active */
  active: boolean;
  /**
   * Text title of an action
   */
  label: string;
  /**
   * Text title of an action consisting of several styled sections. If not defined then {@link label} is used instead.
   */
  styledLabel?: StyledText[];
  /**
   * Whether an action is disabled or not (disabled actions are usually cannot be executed and displayed grayed out)
   */
  disabled: boolean;
  /**
   * Sub-items of an action
   */
  subItems: IActionVariant[];
  /**
   * Whether an action should have a checkbox next to it.
   */
  checkable: boolean;
  /**
   * If {@link checkable} is `true` then whether current state is checked or not.
   */
  checked: boolean;
  /**
   * A hint of an action.
   */
  hint?: string;
  /**
   * A string of SVG icon for an action. A string should be a string representation of SVG (not a path/URL).
   */
  icon?: string;
  /**
   * If {@link checkable} is `true` then an icon to be used when {@link checked} is `true`.
   */
  iconChecked?: string;
  /**
   * Whether an action is still in loading state (it means that it's data is not ready yet).
   * Usually in this case a spinner/loader will be displayed instead of this action.
   */
  loading: boolean;
  /**
   * A string that represents a shortcut hint for this action.
   */
  shortcutHint?: string;
}
export interface ActionsFactory {
  /**
   * Creates an action with provided options.
   */
  createAction: (options: ActionOptions) => IUpdatableAction;
  /**
   * Creates an action that will wait for a promise to get its options.
   * In terms of GUI until a promise is resolved the loader/spinner will be displayed.
   */
  createAsyncAction: (loader: () => Promise<ActionOptions>) => IUpdatableAction;
  /**
   * Creates a separator item.
   */
  createSeparator: () => ISeparator;
}
/**
 * custom symbol info fields to be shown in the Symbol Info dialog
 */
export interface AdditionalSymbolInfoField {
  /** the name of the new symbol info */
  title: string;
  /** used to look up a property from the symbol info returned from the chart's datafeed */
  propertyName: string;
}
/**
 * Overrides for the 'Advance/Decline' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AdvanceDeclineIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Anchored VWAP' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AnchoredVWAPIndicatorOverrides {
  /** Default value: `15` */
  "vwap.display": number;
  /** Default value: `#1e88e5` */
  "vwap.color": string;
  /** Default value: `0` */
  "vwap.linestyle": number;
  /** Default value: `1` */
  "vwap.linewidth": number;
  /** Default value: `line` */
  "vwap.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "vwap.trackprice": boolean;
  /** Default value: `0` */
  "vwap.transparency": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Anchoredvwap drawing tool.
 */
export interface AnchoredvwapLineToolOverrides {
  /** Default value: `hlc3` */
  "linetoolanchoredvwap.inputs.source": string;
  /** Default value: `0` */
  "linetoolanchoredvwap.inputs.start_time": number;
  /** Default value: `default` */
  "linetoolanchoredvwap.precision": string;
  /** Default value: `#1e88e5` */
  "linetoolanchoredvwap.styles.VWAP.color": string;
  /** Default value: `15` */
  "linetoolanchoredvwap.styles.VWAP.display": number;
  /** Default value: `0` */
  "linetoolanchoredvwap.styles.VWAP.linestyle": number;
  /** Default value: `1` */
  "linetoolanchoredvwap.styles.VWAP.linewidth": number;
  /** Default value: `0` */
  "linetoolanchoredvwap.styles.VWAP.plottype": number;
  /** Default value: `false` */
  "linetoolanchoredvwap.styles.VWAP.trackPrice": boolean;
  /** Default value: `0` */
  "linetoolanchoredvwap.styles.VWAP.transparency": number;
}
/**
 * Override properties for the Arc drawing tool.
 */
export interface ArcLineToolOverrides {
  /** Default value: `rgba(233, 30, 99, 0.2)` */
  "linetoolarc.backgroundColor": string;
  /** Default value: `#e91e63` */
  "linetoolarc.color": string;
  /** Default value: `true` */
  "linetoolarc.fillBackground": boolean;
  /** Default value: `2` */
  "linetoolarc.linewidth": number;
  /** Default value: `80` */
  "linetoolarc.transparency": number;
}
export interface AreaStylePreferences {
  /** Top color */
  color1: string;
  /** Bottom color */
  color2: string;
  /** Line Color */
  linecolor: string;
  /** Line Style {@link LineStyle} */
  linestyle: number;
  /** Line width */
  linewidth: number;
  /**
   * Transparency. Range [0..100]
   * `0` - fully opaque,
   * `100` - fully transparent.
   *
   * **Note**: Rather use `rgba` color string for setting transparency.
   */
  transparency: number;
}
/**
 * Overrides for the 'Arnaud Legoux Moving Average' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ArnaudLegouxMovingAverageIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Aroon' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AroonIndicatorOverrides {
  /** Default value: `15` */
  "upper.display": number;
  /** Default value: `0` */
  "upper.linestyle": number;
  /** Default value: `1` */
  "upper.linewidth": number;
  /** Default value: `line` */
  "upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "upper.trackprice": boolean;
  /** Default value: `0` */
  "upper.transparency": number;
  /** Default value: `#FB8C00` */
  "upper.color": string;
  /** Default value: `15` */
  "lower.display": number;
  /** Default value: `0` */
  "lower.linestyle": number;
  /** Default value: `1` */
  "lower.linewidth": number;
  /** Default value: `line` */
  "lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lower.trackprice": boolean;
  /** Default value: `0` */
  "lower.transparency": number;
  /** Default value: `#2196F3` */
  "lower.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Arrow drawing tool.
 */
export interface ArrowLineToolOverrides {
  /** Default value: `false` */
  "linetoolarrow.alwaysShowStats": boolean;
  /** Default value: `false` */
  "linetoolarrow.bold": boolean;
  /** Default value: `false` */
  "linetoolarrow.extendLeft": boolean;
  /** Default value: `false` */
  "linetoolarrow.extendRight": boolean;
  /** Default value: `14` */
  "linetoolarrow.fontsize": number;
  /** Default value: `center` */
  "linetoolarrow.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetoolarrow.italic": boolean;
  /** Default value: `0` */
  "linetoolarrow.leftEnd": number;
  /** Default value: `#2962FF` */
  "linetoolarrow.linecolor": string;
  /** Default value: `0` */
  "linetoolarrow.linestyle": number;
  /** Default value: `2` */
  "linetoolarrow.linewidth": number;
  /** Default value: `1` */
  "linetoolarrow.rightEnd": number;
  /** Default value: `false` */
  "linetoolarrow.showAngle": boolean;
  /** Default value: `false` */
  "linetoolarrow.showBarsRange": boolean;
  /** Default value: `false` */
  "linetoolarrow.showDateTimeRange": boolean;
  /** Default value: `false` */
  "linetoolarrow.showDistance": boolean;
  /** Default value: `false` */
  "linetoolarrow.showLabel": boolean;
  /** Default value: `false` */
  "linetoolarrow.showMiddlePoint": boolean;
  /** Default value: `false` */
  "linetoolarrow.showPercentPriceRange": boolean;
  /** Default value: `false` */
  "linetoolarrow.showPipsPriceRange": boolean;
  /** Default value: `false` */
  "linetoolarrow.showPriceLabels": boolean;
  /** Default value: `false` */
  "linetoolarrow.showPriceRange": boolean;
  /** Default value: `2` */
  "linetoolarrow.statsPosition": number;
  /** Default value: `#2962FF` */
  "linetoolarrow.textcolor": string;
  /** Default value: `bottom` */
  "linetoolarrow.vertLabelsAlign": string;
}
/**
 * Override properties for the Arrowmarkdown drawing tool.
 */
export interface ArrowmarkdownLineToolOverrides {
  /** Default value: `#CC2F3C` */
  "linetoolarrowmarkdown.arrowColor": string;
  /** Default value: `false` */
  "linetoolarrowmarkdown.bold": boolean;
  /** Default value: `#CC2F3C` */
  "linetoolarrowmarkdown.color": string;
  /** Default value: `14` */
  "linetoolarrowmarkdown.fontsize": number;
  /** Default value: `false` */
  "linetoolarrowmarkdown.italic": boolean;
  /** Default value: `true` */
  "linetoolarrowmarkdown.showLabel": boolean;
}
/**
 * Override properties for the Arrowmarker drawing tool.
 */
export interface ArrowmarkerLineToolOverrides {
  /** Default value: `#1E53E5` */
  "linetoolarrowmarker.backgroundColor": string;
  /** Default value: `true` */
  "linetoolarrowmarker.bold": boolean;
  /** Default value: `16` */
  "linetoolarrowmarker.fontsize": number;
  /** Default value: `false` */
  "linetoolarrowmarker.italic": boolean;
  /** Default value: `true` */
  "linetoolarrowmarker.showLabel": boolean;
  /** Default value: `#1E53E5` */
  "linetoolarrowmarker.textColor": string;
}
/**
 * Override properties for the Arrowmarkleft drawing tool.
 */
export interface ArrowmarkleftLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetoolarrowmarkleft.arrowColor": string;
  /** Default value: `false` */
  "linetoolarrowmarkleft.bold": boolean;
  /** Default value: `#2962FF` */
  "linetoolarrowmarkleft.color": string;
  /** Default value: `14` */
  "linetoolarrowmarkleft.fontsize": number;
  /** Default value: `false` */
  "linetoolarrowmarkleft.italic": boolean;
  /** Default value: `true` */
  "linetoolarrowmarkleft.showLabel": boolean;
}
/**
 * Override properties for the Arrowmarkright drawing tool.
 */
export interface ArrowmarkrightLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetoolarrowmarkright.arrowColor": string;
  /** Default value: `false` */
  "linetoolarrowmarkright.bold": boolean;
  /** Default value: `#2962FF` */
  "linetoolarrowmarkright.color": string;
  /** Default value: `14` */
  "linetoolarrowmarkright.fontsize": number;
  /** Default value: `false` */
  "linetoolarrowmarkright.italic": boolean;
  /** Default value: `true` */
  "linetoolarrowmarkright.showLabel": boolean;
}
/**
 * Override properties for the Arrowmarkup drawing tool.
 */
export interface ArrowmarkupLineToolOverrides {
  /** Default value: `#089981` */
  "linetoolarrowmarkup.arrowColor": string;
  /** Default value: `false` */
  "linetoolarrowmarkup.bold": boolean;
  /** Default value: `#089981` */
  "linetoolarrowmarkup.color": string;
  /** Default value: `14` */
  "linetoolarrowmarkup.fontsize": number;
  /** Default value: `false` */
  "linetoolarrowmarkup.italic": boolean;
  /** Default value: `true` */
  "linetoolarrowmarkup.showLabel": boolean;
}
export interface AvailableZOrderOperations {
  /** 'Bring Forward' is possible */
  bringForwardEnabled: boolean;
  /** 'Bring to Front' is possible */
  bringToFrontEnabled: boolean;
  /** 'Send Backward' is possible */
  sendBackwardEnabled: boolean;
  /** 'Send to Back' is possible */
  sendToBackEnabled: boolean;
}
/**
 * Overrides for the 'Average Directional Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AverageDirectionalIndexIndicatorOverrides {
  /** Default value: `15` */
  "adx.display": number;
  /** Default value: `0` */
  "adx.linestyle": number;
  /** Default value: `1` */
  "adx.linewidth": number;
  /** Default value: `line` */
  "adx.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "adx.trackprice": boolean;
  /** Default value: `0` */
  "adx.transparency": number;
  /** Default value: `#FF5252` */
  "adx.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Average Price' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AveragePriceIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Average True Range' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AverageTrueRangeIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#801922` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Awesome Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface AwesomeOscillatorIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `histogram` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#000080` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Balance of Power' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface BalanceofPowerIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF5252` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Balloon drawing tool.
 */
export interface BalloonLineToolOverrides {
  /** Default value: `rgba(156, 39, 176, 0.7)` */
  "linetoolballoon.backgroundColor": string;
  /** Default value: `rgba(156, 39, 176, 0)` */
  "linetoolballoon.borderColor": string;
  /** Default value: `#ffffff` */
  "linetoolballoon.color": string;
  /** Default value: `14` */
  "linetoolballoon.fontsize": number;
  /** Default value: `30` */
  "linetoolballoon.transparency": number;
}
/**
 * Bar data point
 */
export interface Bar {
  /** Bar time.
   * Amount of **milliseconds** since Unix epoch start in **UTC** timezone.
   * `time` for daily, weekly, and monthly bars is expected to be a trading day (not session start day) at 00:00 UTC.
   * The library adjusts time according to `session` from {@link LibrarySymbolInfo}.
   */
  time: number;
  /** Opening price */
  open: number;
  /** High price */
  high: number;
  /** Low price */
  low: number;
  /** Closing price */
  close: number;
  /** Trading Volume */
  volume?: number;
}
export interface BarStylePreferences {
  /** Up bar color */
  upColor: string;
  /** Down bar color */
  downColor: string;
  /** Bar color determined by previous close value */
  barColorsOnPrevClose: boolean;
  /** Whether to draw opening value for bar */
  dontDrawOpen: boolean;
  /** Draw thin bars. Default - `true` */
  thinBars: boolean;
}
/**
 * Override properties for the Barspattern drawing tool.
 */
export interface BarspatternLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetoolbarspattern.color": string;
  /** Default value: `false` */
  "linetoolbarspattern.flipped": boolean;
  /** Default value: `false` */
  "linetoolbarspattern.mirrored": boolean;
  /** Default value: `0` */
  "linetoolbarspattern.mode": number;
}
export interface BaseInputFieldValidatorResult {
  /** Is the base input value valid */
  valid: boolean;
}
export interface BaselineStylePreferences {
  /** Top fill color of positive area */
  topFillColor1: string;
  /** Bottom fill color of positive area */
  topFillColor2: string;
  /** Top fill color of negative area */
  bottomFillColor1: string;
  /** Bottom fill color of negative area */
  bottomFillColor2: string;
  /** Positive area line color */
  topLineColor: string;
  /** Negative area line color */
  bottomLineColor: string;
  /** Baseline line color */
  baselineColor: string;
  /** Positive area line width */
  topLineWidth: number;
  /** Negative area line width */
  bottomLineWidth: number;
  /**
   * Transparency. Range [0..100]
   * `0` - fully opaque,
   * `100` - fully transparent.
   *
   * **Note**: Rather use `rgba` color string for setting transparency.
   */
  transparency: number;
  /** Baseline level percentage */
  baseLevelPercentage: number;
}
/**
 * Override properties for the Beziercubic drawing tool.
 */
export interface BeziercubicLineToolOverrides {
  /** Default value: `rgba(103, 58, 183, 0.2)` */
  "linetoolbeziercubic.backgroundColor": string;
  /** Default value: `false` */
  "linetoolbeziercubic.extendLeft": boolean;
  /** Default value: `false` */
  "linetoolbeziercubic.extendRight": boolean;
  /** Default value: `false` */
  "linetoolbeziercubic.fillBackground": boolean;
  /** Default value: `0` */
  "linetoolbeziercubic.leftEnd": number;
  /** Default value: `#673ab7` */
  "linetoolbeziercubic.linecolor": string;
  /** Default value: `0` */
  "linetoolbeziercubic.linestyle": number;
  /** Default value: `2` */
  "linetoolbeziercubic.linewidth": number;
  /** Default value: `0` */
  "linetoolbeziercubic.rightEnd": number;
  /** Default value: `80` */
  "linetoolbeziercubic.transparency": number;
}
/**
 * Override properties for the Bezierquadro drawing tool.
 */
export interface BezierquadroLineToolOverrides {
  /** Default value: `rgba(41, 98, 255, 0.2)` */
  "linetoolbezierquadro.backgroundColor": string;
  /** Default value: `false` */
  "linetoolbezierquadro.extendLeft": boolean;
  /** Default value: `false` */
  "linetoolbezierquadro.extendRight": boolean;
  /** Default value: `false` */
  "linetoolbezierquadro.fillBackground": boolean;
  /** Default value: `0` */
  "linetoolbezierquadro.leftEnd": number;
  /** Default value: `#2962FF` */
  "linetoolbezierquadro.linecolor": string;
  /** Default value: `0` */
  "linetoolbezierquadro.linestyle": number;
  /** Default value: `2` */
  "linetoolbezierquadro.linewidth": number;
  /** Default value: `0` */
  "linetoolbezierquadro.rightEnd": number;
  /** Default value: `50` */
  "linetoolbezierquadro.transparency": number;
}
/**
 * Overrides for the 'Bollinger Bands %B' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface BollingerBandsBIndicatorOverrides {
  /** Default value: `#26A69A` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `1` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `0` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#22AB94` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Bollinger Bands' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface BollingerBandsIndicatorOverrides {
  /** Default value: `#2196F3` */
  "plots background.color": string;
  /** Default value: `95` */
  "plots background.transparency": number;
  /** Default value: `true` */
  "plots background.visible": boolean;
  /** Default value: `15` */
  "median.display": number;
  /** Default value: `0` */
  "median.linestyle": number;
  /** Default value: `1` */
  "median.linewidth": number;
  /** Default value: `line` */
  "median.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "median.trackprice": boolean;
  /** Default value: `0` */
  "median.transparency": number;
  /** Default value: `#FF6D00` */
  "median.color": string;
  /** Default value: `15` */
  "upper.display": number;
  /** Default value: `0` */
  "upper.linestyle": number;
  /** Default value: `1` */
  "upper.linewidth": number;
  /** Default value: `line` */
  "upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "upper.trackprice": boolean;
  /** Default value: `0` */
  "upper.transparency": number;
  /** Default value: `#2196F3` */
  "upper.color": string;
  /** Default value: `15` */
  "lower.display": number;
  /** Default value: `0` */
  "lower.linestyle": number;
  /** Default value: `1` */
  "lower.linewidth": number;
  /** Default value: `line` */
  "lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lower.trackprice": boolean;
  /** Default value: `0` */
  "lower.transparency": number;
  /** Default value: `#2196F3` */
  "lower.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Bollinger Bands Width' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface BollingerBandsWidthIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF6D00` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * An object that contains information about a bracket order.
 */
export interface BracketOrder extends BracketOrderBase, CustomFields {}
export interface BracketOrderBase extends PlacedOrderBase {
  /** If an order is a bracket, it should contain an ID of a parent order/position. */
  parentId: string;
  /** Type of the bracket's parent. */
  parentType: ParentType;
}
export interface Brackets {
  /** Stop loss */
  stopLoss?: number;
  /** Take Profit */
  takeProfit?: number;
  /** Trailing Stop Pips */
  trailingStopPips?: number;
}
export interface BrokerConfigFlags {
  /**
   * Changes _Amount_ to _Quantity_ in Order Ticket.
   * @default false
   */
  showQuantityInsteadOfAmount?: boolean;
  /**
   * Enables order brackets: take-profit and stop-loss.
   * @default false
   */
  supportOrderBrackets?: boolean;
  /**
   * Enables trailing stop orders.
   * If you set this flag to `true`, the library displays trailing stop orders and a user can place a trailing stop order using the Order Ticket.
   * @default false
   */
  supportTrailingStop?: boolean;
  /**
   * Enables positions.
   * This flag requires the {@link IBrokerTerminal.positions} method to be implemented.
   * If you set `supportPositions` to `false`, the _Positions_ tab in the [Account Manager](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md) will be hidden.
   * @default true
   */
  supportPositions?: boolean;
  /**
   * Enables position brackets: take-profit and stop-loss orders.
   * If you set `supportPositionBrackets` to `true`, the library displays an _Edit_ button for positions and _Edit position..._ in the position's context menu.
   * This flag requires the {@link IBrokerTerminal.editPositionBrackets} method to be implemented.
   * @default false
   */
  supportPositionBrackets?: boolean;
  /**
   * Enables brackets for individual positions: take-profit and stop-loss orders.
   * If you set this flag to `true`, the library displays an _Edit_ button for individual positions and _Edit position..._ in the individual position's context menu.
   * This flag requires the {@link IBrokerTerminal.editIndividualPositionBrackets} method to be implemented.
   * @default false
   */
  supportIndividualPositionBrackets?: boolean;
  /**
   * Enables individual and net positions.
   * If you set this flag to `true`, the [Account Manager](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md) will have two tabs: _Individual Positions_ and _Net Positions_.
   * This flag requires the {@link IBrokerTerminal.individualPositions} method to be implemented.
   *
   * @default false
   */
  supportPositionNetting?: boolean;
  /**
   * Enables position closing.
   * This flag requires the {@link IBrokerTerminal.closePosition} method to be implemented.
   * If `supportClosePosition` is set to `true`, the library displays a close button and calls the `closePosition` method.
   * If `supportClosePosition` is set to `false`, the library displays a close button but calls the {@link IBrokerTerminal.placeOrder} method with the `isClose` property set to `true`.
   * @default false
   */
  supportClosePosition?: boolean;
  /**
   * Enables individual position closing.
   * This flag requires the {@link IBrokerTerminal.closeIndividualPosition} method to be implemented.
   * @default false
   */
  supportCloseIndividualPosition?: boolean;
  /**
   * Enables order price editing.
   * If you set this flag to `false`, the price control in the _Order Ticket_ will be disabled when users modify orders.
   * @default true
   */
  supportModifyOrderPrice?: boolean;
  /**
   * Enables order quantity editing.
   * If you set this flag to `false`, the quantity control in the _Order Ticket_ will be disabled when users modify orders.
   * @default true
   */
  supportEditAmount?: boolean;
  /**
   * Enables order brackets editing.
   * If you set this flag to `false`, the bracket's control in the Order Ticket will be disabled,
   * and the _Modify_ button will be hidden from the chart and in the [Account Manager](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md).
   * @default true
   */
  supportModifyBrackets?: boolean;
  /**
   * Enables Level 2 data for the Depth of Market (DOM) widget.
   * This flag requires the [`subscribeDepth`](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Datafeed-API#subscribedepth) and [`unsubscribeDepth`](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Datafeed-API#unsubscribedepth) methods to be implemented.
   * Note that you should also enable the {@link BrokerConfigFlags.supportDOM} flag to display the DOM widget in the UI.
   * @default false
   */
  supportLevel2Data?: boolean;
  /**
   * Enables the Depth of Market (DOM) widget.
   * Note that you should also enable the {@link BrokerConfigFlags.supportLevel2Data} flag and implement the [`subscribeDepth`](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Datafeed-API#subscribedepth) and [`unsubscribeDepth`](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Datafeed-API#unsubscribedepth) methods to provide Level 2 data for the DOM widget.
   * @default false
   */
  supportDOM?: boolean;
  /**
   * Enables multiple positions for one instrument at the same time.
   * Supporting multiple positions prevents creating the default implementation for a reversing position.
   * @default false
   */
  supportMultiposition?: boolean;
  /**
   * Allows you to use your own Profit & Loss (P&L) values for positions.
   * If `supportPLUpdate` is set to `true`, you should call the {@link IBrokerConnectionAdapterHost.plUpdate} method as soon as P&L values are changed.
   * If `supportPLUpdate` is set to `false`, the library automatically calculates P&L values as the difference between the current trade and the average position price.
   * @default true
   */
  supportPLUpdate?: boolean;
  /**
   * Enables position reversing.
   * If `supportReversePosition` is set to `false`, the _Reverse Position_ button will be hidden from the UI.
   * @default false
   */
  supportReversePosition?: boolean;
  /**
   * Enables native position reversing.
   * This flag requires the {@link IBrokerTerminal.reversePosition} method to be implemented.
   * If `supportNativeReversePosition` is set to `false`, the library expects you to place a reversing order via the {@link IBrokerTerminal.placeOrder} method.
   * @default false
   */
  supportNativeReversePosition?: boolean;
  /**
   * Enables market orders type in the Order Ticket.
   * @default true
   */
  supportMarketOrders?: boolean;
  /**
   * Enables limit orders type in the Order Ticket.
   * @default true
   */
  supportLimitOrders?: boolean;
  /**
   * Enables stop orders type in the Order Ticket.
   * @default true
   */
  supportStopOrders?: boolean;
  /**
   * Enables stop-limit orders type in the Order Ticket.
   * @default false
   */
  supportStopLimitOrders?: boolean;
  /**
   * Enables demo live switcher.
   * @default true
   */
  supportDemoLiveSwitcher?: boolean;
  /**
   * Enables brackets for market orders.
   * @default true
   */
  supportMarketBrackets?: boolean;
  /**
   * Enables symbol searching.
   * @default false
   */
  supportSymbolSearch?: boolean;
  /**
   * Allows modifying existing [order duration](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/order-ticket.md#set-order-duration).
   * @default false
   */
  supportModifyDuration?: boolean;
  /**
   * Allows modifying trailing stop orders.
   * @default true
   */
  supportModifyTrailingStop?: boolean;
  /**
   * Allows margin.
   * If `supportMargin` is set to `true`, you should call {@link IBrokerConnectionAdapterHost.marginAvailableUpdate} when the Trading Platform subscribes to margin available updates using {@link IBrokerWithoutRealtime.subscribeMarginAvailable}.
   * @default false
   */
  supportMargin?: boolean;
  /**
   * Enables Profit & Loss calculations using last value.
   * @default false
   */
  calculatePLUsingLast?: boolean;
  /**
   * Allows providing the estimated commission, fees, margin, and other order information before placing the order without actually placing it.
   * This information will be displayed in the _Order confirmation_ dialog.
   *
   * This flag requires the {@link IBrokerTerminal.previewOrder} method to be implemented and `confirmId` parameter to be passed in the {@link IBrokerTerminal.placeOrder} method.
   * Refer to [Enable order preview](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/order-ticket.md#add-custom-fields) for more information.
   * @default false
   */
  supportPlaceOrderPreview?: boolean;
  /**
   * Allows providing the estimated commission, fees, margin, and other order information before modifying the order without actually modifying it.
   * This information will be displayed in the _Order confirmation_ dialog.
   *
   * This flag requires the {@link IBrokerTerminal.previewOrder} method to be implemented and `confirmId` parameter to be passed in the {@link IBrokerTerminal.modifyOrder} method.
   * Refer to [Enable order preview](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/order-ticket.md#add-custom-fields) for more information.
   * @default false
   */
  supportModifyOrderPreview?: boolean;
  /**
   * Enables trading with leverage.
   * If the flag is set to `true`, you should calculate the leverage using the {@link IBrokerWithoutRealtime.leverageInfo} method.
   * @default false
   */
  supportLeverage?: boolean;
  /**
   * Displays a leverage button in the UI.
   * Note that you should also enable the {@link BrokerConfigFlags.supportLeverage} flag.
   * If `supportLeverageButton` is set to `true`, the leverage input field appears in the Order Ticket.
   * Clicking the input field activates a dedicated Leverage Dialog.
   * @default true
   */
  supportLeverageButton?: boolean;
  /**
   * Enables orders history.
   * If `supportOrdersHistory` is set to `true`, the [Account Manager](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md) will have an additional tab: _Orders History_.
   * This flag requires the {@link IBrokerTerminal.ordersHistory} method to be implemented.
   * The method should return a list of orders with the `filled`, `cancelled`, and `rejected` statuses from previous trade sessions.
   * @default false
   */
  supportOrdersHistory?: boolean;
  /**
   * Enables adding brackets to the existing order.
   * @default true
   */
  supportAddBracketsToExistingOrder?: boolean;
  /**
   * Allows getting crypto balances for an account.
   * Balances are displayed as the first table of the _Account Summary_ tab.
   * Use the flag for crypto currencies only.
   * This flag requires the {@link IBrokerConnectionAdapterHost.cryptoBalanceUpdate} method to be implemented.
   * @default false
   */
  supportBalances?: boolean;
  /**
   * Closing a position cancels its brackets.
   * @default false
   */
  closePositionCancelsOrders?: boolean;
  /**
   * `Stop Loss` and `Take Profit` are added or removed only together.
   * @default false
   */
  supportOnlyPairPositionBrackets?: boolean;
  /**
   * Enables cryptocurrency trading (exchanging).
   * This flag switches the Order Ticket to Crypto Exchange mode,
   * which provides additional controls for entering the quantity in either the base or quote currency.
   * @default false
   */
  supportCryptoExchangeOrderTicket?: boolean;
  /**
   * Enables displaying Profit & Loss values in instrument currency.
   * @default false
   */
  positionPLInInstrumentCurrency?: boolean;
  /**
   * Enables partial position closing.
   * This flag requires the {@link IBrokerTerminal.closePosition} method to be implemented.
   * @default false
   */
  supportPartialClosePosition?: boolean;
  /**
   * Enables partial individual position closing.
   * This flag requires the {@link IBrokerTerminal.closeIndividualPosition} method to be implemented.
   * @default false
   */
  supportPartialCloseIndividualPosition?: boolean;
  /**
   * Modifies the confirmation dialog text for closing a bracket order.
   * When set to `true`, the text explicitly states that cancelling a bracket order will also cancel its associated pair.
   * When set to `false`, the text will include the ID of the singular bracket order being cancelled.
   *
   * Note that the library does not cancel orders itself.
   * You should implement the {@link IBrokerTerminal.cancelOrder} or {@link IBrokerTerminal.cancelOrders } method.
   * @default false
   */
  supportCancellingBothBracketsOnly?: boolean;
  /**
   * Enables crypto brackets.
   * @default false
   */
  supportCryptoBrackets?: boolean;
  /**
   * Enables the _Notifications log_ tab in the [Account Manager](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/account-manager.md).
   * @default true
   */
  showNotificationsLog?: boolean;
  /**
   * Whether stop orders should behave like Market-if-Touched in both directions.
   * Enabling this flag prevents the check of stop price direction from the stop limit Order Ticket.
   * @default false
   */
  supportStopOrdersInBothDirections?: boolean;
  /**
   * Whether stop-limit orders should behave like Limit-if-Touched in both directions.
   * Enabling this flag prevents the check of stop price direction from the stop limit Order Ticket.
   */
  supportStopLimitOrdersInBothDirections?: boolean;
  /**
   * Whether the integration supports limit price validation in the order ticket to eliminate the possibility to place
   * an order on the wrong side of the market that will most likely trigger and get filled immediately.
   */
  supportStrictCheckingLimitOrderPrice?: boolean;
  /**
   * Enables executions.
   * This flag requires the {@link IBrokerTerminal.executions} method to be implemented.
   * @default false
   */
  supportExecutions?: boolean;
  /**
   * Allows modifying order type.
   * @default false
   */
  supportModifyOrderType?: boolean;
  /**
   * Enables closing of individual positions in FIFO order.
   * @default false
   */
  requiresFIFOCloseIndividualPositions?: boolean;
}
export interface BrokerCustomUI {
  /**
   * Shows standard Order Ticket to create or modify an order and executes handler if Buy/Sell/Modify is pressed.
   * @param  {OrderTemplate|Order} order - order to be placed or modified
   * @param  {OrderTicketFocusControl} [focus] - Control to focus on when dialog is opened
   */
  showOrderDialog?: (
    order: OrderTemplate | Order,
    focus?: OrderTicketFocusControl
  ) => Promise<boolean>;
  /**
   * Shows the Position Dialog
   * @param  {Position|IndividualPosition} position - position to be placed or modified
   * @param  {Brackets} brackets - brackets for the position
   * @param  {OrderTicketFocusControl} [focus] - Control to focus on when dialog is opened
   */
  showPositionDialog?: (
    position: Position | IndividualPosition,
    brackets: Brackets,
    focus?: OrderTicketFocusControl
  ) => Promise<boolean>;
  /**
   * Shows a confirmation dialog and executes handler if YES/OK is pressed.
   * @param  {Order} order - order to be cancelled
   */
  showCancelOrderDialog?: (order: Order) => Promise<boolean>;
  /**
   * Shows the Close Position Dialog.
   * @param  {Position} position - position to be closed
   */
  showClosePositionDialog?: (position: Position) => Promise<boolean>;
}
/**
 * Override properties for the Brush drawing tool.
 */
export interface BrushLineToolOverrides {
  /** Default value: `#00bcd4` */
  "linetoolbrush.backgroundColor": string;
  /** Default value: `false` */
  "linetoolbrush.fillBackground": boolean;
  /** Default value: `0` */
  "linetoolbrush.leftEnd": number;
  /** Default value: `#00bcd4` */
  "linetoolbrush.linecolor": string;
  /** Default value: `0` */
  "linetoolbrush.linestyle": number;
  /** Default value: `2` */
  "linetoolbrush.linewidth": number;
  /** Default value: `0` */
  "linetoolbrush.rightEnd": number;
  /** Default value: `5` */
  "linetoolbrush.smooth": number;
  /** Default value: `50` */
  "linetoolbrush.transparency": number;
}
/**
 * Override properties for the Callout drawing tool.
 */
export interface CalloutLineToolOverrides {
  /** Default value: `rgba(0, 151, 167, 0.7)` */
  "linetoolcallout.backgroundColor": string;
  /** Default value: `false` */
  "linetoolcallout.bold": boolean;
  /** Default value: `#0097A7` */
  "linetoolcallout.bordercolor": string;
  /** Default value: `#ffffff` */
  "linetoolcallout.color": string;
  /** Default value: `14` */
  "linetoolcallout.fontsize": number;
  /** Default value: `false` */
  "linetoolcallout.italic": boolean;
  /** Default value: `2` */
  "linetoolcallout.linewidth": number;
  /** Default value: `50` */
  "linetoolcallout.transparency": number;
  /** Default value: `false` */
  "linetoolcallout.wordWrap": boolean;
  /** Default value: `200` */
  "linetoolcallout.wordWrapWidth": number;
}
export interface CandleStylePreferences {
  /** Body color for an up candle */
  upColor: string;
  /** Body color for a down candle */
  downColor: string;
  /** Whether to draw the candle wick */
  drawWick: boolean;
  /** Whether to draw the candle body border */
  drawBorder: boolean;
  /** Whether to draw the candle body */
  drawBody: boolean;
  /** Candle border color */
  borderColor: string;
  /** Up candle border color */
  borderUpColor: string;
  /** Down candle border color */
  borderDownColor: string;
  /** Candle wick color */
  wickColor: string;
  /** Up candle wick color */
  wickUpColor: string;
  /** Down candle wick color */
  wickDownColor: string;
  /** Bar color determined by previous close value */
  barColorsOnPrevClose: boolean;
}
/**
 * Overrides for the 'Chaikin Money Flow' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ChaikinMoneyFlowIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#43A047` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Chaikin Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ChaikinOscillatorIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#EC407A` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Chaikin Volatility' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ChaikinVolatilityIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#AB47BC` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Chande Kroll Stop' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ChandeKrollStopIndicatorOverrides {
  /** Default value: `15` */
  "long.display": number;
  /** Default value: `0` */
  "long.linestyle": number;
  /** Default value: `1` */
  "long.linewidth": number;
  /** Default value: `line` */
  "long.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "long.trackprice": boolean;
  /** Default value: `0` */
  "long.transparency": number;
  /** Default value: `#2196F3` */
  "long.color": string;
  /** Default value: `15` */
  "short.display": number;
  /** Default value: `0` */
  "short.linestyle": number;
  /** Default value: `1` */
  "short.linewidth": number;
  /** Default value: `line` */
  "short.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "short.trackprice": boolean;
  /** Default value: `0` */
  "short.transparency": number;
  /** Default value: `#FF6D00` */
  "short.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Chande Momentum Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ChandeMomentumOscillatorIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface ChangeAccountSolution {
  /** id of a sub-account suitable for trading the symbol */
  changeAccount: AccountId;
}
export interface ChangeSymbolSolution {
  /** the symbol suitable for trading with current sub-account */
  changeSymbol: string;
}
export interface ChangeThemeOptions {
  /** Disable undo for the theme change */
  disableUndo: boolean;
}
/**
 * Saved chart data
 */
export interface ChartData {
  /** unique ID of the chart (may be `undefined` if it wasn't saved before) */
  id: string | undefined;
  /** name of the chart */
  name: string;
  /** symbol of the chart */
  symbol: string;
  /** resolution of the chart */
  resolution: ResolutionString;
  /** content of the chart */
  content: string;
}
export interface ChartDescriptionContext {
  /** Style of chart */
  chartType: SeriesType;
  /** Name of chart style */
  chartTypeName: string;
  /** Symbol's description from the Symbol Info */
  description?: string;
  /** Symbol identifier, typically the symbols ticker or name defined in the Symbol Info */
  symbol: string;
  /** Symbol's exchange */
  exchange?: string;
  /** Symbol's ticker identifier */
  ticker?: string;
  /** Visible time range */
  visibleRange: VisibleTimeRange;
  /** Visible data. Only included if [aria_detailed_chart_descriptions](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#aria_detailed_chart_descriptions) featureset is enabled */
  visibleData?: ExportedData;
  /** The complete Symbol Info for the chart's main series */
  symbolInfo: LibrarySymbolInfo | null;
  /** Index of the current chart within a multi-chart layout */
  chartIndex: number;
  /** Number of visible charts in the current layout */
  chartCount: number;
  /** Symbol's default price formatter */
  priceFormatter: ISymbolValueFormatter;
  /** Resolution (interval) of the chart */
  interval: ResolutionString;
  /** Is the resolution (interval) intraday */
  isIntraday: boolean;
}
/**
 * Meta information about a saved chart
 */
export interface ChartMetaInfo {
  /** unique ID of the chart. */
  id: number;
  /** name of the chart */
  name: string;
  /** symbol of the chart */
  symbol: string;
  /** resolution of the chart */
  resolution: ResolutionString;
  /** UNIX time when the chart was last modified */
  timestamp: number;
}
/**
 * Property overrides that can be used with {@link IChartingLibraryWidget.applyOverrides}.
 */
export interface ChartPropertiesOverrides {
  /**
   * Override values.
   */
  [key: string]: string | number | boolean;
  /**
   * A timezone ID. The default value depends on the locale.
   */
  timezone: TimezoneId;
  /**
   * A price scale selection strategy. Determines where price scales should be placed: on the left, on the right, or spread evenly (auto).
   *
   * @default 'auto'
   */
  priceScaleSelectionStrategyName: "left" | "right" | "auto";
  /**
   * Pane background type. In the dark theme, the default value is 'gradient'.
   *
   * @default 'solid'
   */
  "paneProperties.backgroundType": ColorTypes;
  /**
   * Pane background color.
   *
   * @default '#ffffff'
   */
  "paneProperties.background": string;
  /**
   * Pane background gradient start color.
   *
   * @default '#ffffff'
   */
  "paneProperties.backgroundGradientStartColor": string;
  /**
   * Pane background gradient end color.
   *
   * @default '#ffffff'
   */
  "paneProperties.backgroundGradientEndColor": string;
  /**
   * Pane vertical grid color.
   *
   * @default 'rgba(42, 46, 57, 0.06)'
   */
  "paneProperties.vertGridProperties.color": string;
  /**
   * Pane vertical grid line style.
   *
   * @default LineStyle.Solid
   */
  "paneProperties.vertGridProperties.style": OverrideLineStyle;
  /**
   * Pane horizontal grid color.
   *
   * @default 'rgba(42, 46, 57, 0.06)'
   */
  "paneProperties.horzGridProperties.color": string;
  /**
   * Pane horizontal grid line style.
   *
   * @default LineStyle.Solid
   */
  "paneProperties.horzGridProperties.style": OverrideLineStyle;
  /**
   * Crosshair color.
   *
   * @default '#9598A1'
   */
  "crossHairProperties.color": string;
  /**
   * Crosshair style.
   *
   * @default LineStyle.Dashed
   */
  "crossHairProperties.style": OverrideLineStyle;
  /**
   * Crosshair transparency.
   *
   * @default 0
   */
  "crossHairProperties.transparency": number;
  /**
   * Crosshair width.
   *
   * @default 1
   */
  "crossHairProperties.width": number;
  /**
   * Pane auto scaling top margin percentage.
   *
   * @default 10
   */
  "paneProperties.topMargin": number;
  /**
   * Pane auto scaling bottom margin percentage.
   *
   * @default 8
   */
  "paneProperties.bottomMargin": number;
  /**
   * Pane separator color.
   *
   * @default '#E0E3EB'
   */
  "paneProperties.separatorColor": string;
  /**
   * Study legend input values visibility.
   *
   * @default true
   */
  "paneProperties.legendProperties.showStudyArguments": boolean;
  /**
   * Study legend title visibility.
   *
   * @default true
   */
  "paneProperties.legendProperties.showStudyTitles": boolean;
  /**
   * Toggle the visibility for all studies legend values.
   *
   * @default true
   */
  "paneProperties.legendProperties.showStudyValues": boolean;
  /**
   * Series legend title visibility.
   *
   * @default true
   */
  "paneProperties.legendProperties.showSeriesTitle": boolean;
  /**
   * Study legend OHLC values visibility.
   *
   * @default true
   */
  "paneProperties.legendProperties.showSeriesOHLC": boolean;
  /**
   * Series legend change value visibility.
   *
   * @default true
   */
  "paneProperties.legendProperties.showBarChange": boolean;
  /**
   * Series legend volume value visibility.
   *
   * @default false
   */
  "paneProperties.legendProperties.showVolume": boolean;
  /**
   * Legend background visibility.
   *
   * @default true
   */
  "paneProperties.legendProperties.showBackground": boolean;
  /**
   * Legend background transparency percentage.
   *
   * @default 50
   */
  "paneProperties.legendProperties.backgroundTransparency": number;
  /**
   * Scales (axis) border line color.
   *
   * @default 'rgba(42, 46, 57, 0)'
   */
  "scalesProperties.lineColor": string;
  /**
   * Scales (axis) text color.
   *
   * @default '#131722'
   */
  "scalesProperties.textColor": string;
  /**
   * Scales (axis) font size.
   *
   * @default 12
   */
  "scalesProperties.fontSize": number;
  /**
   * Series last value label visibility.
   *
   * @default true
   */
  "scalesProperties.showSeriesLastValue": boolean;
  /**
   * Series last value label display mode.
   *
   * @default PriceAxisLastValueMode.LastValueAccordingToScale
   */
  "scalesProperties.seriesLastValueMode": OverridePriceAxisLastValueMode;
  /**
   * Study label value label visibility.
   *
   * @default true
   */
  "scalesProperties.showStudyLastValue": boolean;
  /**
   * Symbol name label visibility.
   *
   * @default false
   */
  "scalesProperties.showSymbolLabels": boolean;
  /**
   * Study plot labels visibility.
   *
   * @default false
   */
  "scalesProperties.showStudyPlotLabels": boolean;
  /**
   * Bid/ask labels visibility.
   *
   * @default false
   */
  "scalesProperties.showBidAskLabels": boolean;
  /**
   * Pre/post market price labels visibility.
   *
   * @default true
   */
  "scalesProperties.showPrePostMarketPriceLabel": boolean;
  /**
   * Sets the highlight color of the scales when adding a drawing.
   *
   * @default 'rgba(41, 98, 255, 0.25)'
   */
  "scalesProperties.axisHighlightColor": string;
  /**
   * Configures the background color of a label shown on an axis scale when a drawing is selected.
   *
   * @default '#2962FF'
   */
  "scalesProperties.axisLineToolLabelBackgroundColorCommon": string;
  /**
   * Dynamically changes the background color of all labels on the price scale when a drawing is in motion.
   *
   * @default '#143EB3'
   */
  "scalesProperties.axisLineToolLabelBackgroundColorActive": string;
  /**
   * Price scale crosshair label visibility.
   *
   * @default true
   */
  "scalesProperties.showPriceScaleCrosshairLabel": boolean;
  /**
   * Time scale crosshair label visibility.
   *
   * @default true
   */
  "scalesProperties.showTimeScaleCrosshairLabel": boolean;
  /**
   * Crosshair label light theme background color.
   *
   * @default '#131722'
   */
  "scalesProperties.crosshairLabelBgColorLight": string;
  /**
   * Crosshair label dark theme background color.
   *
   * @default '#363A45'
   */
  "scalesProperties.crosshairLabelBgColorDark": string;
  /**
   * Main series chart style.
   *
   * @default ChartStyle.Candle
   */
  "mainSeriesProperties.style": ChartStyle;
  /**
   * Displays the countdown to the bar closing on the price scale. Available only for [intraday](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution.md#resolution-in-minutes-intraday) resolutions.
   *
   * @default false
   */
  "mainSeriesProperties.showCountdown": boolean;
  /**
   * Main series bid & ask visibility
   *
   * @default false
   */
  "mainSeriesProperties.bidAsk.visible": boolean;
  /**
   * Style of the line for bid & ask
   *
   * @default LineStyle.Dotted
   */
  "mainSeriesProperties.bidAsk.lineStyle": OverrideLineStyle;
  /**
   * Width of the line for bid & ask
   *
   * @default 1
   */
  "mainSeriesProperties.bidAsk.lineWidth": number;
  /**
   * Color line for the bid
   *
   * @default '#2962FF'
   */
  "mainSeriesProperties.bidAsk.bidLineColor": string;
  /**
   * Color line for the ask
   *
   * @default '#F7525F'
   */
  "mainSeriesProperties.bidAsk.askLineColor": string;
  /**
   * High/low price lines visibility.
   *
   * @default false
   */
  "mainSeriesProperties.highLowAvgPrice.highLowPriceLinesVisible": boolean;
  /**
   * High/low price lines label visibility.
   *
   * @default false
   */
  "mainSeriesProperties.highLowAvgPrice.highLowPriceLabelsVisible": boolean;
  /**
   * Average close price lines visibility.
   *
   * @default false
   */
  "mainSeriesProperties.highLowAvgPrice.averageClosePriceLineVisible": boolean;
  /**
   * Average close price lines label visibility.
   *
   * @default false
   */
  "mainSeriesProperties.highLowAvgPrice.averageClosePriceLabelVisible": boolean;
  /**
   * High/low price lines color.
   *
   * @default ""
   */
  "mainSeriesProperties.highLowAvgPrice.highLowPriceLinesColor": string;
  /**
   *
   * High/low price lines width.
   *
   * @default 1
   */
  "mainSeriesProperties.highLowAvgPrice.highLowPriceLinesWidth": number;
  /**
   *
   * Average close price lines color.
   *
   * @default ""
   */
  "mainSeriesProperties.highLowAvgPrice.averagePriceLineColor": string;
  /**
   *
   * Average close price lines width.
   *
   * @default 1
   */
  "mainSeriesProperties.highLowAvgPrice.averagePriceLineWidth": number;
  /**
   * Main series visibility.
   *
   * @default true
   */
  "mainSeriesProperties.visible": boolean;
  /**
   * Sessions to display on the chart. Use `'extended'` to include pre- and post-market subsessions. See the [Extended Sessions](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Extended-Sessions) guide for more info.
   *
   * @default 'regular'
   */
  "mainSeriesProperties.sessionId": "regular" | "extended";
  /**
   * Main series price line visibility.
   *
   * @default true
   */
  "mainSeriesProperties.showPriceLine": boolean;
  /**
   *
   * Main series price line width.
   *
   * @default 1
   */
  "mainSeriesProperties.priceLineWidth": number;
  /**
   * Main series price line color.
   *
   * @default ""
   */
  "mainSeriesProperties.priceLineColor": string;
  /**
   * Main series previous close price line visibility.
   *
   * @default false
   */
  "mainSeriesProperties.showPrevClosePriceLine": boolean;
  /**
   * Main series previous close price line width.
   *
   * @default 1
   */
  "mainSeriesProperties.prevClosePriceLineWidth": number;
  /**
   * Main series previous close price line color.
   *
   * @default "#555555"
   */
  "mainSeriesProperties.prevClosePriceLineColor": string;
  /**
   * Main series minimum tick behaviour.
   *
   * @default "default"
   *
   * @example
   *
   * ```javascript
   * // reset minTick to default
   * tvWidget.applyOverrides({ 'mainSeriesProperties.minTick': 'default' });
   *
   * // Set main series minTick to { priceScale: 10000, minMove: 1, frac: false }
   * tvWidget.applyOverrides({ 'mainSeriesProperties.minTick': '10000,1,false' });
   *
   * // Set default minTick for overlay studies to { priceScale: 10000, minMove: 1, frac: false }
   * tvWidget.applyStudiesOverrides({ 'overlay.minTick': '10000,1,false' });
   * ```
   */
  "mainSeriesProperties.minTick": string;
  /**
   * Main series legend exchange visibility.
   *
   * @default true
   */
  "mainSeriesProperties.statusViewStyle.showExchange": boolean;
  /**
   * Main series legend interval visibility.
   *
   * @default true
   */
  "mainSeriesProperties.statusViewStyle.showInterval": boolean;
  /**
   * Main series legend text style.
   *
   * @default "description"
   */
  "mainSeriesProperties.statusViewStyle.symbolTextSource": SeriesStatusViewSymbolTextSource;
  /**
   * Main series candle style up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.candleStyle.upColor": string;
  /**
   * Main series candle style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.candleStyle.downColor": string;
  /**
   * Main series candle style wick visibility.
   *
   * @default true
   */
  "mainSeriesProperties.candleStyle.drawWick": boolean;
  /**
   * Main series candle style border visibility.
   *
   * @default true
   */
  "mainSeriesProperties.candleStyle.drawBorder": boolean;
  /**
   *
   * Main series candle style border color.
   *
   * @default "#378658"
   */
  "mainSeriesProperties.candleStyle.borderColor": string;
  /**
   *
   * Main series candle style border up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.candleStyle.borderUpColor": string;
  /**
   * Main series candle style border down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.candleStyle.borderDownColor": string;
  /**
   * Main series candle style wick color.
   *
   * @default "#737375"
   */
  "mainSeriesProperties.candleStyle.wickColor": string;
  /**
   * Main series candle style wick up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.candleStyle.wickUpColor": string;
  /**
   * Main series candle style wick down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.candleStyle.wickDownColor": string;
  /**
   *
   * Main series candle style color on previous close behaviour.
   *
   * @default false
   */
  "mainSeriesProperties.candleStyle.barColorsOnPrevClose": boolean;
  /**
   * Main series candle style body visibility.
   *
   * @default true
   */
  "mainSeriesProperties.candleStyle.drawBody": boolean;
  /**
   * Main series hollow candle style up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.hollowCandleStyle.upColor": string;
  /**
   * Main series hollow candle style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.hollowCandleStyle.downColor": string;
  /**
   * Main series hollow candle style wick visibility.
   *
   * @default true
   */
  "mainSeriesProperties.hollowCandleStyle.drawWick": boolean;
  /**
   * Main series hollow candle style border visibility.
   *
   * @default true
   */
  "mainSeriesProperties.hollowCandleStyle.drawBorder": boolean;
  /**
   * Main series hollow candle style border color.
   *
   * @default "#378658"
   */
  "mainSeriesProperties.hollowCandleStyle.borderColor": string;
  /**
   * Main series hollow candle style border up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.hollowCandleStyle.borderUpColor": string;
  /**
   * Main series hollow candle style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.hollowCandleStyle.borderDownColor": string;
  /**
   * Main series hollow candle style wick color.
   *
   * @default "#737375"
   */
  "mainSeriesProperties.hollowCandleStyle.wickColor": string;
  /**
   * Main series hollow candle style wick up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.hollowCandleStyle.wickUpColor": string;
  /**
   * Main series hollow candle style wick down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.hollowCandleStyle.wickDownColor": string;
  /**
   * Main series hollow candle style body visibility.
   *
   * @default true
   */
  "mainSeriesProperties.hollowCandleStyle.drawBody": boolean;
  /**
   * Main series Heikin Ashi style up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.haStyle.upColor": string;
  /**
   * Main series Heikin Ashi style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.haStyle.downColor": string;
  /**
   * Main series Heikin Ashi style wick visibility.
   *
   * @default true
   */
  "mainSeriesProperties.haStyle.drawWick": boolean;
  /**
   * Main series Heikin Ashi style border visibility.
   *
   * @default true
   */
  "mainSeriesProperties.haStyle.drawBorder": boolean;
  /**
   * Main series Heikin Ashi style border color.
   *
   * @default "#378658"
   */
  "mainSeriesProperties.haStyle.borderColor": string;
  /**
   * Main series Heikin Ashi style border up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.haStyle.borderUpColor": string;
  /**
   * Main series Heikin Ashi style border down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.haStyle.borderDownColor": string;
  /**
   * Main series Heikin Ashi style wick color.
   *
   * @default "#737375"
   */
  "mainSeriesProperties.haStyle.wickColor": string;
  /**
   * Main series Heikin Ashi style wick up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.haStyle.wickUpColor": string;
  /**
   * Main series Heikin Ashi style wick down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.haStyle.wickDownColor": string;
  /**
   * Main series Heikin Ashi style color on previous close behaviour.
   *
   * @default false
   */
  "mainSeriesProperties.haStyle.barColorsOnPrevClose": boolean;
  /**
   * Main series Heikin Ashi style body visibility.
   *
   * @default true
   */
  "mainSeriesProperties.haStyle.drawBody": boolean;
  /**
   * Main series bar style up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.barStyle.upColor": string;
  /**
   * Main series bar style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.barStyle.downColor": string;
  /**
   * Main series bar style color on previous close behaviour.
   *
   * @default false
   */
  "mainSeriesProperties.barStyle.barColorsOnPrevClose": boolean;
  /**
   * Main series bar style don't draw open behaviour.
   *
   * @default false
   */
  "mainSeriesProperties.barStyle.dontDrawOpen": boolean;
  /**
   * Main series bar style thin bars behaviour.
   *
   * @default true
   */
  "mainSeriesProperties.barStyle.thinBars": boolean;
  /**
   * Main series High-low style color.
   *
   * @default "#2962FF"
   */
  "mainSeriesProperties.hiloStyle.color": string;
  /**
   * Main series High-low style border visibility.
   *
   * @default true
   */
  "mainSeriesProperties.hiloStyle.showBorders": boolean;
  /**
   * Main series High-low style border color.
   *
   * @default "#2962FF"
   */
  "mainSeriesProperties.hiloStyle.borderColor": string;
  /**
   * Main series High-low style label visibility.
   *
   * @default true
   */
  "mainSeriesProperties.hiloStyle.showLabels": boolean;
  /**
   * Main series High-low style label color.
   *
   * @default "#2962FF"
   */
  "mainSeriesProperties.hiloStyle.labelColor": string;
  /**
   * Main series column style up color.
   *
   * @default "rgba(8, 153, 129, 0.5)"
   */
  "mainSeriesProperties.columnStyle.upColor": string;
  /**
   * Main series column style down color.
   *
   * @default "rgba(242, 54, 69, 0.5)"
   */
  "mainSeriesProperties.columnStyle.downColor": string;
  /**
   * Main series column style color on previous close behaviour.
   *
   * @default true
   */
  "mainSeriesProperties.columnStyle.barColorsOnPrevClose": boolean;
  /**
   * Main series column style price source.
   *
   * @default "close"
   */
  "mainSeriesProperties.columnStyle.priceSource": PriceSource;
  /**
   * Main series line style color.
   *
   * @default "#2962FF"
   */
  "mainSeriesProperties.lineStyle.color": string;
  /**
   * Main series line style line style.
   *
   * @default LineStyle.Solid
   */
  "mainSeriesProperties.lineStyle.linestyle": OverrideLineStyle;
  /**
   * Main series line style line width.
   *
   * @default 2
   */
  "mainSeriesProperties.lineStyle.linewidth": number;
  /**
   * Main series line style price source.
   *
   * @default "close"
   */
  "mainSeriesProperties.lineStyle.priceSource": PriceSource;
  /**
   * Main series area style color1.
   *
   * @default "rgba(41, 98, 255, 0.28)"
   */
  "mainSeriesProperties.areaStyle.color1": string;
  /**
   * Main series area style color2.
   *
   * @default "#2962FF"
   */
  "mainSeriesProperties.areaStyle.color2": string;
  /**
   * Main series area style line color.
   *
   * @default "#2962FF"
   */
  "mainSeriesProperties.areaStyle.linecolor": string;
  /**
   * Main series area style line style.
   *
   * @default LineStyle.Solid
   */
  "mainSeriesProperties.areaStyle.linestyle": OverrideLineStyle;
  /**
   * Main series area style line width.
   *
   * @default 2
   */
  "mainSeriesProperties.areaStyle.linewidth": number;
  /**
   * Main series area style price source.
   *
   * @default "close"
   */
  "mainSeriesProperties.areaStyle.priceSource": PriceSource;
  /**
   * Main series area style transparency.
   *
   * @default 100
   */
  "mainSeriesProperties.areaStyle.transparency": number;
  /**
   * Main series hlc area style close line color.
   *
   * @default "#868993"
   */
  "mainSeriesProperties.hlcAreaStyle.closeLineColor": string;
  /**
   * Main series hlc area style close line style.
   *
   * @default LineStyle.Solid
   */
  "mainSeriesProperties.hlcAreaStyle.closeLineStyle": OverrideLineStyle;
  /**
   * Main series hlc area style close line width.
   *
   * @default 2
   */
  "mainSeriesProperties.hlcAreaStyle.closeLineWidth": number;
  /**
   * Main series hlc area style close low fill color.
   *
   * @default "rgba(242, 54, 69, 0.2)"
   */
  "mainSeriesProperties.hlcAreaStyle.closeLowFillColor": string;
  /**
   * Main series hlc area style high close fill color.
   *
   * @default "rgba(8, 153, 129, 0.2)"
   */
  "mainSeriesProperties.hlcAreaStyle.highCloseFillColor": string;
  /**
   * Main series hlc area style high line color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.hlcAreaStyle.highLineColor": string;
  /**
   * Main series hlc area style high line style.
   *
   * @default LineStyle.Solid
   */
  "mainSeriesProperties.hlcAreaStyle.highLineStyle": OverrideLineStyle;
  /**
   * Main series hlc area style high line width.
   *
   * @default 2
   */
  "mainSeriesProperties.hlcAreaStyle.highLineWidth": number;
  /**
   * Main series hlc area style low line color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.hlcAreaStyle.lowLineColor": string;
  /**
   * Main series hlc area style low line style.
   *
   * @default LineStyle.Solid
   */
  "mainSeriesProperties.hlcAreaStyle.lowLineStyle": OverrideLineStyle;
  /**
   * Main series hlc area style low line width.
   *
   * @default 2
   */
  "mainSeriesProperties.hlcAreaStyle.lowLineWidth": number;
  /**
   * Main series price axis percentage mode.
   *
   * @default false
   */
  "mainSeriesProperties.priceAxisProperties.percentage": boolean;
  /**
   * Main series price axis indexed to 100 mode.
   *
   * @default false
   */
  "mainSeriesProperties.priceAxisProperties.indexedTo100": boolean;
  /**
   * Main series price axis log mode.
   *
   * @default false
   */
  "mainSeriesProperties.priceAxisProperties.log": boolean;
  /**
   * Main series price axis inverted mode.
   *
   * @default false
   */
  "mainSeriesProperties.priceAxisProperties.isInverted": boolean;
  /**
   * Main series price axis label alignment behaviour.
   *
   * @default true
   */
  "mainSeriesProperties.priceAxisProperties.alignLabels": boolean;
  /**
   * Main series Renko style up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.renkoStyle.upColor": string;
  /**
   * Main series Renko style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.renkoStyle.downColor": string;
  /**
   * Main series Renko style border up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.renkoStyle.borderUpColor": string;
  /**
   * Main series Renko style border down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.renkoStyle.borderDownColor": string;
  /**
   * Main series Renko style up projection color.
   *
   * @default "#a9dcc3"
   */
  "mainSeriesProperties.renkoStyle.upColorProjection": string;
  /**
   * Main series Renko style down projection color.
   *
   * @default "#f5a6ae"
   */
  "mainSeriesProperties.renkoStyle.downColorProjection": string;
  /**
   * Main series Renko style up projection border color.
   *
   * @default "#a9dcc3"
   */
  "mainSeriesProperties.renkoStyle.borderUpColorProjection": string;
  /**
   * Main series Renko style down projection border color.
   *
   * @default "#f5a6ae"
   */
  "mainSeriesProperties.renkoStyle.borderDownColorProjection": string;
  /**
   * Main series Renko style wick up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.renkoStyle.wickUpColor": string;
  /**
   * Main series Renko style wick down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.renkoStyle.wickDownColor": string;
  /**
   * Main series Line Break style up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.pbStyle.upColor": string;
  /**
   * Main series Line Break style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.pbStyle.downColor": string;
  /**
   * Main series Line Break style border up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.pbStyle.borderUpColor": string;
  /**
   * Main series Line Break style border down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.pbStyle.borderDownColor": string;
  /**
   * Main series Line Break style up projection color.
   *
   * @default "#a9dcc3"
   */
  "mainSeriesProperties.pbStyle.upColorProjection": string;
  /**
   * Main series Line Break style down projection color.
   *
   * @default "#f5a6ae"
   */
  "mainSeriesProperties.pbStyle.downColorProjection": string;
  /**
   * Main series Line Break style up projection color.
   *
   * @default "#a9dcc3"
   */
  "mainSeriesProperties.pbStyle.borderUpColorProjection": string;
  /**
   * Main series Line Break style down projection color.
   *
   * @default "#f5a6ae"
   */
  "mainSeriesProperties.pbStyle.borderDownColorProjection": string;
  /**
   * Main series Kagi style up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.kagiStyle.upColor": string;
  /**
   * Main series Kagi style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.kagiStyle.downColor": string;
  /**
   * Main series Kagi style up projection color.
   *
   * @default "#a9dcc3"
   */
  "mainSeriesProperties.kagiStyle.upColorProjection": string;
  /**
   * Main series Kagi style down projection color.
   *
   * @default "#f5a6ae"
   */
  "mainSeriesProperties.kagiStyle.downColorProjection": string;
  /**
   * Main series Point & Figure style up color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.pnfStyle.upColor": string;
  /**
   * Main series Point & Figure style down color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.pnfStyle.downColor": string;
  /**
   * Main series Point & Figure style up projection color.
   *
   * @default "#a9dcc3"
   */
  "mainSeriesProperties.pnfStyle.upColorProjection": string;
  /**
   * Main series Point & Figure style down projection color.
   *
   * @default "#f5a6ae"
   */
  "mainSeriesProperties.pnfStyle.downColorProjection": string;
  /**
   * Main series Baseline style baseline color.
   *
   * @default "#758696"
   */
  "mainSeriesProperties.baselineStyle.baselineColor": string;
  /**
   * Main series Baseline style top fill color1.
   *
   * @default "rgba(8, 153, 129, 0.28)"
   */
  "mainSeriesProperties.baselineStyle.topFillColor1": string;
  /**
   * Main series Baseline style top fill color2.
   *
   * @default "rgba(8, 153, 129, 0.05)"
   */
  "mainSeriesProperties.baselineStyle.topFillColor2": string;
  /**
   * Main series Baseline style bottom fill color1.
   *
   * @default "rgba(242, 54, 69, 0.05)"
   */
  "mainSeriesProperties.baselineStyle.bottomFillColor1": string;
  /**
   * Main series Baseline style bottom fill color2.
   *
   * @default "rgba(242, 54, 69, 0.28)"
   */
  "mainSeriesProperties.baselineStyle.bottomFillColor2": string;
  /**
   * Main series Baseline style top line color.
   *
   * @default "#089981"
   */
  "mainSeriesProperties.baselineStyle.topLineColor": string;
  /**
   * Main series Baseline style bottom line color.
   *
   * @default "#F23645"
   */
  "mainSeriesProperties.baselineStyle.bottomLineColor": string;
  /**
   * Main series Baseline style top line width.
   *
   * @default 2
   */
  "mainSeriesProperties.baselineStyle.topLineWidth": number;
  /**
   * Main series Baseline style bottom line width.
   *
   * @default 2
   */
  "mainSeriesProperties.baselineStyle.bottomLineWidth": number;
  /**
   * Main series Baseline style price source.
   *
   * @default "close"
   */
  "mainSeriesProperties.baselineStyle.priceSource": PriceSource;
  /**
   * Main series Baseline style transparency.
   *
   * @default 50
   */
  "mainSeriesProperties.baselineStyle.transparency": number;
  /**
   * Main series Baseline style base level percentage.
   *
   * @default 50
   */
  "mainSeriesProperties.baselineStyle.baseLevelPercentage": number;
  /**
   * Main series Line With Markers style Line Color.
   *
   * @default '#2962FF'
   */
  "mainSeriesProperties.lineWithMarkersStyle.color": string;
  /**
   * Main series Line With Markers style Line style.
   *
   * @default LineStyle.Solid
   */
  "mainSeriesProperties.lineWithMarkersStyle.linestyle": OverrideLineStyle;
  /**
   * Main series Line With Markers style Line width.
   *
   * @default 2
   */
  "mainSeriesProperties.lineWithMarkersStyle.linewidth": number;
  /**
   * Main series Line With Markers style Price Source.
   *
   * @default 'close'
   */
  "mainSeriesProperties.lineWithMarkersStyle.priceSource": string;
}
/**
 * A chart template.
 */
export interface ChartTemplate {
  /**
   * The template content.
   */
  content?: ChartTemplateContent;
}
/**
 * Chart template content. The properties of the chart that are saved/loaded when the library saves/loads a chart template.
 */
export interface ChartTemplateContent {
  [key: string]: any;
  /**
   * Chart properties (for example color, etc).
   */
  chartProperties?: {
    /**
     * Chart pane properties.
     */
    paneProperties: any;
    /**
     * Chart scales properties.
     */
    scalesProperties: any;
  };
  /**
   * Series properties (for example chart style, etc).
   */
  mainSourceProperties?: any;
  /**
   * The version of the chart template.
   */
  version?: number;
}
export interface ChartingLibraryWidgetConstructor {
  /**
   * Constructor for the Advanced Charts Widget
   * @param  {ChartingLibraryWidgetOptions|TradingTerminalWidgetOptions} options - Constructor options
   */
  new (
    options: ChartingLibraryWidgetOptions | TradingTerminalWidgetOptions
  ): IChartingLibraryWidget;
}
export interface ChartingLibraryWidgetOptions {
  /**
   * The `container` can either be a reference to an attribute of a DOM element inside which the iframe with the chart will be placed or the `HTMLElement` itself.
   *
   * ```javascript
   * container: "tv_chart_container",
   * ```
   *
   * or
   *
   * ```javascript
   * container: document.getElementById("tv_chart_container"),
   * ```
   */
  container: HTMLElement | string;
  /**
   * JavaScript object that implements the datafeed interface ({@link IBasicDataFeed}) to supply the chart with data. See [Connecting Data](https://www.tradingview.com/charting-library-docs/latest/connecting_data/connecting_data.md) for more information on the JS API.
   *
   * ```javascript
   * datafeed: new Datafeeds.UDFCompatibleDatafeed("https://demo_feed.tradingview.com")
   * ```
   */
  datafeed: IBasicDataFeed | (IBasicDataFeed & IDatafeedQuotesApi);
  /**
   * The default interval for the chart.
   *
   * Example:
   * ```javascript
   * interval: '1D',
   * ```
   */
  interval: ResolutionString;
  /**
   * The default symbol for the chart.
   *
   * Example:
   * ```javascript
   * symbol: 'AAPL',
   * ```
   */
  symbol?: string;
  /**
   * A threshold delay in seconds that is used to reduce the number of `onAutoSaveNeeded` calls.
   *
   * ```javascript
   * auto_save_delay: 5,
   * ```
   */
  auto_save_delay?: number;
  /**
   * Boolean value showing whether the chart should use all the available space in the container and resize when the container itself is resized.
   * @default false
   *
   * ```javascript
   * autosize: true,
   * ```
   */
  autosize?: boolean;
  /**
   * Setting this property to `true` will make the chart write detailed API logs into the browser console.
   * Alternatively, you can use the `charting_library_debug_mode` featureset to enable it, or use the `setDebugMode` widget method ({@link IChartingLibraryWidget.setDebugMode}) .
   *
   * ```javascript
   * debug: true,
   * ```
   */
  debug?: boolean;
  /**
   * The array containing names of features that should be disabled by default. `Feature` means part of the functionality of the chart (part of the UI/UX). Supported features are listed in [Featuresets](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md).
   *
   * Example:
   * ```javascript
   * disabled_features: ["header_widget", "left_toolbar"],
   * ```
   */
  disabled_features?: ChartingLibraryFeatureset[];
  /**
   * You can hide some drawings from the toolbar or add custom restrictions for applying them to the chart.
   *
   * This property has the same structure as the `studies_access` argument. Use the same names as you see in the UI.
   *
   * **Remark**: There is a special case for font-based drawings. Use the "Font Icons" name for them.
   * Those drawings cannot be enabled or disabled separately - the entire group will have to be either enabled or disabled.
   *
   * @example
   * ```javascript
   * drawings_access: {
   *     type: 'black',
   *     tools: [
   *         {
   *             name: 'Trend Line',
   *             grayed: true
   *         },
   *     ]
   * },
   * ```
   */
  drawings_access?: AccessList;
  /**
   * The array containing names of features that should be enabled by default. `Feature` means part of the functionality of the chart (part of the UI/UX). Supported features are listed in [Featuresets](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md).
   *
   * Example:
   * ```javascript
   * enabled_features: ["move_logo_to_main_pane"],
   * ```
   */
  enabled_features?: ChartingLibraryFeatureset[];
  /**
   * Boolean value showing whether the chart should use all the available space in the window.
   * @default false
   *
   * ```javascript
   * fullscreen: true,
   * ```
   */
  fullscreen?: boolean;
  /**
   * A path to a `static` folder.
   *
   * ```javascript
   * library_path: "charting_library/",
   * ```
   *
   * * If you would like to host the library on a separate origin to the page containing the chart then please view the following guide: [Hosting the library on a separate origin](https://www.tradingview.com/charting-library-docs/latest/getting_started/Hosting-Library-Cross-Origin.md).
   */
  library_path?: string;
  /**
   * Locale to be used by the library. See [Localization](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Localization.md) section for details.
   *
   * ```javascript
   * locale: 'en',
   * ```
   */
  locale: LanguageCode;
  /**
   * The object containing formatting options for numbers. The only possible option is `decimal_sign` currently.
   *
   * ```javascript
   * numeric_formatting: { decimal_sign: "," },
   * ```
   */
  numeric_formatting?: NumericFormattingParams;
  /**
   * JS object containing saved chart content.
   * Use this parameter when creating the widget if you have a saved chart already.
   * If you want to load the chart content when the chart is initialized then use `load()` method ({@link IChartingLibraryWidget.load}) of the widget.
   */
  saved_data?: object;
  /**
   * JS object containing saved chart content meta info.
   */
  saved_data_meta_info?: SavedStateMetaInfo;
  /**
   * You can hide some studies from the toolbar or add custom restrictions for applying them to the chart.
   *
   * @example
   * ```javascript
   * studies_access: {
   *     type: "black" | "white",
   *     tools: [
   *         {
   *             name: "<study name>",
   *             grayed: true
   *         },
   *         < ... >
   *     ]
   * }
   * ```
   */
  studies_access?: AccessList;
  /**
   * Maximum amount of studies allowed at one time within the layout. Minimum value is 2.
   *
   * ```javascript
   * study_count_limit: 5,
   * ```
   */
  study_count_limit?: number;
  /**
   * A threshold delay in milliseconds that is used to reduce the number of search requests when the user enters the symbol name in the [Symbol Search](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Symbol-Search.md).
   *
   * ```javascript
   * symbol_search_request_delay: 1000,
   * ```
   */
  symbol_search_request_delay?: number;
  /**
   * Sets the default time frame of the chart.
   *
   * The time frame can be relative to the current date, or a range.
   *
   * A relative time frame is a number with a letter D for days and M for months:
   *
   * ```javascript
   * timeframe: '3M',
   * ```
   *
   * A range is an object with to and from properties. The to and from properties should be UNIX timestamps:
   *
   * ```javascript
   * timeframe: { from: 1640995200, to: 1643673600 } // from 2022-01-01 to 2022-02-01
   * ```
   *
   * **Note**:
   * When using a range the chart will still request data up to the current date. This is to enable scrolling forward in time once the chart has loaded.
   */
  timeframe?: TimeframeOption;
  /**
   * Default time zone of the chart. The time on the timescale is displayed according to this time zone.
   * See the [list of supported time zones](https://www.tradingview.com/charting-library-docs/latest/ui_elements/timezones.md#supported-time-zones) for available values. Set it to `exchange` to use the exchange time zone. Use the {@link ChartingLibraryWidgetOptions.overrides} section if you wish to override the default value.
   *
   * ```javascript
   * timezone: "America/New_York",
   * ```
   */
  timezone?: "exchange" | Timezone;
  /**
   * Background color of the toolbars.
   *
   * ```javascript
   * toolbar_bg: '#f4f7f9',
   * ```
   */
  toolbar_bg?: string;
  /**
   * The desired width of a widget. Please make sure that there is enough space for the widget to be displayed correctly.
   *
   * ```javascript
   * width: 300,
   * ```
   *
   * **Remark**: If you want the chart to use all the available space use the `fullscreen` parameter instead of setting it to '100%'.
   */
  width?: number;
  /**
   * The desired height of a widget. Please make sure that there is enough space for the widget to be displayed correctly.
   *
   * ```javascript
   * height: 600,
   * ```
   *
   * **Remark**: If you want the chart to use all the available space use the `fullscreen` parameter instead of setting it to '100%'.
   */
  height?: number;
  /**
   * Set the storage URL endpoint for use with the high-level saving/loading chart API.
   * Refer to [Save and load REST API](https://www.tradingview.com/charting-library-docs/latest/saving_loading/save-load-rest-api/save-load-rest-api.md) for more information.
   *
   * ```javascript
   * charts_storage_url: 'http://storage.yourserver.com',
   * ```
   */
  charts_storage_url?: string;
  /**
   * A version of your backend. Supported values are: `"1.0"` | `"1.1"`. Study Templates are supported starting from version `"1.1"`.
   *
   * ```javascript
   * charts_storage_api_version: "1.1",
   * ```
   */
  charts_storage_api_version?: AvailableSaveloadVersions;
  /**
   * Set the client ID for the high-level saving / loading charts API.
   * Refer to [Saving and Loading Charts](https://www.tradingview.com/charting-library-docs/latest/saving_loading/saving_loading.md) for more information.
   *
   * ```javascript
   * client_id: 'yourserver.com',
   * ```
   */
  client_id?: string;
  /**
   * Set the user ID for the high-level saving / loading charts API.
   * Refer to [Saving and Loading Charts](https://www.tradingview.com/charting-library-docs/latest/saving_loading/saving_loading.md) for more information.
   *
   * ```javascript
   * user_id: 'public_user_id',
   * ```
   */
  user_id?: string;
  /**
   * Set this parameter to `true` if you want the library to load the last saved chart for a user. You should implement [save/load](https://www.tradingview.com/charting-library-docs/latest/saving_loading/saving_loading.md) first to make it work.
   *
   * ```javascript
   * load_last_chart: true,
   * ```
   */
  load_last_chart?: boolean;
  /**
   * Use this option to customize the style or inputs of the indicators.
   * You can also customize the styles and inputs of the `Compare` series using this argument.
   * Refer to [Indicator Overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md#specify-default-properties) for more information.
   * Overrides for built-in indicators are listed in {@link StudyOverrides}.
   *
   * ```javascript
   * studies_overrides: {
   *     "volume.volume.color.0": "#00FFFF",
   * },
   * ```
   */
  studies_overrides?: Partial<StudyOverrides>;
  /**
   * Custom formatters for adjusting the display format of price, date, and time values.
   *
   * Example:
   *
   * ```javascript
   * custom_formatters: {
   * timeFormatter: {
   * 	format: (date) => {
   * 		const _format_str = '%h:%m';
   * 		return _format_str
   * 			.replace('%h', date.getUTCHours(), 2)
   * 			.replace('%m', date.getUTCMinutes(), 2)
   * 			.replace('%s', date.getUTCSeconds(), 2);
   * 	}
   * },
   * dateFormatter: {
   * 	format: (date) => {
   * 		return date.getUTCFullYear() + '/' + (date.getUTCMonth() + 1) + '/' + date.getUTCDate();
   * 	}
   * },
   * tickMarkFormatter: (date, tickMarkType) => {
   * 	switch (tickMarkType) {
   * 		case 'Year':
   * 			return 'Y' + date.getUTCFullYear();
   *
   * 		case 'Month':
   * 			return 'M' + (date.getUTCMonth() + 1);
   *
   * 		case 'DayOfMonth':
   * 			return 'D' + date.getUTCDate();
   *
   * 		case 'Time':
   * 			return 'T' + date.getUTCHours() + ':' + date.getUTCMinutes();
   *
   * 		case 'TimeWithSeconds':
   * 			return 'S' + date.getUTCHours() + ':' + date.getUTCMinutes() + ':' + date.getUTCSeconds();
   * 	}
   *
   * 	throw new Error('unhandled tick mark type ' + tickMarkType);
   * },
   * priceFormatterFactory: (symbolInfo, minTick) => {
   * 	if (symbolInfo?.fractional || minTick !== 'default' && minTick.split(',')[2] === 'true') {
   * 		return {
   * 			format: (price, signPositive) => {
   * 				// return the appropriate format
   * 			},
   * 		};
   * 	}
   * 	return null; // this is to use default formatter;
   * },
   * studyFormatterFactory: (format, symbolInfo) => {
   *     if (format.type === 'price') {
   *         const numberFormat = new Intl.NumberFormat('en-US', { notation: 'scientific' });
   *         return {
   *             format: (value) => numberFormat.format(value)
   *         };
   *     }
   *
   *     if (format.type === 'volume') {
   *         return {
   *             format: (value) => (value / 1e9).toPrecision(format?.precision || 2) + 'B'
   *         };
   *     }
   *
   *     if (format.type === 'percent') {
   *         return {
   *             format: (value) => `${value.toPrecision(format?.precision || 4)} percent`
   *         };
   *     }
   *
   *     return null; // this is to use default formatter;
   * },
   * }
   * ```
   *
   * **Remark**: `tickMarkFormatter` must display the UTC date, and not the date corresponding to your local timezone.
   */
  custom_formatters?: CustomFormatters;
  /**
   * Override values for the default widget properties
   * You can override most of the properties (which also may be edited by user through UI)
   * using `overrides` parameter of Widget Constructor. `overrides` is supposed to be an object.
   * The keys of this object are the names of overridden properties.
   * The values of these keys are the new values of the properties.
   *
   * Example:
   * ```javascript
   * overrides: {
   *     "mainSeriesProperties.style": 2
   * }
   * ```
   * This code will change the default series style to "line".
   * All customizable properties are listed in [separate article](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Overrides.md).
   */
  overrides?: Partial<WidgetOverrides>;
  /**
   * This URL is used to send a POST request with binary chart snapshots when a user presses the [snapshot](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Snapshots.md) button.
   * This POST request contains `multipart/form-data` with the field `preparedImage` that represents binary data of the snapshot image in `image/png` format.
   *
   * This endpoint should return the full URL of the saved image in the response.
   *
   * ```javascript
   * snapshot_url: "https://myserver.com/snapshot",
   * ```
   */
  snapshot_url?: string;
  /**
   * List of visible time frames that can be selected at the bottom of the chart. See [Time frame toolbar](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Time-Scale.md#time-frame-toolbar) for more information. Time frame is an object containing the following properties:
   *
   * Example:
   *
   * ```javascript
   * time_frames: [
   *     { text: "50y", resolution: "6M", description: "50 Years" },
   *     { text: "3y", resolution: "1W", description: "3 Years", title: "3yr" },
   *     { text: "8m", resolution: "1D", description: "8 Month" },
   *     { text: "3d", resolution: "5", description: "3 Days" },
   *     { text: "1000y", resolution: "1W", description: "All", title: "All" },
   * ]
   * ```
   */
  time_frames?: TimeFrameItem[];
  /**
   * Adds your custom CSS to the chart. `url` should be an absolute or relative path to the `static` folder.
   *
   * ```javascript
   * custom_css_url: 'css/style.css',
   * ```
   */
  custom_css_url?: string;
  /**
   * Changes the font family used on the chart including the [time scale](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Time-Scale.md), [price scale](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Price-Scale.md), and chart's pane.
   * If you want to customize fonts outside the chart, for example, within [Watchlist](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/Watch-List.md) or another widget,
   * you should use the {@link ChartingLibraryWidgetOptions.custom_css_url} property to provide custom CSS styles.
   *
   * Specify `custom_font_family` in [Widget Constructor](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Widget-Constructor.md) as follows:
   *
   * ```javascript
   * custom_font_family: "'Inconsolata', monospace",
   * ```
   *
   * The `custom_font_family` value should have the same format as the `font-family` property in CSS.
   * To use a font that is not available by default on your system, you should first add this font to your [custom CSS](#custom_css_url).
   * For example, the code sample below imports a Google font into your custom CSS:
   *
   * ```css
   * @import url('https://fonts.googleapis.com/css2?family=Inconsolata:wght@500&display=swap');
   * ```
   *
   */
  custom_font_family?: string;
  /**
   * Elements that should be marked as favorites for a new browser or user.
   * You can use this property to specify default favorite chart types, drawings, indicators, and resolutions.
   * To do this, assign a {@link Favorites} object to `favorites`. The example of such object is demonstrated below.
   *
   * ```javascript
   * favorites: {
   *     intervals: ["1D", "3D", "3W", "W", "M"],
   *     indicators: ["Awesome Oscillator", "Bollinger Bands"],
   *     drawingTools: ['LineToolBrush', 'LineToolCallout', 'LineToolCircle'],
   *     chartTypes: ['Area', 'Candles'],
   * },
   * ```
   *
   * To allow users to add/remove items from favorites, enable the [`items_favoriting`](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#items_favoriting) featureset.
   *
   * Note that favorites saved in [`localStorage`](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage) take precedence over the ones specified in the `favorites` property.
   * Therefore, the library tries to load the favorites from `localStorage` first, and then use the elements in `favorites` if there is nothing saved in `localStorage`.
   * If you want the elements specified within `favorites` to always apply, disable `localStorage` using the [`use_localstorage_for_settings`](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#use_localstorage_for_settings) featureset.
   *
   * You can also use {@link ChartingLibraryWidgetOptions.settings_adapter} to store favorites. These favorites take precedence over favorites in the `favorites` property and `localStorage`.
   * Refer to the [Customization precedence](https://www.tradingview.com/charting-library-docs/latest/customization/customization-precedence.md) article to learn more about the application order of different approaches for changing the chart appearance and behavior.
   */
  favorites?: Favorites<ChartTypeFavorites>;
  /**
   * An object containing the save/load functions.
   * It is used to implement a custom save/load algorithm.
   * Refer to [API handlers](https://www.tradingview.com/charting-library-docs/latest/saving_loading/save-load-adapter.md) for more information.
   */
  save_load_adapter?: IExternalSaveLoadAdapter;
  /**
   * Customization of the loading spinner. Value is an object with the following possible keys:
   *
   * * `backgroundColor`
   * * `foregroundColor`
   *
   * Example:
   *
   * ```javascript
   * loading_screen: { backgroundColor: "#000000" }
   * ```
   */
  loading_screen?: LoadingScreenOptions;
  /**
   * An object that contains set/remove functions. Use it to save [user settings](https://www.tradingview.com/charting-library-docs/latest/saving_loading/user-settings.md) to your preferred storage, including the server-side one.
   *
   * Example:
   * ```javascript
   * settings_adapter: {
   *     initialSettings: { ... },
   *     setValue: function(key, value) { ... },
   *     removeValue: function(key) { ... },
   * }
   * ```
   */
  settings_adapter?: ISettingsAdapter;
  /**
   * Set predefined custom theme color for the chart. Supported values are: `"light"` | `"dark"`.
   *
   * ```javascript
   * theme: "light",
   * ```
   */
  theme?: ThemeName;
  /**
   * an array of custom compare symbols for the Compare window.
   *
   * Example:
   * ```javascript
   * compare_symbols: [
   *     { symbol: 'DAL', title: 'Delta Air Lines' },
   *     { symbol: 'VZ', title: 'Verizon' },
   *     ...
   * ];
   * ```
   */
  compare_symbols?: CompareSymbol[];
  /**
   * Function that returns a Promise object with an array of your custom indicators.
   *
   * `PineJS` variable will be passed as the first argument of this function and can be used inside your indicators to access internal helper functions.
   *
   * Refer to [Custom indicators](https://www.tradingview.com/charting-library-docs/latest/custom_studies/custom_studies.md) for more information.
   *
   * ```javascript
   * custom_indicators_getter: function(PineJS) {
   *     return Promise.resolve([
   *         // *** your indicator object, created from the template ***
   *     ]);
   * },
   * ```
   */
  custom_indicators_getter?: (
    PineJS: PineJS
  ) => Promise<readonly CustomIndicator[]>;
  /**
   * An optional field containing an array of custom symbol info fields to be shown in the Symbol Info dialog.
   *
   * Refer to [Symbology](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Symbology.md) for more information about symbol info.
   *
   * ```javascript
   * additional_symbol_info_fields: [
   *     { title: 'Ticker', propertyName: 'ticker' }
   * ]
   * ```
   */
  additional_symbol_info_fields?: AdditionalSymbolInfoField[];
  /**
   * An additional optional field to change the look and feel of buttons on the top toolbar.
   *
   * By default (if option is omitted) header will be in adaptive mode (fullsize if the window width allows and icons on smaller windows).
   *
   * Example:
   * ```javascript
   * header_widget_buttons_mode: 'fullsize',
   * ```
   */
  header_widget_buttons_mode?: HeaderWidgetButtonsMode;
  /**
   * Use this property to override the [context menu](https://www.tradingview.com/charting-library-docs/latest/ui_elements/context-menu.md). You can also change the menu on the fly using the {@link IChartingLibraryWidget.onContextMenu} method.
   */
  context_menu?: ContextMenuOptions;
  /**
   * An additional optional field to add more bars on screen.
   *
   * Example:
   * ```javascript
   * time_scale: {
   *     min_bar_spacing: 10,
   * }
   * ```
   */
  time_scale?: TimeScaleOptions;
  /**
   * Use this property to set your own translation function. `key` and `options` will be passed to the function.
   *
   * You can use this function to provide custom translations for some strings.
   *
   * The function should return either a string with a new translation or `null` to fallback to the default translation.
   *
   * For example, if you want to rename "Trend Line" shape to "Line Shape", then you can do something like this:
   *
   * ```javascript
   * custom_translate_function: (key, options, isTranslated) => {
   *     if (key === 'Trend Line') {
   *         // patch the title of trend line
   *         return 'Line Shape';
   *     }
   *
   *     return null;
   * }
   * ```
   */
  custom_translate_function?: CustomTranslateFunction;
  /**
   * Use this property to set a function to override the symbol input from the [Symbol Search](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Symbol-Search.md).
   *
   * For example, you may want to get additional input from the user before deciding which symbol should be resolved.
   *
   * The function should take two parameters: a `string` of input from the Symbol Search and a optional search result item. It should return a `Promise` that resolves with a symbol ticker and a human-friendly symbol name.
   *
   * **NOTE:** This override is not called when adding a symbol to the watchlist.
   *
   * ```typescript
   * {
   *     // `SearchSymbolResultItem` is the same interface as for items returned to the Datafeed's searchSymbols result callback.
   *     symbol_search_complete: (symbol: string, searchResultItem?: SearchSymbolResultItem) => {
   *         return new Promise((resolve) => {
   *             let symbol = getNewSymbol(symbol, searchResultItem);
   *             let name = getHumanFriendlyName(symbol, searchResultItem)
   *             resolve({ symbol: symbol, name: name });
   *         });
   *     }
   * }
   * ```
   */
  symbol_search_complete?: SymbolSearchCompleteOverrideFunction;
  /**
   * The object that contains new values for values saved to the settings.
   * These overrides will replace any matching values from the settings, regardless of where the settings are loaded from (i.e. local storage or a custom settings adapter).
   * The object is similar to the [overrides](#overrides) object.
   *
   * [overrides](#overrides) will not affect values that have been saved to settings so this option can be used instead.
   *
   * ```javascript
   * settings_overrides: {
   *     "linetooltrendline.linecolor": "blue"
   * }
   * ```
   */
  settings_overrides?: Overrides;
  /**
   * List of custom time zones.
   *
   * Refer to [Timezones](https://www.tradingview.com/charting-library-docs/latest/ui_elements/timezones.md) for more information.
   */
  custom_timezones?: CustomAliasedTimezone[];
  /**
   * Use this property to set your own chart description function. `context` will be passed to the function.
   *
   * This description is read aloud by screen readers when a chart within the layout is selected via the `Tab` key.
   *
   * The function should return either a string with a description or `null` to fallback to the default description.
   *
   * ```javascript
   * custom_chart_description_function: (context) => {
   *     return Promise.resolve(`Chart ${context.chartIndex + 1} of ${context.chartCount}. ${context.chartTypeName} chart of ${context.symbol}.`);
   * }
   * ```
   */
  custom_chart_description_function?: ChartDescriptorFunction;
}
export interface CheckboxFieldMetaInfo extends CustomFieldMetaInfoBase {
  /** @inheritDoc */
  inputType: "Checkbox";
  /** @inheritDoc */
  value: boolean;
  /** Does the field support modification */
  supportModify?: boolean;
  /** Help message for the field */
  help?: string;
}
/**
 * Overrides for the 'Chop Zone' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ChopZoneIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `columns` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#000080` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Choppiness Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ChoppinessIndexIndicatorOverrides {
  /** Default value: `#2196F3` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `61.8` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `38.2` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Circle drawing tool.
 */
export interface CircleLineToolOverrides {
  /** Default value: `rgba(255, 152, 0, 0.2)` */
  "linetoolcircle.backgroundColor": string;
  /** Default value: `false` */
  "linetoolcircle.bold": boolean;
  /** Default value: `#FF9800` */
  "linetoolcircle.color": string;
  /** Default value: `true` */
  "linetoolcircle.fillBackground": boolean;
  /** Default value: `14` */
  "linetoolcircle.fontSize": number;
  /** Default value: `false` */
  "linetoolcircle.italic": boolean;
  /** Default value: `2` */
  "linetoolcircle.linewidth": number;
  /** Default value: `false` */
  "linetoolcircle.showLabel": boolean;
  /** Default value: `#FF9800` */
  "linetoolcircle.textColor": string;
}
export interface ClientSnapshotOptions {
  /** Background color */
  backgroundColor: string;
  /** Border color */
  borderColor: string;
  /** Font */
  font: string;
  /** Size of font */
  fontSize: number;
  /** Legend Mode. */
  legendMode: LegendMode;
  /** Hide resolution */
  hideResolution: boolean;
}
export interface ColumnStylePreferences {
  /** Up column color */
  upColor: string;
  /** Down column color */
  downColor: string;
  /** Color column based on previous close */
  barColorsOnPrevClose: boolean;
}
/**
 * Override properties for the Comment drawing tool.
 */
export interface CommentLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetoolcomment.backgroundColor": string;
  /** Default value: `#2962FF` */
  "linetoolcomment.borderColor": string;
  /** Default value: `#ffffff` */
  "linetoolcomment.color": string;
  /** Default value: `16` */
  "linetoolcomment.fontsize": number;
  /** Default value: `0` */
  "linetoolcomment.transparency": number;
}
/**
 * Overrides for the 'Commodity Channel Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface CommodityChannelIndexIndicatorOverrides {
  /** Default value: `#2196F3` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `100` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `-100` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  /** Default value: `0` */
  "smoothed ma.display": number;
  /** Default value: `0` */
  "smoothed ma.linestyle": number;
  /** Default value: `1` */
  "smoothed ma.linewidth": number;
  /** Default value: `line` */
  "smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "smoothed ma.transparency": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Compare' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface CompareIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `2` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#9C27B0` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Defines a custom compare symbol for the Compare dialog window
 */
export interface CompareSymbol {
  /** symbol identifier */
  symbol: string;
  /** the name of instrument that will be displayed near the corresponding checkbox */
  title: string;
}
/**
 * Overrides for the 'Connors RSI' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ConnorsRSIIndicatorOverrides {
  /** Default value: `#2196F3` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `70` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `30` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "crsi.display": number;
  /** Default value: `0` */
  "crsi.linestyle": number;
  /** Default value: `1` */
  "crsi.linewidth": number;
  /** Default value: `line` */
  "crsi.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "crsi.trackprice": boolean;
  /** Default value: `0` */
  "crsi.transparency": number;
  /** Default value: `#2196F3` */
  "crsi.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface ContextMenuItem {
  /** Position of the context menu item */
  position: "top" | "bottom";
  /** Text content for the context menu item */
  text: string;
  /** Callback event when menu item is clicked */
  click: EmptyCallback;
}
/** Use this interface to override the [context menu](https://www.tradingview.com/charting-library-docs/latest/ui_elements/context-menu.md).  */
export interface ContextMenuOptions {
  /**
   * Provide this function if you want to change the set of actions being displayed in the context menu.
   *
   * You can filter out, add yours and re-order items.
   *
   * The library will call your function each time it wants to display a context menu and will provide a list of items to display.
   * This function should return an array of items to display.
   *
   * Example:
   *
   * ```js
   * context_menu: {
   *   items_processor: function(items, actionsFactory, params) {
   *      console.log(`Menu name is: ${params.menuName}`);
   *      const newItem = actionsFactory.createAction({
   *         actionId: 'hello-world',
   *         label: 'Say Hello',
   *         onExecute: function() {
   *            alert('Hello World');
   *         },
   *      });
   *      items.unshift(newItem);
   *      return Promise.resolve(items);
   *   },
   * },
   * ```
   */
  items_processor?: ContextMenuItemsProcessor;
  /**
   * Provide this function to override the default renderer for context menu so you can adjust existing menu items.
   */
  renderer_factory?: ContextMenuRendererFactory;
}
export interface ContextMenuPosition {
  /** X (horizontal) coordinate (in pixels) at which the mouse event occurred, relative to the left edge of the applications viewport. */
  clientX: number;
  /** Y (vertical) coordinate (in pixels) at which the mouse event occurred, relative to the left edge of the applications viewport. */
  clientY: number;
  /** Touch positions */
  touches?: readonly {
    /** X (horizontal) coordinate (in pixels) at which the touch event occurred, relative to the left edge of the applications viewport. */
    clientX: number;
    /** Y (vertical) coordinate (in pixels) at which the touch event occurred, relative to the left edge of the applications viewport. */
    clientY: number;
  }[];
  /**
   * Tells what side of the context menu widget should be used to "attach" to a provided x coordinate.
   * If the value is `undefined`, then you may treat it based on whether it is rtl or not (e.g. `'right'` for rtl and `'left'` otherwise).
   * The value `'auto'` behaves as `undefined` but additionally checks if there is enough space to place the menu and if it's not then the result value is inverted.
   */
  attachToXBy?: "left" | "right" | "auto";
  /**
   * Tells what side of the context menu widget should be used to "attach" to a provided y coordinate:
   * - `'auto'` means similar to `'top'` but the menu could be expanded above the coordinate if needed (if there is no enough space to place it below)
   * - `'auto-strict'` means `'top'` if the whole menu fits the space below the coordinate and `'bottom'` otherwise (see {@link box})
   * - `'top'` means that the menu should be placed to the bottom of y coordinate (the menu should be attached by its bottom to y coordinate)
   * - `'bottom'` means that the menu should be placed above y coordinate (the menu should be attached by its top to y coordinate)
   *
   * You may treat `undefined` as `'auto'`.
   */
  attachToYBy?: "auto" | "auto-strict" | "top" | "bottom";
  /**
   * The optional structure that helps to more accurate calculate a position of the menu (see {@link attachToYBy}).
   */
  box?: {
    /** menu x coordinate */
    x: number;
    /** menu y coordinate */
    y: number;
    /** menu width */
    w: number;
    /** menu height */
    h: number;
    /** x coordinate overlaps */
    overlapX?: boolean;
  };
  /**
   * Additional horizontal margin.
   */
  marginX?: number;
  /**
   * Additional vertical margin.
   */
  marginY?: number;
}
/**
 * Overrides for the 'Coppock Curve' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface CoppockCurveIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Correlation Coefficient' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface CorrelationCoefficientIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `area` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Correlation - Log' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface CorrelationLogIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Options for creating an anchored drawing.
 */
export interface CreateAnchoredShapeOptions<TOverrides extends object>
  extends CreateShapeOptionsBase<TOverrides> {
  /**
   * A drawing to create;
   */
  shape: "anchored_text" | "anchored_note";
}
export interface CreateContextMenuParams {
  /** name of the menu */
  menuName: string;
  /**
   * Additional details for the context menu.
   * `type` field can be one of the following: `series`, `study`, `shape`, or `groupOfShapes`
   */
  detail?:
    | {
        /** series type */
        type: "series";
        /** id */
        id: string;
      }
    | {
        /** study type */
        type: "study";
        /** id */
        id: string | null;
      }
    | {
        /** shape type */
        type: "shape";
        /** id */
        id: number | string | null;
      }
    | {
        /** groupOfShapes type */
        type: "groupOfShapes";
        /** id */
        id: string | null;
      }
    | {
        /** Trading position */
        type: "position";
        /** id */
        id: string | null;
      }
    | {
        /** Trading order */
        type: "order";
        /** id */
        id: string | null;
      };
}
export interface CreateHTMLButtonOptions {
  /**
   * Alignment for the button.
   * @default 'left'
   */
  align: "left" | "right";
  /**
   * A placeholder HTMLElement will be created.
   */
  useTradingViewStyle: false;
}
/**
 * Options for creating a multipoint drawing.
 */
export interface CreateMultipointShapeOptions<TOverrides extends object>
  extends CreateShapeOptionsBase<TOverrides> {
  /**
   * A drawing to create.
   */
  shape?: Exclude<
    SupportedLineTools,
    "cursor" | "dot" | "arrow_cursor" | "eraser" | "measure" | "zoom"
  >;
}
/**
 * Options for creating a drawing.
 */
export interface CreateShapeOptions<TOverrides extends object>
  extends CreateShapeOptionsBase<TOverrides> {
  /**
   * A drawing to create.
   */
  shape?:
    | "arrow_up"
    | "arrow_down"
    | "flag"
    | "vertical_line"
    | "horizontal_line"
    | "long_position"
    | "short_position"
    | "icon"
    | "emoji"
    | "sticker"
    | "anchored_text"
    | "anchored_note";
  /**
   * The ID of an indicator that the drawing is attached to.
   * For more information, refer to the [Attach drawing to indicator](https://www.tradingview.com/charting-library-docs/latest/ui_elements/drawings/drawings-api.md#attach-drawing-to-indicator) section.
   */
  ownerStudyId?: EntityId;
}
/**
 * Options for creating a drawing.
 */
export interface CreateShapeOptionsBase<TOverrides extends object> {
  /** Text for drawing */
  text?: string;
  /** Should drawing be locked */
  lock?: boolean;
  /**
   * Disable/enable selecting the drawing.
   */
  disableSelection?: boolean;
  /**
   * Disable/enable saving the drawing.
   */
  disableSave?: boolean;
  /**
   * If `true`, users cannot cancel the drawing creation in the UI. However, users can still click the _Undo_ button to cancel previous actions.
   */
  disableUndo?: boolean;
  /**
   * Drawing properties overrides. Refer to [Shapes and Overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Shapes-and-Overrides.md) for more information.
   */
  overrides?: TOverrides;
  /**
   * Create the drawing in front of all other drawings, or behind all other drawings.
   */
  zOrder?: "top" | "bottom";
  /**
   * Enable/disable showing the drawing in the objects tree.
   */
  showInObjectsTree?: boolean;
  /**
   * The ID of an indicator that the drawing is attached to. For more information, refer to the [Attach drawing to indicator](https://www.tradingview.com/charting-library-docs/latest/ui_elements/drawings/drawings-api.md#attach-drawing-to-indicator) section.
   */
  ownerStudyId?: EntityId;
  /**
   * Enable/disable filling the drawing with color (if the drawing supports filling).
   */
  filled?: boolean;
  /**
   * Specify an icon to render. Only icons listed in [Shapes and Overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Shapes-and-Overrides.md) are supported.
   * Note that the value should be a **hex number**, not a string.
   */
  icon?: number;
}
/**
 * Options for creating a study.
 */
export interface CreateStudyOptions {
  /** if it is `true` then the study limit dialog will be shown if the limit is exceeded. */
  checkLimit?: boolean;
  /**
   * Price scale
   */
  priceScale?: StudyPriceScale;
  /** Allow the currency to be changed */
  allowChangeCurrency?: boolean;
  /** Allow the unit to be changed */
  allowChangeUnit?: boolean;
  /** prevents adding of the action to the undo stack */
  disableUndo?: boolean;
}
/**
 * Options for creating a study template.
 */
export interface CreateStudyTemplateOptions {
  /**
   * An optional boolean flag to include the symbol in the saved state.
   */
  saveSymbol?: boolean;
  /**
   * An optional boolean flag to include the interval in the saved state.
   */
  saveInterval?: boolean;
}
export interface CreateTradingViewStyledButtonOptions {
  /**
   * Alignment for the button.
   * @default 'left'
   */
  align: "left" | "right";
  /**
   * A button with the built-in styles will be created in the header.
   */
  useTradingViewStyle: true;
  /**
   * The text shown on the button.
   */
  text: string;
  /**
   * The text shown on hovering the button.
   */
  title?: string;
  /**
   * A function called when the button is clicked.
   */
  onClick?: () => void;
}
/**
 * Crosshair move event information.
 */
export interface CrossHairMovedEventParams {
  /**
   * The time coordinate of the crosshair.
   */
  time: number;
  /**
   * The price coordinate of the crosshair.
   */
  price: number;
  /**
   * Series and study values at the crosshair position. The object keys are study or series IDs, and the object value are study or series values.
   * The ID for the main series will always be the string `'_seriesId'`.
   */
  entityValues?: Record<EntityId, CrossHairMovedEventSource>;
  /**
   * X coordinate of the crosshair relative to the left edge of the element containing the library.
   */
  offsetX?: number;
  /**
   * Y coordinate of the crosshair relative to the top edge of the element containing the library.
   */
  offsetY?: number;
}
/**
 * Data source (a series or a study) values for a crosshair position.
 */
export interface CrossHairMovedEventSource {
  /**
   * `true` if the source is hovered by the crosshair `false` otherwise.
   */
  isHovered: boolean;
  /**
   * The title of the source. Matches the title shown in the data window.
   */
  title: string;
  /**
   * The values of the source. Matches the values shown in the data window.
   */
  values: CrossHairMovedEventSourceValue[];
}
export interface CrossHairMovedEventSourceValue {
  /**
   * Value title. E.g. 'open', 'high', 'change', etc. Matches the title shown in the data window.
   */
  title: string;
  /**
   * The value formatted as a string. Matches the value shown in the data window.
   */
  value: string;
}
/**
 * Override properties for the Crossline drawing tool.
 */
export interface CrosslineLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetoolcrossline.linecolor": string;
  /** Default value: `0` */
  "linetoolcrossline.linestyle": number;
  /** Default value: `2` */
  "linetoolcrossline.linewidth": number;
  /** Default value: `true` */
  "linetoolcrossline.showPrice": boolean;
  /** Default value: `true` */
  "linetoolcrossline.showTime": boolean;
}
export interface CryptoBalance {
  /** Symbol */
  symbol: string;
  /** Total balance */
  total: number;
  /** Available balance */
  available: number;
  /** Reserved balance */
  reserved?: number;
  /** Balance value */
  value?: number;
  /** Balance value's currency */
  valueCurrency?: string;
  /** Long name of Crypto */
  longName?: string;
  /** Bitcoin value of balance */
  btcValue?: number;
}
export interface CurrencyInfo {
  /**
   * Currently selected currency for the price scale.
   */
  selectedCurrency: PriceScaleSelectedCurrency;
  /**
   * Available currencies for the price scale provided by the datafeed.
   */
  currencies: string[];
}
export interface CurrencyItem {
  /** Unique ID */
  id: string;
  /** Currency code. @example `USD` */
  code: string;
  /** URL to an image of the currency. SVG logos are preferable, but please make sure that the provided image fits nicely in the currency select control (for raster images the expected size is 24x24px). */
  logoUrl?: string;
  /** Description for the currency */
  description?: string;
}
export interface CustomAliasedTimezone extends CustomTimezoneInfo {
  /**
   * Id for the custom timezone.
   */
  id: CustomTimezoneId;
}
export interface CustomComboBoxItem {
  /** Combo box item text */
  text: string;
  /** Combo box item value */
  value: string;
}
export interface CustomComboBoxMetaInfo extends CustomInputFieldMetaInfo {
  /** @inheritDoc */
  inputType: "ComboBox";
  /** Items for the combo box input field */
  items: CustomComboBoxItem[];
}
export interface CustomFieldMetaInfoBase {
  /** Type of the input field */
  inputType: string;
  /** Input field ID */
  id: string;
  /** Title for the input field */
  title: string;
  /** Value of the field */
  value?: any;
  /** Should the input field value be saved to settings */
  saveToSettings?: boolean;
}
/**
 * Custom fields to be added to an object.
 */
export interface CustomFields {
  /** Custom field */
  [key: string]: any;
}
/**  */
export interface CustomFormatter {
  /** Formats date and time */
  format(date: Date): string;
  /** Converts date and time to local time zone. */
  formatLocal(date: Date): string;
  /**
   * Returns a value in a format known by the UI.
   * Required when using `dateFormatter`, it has to return a date in the following format: `YYYY-MM-DD`.
   */
  parse(value: string): string;
}
/**
 * Formatters used to adjust the displayed format of the date and time values.
 */
export interface CustomFormatters {
  /** Used to format the time displayed in the bottom toolbar (time zone) */
  timeFormatter?: CustomFormatter;
  /**
   * Used to format the date displayed over the timescale when hovering over a chart.
   * Note that by declaring this formatter all the default ones defined in Chart settings/Scales/Date format
   * will display the exact same outcome as the formatter.
   */
  dateFormatter?: CustomFormatter;
  /**
   * Used to format date displayed in the time axis
   * **Remark**: `tickMarkFormatter` must display the UTC date, and not the date corresponding to your local time zone.
   */
  tickMarkFormatter?: (date: Date, tickMarkType: TickMarkType) => string;
  /** Used to format the number displayed in the price axis  */
  priceFormatterFactory?: SeriesFormatterFactory;
  /**
   * Used to format the numbers displayed within a custom study.
   */
  studyFormatterFactory?: CustomStudyFormatterFactory;
}
export interface CustomIndicator {
  /** Your study name, it will be used internally by the library */
  readonly name: string;
  /**
   * The metainfo field is designed to contain the main info about the custom study.
   *
   * Refer to [Custom Studies Metainfo](https://www.tradingview.com/charting-library-docs/latest/custom_studies/metainfo/metainfo.md) for more information.
   */
  readonly metainfo: StudyMetaInfo;
  /**
   * The field should contain an ES5 constructor function. The library applies the `new` operator to the constructor to create an instance of the custom indicator.
   * The constructor contains the mandatory `main` method and the optional `init` method.
   * Once the indicator instance is created, the library calls `init` (if exists) and `main` sequentially with empty context to collect information about all variables.
   *
   * Refer to the [Constructor](https://www.tradingview.com/charting-library-docs/latest/custom_studies/custom-indicator-constructor.md) article for more information.
   */
  readonly constructor:
    | LibraryPineStudyConstructor<IPineStudyResult>
    | ((this: LibraryPineStudy<IPineStudyResult>) => void);
}
export interface CustomInputFieldMetaInfo extends CustomFieldMetaInfoBase {
  /** Prevent modification */
  preventModify?: boolean;
  /** Placeholder string for the field */
  placeHolder?: string;
  /** Validator function for the field */
  validator?: InputFieldValidator;
  /** Additional custom information */
  customInfo?: any;
}
/**
 * An object that contains the results of broker specific user inputs (for example a digital signature).
 */
export interface CustomInputFieldsValues {
  [fieldId: string]: TextWithCheckboxValue | boolean | string | any;
}
/**
 * Action link to be displayed at the end of the section for the
 * status item in the pop-up tooltip.
 */
export interface CustomStatusDropDownAction {
  /**
   * Text to be displayed as the link
   */
  text: string;
  /**
   * Tooltip text to be displayed when the user hovers over
   * the action link.
   */
  tooltip?: string;
  /**
   * Callback function to be executed when the user clicks
   * on the action.
   */
  onClick: () => void;
}
/**
 * Specifies the content to be displayed within a section of
 * the pop-up tooltip which is displayed when a user clicks on
 * the symbol status items.
 *
 * The pop-up tooltip should be used to display additional
 * information related to the status item.
 */
export interface CustomStatusDropDownContent {
  /**
   * Title to be displayed next to the icon for this section
   * of the pop-up tooltip.
   */
  title: string;
  /**
   * Color to be used for the icon and title. If unspecified
   * then the color from the status item will be used.
   */
  color?: string;
  /**
   * Icon to be displayed next to the title for this section
   * of the pop-up tooltip. If unspecified then the icon from
   * the status item will be used.
   */
  icon?: string;
  /**
   * Content to the displayed within this section of the
   * pop-up tooltip.
   *
   * **It is essential to protect the content you provide
   * against cross-site scripting (XSS) attacks, as these
   * strings will be interpreted as HTML markup.**
   */
  content: string[];
  /**
   * Optional action link to be displayed at the bottom of
   * the status section.
   */
  action?: CustomStatusDropDownAction;
}
/**
 * Study format description used in custom study formatters.
 */
export interface CustomStudyFormatterFormat {
  /**
   * The format of the plot.
   */
  type: "price" | "volume" | "percent" | "inherit";
  /**
   * The format precision.
   */
  precision?: number;
}
export interface CustomTableElementFormatter<
  T extends TableFormatterInputValues = TableFormatterInputValues
> {
  /** Custom formatter name */
  name: FormatterName;
  /** Formatter to generate HTML element */
  formatElement?: CustomTableFormatElementFunction<T>;
  /** Formatter to generate text. Return an empty string if you don't need to display this */
  formatText: TableFormatTextFunction<T>;
  /** Allow usage of priceFormatter */
  isPriceFormatterNeeded?: boolean;
}
export interface CustomTimezoneInfo {
  /**
   * Timezone identifier ({@link TimezoneId}) to which this custom
   * timezone should be mapped to. This must be a timezone supported
   * by library.
   *
   * Additionally, you can specify a `Etc/GMT` timezone id.
   * In order to conform with the POSIX style, those zone names
   * beginning with "Etc/GMT" have their sign reversed from the
   * standard ISO 8601 convention. In the "Etc" area, zones west
   * of GMT have a positive sign and those east have a negative
   * sign in their name (e.g "Etc/GMT-14" is 14 hours ahead of GMT).
   */
  alias: TimezoneId | GmtTimezoneId;
  /**
   * Display name for the timezone
   */
  title: string;
}
/**
 * Additional translation options
 */
export interface CustomTranslateOptions {
  /** Plural/s of the phrase */
  plural?: string | string[];
  /** Count of the phrase */
  count?: number;
  /** Context of the phrase */
  context?: string;
  /** Replacements object */
  replace?: Record<string, string>;
}
/**
 * Override properties for the Cypherpattern drawing tool.
 */
export interface CypherpatternLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetoolcypherpattern.backgroundColor": string;
  /** Default value: `false` */
  "linetoolcypherpattern.bold": boolean;
  /** Default value: `#2962FF` */
  "linetoolcypherpattern.color": string;
  /** Default value: `true` */
  "linetoolcypherpattern.fillBackground": boolean;
  /** Default value: `12` */
  "linetoolcypherpattern.fontsize": number;
  /** Default value: `false` */
  "linetoolcypherpattern.italic": boolean;
  /** Default value: `2` */
  "linetoolcypherpattern.linewidth": number;
  /** Default value: `#ffffff` */
  "linetoolcypherpattern.textcolor": string;
  /** Default value: `85` */
  "linetoolcypherpattern.transparency": number;
}
/**
 * Depth of Market (Order Book) Data
 */
export interface DOMData {
  /**
   * Whether the Depth of Market data is a snapshot (has the full set of depth data).
   * - If `true` then the data contains the full set of depth data.
   * - If `false` then data only contains updated levels.
   */
  snapshot: boolean;
  /** Ask order levels (must be sorted by `price` in ascending order) */
  asks: DOMLevel[];
  /** Bid order levels (must be sorted by `price` in ascending order) */
  bids: DOMLevel[];
}
/**
 * Depth of Market Level
 */
export interface DOMLevel {
  /** Price for DOM level */
  price: number;
  /** Volume for DOM level */
  volume: number;
}
/**
 * Datafeed configuration data.
 * Pass the resulting array of properties as a parameter to {@link OnReadyCallback} of the [`onReady`](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Datafeed-API.md#onready) method.
 */
export interface DatafeedConfiguration {
  /**
   * List of exchange descriptors.
   * An empty array leads to an absence of the exchanges filter in the Symbol Search list.
   * Use `value=''` if you wish to include all exchanges.
   */
  exchanges?: Exchange[];
  /**
   * List of [resolutions](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution.md) that the chart should support.
   * Each item of the array is expected to be a string that has a specific [format](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution.md#resolution-format).
   * If you set this property to `undefined` or an empty array, the _Resolution_ drop-down menu displays the list of resolutions available for
   * the current symbol ({@link LibrarySymbolInfo.supported_resolutions}).
   *
   * @example
   * `["1", "15", "240", "D", "6M"]` will give you "1 minute, 15 minutes, 4 hours, 1 day, 6 months" in the _Resolution_ drop-down menu.
   */
  supported_resolutions?: ResolutionString[];
  /**
   * Supported unit groups. Each group can have several unit objects.
   *
   * @example
   * ```javascript
   * {
   *     weight: [
   *         { id: 'kg', name: 'kg', description: 'Kilograms' },
   *         { id: 'lb', name: 'lb', description: 'Pounds'},
   *     ]
   * }
   * ```
   */
  units?: Record<string, Unit[]>;
  /**
   * Supported currencies for currency conversion.
   *
   * When a currency code is supplied as a string then the library will automatically convert it to `{ id: value, code: value }` object.
   *
   * @example `["USD", "EUR", "GBP"]`
   * @example `[{ id: "USD", code: "USD", description: "$" }, { id: "EUR", code: "EUR", description: "€" }]`
   */
  currency_codes?: (string | CurrencyItem)[];
  /** Does the datafeed supports marks on bars (`true`), or not (`false | undefined`). */
  supports_marks?: boolean;
  /** Set this one to `true` if your datafeed provides server time (unix time). It is used to adjust Countdown on the Price scale. */
  supports_time?: boolean;
  /** Does the datafeed supports marks on the timescale (`true`), or not (`false | undefined`). */
  supports_timescale_marks?: boolean;
  /**
   * List of filter descriptors.
   *
   * Setting this property to `undefined` or an empty array leads to the absence of filter types in Symbol Search list. Use `value = ''` if you wish to include all filter types.
   * `value` within the descriptor will be passed as `symbolType` argument to {@link IDatafeedChartApi.searchSymbols}
   */
  symbols_types?: DatafeedSymbolType[];
  /**
   * Set it if you want to group symbols in the [Symbol Search](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Symbol-Search.md).
   * Represents an object where keys are symbol types {@link SymbolType} and values are regular expressions (each regular expression should divide an instrument name into 2 parts: a root and an expiration).
   *
   * Sample:
   * ```
   * {
   *   "futures": `/^(.+)([12]!|[FGHJKMNQUVXZ]\d{1,2})$/`,
   *   "stock": `/^(.+)([12]!|[FGHJKMNQUVXZ]\d{1,2})$/`,
   * }
   * ```
   * It will be applied to the instruments with futures and stock as a type.
   * Refer to [Symbol grouping](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Symbol-Search.md#symbol-grouping) for more information.
   */
  symbols_grouping?: Record<string, string>;
}
/** Symbol Quote Data Value */
export interface DatafeedQuoteValues {
  /** Price change (usually counts as an open price on a particular day) */
  ch?: number;
  /** Price change percentage */
  chp?: number;
  /** Short name for the symbol */
  short_name?: string;
  /** The name of the exchange */
  exchange?: string;
  /** A short description of the symbol */
  description?: string;
  /** Last traded price */
  lp?: number;
  /** Ask price */
  ask?: number;
  /** Bid price */
  bid?: number;
  /** Spread (difference between the ask and bid prices) */
  spread?: number;
  /** Today's opening price */
  open_price?: number;
  /** Today's high price */
  high_price?: number;
  /** Today's low price */
  low_price?: number;
  /** Yesterday's closing price */
  prev_close_price?: number;
  /** Today's trading volume */
  volume?: number;
  /** Original name */
  original_name?: string;
  [valueName: string]: string | number | string[] | number[] | undefined;
}
export interface DatafeedSymbolType {
  /** Name of the symbol type */
  name: string;
  /** Value to be passed as the `symbolType` argument to `searchSymbols` */
  value: string;
}
export interface DefaultContextMenuActionsParams {}
export interface DefaultDropdownActionsParams {
  /** Show trading properties */
  tradingProperties?: boolean;
  /** Restore confirmations */
  restoreConfirmations?: boolean;
}
/**
 * Overrides for the 'Detrended Price Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface DetrendedPriceOscillatorIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "dpo.display": number;
  /** Default value: `0` */
  "dpo.linestyle": number;
  /** Default value: `1` */
  "dpo.linewidth": number;
  /** Default value: `line` */
  "dpo.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "dpo.trackprice": boolean;
  /** Default value: `0` */
  "dpo.transparency": number;
  /** Default value: `#43A047` */
  "dpo.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface DialogParams<CallbackType> {
  /** Dialog title */
  title: string;
  /** Dialog content */
  body: string;
  /** Callback */
  callback: CallbackType;
}
/**
 * Overrides for the 'Directional Movement' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface DirectionalMovementIndicatorOverrides {
  /** Default value: `15` */
  "+di.display": number;
  /** Default value: `0` */
  "+di.linestyle": number;
  /** Default value: `1` */
  "+di.linewidth": number;
  /** Default value: `line` */
  "+di.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "+di.trackprice": boolean;
  /** Default value: `0` */
  "+di.transparency": number;
  /** Default value: `#2196F3` */
  "+di.color": string;
  /** Default value: `15` */
  "-di.display": number;
  /** Default value: `0` */
  "-di.linestyle": number;
  /** Default value: `1` */
  "-di.linewidth": number;
  /** Default value: `line` */
  "-di.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "-di.trackprice": boolean;
  /** Default value: `0` */
  "-di.transparency": number;
  /** Default value: `#FF6D00` */
  "-di.color": string;
  /** Default value: `15` */
  "adx.display": number;
  /** Default value: `0` */
  "adx.linestyle": number;
  /** Default value: `1` */
  "adx.linewidth": number;
  /** Default value: `line` */
  "adx.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "adx.trackprice": boolean;
  /** Default value: `0` */
  "adx.transparency": number;
  /** Default value: `#F50057` */
  "adx.color": string;
  /** Default value: `15` */
  "dx.display": number;
  /** Default value: `0` */
  "dx.linestyle": number;
  /** Default value: `1` */
  "dx.linewidth": number;
  /** Default value: `line` */
  "dx.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "dx.trackprice": boolean;
  /** Default value: `0` */
  "dx.transparency": number;
  /** Default value: `#FFA726` */
  "dx.color": string;
  /** Default value: `15` */
  "adxr.display": number;
  /** Default value: `0` */
  "adxr.linestyle": number;
  /** Default value: `1` */
  "adxr.linewidth": number;
  /** Default value: `line` */
  "adxr.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "adxr.trackprice": boolean;
  /** Default value: `0` */
  "adxr.transparency": number;
  /** Default value: `#ab47bc` */
  "adxr.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Disjointangle drawing tool.
 */
export interface DisjointangleLineToolOverrides {
  /** Default value: `rgba(8, 153, 129, 0.2)` */
  "linetooldisjointangle.backgroundColor": string;
  /** Default value: `false` */
  "linetooldisjointangle.bold": boolean;
  /** Default value: `false` */
  "linetooldisjointangle.extendLeft": boolean;
  /** Default value: `false` */
  "linetooldisjointangle.extendRight": boolean;
  /** Default value: `true` */
  "linetooldisjointangle.fillBackground": boolean;
  /** Default value: `12` */
  "linetooldisjointangle.fontsize": number;
  /** Default value: `false` */
  "linetooldisjointangle.italic": boolean;
  /** Default value: `false` */
  "linetooldisjointangle.labelBold": boolean;
  /** Default value: `14` */
  "linetooldisjointangle.labelFontSize": number;
  /** Default value: `left` */
  "linetooldisjointangle.labelHorzAlign": string;
  /** Default value: `false` */
  "linetooldisjointangle.labelItalic": boolean;
  /** Default value: `#089981` */
  "linetooldisjointangle.labelTextColor": string;
  /** Default value: `bottom` */
  "linetooldisjointangle.labelVertAlign": string;
  /** Default value: `false` */
  "linetooldisjointangle.labelVisible": boolean;
  /** Default value: `0` */
  "linetooldisjointangle.leftEnd": number;
  /** Default value: `#089981` */
  "linetooldisjointangle.linecolor": string;
  /** Default value: `0` */
  "linetooldisjointangle.linestyle": number;
  /** Default value: `2` */
  "linetooldisjointangle.linewidth": number;
  /** Default value: `0` */
  "linetooldisjointangle.rightEnd": number;
  /** Default value: `false` */
  "linetooldisjointangle.showBarsRange": boolean;
  /** Default value: `false` */
  "linetooldisjointangle.showDateTimeRange": boolean;
  /** Default value: `false` */
  "linetooldisjointangle.showPriceRange": boolean;
  /** Default value: `false` */
  "linetooldisjointangle.showPrices": boolean;
  /** Default value: `#089981` */
  "linetooldisjointangle.textcolor": string;
  /** Default value: `20` */
  "linetooldisjointangle.transparency": number;
}
/**
 * Overrides for the 'Donchian Channels' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface DonchianChannelsIndicatorOverrides {
  /** Default value: `#2196F3` */
  "plots background.color": string;
  /** Default value: `95` */
  "plots background.transparency": number;
  /** Default value: `true` */
  "plots background.visible": boolean;
  /** Default value: `15` */
  "lower.display": number;
  /** Default value: `0` */
  "lower.linestyle": number;
  /** Default value: `1` */
  "lower.linewidth": number;
  /** Default value: `line` */
  "lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lower.trackprice": boolean;
  /** Default value: `0` */
  "lower.transparency": number;
  /** Default value: `#2196F3` */
  "lower.color": string;
  /** Default value: `15` */
  "upper.display": number;
  /** Default value: `0` */
  "upper.linestyle": number;
  /** Default value: `1` */
  "upper.linewidth": number;
  /** Default value: `line` */
  "upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "upper.trackprice": boolean;
  /** Default value: `0` */
  "upper.transparency": number;
  /** Default value: `#2196F3` */
  "upper.color": string;
  /** Default value: `15` */
  "basis.display": number;
  /** Default value: `0` */
  "basis.linestyle": number;
  /** Default value: `1` */
  "basis.linewidth": number;
  /** Default value: `line` */
  "basis.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "basis.trackprice": boolean;
  /** Default value: `0` */
  "basis.transparency": number;
  /** Default value: `#FF6D00` */
  "basis.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Double EMA' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface DoubleEMAIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#43A047` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/** Item within a dropdown menu */
export interface DropdownItem {
  /** Title of the menu item */
  title: string;
  /** Callback for when the item is selected by the user */
  onSelect: () => void;
}
/** Parameters for configuring a dropdown menu */
export interface DropdownParams {
  /** Title for the dropdown menu */
  title: string;
  /** Menu items */
  items: DropdownItem[];
  /** Dropdown menu tooltip */
  tooltip?: string;
  /** Icons for the dropdown menu. (SVG mark-up) */
  icon?: string;
  /** Alignment of the dropdown menu */
  align?: "right" | "left";
}
/**
 * Overrides for the 'EMA Cross' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface EMACrossIndicatorOverrides {
  /** Default value: `15` */
  "short:plot.display": number;
  /** Default value: `0` */
  "short:plot.linestyle": number;
  /** Default value: `1` */
  "short:plot.linewidth": number;
  /** Default value: `line` */
  "short:plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "short:plot.trackprice": boolean;
  /** Default value: `0` */
  "short:plot.transparency": number;
  /** Default value: `#FF6D00` */
  "short:plot.color": string;
  /** Default value: `15` */
  "long:plot.display": number;
  /** Default value: `0` */
  "long:plot.linestyle": number;
  /** Default value: `1` */
  "long:plot.linewidth": number;
  /** Default value: `line` */
  "long:plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "long:plot.trackprice": boolean;
  /** Default value: `0` */
  "long:plot.transparency": number;
  /** Default value: `#43A047` */
  "long:plot.color": string;
  /** Default value: `15` */
  "crosses.display": number;
  /** Default value: `0` */
  "crosses.linestyle": number;
  /** Default value: `4` */
  "crosses.linewidth": number;
  /** Default value: `cross` */
  "crosses.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "crosses.trackprice": boolean;
  /** Default value: `0` */
  "crosses.transparency": number;
  /** Default value: `#2196F3` */
  "crosses.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Ease Of Movement' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface EaseOfMovementIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#43A047` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface EditObjectDialogEventParams {
  /** Dialog type */
  objectType: EditObjectDialogObjectType;
  /** Title of the object described within the dialog */
  scriptTitle: string;
}
/**
 * Overrides for the 'Elder's Force Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface EldersForceIndexIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#F23645` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Elliottcorrection drawing tool.
 */
export interface ElliottcorrectionLineToolOverrides {
  /** Default value: `#3d85c6` */
  "linetoolelliottcorrection.color": string;
  /** Default value: `7` */
  "linetoolelliottcorrection.degree": number;
  /** Default value: `2` */
  "linetoolelliottcorrection.linewidth": number;
  /** Default value: `true` */
  "linetoolelliottcorrection.showWave": boolean;
}
/**
 * Override properties for the Elliottdoublecombo drawing tool.
 */
export interface ElliottdoublecomboLineToolOverrides {
  /** Default value: `#6aa84f` */
  "linetoolelliottdoublecombo.color": string;
  /** Default value: `7` */
  "linetoolelliottdoublecombo.degree": number;
  /** Default value: `2` */
  "linetoolelliottdoublecombo.linewidth": number;
  /** Default value: `true` */
  "linetoolelliottdoublecombo.showWave": boolean;
}
/**
 * Override properties for the Elliottimpulse drawing tool.
 */
export interface ElliottimpulseLineToolOverrides {
  /** Default value: `#3d85c6` */
  "linetoolelliottimpulse.color": string;
  /** Default value: `7` */
  "linetoolelliottimpulse.degree": number;
  /** Default value: `2` */
  "linetoolelliottimpulse.linewidth": number;
  /** Default value: `true` */
  "linetoolelliottimpulse.showWave": boolean;
}
/**
 * Override properties for the Elliotttriangle drawing tool.
 */
export interface ElliotttriangleLineToolOverrides {
  /** Default value: `#FF9800` */
  "linetoolelliotttriangle.color": string;
  /** Default value: `7` */
  "linetoolelliotttriangle.degree": number;
  /** Default value: `2` */
  "linetoolelliotttriangle.linewidth": number;
  /** Default value: `true` */
  "linetoolelliotttriangle.showWave": boolean;
}
/**
 * Override properties for the Elliotttriplecombo drawing tool.
 */
export interface ElliotttriplecomboLineToolOverrides {
  /** Default value: `#6aa84f` */
  "linetoolelliotttriplecombo.color": string;
  /** Default value: `7` */
  "linetoolelliotttriplecombo.degree": number;
  /** Default value: `2` */
  "linetoolelliotttriplecombo.linewidth": number;
  /** Default value: `true` */
  "linetoolelliotttriplecombo.showWave": boolean;
}
/**
 * Override properties for the Ellipse drawing tool.
 */
export interface EllipseLineToolOverrides {
  /** Default value: `rgba(242, 54, 69, 0.2)` */
  "linetoolellipse.backgroundColor": string;
  /** Default value: `false` */
  "linetoolellipse.bold": boolean;
  /** Default value: `#F23645` */
  "linetoolellipse.color": string;
  /** Default value: `true` */
  "linetoolellipse.fillBackground": boolean;
  /** Default value: `14` */
  "linetoolellipse.fontSize": number;
  /** Default value: `false` */
  "linetoolellipse.italic": boolean;
  /** Default value: `2` */
  "linetoolellipse.linewidth": number;
  /** Default value: `false` */
  "linetoolellipse.showLabel": boolean;
  /** Default value: `#F23645` */
  "linetoolellipse.textColor": string;
  /** Default value: `50` */
  "linetoolellipse.transparency": number;
}
/**
 * Override properties for the Emoji drawing tool.
 */
export interface EmojiLineToolOverrides {
  /** Default value: `1.5707963267948966` */
  "linetoolemoji.angle": number;
  /** Default value: `😀` */
  "linetoolemoji.emoji": string;
  /** Default value: `40` */
  "linetoolemoji.size": number;
}
export interface EmojiOptions {
  /** Emoji */
  emoji: string;
}
export interface EntityInfo {
  /** Entity id (string) */
  id: EntityId;
  /** Name of entity */
  name: string;
}
/**
 * Overrides for the 'Envelopes' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface EnvelopesIndicatorOverrides {
  /** Default value: `#2196F3` */
  "plots background.color": string;
  /** Default value: `95` */
  "plots background.transparency": number;
  /** Default value: `true` */
  "plots background.visible": boolean;
  /** Default value: `15` */
  "average.display": number;
  /** Default value: `0` */
  "average.linestyle": number;
  /** Default value: `1` */
  "average.linewidth": number;
  /** Default value: `line` */
  "average.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "average.trackprice": boolean;
  /** Default value: `0` */
  "average.transparency": number;
  /** Default value: `#FF6D00` */
  "average.color": string;
  /** Default value: `15` */
  "upper.display": number;
  /** Default value: `0` */
  "upper.linestyle": number;
  /** Default value: `1` */
  "upper.linewidth": number;
  /** Default value: `line` */
  "upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "upper.trackprice": boolean;
  /** Default value: `0` */
  "upper.transparency": number;
  /** Default value: `#2196F3` */
  "upper.color": string;
  /** Default value: `15` */
  "lower.display": number;
  /** Default value: `0` */
  "lower.linestyle": number;
  /** Default value: `1` */
  "lower.linewidth": number;
  /** Default value: `line` */
  "lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lower.trackprice": boolean;
  /** Default value: `0` */
  "lower.transparency": number;
  /** Default value: `#2196F3` */
  "lower.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface ErrorFormatterParseResult extends FormatterParseResult {
  /** Optional message when there's an error while parsing */
  error?: string;
  /** @inheritDoc */
  res: false;
}
/** Exchange Description */
export interface Exchange {
  /** Value to be passed as the `exchange` argument to `searchSymbols` */
  value: string;
  /** Name of the exchange */
  name: string;
  /** Description of the exchange */
  desc: string;
}
/**
 * Describes a single execution.
 * Execution is when a buy or sell order is completed for a financial instrument.
 */
export interface Execution extends CustomFields {
  /** Symbol name */
  symbol: string;
  /** Execution price */
  price: number;
  /** Execution Quantity */
  qty: number;
  /** Execution Side */
  side: Side;
  /** Time (unix timestamp in milliseconds) */
  time: number;
  /** Commission amount for executed trade */
  commission?: number;
  /** Net amount for executed trade */
  netAmount?: number;
}
/**
 * Override properties for the Execution drawing tool.
 */
export interface ExecutionLineToolOverrides {
  /** Default value: `#4094e8` */
  "linetoolexecution.arrowBuyColor": string;
  /** Default value: `8` */
  "linetoolexecution.arrowHeight": number;
  /** Default value: `#e75656` */
  "linetoolexecution.arrowSellColor": string;
  /** Default value: `1` */
  "linetoolexecution.arrowSpacing": number;
  /** Default value: `buy` */
  "linetoolexecution.direction": string;
  /** Default value: `false` */
  "linetoolexecution.fontBold": boolean;
  /** Default value: `Verdana` */
  "linetoolexecution.fontFamily": string;
  /** Default value: `false` */
  "linetoolexecution.fontItalic": boolean;
  /** Default value: `10` */
  "linetoolexecution.fontSize": number;
  /** Default value: `` */
  "linetoolexecution.text": string;
  /** Default value: `#000000` */
  "linetoolexecution.textColor": string;
  /** Default value: `0` */
  "linetoolexecution.textTransparency": number;
  /** Default value: `` */
  "linetoolexecution.tooltip": string;
}
export interface ExportDataOptions {
  /**
   * Optional timestamp of the first exported bar.
   */
  from?: number;
  /**
   * Optional timestamp of the last exported bar.
   */
  to?: number;
  /**
   * If true then each exported data item will include a time value.
   *
   * @default true
   */
  includeTime?: boolean;
  /**
   * If true then each exported data item will include a user time value.
   * User time is the time that user sees on the chart.
   * This time depends on the selected time zone and resolution.
   *
   * @default false
   */
  includeUserTime?: boolean;
  /**
   * If true then the exported data will include open, high, low, close values from the main series.
   *
   * @default true
   */
  includeSeries?: boolean;
  /**
   * If true then the exported data will include formatted value as displayed to the user.
   *
   * @default false
   */
  includeDisplayedValues?: boolean;
  /**
   * If true then each exported data item will include a value for the specified studies.
   */
  includedStudies: readonly string[] | "all";
  /**
   * Include study data that has a positive offset from the main series data. That is study data that is "to the right of" the last main series data point.
   */
  includeOffsetStudyValues?: boolean;
}
/**
 * Export data from the chart
 */
export interface ExportedData {
  /** An array of {@link FieldDescriptor} */
  schema: FieldDescriptor[];
  /** Array of the same length as `schema` that represents the associated field's item  */
  data: Float64Array[];
  /** Array of strings that represents the display value of the associated field element */
  displayedData: string[][];
}
/**
 * Override properties for the Extended drawing tool.
 */
export interface ExtendedLineToolOverrides {
  /** Default value: `false` */
  "linetoolextended.alwaysShowStats": boolean;
  /** Default value: `false` */
  "linetoolextended.bold": boolean;
  /** Default value: `true` */
  "linetoolextended.extendLeft": boolean;
  /** Default value: `true` */
  "linetoolextended.extendRight": boolean;
  /** Default value: `14` */
  "linetoolextended.fontsize": number;
  /** Default value: `center` */
  "linetoolextended.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetoolextended.italic": boolean;
  /** Default value: `0` */
  "linetoolextended.leftEnd": number;
  /** Default value: `#2962FF` */
  "linetoolextended.linecolor": string;
  /** Default value: `0` */
  "linetoolextended.linestyle": number;
  /** Default value: `2` */
  "linetoolextended.linewidth": number;
  /** Default value: `0` */
  "linetoolextended.rightEnd": number;
  /** Default value: `false` */
  "linetoolextended.showAngle": boolean;
  /** Default value: `false` */
  "linetoolextended.showBarsRange": boolean;
  /** Default value: `false` */
  "linetoolextended.showDateTimeRange": boolean;
  /** Default value: `false` */
  "linetoolextended.showDistance": boolean;
  /** Default value: `false` */
  "linetoolextended.showLabel": boolean;
  /** Default value: `false` */
  "linetoolextended.showMiddlePoint": boolean;
  /** Default value: `false` */
  "linetoolextended.showPercentPriceRange": boolean;
  /** Default value: `false` */
  "linetoolextended.showPipsPriceRange": boolean;
  /** Default value: `false` */
  "linetoolextended.showPriceLabels": boolean;
  /** Default value: `false` */
  "linetoolextended.showPriceRange": boolean;
  /** Default value: `2` */
  "linetoolextended.statsPosition": number;
  /** Default value: `#2962FF` */
  "linetoolextended.textcolor": string;
  /** Default value: `bottom` */
  "linetoolextended.vertLabelsAlign": string;
}
/**
 * Favorites which can be defined within the Widget Constructor options (see {@link ChartingLibraryWidgetOptions.favorites}).
 */
export interface Favorites<TChartTypeFavorites> {
  /**
   * An array of time intervals that are marked as favorite.
   *
   * Example: `["D", "2D"]`
   */
  intervals?: ResolutionString[];
  /**
   * An array of indicator titles that are marked as favorite.
   * The names of indicators are identical to the `title` property of the indicator. For built-in indicators
   * this will match the chart UI in the English version.
   *
   * Example: `["Awesome Oscillator", "Bollinger Bands"]`.
   */
  indicators?: string[];
  /**
   * An array of chart types that are marked as favorite.
   * The names of chart types are listed within the {@link ChartTypeFavorites} or {@link TradingTerminalChartTypeFavorites} type.
   *
   * Example: `["Area", "Candles"]`.
   */
  chartTypes?: TChartTypeFavorites[];
  /**
   * An array of drawing tool identifiers that should be marked as favorite. These will only
   * be applied if there aren't existing favorites.
   *
   * Example: ['LineToolBrush', 'LineToolCallout', 'LineToolCircle']
   */
  drawingTools?: DrawingToolIdentifier[];
}
/**
 * Override properties for the Fibchannel drawing tool.
 */
export interface FibchannelLineToolOverrides {
  /** Default value: `false` */
  "linetoolfibchannel.coeffsAsPercents": boolean;
  /** Default value: `false` */
  "linetoolfibchannel.extendLeft": boolean;
  /** Default value: `false` */
  "linetoolfibchannel.extendRight": boolean;
  /** Default value: `true` */
  "linetoolfibchannel.fillBackground": boolean;
  /** Default value: `left` */
  "linetoolfibchannel.horzLabelsAlign": string;
  /** Default value: `12` */
  "linetoolfibchannel.labelFontSize": number;
  /** Default value: `0` */
  "linetoolfibchannel.level1.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibchannel.level1.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level1.visible": boolean;
  /** Default value: `3.618` */
  "linetoolfibchannel.level10.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolfibchannel.level10.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level10.visible": boolean;
  /** Default value: `4.236` */
  "linetoolfibchannel.level11.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibchannel.level11.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level11.visible": boolean;
  /** Default value: `1.272` */
  "linetoolfibchannel.level12.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibchannel.level12.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level12.visible": boolean;
  /** Default value: `1.414` */
  "linetoolfibchannel.level13.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibchannel.level13.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level13.visible": boolean;
  /** Default value: `2.272` */
  "linetoolfibchannel.level14.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibchannel.level14.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level14.visible": boolean;
  /** Default value: `2.414` */
  "linetoolfibchannel.level15.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibchannel.level15.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level15.visible": boolean;
  /** Default value: `2` */
  "linetoolfibchannel.level16.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibchannel.level16.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level16.visible": boolean;
  /** Default value: `3` */
  "linetoolfibchannel.level17.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibchannel.level17.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level17.visible": boolean;
  /** Default value: `3.272` */
  "linetoolfibchannel.level18.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibchannel.level18.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level18.visible": boolean;
  /** Default value: `3.414` */
  "linetoolfibchannel.level19.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibchannel.level19.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level19.visible": boolean;
  /** Default value: `0.236` */
  "linetoolfibchannel.level2.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibchannel.level2.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level2.visible": boolean;
  /** Default value: `4` */
  "linetoolfibchannel.level20.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibchannel.level20.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level20.visible": boolean;
  /** Default value: `4.272` */
  "linetoolfibchannel.level21.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolfibchannel.level21.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level21.visible": boolean;
  /** Default value: `4.414` */
  "linetoolfibchannel.level22.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibchannel.level22.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level22.visible": boolean;
  /** Default value: `4.618` */
  "linetoolfibchannel.level23.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibchannel.level23.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level23.visible": boolean;
  /** Default value: `4.764` */
  "linetoolfibchannel.level24.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibchannel.level24.color": string;
  /** Default value: `false` */
  "linetoolfibchannel.level24.visible": boolean;
  /** Default value: `0.382` */
  "linetoolfibchannel.level3.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibchannel.level3.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level3.visible": boolean;
  /** Default value: `0.5` */
  "linetoolfibchannel.level4.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibchannel.level4.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level4.visible": boolean;
  /** Default value: `0.618` */
  "linetoolfibchannel.level5.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibchannel.level5.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level5.visible": boolean;
  /** Default value: `0.786` */
  "linetoolfibchannel.level6.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibchannel.level6.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level6.visible": boolean;
  /** Default value: `1` */
  "linetoolfibchannel.level7.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibchannel.level7.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level7.visible": boolean;
  /** Default value: `1.618` */
  "linetoolfibchannel.level8.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibchannel.level8.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level8.visible": boolean;
  /** Default value: `2.618` */
  "linetoolfibchannel.level9.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibchannel.level9.color": string;
  /** Default value: `true` */
  "linetoolfibchannel.level9.visible": boolean;
  /** Default value: `0` */
  "linetoolfibchannel.levelsStyle.linestyle": number;
  /** Default value: `2` */
  "linetoolfibchannel.levelsStyle.linewidth": number;
  /** Default value: `true` */
  "linetoolfibchannel.showCoeffs": boolean;
  /** Default value: `true` */
  "linetoolfibchannel.showPrices": boolean;
  /** Default value: `80` */
  "linetoolfibchannel.transparency": number;
  /** Default value: `middle` */
  "linetoolfibchannel.vertLabelsAlign": string;
}
/**
 * Override properties for the Fibcircles drawing tool.
 */
export interface FibcirclesLineToolOverrides {
  /** Default value: `false` */
  "linetoolfibcircles.coeffsAsPercents": boolean;
  /** Default value: `true` */
  "linetoolfibcircles.fillBackground": boolean;
  /** Default value: `0.236` */
  "linetoolfibcircles.level1.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibcircles.level1.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level1.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level1.visible": boolean;
  /** Default value: `4.236` */
  "linetoolfibcircles.level10.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibcircles.level10.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level10.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level10.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level10.visible": boolean;
  /** Default value: `4.618` */
  "linetoolfibcircles.level11.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibcircles.level11.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level11.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level11.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level11.visible": boolean;
  /** Default value: `0.382` */
  "linetoolfibcircles.level2.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibcircles.level2.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level2.visible": boolean;
  /** Default value: `0.5` */
  "linetoolfibcircles.level3.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibcircles.level3.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level3.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level3.visible": boolean;
  /** Default value: `0.618` */
  "linetoolfibcircles.level4.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibcircles.level4.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level4.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level4.visible": boolean;
  /** Default value: `0.786` */
  "linetoolfibcircles.level5.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibcircles.level5.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level5.visible": boolean;
  /** Default value: `1` */
  "linetoolfibcircles.level6.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibcircles.level6.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level6.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level6.visible": boolean;
  /** Default value: `1.618` */
  "linetoolfibcircles.level7.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibcircles.level7.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level7.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level7.visible": boolean;
  /** Default value: `2.618` */
  "linetoolfibcircles.level8.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibcircles.level8.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level8.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level8.visible": boolean;
  /** Default value: `3.618` */
  "linetoolfibcircles.level9.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibcircles.level9.color": string;
  /** Default value: `0` */
  "linetoolfibcircles.level9.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.level9.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.level9.visible": boolean;
  /** Default value: `true` */
  "linetoolfibcircles.showCoeffs": boolean;
  /** Default value: `80` */
  "linetoolfibcircles.transparency": number;
  /** Default value: `#787B86` */
  "linetoolfibcircles.trendline.color": string;
  /** Default value: `2` */
  "linetoolfibcircles.trendline.linestyle": number;
  /** Default value: `2` */
  "linetoolfibcircles.trendline.linewidth": number;
  /** Default value: `true` */
  "linetoolfibcircles.trendline.visible": boolean;
}
/**
 * Override properties for the Fibretracement drawing tool.
 */
export interface FibretracementLineToolOverrides {
  /** Default value: `false` */
  "linetoolfibretracement.coeffsAsPercents": boolean;
  /** Default value: `false` */
  "linetoolfibretracement.extendLines": boolean;
  /** Default value: `false` */
  "linetoolfibretracement.extendLinesLeft": boolean;
  /** Default value: `false` */
  "linetoolfibretracement.fibLevelsBasedOnLogScale": boolean;
  /** Default value: `true` */
  "linetoolfibretracement.fillBackground": boolean;
  /** Default value: `left` */
  "linetoolfibretracement.horzLabelsAlign": string;
  /** Default value: `12` */
  "linetoolfibretracement.labelFontSize": number;
  /** Default value: `0` */
  "linetoolfibretracement.level1.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibretracement.level1.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level1.visible": boolean;
  /** Default value: `3.618` */
  "linetoolfibretracement.level10.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolfibretracement.level10.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level10.visible": boolean;
  /** Default value: `4.236` */
  "linetoolfibretracement.level11.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibretracement.level11.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level11.visible": boolean;
  /** Default value: `1.272` */
  "linetoolfibretracement.level12.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibretracement.level12.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level12.visible": boolean;
  /** Default value: `1.414` */
  "linetoolfibretracement.level13.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibretracement.level13.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level13.visible": boolean;
  /** Default value: `2.272` */
  "linetoolfibretracement.level14.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibretracement.level14.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level14.visible": boolean;
  /** Default value: `2.414` */
  "linetoolfibretracement.level15.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibretracement.level15.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level15.visible": boolean;
  /** Default value: `2` */
  "linetoolfibretracement.level16.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibretracement.level16.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level16.visible": boolean;
  /** Default value: `3` */
  "linetoolfibretracement.level17.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibretracement.level17.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level17.visible": boolean;
  /** Default value: `3.272` */
  "linetoolfibretracement.level18.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibretracement.level18.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level18.visible": boolean;
  /** Default value: `3.414` */
  "linetoolfibretracement.level19.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibretracement.level19.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level19.visible": boolean;
  /** Default value: `0.236` */
  "linetoolfibretracement.level2.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibretracement.level2.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level2.visible": boolean;
  /** Default value: `4` */
  "linetoolfibretracement.level20.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibretracement.level20.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level20.visible": boolean;
  /** Default value: `4.272` */
  "linetoolfibretracement.level21.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolfibretracement.level21.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level21.visible": boolean;
  /** Default value: `4.414` */
  "linetoolfibretracement.level22.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibretracement.level22.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level22.visible": boolean;
  /** Default value: `4.618` */
  "linetoolfibretracement.level23.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibretracement.level23.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level23.visible": boolean;
  /** Default value: `4.764` */
  "linetoolfibretracement.level24.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibretracement.level24.color": string;
  /** Default value: `false` */
  "linetoolfibretracement.level24.visible": boolean;
  /** Default value: `0.382` */
  "linetoolfibretracement.level3.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibretracement.level3.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level3.visible": boolean;
  /** Default value: `0.5` */
  "linetoolfibretracement.level4.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibretracement.level4.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level4.visible": boolean;
  /** Default value: `0.618` */
  "linetoolfibretracement.level5.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibretracement.level5.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level5.visible": boolean;
  /** Default value: `0.786` */
  "linetoolfibretracement.level6.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibretracement.level6.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level6.visible": boolean;
  /** Default value: `1` */
  "linetoolfibretracement.level7.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibretracement.level7.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level7.visible": boolean;
  /** Default value: `1.618` */
  "linetoolfibretracement.level8.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibretracement.level8.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level8.visible": boolean;
  /** Default value: `2.618` */
  "linetoolfibretracement.level9.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibretracement.level9.color": string;
  /** Default value: `true` */
  "linetoolfibretracement.level9.visible": boolean;
  /** Default value: `0` */
  "linetoolfibretracement.levelsStyle.linestyle": number;
  /** Default value: `2` */
  "linetoolfibretracement.levelsStyle.linewidth": number;
  /** Default value: `false` */
  "linetoolfibretracement.reverse": boolean;
  /** Default value: `true` */
  "linetoolfibretracement.showCoeffs": boolean;
  /** Default value: `true` */
  "linetoolfibretracement.showPrices": boolean;
  /** Default value: `80` */
  "linetoolfibretracement.transparency": number;
  /** Default value: `#787B86` */
  "linetoolfibretracement.trendline.color": string;
  /** Default value: `2` */
  "linetoolfibretracement.trendline.linestyle": number;
  /** Default value: `2` */
  "linetoolfibretracement.trendline.linewidth": number;
  /** Default value: `true` */
  "linetoolfibretracement.trendline.visible": boolean;
  /** Default value: `bottom` */
  "linetoolfibretracement.vertLabelsAlign": string;
}
/**
 * Override properties for the Fibspeedresistancearcs drawing tool.
 */
export interface FibspeedresistancearcsLineToolOverrides {
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.fillBackground": boolean;
  /** Default value: `false` */
  "linetoolfibspeedresistancearcs.fullCircles": boolean;
  /** Default value: `0.236` */
  "linetoolfibspeedresistancearcs.level1.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibspeedresistancearcs.level1.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level1.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level1.visible": boolean;
  /** Default value: `4.236` */
  "linetoolfibspeedresistancearcs.level10.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibspeedresistancearcs.level10.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level10.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level10.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level10.visible": boolean;
  /** Default value: `4.618` */
  "linetoolfibspeedresistancearcs.level11.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibspeedresistancearcs.level11.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level11.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level11.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level11.visible": boolean;
  /** Default value: `0.382` */
  "linetoolfibspeedresistancearcs.level2.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibspeedresistancearcs.level2.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level2.visible": boolean;
  /** Default value: `0.5` */
  "linetoolfibspeedresistancearcs.level3.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibspeedresistancearcs.level3.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level3.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level3.visible": boolean;
  /** Default value: `0.618` */
  "linetoolfibspeedresistancearcs.level4.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibspeedresistancearcs.level4.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level4.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level4.visible": boolean;
  /** Default value: `0.786` */
  "linetoolfibspeedresistancearcs.level5.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibspeedresistancearcs.level5.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level5.visible": boolean;
  /** Default value: `1` */
  "linetoolfibspeedresistancearcs.level6.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibspeedresistancearcs.level6.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level6.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level6.visible": boolean;
  /** Default value: `1.618` */
  "linetoolfibspeedresistancearcs.level7.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibspeedresistancearcs.level7.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level7.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level7.visible": boolean;
  /** Default value: `2.618` */
  "linetoolfibspeedresistancearcs.level8.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibspeedresistancearcs.level8.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level8.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level8.visible": boolean;
  /** Default value: `3.618` */
  "linetoolfibspeedresistancearcs.level9.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibspeedresistancearcs.level9.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancearcs.level9.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.level9.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.level9.visible": boolean;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.showCoeffs": boolean;
  /** Default value: `80` */
  "linetoolfibspeedresistancearcs.transparency": number;
  /** Default value: `#787B86` */
  "linetoolfibspeedresistancearcs.trendline.color": string;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.trendline.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancearcs.trendline.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancearcs.trendline.visible": boolean;
}
/**
 * Override properties for the Fibspeedresistancefan drawing tool.
 */
export interface FibspeedresistancefanLineToolOverrides {
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.fillBackground": boolean;
  /** Default value: `rgba(21, 56, 153, 0.8)` */
  "linetoolfibspeedresistancefan.grid.color": string;
  /** Default value: `0` */
  "linetoolfibspeedresistancefan.grid.linestyle": number;
  /** Default value: `1` */
  "linetoolfibspeedresistancefan.grid.linewidth": number;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.grid.visible": boolean;
  /** Default value: `0` */
  "linetoolfibspeedresistancefan.hlevel1.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibspeedresistancefan.hlevel1.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.hlevel1.visible": boolean;
  /** Default value: `0.25` */
  "linetoolfibspeedresistancefan.hlevel2.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibspeedresistancefan.hlevel2.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.hlevel2.visible": boolean;
  /** Default value: `0.382` */
  "linetoolfibspeedresistancefan.hlevel3.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibspeedresistancefan.hlevel3.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.hlevel3.visible": boolean;
  /** Default value: `0.5` */
  "linetoolfibspeedresistancefan.hlevel4.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibspeedresistancefan.hlevel4.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.hlevel4.visible": boolean;
  /** Default value: `0.618` */
  "linetoolfibspeedresistancefan.hlevel5.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibspeedresistancefan.hlevel5.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.hlevel5.visible": boolean;
  /** Default value: `0.75` */
  "linetoolfibspeedresistancefan.hlevel6.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibspeedresistancefan.hlevel6.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.hlevel6.visible": boolean;
  /** Default value: `1` */
  "linetoolfibspeedresistancefan.hlevel7.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibspeedresistancefan.hlevel7.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.hlevel7.visible": boolean;
  /** Default value: `0` */
  "linetoolfibspeedresistancefan.linestyle": number;
  /** Default value: `2` */
  "linetoolfibspeedresistancefan.linewidth": number;
  /** Default value: `false` */
  "linetoolfibspeedresistancefan.reverse": boolean;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.showBottomLabels": boolean;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.showLeftLabels": boolean;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.showRightLabels": boolean;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.showTopLabels": boolean;
  /** Default value: `80` */
  "linetoolfibspeedresistancefan.transparency": number;
  /** Default value: `0` */
  "linetoolfibspeedresistancefan.vlevel1.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibspeedresistancefan.vlevel1.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.vlevel1.visible": boolean;
  /** Default value: `0.25` */
  "linetoolfibspeedresistancefan.vlevel2.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibspeedresistancefan.vlevel2.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.vlevel2.visible": boolean;
  /** Default value: `0.382` */
  "linetoolfibspeedresistancefan.vlevel3.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibspeedresistancefan.vlevel3.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.vlevel3.visible": boolean;
  /** Default value: `0.5` */
  "linetoolfibspeedresistancefan.vlevel4.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibspeedresistancefan.vlevel4.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.vlevel4.visible": boolean;
  /** Default value: `0.618` */
  "linetoolfibspeedresistancefan.vlevel5.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibspeedresistancefan.vlevel5.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.vlevel5.visible": boolean;
  /** Default value: `0.75` */
  "linetoolfibspeedresistancefan.vlevel6.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibspeedresistancefan.vlevel6.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.vlevel6.visible": boolean;
  /** Default value: `1` */
  "linetoolfibspeedresistancefan.vlevel7.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibspeedresistancefan.vlevel7.color": string;
  /** Default value: `true` */
  "linetoolfibspeedresistancefan.vlevel7.visible": boolean;
}
/**
 * Override properties for the Fibtimezone drawing tool.
 */
export interface FibtimezoneLineToolOverrides {
  /** Default value: `#808080` */
  "linetoolfibtimezone.baselinecolor": string;
  /** Default value: `false` */
  "linetoolfibtimezone.fillBackground": boolean;
  /** Default value: `right` */
  "linetoolfibtimezone.horzLabelsAlign": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level1.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibtimezone.level1.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level1.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level1.visible": boolean;
  /** Default value: `55` */
  "linetoolfibtimezone.level10.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level10.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level10.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level10.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level10.visible": boolean;
  /** Default value: `89` */
  "linetoolfibtimezone.level11.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level11.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level11.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level11.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level11.visible": boolean;
  /** Default value: `1` */
  "linetoolfibtimezone.level2.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level2.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level2.visible": boolean;
  /** Default value: `2` */
  "linetoolfibtimezone.level3.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level3.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level3.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level3.visible": boolean;
  /** Default value: `3` */
  "linetoolfibtimezone.level4.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level4.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level4.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level4.visible": boolean;
  /** Default value: `5` */
  "linetoolfibtimezone.level5.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level5.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level5.visible": boolean;
  /** Default value: `8` */
  "linetoolfibtimezone.level6.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level6.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level6.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level6.visible": boolean;
  /** Default value: `13` */
  "linetoolfibtimezone.level7.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level7.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level7.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level7.visible": boolean;
  /** Default value: `21` */
  "linetoolfibtimezone.level8.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level8.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level8.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level8.visible": boolean;
  /** Default value: `34` */
  "linetoolfibtimezone.level9.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibtimezone.level9.color": string;
  /** Default value: `0` */
  "linetoolfibtimezone.level9.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.level9.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.level9.visible": boolean;
  /** Default value: `#0055db` */
  "linetoolfibtimezone.linecolor": string;
  /** Default value: `0` */
  "linetoolfibtimezone.linestyle": number;
  /** Default value: `2` */
  "linetoolfibtimezone.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.showLabels": boolean;
  /** Default value: `80` */
  "linetoolfibtimezone.transparency": number;
  /** Default value: `#808080` */
  "linetoolfibtimezone.trendline.color": string;
  /** Default value: `2` */
  "linetoolfibtimezone.trendline.linestyle": number;
  /** Default value: `1` */
  "linetoolfibtimezone.trendline.linewidth": number;
  /** Default value: `true` */
  "linetoolfibtimezone.trendline.visible": boolean;
  /** Default value: `bottom` */
  "linetoolfibtimezone.vertLabelsAlign": string;
}
/**
 * Override properties for the Fibwedge drawing tool.
 */
export interface FibwedgeLineToolOverrides {
  /** Default value: `true` */
  "linetoolfibwedge.fillBackground": boolean;
  /** Default value: `0.236` */
  "linetoolfibwedge.level1.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibwedge.level1.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level1.linewidth": number;
  /** Default value: `true` */
  "linetoolfibwedge.level1.visible": boolean;
  /** Default value: `4.236` */
  "linetoolfibwedge.level10.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibwedge.level10.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level10.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level10.linewidth": number;
  /** Default value: `false` */
  "linetoolfibwedge.level10.visible": boolean;
  /** Default value: `4.618` */
  "linetoolfibwedge.level11.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolfibwedge.level11.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level11.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level11.linewidth": number;
  /** Default value: `false` */
  "linetoolfibwedge.level11.visible": boolean;
  /** Default value: `0.382` */
  "linetoolfibwedge.level2.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolfibwedge.level2.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolfibwedge.level2.visible": boolean;
  /** Default value: `0.5` */
  "linetoolfibwedge.level3.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolfibwedge.level3.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level3.linewidth": number;
  /** Default value: `true` */
  "linetoolfibwedge.level3.visible": boolean;
  /** Default value: `0.618` */
  "linetoolfibwedge.level4.coeff": number;
  /** Default value: `#089981` */
  "linetoolfibwedge.level4.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level4.linewidth": number;
  /** Default value: `true` */
  "linetoolfibwedge.level4.visible": boolean;
  /** Default value: `0.786` */
  "linetoolfibwedge.level5.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolfibwedge.level5.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolfibwedge.level5.visible": boolean;
  /** Default value: `1` */
  "linetoolfibwedge.level6.coeff": number;
  /** Default value: `#787B86` */
  "linetoolfibwedge.level6.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level6.linewidth": number;
  /** Default value: `true` */
  "linetoolfibwedge.level6.visible": boolean;
  /** Default value: `1.618` */
  "linetoolfibwedge.level7.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolfibwedge.level7.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level7.linewidth": number;
  /** Default value: `false` */
  "linetoolfibwedge.level7.visible": boolean;
  /** Default value: `2.618` */
  "linetoolfibwedge.level8.coeff": number;
  /** Default value: `#F23645` */
  "linetoolfibwedge.level8.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level8.linewidth": number;
  /** Default value: `false` */
  "linetoolfibwedge.level8.visible": boolean;
  /** Default value: `3.618` */
  "linetoolfibwedge.level9.coeff": number;
  /** Default value: `#673ab7` */
  "linetoolfibwedge.level9.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.level9.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.level9.linewidth": number;
  /** Default value: `false` */
  "linetoolfibwedge.level9.visible": boolean;
  /** Default value: `true` */
  "linetoolfibwedge.showCoeffs": boolean;
  /** Default value: `80` */
  "linetoolfibwedge.transparency": number;
  /** Default value: `#808080` */
  "linetoolfibwedge.trendline.color": string;
  /** Default value: `0` */
  "linetoolfibwedge.trendline.linestyle": number;
  /** Default value: `2` */
  "linetoolfibwedge.trendline.linewidth": number;
  /** Default value: `true` */
  "linetoolfibwedge.trendline.visible": boolean;
}
/**
 * Overrides for the '52 Week High/Low' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface FiftyTwoWeekHighLowIndicatorOverrides {
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Fisher Transform' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface FisherTransformIndicatorOverrides {
  /** Default value: `#E91E63` */
  "level:band.color": string;
  /** Default value: `2` */
  "level:band.linestyle": number;
  /** Default value: `1` */
  "level:band.linewidth": number;
  /** Default value: `true` */
  "level:band.visible": boolean;
  /** Default value: `-1.5` */
  "level:band.value": number;
  /** Default value: `15` */
  "fisher.display": number;
  /** Default value: `0` */
  "fisher.linestyle": number;
  /** Default value: `1` */
  "fisher.linewidth": number;
  /** Default value: `line` */
  "fisher.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "fisher.trackprice": boolean;
  /** Default value: `0` */
  "fisher.transparency": number;
  /** Default value: `#2196F3` */
  "fisher.color": string;
  /** Default value: `15` */
  "trigger.display": number;
  /** Default value: `0` */
  "trigger.linestyle": number;
  /** Default value: `1` */
  "trigger.linewidth": number;
  /** Default value: `line` */
  "trigger.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trigger.trackprice": boolean;
  /** Default value: `0` */
  "trigger.transparency": number;
  /** Default value: `#FF6D00` */
  "trigger.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Fivepointspattern drawing tool.
 */
export interface FivepointspatternLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetool5pointspattern.backgroundColor": string;
  /** Default value: `false` */
  "linetool5pointspattern.bold": boolean;
  /** Default value: `#2962FF` */
  "linetool5pointspattern.color": string;
  /** Default value: `true` */
  "linetool5pointspattern.fillBackground": boolean;
  /** Default value: `12` */
  "linetool5pointspattern.fontsize": number;
  /** Default value: `false` */
  "linetool5pointspattern.italic": boolean;
  /** Default value: `2` */
  "linetool5pointspattern.linewidth": number;
  /** Default value: `#ffffff` */
  "linetool5pointspattern.textcolor": string;
  /** Default value: `85` */
  "linetool5pointspattern.transparency": number;
}
/**
 * Overrides for the 'Fixed Range' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface FixedRangeIndicatorOverrides {
  /** Default value: `#ff0000` */
  "developing poc.color": string;
  /** Default value: `0` */
  "developing poc.linestyle": number;
  /** Default value: `1` */
  "developing poc.linewidth": number;
  /** Default value: `step_line` */
  "developing poc.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing poc.trackprice": boolean;
  /** Default value: `0` */
  "developing poc.transparency": number;
  /** Default value: `0` */
  "developing poc.display": number;
  /** Default value: `#0000ff` */
  "developing va high.color": string;
  /** Default value: `0` */
  "developing va high.linestyle": number;
  /** Default value: `1` */
  "developing va high.linewidth": number;
  /** Default value: `step_line` */
  "developing va high.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing va high.trackprice": boolean;
  /** Default value: `0` */
  "developing va high.transparency": number;
  /** Default value: `0` */
  "developing va high.display": number;
  /** Default value: `#0000ff` */
  "developing va low.color": string;
  /** Default value: `0` */
  "developing va low.linestyle": number;
  /** Default value: `1` */
  "developing va low.linewidth": number;
  /** Default value: `step_line` */
  "developing va low.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing va low.trackprice": boolean;
  /** Default value: `0` */
  "developing va low.transparency": number;
  /** Default value: `0` */
  "developing va low.display": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Flagmark drawing tool.
 */
export interface FlagmarkLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetoolflagmark.flagColor": string;
}
/**
 * Override properties for the Flatbottom drawing tool.
 */
export interface FlatbottomLineToolOverrides {
  /** Default value: `rgba(255, 152, 0, 0.2)` */
  "linetoolflatbottom.backgroundColor": string;
  /** Default value: `false` */
  "linetoolflatbottom.bold": boolean;
  /** Default value: `false` */
  "linetoolflatbottom.extendLeft": boolean;
  /** Default value: `false` */
  "linetoolflatbottom.extendRight": boolean;
  /** Default value: `true` */
  "linetoolflatbottom.fillBackground": boolean;
  /** Default value: `12` */
  "linetoolflatbottom.fontsize": number;
  /** Default value: `false` */
  "linetoolflatbottom.italic": boolean;
  /** Default value: `false` */
  "linetoolflatbottom.labelBold": boolean;
  /** Default value: `14` */
  "linetoolflatbottom.labelFontSize": number;
  /** Default value: `left` */
  "linetoolflatbottom.labelHorzAlign": string;
  /** Default value: `false` */
  "linetoolflatbottom.labelItalic": boolean;
  /** Default value: `#FF9800` */
  "linetoolflatbottom.labelTextColor": string;
  /** Default value: `bottom` */
  "linetoolflatbottom.labelVertAlign": string;
  /** Default value: `false` */
  "linetoolflatbottom.labelVisible": boolean;
  /** Default value: `0` */
  "linetoolflatbottom.leftEnd": number;
  /** Default value: `#FF9800` */
  "linetoolflatbottom.linecolor": string;
  /** Default value: `0` */
  "linetoolflatbottom.linestyle": number;
  /** Default value: `2` */
  "linetoolflatbottom.linewidth": number;
  /** Default value: `0` */
  "linetoolflatbottom.rightEnd": number;
  /** Default value: `false` */
  "linetoolflatbottom.showBarsRange": boolean;
  /** Default value: `false` */
  "linetoolflatbottom.showDateTimeRange": boolean;
  /** Default value: `false` */
  "linetoolflatbottom.showPriceRange": boolean;
  /** Default value: `false` */
  "linetoolflatbottom.showPrices": boolean;
  /** Default value: `#FF9800` */
  "linetoolflatbottom.textcolor": string;
  /** Default value: `20` */
  "linetoolflatbottom.transparency": number;
}
export interface FormatterParseResult {
  /** Returns if the formatter support parsing */
  res: boolean;
}
/**
 * Override properties for the Ganncomplex drawing tool.
 */
export interface GanncomplexLineToolOverrides {
  /** Default value: `#FF9800` */
  "linetoolganncomplex.arcs.0.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.0.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.0.width": number;
  /** Default value: `1` */
  "linetoolganncomplex.arcs.0.x": number;
  /** Default value: `0` */
  "linetoolganncomplex.arcs.0.y": number;
  /** Default value: `#FF9800` */
  "linetoolganncomplex.arcs.1.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.1.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.1.width": number;
  /** Default value: `1` */
  "linetoolganncomplex.arcs.1.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.arcs.1.y": number;
  /** Default value: `#2962FF` */
  "linetoolganncomplex.arcs.10.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.10.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.10.width": number;
  /** Default value: `5` */
  "linetoolganncomplex.arcs.10.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.arcs.10.y": number;
  /** Default value: `#FF9800` */
  "linetoolganncomplex.arcs.2.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.2.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.2.width": number;
  /** Default value: `1.5` */
  "linetoolganncomplex.arcs.2.x": number;
  /** Default value: `0` */
  "linetoolganncomplex.arcs.2.y": number;
  /** Default value: `#00bcd4` */
  "linetoolganncomplex.arcs.3.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.3.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.3.width": number;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.3.x": number;
  /** Default value: `0` */
  "linetoolganncomplex.arcs.3.y": number;
  /** Default value: `#00bcd4` */
  "linetoolganncomplex.arcs.4.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.4.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.4.width": number;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.4.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.arcs.4.y": number;
  /** Default value: `#4caf50` */
  "linetoolganncomplex.arcs.5.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.5.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.5.width": number;
  /** Default value: `3` */
  "linetoolganncomplex.arcs.5.x": number;
  /** Default value: `0` */
  "linetoolganncomplex.arcs.5.y": number;
  /** Default value: `#4caf50` */
  "linetoolganncomplex.arcs.6.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.6.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.6.width": number;
  /** Default value: `3` */
  "linetoolganncomplex.arcs.6.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.arcs.6.y": number;
  /** Default value: `#089981` */
  "linetoolganncomplex.arcs.7.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.7.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.7.width": number;
  /** Default value: `4` */
  "linetoolganncomplex.arcs.7.x": number;
  /** Default value: `0` */
  "linetoolganncomplex.arcs.7.y": number;
  /** Default value: `#089981` */
  "linetoolganncomplex.arcs.8.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.8.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.8.width": number;
  /** Default value: `4` */
  "linetoolganncomplex.arcs.8.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.arcs.8.y": number;
  /** Default value: `#2962FF` */
  "linetoolganncomplex.arcs.9.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.arcs.9.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.arcs.9.width": number;
  /** Default value: `5` */
  "linetoolganncomplex.arcs.9.x": number;
  /** Default value: `0` */
  "linetoolganncomplex.arcs.9.y": number;
  /** Default value: `true` */
  "linetoolganncomplex.arcsBackground.fillBackground": boolean;
  /** Default value: `80` */
  "linetoolganncomplex.arcsBackground.transparency": number;
  /** Default value: `#B39DDB` */
  "linetoolganncomplex.fanlines.0.color": string;
  /** Default value: `false` */
  "linetoolganncomplex.fanlines.0.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.0.width": number;
  /** Default value: `8` */
  "linetoolganncomplex.fanlines.0.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.0.y": number;
  /** Default value: `#F23645` */
  "linetoolganncomplex.fanlines.1.color": string;
  /** Default value: `false` */
  "linetoolganncomplex.fanlines.1.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.1.width": number;
  /** Default value: `5` */
  "linetoolganncomplex.fanlines.1.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.1.y": number;
  /** Default value: `#B39DDB` */
  "linetoolganncomplex.fanlines.10.color": string;
  /** Default value: `false` */
  "linetoolganncomplex.fanlines.10.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.10.width": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.10.x": number;
  /** Default value: `8` */
  "linetoolganncomplex.fanlines.10.y": number;
  /** Default value: `#787B86` */
  "linetoolganncomplex.fanlines.2.color": string;
  /** Default value: `false` */
  "linetoolganncomplex.fanlines.2.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.2.width": number;
  /** Default value: `4` */
  "linetoolganncomplex.fanlines.2.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.2.y": number;
  /** Default value: `#FF9800` */
  "linetoolganncomplex.fanlines.3.color": string;
  /** Default value: `false` */
  "linetoolganncomplex.fanlines.3.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.3.width": number;
  /** Default value: `3` */
  "linetoolganncomplex.fanlines.3.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.3.y": number;
  /** Default value: `#00bcd4` */
  "linetoolganncomplex.fanlines.4.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.fanlines.4.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.4.width": number;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.4.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.4.y": number;
  /** Default value: `#4caf50` */
  "linetoolganncomplex.fanlines.5.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.fanlines.5.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.5.width": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.5.x": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.5.y": number;
  /** Default value: `#089981` */
  "linetoolganncomplex.fanlines.6.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.fanlines.6.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.6.width": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.6.x": number;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.6.y": number;
  /** Default value: `#089981` */
  "linetoolganncomplex.fanlines.7.color": string;
  /** Default value: `false` */
  "linetoolganncomplex.fanlines.7.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.7.width": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.7.x": number;
  /** Default value: `3` */
  "linetoolganncomplex.fanlines.7.y": number;
  /** Default value: `#2962FF` */
  "linetoolganncomplex.fanlines.8.color": string;
  /** Default value: `false` */
  "linetoolganncomplex.fanlines.8.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.8.width": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.8.x": number;
  /** Default value: `4` */
  "linetoolganncomplex.fanlines.8.y": number;
  /** Default value: `#9575cd` */
  "linetoolganncomplex.fanlines.9.color": string;
  /** Default value: `false` */
  "linetoolganncomplex.fanlines.9.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.fanlines.9.width": number;
  /** Default value: `1` */
  "linetoolganncomplex.fanlines.9.x": number;
  /** Default value: `5` */
  "linetoolganncomplex.fanlines.9.y": number;
  /** Default value: `false` */
  "linetoolganncomplex.fillBackground": boolean;
  /** Default value: `false` */
  "linetoolganncomplex.labelsStyle.bold": boolean;
  /** Default value: `12` */
  "linetoolganncomplex.labelsStyle.fontSize": number;
  /** Default value: `false` */
  "linetoolganncomplex.labelsStyle.italic": boolean;
  /** Default value: `#787B86` */
  "linetoolganncomplex.levels.0.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.levels.0.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.levels.0.width": number;
  /** Default value: `#FF9800` */
  "linetoolganncomplex.levels.1.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.levels.1.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.levels.1.width": number;
  /** Default value: `#00bcd4` */
  "linetoolganncomplex.levels.2.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.levels.2.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.levels.2.width": number;
  /** Default value: `#4caf50` */
  "linetoolganncomplex.levels.3.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.levels.3.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.levels.3.width": number;
  /** Default value: `#089981` */
  "linetoolganncomplex.levels.4.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.levels.4.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.levels.4.width": number;
  /** Default value: `#787B86` */
  "linetoolganncomplex.levels.5.color": string;
  /** Default value: `true` */
  "linetoolganncomplex.levels.5.visible": boolean;
  /** Default value: `2` */
  "linetoolganncomplex.levels.5.width": number;
  /** Default value: `false` */
  "linetoolganncomplex.reverse": boolean;
  /** Default value: `` */
  "linetoolganncomplex.scaleRatio": string;
  /** Default value: `true` */
  "linetoolganncomplex.showLabels": boolean;
}
/**
 * Override properties for the Gannfan drawing tool.
 */
export interface GannfanLineToolOverrides {
  /** Default value: `true` */
  "linetoolgannfan.fillBackground": boolean;
  /** Default value: `1` */
  "linetoolgannfan.level1.coeff1": number;
  /** Default value: `8` */
  "linetoolgannfan.level1.coeff2": number;
  /** Default value: `#FF9800` */
  "linetoolgannfan.level1.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level1.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level1.visible": boolean;
  /** Default value: `1` */
  "linetoolgannfan.level2.coeff1": number;
  /** Default value: `4` */
  "linetoolgannfan.level2.coeff2": number;
  /** Default value: `#089981` */
  "linetoolgannfan.level2.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level2.visible": boolean;
  /** Default value: `1` */
  "linetoolgannfan.level3.coeff1": number;
  /** Default value: `3` */
  "linetoolgannfan.level3.coeff2": number;
  /** Default value: `#4caf50` */
  "linetoolgannfan.level3.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level3.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level3.visible": boolean;
  /** Default value: `1` */
  "linetoolgannfan.level4.coeff1": number;
  /** Default value: `2` */
  "linetoolgannfan.level4.coeff2": number;
  /** Default value: `#089981` */
  "linetoolgannfan.level4.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level4.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level4.visible": boolean;
  /** Default value: `1` */
  "linetoolgannfan.level5.coeff1": number;
  /** Default value: `1` */
  "linetoolgannfan.level5.coeff2": number;
  /** Default value: `#00bcd4` */
  "linetoolgannfan.level5.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level5.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfan.level6.coeff1": number;
  /** Default value: `1` */
  "linetoolgannfan.level6.coeff2": number;
  /** Default value: `#2962FF` */
  "linetoolgannfan.level6.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level6.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level6.visible": boolean;
  /** Default value: `3` */
  "linetoolgannfan.level7.coeff1": number;
  /** Default value: `1` */
  "linetoolgannfan.level7.coeff2": number;
  /** Default value: `#9c27b0` */
  "linetoolgannfan.level7.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level7.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level7.visible": boolean;
  /** Default value: `4` */
  "linetoolgannfan.level8.coeff1": number;
  /** Default value: `1` */
  "linetoolgannfan.level8.coeff2": number;
  /** Default value: `#e91e63` */
  "linetoolgannfan.level8.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level8.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level8.visible": boolean;
  /** Default value: `8` */
  "linetoolgannfan.level9.coeff1": number;
  /** Default value: `1` */
  "linetoolgannfan.level9.coeff2": number;
  /** Default value: `#F23645` */
  "linetoolgannfan.level9.color": string;
  /** Default value: `0` */
  "linetoolgannfan.level9.linestyle": number;
  /** Default value: `2` */
  "linetoolgannfan.level9.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.level9.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfan.linewidth": number;
  /** Default value: `true` */
  "linetoolgannfan.showLabels": boolean;
  /** Default value: `80` */
  "linetoolgannfan.transparency": number;
}
/**
 * Override properties for the Gannfixed drawing tool.
 */
export interface GannfixedLineToolOverrides {
  /** Default value: `#FF9800` */
  "linetoolgannfixed.arcs.0.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.0.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.0.width": number;
  /** Default value: `1` */
  "linetoolgannfixed.arcs.0.x": number;
  /** Default value: `0` */
  "linetoolgannfixed.arcs.0.y": number;
  /** Default value: `#FF9800` */
  "linetoolgannfixed.arcs.1.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.1.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.1.width": number;
  /** Default value: `1` */
  "linetoolgannfixed.arcs.1.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.arcs.1.y": number;
  /** Default value: `#2962FF` */
  "linetoolgannfixed.arcs.10.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.10.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.10.width": number;
  /** Default value: `5` */
  "linetoolgannfixed.arcs.10.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.arcs.10.y": number;
  /** Default value: `#FF9800` */
  "linetoolgannfixed.arcs.2.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.2.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.2.width": number;
  /** Default value: `1.5` */
  "linetoolgannfixed.arcs.2.x": number;
  /** Default value: `0` */
  "linetoolgannfixed.arcs.2.y": number;
  /** Default value: `#00bcd4` */
  "linetoolgannfixed.arcs.3.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.3.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.3.width": number;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.3.x": number;
  /** Default value: `0` */
  "linetoolgannfixed.arcs.3.y": number;
  /** Default value: `#00bcd4` */
  "linetoolgannfixed.arcs.4.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.4.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.4.width": number;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.4.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.arcs.4.y": number;
  /** Default value: `#4caf50` */
  "linetoolgannfixed.arcs.5.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.5.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.5.width": number;
  /** Default value: `3` */
  "linetoolgannfixed.arcs.5.x": number;
  /** Default value: `0` */
  "linetoolgannfixed.arcs.5.y": number;
  /** Default value: `#4caf50` */
  "linetoolgannfixed.arcs.6.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.6.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.6.width": number;
  /** Default value: `3` */
  "linetoolgannfixed.arcs.6.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.arcs.6.y": number;
  /** Default value: `#089981` */
  "linetoolgannfixed.arcs.7.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.7.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.7.width": number;
  /** Default value: `4` */
  "linetoolgannfixed.arcs.7.x": number;
  /** Default value: `0` */
  "linetoolgannfixed.arcs.7.y": number;
  /** Default value: `#089981` */
  "linetoolgannfixed.arcs.8.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.8.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.8.width": number;
  /** Default value: `4` */
  "linetoolgannfixed.arcs.8.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.arcs.8.y": number;
  /** Default value: `#2962FF` */
  "linetoolgannfixed.arcs.9.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.arcs.9.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.arcs.9.width": number;
  /** Default value: `5` */
  "linetoolgannfixed.arcs.9.x": number;
  /** Default value: `0` */
  "linetoolgannfixed.arcs.9.y": number;
  /** Default value: `true` */
  "linetoolgannfixed.arcsBackground.fillBackground": boolean;
  /** Default value: `80` */
  "linetoolgannfixed.arcsBackground.transparency": number;
  /** Default value: `#B39DDB` */
  "linetoolgannfixed.fanlines.0.color": string;
  /** Default value: `false` */
  "linetoolgannfixed.fanlines.0.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.0.width": number;
  /** Default value: `8` */
  "linetoolgannfixed.fanlines.0.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.0.y": number;
  /** Default value: `#F23645` */
  "linetoolgannfixed.fanlines.1.color": string;
  /** Default value: `false` */
  "linetoolgannfixed.fanlines.1.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.1.width": number;
  /** Default value: `5` */
  "linetoolgannfixed.fanlines.1.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.1.y": number;
  /** Default value: `#B39DDB` */
  "linetoolgannfixed.fanlines.10.color": string;
  /** Default value: `false` */
  "linetoolgannfixed.fanlines.10.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.10.width": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.10.x": number;
  /** Default value: `8` */
  "linetoolgannfixed.fanlines.10.y": number;
  /** Default value: `#787B86` */
  "linetoolgannfixed.fanlines.2.color": string;
  /** Default value: `false` */
  "linetoolgannfixed.fanlines.2.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.2.width": number;
  /** Default value: `4` */
  "linetoolgannfixed.fanlines.2.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.2.y": number;
  /** Default value: `#FF9800` */
  "linetoolgannfixed.fanlines.3.color": string;
  /** Default value: `false` */
  "linetoolgannfixed.fanlines.3.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.3.width": number;
  /** Default value: `3` */
  "linetoolgannfixed.fanlines.3.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.3.y": number;
  /** Default value: `#00bcd4` */
  "linetoolgannfixed.fanlines.4.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.fanlines.4.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.4.width": number;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.4.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.4.y": number;
  /** Default value: `#4caf50` */
  "linetoolgannfixed.fanlines.5.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.fanlines.5.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.5.width": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.5.x": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.5.y": number;
  /** Default value: `#089981` */
  "linetoolgannfixed.fanlines.6.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.fanlines.6.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.6.width": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.6.x": number;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.6.y": number;
  /** Default value: `#089981` */
  "linetoolgannfixed.fanlines.7.color": string;
  /** Default value: `false` */
  "linetoolgannfixed.fanlines.7.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.7.width": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.7.x": number;
  /** Default value: `3` */
  "linetoolgannfixed.fanlines.7.y": number;
  /** Default value: `#2962FF` */
  "linetoolgannfixed.fanlines.8.color": string;
  /** Default value: `false` */
  "linetoolgannfixed.fanlines.8.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.8.width": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.8.x": number;
  /** Default value: `4` */
  "linetoolgannfixed.fanlines.8.y": number;
  /** Default value: `#9575cd` */
  "linetoolgannfixed.fanlines.9.color": string;
  /** Default value: `false` */
  "linetoolgannfixed.fanlines.9.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.fanlines.9.width": number;
  /** Default value: `1` */
  "linetoolgannfixed.fanlines.9.x": number;
  /** Default value: `5` */
  "linetoolgannfixed.fanlines.9.y": number;
  /** Default value: `false` */
  "linetoolgannfixed.fillBackground": boolean;
  /** Default value: `#787B86` */
  "linetoolgannfixed.levels.0.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.levels.0.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.levels.0.width": number;
  /** Default value: `#FF9800` */
  "linetoolgannfixed.levels.1.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.levels.1.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.levels.1.width": number;
  /** Default value: `#00bcd4` */
  "linetoolgannfixed.levels.2.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.levels.2.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.levels.2.width": number;
  /** Default value: `#4caf50` */
  "linetoolgannfixed.levels.3.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.levels.3.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.levels.3.width": number;
  /** Default value: `#089981` */
  "linetoolgannfixed.levels.4.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.levels.4.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.levels.4.width": number;
  /** Default value: `#787B86` */
  "linetoolgannfixed.levels.5.color": string;
  /** Default value: `true` */
  "linetoolgannfixed.levels.5.visible": boolean;
  /** Default value: `2` */
  "linetoolgannfixed.levels.5.width": number;
  /** Default value: `false` */
  "linetoolgannfixed.reverse": boolean;
}
/**
 * Override properties for the Gannsquare drawing tool.
 */
export interface GannsquareLineToolOverrides {
  /** Default value: `rgba(21, 56, 153, 0.8)` */
  "linetoolgannsquare.color": string;
  /** Default value: `#9598A1` */
  "linetoolgannsquare.fans.color": string;
  /** Default value: `false` */
  "linetoolgannsquare.fans.visible": boolean;
  /** Default value: `true` */
  "linetoolgannsquare.fillHorzBackground": boolean;
  /** Default value: `true` */
  "linetoolgannsquare.fillVertBackground": boolean;
  /** Default value: `0` */
  "linetoolgannsquare.hlevel1.coeff": number;
  /** Default value: `#787B86` */
  "linetoolgannsquare.hlevel1.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.hlevel1.visible": boolean;
  /** Default value: `0.25` */
  "linetoolgannsquare.hlevel2.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolgannsquare.hlevel2.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.hlevel2.visible": boolean;
  /** Default value: `0.382` */
  "linetoolgannsquare.hlevel3.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolgannsquare.hlevel3.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.hlevel3.visible": boolean;
  /** Default value: `0.5` */
  "linetoolgannsquare.hlevel4.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolgannsquare.hlevel4.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.hlevel4.visible": boolean;
  /** Default value: `0.618` */
  "linetoolgannsquare.hlevel5.coeff": number;
  /** Default value: `#089981` */
  "linetoolgannsquare.hlevel5.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.hlevel5.visible": boolean;
  /** Default value: `0.75` */
  "linetoolgannsquare.hlevel6.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolgannsquare.hlevel6.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.hlevel6.visible": boolean;
  /** Default value: `1` */
  "linetoolgannsquare.hlevel7.coeff": number;
  /** Default value: `#787B86` */
  "linetoolgannsquare.hlevel7.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.hlevel7.visible": boolean;
  /** Default value: `80` */
  "linetoolgannsquare.horzTransparency": number;
  /** Default value: `0` */
  "linetoolgannsquare.linestyle": number;
  /** Default value: `2` */
  "linetoolgannsquare.linewidth": number;
  /** Default value: `false` */
  "linetoolgannsquare.reverse": boolean;
  /** Default value: `true` */
  "linetoolgannsquare.showBottomLabels": boolean;
  /** Default value: `true` */
  "linetoolgannsquare.showLeftLabels": boolean;
  /** Default value: `true` */
  "linetoolgannsquare.showRightLabels": boolean;
  /** Default value: `true` */
  "linetoolgannsquare.showTopLabels": boolean;
  /** Default value: `80` */
  "linetoolgannsquare.vertTransparency": number;
  /** Default value: `0` */
  "linetoolgannsquare.vlevel1.coeff": number;
  /** Default value: `#787B86` */
  "linetoolgannsquare.vlevel1.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.vlevel1.visible": boolean;
  /** Default value: `0.25` */
  "linetoolgannsquare.vlevel2.coeff": number;
  /** Default value: `#FF9800` */
  "linetoolgannsquare.vlevel2.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.vlevel2.visible": boolean;
  /** Default value: `0.382` */
  "linetoolgannsquare.vlevel3.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolgannsquare.vlevel3.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.vlevel3.visible": boolean;
  /** Default value: `0.5` */
  "linetoolgannsquare.vlevel4.coeff": number;
  /** Default value: `#4caf50` */
  "linetoolgannsquare.vlevel4.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.vlevel4.visible": boolean;
  /** Default value: `0.618` */
  "linetoolgannsquare.vlevel5.coeff": number;
  /** Default value: `#089981` */
  "linetoolgannsquare.vlevel5.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.vlevel5.visible": boolean;
  /** Default value: `0.75` */
  "linetoolgannsquare.vlevel6.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolgannsquare.vlevel6.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.vlevel6.visible": boolean;
  /** Default value: `1` */
  "linetoolgannsquare.vlevel7.coeff": number;
  /** Default value: `#787B86` */
  "linetoolgannsquare.vlevel7.color": string;
  /** Default value: `true` */
  "linetoolgannsquare.vlevel7.visible": boolean;
}
export interface GetNewsResponse {
  /** Title */
  title?: string;
  /** Retrieved news items */
  newsItems: NewsItem[];
}
/**
 * Override properties for the Ghostfeed drawing tool.
 */
export interface GhostfeedLineToolOverrides {
  /** Default value: `20` */
  "linetoolghostfeed.averageHL": number;
  /** Default value: `#378658` */
  "linetoolghostfeed.candleStyle.borderColor": string;
  /** Default value: `#F23645` */
  "linetoolghostfeed.candleStyle.borderDownColor": string;
  /** Default value: `#089981` */
  "linetoolghostfeed.candleStyle.borderUpColor": string;
  /** Default value: `#FAA1A4` */
  "linetoolghostfeed.candleStyle.downColor": string;
  /** Default value: `true` */
  "linetoolghostfeed.candleStyle.drawBorder": boolean;
  /** Default value: `true` */
  "linetoolghostfeed.candleStyle.drawWick": boolean;
  /** Default value: `#ACE5DC` */
  "linetoolghostfeed.candleStyle.upColor": string;
  /** Default value: `#787B86` */
  "linetoolghostfeed.candleStyle.wickColor": string;
  /** Default value: `50` */
  "linetoolghostfeed.transparency": number;
  /** Default value: `50` */
  "linetoolghostfeed.variance": number;
}
export interface GrayedObject {
  /** Type for grayed object */
  type: "drawing" | "study";
  /** Name of grayed object */
  name: string;
}
/**
 * Overrides for the 'Guppy Multiple Moving Average' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface GuppyMultipleMovingAverageIndicatorOverrides {
  /** Default value: `15` */
  "trader ema 1.display": number;
  /** Default value: `#00FFFF` */
  "trader ema 1.color": string;
  /** Default value: `0` */
  "trader ema 1.linestyle": number;
  /** Default value: `1` */
  "trader ema 1.linewidth": number;
  /** Default value: `line` */
  "trader ema 1.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trader ema 1.trackprice": boolean;
  /** Default value: `15` */
  "trader ema 1.transparency": number;
  /** Default value: `15` */
  "trader ema 2.display": number;
  /** Default value: `#00FFFF` */
  "trader ema 2.color": string;
  /** Default value: `0` */
  "trader ema 2.linestyle": number;
  /** Default value: `1` */
  "trader ema 2.linewidth": number;
  /** Default value: `line` */
  "trader ema 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trader ema 2.trackprice": boolean;
  /** Default value: `12` */
  "trader ema 2.transparency": number;
  /** Default value: `15` */
  "trader ema 3.display": number;
  /** Default value: `#00FFFF` */
  "trader ema 3.color": string;
  /** Default value: `0` */
  "trader ema 3.linestyle": number;
  /** Default value: `1` */
  "trader ema 3.linewidth": number;
  /** Default value: `line` */
  "trader ema 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trader ema 3.trackprice": boolean;
  /** Default value: `9` */
  "trader ema 3.transparency": number;
  /** Default value: `15` */
  "trader ema 4.display": number;
  /** Default value: `#00FFFF` */
  "trader ema 4.color": string;
  /** Default value: `0` */
  "trader ema 4.linestyle": number;
  /** Default value: `1` */
  "trader ema 4.linewidth": number;
  /** Default value: `line` */
  "trader ema 4.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trader ema 4.trackprice": boolean;
  /** Default value: `6` */
  "trader ema 4.transparency": number;
  /** Default value: `15` */
  "trader ema 5.display": number;
  /** Default value: `#00FFFF` */
  "trader ema 5.color": string;
  /** Default value: `0` */
  "trader ema 5.linestyle": number;
  /** Default value: `1` */
  "trader ema 5.linewidth": number;
  /** Default value: `line` */
  "trader ema 5.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trader ema 5.trackprice": boolean;
  /** Default value: `3` */
  "trader ema 5.transparency": number;
  /** Default value: `15` */
  "trader ema 6.display": number;
  /** Default value: `#00FFFF` */
  "trader ema 6.color": string;
  /** Default value: `0` */
  "trader ema 6.linestyle": number;
  /** Default value: `1` */
  "trader ema 6.linewidth": number;
  /** Default value: `line` */
  "trader ema 6.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trader ema 6.trackprice": boolean;
  /** Default value: `0` */
  "trader ema 6.transparency": number;
  /** Default value: `15` */
  "investor ema 1.display": number;
  /** Default value: `#FF0000` */
  "investor ema 1.color": string;
  /** Default value: `0` */
  "investor ema 1.linestyle": number;
  /** Default value: `1` */
  "investor ema 1.linewidth": number;
  /** Default value: `line` */
  "investor ema 1.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "investor ema 1.trackprice": boolean;
  /** Default value: `15` */
  "investor ema 1.transparency": number;
  /** Default value: `15` */
  "investor ema 2.display": number;
  /** Default value: `#FF0000` */
  "investor ema 2.color": string;
  /** Default value: `0` */
  "investor ema 2.linestyle": number;
  /** Default value: `1` */
  "investor ema 2.linewidth": number;
  /** Default value: `line` */
  "investor ema 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "investor ema 2.trackprice": boolean;
  /** Default value: `12` */
  "investor ema 2.transparency": number;
  /** Default value: `15` */
  "investor ema 3.display": number;
  /** Default value: `#FF0000` */
  "investor ema 3.color": string;
  /** Default value: `0` */
  "investor ema 3.linestyle": number;
  /** Default value: `1` */
  "investor ema 3.linewidth": number;
  /** Default value: `line` */
  "investor ema 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "investor ema 3.trackprice": boolean;
  /** Default value: `9` */
  "investor ema 3.transparency": number;
  /** Default value: `15` */
  "investor ema 4.display": number;
  /** Default value: `#FF0000` */
  "investor ema 4.color": string;
  /** Default value: `0` */
  "investor ema 4.linestyle": number;
  /** Default value: `1` */
  "investor ema 4.linewidth": number;
  /** Default value: `line` */
  "investor ema 4.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "investor ema 4.trackprice": boolean;
  /** Default value: `6` */
  "investor ema 4.transparency": number;
  /** Default value: `15` */
  "investor ema 5.display": number;
  /** Default value: `#FF0000` */
  "investor ema 5.color": string;
  /** Default value: `0` */
  "investor ema 5.linestyle": number;
  /** Default value: `1` */
  "investor ema 5.linewidth": number;
  /** Default value: `line` */
  "investor ema 5.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "investor ema 5.trackprice": boolean;
  /** Default value: `3` */
  "investor ema 5.transparency": number;
  /** Default value: `15` */
  "investor ema 6.display": number;
  /** Default value: `#FF0000` */
  "investor ema 6.color": string;
  /** Default value: `0` */
  "investor ema 6.linestyle": number;
  /** Default value: `1` */
  "investor ema 6.linewidth": number;
  /** Default value: `line` */
  "investor ema 6.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "investor ema 6.trackprice": boolean;
  /** Default value: `0` */
  "investor ema 6.transparency": number;
  [key: string]: StudyOverrideValueType;
}
/** Histogram Preferences */
export interface HHistPreferences {
  /**
   * Colors for the histogram up and down bars.
   * Example:
   * ```js
   * colors: ['#1592e6', '#fbc123']
   * ```
   */
  colors: string[];
  /** Transparency values for the histogram */
  transparencies: number[];
  /** Should the histogram be visible */
  visible: boolean;
  /** Percentage width of the chart for which the histogram should occupy */
  percentWidth: number;
  /** Should the values be shown */
  showValues: boolean;
  /** Color for values shown */
  valuesColor: string;
  /**
   * Direction of the histogram.
   * Whether the histogram will be shown on the left or right edge of the chart
   */
  direction: HHistDirection;
}
export interface HLCAreaStylePreferences {
  /** High line color */
  highLineColor: string;
  /** High line style */
  highLineStyle: number;
  /** High line width */
  highLineWidth: number;
  /** Low line color */
  lowLineColor: string;
  /** Low line style */
  lowLineStyle: number;
  /** Low line width */
  lowLineWidth: number;
  /** Close line color */
  closeLineColor: string;
  /** Close line style */
  closeLineStyle: number;
  /** Close line width */
  closeLineWidth: number;
  /** Fill color of area between high and close lines */
  highCloseFillColor: string;
  /** Fill color of area between close and low lines */
  closeLowFillColor: string;
}
/**
 * Override properties for the Headandshoulders drawing tool.
 */
export interface HeadandshouldersLineToolOverrides {
  /** Default value: `#089981` */
  "linetoolheadandshoulders.backgroundColor": string;
  /** Default value: `false` */
  "linetoolheadandshoulders.bold": boolean;
  /** Default value: `#089981` */
  "linetoolheadandshoulders.color": string;
  /** Default value: `true` */
  "linetoolheadandshoulders.fillBackground": boolean;
  /** Default value: `12` */
  "linetoolheadandshoulders.fontsize": number;
  /** Default value: `false` */
  "linetoolheadandshoulders.italic": boolean;
  /** Default value: `2` */
  "linetoolheadandshoulders.linewidth": number;
  /** Default value: `#ffffff` */
  "linetoolheadandshoulders.textcolor": string;
  /** Default value: `85` */
  "linetoolheadandshoulders.transparency": number;
}
export interface HeikinAshiStylePreferences {
  /** Body color for an up candle */
  upColor: string;
  /** Body color for down candle */
  downColor: string;
  /** Whether to draw the candle wick */
  drawWick: boolean;
  /** Whether to draw the candle border */
  drawBorder: boolean;
  /** Whether to draw the candle body */
  drawBody: boolean;
  /** Candle border color */
  borderColor: string;
  /** Up candle border color */
  borderUpColor: string;
  /** Down candle border color */
  borderDownColor: string;
  /** Candle wick color */
  wickColor: string;
  /** Up candle wick color */
  wickUpColor: string;
  /** Down candle wick color */
  wickDownColor: string;
  /** Show real last price */
  showRealLastPrice: boolean;
  /** Color bars based on previous close value */
  barColorsOnPrevClose: boolean;
}
export interface HiLoStylePreferences {
  /** Color for Hi Lo chart */
  color: string;
  /** Show borders. Default - `false` */
  showBorders: boolean;
  /** Border Color */
  borderColor: string;
  /** Show Labels. Default - `false` */
  showLabels: boolean;
  /** Label color */
  labelColor: string;
  /** Draw body. Default - `true` */
  drawBody: boolean;
}
/**
 * Override properties for the Highlighter drawing tool.
 */
export interface HighlighterLineToolOverrides {
  /** Default value: `rgba(242, 54, 69, 0.2)` */
  "linetoolhighlighter.linecolor": string;
  /** Default value: `5` */
  "linetoolhighlighter.smooth": number;
  /** Default value: `80` */
  "linetoolhighlighter.transparency": number;
}
/**
 * Overrides for the 'Historical Volatility' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface HistoricalVolatilityIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Information passed to `onHistoryCallback` for getBars.
 */
export interface HistoryMetadata {
  /**
   * Optional value indicating to the library that there is no more data on the server.
   */
  noData?: boolean;
  /**
   * Time of the next bar if there is no data in the requested period.
   * It should be set if the requested period represents a gap in the data. Hence there is available data prior to the requested period.
   */
  nextTime?: number | null;
}
export interface HollowCandleStylePreferences {
  /** Body color for an up candle */
  upColor: string;
  /** Body color for a down candle */
  downColor: string;
  /** Whether to draw the candle wick */
  drawWick: boolean;
  /** Whether to draw the candle body border */
  drawBorder: boolean;
  /** Whether to draw the candle body */
  drawBody: boolean;
  /** Candle border color */
  borderColor: string;
  /** Up candle border color */
  borderUpColor: string;
  /** Down candle border color */
  borderDownColor: string;
  /** Candle wick color */
  wickColor: string;
  /** Up candle wick color */
  wickUpColor: string;
  /** Down candle wick color */
  wickDownColor: string;
}
/**
 * Horizontal Line Preferences
 */
export interface HorizLinePreferences {
  /** Is visible if set to `true` */
  visible: boolean;
  /** Width of the horizontal line */
  width: number;
  /** Color of the horizontal line */
  color: string;
  /** Line style */
  style: LineStyle;
  /** Show price if set to `true` */
  showPrice?: boolean;
}

/**
 * Override properties for the Horzline drawing tool.
 */
export interface HorzlineLineToolOverrides {
  /** Default value: `false` */
  "linetoolhorzline.bold": boolean;
  /** Default value: `12` */
  "linetoolhorzline.fontsize": number;
  /** Default value: `center` */
  "linetoolhorzline.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetoolhorzline.italic": boolean;
  /** Default value: `#2962FF` */
  "linetoolhorzline.linecolor": string;
  /** Default value: `0` */
  "linetoolhorzline.linestyle": number;
  /** Default value: `2` */
  "linetoolhorzline.linewidth": number;
  /** Default value: `false` */
  "linetoolhorzline.showLabel": boolean;
  /** Default value: `true` */
  "linetoolhorzline.showPrice": boolean;
  /** Default value: `#2962FF` */
  "linetoolhorzline.textcolor": string;
  /** Default value: `top` */
  "linetoolhorzline.vertLabelsAlign": string;
}
/**
 * Override properties for the Horzray drawing tool.
 */
export interface HorzrayLineToolOverrides {
  /** Default value: `false` */
  "linetoolhorzray.bold": boolean;
  /** Default value: `12` */
  "linetoolhorzray.fontsize": number;
  /** Default value: `center` */
  "linetoolhorzray.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetoolhorzray.italic": boolean;
  /** Default value: `#2962FF` */
  "linetoolhorzray.linecolor": string;
  /** Default value: `0` */
  "linetoolhorzray.linestyle": number;
  /** Default value: `2` */
  "linetoolhorzray.linewidth": number;
  /** Default value: `false` */
  "linetoolhorzray.showLabel": boolean;
  /** Default value: `true` */
  "linetoolhorzray.showPrice": boolean;
  /** Default value: `#2962FF` */
  "linetoolhorzray.textcolor": string;
  /** Default value: `top` */
  "linetoolhorzray.vertLabelsAlign": string;
}
/**
 * Overrides for the 'Hull Moving Average' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface HullMovingAverageIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface IAction extends IMenuItem {
  /** @inheritDoc */
  readonly type: MenuItemType.Action;
  /**
   * A method which will be called when an action should be executed (e.g. when a user clicks on the item)
   */
  execute(): void;
  /**
   * @returns Returns a state object of the action.
   */
  getState(): Readonly<ActionState>;
  /**
   * @returns A subscription for an event when an action is updated.
   */
  onUpdate(): ISubscription<OnActionUpdateHandler>;
}
export interface IBoxedValue<T> extends IBoxedValueReadOnly<T> {
  /**
   * Set boxed value
   * @param  {T} value - value to be set
   */
  setValue(value: T): void;
}
export interface IBoxedValueReadOnly<T> {
  /** Value */
  value(): T;
}
export interface IBrokerAccountInfo {
  accountsMetainfo(): Promise<AccountMetainfo[]>;
  currentAccount(): AccountId;
  setCurrentAccount?(id: AccountId): void;
}
export interface IBrokerCommon {
  /**
   * Chart can have a sub-menu `Trading` in the context menu. This method should return an array of {@link ActionMetaInfo} elements, each of them representing one context menu item.
   * @param  {TradeContext} context - context object passed by a browser
   * @param  {DefaultContextMenuActionsParams} [options] - default options for the context menu action parameters
   */
  chartContextMenuActions(
    context: TradeContext,
    options?: DefaultContextMenuActionsParams
  ): Promise<ActionMetaInfo[]>;
  /**
   * This function is required for the Floating Trading Panel.
   * The ability to trade via the panel depends on the result of this function: `true` or `false`.
   * You don't need to implement this method if all symbols can be traded.
   *
   * If you want to show a custom message with the reason why the symbol cannot be traded then you can return an object `IsTradableResult`.
   * @param  {string} symbol - symbol identifier
   */
  isTradable(symbol: string): Promise<boolean | IsTradableResult>;
  /**
   * Connection status for the Broker API.
   *
   * You don't need to return values other than `1` (`Connected`) typically since the broker is already connected when you create the widget.
   * You can use it if you want to display a spinner in the bottom panel while the data is being loaded.
   */
  connectionStatus(): ConnectionStatus;
  /**
   * Called by Trading Platform to request orders
   */
  orders(): Promise<Order[]>;
  /**
   * This method is called by the Trading Platform to request orders history.
   * It is expected that returned orders will have a final status (`rejected`, `filled`, `cancelled`).
   *
   * This method is optional. If you don't support orders history, please set the {@link BrokerConfigFlags.supportOrdersHistory} flag to `false`.
   */
  ordersHistory?(): Promise<Order[]>;
  /**
   * Called by Trading Platform to request positions.
   * Required if the {@link BrokerConfigFlags.supportPositions} flag is set to `true`.
   */
  positions?(): Promise<Position[]>;
  /**
   * Called by Trading Platform to request individual positions.
   * Required if the {@link BrokerConfigFlags.supportPositionNetting} flag is set to `true`.
   */
  individualPositions?(): Promise<IndividualPosition[]>;
  /**
   * Called by Trading Platform to request executions for the specified symbol
   * @param  {string} symbol - symbol identifier
   */
  executions(symbol: string): Promise<Execution[]>;
  /**
   * Called by the internal Order dialog, DOM panel, and floating trading panel to get symbol information.
   * @param  {string} symbol - symbol identifier
   */
  symbolInfo(symbol: string): Promise<InstrumentInfo>;
  /**
   * This function should return the information that will be used to build an Account manager.
   */
  accountManagerInfo(): AccountManagerInfo;
  /**
   * Provide a custom price formatter for the specified symbol.
   * @param  {string} symbol - symbol identifier
   * @param  {boolean} alignToMinMove - align formatted number to the minimum movement amount of the symbol
   */
  formatter?(
    symbol: string,
    alignToMinMove: boolean
  ): Promise<INumberFormatter>;
  /**
   * Provide a custom spread formatter for the specified symbol.
   * @param  {string} symbol - symbol identifier
   */
  spreadFormatter?(symbol: string): Promise<INumberFormatter>;
  /**
   * Provide a custom quantity formatter for the specified symbol.
   * @param  {string} symbol - symbol identifier
   */
  quantityFormatter?(symbol: string): Promise<INumberFormatter>;
  /**
   * Implement this method if you want to [add custom fields](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/order-ticket.md#add-custom-fields) to the standard Order Ticket.
   *
   * Use the `symbol` parameter to return customization options for a particular symbol.
   * @param  {string} symbol - symbol identifier
   */
  getOrderDialogOptions?(
    symbol: string
  ): Promise<OrderDialogOptions | undefined>;
  /**
   * Implement this method if you want to customize the position dialog.
   */
  getPositionDialogOptions?(): PositionDialogOptions | undefined;
  /**
   * Implement this method if you want to have custom options available for different symbols.
   * @param  {string} symbol - symbol identifier
   */
  getSymbolSpecificTradingOptions?(
    symbol: string
  ): Promise<SymbolSpecificTradingOptions | undefined>;
}
export interface IBrokerConnectionAdapterFactory {
  /** Creates a Delegate object */
  createDelegate<T extends Function>(): IDelegate<T>;
  /** Creates a WatchedValue object */
  createWatchedValue<T>(value?: T): IWatchedValue<T>;
  /**
   * Creates a price formatter.
   * @param priceScale - Defines the number of decimal places. It is `10^number-of-decimal-places`. If a price is displayed as `1.01`, `pricescale` is `100`; If it is displayed as `1.005`, `pricescale` is `1000`.
   * @param minMove - The amount of price precision steps for 1 tick. For example, since the tick size for U.S. equities is `0.01`, `minmov` is 1. But the price of the E-mini S&P futures contract moves upward or downward by `0.25` increments, so the `minmov` is `25`.
   * @param fractional - For common prices, is `false` or it can be skipped. For more information on fractional prices, refer to [Fractional format](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Symbology.md#fractional-format).
   * @param minMove2 - For common prices, is `0` or it can be skipped.
   * @param variableMinTick - For common prices, is `string` (for example, `0.01 10 0.02 25 0.05`) or it can be skipped. For more information, refer to [Variable tick size](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Symbology.md#variable-tick-size).
   */
  createPriceFormatter(
    priceScale?: number,
    minMove?: number,
    fractional?: boolean,
    minMove2?: number,
    variableMinTick?: string
  ): IPriceFormatter;
}
/**
 * The Trading Host is an API for interaction between the Broker API and the library code related to trading.
 * Its main purpose is to receive information from your backend server where trading logic is implemented and provide updates to the library.
 * Refer to the [Core trading concepts](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/trading-concepts/trading-concepts.md) article for more information.
 */
export interface IBrokerConnectionAdapterHost {
  /** Broker Connection Adapter Factory object */
  factory: IBrokerConnectionAdapterFactory;
  /**
   * Generates and returns the default value formatter for the symbol
   * @param  {string} symbol - symbol identifier
   * @param  {boolean} alignToMinMove - whether the formatted number should be aligned to minimum movement for the symbol
   */
  defaultFormatter(
    symbol: string,
    alignToMinMove: boolean
  ): Promise<INumberFormatter>;
  /**
   * Generates and returns a number formatter with the desired decimal places
   * @param  {number} [decimalPlaces] - decimal places
   */
  numericFormatter(decimalPlaces: number): Promise<INumberFormatter>;
  /**
   * Generates and returns a quantity formatter with the desired decimal places
   * @param  {number} [decimalPlaces] - decimal places
   */
  quantityFormatter(decimalPlaces?: number): Promise<INumberFormatter>;
  /**
   * Provides default buy/sell, show properties actions to be returned as a default by {@link IBrokerCommon.chartContextMenuActions}.
   * @param  {TradeContext} context - trade context
   * @param  {DefaultContextMenuActionsParams} [params] - optional parameters
   */
  defaultContextMenuActions(
    context: TradeContext,
    params?: DefaultContextMenuActionsParams
  ): Promise<ActionMetaInfo[]>;
  /**
   * Provides default dropdown list of actions. You can use default actions in {@link IBrokerConnectionAdapterHost.setButtonDropdownActions}
   * @param  {Partial<DefaultDropdownActionsParams>} [options] - options for the dropdown menu actions
   */
  defaultDropdownMenuActions(
    options?: Partial<DefaultDropdownActionsParams>
  ): ActionMetaInfo[];
  /** Returns whether the buy/sell buttons are visible or not. */
  sellBuyButtonsVisibility(): IWatchedValue<boolean> | null;
  /** Returns whether DOM Panel is visible or not. */
  domPanelVisibility(): IWatchedValue<boolean> | null;
  /** Returns whether the order panel is visible or not. */
  orderPanelVisibility(): IWatchedValue<boolean> | null;
  /** Returns if orders can be sent to the broker without showing the order ticket. */
  silentOrdersPlacement(): IWatchedValue<boolean>;
  /**
   * Patch changes into the current broker configuration
   * @param  {Partial<BrokerConfigFlags>} config - partial configuration changes to apply
   */
  patchConfig(config: Partial<BrokerConfigFlags>): void;
  /**
   * Set expiration durations
   * @param  {OrderDurationMetaInfo[]} durations - Expiration options for orders
   */
  setDurations(durations: OrderDurationMetaInfo[]): void;
  /**
   * Call this method to notify the chart that it needs to update information after an order is added or changed.
   * @param  {Order} order - order which was added or changed
   */
  orderUpdate(order: Order): void;
  /**
   * Call this method when an order is not changed, but the fields that you added to the order object to display in the Account Manager have changed.
   * It should be used only if you want to display custom fields in the Account Manager.
   * @param  {string} id - order id
   * @param  {Partial<Order>} orderChanges - changes made to the order object
   */
  orderPartialUpdate(id: string, orderChanges: Partial<Order>): void;
  /**
   * Call this method when a position is added or changed.
   * @param  {Position} position - position which was added or changed
   * @param  {boolean} [isHistoryUpdate] - whether the change is a history update
   */
  positionUpdate(position: Position, isHistoryUpdate?: boolean): void;
  /**
   * Call this method when a position is not changed, but the fields that you added to the position object to display in the Account Manager have changed.
   * It should be used only if you want to display custom fields in the Account Manager.
   * @param  {string} id - id of the position
   * @param  {Partial<Position>} positionChanges - changes to the position object
   */
  positionPartialUpdate(id: string, positionChanges: Partial<Position>): void;
  /**
   * Call this method when an individual position is added or changed.
   * @param  {IndividualPosition} individualPosition - updated individual position
   * @param  {boolean} [isHistoryUpdate] - whether the change is a history update
   */
  individualPositionUpdate(
    individualPosition: IndividualPosition,
    isHistoryUpdate?: boolean
  ): void;
  /**
   * Call this method when an individual position has not changed, but fields that you added to the individual position object to display in the Account Manager have changed.
   * @param  {string} id - ID of the updated individual position
   * @param  {Partial<IndividualPosition>} changes - changes to the individual position object
   */
  individualPositionPartialUpdate(
    id: string,
    changes: Partial<IndividualPosition>
  ): void;
  /**
   * Call this method when an execution is added.
   * @param  {Execution} execution - execution which was added
   */
  executionUpdate(execution: Execution): void;
  /**
   * Call this method when user account has been changed synchronously. The terminal will re-request all displayed information.
   */
  currentAccountUpdate(): void;
  /**
   * Trading quote realtime update
   * @param  {string} symbol - symbol identifier
   * @param  {TradingQuotes} data - realtime updated data for the symbol quotes
   */
  realtimeUpdate(symbol: string, data: TradingQuotes): void;
  /**
   * Call this method when a broker connection has received a PL update.
   * Use this method when the {@link BrokerConfigFlags.supportPLUpdate} flag is set to `true` in {@link SingleBrokerMetaInfo.configFlags}.
   * @param  {string} positionId - ID of the position
   * @param  {number} pl - updated profit / loss value
   */
  plUpdate(positionId: string, pl: number): void;
  /**
   * Call this method when a broker connection has a `pipValue` update.
   * The library subscribes to `pipValue` updates using {@link IBrokerWithoutRealtime.subscribePipValue}.
   * @param  {string} symbol - symbol with updated pip values
   * @param  {PipValues} pipValues - updated pip values
   */
  pipValueUpdate(symbol: string, pipValues: PipValues): void;
  /**
   * Call this method when a broker connection has received an individual position PL update.
   * @param  {string} individualPositionId - ID of the individual position
   * @param  {number} pl - updated profit / loss for the individual position
   */
  individualPositionPLUpdate(individualPositionId: string, pl: number): void;
  /**
   * Call this method when a broker connection has received an equity update. This method is required by the standard Order Dialog to calculate risks.
   * @param  {number} equity - updated equity
   */
  equityUpdate(equity: number): void;
  /**
   * Call this method when a broker connection has received a margin available update.
   * This method is required by the standard Order Dialog to display the margin meter.
   * This method should be used when {@link BrokerConfigFlags.supportMargin} is set to `true` in {@link SingleBrokerMetaInfo.configFlags}.
   * The Trading Platform subscribes to margin available updates using {@link IBrokerWithoutRealtime.subscribeMarginAvailable}.
   * @param  {number} marginAvailable - updated available margin
   */
  marginAvailableUpdate(marginAvailable: number): void;
  /**
   * Call this method when a broker connection has received a balance update.
   * This method is required by the crypto Order Dialog.
   * It should be implemented when the {@link BrokerConfigFlags.supportBalances} flag is set to `true` in {@link SingleBrokerMetaInfo.configFlags}.
   * @param  {string} symbol - symbol ID
   * @param  {CryptoBalance} balance - updated crypto balance
   */
  cryptoBalanceUpdate(symbol: string, balance: CryptoBalance): void;
  /**
   * Update the Depth of Market for the specified symbol
   * @param  {string} symbol - symbol identifier
   * @param  {DOMData} equity - Depth of market data
   */
  domUpdate(symbol: string, equity: DOMData): void;
  /**
   * Sets the quantity for a given symbol.
   * @param  {string} symbol - symbol
   * @param  {number} quantity - quantity to update
   */
  setQty(symbol: string, quantity: number): void;
  /**
   * Returns the quantity for a given symbol.
   * @param  {string} symbol - symbol
   * @return  {Promise<number>} - quantity for the given symbol
   */
  getQty(symbol: string): Promise<number>;
  /**
   * Adds a callback to be executed whenever there's a change of quantity for a given symbol.
   *
   * It's the user's responsibility to manage the unsubscription of any added listener
   *
   * @param  {string} symbol - symbol to which the callback will be linked to
   * @param  {SuggestedQtyChangedListener} listener - callback
   */
  subscribeSuggestedQtyChange(
    symbol: string,
    listener: SuggestedQtyChangedListener
  ): void;
  /**
   * Remove a previously added callback from the list.
   * @param  {string} symbol - symbol to remove the callback from
   * @param  {SuggestedQtyChangedListener} listener - callback to be removed
   */
  unsubscribeSuggestedQtyChange(
    symbol: string,
    listener: SuggestedQtyChangedListener
  ): void;
  /**
   * Shows the order dialog
   * @param  {T extends PreOrder} order - order to show in the dialog
   * @param  {OrderTicketFocusControl} [focus] - input control to focus on when dialog is opened
   */
  showOrderDialog?<T extends PreOrder>(
    order: T,
    focus?: OrderTicketFocusControl
  ): Promise<boolean>;
  /**
   * Shows notification message
   * @param  {string} title - notification title
   * @param  {string} text - notification content
   * @param  {NotificationType} [notificationType] - type of notification (default: NotificationType.Error)
   */
  showNotification(
    title: string,
    text: string,
    notificationType?: NotificationType
  ): void;
  /**
   * Shows the cancel order dialog for specified order
   * @param  {string} orderId - id of order to potentially cancel
   * @param  {()=>Promise<void>} handler - cancel order confirmation handler (called when order should be cancelled)
   */
  showCancelOrderDialog(
    orderId: string,
    handler: () => Promise<void>
  ): Promise<void>;
  /**
   * Shows the cancel order dialog for multiple orders
   * @param  {string} symbol - symbol for which to cancel orders
   * @param  {Side} side - side of the order
   * @param  {number} qty - quantity of the order
   * @param  {()=>Promise<void>} handler - cancel orders confirmation handler (called when orders should be cancelled)
   */
  showCancelMultipleOrdersDialog(
    symbol: string,
    side: Side,
    qty: number,
    handler: () => Promise<void>
  ): Promise<void>;
  /**
   * Shows the cancel brackets dialog
   * @param  {string} orderId - id of order
   * @param  {()=>Promise<void>} handler - cancel brackets confirmation handler (called when brackets should be cancelled)
   */
  showCancelBracketsDialog(
    orderId: string,
    handler: () => Promise<void>
  ): Promise<void>;
  /**
   * Shows the cancel brackets dialog for multiple brackets
   * @param  {string} orderId - id of order
   * @param  {()=>Promise<void>} handler - cancel brackets confirmation handler (called when brackets should be cancelled)
   */
  showCancelMultipleBracketsDialog(
    orderId: string,
    handler: () => Promise<void>
  ): Promise<void>;
  /**
   * Shows reverse position dialog
   * @param  {string} position - position to be reversed
   * @param  {()=>Promise<boolean>} handler - reverse position confirmation handler (called when the position should be reversed)
   */
  showReversePositionDialog(
    position: string,
    handler: () => Promise<boolean>
  ): Promise<boolean>;
  /**
   * Shows the position brackets dialog
   * @param  {Position|IndividualPosition} position - position or individual position
   * @param  {Brackets} brackets - brackets for the position or individual position
   * @param  {OrderTicketFocusControl} focus - input control to focus on when dialog is opened
   */
  showPositionBracketsDialog(
    position: Position | IndividualPosition,
    brackets: Brackets,
    focus: OrderTicketFocusControl
  ): Promise<boolean>;
  /**
   * Activate bottom widget
   */
  activateBottomWidget(): Promise<void>;
  /**
   * Shows trading properties
   */
  showTradingProperties(): void;
  /**
   * Returns symbol `minTick`.
   * @param  {string} symbol - symbol identifier
   */
  getSymbolMinTick(symbol: string): Promise<number>;
  /**
   * Displays a message dialog to a user.
   * @param  {string} title - title of the message dialog
   * @param  {string} text - message
   * @param  {boolean} [textHasHTML] - whether message text contains HTML
   */
  showMessageDialog(title: string, text: string, textHasHTML?: boolean): void;
  /**
   * Displays a confirmation dialog to a user and returns a Promise to the result.
   * @param  {string} title - title of the confirmation dialog
   * @param  {string|string[]} content - content for the dialog
   * @param  {string} [mainButtonText] - text for the main button (`true` result)
   * @param  {string} [cancelButtonText] - text for the cancel button (`false` result)
   * @param  {boolean} [showDisableConfirmationsCheckbox] - show disable confirmations checkbox within the dialog
   */
  showConfirmDialog(
    title: string,
    content: string | string[],
    mainButtonText?: string,
    cancelButtonText?: string,
    showDisableConfirmationsCheckbox?: boolean
  ): Promise<boolean>;
  /**
   * Displays a simple confirmation dialog to a user and returns a Promise to the result.
   * @param  {string} title - title of the confirmation dialog
   * @param  {string|string[]} content - content for the dialog
   * @param  {string} [mainButtonText] - text for the main button (`true` result)
   * @param  {string} [cancelButtonText] - text for the cancel button (`false` result)
   * @param  {boolean} [showDisableConfirmationsCheckbox] - show disable confirmations checkbox within the dialog
   */
  showSimpleConfirmDialog(
    title: string,
    content: string | string[],
    mainButtonText?: string,
    cancelButtonText?: string,
    showDisableConfirmationsCheckbox?: boolean
  ): Promise<boolean>;
}
export interface IBrokerTerminal extends IBrokerWithoutRealtime {
  /**
   * Library is requesting that realtime updates should be supplied for this symbol.
   * @param  {string} symbol - symbol identifier
   */
  subscribeRealtime(symbol: string): void;
  /**
   * Library is notifying that realtime updates are no longer required for this symbol.
   * @param  {string} symbol - symbol identifier
   */
  unsubscribeRealtime(symbol: string): void;
}
/**
 * The Broker API is a key component that enables trading.
 * Its main purpose is to connect TradingView charts with your trading logic.
 * Refer to the [Core trading concepts](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/trading-concepts/trading-concepts.md) article for more information.
 */
export interface IBrokerWithoutRealtime
  extends IBrokerCommon,
    IBrokerAccountInfo {
  /**
   * Library is requesting that realtime DOM (Depth of Market) updates should be supplied for this symbol
   * @param  {string} symbol - symbol identifier
   */
  subscribeDOM?(symbol: string): void;
  /**
   * Library is notifying that realtime DOM (Depth of Market) updates are no longer required for this symbol.
   * @param  {string} symbol - symbol identifier
   */
  unsubscribeDOM?(symbol: string): void;
  /**
   * Method is called when a user wants to place an order.
   * Order is pre-filled with partial or complete information.
   * This function returns an object with the order ID.
   * To enable order preview before placing it, set {@link BrokerConfigFlags.supportPlaceOrderPreview} to `true`.
   * @param  {PreOrder} order - order information
   * @param  {string} [confirmId] - is passed if the `supportPlaceOrderPreview` configuration flag is on.
   * @returns PlaceOrderResult, which should include an `orderId`
   */
  placeOrder(order: PreOrder, confirmId?: string): Promise<PlaceOrderResult>;
  /**
   * Returns estimated commission, fees, margin, and other information for the order without it actually being placed.
   * The method is called if the {@link BrokerConfigFlags.supportPlaceOrderPreview} or {@link BrokerConfigFlags.supportModifyOrderPreview} configuration flag is on.
   * @param  {PreOrder} order - order information
   */
  previewOrder?(order: PreOrder): Promise<OrderPreviewResult>;
  /**
   * Method is called when a user wants to modify an existing order.
   *
   * Note that the library expects you to call the {@link IBrokerConnectionAdapterHost.orderUpdate} method right afterwards.
   * Otherwise, the library will return a [timeout issue](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/common-issues.md#timeout-issue).
   *
   * To enable order preview before modifying it, set {@link BrokerConfigFlags.supportModifyOrderPreview} to `true`.
   * @param  {Order} order - order information
   * @param  {string} [confirmId] - is passed if `supportModifyOrderPreview` configuration flag is on.
   */
  modifyOrder(order: Order, confirmId?: string): Promise<void>;
  /**
   * This method is called to cancel a single order with the given `id`.
   *
   * Note that the library expects you to call the {@link IBrokerConnectionAdapterHost.orderUpdate} method right afterwards.
   * @param  {string} orderId - ID for the order to cancel
   */
  cancelOrder(orderId: string): Promise<void>;
  /**
   * This method is called to cancel multiple orders for a `symbol` and `side`.
   * The `ordersIds` parameter should contain the list of order ids to be cancelled.
   *
   * Note that the library expects you to call the {@link IBrokerConnectionAdapterHost.orderUpdate} method right afterwards.
   * @param  {string} symbol - symbol identifier
   * @param  {Side|undefined} side - order side
   * @param  {string[]} ordersIds - ids already collected by `symbol` and `side`
   */
  cancelOrders(
    symbol: string,
    side: Side | undefined,
    ordersIds: string[]
  ): Promise<void>;
  /**
   * This method is called if the {@link BrokerConfigFlags.supportNativeReversePosition} configuration flag is on.
   * It allows reversing the position by ID.
   *
   * Note that the library expects you to call the {@link IBrokerConnectionAdapterHost.positionUpdate} method right afterwards.
   * Otherwise, the library will return a [timeout issue](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/common-issues.md#timeout-issue).
   * @param  {string} positionId - position
   */
  reversePosition?(positionId: string): Promise<void>;
  /**
   * This method is called if the {@link BrokerConfigFlags.supportClosePosition} or {@link BrokerConfigFlags.supportPartialClosePosition} configuration flag is on.
   * It allows closing the position by ID.
   *
   * Note that the library expects you to call the {@link IBrokerConnectionAdapterHost.positionUpdate} method right afterwards.
   * Otherwise, the library will return a [timeout issue](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/common-issues.md#timeout-issue).
   * @param  {string} positionId - Position ID.
   * @param  {number} [amount] - The amount is specified if `supportPartialClosePosition` is `true` and the user wants to close only part of the position.
   */
  closePosition?(positionId: string, amount?: number): Promise<void>;
  /**
   * This method is called if the {@link BrokerConfigFlags.supportCloseIndividualPosition} or {@link BrokerConfigFlags.supportPartialCloseIndividualPosition} configuration flag is on.
   * It allows closing the individual position by ID.
   *
   * Note that the library expects you to call the {@link IBrokerConnectionAdapterHost.positionUpdate} method right afterwards.
   * Otherwise, the library will return a [timeout issue](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/common-issues.md#timeout-issue).
   * @param  {string} individualPositionId - Individual position ID.
   * @param  {number} [amount] - The amount is specified if `supportPartialCloseIndividualPosition` is `true` and the user wants to close only part of the individual position.
   */
  closeIndividualPosition?(
    individualPositionId: string,
    amount?: number
  ): Promise<void>;
  /**
   * This method is called if the {@link BrokerConfigFlags.supportPositionBrackets} configuration flag is on.
   * It shows a dialog that enables take-profit and stop-loss editing.
   *
   * Note that the library expects you to call the {@link IBrokerConnectionAdapterHost.positionUpdate} method right afterwards.
   * @param  {string} positionId - is an ID of an existing position to be modified
   * @param  {Brackets} brackets - new Brackets to be set for the position
   * @param  {CustomInputFieldsValues} [customFields] - custom fields to display in the dialog
   */
  editPositionBrackets?(
    positionId: string,
    brackets: Brackets,
    customFields?: CustomInputFieldsValues
  ): Promise<void>;
  /**
   * This method is called if the {@link BrokerConfigFlags.supportIndividualPositionBrackets} configuration flag is on.
   * It displays a dialog that enables take-profit and stop-loss editing.
   *
   * Note that the library expects you to call the {@link IBrokerConnectionAdapterHost.positionUpdate} method right afterwards.
   * @param  {string} individualPositionId - ID of existing individual position to be modified
   * @param  {Brackets} brackets - new Brackets to be set for the individual position
   */
  editIndividualPositionBrackets?(
    individualPositionId: string,
    brackets: Brackets
  ): Promise<void>;
  /**
   * This method is called to receive leverageInfo from the broker.
   * @param  {LeverageInfoParams} leverageInfoParams - information about the specific symbol to provide leverage information for
   */
  leverageInfo?(leverageInfoParams: LeverageInfoParams): Promise<LeverageInfo>;
  /**
   * This method is called to send user's leverage value to the broker. The value should be verified and corrected on the broker's side if required, and sent back in the response.
   * @param  {LeverageSetParams} leverageSetParams - `leverageSetParams` is an object similar to {@link leverageInfoParams}, but contains an additional `leverage: number` field, which holds the leverage value set by the user.
   */
  setLeverage?(
    leverageSetParams: LeverageSetParams
  ): Promise<LeverageSetResult>;
  /**
   * This method is called to receive {@link LeveragePreviewResult} object which holds messages about the leverage value set by the user.
   * @param  {LeverageSetParams} leverageSetParams - `leverageSetParams` is an object similar to {@link leverageInfoParams}, but contains an additional `leverage: number` field, which holds the leverage value set by the user.
   */
  previewLeverage?(
    leverageSetParams: LeverageSetParams
  ): Promise<LeveragePreviewResult>;
  /**
   * The method should be implemented if you use the standard Order dialog and support stop loss. Equity is used to calculate Risk in Percent.
   *
   * Once this method is called the broker should provide equity (Balance + P/L) updates via {@link IBrokerConnectionAdapterHost.equityUpdate} method.
   */
  subscribeEquity?(): void;
  /**
   * The method should be implemented if you use the standard Order dialog and want to show the margin meter.
   *
   * Once this method is called the broker should provide margin available updates via {@link IBrokerConnectionAdapterHost.marginAvailableUpdate} method.
   * @param  {string} symbol - symbol identifier
   */
  subscribeMarginAvailable?(symbol: string): void;
  /**
   * The method should be implemented if you use a standard Order dialog.
   * `pipValues` is displayed in the Order info and it is used to calculate the Trade Value and risks.
   * If this method is not implemented then `pipValue` from the `symbolInfo` is used in the order panel/dialog.
   *
   * Once this method is called the broker should provide `pipValue` updates via {@link IBrokerConnectionAdapterHost.pipValueUpdate} method.
   * @param  {string} symbol - symbol identifier
   */
  subscribePipValue?(symbol: string): void;
  /**
   * The method should be implemented if you use a standard Order dialog and implement `subscribePipValue`.
   *
   * Once this method is called the broker should stop providing `pipValue` updates.
   * @param  {string} symbol - symbol identifier
   */
  unsubscribePipValue?(symbol: string): void;
  /**
   * The method should be implemented if you use the standard Order dialog want to show the margin meter.
   *
   * Once this method is called the broker should stop providing margin available updates.
   * @param  {string} symbol - symbol identifier
   */
  unsubscribeMarginAvailable?(symbol: string): void;
  /**
   * The method should be implemented if you use the standard Order dialog and support stop loss.
   *
   * Once this method is called the broker should stop providing equity updates.
   */
  unsubscribeEquity?(): void;
}
/**
 * The main chart API.
 *
 * This interface can be retrieved by using the following widget ({@link IChartingLibraryWidget}) methods:
 * - `chart` ({@link IChartingLibraryWidget.chart})
 * - `activeChart` ({@link IChartingLibraryWidget.activeChart})
 */
export interface IChartWidgetApi {
  /**
   * Get a subscription object for new data being loaded for the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().onDataLoaded().subscribe(
   *     null,
   *     () => console.log('New history bars are loaded'),
   *     true
   * );
   * ```
   * @returns A subscription object for new data loaded for the chart.
   */
  onDataLoaded(): ISubscription<() => void>;
  /**
   * Get a subscription object for the chart symbol changing.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().onSymbolChanged().subscribe(null, () => console.log('The symbol is changed'));
   * ```
   * @returns A subscription object for when a symbol is resolved (ie changing resolution, timeframe, currency, etc.)
   */
  onSymbolChanged(): ISubscription<() => void>;
  /**
   * Get a subscription object for the chart resolution (interval) changing. This method also allows you to track whether the chart's [date range](https://www.tradingview.com/charting-library-docs/latest/getting_started/glossary.md#date-range) is changed.
   * The `timeframe` argument represents if a user clicks on the [time frame toolbar](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Time-Scale.md#time-frame-toolbar) or changes the date range manually.
   * If `timeframe` is `undefined`, you can change a date range before data loading starts.
   * To do this, you can specify a time frame value or a certain date range.
   *
   * **Examples**
   *
   * The following code sample specifies a time frame value:
   *
   * ```javascript
   * widget.activeChart().onIntervalChanged().subscribe(null, (interval, timeframeObj) =>
   *     timeframeObj.timeframe = {
   *         value: "12M",
   *         type: "period-back"
   * });
   * ```
   *
   * The following code sample specifies a certain date range:
   *
   * ```javascript
   * widget.activeChart().onIntervalChanged().subscribe(null, (interval, timeframeObj) =>
   *     timeframeObj.timeframe = {
   *         from: new Date('2015-01-01').getTime() / 1000,
   *         to: new Date('2017-01-01').getTime() / 1000,
   *         type: "time-range"
   *     });
   * ```
   * @returns A subscription object for the chart interval (resolution) changing.
   */
  onIntervalChanged(): ISubscription<
    (
      interval: ResolutionString,
      timeFrameParameters: {
        timeframe?: TimeFrameValue;
      }
    ) => void
  >;
  /**
   * Get a subscription object for the chart's visible range changing.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().onVisibleRangeChanged().subscribe(
   *     null,
   *     ({ from, to }) => console.log(from, to)
   * );
   * ```
   * @returns A subscription object for the chart's visible range changing.
   */
  onVisibleRangeChanged(): ISubscription<(range: VisibleTimeRange) => void>;
  /**
   * Get a subscription object for the chart type changing.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().onChartTypeChanged().subscribe(
   *     null,
   *     (chartType) => console.log('The type of chart is changed')
   * );
   * ```
   * @returns A subscription object for the chart type changing.
   */
  onChartTypeChanged(): ISubscription<(chartType: SeriesType) => void>;
  /**
   * Provide a callback function that will be called when chart data is loaded.
   * If chart data is already loaded when this method is called, the callback is called immediately.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().dataReady(() => {
   *     // ...
   * }
   * ```
   *
   * @param callback A callback function called when chart data is loaded.
   */
  dataReady(callback?: () => void): boolean;
  /**
   * Get a subscription object for the crosshair moving over the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().crossHairMoved().subscribe(
   *     null,
   *     ({ time, price }) => console.log(time, price)
   * );
   * ```
   * @returns A subscription object for the crosshair moving over the chart.
   */
  crossHairMoved(): ISubscription<(params: CrossHairMovedEventParams) => void>;
  /**
   * Get a subscription object for the ID of the study or series hovered by the crosshair.
   *
   * @returns A subscription object for the ID of the study or series hovered by the crosshair. Subscribers will be called with `null` if there is no study or series hovered.
   */
  onHoveredSourceChanged(): ISubscription<(sourceId: EntityId) => void>;
  /**
   * Scroll and/or scale the chart so a time range is visible.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().setVisibleRange(
   *     { from: 1420156800, to: 1451433600 },
   *     { percentRightMargin: 20 }
   * ).then(() => console.log('New visible range is applied'));
   * ```
   * @param range A range that will be made visible.
   * @param options Optional object of options for the new visible range.
   * @returns A promise that is resolved when the range has been set.
   */
  setVisibleRange(
    range: SetVisibleTimeRange,
    options?: SetVisibleRangeOptions
  ): Promise<void>;
  /**
   * Change the chart's symbol.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().setSymbol('IBM');
   * ```
   * Note: if you are attempting to change multiple charts (multi-chart layouts) at the same time with
   * multiple `setSymbol` calls then you should set `doNotActivateChart` option to `true`.
   *
   * @param symbol A symbol.
   * @param options Optional object of options for the new symbol or optional callback that is called when the data for the new symbol has loaded.
   */
  setSymbol(symbol: string, options?: SetSymbolOptions | (() => void)): void;
  /**
   * Change the chart's interval (resolution).
   *
   * **Example**
   * ```javascript
   * widget.activeChart().setResolution('2M');
   * ```
   * Note: if you are attempting to change multiple charts (multi-chart layouts) at the same time with
   * multiple `setResolution` calls then you should set `doNotActivateChart` option to `true`.
   *
   * @param resolution A resolution.
   * @param options Optional object of options for the new resolution or optional callback that is called when the data for the new resolution has loaded.
   * @returns A promise that resolves with a boolean value. It's `true` when the resolution has been set and `false` when setting the resolution is not possible.
   */
  setResolution(
    resolution: ResolutionString,
    options?: SetResolutionOptions | (() => void)
  ): Promise<boolean>;
  /**
   * Change the chart's type.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().setChartType(12); // Specifies the High-low type
   * ```
   *
   * @param type A chart type.
   * @param callback An optional callback function. Called when the chart type has changed and data has loaded.
   * @returns A promise that resolves with a boolean value. It's `true` when the chart type has been set and `false` when setting the chart type is not possible.
   */
  setChartType(type: SeriesType, callback?: () => void): void;
  /**
   * Force the chart to re-request data, for example if there are [internet connection issues](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Datafeed-Issues.md#internet-connection-issues).
   * Before calling this function the `onResetCacheNeededCallback` callback from {@link IDatafeedChartApi.subscribeBars} should be called.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().resetData();
   * ```
   *
   */
  resetData(): void;
  /**
   * Execute an action.
   *
   * **Example**
   * ```javascript
   * // ...
   * widget.activeChart().executeActionById("undo");
   * // ...
   * widget.activeChart().executeActionById("drawingToolbarAction"); // Hides or shows the drawing toolbar
   * // ...
   * ```
   *
   * @param actionId An action ID.
   */
  executeActionById(actionId: ChartActionId): void;
  /**
   * Get the state of a checkable action.
   *
   * **Example**
   * ```javascript
   * if (widget.activeChart().getCheckableActionState("drawingToolbarAction")) {
   *     // ...
   * };
   * ```
   *
   * @param actionId An action ID.
   * @returns `true` if the action is checked, `false` otherwise.
   */
  getCheckableActionState(actionId: ChartActionId): boolean;
  /**
   * Force the chart to re-request all bar marks and timescale marks.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().refreshMarks();
   * ```
   *
   */
  refreshMarks(): void;
  /**
   * Remove marks from the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().clearMarks();
   * ```
   *
   * @param marksToClear type of marks to clear. If nothing is specified both bar & timescale marks will be removed.
   */
  clearMarks(marksToClear?: ClearMarksMode): void;
  /**
   * Get an array of IDs and name for all drawings on the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().getAllShapes().forEach(({ name }) => console.log(name));
   * ```
   *
   * @returns An array of drawing information.
   */
  getAllShapes(): EntityInfo[];
  /**
   * Get an array of IDs and names for all studies on the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().getAllStudies().forEach(({ name }) => console.log(name));
   * ```
   *
   * @returns An array of study information.
   */
  getAllStudies(): EntityInfo[];
  /**
   * Get the chart's price to bar ratio.
   *
   * **Example**
   * ```javascript
   * console.log(widget.activeChart().getPriceToBarRatio());
   * ```
   *
   * @returns The ratio or `null` if no ratio is defined.
   */
  getPriceToBarRatio(): number | null;
  /**
   * Set the chart's price to bar ratio.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().setPriceToBarRatio(0.4567, { disableUndo: true });
   * ```
   *
   * @param ratio The new price to bar ratio.
   * @param options Optional undo options.
   */
  setPriceToBarRatio(ratio: number, options?: UndoOptions): void;
  /**
   * Get the locked/unlocked state of the chart's price to bar ratio.
   *
   * **Example**
   * ```javascript
   * console.log(widget.activeChart().isPriceToBarRatioLocked());
   * ```
   *
   */
  isPriceToBarRatioLocked(): boolean;
  /**
   * Lock or unlock the chart's price to bar ratio.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().setPriceToBarRatioLocked(true, { disableUndo: false });
   * ```
   *
   * @param value `true` to lock, `false` to unlock.
   * @param options Optional undo options.
   */
  setPriceToBarRatioLocked(value: boolean, options?: UndoOptions): void;
  /**
   * Get an array of the heigh of all panes.
   *
   * **Example**
   * ```javascript
   * console.log(widget.activeChart().getAllPanesHeight());
   * ```
   *
   * @returns An array of heights.
   */
  getAllPanesHeight(): number[];
  /**
   * Set the height for each pane in the order provided.
   *
   * **Example**
   * ```javascript
   * console.log(widget.activeChart().setAllPanesHeight([250, 400, 200]));
   * ```
   *
   * @param heights An array of heights.
   */
  setAllPanesHeight(heights: readonly number[]): void;
  /**
   * Maximize to its full size currently selected chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().maximizeChart();
   * ```
   */
  maximizeChart(): void;
  /**
   * Check if the chart is maximized or not.
   *
   * @returns `true` if maximized, `false` otherwise.
   */
  isMaximized(): boolean;
  /**
   * Restore to its initial size currently selected chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().restoreChart();
   * ```
   */
  restoreChart(): void;
  /**
   * Get an object with operations available for the specified set of entities.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().availableZOrderOperations([id]);
   * ```
   *
   * @param sources An array of entity IDs.
   */
  availableZOrderOperations(
    sources: readonly EntityId[]
  ): AvailableZOrderOperations;
  /**
   * Move the group to the bottom of the Z-order.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().sendToBack([id]);
   * ```
   *
   * @param entities An array of entity IDs.
   */
  sendToBack(entities: readonly EntityId[]): void;
  /**
   * Move the sources to the top of the Z-order.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().bringToFront([id]);
   * ```
   *
   * @param sources An array of source IDs.
   */
  bringToFront(sources: readonly EntityId[]): void;
  /**
   * Move the sources one level up in the Z-order.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().bringForward([id]);
   * ```
   *
   * @param sources An array of source IDs.
   */
  bringForward(sources: readonly EntityId[]): void;
  /**
   * Move the sources one level down in the Z-order.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().sendBackward([id]);
   * ```
   *
   * @param sources An array of source IDs.
   */
  sendBackward(sources: readonly EntityId[]): void;
  /**
   * Adds an indicator or a symbol for comparison to the chart.
   * For more information, refer to the [Indicators](https://www.tradingview.com/charting-library-docs/latest/ui_elements/indicators/indicators.md) article.
   *
   * @param  {string} name - name of an indicator as shown in the `Indicators` widget
   * @param  {boolean} [forceOverlay] - forces the Charting Library to place the created indicator on the main pane
   * @param  {boolean} [lock] - whether a user will be able to remove/change/hide the indicator or not
   * @param  {Record<string} [inputs] - **From version v22**, it's an object containing named properties from the indicator properties dialog.
   * @param  {TOverrides} [overrides] - An object that contains [overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md#customize-a-single-indicator) for a new indicator. Note that you should not specify the indicator name. Overrides for built-in indicators are listed in `SingleIndicatorOverrides`.
   * @param  {CreateStudyOptions} [options] - study creation options
   * @returns ID of the created study
   */
  createStudy<TOverrides extends Partial<SingleIndicatorOverrides>>(
    name: string,
    forceOverlay?: boolean,
    lock?: boolean,
    inputs?: Record<string, StudyInputValue>,
    overrides?: TOverrides,
    options?: CreateStudyOptions
  ): Promise<EntityId | null>;
  /**
   * Get a study by ID.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().getStudyById(id).setVisible(false);
   * ```
   *
   * @param entityId The study ID.
   * @returns An API object for interacting with the study.
   */
  getStudyById(entityId: EntityId): IStudyApi;
  /**
   * Get the main series.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().getSeries().setVisible(false);
   * ```
   *
   * @returns An API object for interacting with the main series.
   */
  getSeries(): ISeriesApi;
  /**
   * Create a new single point drawing.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().createShape({ time: 1514764800 }, { shape: 'vertical_line' });
   * ```
   *
   * For more information, refer to [Drawings API](https://www.tradingview.com/charting-library-docs/latest/ui_elements/drawings/drawings-api.md#createshape).
   *
   * @param point A point. The location of the new drawing.
   * @param options An options object for the new drawing.
   * @returns The ID of the new drawing if it was created successfully, or null otherwise.
   */
  createShape<TOverrides extends object>(
    point: ShapePoint,
    options: CreateShapeOptions<TOverrides>
  ): EntityId | null;
  /**
   * Create a new multi point drawing.
   *
   * **Example**
   * ```javascript
   * const from = Date.now() / 1000 - 500 * 24 * 3600; // 500 days ago
   * const to = Date.now() / 1000;
   * widget.activeChart().createMultipointShape(
   *     [{ time: from, price: 150 }, { time: to, price: 150 }],
   *     {
   *         shape: "trend_line",
   *         lock: true,
   *         disableSelection: true,
   *         disableSave: true,
   *         disableUndo: true,
   *         text: "text",
   *     }
   * );
   * ```
   *
   * For more information, refer to [Drawings API](https://www.tradingview.com/charting-library-docs/latest/ui_elements/drawings/drawings-api.md#createmultipointshape).
   *
   * @param points An array of points that define the drawing.
   * @param options An options object for the new drawing.
   * @returns The ID of the new drawing if it was created successfully, or null otherwise.
   */
  createMultipointShape<TOverrides extends object>(
    points: ShapePoint[],
    options: CreateMultipointShapeOptions<TOverrides>
  ): EntityId | null;
  /**
   * Create a new anchored drawing. Anchored drawings maintain their position when the chart's visible range changes.
   *
   * **Example**
   * ```javascript
   * widget.createAnchoredShape({ x: 0.1, y: 0.9 }, { shape: 'anchored_text', text: 'Hello, charts!', overrides: { color: 'green' }});
   * ```
   *
   * For more information, refer to [Drawings API](https://www.tradingview.com/charting-library-docs/latest/ui_elements/drawings/drawings-api.md#createanchoredshape).
   *
   * @param position Percent-based x and y position of the new drawing, relative to the top left of the chart.
   * @param options An options object for the new drawing.
   */
  createAnchoredShape<TOverrides extends object>(
    position: PositionPercents,
    options: CreateAnchoredShapeOptions<TOverrides>
  ): EntityId | null;
  /**
   * Get a drawing by ID.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().getShapeById(id).bringToFront();
   * ```
   *
   * For more information, refer to [Drawings API](https://www.tradingview.com/charting-library-docs/latest/ui_elements/drawings/drawings-api.md#manage-drawings).
   *
   * @param entityId A drawing ID.
   * @returns An API object for interacting with the drawing.
   */
  getShapeById(entityId: EntityId): ILineDataSourceApi;
  /**
   * Remove an entity (e.g. drawing or study) from the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().removeEntity(id);
   * ```
   *
   * @param entityId The ID of the entity.
   * @param options Optional undo options.
   */
  removeEntity(entityId: EntityId, options?: UndoOptions): void;
  /**
   * Remove all drawings from the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().removeAllShapes();
   * ```
   *
   */
  removeAllShapes(): void;
  /**
   * Remove all studies from the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().removeAllStudies();
   * ```
   *
   */
  removeAllStudies(): void;
  /**
   * Get an API object for interacting with the selection.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().selection().clear();
   * ```
   *
   */
  selection(): ISelectionApi;
  /**
   * Show the properties dialog for a study or drawing.
   *
   * **Example**
   * ```javascript
   * const chart = widget.activeChart();
   * chart.showPropertiesDialog(chart.getAllShapes()[0].id);`
   * ```
   *
   * @param studyId An ID of the study or drawing.
   */
  showPropertiesDialog(studyId: EntityId): void;
  /**
   * Save the current study template to a object.
   *
   * **Example**
   * ```javascript
   * const options = { saveSymbol: true, saveInterval: true };
   * const template = widget.activeChart().createStudyTemplate(options);
   * ```
   *
   * @param options An object of study template options.
   * @returns A study template object.
   */
  createStudyTemplate(options: CreateStudyTemplateOptions): object;
  /**
   * Apply a study template to the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().applyStudyTemplate(template);
   * ```
   *
   * @param template A study template object.
   */
  applyStudyTemplate(template: object): void;
  /**
   * Create a new trading order on the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().createOrderLine()
   *     .setTooltip("Additional order information")
   *     .setModifyTooltip("Modify order")
   *     .setCancelTooltip("Cancel order")
   *     .onMove(function() {
   *         this.setText("onMove called");
   *     })
   *     .onModify("onModify called", function(text) {
   *         this.setText(text);
   *     })
   *     .onCancel("onCancel called", function(text) {
   *         this.setText(text);
   *     })
   *     .setText("STOP: 73.5 (5,64%)")
   *     .setQuantity("2");
   * ```
   *
   * @param options Optional undo options.
   * @returns An API object for interacting with the order.
   */
  createOrderLine(options?: UndoOptions): IOrderLineAdapter;
  /**
   * Creates a new trading position on the chart.
   *
   * **Example**
   * ```javascript
   * widget.chart().createPositionLine()
   *     .onModify(function() {
   *         this.setText("onModify called");
   *     })
   *     .onReverse("onReverse called", function(text) {
   *         this.setText(text);
   *     })
   *     .onClose("onClose called", function(text) {
   *         this.setText(text);
   *     })
   *     .setText("PROFIT: 71.1 (3.31%)")
   *     .setTooltip("Additional position information")
   *     .setProtectTooltip("Protect position")
   *     .setCloseTooltip("Close position")
   *     .setReverseTooltip("Reverse position")
   *     .setQuantity("8.235")
   *     .setPrice(160)
   *     .setExtendLeft(false)
   *     .setLineStyle(0)
   *     .setLineLength(25);
   * ```
   *
   * @param options Optional undo options.
   * @returns An API object for interacting with the position.
   */
  createPositionLine(options?: UndoOptions): IPositionLineAdapter;
  /**
   * Creates a new trade execution on the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().createExecutionShape()
   *     .setText("@1,320.75 Limit Buy 1")
   *     .setTooltip("@1,320.75 Limit Buy 1")
   *     .setTextColor("rgba(0,255,0,0.5)")
   *     .setArrowColor("#0F0")
   *     .setDirection("buy")
   *     .setTime(widget.activeChart().getVisibleRange().from)
   *     .setPrice(160);
   * ```
   *
   * @param options Optional undo options.
   * @returns An API object for interacting with the execution.
   */
  createExecutionShape(options?: UndoOptions): IExecutionLineAdapter;
  /**
   * Get the name of the current symbol.
   *
   * **Example**
   * ```javascript
   * console.log(widget.activeChart().symbol());
   * ```
   *
   */
  symbol(): string;
  /**
   * Get an extended information object for the current symbol.
   *
   * **Example**
   * ```javascript
   * console.log(widget.activeChart().symbolExt().full_name);
   * ```
   *
   */
  symbolExt(): SymbolExt | null;
  /**
   * Get the current resolution (interval).
   *
   * **Example**
   * ```javascript
   * console.log(widget.activeChart().resolution());
   * ```
   *
   */
  resolution(): ResolutionString;
  /**
   * Get the current visible time range.
   *
   * **Example**
   * ```javascript
   * console.log(widget.activeChart().getVisibleRange());
   * ```
   *
   */
  getVisibleRange(): VisibleTimeRange;
  /**
   * Returns the object with 'format' function that you can use to format the prices.
   *
   * ```javascript
   * widget.activeChart().priceFormatter().format(123);
   * ```
   */
  priceFormatter(): INumberFormatter;
  /**
   * Returns the main series style type.
   *
   * ```javascript
   * console.log(widget.activeChart().chartType());
   * ```
   */
  chartType(): SeriesType;
  /**
   * Get an API object for interacting with the chart timezone.
   */
  getTimezoneApi(): ITimezoneApi;
  /**
   * Get an array of API objects for interacting with the chart panes.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().getPanes()[1].moveTo(0);
   * ```
   *
   */
  getPanes(): IPaneApi[];
  /**
   * Export the current data from the chart.
   *
   * **Example**
   * ```javascript
   * // Exports series' data only
   * widget.activeChart().exportData({ includeTime: false, includedStudies: [] });
   * // Exports series' data with times
   * widget.activeChart().exportData({ includedStudies: [] });
   * // Exports series' data with with user time
   * widget.activeChart().exportData({ includeTime: false, includeUserTime: true, includedStudies: [] });
   * // Exports data for the indicator which ID is STUDY_ID
   * widget.activeChart().exportData({ includeTime: false, includeSeries: false, includedStudies: ['STUDY_ID'] });
   * // Exports all available data from the chart
   * widget.activeChart().exportData({ includeUserTime: true });
   * // Exports series' data before 2018-01-01
   * widget.activeChart().exportData({ includeTime: false, to: Date.UTC(2018, 0, 1) / 1000 });
   * // Exports series' data after 2018-01-01
   * widget.activeChart().exportData({ includeTime: false, from: Date.UTC(2018, 0, 1) / 1000 });
   * // Exports series' data in the range between 2018-01-01 and 2018-02-01
   * widget.activeChart().exportData({ includeTime: false, from: Date.UTC(2018, 0, 1) / 1000, to: Date.UTC(2018, 1, 1) / 1000 });
   * // Exports all displayed data on the chart
   * widget.activeChart().exportData({ includeDisplayedValues: true });
   * ```
   *
   * @param options Optional object of options to control the exported data.
   * @returns A promise that resolves with the exported data.
   */
  exportData(options?: Partial<ExportDataOptions>): Promise<ExportedData>;
  /**
   * Check if the chart can be zoomed out using the {@link zoomOut} method.
   *
   * **Example**
   * ```javascript
   * if(widget.activeChart().canZoomOut()) {
   *     widget.activeChart().zoomOut();
   * };
   * ```
   *
   * @returns `true` if the chart can be zoomed out.
   */
  canZoomOut(): boolean;
  /**
   * Zoom out. The method has the same effect as clicking on the "Zoom out" button.
   */
  zoomOut(): void;
  /**
   * Enable or disable zooming of the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().setZoomEnabled(false);
   * ```
   *
   * @param enabled `true` to enable zooming, `false` to disable.
   */
  setZoomEnabled(enabled: boolean): void;
  /**
   * Enable or disable scrolling of the chart.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().setScrollEnabled(false);
   * ```
   *
   * @param enabled `true` to enable scrolling, `false` to disable.
   */
  setScrollEnabled(enabled: boolean): void;
  /**
   * Get an API object for interacting with groups of drawings.
   * Refer to the [Drawings API](https://www.tradingview.com/charting-library-docs/latest/ui_elements/drawings/drawings-api.md#drawing-groups-api) article for more information.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().shapesGroupController().createGroupFromSelection();
   * ```
   *
   */
  shapesGroupController(): IShapesGroupControllerApi;
  /**
   * Get the bar time to the end of the period
   * @param  {number} unixTime - date timestamp
   */
  barTimeToEndOfPeriod(unixTime: number): number;
  /**
   * Get the end of period to bar time
   * @param  {number} unixTime - date timestamp
   */
  endOfPeriodToBarTime(unixTime: number): number;
  /**
   * Get an API object for interacting with the timescale.
   *
   * **Example**
   * ```javascript
   * var time = widget.activeChart().getTimeScale().coordinateToTime(100);
   * ```
   *
   */
  getTimeScale(): ITimeScaleApi;
  /**
   * Check if bar selection mode is active or not.
   *
   * **Example**
   * ```javascript
   * var isRequested = widget.activeChart().isSelectBarRequested();
   * ```
   *
   * @returns `true` if active, `false` otherwise.
   */
  isSelectBarRequested(): boolean;
  /**
   * Switch the chart to bar selection mode.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().requestSelectBar()
   *     .then(function(time) {
   *         console.log('user selects bar with time', time);
   *     })
   *     .catch(function() {
   *         console.log('bar selection was rejected');
   *     });
   * ```
   *
   * @returns A promise that resolves to the timestamp of a bar selected by the user. Rejects if the bar selection was already requested or is cancelled.
   */
  requestSelectBar(): Promise<number>;
  /**
   * Cancel any active bar selection requests.
   *
   * **Example**
   * ```javascript
   * widget.activeChart().cancelSelectBar();
   * ```
   *
   */
  cancelSelectBar(): void;
  /**
   * Load and apply a chart template.
   *
   * @param templateName The name of the template to load.
   */
  loadChartTemplate(templateName: string): Promise<void>;
  /**
   * Get a readonly watched value that can be used to read/subscribe to the state of the chart's market status.
   */
  marketStatus(): IWatchedValueReadonly<MarketStatus | null>;
  /**
   * Set the time frame for this chart.
   *
   * **Note:** This action will set this chart as active in a multi-chart layout.
   *
   * **Example**
   * To apply the '1Y' timeframe:
   * ```js
   * tvWidget.setTimeFrame({
   *   val: { type: 'period-back', value: '12M' },
   *   res: '1W',
   * });
   * ```
   *
   * @param timeFrame Object specifying the range and resolution to be applied
   */
  setTimeFrame(timeFrame: RangeOptions): void;
  /**
   * Get the line tools state containing the drawings on the active chart.
   *
   * This method requires that the [`saveload_separate_drawings_storage`](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#saveload_separate_drawings_storage) featureset is enabled.
   */
  getLineToolsState(): LineToolsAndGroupsState;
  /**
   * Apply line tools state to the chart which will restore the drawings from the saved content.
   *
   * This method requires that the [`saveload_separate_drawings_storage`](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#saveload_separate_drawings_storage) featureset is enabled.
   */
  applyLineToolsState(state: LineToolsAndGroupsState): Promise<void>;
  /**
   * Manually trigger the chart to request the linetools again from the {@link IExternalSaveLoadAdapter.loadLineToolsAndGroups} method
   * or the 'load_line_tools' endpoint of the [Chart Storage REST API](https://www.tradingview.com/charting-library-docs/latest/saving_loading/#predefined-rest-api).
   *
   * This method requires that the [`saveload_separate_drawings_storage`](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#saveload_separate_drawings_storage) featureset is enabled.
   */
  reloadLineToolsFromServer(): void;
}
/**
 * The main interface for interacting with the library, returned by {@link ChartingLibraryWidgetConstructor}.
 * For more information, refer to the [Widget methods](https://www.tradingview.com/charting-library-docs/latest/core_concepts/widget-methods.md) article.
 */
export interface IChartingLibraryWidget {
  /**
   * A promise that resolves if and when the header is ready to be used.
   */
  headerReady(): Promise<void>;
  /**
   * The library will call `callback` when the chart is ready to be used.
   *
   * @param callback A function that will be called when the chart is ready to be used.
   */
  onChartReady(callback: EmptyCallback): void;
  /**
   * The library will call `callback` when a greyed-out drawing tool or study is clicked.
   *
   * @param callback A function that will be called when a greyed-out drawing tool or study is clicked.
   */
  onGrayedObjectClicked(callback: (obj: GrayedObject) => void): void;
  /**
   * The library will call `callback` when the `shortCut` keys are input.
   *
   * Use a string separated by '+' for shortcuts using an alphabet character (A to Z) with optional modifiers (ctrl, shift, alt).
   * Use a number for shortcuts using non-alphabet character without modifiers.
   * If you don't know the key code you need you can use resources like [keycode.info](https://keycode.info), or [MDN](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/keyCode) to check.
   * Use an array of literal key codes and modifier strings for shortcuts using non-alphabet characters with optional modifier strings.
   *
   * @param shortCut A number, a string, or an array of number and string.
   * @param callback A function that will be called when the `shortCut` keys are input.
   * @example
   * ```javascript
   * widget.onShortcut("alt+q", function() {
   *   widget.chart().executeActionById("symbolSearch");
   * });
   *
   * // F1
   * widget.onShortcut(112, function() {
   *   widget.chart().executeActionById("symbolSearch");
   * });
   *
   * // ctrl+shift+\
   * widget.onShortcut(['ctrl', 'shift', 220], function() {
   * 	 widget.chart().executeActionById("symbolSearch");
   * });
   * ```
   */
  onShortcut(
    shortCut: string | number | (string | number)[],
    callback: EmptyCallback
  ): void;
  /**
   * Subscribe to library events.
   *
   * @param event A event to subscribe to.
   * @param callback A callback that will be called when the event happens.
   */
  subscribe<EventName extends keyof SubscribeEventsMap>(
    event: EventName,
    callback: SubscribeEventsMap[EventName]
  ): void;
  /**
   * Unsubscribe from library events.
   *
   * @param event A event to unsubscribe from.
   * @param callback A callback to unsubscribe. Must be the same reference as a callback passed to {@link subscribe}.
   */
  unsubscribe<EventName extends keyof SubscribeEventsMap>(
    event: EventName,
    callback: SubscribeEventsMap[EventName]
  ): void;
  /**
   * Get an API instance that can be used to interact with a chart.
   *
   * @param index Zero based index of the chart.
   * @returns An API instance.
   */
  chart(index?: number): IChartWidgetApi;
  /**
   * Get the configured locale of the widget. For example `en`, `zh`, `ru`.
   *
   * @returns A code representing the locale of the widget.
   */
  getLanguage(): LanguageCode;
  /**
   * Set the symbol and resolution of the active chart.
   * @param symbol A symbol to load.
   * @param interval A interval (resolution) to load.
   * @param callback A callback. Called when the symbol's data has finished loading.
   */
  setSymbol(
    symbol: string,
    interval: ResolutionString,
    callback: EmptyCallback
  ): void;
  /**
   * Remove the widget and all its data from the page. The widget cannot be interacted with after it has been removed.
   */
  remove(): void;
  /**
   * Close all open context menus, pop-ups or dialogs.
   */
  closePopupsAndDialogs(): void;
  /**
   * Select an icon. It's the same as clicking on the corresponding button in the left toolbar.
   *
   * @param linetool An icon drawing tool.
   * @param options An optional object with options.
   */
  selectLineTool(linetool: "icon", options?: IconOptions): void;
  /**
   * Select a drawing or a cursor. It's the same as clicking on the corresponding button in the left toolbar.
   *
   * @param linetool A drawing or cursor to select (excluding 'icon')
   */
  selectLineTool(linetool: Omit<"icon", SupportedLineTools>): void;
  /**
   * Select the Icon line tool. It's the same as clicking on the corresponding button in the left toolbar.
   *
   * @param linetool Icon line tool.
   * @param options An optional object with options. Currently only used for the 'icon' drawing.
   */
  selectLineTool(linetool: "icon", options?: IconOptions): void;
  /**
   * Select the Emoji line tool. It's the same as clicking on the corresponding button in the left toolbar.
   *
   * @param linetool Emoji line tool.
   * @param options Options for the Emoji line tool
   */
  selectLineTool(linetool: "emoji", options?: EmojiOptions): void;
  /**
   * Select a drawing, icon, or a cursor. It's the same as clicking on the corresponding button in the left toolbar.
   *
   * @param linetool A drawing or cursor to select.
   * @param options An optional object with options.
   */
  selectLineTool(
    linetool: SupportedLineTools,
    options?: IconOptions | EmojiOptions
  ): void;
  /**
   * Get the currently selected drawing or cursor.
   *
   * @returns An identifier for drawing or cursor.
   */
  selectedLineTool(): SupportedLineTools;
  /**
   * Saves the chart state to a object. This method is part of the low-level save/load API.
   *
   * @param callback A function called with the chart state as the first argument.
   * @param options Options for customising the saved data.
   */
  save(callback: (state: object) => void, options?: SaveChartOptions): void;
  /**
   * Loads the chart state from a object. This method is part of the low-level save/load API.
   *
   * @param state A chart state object to load.
   * @param extendedData A optional object of information about the saved state.
   */
  load(state: object, extendedData?: SavedStateMetaInfo): void;
  /**
   * Get a list of chart descriptions saved to the server for the current user.
   *
   * @param callback A function called with an array of saved chart information as the first argument.
   */
  getSavedCharts(callback: (chartRecords: SaveLoadChartRecord[]) => void): void;
  /**
   * Load a saved chart from the server.
   *
   * @param chartRecord A chart information object (returned by {@link getSavedCharts}).
   */
  loadChartFromServer(chartRecord: SaveLoadChartRecord): void;
  /**
   * Save the current chart to the server.
   *
   * @param onComplete An optional callback function called when the chart is successfully saved.
   * @param onFail An optional callback function called when the chart fails to save.
   * @param options An optional object of options for saving the chart.
   */
  saveChartToServer(
    onComplete?: EmptyCallback,
    onFail?: EmptyCallback,
    options?: SaveChartToServerOptions
  ): void;
  /**
   * Remove a saved chart from the server.
   *
   * @param chartId A chart ID from a {@link SaveLoadChartRecord} (returned by {@link getSavedCharts}).
   * @param onCompleteCallback A callback function called when the chart is successfully saved.
   */
  removeChartFromServer(
    chartId: string,
    onCompleteCallback: EmptyCallback
  ): void;
  /**
   * The widget will call the callback function each time the widget wants to display a context menu.
   * See also {@link ChartingLibraryWidgetOptions.context_menu}.
   *
   * **Example**
   * ```javascript
   * widget.onChartReady(function() {
   *     widget.onContextMenu(function(unixtime, price) {
   *         return [{
   *             position: "top",
   *             text: "First top menu item, time: " + unixtime + ", price: " + price,
   *             click: function() { alert("First clicked."); }
   *         },
   *         { text: "-", position: "top" }, // Adds a separator between buttons
   *         { text: "-Paste" },             // Removes the existing item from the menu
   *         {
   *             position: "top",
   *             text: "Second top menu item 2",
   *             click: function() { alert("Second clicked."); }
   *         }, {
   *             position: "bottom",
   *             text: "Bottom menu item",
   *             click: function() { alert("Third clicked."); }
   *         }];
   *     });
   * });
   * ```
   *
   * @param callback A function called with the time and price of the location on the chart that triggered the context menu.
   * The array of objects returned will add or remove items from the context menu.
   */
  onContextMenu(
    callback: (unixTime: number, price: number) => ContextMenuItem[]
  ): void;
  /**
   * Create a button in the top toolbar. This should be called after {@link headerReady} has resolved.
   *
   * **Example**
   * ```javascript
   * widget.headerReady().then(function() {
   *     var button = widget.createButton();
   *     button.setAttribute('title', 'My custom button tooltip');
   *     button.addEventListener('click', function() { alert("My custom button pressed!"); });
   *     button.textContent = 'My custom button caption';
   * });
   * ```
   *
   * @param options A optional object of options for the button.
   * @returns A `HTMLElement` you can customize.
   */
  createButton(options?: CreateHTMLButtonOptions): HTMLElement;
  /**
   * Create a button in the top toolbar. This should be called after {@link headerReady} has resolved.
   * If the `title` option is provided then the title text will be shown in a tooltip on hover.
   * If the `onClick` option is provided then the button will be clickable.
   * @param options A optional object of options for the button.
   */
  createButton(options?: CreateTradingViewStyledButtonOptions): void;
  /**
   * Create a button in the top toolbar. This should be called after {@link headerReady} has resolved.
   * @param options A optional object of options for the button.
   * @returns A `HTMLElement` if the `useTradingViewStyle` option if `false`. `undefined` if `useTradingViewStyle` is `true`.
   */
  createButton(options?: CreateButtonOptions): HTMLElement | undefined;
  /**
   * Add a custom dropdown menu to the top toolbar.
   *
   * **Example**
   * ```javascript
   * widget.createDropdown(
   *     {
   *         title: 'dropdown',
   *         tooltip: 'tooltip for this dropdown',
   *         items: [
   *             {
   *                 title: 'item#1',
   *                 onSelect: () => {console.log('1');},
   *             },
   *             {
   *                 title: 'item#2',
   *                 onSelect: () => {widget.setSymbol('IBM', '1D');},
   *             },
   *             {
   *                 title: 'item#3',
   *                 onSelect: () => {
   *                     widget.activeChart().createStudy(
   *                         'MACD',
   *                         false,
   *                         false,
   *                         {
   *                             in_0: 14,
   *                             in_1: 30,
   *                             in_3: 'close',
   *                             in_2: 9
   *                         }
   *                     );
   *                 },
   *             }
   *         ],
   *         icon: `<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"><g fill="none" stroke="currentColor"><circle cx="10" cy="10" r="2.5"/><circle cx="18" cy="18" r="2.5"/><path stroke-linecap="square" d="M17.5 7.5l-7 13"/></g></svg>`,
   *     }
   * ).then(myDropdownApi => {
   *     // Use myDropdownApi if you need to update the dropdown:
   *     // myDropdownApi.applyOptions({
   *     //     title: 'a new title!'
   *     // });
   *
   *     // Or remove the dropdown:
   *     // myDropdownApi.remove();
   * });
   * ```
   * @param  {DropdownParams} params
   */
  createDropdown(params: DropdownParams): Promise<IDropdownApi>;
  /**
   * Show a dialog with custom title and text along with an "OK" buttons.
   * @param params A object of options for the created dialog.
   */
  showNoticeDialog(params: DialogParams<() => void>): void;
  /**
   * Show a dialog with custom title and text along with "OK" and "CANCEL" buttons.
   *
   * @param params A object of options for the created dialog.
   */
  showConfirmDialog(params: DialogParams<(confirmed: boolean) => void>): void;
  /**
   * Show the "Load Chart Layout" dialog.
   */
  showLoadChartDialog(): void;
  /**
   * Show the "Copy Chart Layout" dialog.
   */
  showSaveAsChartDialog(): void;
  /**
   * Get the symbol and interval of the active chart.
   */
  symbolInterval(): SymbolIntervalResult;
  /**
   * Get the price formatter for the main series. You can use this to format prices as the char
   */
  mainSeriesPriceFormatter(): INumberFormatter;
  /**
   * Get an array of supported intervals (resolutions).
   *
   * @returns An array of supported intervals. E.g. `['1D', '5D', '1Y']`.
   */
  getIntervals(): string[];
  /**
   * Get an array of the names of all supported studies. These names can be used when calling {@link IChartWidgetApi.createStudy}.
   *
   * @returns An array of supported study names. E.g. `['Accumulation/Distribution', 'Accumulative Swing Index', 'Advance/Decline', ...]`.
   */
  getStudiesList(): string[];
  /**
   * Get an array of information about indicator inputs, including their names.
   * You need to know an input name to refer to this property in the code.
   * For example, when you change an input value using the [overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md).
   * Consider the [Input property](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md#input-property) section for more information.
   *
   * @param studyName The name of a study.
   */
  getStudyInputs(studyName: string): StudyInputInformation[];
  /**
   * Get information about indicator properties.
   * You can use this information to refer to the properties in the code.
   * For example, when you change property values using the [overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md).
   *
   * Note that `getStudyStyles` does not return actual property names but the indicator's [metadata](https://www.tradingview.com/charting-library-docs/latest/custom_studies/metainfo/metainfo.md).
   * Consider the [Property path](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md#property-path) section for more information on how to refer to the properties.
   *
   * @param studyName The name of a indicator.
   */
  getStudyStyles(studyName: string): StudyStyleInfo;
  /**
   * Add a custom CSS file for the library to load.
   *
   * @param url A url to the custom CSS file. Should be absolute or relative to the `static` folder.
   */
  addCustomCSSFile(url: string): void;
  /**
   * Apply overrides to the chart without reloading. See also {@link ChartingLibraryWidgetOptions.overrides}.
   *
   * @param overrides An object of overrides to apply to the chart.
   */
  applyOverrides<TOverrides extends Partial<ChartPropertiesOverrides>>(
    overrides: TOverrides
  ): void;
  /**
   * Apply overrides to indicator styles and inputs without reloading.
   * Refer to [Indicator Overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md#change-default-properties-on-the-fly) for more information.
   * Overrides for built-in indicators are listed in {@link StudyOverrides}.
   *
   * @param overrides An object of overrides to apply to the studies.
   */
  applyStudiesOverrides(overrides: object): void;
  /**
   * Trading Platform only. Get a promise that resolves with an API object for interacting with the widgetbar (right sidebar) watchlist.
   *
   * **Example**
   * ```javascript
   * const watchlistApi = await widget.watchList();
   * const activeListId = watchlistApi.getActiveListId();
   * const currentListItems = watchlistApi.getList(activeListId);
   * // append new section and item to the current watchlist
   * watchlistApi.updateList(activeListId, [...currentListItems, '###NEW SECTION', 'AMZN']);
   * ```
   *
   * @returns An API object for interacting with the widgetbar (right sidebar) watchlist.
   */
  watchList(): Promise<IWatchListApi>;
  /**
   * Trading Platform only. Get a promise that resolves with an API object for interacting with the widgetbar (right sidebar) news widget.
   *
   * @returns An API object for interacting with the widgetbar (right sidebar) widget.
   */
  news(): Promise<INewsApi>;
  /**
   * Trading Platform only. Get a promise that resolves with an API object for interacting with the widgetbar (right sidebar).
   *
   * @returns An API object for interacting with the widgetbar (right sidebar).
   */
  widgetbar(): Promise<IWidgetbarApi>;
  /**
   * Get an API object for interacting with the active chart.
   *
   * @returns An API object for interacting with the chart.
   */
  activeChart(): IChartWidgetApi;
  /**
   * Get the index of the active chart in the layout.
   *
   * @returns number.
   */
  activeChartIndex(): number;
  /**
   * Set which chart is currently active.
   * It is recommended that this method is only used when linked to a user action
   * which should change the active chart.
   *
   * Use {@link chartsCount} to determine the number of charts currently available.
   * If an invalid index is supplied (less than zero, or greater than the number of charts minus 1)
   * then this method will not change the active chart.
   * @param index - index of chart to set as the active chart. Index is zero-based.
   */
  setActiveChart(index: number): void;
  /**
   * Get the number of charts in the current layout.
   *
   * @returns A count of the charts in the current layout.
   */
  chartsCount(): number;
  /**
   * This method deletes non-visible charts from a multiple-chart layout.
   *
   * When a user transitions from a layout with a larger number of charts
   * to one with fewer charts, the unused chart APIs still exist behind the scenes.
   * This inherent behavior allows the library to restore previously displayed charts.
   *
   * If you prefer that additional charts are displayed as new, with no record of previous
   * charts at the same position, you can use this method to delete all non-visible charts.
   * It is most effective to run this method right after a layout change (one can subscribe to
   * {@link SubscribeEventsMap.layout_changed} to know when this occurs).
   *
   * Please ensure that any subscriptions or event listeners associated with the
   * hidden charts are removed prior to invoking this method.
   *
   * @returns void
   */
  unloadUnusedCharts(): void;
  /**
   * Get the current chart layout type.
   *
   * @returns A string representation of the current layout type. E.g. `'2h'` for two charts split vertically.
   */
  layout(): LayoutType;
  /**
   * Set the current chart layout type.
   *
   * @params layout A string representation of the new layout type. E.g. `'2h'` for two charts split vertically.
   */
  setLayout(layout: LayoutType): void;
  /**
   * Get the name of the current chart layout. The return value will be `undefined` if the current layout has not been saved.
   *
   * @returns A string of the name of the current chart layout.
   */
  layoutName(): string;
  /**
   * Resets the sizes of all charts within a multiple-chart layout back to their initial default values.
   * This action redistributes the space equally among all charts to ensure consistency in layout design.
   *
   * @param disableUndo When set to true, the reset action is not added to the undo stack. Hence, the user cannot undo the reset operation.
   */
  resetLayoutSizes(disableUndo?: boolean): void;
  /**
   * Change the theme of the chart.
   *
   * @param themeName A theme name.
   * @param options An optional object of options for the theme.
   * @returns A promise that resolves when the theme has been changed.
   */
  changeTheme(
    themeName: ThemeName,
    options?: ChangeThemeOptions
  ): Promise<void>;
  /**
   * Get the current theme of the chart.
   *
   * **Example**
   * ```javascript
   * console.log(widget.getTheme());
   * ```
   *
   * @returns A theme name. The name of the current theme.
   */
  getTheme(): ThemeName;
  /**
   * Create a snapshot of the chart and upload it to the server.
   * When it is ready callback functions subscribed to the `'onScreenshotReady'` event using {@link subscribe} will be called.
   * The URL of the snapshot will be passed as an argument to the callback function.
   */
  takeScreenshot(): void;
  /**
   * Create a snapshot of the chart and return it as a canvas.
   * Use this method to [implement your logic](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Snapshots.md#implement-your-logic) for taking snapshots.
   *
   * @param options An optional object that customizes the returned snapshot.
   * @returns A promise containing a `HTMLCanvasElement` of the snapshot.
   */
  takeClientScreenshot(
    options?: Partial<ClientSnapshotOptions>
  ): Promise<HTMLCanvasElement>;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the "Lock All Drawing Tools" button.
   *
   * @returns A watched value of the state of the "Lock All Drawing Tools" button.
   */
  lockAllDrawingTools(): IWatchedValue<boolean>;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the "Hide All Drawing Tools" button.
   *
   * @returns A watched value of the state of the "Hide All Drawing Tools" button.
   */
  hideAllDrawingTools(): IWatchedValue<boolean>;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the magnet.
   *
   * @returns A watched value of the state of the magnet.
   */
  magnetEnabled(): IWatchedValue<boolean>;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the magnet mode.
   *
   * @returns A watched value of the state of the magnet mode.
   */
  magnetMode(): IWatchedValue<number>;
  /**
   * Only available in Trading Platform. Get a watched value that can be used to read/write/subscribe to the state of the symbol sync between charts.
   *
   * **Example**
   * ```javascript
   * if (widget.symbolSync().value()) {
   *     // ...
   * }
   * ```
   *
   * @returns A watched value of the state of the symbol sync.
   */
  symbolSync(): IWatchedValue<boolean>;
  /**
   * Only available in Trading Platform. Get a watched value that can be used to read/write/subscribe to the state of the interval sync between charts.
   *
   * **Example**
   * ```javascript
   * widget.intervalSync().setValue(true);
   * ```
   *
   * @returns A watched value of the state of the interval sync.
   */
  intervalSync(): IWatchedValue<boolean>;
  /**
   * Only available in Trading Platform. Get a watched value that can be used to read/write/subscribe to the state of the crosshair sync between charts.
   *
   * **Example**
   * ```javascript
   * widget.crosshairSync().setValue(true);
   * ```
   *
   * @returns A watched value of the state of the crosshair sync.
   */
  crosshairSync(): IWatchedValue<boolean>;
  /**
   * Only available in Trading Platform. Get a watched value that can be used to read/write/subscribe to the state of the time sync between charts.
   *
   * **Example**
   * ```javascript
   * widget.timeSync().setValue(true);
   * ```
   *
   * @returns A watched value of the state of the time sync.
   */
  timeSync(): IWatchedValue<boolean>;
  /**
   * Only available in Trading Platform. Get a watched value that can be used to read/write/subscribe to the state of the date range sync between charts.
   *
   * **Example**
   * ```javascript
   * widget.dateRangeSync().setValue(true);
   * ```
   *
   * @returns A watched value of the state of the date range sync.
   */
  dateRangeSync(): IWatchedValue<boolean>;
  /**
   * Set the chart into fullscreen mode (if it isn't already).
   */
  startFullscreen(): void;
  /**
   * Set the chart into non-fullscreen mode (if it isn't already).
   */
  exitFullscreen(): void;
  /**
   * Get the state of the undo/redo stack.
   */
  undoRedoState(): UndoRedoState;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the navigation buttons.
   *
   * @returns A watched value of the state of the navigation buttons.
   */
  navigationButtonsVisibility(): IWatchedValue<VisibilityType>;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the pane buttons.
   *
   * @returns A watched value of the state of the pane buttons.
   */
  paneButtonsVisibility(): IWatchedValue<VisibilityType>;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the date format.
   *
   * @returns A watched value of the state of the date format.
   */
  dateFormat(): IWatchedValue<DateFormat>;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the timeHours format.
   */
  timeHoursFormat(): IWatchedValue<TimeHoursFormat>;
  /**
   * Get a watched value that can be used to read/write/subscribe to the state of the currency and unit
   * visibility setting on the price scale.
   *
   * @returns A watched value of the state of the currency and unit visibility option.
   */
  currencyAndUnitVisibility(): IWatchedValue<VisibilityType>;
  /**
   * Enable or disable debug mode.
   *
   * @param enabled A boolean flag. `true` to enable debug mode, `false` to disable.
   */
  setDebugMode(enabled: boolean): void;
  /**
   * Get a watched value that read/write/subscribe to the state of the 'draw on all charts' mode.
   *
   * When enabled new drawings will be replicated to all charts in the layout
   * and shown when the same ticker is selected.
   */
  drawOnAllChartsEnabled(): IWatchedValue<boolean>;
  /**
   * Clears the undo & redo history.
   *
   * **Warning:** this should only be used in very specific cases where you have considered
   * the UX implications. It is generally unexpected for the user that the undo
   * history has been cleared.
   *
   * An example of an acceptable use-case would be reusing a chart when switching
   * pages / tabs on a Single Page Application, and presenting it to the user as a
   * new chart.
   */
  clearUndoHistory(): void;
  /**
   * This method returns a readonly WatchedValue ({@link IWatchedValueReadonly})
   * object that can be used to read/watch the current supported chart types
   * ({@link SeriesType}) for an active chart.
   *
   * The chart type is returned as a number.
   * You can see which number corresponds to which chart type in the
   * [Overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/)
   * documentation for `mainSeriesProperties.style`.
   */
  supportedChartTypes(): IWatchedValueReadonly<ChartStyle[]>;
  /**
   * Get an API object for adjusting the watermarks present on the charts.
   * This can only be accessed when the chart is ready to be used. ({@link onChartReady})
   *
   * @returns An API object for adjusting the watermark settings.
   */
  watermark(): IWatermarkApi;
  /**
   * Get an API object for creating, and adjusting, custom status items to
   * be displayed within the legend for the main series of each chart.
   *
   * This can only be accessed when the chart has been created. ({@link headerReady})
   *
   * @returns An API object for controlling additional custom status items within the legend area.
   */
  customSymbolStatus(): ICustomSymbolStatusApi;
  /**
   * Sets the value for a CSS custom property.
   *
   * **Example:**
   * ```js
   * widget.setCSSCustomProperty('--my-theme-color', '#123AAA');
   * ```
   *
   * @param customPropertyName A string representing the CSS custom property name. It is expected that the name should start with a double hyphen ('--').
   * @param value A string containing the new property value.
   */
  setCSSCustomProperty(customPropertyName: string, value: string): void;
  /**
   * Returns the current value for a CSS custom property.
   *
   * **Example:**
   * ```js
   * const currentValue = widget.getCSSCustomPropertyValue('--my-theme-color');
   * ```
   *
   * @param customPropertyName A string representing the CSS custom property name to be checked. It is expected that the name should start with a double hyphen ('--').
   * @returns A string containing the value of the property. If not set, returns the empty string.
   */
  getCSSCustomPropertyValue(customPropertyName: string): string;
}
/**
 * PineJS execution context.
 */
export interface IContext {
  /**
   * Symbol Instrument
   */
  symbol: ISymbolInstrument;
  /**
   * Load a new symbol for the custom indicator
   * @param  {string} tickerid - Symbol identifier
   * @param  {string} period - period for the new symbol
   * @param  {string} [currencyCode] - Currency code
   * @param  {string} [unitId] - Unit ID
   * @param  {string} [subsessionId] - Subsession ID
   */
  new_sym(
    tickerid: string,
    period: string,
    currencyCode?: string,
    unitId?: string,
    subsessionId?: string
  ): ISymbolInstrument;
  /**
   * Switch context to the other symbol received through {@link IContext.new_sym}
   * @param  {number} i - the index of the symbol (`0` for the main series)
   */
  select_sym(i: number): void;
  /**
   * Creates an in-memory temporary storage with depth defined by the first call `new_var(value).get(n)`
   * @param  {number} [value] - variable's value
   */
  new_var(value?: number): IPineSeries;
  /**
   * Creates an in-memory temporary storage with unlimited depth.
   * @param  {number} [value] - variable's value
   */
  new_unlimited_var(value?: number): IPineSeries;
  /**
   * Creates a new context
   */
  new_ctx(): IContext;
  /**
   * Checks if symbol is the main symbol
   * @param  {ISymbolInstrument|undefined} symbol - symbol to check
   * @returns `true` if symbol is the main symbol
   */
  is_main_symbol(symbol: ISymbolInstrument | undefined): boolean;
}
export interface IContextMenuRenderer {
  /**
   * Displays the menu at the position.
   * @param pos Position to show context menu
   */
  show(pos: ContextMenuPosition): void;
  /**
   * hides the menu.
   */
  hide(): void;
  /**
   * @returns `true` when the menu is currently displayed.
   */
  isShown(): boolean;
}
/**
 * Adapter API for reading and setting the state of a
 * custom symbol status item.
 *
 * The 'set' methods return the same adapter so that you can
 * chain multiple set functions together.
 *
 * **Example**
 * ```js
 * const adapter = widget.customSymbolStatus().symbol('ABC');
 * adapter.setVisible(true).setColor('#336699').setTooltip('Custom Status')
 * ```
 */
export interface ICustomSymbolStatusAdapter {
  /**
   * Get the current visibility of the status item.
   * @returns the current visibility
   */
  getVisible(): boolean;
  /**
   * Set the visibility for the status item. @default false
   *
   * @param visible - visibility for the status item, where
   * `true` makes the item visible.
   * @returns the current symbol status adapter so you can
   * chain 'set' functions together.
   */
  setVisible(visible: boolean): ICustomSymbolStatusAdapter;
  /**
   * Get the current icon for the status item.
   * @returns the current icon SVG string
   */
  getIcon(): string | null;
  /**
   * Set the icon for the status item. @default blank
   * The icon should be provided as an svg markup. It is
   * recommended that the icon works well at small sizes.
   *
   * **Example**
   * ```svg
   * <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
   *   <!-- Icon source: https://heroicons.com -->
   *   <path fill-rule="evenodd" d="M13.5 4.938a7 7 0 11-9.006 1.737c.202-.257.59-.218.793.039.278.352.594.672.943.954.332.269.786-.049.773-.476a5.977 5.977 0 01.572-2.759 6.026 6.026 0 012.486-2.665c.247-.14.55-.016.677.238A6.967 6.967 0 0013.5 4.938zM14 12a4 4 0 01-4 4c-1.913 0-3.52-1.398-3.91-3.182-.093-.429.44-.643.814-.413a4.043 4.043 0 001.601.564c.303.038.531-.24.51-.544a5.975 5.975 0 011.315-4.192.447.447 0 01.431-.16A4.001 4.001 0 0114 12z" clip-rule="evenodd" />
   * </svg>
   * ```
   *
   * @param icon - svg markup string to be used as the icon, or `null` to display no icon
   * @returns the current symbol status adapter so you can
   * chain 'set' functions together.
   */
  setIcon(icon: string | null): ICustomSymbolStatusAdapter;
  /**
   * Get the current color of the status item.
   * @returns the current color
   */
  getColor(): string;
  /**
   * Set the color for the status item. @default '#9598a1'
   *
   * @param color - color to be used for the status item.
   * It is recommended that you test that the color works well
   * for both light and dark themes.
   * @returns the current symbol status adapter so you can
   * chain 'set' functions together.
   */
  setColor(color: string): ICustomSymbolStatusAdapter;
  /**
   * Get the current tooltip text for the status item.
   * @returns the current tooltip text
   */
  getTooltip(): string | null;
  /**
   * Set the text to be displayed within the tooltip displayed
   * when hovering over the statuses for the symbol.
   * @default ''
   *
   * @param tooltip - text to be displayed within the tooltip.
   * @returns the current symbol status adapter so you can
   * chain 'set' functions together.
   */
  setTooltip(tooltip: string | null): ICustomSymbolStatusAdapter;
  /**
   * Get the current content of the status item displayed within
   * the pop-up tooltip.
   * @returns the current pop-up content
   */
  getDropDownContent(): CustomStatusDropDownContent[] | null;
  /**
   * Set the content to be displayed within the pop-up which appears
   * when the user clicks on the symbol statuses.
   * @default null
   *
   * @param content - content to be displayed, set to `null` to display
   * nothing. More than one section can be specified.
   * @returns the current symbol status adapter so you can
   * chain 'set' functions together.
   */
  setDropDownContent(
    content: CustomStatusDropDownContent[] | null
  ): ICustomSymbolStatusAdapter;
}
/**
 * The custom symbol status API provides the ability to create (and adjust)
 * additional status items to be displayed within the symbol status section
 * of the main series legend. This section is typically used to show the
 * market status (such as open or closed) but can additionally be used to
 * display warnings related to the current symbol.
 *
 * This API allows custom status items to be added (which are tied to a
 * specific symbol). You can customise the icon, color, tooltip, and content
 * within the dropdown tooltip menu displayed when the user clicks on the
 * icon.
 *
 * **Example**
 * ```js
 * widget
 *  .customSymbolStatus()
 *  .symbol('NASDAQNM:AAPL') // select the symbol
 *  .setVisible(true) // make the status visible
 *  .setColor('rgb(255, 40, 60)') // set the colour
 *  .setIcon(myCustomIconSvgString) // string for an svg icon, i.e. '<svg> ... </svg>'
 *  .setTooltip('Tooltip') // text to be displayed within the hover tooltip
 *  .setDropDownContent([ // content to be displayed within the large pop-up tooltip
 *    {
 *      title: 'Title', // title to be displayed within the pop-up
 *      color: 'rgb(255, 60, 70)', // optional, if you want it to be different to above
 *      content: [
 *        'Explanation of status',
 *        '<br/><br/>',
 *        'More details...',
 *      ],
 *      action: { // Optional action to be displayed
 *        text: 'Read more here',
 *        tooltip: 'opens in a new window',
 *        onClick: () => {
 *          window.open('https://www.tradingview.com/', '_blank');
 *        },
 *      },
 *    },
 * ]);
 * ```
 */
export interface ICustomSymbolStatusApi {
  /**
   * Get the custom symbol status adapter for a specific symbolId. The
   * symbolId should exactly match the resolved symbolId. This id can
   * be retrieved for a chart via the {@link IChartWidgetApi.symbol} method.
   *
   * @param symbolId - symbol id for which you would like to create / adjust
   * the custom status
   */
  symbol(symbolId: string): ICustomSymbolStatusAdapter;
  /**
   * Hide all the custom status items. This is equivalent to using
   * `setVisible(false)` on all of the current custom symbol status items.
   */
  hideAll(): void;
}
export interface IDatafeedChartApi {
  /**
   * The library calls this function to get marks for visible bars range.
   * The library assumes that you will call `onDataCallback` only once per `getMarks` call.
   *
   * A few marks per bar are allowed (for now, the maximum is 10). The time of each mark must match the time of a bar. For example, if the bar times are `2023-01-01`, `2023-01-08`, and `2023-01-15`, then a mark cannot have the time `2023-01-05`.
   *
   * **Remark:** This function will be called only if you confirmed that your back-end is supporting marks ({@link DatafeedConfiguration.supports_marks}).
   *
   * @param symbolInfo A SymbolInfo object
   * @param from Unix timestamp (leftmost visible bar)
   * @param to Unix timestamp (rightmost visible bar)
   * @param onDataCallback Callback function containing an array of marks
   * @param resolution Resolution of the symbol
   */
  getMarks?(
    symbolInfo: LibrarySymbolInfo,
    from: number,
    to: number,
    onDataCallback: GetMarksCallback<Mark>,
    resolution: ResolutionString
  ): void;
  /**
   * The library calls this function to get timescale marks for visible bars range.
   * The library assumes that you will call `onDataCallback` only once per `getTimescaleMarks` call.
   *
   * **Remark:** This function will be called only if you confirmed that your back-end is supporting marks ({@link DatafeedConfiguration.supports_timescale_marks}).
   *
   * @param symbolInfo A SymbolInfo object
   * @param from Unix timestamp (leftmost visible bar)
   * @param to Unix timestamp (rightmost visible bar)
   * @param onDataCallback Callback function containing an array of marks
   * @param resolution Resolution of the symbol
   */
  getTimescaleMarks?(
    symbolInfo: LibrarySymbolInfo,
    from: number,
    to: number,
    onDataCallback: GetMarksCallback<TimescaleMark>,
    resolution: ResolutionString
  ): void;
  /**
   * This function is called if the `supports_time` configuration flag is `true` when the chart needs to know the server time.
   * The library expects a callback to be called once.
   * The time is provided without milliseconds. Example: `1445324591`.
   *
   * `getServerTime` is used to display countdown on the price scale.
   * Note that the countdown can be displayed only for [intraday](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution.md#resolution-in-minutes-intraday) resolutions.
   */
  getServerTime?(callback: ServerTimeCallback): void;
  /**
   * Provides a list of symbols that match the user's search query.
   *
   * @param userInput Text entered by user in the symbol search field
   * @param exchange The requested exchange. Empty value means no filter was specified
   * @param symbolType Type of symbol. Empty value means no filter was specified
   * @param onResult Callback function that returns an array of results ({@link SearchSymbolResultItem}) or empty array if no symbols found
   */
  searchSymbols(
    userInput: string,
    exchange: string,
    symbolType: string,
    onResult: SearchSymbolsCallback
  ): void;
  /**
   * The library will call this function when it needs to get SymbolInfo by symbol name.
   *
   * @param symbolName Symbol name or `ticker`
   * @param onResolve Callback function returning a SymbolInfo ({@link LibrarySymbolInfo})
   * @param onError Callback function whose only argument is a text error message
   * @param extension An optional object with additional parameters
   */
  resolveSymbol(
    symbolName: string,
    onResolve: ResolveCallback,
    onError: ErrorCallback,
    extension?: SymbolResolveExtension
  ): void;
  /**
   * This function is called when the chart needs a history fragment defined by dates range.
   *
   * @param symbolInfo A SymbolInfo object
   * @param resolution Resolution of the symbol
   * @param periodParams An object used to pass specific requirements for getting bars
   * @param onResult Callback function for historical data
   * @param onError Callback function whose only argument is a text error message
   */
  getBars(
    symbolInfo: LibrarySymbolInfo,
    resolution: ResolutionString,
    periodParams: PeriodParams,
    onResult: HistoryCallback,
    onError: ErrorCallback
  ): void;
  /**
   * The library calls this function when it wants to receive real-time updates for a symbol.
   * The library assumes that you will call the callback provided by the `onTick` parameter every time you want to update the most recent bar or to add a new one.
   *
   * @param symbolInfo A SymbolInfo object
   * @param resolution Resolution of the symbol
   * @param onTick Callback function returning a Bar object
   * @param listenerGuid
   * @param onResetCacheNeededCallback Function to be executed when bar data has changed
   */
  subscribeBars(
    symbolInfo: LibrarySymbolInfo,
    resolution: ResolutionString,
    onTick: SubscribeBarsCallback,
    listenerGuid: string,
    onResetCacheNeededCallback: () => void
  ): void;
  /**
   * The library calls this function when it doesn't want to receive updates anymore.
   *
   * @param listenerGuid id to unsubscribe from
   */
  unsubscribeBars(listenerGuid: string): void;
  /**
   * Trading Platform calls this function when it wants to receive real-time level 2 (DOM) for a symbol.
   * Note that you should set the {@link BrokerConfigFlags.supportLevel2Data} configuration flag to `true`.
   *
   * @param symbol A SymbolInfo object
   * @param callback Function returning an object to update Depth Of Market (DOM) data
   * @returns A unique identifier that will be used to unsubscribe from the data
   */
  subscribeDepth?(symbol: string, callback: DOMCallback): string;
  /**
   * Trading Platform calls this function when it doesn't want to receive updates for this listener anymore.
   * Note that you should set the {@link BrokerConfigFlags.supportLevel2Data} configuration flag to `true`.
   *
   * @param subscriberUID A string returned by `subscribeDepth`
   */
  unsubscribeDepth?(subscriberUID: string): void;
  /**
   * The library calls this function to get the resolution that will be used to calculate the Volume Profile Visible Range indicator.
   *
   * Usually you might want to implement this method to calculate the indicator more accurately.
   * The implementation really depends on how much data you can transfer to the library and the depth of data in your data feed.
   * **Remark:** If this function is not provided the library uses currentResolution.
   *
   * @param currentResolution Resolution of the symbol
   * @param from Unix timestamp (leftmost visible bar)
   * @param to Unix timestamp (rightmost visible bar)
   * @param symbolInfo A Symbol object
   * @returns A resolution
   */
  getVolumeProfileResolutionForPeriod?(
    currentResolution: ResolutionString,
    from: number,
    to: number,
    symbolInfo: LibrarySymbolInfo
  ): ResolutionString;
}
/** Quotes datafeed API */
export interface IDatafeedQuotesApi {
  /**
   * This function is called when the library needs quote data.
   * The library assumes that `onDataCallback` is called once when all the requested data is received.
   * @param  {string[]} symbols - symbol names.
   * @param  {QuotesCallback} onDataCallback - callback to return the requested data.
   * @param  {QuotesErrorCallback} onErrorCallback - callback for responding with an error.
   */
  getQuotes(
    symbols: string[],
    onDataCallback: QuotesCallback,
    onErrorCallback: QuotesErrorCallback
  ): void;
  /**
   * Trading Platform calls this function when it wants to receive real-time quotes for a symbol.
   * The library assumes that you will call `onRealtimeCallback` every time you want to update the quotes.
   * @param  {string[]} symbols - list of symbols that should be updated rarely (once per minute). These symbols are included in the watchlist but they are not visible at the moment.
   * @param  {string[]} fastSymbols - list of symbols that should be updated frequently (at least once every 10 seconds)
   * @param  {QuotesCallback} onRealtimeCallback - callback to send realtime quote data updates
   * @param  {string} listenerGUID - unique identifier of the listener
   */
  subscribeQuotes(
    symbols: string[],
    fastSymbols: string[],
    onRealtimeCallback: QuotesCallback,
    listenerGUID: string
  ): void;
  /**
   * Trading Platform calls this function when it doesn't want to receive updates for this listener anymore.
   * `listenerGUID` will be the same object that the Library passed to `subscribeQuotes` before.
   * @param  {string} listenerGUID - unique identifier of the listener
   */
  unsubscribeQuotes(listenerGUID: string): void;
}
export interface IDelegate<TFunc extends Function>
  extends ISubscription<TFunc> {
  /** Fire (Evoke) */
  fire: TFunc;
}
/**
 * # IDESTRØYÅBLE
 * ```
 * ┌────────────────┐
 * │ ┏━━━━━┓        │
 * │ ┃ ○ ○ ┃        │  ┏━━━━━┓           ┌╲╌╌╱╌┐
 * │ ┃ ○ ○ ┃    x 1 │  ┃ ○ ○ ┃ destroy() ┊ ╲╱  ╵
 * │ ┠─────┨        │  ┃ ○ ○ ┃  ╭───╯╲   ╷ ╱╲  ┊
 * │ ┗━━━━━┛        │  ┠─────┨  ╰───╮╱   ├╱ ╌╲ ┤
 * │ destroy()  x 1 │  ┗━━━━━┛           └ ╌╌ ╌┘
 * └────────────────┘
 * ```
 */
export interface IDestroyable {
  /** Clean up (destroy) any subscriptions, intervals, or other resources that this `IDestroyable` instance has. */
  destroy(): void;
}
/** Dropdown menu API */
export interface IDropdownApi {
  /**
   * Apply options to the dropdown menu.
   * Note that this method does not affect the menu's alignment. To change the alignment, you should remove and recreate the menu as follows:
   *
   * ```javascript
   * myCustomDropdownApi.remove();
   * widget.createDropdown(optionsWithDifferentAlignment);
   * ```
   *
   * @param  {DropdownUpdateParams} options - Partial options for the dropdown menu
   */
  applyOptions(options: DropdownUpdateParams): void;
  /**
   * Remove the dropdown menu.
   */
  remove(): void;
}
/**
 * An API object used to control execution lines.
 */
export interface IExecutionLineAdapter {
  /**
   * Remove the execution line. This API object cannot be used after this call.
   */
  remove(): void;
  /**
   * Get the price of the execution line.
   */
  getPrice(): number;
  /**
   * Set the price of the execution line.
   *
   * @param value The new price.
   */
  setPrice(value: number): this;
  /**
   * Get the time of the execution line.
   */
  getTime(): number;
  /**
   * Set the time of the execution line.
   *
   * @param value The new time.
   */
  setTime(value: number): this;
  /**
   * Get the direction of the execution line.
   */
  getDirection(): Direction;
  /**
   * Set the direction of the execution line.
   *
   * @param value The new direction.
   */
  setDirection(value: Direction): this;
  /**
   * Get the text of the execution line.
   */
  getText(): string;
  /**
   * Set the text of the execution line.
   *
   * @param value The new text.
   */
  setText(value: string): this;
  /**
   * Get the tooltip of the execution line.
   */
  getTooltip(): string;
  /**
   * Set the tooltip of the execution line.
   *
   * @param value The new tooltip.
   */
  setTooltip(value: string): this;
  /**
   * Get the arrow height of the execution line.
   */
  getArrowHeight(): number;
  /**
   * Set the arrow height of the execution line.
   *
   * @param value The new arrow height.
   */
  setArrowHeight(value: number): this;
  /**
   * Get the arrow spacing of the execution line.
   */
  getArrowSpacing(): number;
  /**
   * Set the arrow spacing of the execution line.
   *
   * @param value The new arrow spacing.
   */
  setArrowSpacing(value: number): this;
  /**
   * Get the font of the execution line.
   */
  getFont(): string;
  /**
   * Set the font of the execution line.
   *
   * @param value The new font.
   */
  setFont(value: string): this;
  /**
   * Get the text color of the execution line.
   */
  getTextColor(): string;
  /**
   * Set the text color of the execution line.
   *
   * @param value The new text color.
   */
  setTextColor(value: string): this;
  /**
   * Get the arrow color of the execution line.
   */
  getArrowColor(): string;
  /**
   * Set the arrow color of the execution line.
   *
   * @param value The new arrow color.
   */
  setArrowColor(value: string): this;
}
export interface IExternalDatafeed {
  /**
   * This call is intended to provide the object filled with the configuration data.
   * The lib assumes that you will call the callback function and pass your datafeed {@link DatafeedConfiguration} as an argument.
   *
   * @param  {OnReadyCallback} callback - callback to return your datafeed configuration ({@link DatafeedConfiguration}) to the library.
   */
  onReady(callback: OnReadyCallback): void;
}
export interface IExternalSaveLoadAdapter {
  /**
   * Get all saved charts.
   * @returns Array of chart meta information
   */
  getAllCharts(): Promise<ChartMetaInfo[]>;
  /**
   * Remove a chart.
   * @param  id - Unique ID of the chart (see {@link getAllCharts})
   */
  removeChart<T extends number | string>(id: T): Promise<void>;
  /**
   * Save the chart
   * @param  {ChartData} chartData - Chart description data
   * @returns unique ID of the chart
   */
  saveChart(chartData: ChartData): Promise<string>;
  /**
   * Load the chart from the server
   * @param  {number} chartId - Unique ID of the chart to load (see {@link getAllCharts})
   * @returns chart content contained in the `content` field when saving the chart ({@link ChartData})
   */
  getChartContent(chartId: number): Promise<string>;
  /**
   * Get all saved study templates
   * @returns Array of study template meta information
   */
  getAllStudyTemplates(): Promise<StudyTemplateMetaInfo[]>;
  /**
   * Remove a study template
   * @param  {StudyTemplateMetaInfo} studyTemplateInfo
   */
  removeStudyTemplate(studyTemplateInfo: StudyTemplateMetaInfo): Promise<void>;
  /**
   * Save a study template
   * @param  {StudyTemplateData} studyTemplateData - Study template data to save
   */
  saveStudyTemplate(studyTemplateData: StudyTemplateData): Promise<void>;
  /**
   * load a study template from the server
   * @param  {StudyTemplateMetaInfo} studyTemplateInfo
   * @returns Study template `content`
   */
  getStudyTemplateContent(
    studyTemplateInfo: StudyTemplateMetaInfo
  ): Promise<string>;
  /**
   * Get names of all saved drawing templates
   * @param  {string} toolName - name of the drawing tool
   * @returns names of saved drawing templates
   */
  getDrawingTemplates(toolName: string): Promise<string[]>;
  /**
   * Load a drawing template from the server
   * @param  {string} toolName - name of the drawing tool
   * @param  {string} templateName - name of the template
   * @returns content of the drawing template
   */
  loadDrawingTemplate(toolName: string, templateName: string): Promise<string>;
  /**
   * Remove a drawing template
   * @param  {string} toolName - name of the drawing tool
   * @param  {string} templateName - name of the template
   */
  removeDrawingTemplate(toolName: string, templateName: string): Promise<void>;
  /**
   * Save a drawing template
   * @param  {string} toolName - name of the drawing tool
   * @param  {string} templateName - name of the template
   * @param  {string} content - content of the drawing template
   */
  saveDrawingTemplate(
    toolName: string,
    templateName: string,
    content: string
  ): Promise<void>;
  /**
   * Load a chart template from the server
   *
   * @param templateName The name of the template.
   *
   * @returns The chart template content.
   */
  getChartTemplateContent(templateName: string): Promise<ChartTemplate>;
  /**
   * Get names of all saved chart templates.
   *
   * @returns An array of names.
   */
  getAllChartTemplates(): Promise<string[]>;
  /**
   * Save a chart template.
   *
   * @param newName The name of the template.
   * @param theme The template content.
   */
  saveChartTemplate(
    newName: string,
    theme: ChartTemplateContent
  ): Promise<void>;
  /**
   * Remove a chart template.
   *
   * @param templateName The name of the template.
   */
  removeChartTemplate(templateName: string): Promise<void>;
  /**
   * Save drawings and drawing groups associated with a chart layout.
   *
   * @param layoutId The chart layout ID
   * @param chartId The chart ID
   * @param state The drawings and drawing groups state
   */
  saveLineToolsAndGroups(
    layoutId: string | undefined,
    chartId: string | number,
    state: LineToolsAndGroupsState
  ): Promise<void>;
  /**
   * Load drawings and drawing groups associated with a chart layout.
   *
   * @param layoutId The chart layout ID
   * @param chartId The chart ID
   * @param requestType Type of load request
   * @param requestContext Additional information for the request
   *
   * @returns The drawings and drawing groups state
   */
  loadLineToolsAndGroups(
    layoutId: string | undefined,
    chartId: string | number,
    requestType: LineToolsAndGroupsLoadRequestType,
    requestContext: LineToolsAndGroupsLoadRequestContext
  ): Promise<Partial<LineToolsAndGroupsState> | null>;
}
/** Definition of a formatter */
export interface IFormatter<T> {
  /** Whatever the input type, formats the data following a certain logic and return that value as a string  */
  format(value?: T): string;
  /** Check if the input value satisfies the logic and return either an error or the result of the parsing  */
  parse?(
    value: string
  ): ErrorFormatterParseResult | SuccessFormatterParseResult<T>;
}
/**
 * Drawing API
 *
 * You can retrieve this interface by using the {@link IChartWidgetApi.getShapeById} method.
 */
export interface ILineDataSourceApi {
  /**
   * Is the drawing selectable by the user.
   * @returns `true` when the drawing can be selected
   */
  isSelectionEnabled(): boolean;
  /**
   * Set whether the drawing can be selected by the user or not.
   * @param  {boolean} enable - if `true` then the user can select the drawing (see `disableSelection` option of `createMultipointShape`)
   */
  setSelectionEnabled(enable: boolean): void;
  /**
   * Can the drawing be saved in the chart layout
   * @returns `true` when the drawing can be saved
   */
  isSavingEnabled(): boolean;
  /**
   * Enables or disables saving of the drawing in the chart layout (see `disableSave` option of `createMultipointShape`).
   * @param  {boolean} enable - if `true`, the drawing can be saved to the chart
   */
  setSavingEnabled(enable: boolean): void;
  /**
   * Is the drawing shown in the Object Tree Panel
   * @returns `true` when the drawing is visible in the tree.
   */
  isShowInObjectsTreeEnabled(): boolean;
  /**
   * Enables or disables the visibility of the drawing in the Object Tree panel
   * @param  {boolean} enabled - if `true` then the drawing will be visible
   */
  setShowInObjectsTreeEnabled(enabled: boolean): void;
  /**
   * Is the drawing editable by the user.
   * @returns `true` when the drawing is editable
   */
  isUserEditEnabled(): boolean;
  /**
   * Enables or disables whether the drawing is editable
   * @param  {boolean} enabled - if `true`, then the drawing will be editable
   */
  setUserEditEnabled(enabled: boolean): void;
  /**
   * Places the drawing on top of all other chart objects.
   */
  bringToFront(): void;
  /**
   * Places the drawing behind all other chart objects.
   */
  sendToBack(): void;
  /**
   * Get all the properties of the drawing.
   * @returns properties of the drawing
   */
  getProperties(): Record<string, any>;
  /**
   * Sets the properties of the drawing.
   * @param  {object} newProperties - Drawing properties to be set on the drawing. It should have the same structure as an object from {@link ILineDataSourceApi.getProperties}. It can only include the properties that you want to override.
   */
  setProperties(newProperties: object): void;
  /**
   * Returns the points of the drawing.
   */
  getPoints(): PricedPoint[];
  /**
   * Set the new points of the drawing. All points must be provided: for example if the drawing is defined by 5 points then all 5 must be provided.
   *
   * @param  points - The new points.
   *
   */
  setPoints(points: ShapePoint[]): void;
  /**
   * Get the position percents of a fixed drawing.
   */
  getAnchoredPosition(): PositionPercents | undefined;
  /**
   * Set the position percents for a fixed drawing.
   * For example `setPoints([{ x: 0.1, y: 0.1 }])` would set a fixed drawing defined by
   * a single point to be 10% top the left edge of the chart and 10% from the top edge.
   *
   * @param positionPercents The new position percents.
   */
  setAnchoredPosition(positionPercents: PositionPercents): void;
}
export interface IMenuItem {
  /** Menu item type */
  readonly type: MenuItemType;
  /**
   * An unique ID of an action item. Could be used to distinguish actions between each other.
   */
  readonly id: string;
}
export interface INewsApi {
  /** Refresh News */
  refresh(): void;
}
export interface INonSeriesStudyBarsResult {
  type: "non_series_bars";
  /**
   * Non series bars
   */
  bars: IBarArray[];
}
export interface INonSeriesStudyResult {
  /** Type is `non_series_data` */
  type: "non_series_data";
  /** Always true */
  nonseries: true;
  /** Data */
  data: object;
}
/** Specific formatter for number */
export interface INumberFormatter extends IFormatter<number> {
  /**
   * Formatter for a price change
   * @param currentPrice - current price
   * @param prevPrice - previous price
   */
  formatChange?(currentPrice: number, prevPrice: number): string;
}
export interface IObservable<T> {
  /**
   * Subscribe to changes
   * @param  {(value:T)=>void} callback - callback function to be evoked when observed value changes
   */
  subscribe(callback: (value: T) => void): void;
  /**
   * Unsubscribe from changes
   * @param  {(value:T)=>void} callback - callback function to be unsubscribed
   */
  unsubscribe(callback: (value: T) => void): void;
}
export interface IObservableValue<T> extends IBoxedValue<T>, IObservable<T> {}
export interface IObservableValueReadOnly<T>
  extends IBoxedValueReadOnly<T>,
    IObservable<T> {}
/**
 * An API object used to control order lines.
 */
export interface IOrderLineAdapter {
  /**
   * Remove the order line. This API object cannot be used after this call.
   */
  remove(): void;
  /**
   * Attach a callback to be executed when the order line is modified.
   *
   * @param callback Callback to be executed when the order line is modified.
   */
  onModify(callback: () => void): this;
  /**
   * Attach a callback to be executed when the order line is modified.
   *
   * @param data Data to be passed to the callback.
   * @param callback Callback to be executed when the order line is modified.
   */
  onModify<T>(data: T, callback: (data: T) => void): this;
  /**
   * Attach a callback to be executed when the order line is moved.
   *
   * @param callback Callback to be executed when the order line is moved.
   */
  onMove(callback: () => void): this;
  /**
   * Attach a callback to be executed when the order line is moved.
   *
   * @param data Data to be passed to the callback.
   * @param callback Callback to be executed when the order line is moved.
   */
  onMove<T>(data: T, callback: (data: T) => void): this;
  /**
   * Attach a callback to be executed while the order line is being moved.
   *
   * @param callback Callback to be executed while the order line is being moved.
   */
  onMoving(callback: () => void): this;
  /**
   * Attach a callback to be executed while the order line is being moved.
   *
   * @param data Data to be passed to the callback.
   * @param callback Callback to be executed while the order line is being moved.
   */
  onMoving<T>(data: T, callback: (data: T) => void): this;
  /**
   * Attach a callback to be executed when the order line is cancelled.
   *
   * @param callback Callback to be executed when the order line is cancelled.
   */
  onCancel(callback: () => void): this;
  /**
   * Attach a callback to be executed when the order line is cancelled.
   *
   * @param data Data to be passed to the callback.
   * @param callback Callback to be executed when the order line is cancelled.
   */
  onCancel<T>(data: T, callback: (data: T) => void): this;
  /**
   * Get the price of the order line.
   */
  getPrice(): number;
  /**
   * Set the price of the order line.
   *
   * @param value The new price
   */
  setPrice(value: number): this;
  /**
   * Get the text of the order line.
   */
  getText(): string;
  /**
   * Set the text of the order line.
   *
   * @param value The new text
   */
  setText(value: string): this;
  /**
   * Get the tooltip of the order line.
   */
  getTooltip(): string;
  /**
   * Set the tooltip of the order line.
   *
   * @param value The new tooltip
   */
  setTooltip(value: string): this;
  /**
   * Get the modify tooltip of the order line.
   */
  getModifyTooltip(): string;
  /**
   * Set the modify tooltip of the order line.
   *
   * @param value The new modify tooltip
   */
  setModifyTooltip(value: string): this;
  /**
   * Get the cancel tooltip of the order line.
   */
  getCancelTooltip(): string;
  /**
   * Set the cancel tooltip of the order line.
   *
   * @param value The new cancel tooltip
   */
  setCancelTooltip(value: string): this;
  /**
   * Get the quantity of the order line.
   */
  getQuantity(): string;
  /**
   * Set the quantity of the order line.
   *
   * @param value The new quantity.
   */
  setQuantity(value: string): this;
  /**
   * Get the editable flag value of the order line.
   */
  getEditable(): boolean;
  /**
   * Set the editable of the order line.
   *
   * @param value The new editable.
   */
  setEditable(value: boolean): this;
  /**
   * Get the cancellable flag value of the order line.
   */
  getCancellable(): boolean;
  /**
   * Set the cancellable flag value of the order line.
   *
   * @param value The new cancellable flag value.
   */
  setCancellable(value: boolean): this;
  /**
   * Get the extend left flag value of the order line.
   */
  getExtendLeft(): boolean;
  /**
   * Set the extend left flag value of the order line.
   *
   * @param value The new extend left flag value.
   */
  setExtendLeft(value: boolean): this;
  /**
   * Get the line length of the order line.
   */
  getLineLength(): number;
  /**
   * Get the unit of length specified for the line length of the order line.
   */
  getLineLengthUnit(): OrderLineLengthUnit;
  /**
   * Set the line length of the order line.
   *
   * If negative number is provided for the value and the unit is 'pixel' then
   * the position will be relative to the left edge of the chart.
   *
   * @param value The new line length.
   * @param [unit] - unit for the line length, defaults to 'percentage'.
   */
  setLineLength(value: number, unit?: OrderLineLengthUnit): this;
  /**
   * Get the line style of the order line.
   */
  getLineStyle(): number;
  /**
   * Set the line style of the order line.
   *
   * @param value The new line style.
   */
  setLineStyle(value: number): this;
  /**
   * Get the line width of the order line.
   */
  getLineWidth(): number;
  /**
   * Set the line width of the order line.
   *
   * @param value The new line width.
   */
  setLineWidth(value: number): this;
  /**
   * Get the body font of the order line.
   */
  getBodyFont(): string;
  /**
   * Set the body font of the order line.
   *
   * @param value The new body font.
   */
  setBodyFont(value: string): this;
  /**
   * Get the quantity font of the order line.
   */
  getQuantityFont(): string;
  /**
   * Set the quantity font of the order line.
   *
   * @param value The new quantity font.
   */
  setQuantityFont(value: string): this;
  /**
   * Get the line color of the order line.
   */
  getLineColor(): string;
  /**
   * Set the line color of the order line.
   *
   * @param value The new line color.
   */
  setLineColor(value: string): this;
  /**
   * Get the body border color of the order line.
   */
  getBodyBorderColor(): string;
  /**
   * Set the body border color of the order line.
   *
   * @param value The new body border color.
   */
  setBodyBorderColor(value: string): this;
  /**
   * Get the body background color of the order line.
   */
  getBodyBackgroundColor(): string;
  /**
   * Set the body background color of the order line.
   *
   * @param value The new body background color.
   */
  setBodyBackgroundColor(value: string): this;
  /**
   * Get the body text color of the order line.
   */
  getBodyTextColor(): string;
  /**
   * Set the body text color of the order line.
   *
   * @param value The new body text color.
   */
  setBodyTextColor(value: string): this;
  /**
   * Get the quantity border color of the order line.
   */
  getQuantityBorderColor(): string;
  /**
   * Set the quantity border color of the order line.
   *
   * @param value The new quantity border color.
   */
  setQuantityBorderColor(value: string): this;
  /**
   * Get the quantity background color of the order line.
   */
  getQuantityBackgroundColor(): string;
  /**
   * Set the quantity background color of the order line.
   *
   * @param value The new quantity background color.
   */
  setQuantityBackgroundColor(value: string): this;
  /**
   * Get the quantity text color of the order line.
   */
  getQuantityTextColor(): string;
  /**
   * Set the quantity text color of the order line.
   *
   * @param value The new quantity text color.
   */
  setQuantityTextColor(value: string): this;
  /**
   * Get the cancel button border color of the order line.
   */
  getCancelButtonBorderColor(): string;
  /**
   * Set the cancel button border color of the order line.
   *
   * @param value The new cancel button border color.
   */
  setCancelButtonBorderColor(value: string): this;
  /**
   * Get the cancel button background color of the order line.
   */
  getCancelButtonBackgroundColor(): string;
  /**
   * Set the cancel button background color of the order line.
   *
   * @param value The new cancel button background color.
   */
  setCancelButtonBackgroundColor(value: string): this;
  /**
   * Get the cancel button icon color of the order line.
   */
  getCancelButtonIconColor(): string;
  /**
   * Set the cancel button icon color of the order line.
   *
   * @param value The new cancel button icon color.
   */
  setCancelButtonIconColor(value: string): this;
}
/**
 * You can retrieve this interface by using the {@link IChartWidgetApi.getPanes} method
 */
export interface IPaneApi {
  /** Returns `true` if the price scale contains the main series */
  hasMainSeries(): boolean;
  /**
   * Returns an array of the PriceScaleApi instances that allows interaction with right price scales.
   * The array may be empty if there is not any price scale on the left side of the pane
   */
  getLeftPriceScales(): readonly IPriceScaleApi[];
  /**
   * Returns an array of the PriceScaleApi instances that allows interaction with right price scales.
   * The array may be empty if there is not any price scale on the right side of the pane
   */
  getRightPriceScales(): readonly IPriceScaleApi[];
  /**
   * Returns an instance of the PriceScaleApi that allows you to interact with the price scale of the main source
   * or `null` if the main source is not attached to any price scale (it is in 'No Scale' mode)
   */
  getMainSourcePriceScale(): IPriceScaleApi | null;
  /** Returns the pane's height */
  getHeight(): number;
  /** Sets the pane's height */
  setHeight(height: number): void;
  /** Moves the pane to a new position, `paneIndex` should be a number between 0 and all panes count - 1 */
  moveTo(paneIndex: number): void;
  /** Returns the pane's index, it's a number between 0 and all panes count - 1 */
  paneIndex(): number;
  /** Collapse the current pane */
  collapse(): void;
  /** Restore the size of a previously collapsed pane */
  restore(): void;
}
export interface IPineSeries {
  /**
   * Get the value at a specific index.
   *
   * Note: The indices of a pine series is opposite.
   *
   * Example:
   * - s.get(1) returns second last,
   * - s.get(2) - third last
   * - and so on
   * @param  {number} [n] - index
   */
  get(n?: number): number;
  /**
   * Set the value for the pine series at the current index interation.
   * @param  {number} value - value to be set
   */
  set(value: number): void;
  /**
   * Get the index for the bar at the specified timestamp
   * @param  {number} time - timestamp
   */
  indexOf(time: number): number;
  /**
   * Map some values from one time scale to another.
   *
   * @param source Source times.
   * @param destination Destination times.
   * @param mode Adopt mode. `0` for continuous, `1` for precise.
   *
   * In continuous mode (`0`) every source time will be mapped to a destination time if one exists. Multiple source times may be mapped to the same destination time.
   *
   * In precise mode (`1`) every source time will be mapped to a destination time AT MOST ONCE if one exists. Some source times may not be mapped.
   *
   * @example
   * ```javascript
   * // A pine series with values [5, 5]
   * const sourceTimes = ctx.new_var();
   * // A pine series with values [4, 5]
   * const destinationTimes = ctx.new_var();
   * // A pine series with values [1, 2]
   * const values = ctx.new_var();
   *
   * // Creates a pine series with values [2, 2]
   * const adopted1 = values.adopt(sourceTimes, destinationTimes, 0);
   *
   * // Creates a pine series with values [NaN, 2]
   * const adopted2 = values.adopt(sourceTimes, destinationTimes, 1);
   * ```
   *
   * @example
   *
   * Psuedocode of the adopt algorithm:
   *
   * ```
   * adopt(sourceSeries, destinationSeries, mode) =
   *   destinationValue = most recent value in destinationSeries
   *   sourceIndex = index of destinationValue in sourceSeries
   *
   *   if mode equals 1 then
   *     previousDestinationValue = second most recent value in destinationSeries
   *     previousSourceIndex = index of previousDestinationValue in sourceSeries
   *
   *     if sourceIndex equals previousSourceIndex
   *       return NaN
   *
   *   return value at sourceIndex
   * ```
   */
  adopt(source: IPineSeries, destination: IPineSeries, mode: 0 | 1): number;
}
/**
 * An API object used to control position lines.
 */
export interface IPositionLineAdapter {
  /**
   * Remove the position line. This API object cannot be used after this call.
   */
  remove(): void;
  /**
   * Attach a callback to be executed when the position line is closed.
   *
   * @param callback Callback to be executed when the position line is closed.
   */
  onClose(callback: () => void): this;
  /**
   * Attach a callback to be executed when the position line is closed.
   *
   * @param data Data to be passed to the callback.
   * @param callback Callback to be executed when the position line is closed.
   */
  onClose<T>(data: T, callback: (data: T) => void): this;
  /**
   * Attach a callback to be executed when the position line is modified.
   *
   * @param callback Callback to be executed when the position line is modified.
   */
  onModify(callback: () => void): this;
  /**
   * Attach a callback to be executed when the position line is modified.
   *
   * @param data Data to be passed to the callback.
   * @param callback Callback to be executed when the position line is modified.
   */
  onModify<T>(data: T, callback: (data: T) => void): this;
  /**
   * Attach a callback to be executed when the position line is reversed.
   *
   * @param callback Callback to be executed when the position line is reversed.
   */
  onReverse(callback: () => void): this;
  /**
   * Attach a callback to be executed when the position line is reversed.
   *
   * @param data Data to be passed to the callback.
   * @param callback Callback to be executed when the position line is reversed.
   */
  onReverse<T>(data: T, callback: (data: T) => void): this;
  /**
   * Get the price of the position line.
   */
  getPrice(): number;
  /**
   * Set the price of the position line.
   *
   * @param value The new price.
   */
  setPrice(value: number): this;
  /**
   * Get the text of the position line.
   */
  getText(): string;
  /**
   * Set the text of the position line.
   *
   * @param value The new text.
   */
  setText(value: string): this;
  /**
   * Get the tooltip of the position line.
   */
  getTooltip(): string;
  /**
   * Set the tooltip of the position line.
   *
   * @param value The new tooltip.
   */
  setTooltip(value: string): this;
  /**
   * Get the protect tooltip of the position line.
   */
  getProtectTooltip(): string;
  /**
   * Set the protect tooltip of the position line.
   *
   * @param value The new protect tooltip.
   */
  setProtectTooltip(value: string): this;
  /**
   * Get the close tooltip of the position line.
   */
  getCloseTooltip(): string;
  /**
   * Set the close tooltip of the position line.
   *
   * @param value The new close tooltip.
   */
  setCloseTooltip(value: string): this;
  /**
   * Get the reverse tooltip of the position line.
   */
  getReverseTooltip(): string;
  /**
   * Set the reverse tooltip of the position line.
   *
   * @param value The new reverse tooltip.
   */
  setReverseTooltip(value: string): this;
  /**
   * Get the quantity of the position line.
   */
  getQuantity(): string;
  /**
   * Set the quantity of the position line.
   *
   * @param value The new quantity.
   */
  setQuantity(value: string): this;
  /**
   * Get the extend left flag value of the position line.
   */
  getExtendLeft(): boolean;
  /**
   * Set the extend left flag value of the position line.
   * @param value The new extend left flag value.
   */
  setExtendLeft(value: boolean): this;
  /**
   * Get the unit of length specified for the line length of the position line.
   */
  getLineLengthUnit(): PositionLineLengthUnit;
  /**
   * Get the line length of the position line.
   */
  getLineLength(): number;
  /**
   * Set the line length of the position line.
   *
   * If negative number is provided for the value and the unit is 'pixel' then
   * the position will be relative to the left edge of the chart.
   *
   * @param value The new line length.
   * @param [unit] - unit for the line length, defaults to 'percentage'.
   */
  setLineLength(value: number, unit?: PositionLineLengthUnit): this;
  /**
   * Get the line style of the position line.
   */
  getLineStyle(): number;
  /**
   * Set the line style of the position line.
   * @param value The new line style.
   */
  setLineStyle(value: number): this;
  /**
   * Get the line width of the position line.
   */
  getLineWidth(): number;
  /**
   * Set the line width of the position line.
   * @param value The new line width.
   */
  setLineWidth(value: number): this;
  /**
   * Get the body font of the position line.
   */
  getBodyFont(): string;
  /**
   * Set the body font of the position line.
   * @param value The new body font.
   */
  setBodyFont(value: string): this;
  /**
   * Get the quantity font of the position line.
   */
  getQuantityFont(): string;
  /**
   * Set the quantity font of the position line.
   * @param value The new quantity font.
   */
  setQuantityFont(value: string): this;
  /**
   * Get the line color of the position line.
   */
  getLineColor(): string;
  /**
   * Set the line color of the position line.
   * @param value The new line color.
   */
  setLineColor(value: string): this;
  /**
   * Get the body border color of the position line.
   */
  getBodyBorderColor(): string;
  /**
   * Set the body border color of the position line.
   * @param value The new body border color.
   */
  setBodyBorderColor(value: string): this;
  /**
   * Get the body font of the position line.
   */
  getBodyBackgroundColor(): string;
  /**
   * Set the body font of the position line.
   * @param value The new body font.
   */
  setBodyBackgroundColor(value: string): this;
  /**
   * Get the body text color of the position line.
   */
  getBodyTextColor(): string;
  /**
   * Set the body text color of the position line.
   * @param value The new body text color.
   */
  setBodyTextColor(value: string): this;
  /**
   * Get the quantity border color of the position line.
   */
  getQuantityBorderColor(): string;
  /**
   * Set the quantity border color of the position line.
   *
   * @param value The new quantity border color.
   */
  setQuantityBorderColor(value: string): this;
  /**
   * Get the quantity background color of the position line.
   */
  getQuantityBackgroundColor(): string;
  /**
   * Set the quantity background color of the position line.
   *
   * @param value The new quantity background color.
   */
  setQuantityBackgroundColor(value: string): this;
  /**
   * Get the quantity text color of the position line.
   */
  getQuantityTextColor(): string;
  /**
   * Set the quantity text color of the position line.
   *
   * @param value The new quantity text color.
   */
  setQuantityTextColor(value: string): this;
  /**
   * Get the reverse button border color of the position line.
   */
  getReverseButtonBorderColor(): string;
  /**
   * Set the reverse button border color of the position line.
   * @param value The new reverse button border color.
   */
  setReverseButtonBorderColor(value: string): this;
  /**
   * Get the reverse button background color of the position line.
   */
  getReverseButtonBackgroundColor(): string;
  /**
   * Set the reverse button background color of the position line.
   * @param value The new reverse button background color.
   */
  setReverseButtonBackgroundColor(value: string): this;
  /**
   * Get the reverse button icon color of the position line.
   */
  getReverseButtonIconColor(): string;
  /**
   * Set the reverse button icon color of the position line.
   * @param value The new reverse button icon color.
   */
  setReverseButtonIconColor(value: string): this;
  /**
   * Get the close button border color of the position line.
   */
  getCloseButtonBorderColor(): string;
  /**
   * Set the close button border color of the position line.
   * @param value The new close button border color.
   */
  setCloseButtonBorderColor(value: string): this;
  /**
   * Get the close button background color of the position line.
   */
  getCloseButtonBackgroundColor(): string;
  /**
   * Set the close button background color of the position line.
   * @param value The new close button background color.
   */
  setCloseButtonBackgroundColor(value: string): this;
  /**
   * Get the close button icon color of the position line.
   */
  getCloseButtonIconColor(): string;
  /**
   * Set the close button icon color of the position line.
   * @param value The new close button icon color.
   */
  setCloseButtonIconColor(value: string): this;
}
/**
 * Specific formatter for numbers
 */
export interface IPriceFormatter extends ISymbolValueFormatter {
  /**
   * Price Formatter
   * @param  {number} price - price
   * @param  {boolean} [signPositive] - add plus sign to result string.
   * @param  {number} [tailSize] - add `tailSize` digits to fractional part of result string
   * @param  {boolean} [signNegative] - add minus sign to result string.
   * @param  {boolean} [useRtlFormat] - Use Right to left format
   * @param  {boolean} [cutFractionalByPrecision] - cuts price by priceScalePrecision, without rounding.
   * @returns formatted price
   */
  format(
    price: number,
    signPositive?: boolean,
    tailSize?: number,
    signNegative?: boolean,
    useRtlFormat?: boolean,
    cutFractionalByPrecision?: boolean
  ): string;
}
/**
 * The Price Scale API allows interacting with the [price scale](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Price-Scale.md).
 * You can retrieve this interface by evoking the following methods of the {@link IPaneApi}:
 * - `getLeftPriceScales`
 * - `getRightPriceScales`
 * - `getMainSourcePriceScale`
 */
export interface IPriceScaleApi {
  /** Returns current mode of the price scale */
  getMode(): PriceScaleMode;
  /**
   * Changes current mode of the price scale
   * @param newMode new mode to set for the price scale
   */
  setMode(newMode: PriceScaleMode): void;
  /** Returns whether the price scale is inverted or not */
  isInverted(): boolean;
  /**
   * Changes current inverted state of the price scale
   * @param isInverted set to `true` if the price scale should become inverted
   */
  setInverted(isInverted: boolean): void;
  /**
   * Returns `true` when the price scale is locked
   */
  isLocked(): boolean;
  /**
   * Set whether the price scale should be locked or not
   * @param  {boolean} isLocked - set to `true` to lock the price scale
   */
  setLocked(isLocked: boolean): void;
  /**
   * Returns `true` when the price scale has auto scaling enabled
   */
  isAutoScale(): boolean;
  /**
   * Set whether auto scaling should be enabled or not for the price scale
   * @param  {boolean} isAutoScale - set to `true` to enable auto scaling
   */
  setAutoScale(isAutoScale: boolean): void;
  /**
   * Returns current visible price range of the price scale.
   * The result is an object with `from` and `to`,
   * which are the boundaries of the price scale visible range.
   */
  getVisiblePriceRange(): VisiblePriceRange | null;
  /**
   * Sets current visible price range of the price scale,
   * @param range an object with `from` and `to`, which are the boundaries of the price scale visible range.
   */
  setVisiblePriceRange(range: VisiblePriceRange): void;
  /** Returns `true` if the price scale contains the main series */
  hasMainSeries(): boolean;
  /** Returns an array of IDs of all studies attached to the price scale */
  getStudies(): EntityId[];
  /** Returns the current currency info set on the price scale if any or null if none is specified */
  currency(): CurrencyInfo | null;
  /**
   * Sets a currency on the price scale.
   * @param  {string|null} currency - currency supported by your backend (for example 'EUR', 'USD'). A null value will reset the currency to default.
   */
  setCurrency(currency: string | null): void;
  /** Returns the current unit info set on the price scale if any or null if none is specified */
  unit(): UnitInfo | null;
  /**
   * Sets a unit on the price scale.
   * @param  {string|null} unit - unit supported by your backend (for example 'weight', 'energy'). A null value will reset the unit to default.
   */
  setUnit(unit: string | null): void;
}
export interface IProjectionStudyResult {
  /** array of projection bars */
  bars: IProjectionBar[];
  /** always true */
  nonseries?: boolean;
  /** last price displayed on price scale */
  price?: number;
  /** always projection */
  type: "projection";
  /** box size is displayed in the legend */
  boxSize?: number;
  /** reversal amount is displayed in the legend */
  reversalAmount?: number;
  projectionTime?: number;
}
/**
 * Allows you to select entities ([drawings](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Drawings) and [indicators](https://www.tradingview.com/charting-library-docs/latest/ui_elements/indicators/)) on the chart. Consider the following example:
 *
 * ```js
 * var chart = tvWidget.activeChart();
 * // Prints all selection changes to the console
 * chart.selection().onChanged().subscribe(null, s => console.log(chart.selection().allSources()));
 * // Creates an indicator and saves its ID
 * var studyId = chart.createStudy("Moving Average", false, false, { length: 10 });
 * // Adds the indicator to the selection ([<id>] is printed to the console)
 * chart.selection().add(studyId);
 * // Clears the selection ([] is printed to the console)
 * chart.selection().clear();
 * ```
 *
 * #### Multiple Selection
 *
 * Multiple selection has the following specifics:
 *
 * - Either indicators or drawings can be selected at the same time.
 * - If you add an indicator to the selection, other entities are removed from it.
 * - Adding an array of objects to the selection works the same as adding these objects one by one.
 */
export interface ISelectionApi {
  /**
   * Add entity / entities to selection
   * @param  {EntityId[]|EntityId} entities - entities to be added to selection
   */
  add(entities: EntityId[] | EntityId): void;
  /**
   * Set entity / entities as the selection
   * @param  {EntityId[]|EntityId} entities - entities to be selected
   */
  set(entities: EntityId[] | EntityId): void;
  /**
   * Remove entities from the selection
   * @param  {EntityId[]} entities - entities to be removed from the selection
   */
  remove(entities: EntityId[]): void;
  /**
   * Does the selection contain the entity
   * @param  {EntityId} entity - entity to be checked
   * @returns `true` when entity is in the selection
   */
  contains(entity: EntityId): boolean;
  /**
   * Returns all the entities in the selection
   */
  allSources(): EntityId[];
  /**
   * Is the selection empty
   * @returns `true` when empty
   */
  isEmpty(): boolean;
  /**
   * Clear selection
   */
  clear(): void;
  /**
   * Subscription for selection changes.
   */
  onChanged(): ISubscription<() => void>;
  /**
   * Whether the entity can be added to the selection
   * @param  {EntityId} entity - entity to be checked
   * @returns `true` when entity can be added to the selection
   */
  canBeAddedToSelection(entity: EntityId): boolean;
}
export interface ISeparator extends IMenuItem {
  /** @inheritDoc */
  readonly type: MenuItemType.Separator;
}
/**
 * Series API
 *
 * You can retrieve this interface by using the {@link IChartWidgetApi.getSeries} method
 */
export interface ISeriesApi {
  /** Returns `true` if a user is able to remove/change/hide the main series */
  isUserEditEnabled(): boolean;
  /**
   * Enables or disables removing/changing/hiding the main series by the user
   */
  setUserEditEnabled(enabled: boolean): void;
  /** Merges the main series up (if possible) */
  mergeUp(): void;
  /** Merges the main series down (if possible) */
  mergeDown(): void;
  /** Unmerges the main series up (if possible) */
  unmergeUp(): void;
  /** Unmerges the main series down (if possible) */
  unmergeDown(): void;
  /** Pins the main series to a new price axis at right */
  detachToRight(): void;
  /** Pins the main series to a new price axis at left */
  detachToLeft(): void;
  /** Makes the main series to be an overlay source */
  detachNoScale(): void;
  /** Changes the price scale of the main series */
  changePriceScale(newPriceScale: SeriesPriceScale): void;
  /** Returns `true` if the main series is visible */
  isVisible(): boolean;
  /** Shows/hides the main series */
  setVisible(visible: boolean): void;
  /** Places main series on top of all other chart objects */
  bringToFront(): void;
  /** Places main series behind all other chart objects */
  sendToBack(): void;
  /** Value that is returned when a study is created via API */
  entityId(): EntityId;
  /** Returns properties for a specific chart style */
  chartStyleProperties<T extends ChartStyle>(
    chartStyle: T
  ): SeriesPreferencesMap[T];
  /** Sets properties for a specific chart style */
  setChartStyleProperties<T extends ChartStyle>(
    chartStyle: T,
    newPrefs: Partial<SeriesPreferencesMap[T]>
  ): void;
}
/**
 * Properties of the {@link ChartingLibraryWidgetOptions.settings_adapter} property that allows saving [user settings](https://www.tradingview.com/charting-library-docs/latest/saving_loading/user-settings.md) to your preferred storage, including server-side.
 */
export interface ISettingsAdapter {
  /** Initial settings the chart should be initiated with. */
  initialSettings?: InitialSettingsMap;
  /** Set a value for a setting. */
  setValue(key: string, value: string): void;
  /** Remove a value for a setting. */
  removeValue(key: string): void;
}
/**
 * Drawing Groups API. Refer to the [Drawings API](https://www.tradingview.com/charting-library-docs/latest/ui_elements/drawings/drawings-api.md#drawing-groups-api) article for more information.
 */
export interface IShapesGroupControllerApi {
  /**
   * Create a group of drawings from the selection.
   *
   * @throws If selection is empty, or selection contains non-drawings, or selection contains drawings from more than one pane.
   * @return The ID of the created group.
   */
  createGroupFromSelection(): ShapesGroupId;
  /**
   * Remove a group of drawings.
   *
   * @param groupId A group ID.
   */
  removeGroup(groupId: ShapesGroupId): void;
  /**
   * Get an array of all drawing groups.
   *
   * @returns An array of group IDs.
   */
  groups(): readonly ShapesGroupId[];
  /**
   * Get an array of IDs for each drawing in a group.
   *
   * @param groupId A group ID.
   * @returns An array of drawing IDs.
   */
  shapesInGroup(groupId: ShapesGroupId): readonly EntityId[];
  /**
   * Remove a drawing from a group. If the drawing is the only drawing in the group then the group is also removed.
   *
   * @param groupId A group ID.
   * @param shapeId A drawing ID.
   */
  excludeShapeFromGroup(groupId: ShapesGroupId, shapeId: EntityId): void;
  /**
   * Add a drawing to a group.
   *
   * @param groupId A group ID.
   * @param shapeId A drawing ID.
   */
  addShapeToGroup(groupId: ShapesGroupId, shapeId: EntityId): void;
  /**
   * Get an object containing the available Z-order operations for a group.
   *
   * @param groupId A group ID.
   * @returns The available Z-order operations.
   */
  availableZOrderOperations(groupId: ShapesGroupId): AvailableZOrderOperations;
  /**
   * Move the group to the top of the Z-order.
   *
   * @param groupId A group ID.
   */
  bringToFront(groupId: ShapesGroupId): void;
  /**
   * Move the group to the bottom of the Z-order.
   *
   * @param groupId A group ID.
   */
  sendToBack(groupId: ShapesGroupId): void;
  /**
   * Move the group one level up in the Z-order.
   *
   * @param groupId A group ID.
   */
  bringForward(groupId: ShapesGroupId): void;
  /**
   * Move the group one level down in the Z-order.
   *
   * @param groupId A group ID.
   */
  sendBackward(groupId: ShapesGroupId): void;
  /**
   * Move the group immediately below the target in the Z-order.
   *
   * @param groupId A group ID.
   * @param target A target ID.
   */
  insertAfter(groupId: ShapesGroupId, target: ShapesGroupId | EntityId): void;
  /**
   * Move the group immediately above the target in the Z-order.
   *
   * @param groupId A group ID.
   * @param target A target ID.
   */
  insertBefore(groupId: ShapesGroupId, target: ShapesGroupId | EntityId): void;
  /**
   * Show or hide all drawings in a group.
   *
   * @param groupId A group ID.
   * @param value A boolean flag. `true` to show, `false` to hide.
   */
  setGroupVisibility(groupId: ShapesGroupId, value: boolean): void;
  /**
   * Get the visibility state of a group.
   *
   * @param groupId A group ID.
   * @returns The visibility state.
   */
  groupVisibility(groupId: ShapesGroupId): GroupVisibilityState;
  /**
   * Lock or unlock a group.
   *
   * @param groupId A group ID.
   * @param value A boolean flag. `true` to lock, `false` to unlock.
   */
  setGroupLock(groupId: ShapesGroupId, value: boolean): void;
  /**
   * Get locked state of a group.
   *
   * @param groupId A group ID.
   * @returns The locked state.
   */
  groupLock(groupId: ShapesGroupId): GroupLockState;
  /**
   * Get the name of a group.
   *
   * @param groupId A group ID.
   * @returns The name of the group.
   */
  getGroupName(groupId: ShapesGroupId): string;
  /**
   * Set the name of a group. Names do not need to be unique.
   *
   * @param groupId A group ID.
   * @param name The new name of the group.
   */
  setGroupName(groupId: ShapesGroupId, name: string): void;
  /**
   * Check if some drawings can be grouped.
   *
   * @param shapes An array of drawing IDs.
   * @return `true` if the drawings can be grouped, `false` otherwise.
   */
  canBeGroupped(shapes: readonly EntityId[]): boolean;
}
/**
 * API object for interacting with a study.
 *
 * You can retrieve this interface by using the {@link IChartWidgetApi.getStudyById} method
 */
export interface IStudyApi {
  /**
   * Get if user editing is enabled for the study.
   *
   * @returns `true` if editing is enabled, `false` otherwise.
   */
  isUserEditEnabled(): boolean;
  /**
   * Set if user editing is enabled for the study.
   *
   * @param enabled `true` if editing should be enabled, `false` otherwise.
   */
  setUserEditEnabled(enabled: boolean): void;
  /**
   * Get descriptions of the study inputs.
   */
  getInputsInfo(): StudyInputInformation[];
  /**
   * Get current values of the study inputs.
   */
  getInputValues(): StudyInputValueItem[];
  /**
   * Set the value of one or more study inputs.
   *
   * @param values Study input values to set.
   */
  setInputValues(values: StudyInputValueItem[]): void;
  /**
   * Get descriptions of study styles.
   */
  getStyleInfo(): StudyStyleInfo;
  /**
   * Get current values of the study styles.
   */
  getStyleValues(): StudyStyleValues;
  /**
   * Merge the study into the pane above, if possible.
   */
  mergeUp(): void;
  /**
   * Merge the study into the pane below, if possible.
   */
  mergeDown(): void;
  /**
   * Unmerge the study into the pane above, if possible.
   */
  unmergeUp(): void;
  /**
   * Unmerge the study into the pane below, if possible.
   */
  unmergeDown(): void;
  /**
   * Change the price scale that the study is attached to.
   *
   * @param newPriceScale Price scale identifier, or the ID of another study whose price scale the study should be moved to.
   */
  changePriceScale(newPriceScale: StudyPriceScale | EntityId): void;
  /**
   * Get if the study is visible.
   *
   * @returns `true` if visible, `false` otherwise.
   */
  isVisible(): boolean;
  /**
   * Set the study visibility.
   *
   * @param visible `true` if the study should be visible, `false` otherwise.
   */
  setVisible(visible: boolean): void;
  /**
   * Move the study visually in front of all other chart objects.
   */
  bringToFront(): void;
  /**
   * Move the study visually behind of all other chart objects.
   */
  sendToBack(): void;
  /**
   * Override one or more of the indicator's properties.
   * Refer to [Indicator Overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md#change-the-existing-indicator) for more information.
   * Overrides for built-in indicators are listed in {@link SingleIndicatorOverrides}.
   *
   * @param overrides Property values to override.
   */
  applyOverrides<TOverrides extends Partial<SingleIndicatorOverrides>>(
    overrides: TOverrides
  ): void;
  /**
   * Copies the study to all charts in the layout.
   * Only applicable to multi-chart layouts (Trading Platform).
   */
  applyToEntireLayout(): void;
  /**
   * Get a subscription that can be used to subscribe a callback when the study data has loaded.
   *
   * @returns A subscription.
   *
   * Example:
   * ```javascript
   * studyApi.onDataLoaded().subscribe(
   *     null,
   *     () => console.log('Study data is loaded'),
   *     true
   * );
   * ```
   */
  onDataLoaded(): ISubscription<() => void>;
  /**
   * Get a subscription that can be used to subscribe a callback when the study has an error.
   *
   * @returns A subscription.
   *
   * Example:
   * ```javascript
   * studyApi.studyApi.onStudyError().subscribe(
   *     null,
   *     () => console.log('Study error'),
   *     true
   * );
   * ```
   */
  onStudyError(): ISubscription<() => void>;
}
/**
 * A subscription. Used to subscribe callbacks to events.
 */
export interface ISubscription<TFunc extends Function> {
  /**
   * Subscribe a callback function to this event. Subscribed callbacks are called when the event fires.
   *
   * @param obj Object used as the `this` value bound to the callback function.
   * @param member Function called when the event is fired.
   * @param singleshot `true` if the subscription should be automatically removed after the first time it is fired.
   *
   * @example
   * ```
   * // Log 'Series data loaded!' to the console the next time the data loaded event fires and then unsubscribe automatically.
   * seriesApi.onDataLoaded().subscribe(null, () => { console.log('Series data loaded!'); }, true);
   * ```
   * Subscribe to an event within a class. Manually unsubscribe when some condition is true.
   * ```
   * class Example {
   *   constructor(seriesApi) {
   *     this._seriesApi = seriesApi;
   *     this._seriesApi.onDataLoaded().subscribe(this, this._onDataLoaded);
   *   }
   *
   *   _onDataLoaded() {
   *     // Do something in response to the event.
   *
   *     if (someUnsubscribeCondition) {
   *       this._seriesApi.onDataLoaded().unsubscribe(this, this._onDataLoaded);
   *     }
   *   }
   * }
   * ```
   */
  subscribe(obj: object | null, member: TFunc, singleshot?: boolean): void;
  /**
   * Unsubscribe a previously subscribed callback function.
   * It is important that the `obj` and `member` arguments are the same as the ones passed when the callback was subscribed.
   *
   * @param obj Object passed as the `this` value when the callback was subscribed.
   * @param member Function subscribed to the event.
   */
  unsubscribe(obj: object | null, member: TFunc): void;
  /**
   * Unsubscribe all callbacks that were subscribed with the same `obj` value.
   *
   * @param obj `obj` value passed when the callbacks were subscribed.
   * @example
   * ```
   * // Unsubscribe all three callback functions at once in the `destroy` method.
   * class Example {
   *   constructor(seriesApi) {
   *     this._seriesApi = seriesApi;
   *     this._seriesApi.onDataLoaded().subscribe(this, this._callback1);
   *     this._seriesApi.onDataLoaded().subscribe(this, this._callback2);
   *     this._seriesApi.onDataLoaded().subscribe(this, this._callback3);
   *   }
   *
   *   destroy() {
   *     this._seriesapi.onDataLoaded().unsubscribeAll(this);
   *   }
   *
   *   _callback1() { ... }
   *   _callback2() { ... }
   *   _callback3() { ... }
   * }
   * ```
   */
  unsubscribeAll(obj: object | null): void;
}
/**
 * PineJS execution context symbol information.
 */
export interface ISymbolInstrument {
  /** Period Base */
  periodBase: string;
  /** Ticker ID */
  tickerid: string;
  /** Currency Code */
  currencyCode?: string | null;
  /** Unit ID */
  unitId?: string | null;
  /** Bar resolution */
  period: ResolutionString;
  /** Index */
  index: number;
  /** Time */
  time: number;
  /** Open bar value */
  open: number;
  /** High bar value */
  high: number;
  /** Low bar value */
  low: number;
  /** Close bar value */
  close: number;
  /** Bar Volume value */
  volume: number;
  /** Time of the update */
  updatetime: number;
  /** Ticker */
  ticker: string;
  /** Resolution */
  resolution: string;
  /** Interval */
  interval: number;
  /** Minimum tick amount */
  minTick: number;
  /** Whether this is the first bar */
  isFirstBar: boolean;
  /** Whether this is the last bar */
  isLastBar: boolean;
  /** Whether this is a new bar */
  isNewBar: boolean;
  /** Whether the bar is closed */
  isBarClosed: boolean;
  /** Symbol information */
  info?: LibrarySymbolInfo;
  /**
   * Time of the bar.
   *
   * @returns the timestamp in milliseconds
   */
  bartime(): number;
  /**
   * @returns true if the bar resolution is day/week/month, false if it is intraday
   */
  isdwm(): boolean;
}
export interface ISymbolValueFormatter {
  /** Default formatter function used to assign the correct sign (+ or -) to a number  */
  format(price: number, signPositive?: boolean): string;
  /**
   * Formatter for a price change
   * @param currentPrice - current price
   * @param prevPrice - previous price
   * @param signPositive - is the sign of the number positive
   */
  formatChange?(
    currentPrice: number,
    prevPrice: number,
    signPositive?: boolean
  ): string;
}
/**
 * API object for interacting with the [time scale](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Time-Scale.md).
 *
 * You can retrieve this interface by using the {@link IChartWidgetApi.getTimeScale} method
 */
export interface ITimeScaleApi {
  /** Returns the time associated to a given coordinate (distance in pixels from the leftmost visible bar) */
  coordinateToTime(x: number): number | null;
  /**
   * Users will be notified every time `barSpacing` value is changed. This typically occurs when zooming in/out on the chart.
   * This is to detect when the chart has been zoomed in/out
   */
  barSpacingChanged(): ISubscription<(newBarSpacing: number) => void>;
  /**
   * Users will be notified every time `rightOffset` value is changed.
   * This is to detect when the chart has been scrolled left/right.
   */
  rightOffsetChanged(): ISubscription<(rightOffset: number) => void>;
  /** To set a new right offset */
  setRightOffset(offset: number): void;
  /** To set a new bar spacing */
  setBarSpacing(newBarSpacing: number): void;
  /** Returns the current bar spacing */
  barSpacing(): number;
  /** Returns the current right offset */
  rightOffset(): number;
  /** Returns the current width of the chart in pixels */
  width(): number;
  /** Object that can be used to read/set/watch the default right offset (margin)  */
  defaultRightOffset(): IWatchedValue<number>;
  /** Object that can be used to read/set/watch the default right offset (in percent) (margin)  */
  defaultRightOffsetPercentage(): IWatchedValue<number>;
  /**
   * Object that can be used to read/set/watch whether to use `defaultRightOffset` or `defaultRightOffsetPercentage`
   * option for the right offset (margin).
   * - `false`: use `defaultRightOffset`
   * - `true`: use `defaultRightOffsetPercentage`
   *
   * Default: `false`
   */
  usePercentageRightOffset(): IWatchedValue<boolean>;
}
export interface ITimezoneApi {
  /** Array of supported TimezoneInfo */
  availableTimezones(): readonly TimezoneInfo[];
  /** Returns the current TimezoneInfo */
  getTimezone(): TimezoneInfo;
  /** Sets the current timezone */
  setTimezone(
    timezone: TimezoneId | CustomTimezoneId,
    options?: UndoOptions
  ): void;
  /**
   * To be notified when the timezone is changed
   *
   * Example:
   * ```javascript
   * timezoneApi.onTimezoneChanged().subscribe(
   *     null,
   *     timezone => console.log(`New timezone: ${timezone}`),
   *     true
   * );
   * ```
   */
  onTimezoneChanged(): ISubscription<(timezone: TimezoneId) => void>;
}
export interface IUpdatableAction extends IAction {
  /**
   * Update the options for the Action
   * @param  {Partial<OmitActionId<ActionOptions>>} options - updated options
   */
  update(options: Partial<OmitActionId<ActionOptions>>): void;
}
/**
 * An API object for interacting with the widgetbar (right sidebar) watchlist.
 *
 * **Notes about watchlist contents**
 *
 * Watchlist items should be symbol names which your datafeed `resolveSymbol` method can resolve. This
 * means that generally shorter names such as `AAPL` can be used if your datafeed understands it. However,
 * it is recommend that you provided the symbol names as they appear within the symbolInfo result (for
 * example: `NASDAQNM:AAPL`).
 *
 * Additionally, any item in the list which is prefixed with `###` will be considered a
 * section divider in the watchlist.
 */
export interface IWatchListApi {
  /**
   * Get a default list of symbols.
   * @returns default list of symbols
   */
  defaultList(): string[];
  /**
   * Get a list of symbols.
   * If the `id` parameter is not provided then the current list will be returned. If there is no WatchList then `null` will be returned.
   * @param  {string} [id] - Watchlist ID
   * @returns list of symbols for watchlist
   */
  getList(id?: string): string[] | null;
  /**
   * Get all watchlists. If there is no WatchList then `null` will be returned.
   * @returns object of all watchlists
   */
  getAllLists(): WatchListSymbolListMap | null;
  /**
   * Make the watchlist with the specified `id` active.
   * @param  {string} id - watchlist ID
   */
  setActiveList(id: string): void;
  /**
   * Get the ID of the current watchlist. If there is no WatchList then `null` will be returned.
   * @returns id of active watchlist
   */
  getActiveListId(): string | null;
  /**
   * **Obsolete. Use `updateList` instead.**
   *
   * Set the list of symbols for the watchlist. It will replace the entire list.
   * @param  {string[]} symbols - symbol IDs
   */
  setList(symbols: string[]): void;
  /**
   * Edit the list of symbols for a watchlist.
   * @param  {string} listId - ID of the watchlist
   * @param  {string[]} symbols - symbols to be set for the watchlist. Any item in the list which is prefixed with `###` will be considered a
   * section divider in the watchlist.
   */
  updateList(listId: string, symbols: string[]): void;
  /**
   * Rename the watchlist.
   * @param  {string} listId - ID of the watchlist
   * @param  {string} newName - new name to set for the watchlist
   */
  renameList(listId: string, newName: string): void;
  /**
   * Create a list of symbols with `listName` name. If the `listName` parameter is not provided or there is no WatchList then `null` will be returned;
   * @param  {string} [listName] - name for the watchlist
   * @param  {string[]} [symbols] - symbol IDs for the watchlist. Any item in the list which is prefixed with `###` will be considered a
   * section divider in the watchlist.
   * @returns WatchListSymbolList
   */
  createList(listName?: string, symbols?: string[]): WatchListSymbolList | null;
  /**
   * Save a list of symbols.
   * @param  {WatchListSymbolList} list
   * @returns If there is no WatchList or an equivalent list already exists then `false` will be returned, otherwise `true` will returned.
   */
  saveList(list: WatchListSymbolList): boolean;
  /**
   * Delete a watchlist of symbols
   * @param  {string} listId - watchlist ID
   */
  deleteList(listId: string): void;
  /**
   * Subscription for when the symbols of the active watchlist are changed. Use the `subscribe` method of the returned {@link ISubscription} object to subscribe to the notifications.
   */
  onListChanged(): ISubscription<WatchListSymbolListChangedCallback>;
  /**
   * Subscription for when the active watchlist is changed to a different list. Use the `subscribe` method of the returned {@link ISubscription} object to subscribe to the notifications.
   */
  onActiveListChanged(): ISubscription<EmptyCallback>;
  /**
   * Subscription for when a new list is added to the watchlist widget. Use the `subscribe` method of the returned {@link ISubscription} object to subscribe to the notifications.
   */
  onListAdded(): ISubscription<WatchListSymbolListAddedCallback>;
  /**
   * Subscription for when a list is removed from the watchlist widget. Use the `subscribe` method of the returned {@link ISubscription} object to subscribe to the notifications.
   */
  onListRemoved(): ISubscription<WatchListSymbolListRemovedCallback>;
  /**
   * Subscription for when a list is renamed. Use the `subscribe` method of the returned {@link ISubscription} object to subscribe to the notifications.
   */
  onListRenamed(): ISubscription<WatchListSymbolListRenamedCallback>;
}
export interface IWatchedValue<T>
  extends IWatchedValueReadonly<T>,
    IObservableValue<T> {
  /**
   * Set value for the watched value
   * @param  {T} value - value to set
   * @param  {boolean} [forceUpdate] - force an update
   */
  setValue(value: T, forceUpdate?: boolean): void;
  /** @inheritDoc */
  subscribe(
    callback: WatchedValueCallback<T>,
    options?: WatchedValueSubscribeOptions
  ): void;
  /** @inheritDoc */
  unsubscribe(callback?: WatchedValueCallback<T> | null): void;
}
export interface IWatchedValueReadonly<T> extends IObservableValueReadOnly<T> {
  /**
   * Subscribe to watched value changes
   * @param  {(value:T)=>void} callback - callback to be evoked when change occurs
   * @param  {WatchedValueSubscribeOptions} [options] - watch subscriber options
   */
  subscribe(
    callback: (value: T) => void,
    options?: WatchedValueSubscribeOptions
  ): void;
  /**
   * Unsubscribe to watched value changes
   * @param  {((value:T)=>void)|null} [callback] - callback to remove
   */
  unsubscribe(callback?: ((value: T) => void) | null): void;
  /**
   * A simplified version of subscription, with promise-like interface, generally for using with boolean-valued watched values
   * @param  {WatchedValueCallback<T>} callback - a function to be called when the value became `true`. `once` and `callWithLast` are implicitly set to true.
   */
  when(callback: WatchedValueCallback<T>): void;
}
/**
 * An API object used to change the settings of the watermark.
 */
export interface IWatermarkApi {
  /**
   * Object that can be used to read/set/watch the color of the watermark text.
   */
  color(): IWatchedValue<string>;
  /**
   * Object that can be used to read/set/watch the visibility of the watermark.
   */
  visibility(): IWatchedValue<boolean>;
  /**
   * Set a custom content provider for the watermark content.
   *
   * @param provider - Custom watermark content provider, use `null` if you would like to revert back to the default content for the watermark.
   */
  setContentProvider(provider: WatermarkContentProvider | null): void;
}
/**
 * Widget Bar API
 */
export interface IWidgetbarApi extends IDestroyable {
  /**
   * Show page
   * @param  {PageName} pageName - name of page to show
   */
  showPage(pageName: PageName): void;
  /**
   * Hide page
   * @param  {PageName} pageName - name of page to hide
   */
  hidePage(pageName: PageName): void;
  /**
   * Checks if page is visible
   * @param  {PageName} pageName - page to check if visible
   * @returns true` when page is visible
   */
  isPageVisible(pageName: PageName): boolean;
  /**
   * Open order panel widget
   */
  openOrderPanel(): void;
  /**
   * Close order panel widget
   */
  closeOrderPanel(): void;
  /**
   * Change the visibility of the right toolbar
   * @param {boolean} visible - true to display the toolbar, false to hide
   */
  changeWidgetBarVisibility(visible: boolean): void;
}
/**
 * Overrides for the 'Ichimoku Cloud' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface IchimokuCloudIndicatorOverrides {
  /** Default value: `#000080` */
  "plots background.color": string;
  /** Default value: `90` */
  "plots background.transparency": number;
  /** Default value: `true` */
  "plots background.visible": boolean;
  /** Default value: `15` */
  "conversion line.display": number;
  /** Default value: `0` */
  "conversion line.linestyle": number;
  /** Default value: `1` */
  "conversion line.linewidth": number;
  /** Default value: `line` */
  "conversion line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "conversion line.trackprice": boolean;
  /** Default value: `0` */
  "conversion line.transparency": number;
  /** Default value: `#2196F3` */
  "conversion line.color": string;
  /** Default value: `15` */
  "base line.display": number;
  /** Default value: `0` */
  "base line.linestyle": number;
  /** Default value: `1` */
  "base line.linewidth": number;
  /** Default value: `line` */
  "base line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "base line.trackprice": boolean;
  /** Default value: `0` */
  "base line.transparency": number;
  /** Default value: `#801922` */
  "base line.color": string;
  /** Default value: `15` */
  "lagging span.display": number;
  /** Default value: `0` */
  "lagging span.linestyle": number;
  /** Default value: `1` */
  "lagging span.linewidth": number;
  /** Default value: `line` */
  "lagging span.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lagging span.trackprice": boolean;
  /** Default value: `0` */
  "lagging span.transparency": number;
  /** Default value: `#43A047` */
  "lagging span.color": string;
  /** Default value: `15` */
  "leading span a.display": number;
  /** Default value: `0` */
  "leading span a.linestyle": number;
  /** Default value: `1` */
  "leading span a.linewidth": number;
  /** Default value: `line` */
  "leading span a.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "leading span a.trackprice": boolean;
  /** Default value: `0` */
  "leading span a.transparency": number;
  /** Default value: `#A5D6A7` */
  "leading span a.color": string;
  /** Default value: `15` */
  "leading span b.display": number;
  /** Default value: `0` */
  "leading span b.linestyle": number;
  /** Default value: `1` */
  "leading span b.linewidth": number;
  /** Default value: `line` */
  "leading span b.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "leading span b.trackprice": boolean;
  /** Default value: `0` */
  "leading span b.transparency": number;
  /** Default value: `#FAA1A4` */
  "leading span b.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Icon drawing tool.
 */
export interface IconLineToolOverrides {
  /** Default value: `1.5707963267948966` */
  "linetoolicon.angle": number;
  /** Default value: `#2962FF` */
  "linetoolicon.color": string;
  /** Default value: `61720` */
  "linetoolicon.icon": number;
  /** Default value: `40` */
  "linetoolicon.size": number;
}
export interface IconOptions {
  /** Icon number */
  icon: number;
}
/**
 * Override properties for the Image drawing tool.
 */
export interface ImageLineToolOverrides {
  /** Default value: `0` */
  "linetoolimage.angle": number;
  /** Default value: `0` */
  "linetoolimage.cssHeight": number;
  /** Default value: `0` */
  "linetoolimage.cssWidth": number;
  /** Default value: `0` */
  "linetoolimage.transparency": number;
}
export interface IndividualPosition
  extends IndividualPositionBase,
    CustomFields {}
/**
 * Describes an individual position.
 */
export interface IndividualPositionBase {
  /** Individual position ID. Usually id should be equal to brokerSymbol */
  id: string;
  /** Individual position open date (UNIX timestamp in milliseconds) */
  date: number;
  /** Symbol name */
  symbol: string;
  /** Individual position Quantity */
  qty: number;
  /** Individual position Side */
  side: Side;
  /** Individual position price */
  price: number;
}
/**
 * Override properties for the Infoline drawing tool.
 */
export interface InfolineLineToolOverrides {
  /** Default value: `true` */
  "linetoolinfoline.alwaysShowStats": boolean;
  /** Default value: `false` */
  "linetoolinfoline.bold": boolean;
  /** Default value: `false` */
  "linetoolinfoline.extendLeft": boolean;
  /** Default value: `false` */
  "linetoolinfoline.extendRight": boolean;
  /** Default value: `14` */
  "linetoolinfoline.fontsize": number;
  /** Default value: `center` */
  "linetoolinfoline.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetoolinfoline.italic": boolean;
  /** Default value: `0` */
  "linetoolinfoline.leftEnd": number;
  /** Default value: `#2962FF` */
  "linetoolinfoline.linecolor": string;
  /** Default value: `0` */
  "linetoolinfoline.linestyle": number;
  /** Default value: `2` */
  "linetoolinfoline.linewidth": number;
  /** Default value: `0` */
  "linetoolinfoline.rightEnd": number;
  /** Default value: `true` */
  "linetoolinfoline.showAngle": boolean;
  /** Default value: `true` */
  "linetoolinfoline.showBarsRange": boolean;
  /** Default value: `true` */
  "linetoolinfoline.showDateTimeRange": boolean;
  /** Default value: `true` */
  "linetoolinfoline.showDistance": boolean;
  /** Default value: `false` */
  "linetoolinfoline.showLabel": boolean;
  /** Default value: `false` */
  "linetoolinfoline.showMiddlePoint": boolean;
  /** Default value: `true` */
  "linetoolinfoline.showPercentPriceRange": boolean;
  /** Default value: `true` */
  "linetoolinfoline.showPipsPriceRange": boolean;
  /** Default value: `false` */
  "linetoolinfoline.showPriceLabels": boolean;
  /** Default value: `true` */
  "linetoolinfoline.showPriceRange": boolean;
  /** Default value: `1` */
  "linetoolinfoline.statsPosition": number;
  /** Default value: `#2962FF` */
  "linetoolinfoline.textcolor": string;
  /** Default value: `bottom` */
  "linetoolinfoline.vertLabelsAlign": string;
}
export interface InitialSettingsMap {
  /** Initial Setting */
  [key: string]: string;
}
/**
 * Override properties for the Insidepitchfork drawing tool.
 */
export interface InsidepitchforkLineToolOverrides {
  /** Default value: `false` */
  "linetoolinsidepitchfork.extendLines": boolean;
  /** Default value: `true` */
  "linetoolinsidepitchfork.fillBackground": boolean;
  /** Default value: `0.25` */
  "linetoolinsidepitchfork.level0.coeff": number;
  /** Default value: `#ffb74d` */
  "linetoolinsidepitchfork.level0.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level0.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level0.linewidth": number;
  /** Default value: `false` */
  "linetoolinsidepitchfork.level0.visible": boolean;
  /** Default value: `0.382` */
  "linetoolinsidepitchfork.level1.coeff": number;
  /** Default value: `#81c784` */
  "linetoolinsidepitchfork.level1.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level1.linewidth": number;
  /** Default value: `false` */
  "linetoolinsidepitchfork.level1.visible": boolean;
  /** Default value: `0.5` */
  "linetoolinsidepitchfork.level2.coeff": number;
  /** Default value: `#089981` */
  "linetoolinsidepitchfork.level2.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolinsidepitchfork.level2.visible": boolean;
  /** Default value: `0.618` */
  "linetoolinsidepitchfork.level3.coeff": number;
  /** Default value: `#089981` */
  "linetoolinsidepitchfork.level3.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level3.linewidth": number;
  /** Default value: `false` */
  "linetoolinsidepitchfork.level3.visible": boolean;
  /** Default value: `0.75` */
  "linetoolinsidepitchfork.level4.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolinsidepitchfork.level4.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level4.linewidth": number;
  /** Default value: `false` */
  "linetoolinsidepitchfork.level4.visible": boolean;
  /** Default value: `1` */
  "linetoolinsidepitchfork.level5.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolinsidepitchfork.level5.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolinsidepitchfork.level5.visible": boolean;
  /** Default value: `1.5` */
  "linetoolinsidepitchfork.level6.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolinsidepitchfork.level6.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level6.linewidth": number;
  /** Default value: `false` */
  "linetoolinsidepitchfork.level6.visible": boolean;
  /** Default value: `1.75` */
  "linetoolinsidepitchfork.level7.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolinsidepitchfork.level7.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level7.linewidth": number;
  /** Default value: `false` */
  "linetoolinsidepitchfork.level7.visible": boolean;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level8.coeff": number;
  /** Default value: `#F77C80` */
  "linetoolinsidepitchfork.level8.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.level8.linewidth": number;
  /** Default value: `false` */
  "linetoolinsidepitchfork.level8.visible": boolean;
  /** Default value: `#F23645` */
  "linetoolinsidepitchfork.median.color": string;
  /** Default value: `0` */
  "linetoolinsidepitchfork.median.linestyle": number;
  /** Default value: `2` */
  "linetoolinsidepitchfork.median.linewidth": number;
  /** Default value: `true` */
  "linetoolinsidepitchfork.median.visible": boolean;
  /** Default value: `2` */
  "linetoolinsidepitchfork.style": number;
  /** Default value: `80` */
  "linetoolinsidepitchfork.transparency": number;
}
export interface InstrumentInfo {
  /** Quantity field step and boundaries */
  qty: QuantityMetainfo;
  /** Value of 1 pip for the instrument in the account currency */
  pipValue: number;
  /** Size of 1 pip (e.g., 0.0001 for EURUSD) */
  pipSize: number;
  /** Minimal price change (e.g., 0.00001 for EURUSD). Used for price fields. */
  minTick: number;
  /** Lot size */
  lotSize?: number;
  /** Instrument type. `forex` enables negative pips. You can check that in Order Ticket. */
  type?: SymbolType;
  /** Units of quantity or amount. Displayed instead of the Units label in the Quantity/Amount field. */
  units?: string;
  /** Display name for the symbol */
  brokerSymbol?: string;
  /** A description to be displayed in the UI dialogs. */
  description: string;
  /** Number of decimal places of DOM asks/bids volume (optional, 0 by default). */
  domVolumePrecision?: number;
  /** Leverage */
  leverage?: string;
  /**
   * The margin requirement for the instrument. A 3% margin rate should be represented as 0.03.
   */
  marginRate?: number;
  /** Minimal price change for limit price field of the Limit and Stop Limit order. If set it will override the `minTick` value. */
  limitPriceStep?: number;
  /** Minimal price change for stop price field of the Stop and Stop Limit order. If set it will override the `minTick` value. */
  stopPriceStep?: number;
  /** Array of strings with valid duration values. You can check that in Order Ticket. */
  allowedDurations?: string[];
  /**
   * Dynamic minimum price movement.
   * It is used if the instrument's minimum price movement changes depending on the price range.
   *
   * For example: `0.01 10 0.02 25 0.05`, where `minTick` is `0.01` for a price less than `10`, `minTick` is `0.02` for a price less than `25`, `minTick` is `0.05` for a price more and equal than `25`.
   */
  variableMinTick?: string;
  /** Instrument currency that is displayed in Order Ticket */
  currency?: string;
  /** The first currency quoted in a currency pair. Used for crypto currencies only. */
  baseCurrency?: string;
  /** The second currency quoted in a currency pair. Used for crypto currencies only. */
  quoteCurrency?: string;
  /** The value represented by a full point of price movement in the contract currency. This value is used to calculate the Total Value (symbol currency) of the order. */
  bigPointValue?: number;
  /** The value represents how much price is multiplied in relation to base monetary unit. */
  priceMagnifier?: number;
  /** Supported order types for the instrument */
  allowedOrderTypes?: OrderType[];
}
/** Show a custom message with the reason why the symbol cannot be traded */
export interface IsTradableResult {
  /**
   * Is the symbol tradable
   */
  tradable: boolean;
  /**
   * Reason is displayed in Order Ticket
   */
  reason?: string;
  /** Solution available to user to resolve the issue */
  solutions?: TradableSolutions;
  /** shortReason is displayed in the legend */
  shortReason?: string;
}
export interface KagiStylePreferences {
  /** Up line color */
  upColor: string;
  /** Up down color */
  downColor: string;
  /** Up projection line color */
  upColorProjection: string;
  /** Down projection line color */
  downColorProjection: string;
}
/**
 * Overrides for the 'Keltner Channels' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface KeltnerChannelsIndicatorOverrides {
  /** Default value: `#2196F3` */
  "plots background.color": string;
  /** Default value: `95` */
  "plots background.transparency": number;
  /** Default value: `true` */
  "plots background.visible": boolean;
  /** Default value: `15` */
  "upper.display": number;
  /** Default value: `0` */
  "upper.linestyle": number;
  /** Default value: `1` */
  "upper.linewidth": number;
  /** Default value: `line` */
  "upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "upper.trackprice": boolean;
  /** Default value: `0` */
  "upper.transparency": number;
  /** Default value: `#2196F3` */
  "upper.color": string;
  /** Default value: `15` */
  "middle.display": number;
  /** Default value: `0` */
  "middle.linestyle": number;
  /** Default value: `1` */
  "middle.linewidth": number;
  /** Default value: `line` */
  "middle.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "middle.trackprice": boolean;
  /** Default value: `0` */
  "middle.transparency": number;
  /** Default value: `#2196F3` */
  "middle.color": string;
  /** Default value: `15` */
  "lower.display": number;
  /** Default value: `0` */
  "lower.linestyle": number;
  /** Default value: `1` */
  "lower.linewidth": number;
  /** Default value: `line` */
  "lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lower.trackprice": boolean;
  /** Default value: `0` */
  "lower.transparency": number;
  /** Default value: `#2196F3` */
  "lower.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Klinger Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface KlingerOscillatorIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  /** Default value: `15` */
  "signal.display": number;
  /** Default value: `0` */
  "signal.linestyle": number;
  /** Default value: `1` */
  "signal.linewidth": number;
  /** Default value: `line` */
  "signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "signal.trackprice": boolean;
  /** Default value: `0` */
  "signal.transparency": number;
  /** Default value: `#43A047` */
  "signal.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Know Sure Thing' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface KnowSureThingIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "kst.display": number;
  /** Default value: `0` */
  "kst.linestyle": number;
  /** Default value: `1` */
  "kst.linewidth": number;
  /** Default value: `line` */
  "kst.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "kst.trackprice": boolean;
  /** Default value: `0` */
  "kst.transparency": number;
  /** Default value: `#089981` */
  "kst.color": string;
  /** Default value: `15` */
  "signal.display": number;
  /** Default value: `0` */
  "signal.linestyle": number;
  /** Default value: `1` */
  "signal.linewidth": number;
  /** Default value: `line` */
  "signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "signal.trackprice": boolean;
  /** Default value: `0` */
  "signal.transparency": number;
  /** Default value: `#F23645` */
  "signal.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Least Squares Moving Average' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface LeastSquaresMovingAverageIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * An API object representing leverage info for an order.
 */
export interface LeverageInfo {
  /**
   * The title for any Leverage Dialogs shown by the library.
   */
  title: string;
  /**
   * The leverage.
   */
  leverage: number;
  /**
   * The minimum leverage value.
   */
  min: number;
  /**
   * The maximum leverage value.
   */
  max: number;
  /**
   * The mimimum change between leverage values.
   */
  step: number;
}
/**
 * An API object representing an order. Used when requesting leverage information from a broker.
 */
export interface LeverageInfoParams {
  /**
   * The order symbol.
   */
  symbol: string;
  /**
   * The type of the order.
   */
  orderType: OrderType;
  /**
   * The order side. Buy or sell.
   */
  side: Side;
  /**
   * Custom data for the broker.
   */
  customFields?: CustomInputFieldsValues;
}
/**
 * An API object representing some messages describing the leverage value set by the user.
 *
 * Shown in any Leverage Dialogs.
 */
export interface LeveragePreviewResult {
  /**
   * Informative messages about the leverage value.
   */
  infos?: string[];
  /**
   * Warnings about the leverage value.
   */
  warnings?: string[];
  /**
   * Errors about the leverage value.
   */
  errors?: string[];
}
/**
 * An API object representing an order and leverage. Used when requesting that a broker updates a order's leverage.
 */
export interface LeverageSetParams extends LeverageInfoParams {
  /**
   * The requested leverage value.
   */
  leverage: number;
}
/**
 * An API object representing a response containing the leverage value for a user.
 */
export interface LeverageSetResult {
  /**
   * The leverage.
   */
  leverage: number;
}
export interface LibraryPineStudy<TPineStudyResult> {
  /**
   * Called only once during the lifetime of the study and designed to get additional info for the study.
   *
   * Example:
   * ```
   * this.init = function(context, inputCallback) {
   *     var symbol = '#EQUITY';
   *     var period = PineJS.Std.period(this._context);
   *     context.new_sym(symbol, period);
   * };
   * ```
   * @param  ctx - An object containing symbol info along with some useful methods to load/store symbol
   * @param  {<TextendsStudyInputValue>(index:number} inputs - The inputs callback is an array of input values, placed in order of inputs in Metainfo.
   */
  init?(
    ctx: IContext,
    inputs: <T extends StudyInputValue>(index: number) => T
  ): void;
  /**
   * Called every time the library wants to calculate the study. Also it's called for every bar of every symbol.
   * Thus, if you request several additional symbols inside your indicator it will increase the count of runs.
   * @param  ctx - An object containing symbol info along with some useful methods to load/store symbol
   * @param  {<TextendsStudyInputValue>(index:number} inputs - The inputs callback is an array of input values, placed in order of inputs in Metainfo.
   */
  main(
    ctx: IContext,
    inputs: <T extends StudyInputValue>(index: number) => T
  ): TPineStudyResult | null;
  // Indicator defined properties
  // tslint:disable-next-line:no-any
  [key: string]: any;
}
export interface LibraryPineStudyConstructor<TPineStudyResult> {
  /**
   * Custom Study constructor
   */

  new (): LibraryPineStudy<TPineStudyResult>;
}
export interface LibrarySubsessionInfo {
  /**
   * Description of the subsession.
   *
   * @example "Regular Trading Hours"
   */
  description: string;
  /**
   * Subsession ID.
   */
  id: LibrarySessionId;
  /**
   * Session string. See {@link LibrarySymbolInfo.session}.
   */
  session: string;
  /**
   * Session corrections string. See {@link LibrarySymbolInfo.corrections}.
   */
  "session-correction"?: string;
  /**
   * Session to display. See {@link LibrarySymbolInfo.session_display}.
   */
  "session-display"?: string;
}
export interface LibrarySymbolInfo {
  /**
   * It is a symbol name within an exchange, such as `AAPL` or `9988` (Hong Kong).
   * Note that it should not contain the exchange name.
   * This symbol name is visible to users and can be repeated.
   *
   * By default, `name` is used to resolve symbols in the [Datafeed API](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Datafeed-API.md).
   * If you use {@link LibrarySymbolInfo.ticker}, the library will use the ticker for Datafeed API requests.
   */
  name: string;
  /**
   * Array of base symbols
   * Example: for `AAPL*MSFT` it is `['NASDAQ:AAPL', 'NASDAQ:MSFT']`
   */
  base_name?: [string];
  /**
   * It is an unique identifier for a particular symbol in your [symbology](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Symbology.md).
   * If you specify this property, its value will be used for all data requests for this symbol.
   * `ticker` will be treated the same as {@link LibrarySymbolInfo.name} if not specified explicitly.
   * Note that it should not contain the exchange name.
   */
  ticker?: string;
  /**
   * The description of the symbol.
   * Will be displayed in the chart legend for this symbol.
   */
  description: string;
  /**
   * Symbol Long description
   *
   * Optional long(er) description for the symbol.
   */
  long_description?: string;
  /**
   * Type of the instrument.
   * Possible values: {@link SymbolType}
   */
  type: string;
  /**
   * Trading hours for this symbol. See the [Trading sessions](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Trading-Sessions.md) article to learn more details.
   * @example "1700-0200"
   */
  session: string;
  /**
   * The session value to display in the UI. If not specified, then `session` is used.
   */
  session_display?: string;
  /**
   * A string that contains a list of non-trading holidays for the symbol.
   * Holiday dates should be in the `YYYYMMDD` format.
   * These dates are not displayed on the chart.
   *
   * You can specify a correction for a holiday using {@link LibrarySymbolInfo.corrections}.
   * @example "20181105,20181107,20181112"
   */
  session_holidays?: string;
  /**
   * List of corrections for a symbol. The corrections are days when the trading session differs from the default one set in {@link LibrarySymbolInfo.session}.
   * The `corrections` value is a string in the following format: `SESSION:YYYYMMDD`.
   * For more information, refer to [corrections](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Symbology.md#corrections).
   *
   * The string below specifies corrections for two trading days:
   *
   * - November 13, 2018. This trading day is split into two sessions. The first session starts at 19:00 four days before (November 9, 2018) and ends at 23:50 four days before. The second session starts at 10:00 and ends at 18:45.
   * - November 14, 2018. The session starts at 10:00 and ends at 14:00.
   *
   * @example "1900F4-2350F4,1000-1845:20181113;1000-1400:20181114"
   */
  corrections?: string;
  /**
   * Traded exchange (current (proxy) exchange).
   * The name will be displayed in the chart legend for this symbol.
   *
   * @example "NYSE"
   */
  exchange: string;
  /**
   * short name of the exchange where this symbol is traded (real listed exchange).
   * The name will be displayed in the chart legend for this symbol.
   *
   * @example "NYSE"
   */
  listed_exchange: string;
  /**
   * Time zone of the exchange for this symbol. We expect to get the name of the time zone in `olsondb` format.
   * See [Time zones](https://www.tradingview.com/charting-library-docs/latest/ui_elements/timezones.md) for a full list of supported time zones.
   */
  timezone: Timezone;
  /**
   * Format of displaying labels on the price scale:
   *
   * `price` - formats decimal or fractional numbers based on `minmov`, `pricescale`, `minmove2`, `fractional` and `variableMinTick` values. See [Price Formatting](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Symbology#price-format) for more details
   * `volume` - formats decimal numbers in thousands, millions, billions or trillions
   */
  format: SeriesFormat;
  /**
   * Code (Tick)
   * @example 8/16/.../256 (1/8/100 1/16/100 ... 1/256/100) or 1/10/.../10000000 (1 0.1 ... 0.0000001)
   */
  pricescale: number;
  /**
   * The number of units that make up one tick.
   * @example For example, U.S. equities are quotes in decimals, and tick in decimals, and can go up +/- .01. So the tick increment is 1. But the e-mini S&P futures contract, though quoted in decimals, goes up in .25 increments, so the tick increment is 25. (see also Tick Size)
   */
  minmov: number;
  /**
   * For common prices this can be skipped.
   *
   * Fractional prices are displayed 2 different forms: 1) `xx'yy` (for example, `133'21`) 2) `xx'yy'zz` (for example, `133'21'5`).
   *
   * - `xx` is an integer part.
   * - `minmov/pricescale` is a Fraction.
   * - `minmove2` is used in form 2.
   * - `fractional` is `true`.
   * - `variableMinTick` is skipped.
   *
   * Example:
   *
   * If `minmov = 1`, `pricescale = 128` and `minmove2 = 4`:
   *
   * - `119'16'0` represents `119 + 16/32`
   * - `119'16'2` represents `119 + 16.25/32`
   * - `119'16'5` represents `119 + 16.5/32`
   * - `119'16'7` represents `119 + 16.75/32`
   *
   * More examples:
   *
   * - `ZBM2014 (T-Bond)` with `1/32`: `minmov = 1`, `pricescale = 32`, `minmove2 = 0`
   * - `ZCM2014 (Corn)` with `2/8`: `minmov = 2`, `pricescale = 8`, `minmove2 = 0`
   * - `ZFM2014 (5 year t-note)` with `1/4 of 1/32`: `minmov = 1`, `pricescale = 128`, `minmove2 = 4`
   */
  fractional?: boolean;
  /**
   * For common prices this can be skipped.
   * @example Quarters of 1/32: pricescale=128, minmovement=1, minmovement2=4
   */
  minmove2?: number;
  /**
   * Dynamic minimum price movement. It is used if the instrument's minimum price movement changes depending on the price range.
   *
   * For example, '0.01 10 0.02 25 0.05', where the tick size is 0.01 for a price less than 10, the tick size is 0.02 for a price less than 25, the tick size is 0.05 for a price greater than or equal to 25.
   */
  variable_tick_size?: string;
  /**
   * Boolean value showing whether the symbol includes intraday (minutes) historical data.
   *
   * If it's `false` then all buttons for intraday resolutions will be disabled for this particular symbol.
   * If it is set to `true`, all intradays resolutions that are supplied directly by the datafeed must be provided in `intraday_multipliers` array.
   *
   * **WARNING** Any daily, weekly or monthly resolutions cannot be inferred from intraday resolutions!
   *
   * `false` if DWM only
   * @default false
   */
  has_intraday?: boolean;
  /**
   * An array of [resolutions](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution.md) which should be enabled in the _Resolution_ drop-down menu for this symbol.
   * Each item of the array is expected to be a string that has a specific [format](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution.md#resolution-format).
   *
   * If one changes the symbol and the new symbol does not support the selected resolution, the resolution will be switched to the first available one in the list.
   *
   * **Resolution availability logic (pseudocode):**
   * ```
   * resolutionAvailable  =
   *     resolution.isIntraday
   *         ? symbol.has_intraday && symbol.supported_resolutions(resolution)
   *         : symbol.supported_resolutions(resolution);
   * ```
   *
   * If `supported_resolutions` is `[]` (empty array), all resolutions are disabled in the _Resolution_ drop-down menu.
   *
   * If `supported_resolutions` is `undefined`, all resolutions that the chart support ({@link DatafeedConfiguration.supported_resolutions}) and custom resolutions are enabled.
   *
   * Note that the list of available time frames depends on supported resolutions.
   * Time frames that require resolutions that are unavailable for a particular symbol will be hidden.
   * Refer to [Time frame toolbar](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Time-Scale.md#time-frame-toolbar) for more information.
   */
  supported_resolutions?: ResolutionString[];
  /**
   * Array of resolutions (in minutes) supported directly by the data feed. Each such resolution may be passed to, and should be implemented by, `getBars`. The default of [] means that the data feed supports aggregating by any number of minutes.
   *
   * If the data feed only supports certain minute resolutions but not the requested resolution, `getBars` will be called (repeatedly if needed) with a higher resolution as a parameter, in order to build the requested resolution.
   *
   * For example, if the data feed only supports minute resolution, set `intraday_multipliers` to `['1']`.
   *
   * When the user wants to see 5-minute data, `getBars` will be called with the resolution set to 1 until the library builds all the 5-minute resolution by itself.
   * @example (for ex.: "1,5,60") - only these resolutions will be requested, all others will be built using them if possible
   * @default []
   */
  intraday_multipliers?: string[];
  /**
   * Boolean value showing whether the symbol includes seconds in the historical data.
   *
   * If it's `false` then all buttons for resolutions that include seconds will be disabled for this particular symbol.
   *
   * If it is set to `true`, all resolutions that are supplied directly by the data feed must be provided in `seconds_multipliers` array.
   * @default false
   */
  has_seconds?: boolean;
  /**
   * Boolean value showing whether the symbol includes ticks in the historical data.
   *
   * If it's `false` then all buttons for resolutions that include ticks will be disabled for this particular symbol.
   * @default false
   */
  has_ticks?: boolean;
  /**
   * It is an array containing resolutions that include seconds (excluding postfix) that the data feed provides.
   * E.g., if the data feed supports resolutions such as `["1S", "5S", "15S"]`, but has 1-second bars for some symbols then you should set `seconds_multipliers` of this symbol to `[1]`.
   * This will make the library build 5S and 15S resolutions by itself.
   */
  seconds_multipliers?: string[];
  /**
   * The boolean value specifying whether the datafeed can supply historical data at the daily resolution.
   *
   * If `has_daily` is set to `false`, all buttons for resolutions that include days are disabled for this particular symbol.
   * Otherwise, the library requests daily bars from the datafeed.
   * All daily resolutions that the datafeed supplies must be included in the {@link LibrarySymbolInfo.daily_multipliers} array.
   *
   * @default true
   */
  has_daily?: boolean;
  /**
   * Array (of strings) containing the [resolutions](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution.md#resolution-format) (in days - without the suffix) supported by the datafeed. {@link ResolutionString}
   *
   * For example it could be something like
   *
   * ```javascript
   * daily_multipliers = ['1', '3', '4', '6', '7'];
   * ```
   * @default ['1']
   */
  daily_multipliers?: string[];
  /**
   * The boolean value showing whether data feed has its own weekly and monthly resolution bars or not.
   *
   * If `has_weekly_and_monthly` = `false` then the library will build the respective resolutions using daily bars by itself.
   * If not, then it will request those bars from the data feed using either the `weekly_multipliers` or `monthly_multipliers` if specified.
   * If resolution is not within either list an error will be raised.
   * @default false
   */
  has_weekly_and_monthly?: boolean;
  /**
   * Array (of strings) containing the [resolutions](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution#weeks) (in weeks - without the suffix) supported by the data feed. {@link ResolutionString}
   *
   * For example it could be something like
   *
   * ```javascript
   * weekly_multipliers = ['1', '5', '10'];
   * ```
   * @default ['1']
   */
  weekly_multipliers?: string[];
  /**
   * Array (of strings) containing the [resolutions](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution#months) (in months - without the suffix) supported by the data feed. {@link ResolutionString}
   *
   * For example it could be something like
   *
   * ```javascript
   * monthly_multipliers = ['1', '3', '4', '12'];
   * ```
   * @default ['1']
   */
  monthly_multipliers?: string[];
  /**
   * The boolean value showing whether the library should generate empty bars in the session when there is no data from the data feed for this particular time.
   *
   * I.e., if your session is `0900-1600` and your data has gaps between `11:00` and `12:00` and your `has_empty_bars` is `true`, then the Library will fill the gaps with bars for this time.
   *
   * Flag `has_empty_bars` = `true` cannot be used if featureset `disable_resolution_rebuild` is enabled.
   * @default false
   */
  has_empty_bars?: boolean;
  /**
   * Represents what values are supported by the symbol. Possible values:
   *
   * - `ohlcv` - the symbol supports open, high, low, close and has volume
   * - `ohlc` - the symbol supports open, high, low, close, but doesn't have volume
   * - `c` - the symbol supports only close, it's displayed on the chart using line-based styles only
   * @default 'ohlcv'
   */
  visible_plots_set?: VisiblePlotsSet;
  /**
   * Integer showing typical volume value decimal places for a particular symbol.
   * 0 means volume is always an integer.
   * 1 means that there might be 1 numeric character after the comma.
   * @default '0'
   */
  volume_precision?: number;
  /**
   * The status code of a series with this symbol.
   * For `delayed_streaming` and `endofday` type of data, the status is displayed as an icon and the *Data is delayed* section in the [_Legend_](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Legend.md#display-delayed-data-information), next to the market status icon.
   * Note that you should also enable the [`display_data_mode`](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#display_data_mode) featureset.
   *
   * When declaring `delayed_streaming` you also have to specify its {@link LibrarySymbolInfo.delay} in seconds.
   */
  data_status?: "streaming" | "endofday" | "delayed_streaming";
  /**
   * Type of delay that is associated to the data or real delay for real time data.
   * - `0` for realtime
   * - `-1` for endofday
   * - or delay in seconds (for delayed realtime)
   */
  delay?: number;
  /**
   * Boolean showing whether this symbol is expired futures contract or not.
   * @default false
   */
  expired?: boolean;
  /**
   * Unix timestamp of the expiration date. One must set this value when `expired` = `true`.
   * The library will request data for this symbol starting from that time point.
   */
  expiration_date?: number;
  /** Sector for stocks to be displayed in the Symbol Info. */
  sector?: string;
  /** Industry for stocks to be displayed in the Symbol Info. */
  industry?: string;
  /**
   * The currency in which the instrument is traded or some other currency if currency conversion is enabled.
   * It is displayed in the Symbol Info dialog and on the price axes.
   */
  currency_code?: string;
  /** The currency in which the instrument is traded. */
  original_currency_code?: string;
  /**
   * A unique identifier of a unit in which the instrument is traded or some other identifier if unit conversion is enabled.
   * It is displayed on the price axes.
   */
  unit_id?: string;
  /**
   * A unique identifier of a unit in which the instrument is traded.
   */
  original_unit_id?: string;
  /**
   * Allowed unit conversion group names.
   */
  unit_conversion_types?: string[];
  /**
   * Subsession ID. Must match the `id` property of one of the subsessions.
   */
  subsession_id?: string;
  /**
   * Subsessions definitions.
   */
  subsessions?: LibrarySubsessionInfo[];
  /**
   * Optional ID of a price source for a symbol. Should match one of the price sources from the {@link price_sources} array.
   *
   * Note that you should set the [`symbol_info_price_source`](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#symbol_info_price_source) featureset to `true` to display the symbol price source in the main series legend.
   */
  price_source_id?: string;
  /**
   * Supported price sources for the symbol.
   * Price sources appear in the series legend and indicate the origin of values represented by symbol bars.
   * Example price sources: "Spot Price", "Ask", "Bid", etc.
   * The price source information is valuable when viewing non-OHLC series types.
   *
   * Note that you should set the [`symbol_info_price_source`](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md#symbol_info_price_source) featureset to `true` to display the symbol price source in the main series legend.
   * @example [{ id: '1', name: 'Spot Price' }, { id: '321', name: 'Bid' }]
   */
  price_sources?: SymbolInfoPriceSource[];
  /**
   * URL of image/s to be displayed as the logo/s for the symbol. The `show_symbol_logos` featureset needs to be enabled for this to be visible in the UI.
   *
   * - If a single url is returned then that url will solely be used to display the symbol logo.
   * - If two urls are provided then the images will be displayed as two partially overlapping
   * circles with the first url appearing on top. This is typically used for FOREX where you would
   * like to display two country flags are the symbol logo.
   *
   * The image/s should ideally be square in dimension. You can use any image type which
   * the browser supports natively.
   *
   * Examples:
   * - `https://yourserver.com/apple.svg`
   * - `/images/myImage.png`
   * - `data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3...`
   * - `data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAASABIAAD/4...`
   */
  logo_urls?: [string] | [string, string];
  /**
   * URL of image to be displayed as the logo for the exchange. The `show_exchange_logos` featureset needs to be enabled for this to be visible in the UI.
   *
   * The image should ideally be square in dimension. You can use any image type which
   * the browser supports natively. Simple SVG images are recommended.
   *
   * Examples:
   * - `https://yourserver.com/exchangeLogo.svg`
   * - `/images/myImage.png`
   * - `data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3...`
   * - `data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAASABIAAD/4...`
   */
  exchange_logo?: string;
}
export interface LineBreakStylePreferences {
  /** Up bar color */
  upColor: string;
  /** Down bar color */
  downColor: string;
  /** Up bar border color */
  borderUpColor: string;
  /** Down bar border color */
  borderDownColor: string;
  /** Projection up bar color */
  upColorProjection: string;
  /** Projection down bar color */
  downColorProjection: string;
  /** Projection up bar border color */
  borderUpColorProjection: string;
  /** Projection down bar border color */
  borderDownColorProjection: string;
}
export interface LineStylePreferences {
  /** Line color */
  color: string;
  /** Line Style {@link LineStyle} */
  linestyle: number;
  /** Line width */
  linewidth: number;
}
/**
 * Represents the state of a Drawing
 */
export interface LineToolState {
  /** The entity ID of the drawing */
  id: EntityId;
  /** The associated symbol ID for the drawing */
  symbol?: string;
  /** The source ID of the object's owner */
  ownerSource: string;
  /** The ID of the group to which drawing belongs */
  groupId?: string;
  /** The associated symbol's currency ID */
  currencyId?: string | null;
  /** The associated symbol's unit ID */
  unitId?: string | null;
  /** The current state object of the drawing */
  state: unknown;
}
/**
 * Additional information for the {@link IExternalSaveLoadAdapter.loadLineToolsAndGroups} request.
 */
export interface LineToolsAndGroupsLoadRequestContext {
  /** The name / identifier of the symbol displayed as the main series on the chart. */
  symbol?: string;
}
/**
 * Represents the state of drawings and groups
 */
export interface LineToolsAndGroupsState {
  /** A map of sources to drawing states */
  sources: Map<EntityId, LineToolState | null> | null;
  /** A map of group IDs to drawings group states */
  groups: Map<string, LineToolsGroupState | null>;
  /** The symbol ID associated with the drawings and groups */
  symbol?: string;
}
/**
 * Represents the state of a group of LineTools
 */
export interface LineToolsGroupState {
  /** The ID of the drawings group */
  id: string;
  /** The name of the drawings group */
  name: string;
  /** The symbol associated with the drawings group */
  symbol: string;
  /** The associated symbol's currency ID */
  currencyId?: string | null;
  /** The associated symbol's unit ID */
  unitId?: string | null;
}
/**
 * Overrides for the 'Linear Regression Curve' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface LinearRegressionCurveIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Linear Regression Slope' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface LinearRegressionSlopeIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF5252` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Color styling options for the loading screen (spinner)
 */
export interface LoadingScreenOptions {
  /** Colour of the spinner on the loading screen */
  foregroundColor?: string;
  /** Background color for the loading screen */
  backgroundColor?: string;
}
/**
 * Overrides for the 'MACD' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MACDIndicatorOverrides {
  /** Default value: `15` */
  "histogram.display": number;
  /** Default value: `0` */
  "histogram.linestyle": number;
  /** Default value: `1` */
  "histogram.linewidth": number;
  /** Default value: `columns` */
  "histogram.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "histogram.trackprice": boolean;
  /** Default value: `0` */
  "histogram.transparency": number;
  /** Default value: `#FF5252` */
  "histogram.color": string;
  /** Default value: `15` */
  "macd.display": number;
  /** Default value: `0` */
  "macd.linestyle": number;
  /** Default value: `1` */
  "macd.linewidth": number;
  /** Default value: `line` */
  "macd.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "macd.trackprice": boolean;
  /** Default value: `0` */
  "macd.transparency": number;
  /** Default value: `#2196F3` */
  "macd.color": string;
  /** Default value: `15` */
  "signal.display": number;
  /** Default value: `0` */
  "signal.linestyle": number;
  /** Default value: `1` */
  "signal.linewidth": number;
  /** Default value: `line` */
  "signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "signal.trackprice": boolean;
  /** Default value: `0` */
  "signal.transparency": number;
  /** Default value: `#FF6D00` */
  "signal.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'MA Cross' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MACrossIndicatorOverrides {
  /** Default value: `15` */
  "short:plot.display": number;
  /** Default value: `0` */
  "short:plot.linestyle": number;
  /** Default value: `1` */
  "short:plot.linewidth": number;
  /** Default value: `line` */
  "short:plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "short:plot.trackprice": boolean;
  /** Default value: `0` */
  "short:plot.transparency": number;
  /** Default value: `#43A047` */
  "short:plot.color": string;
  /** Default value: `15` */
  "long:plot.display": number;
  /** Default value: `0` */
  "long:plot.linestyle": number;
  /** Default value: `1` */
  "long:plot.linewidth": number;
  /** Default value: `line` */
  "long:plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "long:plot.trackprice": boolean;
  /** Default value: `0` */
  "long:plot.transparency": number;
  /** Default value: `#FF6D00` */
  "long:plot.color": string;
  /** Default value: `15` */
  "crosses.display": number;
  /** Default value: `0` */
  "crosses.linestyle": number;
  /** Default value: `4` */
  "crosses.linewidth": number;
  /** Default value: `cross` */
  "crosses.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "crosses.trackprice": boolean;
  /** Default value: `0` */
  "crosses.transparency": number;
  /** Default value: `#2196F3` */
  "crosses.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'MA with EMA Cross' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MAwithEMACrossIndicatorOverrides {
  /** Default value: `15` */
  "ma.display": number;
  /** Default value: `0` */
  "ma.linestyle": number;
  /** Default value: `1` */
  "ma.linewidth": number;
  /** Default value: `line` */
  "ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ma.trackprice": boolean;
  /** Default value: `0` */
  "ma.transparency": number;
  /** Default value: `#FF6D00` */
  "ma.color": string;
  /** Default value: `15` */
  "ema.display": number;
  /** Default value: `0` */
  "ema.linestyle": number;
  /** Default value: `1` */
  "ema.linewidth": number;
  /** Default value: `line` */
  "ema.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ema.trackprice": boolean;
  /** Default value: `0` */
  "ema.transparency": number;
  /** Default value: `#43A047` */
  "ema.color": string;
  /** Default value: `15` */
  "crosses.display": number;
  /** Default value: `0` */
  "crosses.linestyle": number;
  /** Default value: `4` */
  "crosses.linewidth": number;
  /** Default value: `cross` */
  "crosses.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "crosses.trackprice": boolean;
  /** Default value: `0` */
  "crosses.transparency": number;
  /** Default value: `#2196F3` */
  "crosses.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Majority Rule' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MajorityRuleIndicatorOverrides {
  /** Default value: `15` */
  "majority rule.display": number;
  /** Default value: `0` */
  "majority rule.linestyle": number;
  /** Default value: `1` */
  "majority rule.linewidth": number;
  /** Default value: `line` */
  "majority rule.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "majority rule.trackprice": boolean;
  /** Default value: `0` */
  "majority rule.transparency": number;
  /** Default value: `#FF5252` */
  "majority rule.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface MappedObject<TValue> {
  [key: string]: TValue | undefined;
}
export interface Mark {
  /** ID of the mark */
  id: string | number;
  /**
   * Time for the mark.
   * Unix timestamp in seconds.
   */
  time: number;
  /** Color for the mark */
  color: MarkConstColors | MarkCustomColor;
  /** Text content for the mark */
  text: string;
  /** Label for the mark */
  label: string;
  /** Text color for the mark */
  labelFontColor: string;
  /** Minimum size for the mark */
  minSize: number;
  /** Border Width */
  borderWidth?: number;
  /** Border Width when hovering over bar mark */
  hoveredBorderWidth?: number;
  /**
   * Optional URL for an image to be displayed within the timescale mark.
   *
   * The image should ideally be square in dimension. You can use any image type which
   * the browser supports natively.
   *
   * Examples:
   * - `https://yourserver.com/adobe.svg`
   * - `/images/myImage.png`
   * - `data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3...`
   * - `data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAASABIAAD/4...`
   */
  imageUrl?: string;
  /**
   * Continue to show text label even when an image has
   * been loaded for the timescale mark.
   *
   * Defaults to `false` if undefined.
   */
  showLabelWhenImageLoaded?: boolean;
}
export interface MarkCustomColor {
  /** Border color */
  border: string;
  /** Background color */
  background: string;
}
/**
 * Overrides for the 'Mass Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MassIndexIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'McGinley Dynamic' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface McGinleyDynamicIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Median Price' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MedianPriceIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF6D00` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/** Separator for a dropdown or context menu */
export interface MenuSeparator extends ActionDescription {
  /** Is a menu separator */
  separator: boolean;
}
/**
 * Overrides for the 'Momentum' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MomentumIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "mom.display": number;
  /** Default value: `0` */
  "mom.linestyle": number;
  /** Default value: `1` */
  "mom.linewidth": number;
  /** Default value: `line` */
  "mom.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "mom.trackprice": boolean;
  /** Default value: `0` */
  "mom.transparency": number;
  /** Default value: `#2196F3` */
  "mom.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Money Flow Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MoneyFlowIndexIndicatorOverrides {
  /** Default value: `#7E57C2` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `80` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `20` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#7E57C2` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface MouseEventParams {
  /** X (horizontal) coordinate (in pixels) at which the mouse event occurred, relative to the left edge of the applications viewport. */
  clientX: number;
  /** Y (vertical) coordinate (in pixels) at which the mouse event occurred, relative to the left edge of the applications viewport. */
  clientY: number;
  /** X (horizontal) coordinate (in pixels) at which the mouse event occurred, relative to the left edge of the entire document. */
  pageX: number;
  /** Y (vertical) coordinate (in pixels) at which the mouse event occurred, relative to the left edge of the entire document. */
  pageY: number;
  /** X (horizontal) coordinate (in pixels) at which the mouse event occurred, in global screen coordinates. */
  screenX: number;
  /** Y (vertical) coordinate (in pixels) at which the mouse event occurred, in global screen coordinates. */
  screenY: number;
}
/**
 * Overrides for the 'Moving Average Adaptive' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageAdaptiveIndicatorOverrides {
  /** Default value: `15` */
  "plot 1.display": number;
  /** Default value: `0` */
  "plot 1.linestyle": number;
  /** Default value: `1` */
  "plot 1.linewidth": number;
  /** Default value: `line` */
  "plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "plot 1.transparency": number;
  /** Default value: `false` */
  "plot 1.trackprice": boolean;
  /** Default value: `#AB47BC` */
  "plot 1.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Moving Average Channel' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageChannelIndicatorOverrides {
  /** Default value: `#2196F3` */
  "plots background.color": string;
  /** Default value: `90` */
  "plots background.transparency": number;
  /** Default value: `true` */
  "plots background.visible": boolean;
  /** Default value: `15` */
  "upper.display": number;
  /** Default value: `0` */
  "upper.linestyle": number;
  /** Default value: `1` */
  "upper.linewidth": number;
  /** Default value: `line` */
  "upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "upper.trackprice": boolean;
  /** Default value: `0` */
  "upper.transparency": number;
  /** Default value: `#2196F3` */
  "upper.color": string;
  /** Default value: `15` */
  "lower.display": number;
  /** Default value: `0` */
  "lower.linestyle": number;
  /** Default value: `1` */
  "lower.linewidth": number;
  /** Default value: `line` */
  "lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lower.trackprice": boolean;
  /** Default value: `0` */
  "lower.transparency": number;
  /** Default value: `#FF6D00` */
  "lower.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Moving Average Double' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageDoubleIndicatorOverrides {
  /** Default value: `15` */
  "plot 1.display": number;
  /** Default value: `0` */
  "plot 1.linestyle": number;
  /** Default value: `1` */
  "plot 1.linewidth": number;
  /** Default value: `line` */
  "plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 1.trackprice": boolean;
  /** Default value: `0` */
  "plot 1.transparency": number;
  /** Default value: `#FF6D00` */
  "plot 1.color": string;
  /** Default value: `15` */
  "plot 2.display": number;
  /** Default value: `0` */
  "plot 2.linestyle": number;
  /** Default value: `1` */
  "plot 2.linewidth": number;
  /** Default value: `line` */
  "plot 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 2.trackprice": boolean;
  /** Default value: `0` */
  "plot 2.transparency": number;
  /** Default value: `#2196F3` */
  "plot 2.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Moving Average Exponential' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageExponentialIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  /** Default value: `0` */
  "smoothed ma.display": number;
  /** Default value: `0` */
  "smoothed ma.linestyle": number;
  /** Default value: `1` */
  "smoothed ma.linewidth": number;
  /** Default value: `line` */
  "smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "smoothed ma.transparency": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Moving Average Hamming' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageHammingIndicatorOverrides {
  /** Default value: `15` */
  "plot 1.display": number;
  /** Default value: `0` */
  "plot 1.linestyle": number;
  /** Default value: `1` */
  "plot 1.linewidth": number;
  /** Default value: `line` */
  "plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "plot 1.transparency": number;
  /** Default value: `false` */
  "plot 1.trackprice": boolean;
  /** Default value: `#4CAF50` */
  "plot 1.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Moving Average' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  /** Default value: `0` */
  "smoothed ma.display": number;
  /** Default value: `0` */
  "smoothed ma.linestyle": number;
  /** Default value: `1` */
  "smoothed ma.linewidth": number;
  /** Default value: `line` */
  "smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "smoothed ma.transparency": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Moving Average Multiple' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageMultipleIndicatorOverrides {
  /** Default value: `15` */
  "plot 1.display": number;
  /** Default value: `0` */
  "plot 1.linestyle": number;
  /** Default value: `1` */
  "plot 1.linewidth": number;
  /** Default value: `line` */
  "plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "plot 1.transparency": number;
  /** Default value: `false` */
  "plot 1.trackprice": boolean;
  /** Default value: `#9C27B0` */
  "plot 1.color": string;
  /** Default value: `15` */
  "plot 2.display": number;
  /** Default value: `0` */
  "plot 2.linestyle": number;
  /** Default value: `1` */
  "plot 2.linewidth": number;
  /** Default value: `0` */
  "plot 2.transparency": number;
  /** Default value: `line` */
  "plot 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 2.trackprice": boolean;
  /** Default value: `#FF6D00` */
  "plot 2.color": string;
  /** Default value: `15` */
  "plot 3.display": number;
  /** Default value: `0` */
  "plot 3.linestyle": number;
  /** Default value: `1` */
  "plot 3.linewidth": number;
  /** Default value: `0` */
  "plot 3.transparency": number;
  /** Default value: `line` */
  "plot 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 3.trackprice": boolean;
  /** Default value: `#43A047` */
  "plot 3.color": string;
  /** Default value: `15` */
  "plot 4.display": number;
  /** Default value: `0` */
  "plot 4.linestyle": number;
  /** Default value: `1` */
  "plot 4.linewidth": number;
  /** Default value: `0` */
  "plot 4.transparency": number;
  /** Default value: `line` */
  "plot 4.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 4.trackprice": boolean;
  /** Default value: `#26C6DA` */
  "plot 4.color": string;
  /** Default value: `15` */
  "plot 5.display": number;
  /** Default value: `0` */
  "plot 5.linestyle": number;
  /** Default value: `1` */
  "plot 5.linewidth": number;
  /** Default value: `0` */
  "plot 5.transparency": number;
  /** Default value: `line` */
  "plot 5.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 5.trackprice": boolean;
  /** Default value: `#F50057` */
  "plot 5.color": string;
  /** Default value: `15` */
  "plot 6.display": number;
  /** Default value: `0` */
  "plot 6.linestyle": number;
  /** Default value: `1` */
  "plot 6.linewidth": number;
  /** Default value: `0` */
  "plot 6.transparency": number;
  /** Default value: `line` */
  "plot 6.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 6.trackprice": boolean;
  /** Default value: `#2196F3` */
  "plot 6.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Moving Average Triple' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageTripleIndicatorOverrides {
  /** Default value: `15` */
  "plot 1.display": number;
  /** Default value: `0` */
  "plot 1.linestyle": number;
  /** Default value: `1` */
  "plot 1.linewidth": number;
  /** Default value: `line` */
  "plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "plot 1.transparency": number;
  /** Default value: `false` */
  "plot 1.trackprice": boolean;
  /** Default value: `#FF6D00` */
  "plot 1.color": string;
  /** Default value: `15` */
  "plot 2.display": number;
  /** Default value: `0` */
  "plot 2.linestyle": number;
  /** Default value: `1` */
  "plot 2.linewidth": number;
  /** Default value: `0` */
  "plot 2.transparency": number;
  /** Default value: `line` */
  "plot 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 2.trackprice": boolean;
  /** Default value: `#2196F3` */
  "plot 2.color": string;
  /** Default value: `15` */
  "plot 3.display": number;
  /** Default value: `0` */
  "plot 3.linestyle": number;
  /** Default value: `1` */
  "plot 3.linewidth": number;
  /** Default value: `0` */
  "plot 3.transparency": number;
  /** Default value: `line` */
  "plot 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 3.trackprice": boolean;
  /** Default value: `#26C6DA` */
  "plot 3.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Moving Average Weighted' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface MovingAverageWeightedIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface NegativeBaseInputFieldValidatorResult
  extends BaseInputFieldValidatorResult {
  /** @inheritDoc */
  valid: false;
  /** Reason why base input value is invalid  */
  errorMessage: string;
}
/**
 * Overrides for the 'Net Volume' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface NetVolumeIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface NewsItem {
  /** News item title */
  title: string;
  /** Source of the news item */
  source: string;
  /** Published date */
  published: number;
  /** Link to the news item */
  link?: string;
  /** Short description */
  shortDescription?: string;
  /** Full description */
  fullDescription?: string;
}
/**
 * Override properties for the Note drawing tool.
 */
export interface NoteLineToolOverrides {
  /** Default value: `rgba(41, 98, 255, 0.7)` */
  "linetoolnote.backgroundColor": string;
  /** Default value: `0` */
  "linetoolnote.backgroundTransparency": number;
  /** Default value: `false` */
  "linetoolnote.bold": boolean;
  /** Default value: `#2962FF` */
  "linetoolnote.borderColor": string;
  /** Default value: `true` */
  "linetoolnote.fixedSize": boolean;
  /** Default value: `14` */
  "linetoolnote.fontSize": number;
  /** Default value: `false` */
  "linetoolnote.italic": boolean;
  /** Default value: `#2962FF` */
  "linetoolnote.markerColor": string;
  /** Default value: `#ffffff` */
  "linetoolnote.textColor": string;
}
/**
 * Override properties for the Noteabsolute drawing tool.
 */
export interface NoteabsoluteLineToolOverrides {
  /** Default value: `rgba(41, 98, 255, 0.7)` */
  "linetoolnoteabsolute.backgroundColor": string;
  /** Default value: `0` */
  "linetoolnoteabsolute.backgroundTransparency": number;
  /** Default value: `false` */
  "linetoolnoteabsolute.bold": boolean;
  /** Default value: `#2962FF` */
  "linetoolnoteabsolute.borderColor": string;
  /** Default value: `true` */
  "linetoolnoteabsolute.fixedSize": boolean;
  /** Default value: `14` */
  "linetoolnoteabsolute.fontSize": number;
  /** Default value: `false` */
  "linetoolnoteabsolute.italic": boolean;
  /** Default value: `#2962FF` */
  "linetoolnoteabsolute.markerColor": string;
  /** Default value: `#ffffff` */
  "linetoolnoteabsolute.textColor": string;
}
/**
 * Formatting options for numbers
 */
export interface NumericFormattingParams {
  /**
   * String that would represent the decimal part of a number
   * @example 123.4 or 123,4 or 123'4
   */
  decimal_sign: string;
}
/**
 * Overrides for the 'On Balance Volume' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface OnBalanceVolumeIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  /** Default value: `0` */
  "smoothed ma.display": number;
  /** Default value: `0` */
  "smoothed ma.linestyle": number;
  /** Default value: `1` */
  "smoothed ma.linewidth": number;
  /** Default value: `line` */
  "smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "smoothed ma.transparency": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Interface for an URL which will be opened
 */
export interface OpenUrlSolution {
  /**
   * Link to be opened
   */
  openUrl: {
    /** URL to be opened */
    url: string;
    /** text for solution button */
    text: string;
  };
}
export interface OrderDialogOptions extends TradingDialogOptions {
  /**
   * Using this flag, you can change `Trade Value` to `Total` in the *Order Info* section of the [Order Ticket](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/order-ticket.md).
   */
  showTotal?: boolean;
}
export interface OrderDuration {
  /**
   * type is OrderDurationMetaInfo.value
   */
  type: string;
  /** Order duration time */
  datetime?: number;
}
/**
 * Order duration options that determine how long the order remains active.
 * Refer to [Set order duration](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/order-ticket.md#set-order-duration) for more information.
 */
export interface OrderDurationMetaInfo {
  /** If it is set to `true`, then the Display date control in Order Ticket for this duration type will be displayed. */
  hasDatePicker?: boolean;
  /** If it is set to `true`, then the Display time control in Order Ticket for this duration type will be displayed. */
  hasTimePicker?: boolean;
  /**
   * Default duration.
   * Only one duration object in the durations array can have a `true` value for this field.
   * The default duration will be used when the user places orders in the silent mode and it will be the selected one when the user opens Order Ticket for the first time.
   */
  default?: boolean;
  /** Localized title of the duration. The title will be displayed in the Duration control of Order Ticket. */
  name: string;
  /** Duration identifier */
  value: string;
  /** A list of order types for which this duration type will be displayed in the Duration control of Order Ticket. Default value is `[OrderType.Limit, OrderType.Stop, OrderType.StopLimit]`. */
  supportedOrderTypes?: OrderType[];
}
/**
 * Override properties for the Order drawing tool.
 */
export interface OrderLineToolOverrides {
  /** Default value: `rgba(255, 255, 255, 0.25)` */
  "linetoolorder.bodyBackgroundColor": string;
  /** Default value: `25` */
  "linetoolorder.bodyBackgroundTransparency": number;
  /** Default value: `#4094e8` */
  "linetoolorder.bodyBorderActiveBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolorder.bodyBorderActiveSellColor": string;
  /** Default value: `rgba(64, 148, 232, 0.5)` */
  "linetoolorder.bodyBorderInactiveBuyColor": string;
  /** Default value: `rgba(231, 86, 86, 0.5)` */
  "linetoolorder.bodyBorderInactiveSellColor": string;
  /** Default value: `true` */
  "linetoolorder.bodyFontBold": boolean;
  /** Default value: `Verdana` */
  "linetoolorder.bodyFontFamily": string;
  /** Default value: `false` */
  "linetoolorder.bodyFontItalic": boolean;
  /** Default value: `9` */
  "linetoolorder.bodyFontSize": number;
  /** Default value: `#4094e8` */
  "linetoolorder.bodyTextActiveBuyColor": string;
  /** Default value: `#268c02` */
  "linetoolorder.bodyTextActiveLimitColor": string;
  /** Default value: `#e75656` */
  "linetoolorder.bodyTextActiveSellColor": string;
  /** Default value: `#e75656` */
  "linetoolorder.bodyTextActiveStopColor": string;
  /** Default value: `rgba(64, 148, 232, 0.5)` */
  "linetoolorder.bodyTextInactiveBuyColor": string;
  /** Default value: `rgba(38, 140, 2, 0.5)` */
  "linetoolorder.bodyTextInactiveLimitColor": string;
  /** Default value: `rgba(231, 86, 86, 0.5)` */
  "linetoolorder.bodyTextInactiveSellColor": string;
  /** Default value: `rgba(231, 86, 86, 0.5)` */
  "linetoolorder.bodyTextInactiveStopColor": string;
  /** Default value: `rgba(255, 255, 255, 0.25)` */
  "linetoolorder.cancelButtonBackgroundColor": string;
  /** Default value: `25` */
  "linetoolorder.cancelButtonBackgroundTransparency": number;
  /** Default value: `#4094e8` */
  "linetoolorder.cancelButtonBorderActiveBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolorder.cancelButtonBorderActiveSellColor": string;
  /** Default value: `rgba(64, 148, 232, 0.5)` */
  "linetoolorder.cancelButtonBorderInactiveBuyColor": string;
  /** Default value: `rgba(231, 86, 86, 0.5)` */
  "linetoolorder.cancelButtonBorderInactiveSellColor": string;
  /** Default value: `#4094e8` */
  "linetoolorder.cancelButtonIconActiveBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolorder.cancelButtonIconActiveSellColor": string;
  /** Default value: `rgba(64, 148, 232, 0.5)` */
  "linetoolorder.cancelButtonIconInactiveBuyColor": string;
  /** Default value: `rgba(231, 86, 86, 0.5)` */
  "linetoolorder.cancelButtonIconInactiveSellColor": string;
  /** Default value: `` */
  "linetoolorder.cancelTooltip": string;
  /** Default value: `inherit` */
  "linetoolorder.extendLeft": string;
  /** Default value: `#4094e8` */
  "linetoolorder.lineActiveBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolorder.lineActiveSellColor": string;
  /** Default value: `#FF0000` */
  "linetoolorder.lineColor": string;
  /** Default value: `rgba(64, 148, 232, 0.5)` */
  "linetoolorder.lineInactiveBuyColor": string;
  /** Default value: `rgba(231, 86, 86, 0.5)` */
  "linetoolorder.lineInactiveSellColor": string;
  /** Default value: `inherit` */
  "linetoolorder.lineLength": string;
  /** Default value: `percentage` */
  "linetoolorder.lineLengthUnit": string;
  /** Default value: `inherit` */
  "linetoolorder.lineStyle": string;
  /** Default value: `inherit` */
  "linetoolorder.lineWidth": string;
  /** Default value: `` */
  "linetoolorder.modifyTooltip": string;
  /** Default value: `#4094e8` */
  "linetoolorder.quantityBackgroundActiveBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolorder.quantityBackgroundActiveSellColor": string;
  /** Default value: `rgba(64, 148, 232, 0.5)` */
  "linetoolorder.quantityBackgroundInactiveBuyColor": string;
  /** Default value: `rgba(231, 86, 86, 0.5)` */
  "linetoolorder.quantityBackgroundInactiveSellColor": string;
  /** Default value: `#4094e8` */
  "linetoolorder.quantityBorderActiveBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolorder.quantityBorderActiveSellColor": string;
  /** Default value: `rgba(64, 148, 232, 0.5)` */
  "linetoolorder.quantityBorderInactiveBuyColor": string;
  /** Default value: `rgba(231, 86, 86, 0.5)` */
  "linetoolorder.quantityBorderInactiveSellColor": string;
  /** Default value: `true` */
  "linetoolorder.quantityFontBold": boolean;
  /** Default value: `Verdana` */
  "linetoolorder.quantityFontFamily": string;
  /** Default value: `false` */
  "linetoolorder.quantityFontItalic": boolean;
  /** Default value: `9` */
  "linetoolorder.quantityFontSize": number;
  /** Default value: `#ffffff` */
  "linetoolorder.quantityTextColor": string;
  /** Default value: `0` */
  "linetoolorder.quantityTextTransparency": number;
  /** Default value: `` */
  "linetoolorder.tooltip": string;
}
export interface OrderOrPositionMessage {
  /** Type of message about the order or position */
  type: OrderOrPositionMessageType;
  /** Message content */
  text: string;
}
/** Describes the result of the order preview. */
export interface OrderPreviewResult {
  /** Order preview section */
  sections: OrderPreviewSection[];
  /** Confirmation ID. A unique identifier that should be passed to `placeOrder` method */
  confirmId?: string;
  /** Warning messages */
  warnings?: string[];
  /** Error messages */
  errors?: string[];
}
/**
 * Describes a single order preview section.
 * Order preview can have multiple sections that are divided by separators and may have titles.
 */
export interface OrderPreviewSection {
  /** Order preview items. Each item is a row of the section table. */
  rows: OrderPreviewSectionRow[];
  /** Optional title of the section. */
  header?: string;
}
/**
 * Describes a single row of a section table of the order preview.
 */
export interface OrderPreviewSectionRow {
  /** Description of the item. */
  title: string;
  /** Formatted value of the item. */
  value: string;
}
export interface OrderRule {
  /** Order ID */
  id: string;
  /** Severity of Order Rule */
  severity: "warning" | "error";
}
/**
 * Input value of the Order Ticket.
 * This information is not sufficient to place an order.
 */
export interface OrderTemplate {
  /** Symbol identifier */
  symbol: string;
  /** Order Type */
  type?: OrderType;
  /** order / execution side */
  side?: Side;
  /** Order quantity */
  qty?: number;
  /** Type of Stop Order */
  stopType?: StopType;
  /** Order stop price */
  stopPrice?: number;
  /** Order limit price */
  limitPrice?: number;
  /** Order Take Profit (Brackets) */
  takeProfit?: number;
  /** Order Stop loss (Brackets) */
  stopLoss?: number;
  /** Order Trailing stop (Brackets) */
  trailingStopPips?: number;
  /** Duration or expiration of an order */
  duration?: OrderDuration;
  /** Custom input fields */
  customFields?: CustomInputFieldsValues;
}
/**
 * Overrides for the 'Overlay' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface OverlayIndicatorOverrides {
  [key: string]: StudyOverrideValueType;
}
export interface Overrides {
  [key: string]: string | number | boolean;
}
/**
 * Overrides for the 'Parabolic SAR' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ParabolicSARIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `cross` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Parallelchannel drawing tool.
 */
export interface ParallelchannelLineToolOverrides {
  /** Default value: `rgba(41, 98, 255, 0.2)` */
  "linetoolparallelchannel.backgroundColor": string;
  /** Default value: `false` */
  "linetoolparallelchannel.extendLeft": boolean;
  /** Default value: `false` */
  "linetoolparallelchannel.extendRight": boolean;
  /** Default value: `true` */
  "linetoolparallelchannel.fillBackground": boolean;
  /** Default value: `false` */
  "linetoolparallelchannel.labelBold": boolean;
  /** Default value: `14` */
  "linetoolparallelchannel.labelFontSize": number;
  /** Default value: `left` */
  "linetoolparallelchannel.labelHorzAlign": string;
  /** Default value: `false` */
  "linetoolparallelchannel.labelItalic": boolean;
  /** Default value: `#2962FF` */
  "linetoolparallelchannel.labelTextColor": string;
  /** Default value: `bottom` */
  "linetoolparallelchannel.labelVertAlign": string;
  /** Default value: `false` */
  "linetoolparallelchannel.labelVisible": boolean;
  /** Default value: `#2962FF` */
  "linetoolparallelchannel.linecolor": string;
  /** Default value: `0` */
  "linetoolparallelchannel.linestyle": number;
  /** Default value: `2` */
  "linetoolparallelchannel.linewidth": number;
  /** Default value: `#2962FF` */
  "linetoolparallelchannel.midlinecolor": string;
  /** Default value: `2` */
  "linetoolparallelchannel.midlinestyle": number;
  /** Default value: `1` */
  "linetoolparallelchannel.midlinewidth": number;
  /** Default value: `true` */
  "linetoolparallelchannel.showMidline": boolean;
  /** Default value: `20` */
  "linetoolparallelchannel.transparency": number;
}
/**
 * Override properties for the Path drawing tool.
 */
export interface PathLineToolOverrides {
  /** Default value: `0` */
  "linetoolpath.leftEnd": number;
  /** Default value: `#2962FF` */
  "linetoolpath.lineColor": string;
  /** Default value: `0` */
  "linetoolpath.lineStyle": number;
  /** Default value: `2` */
  "linetoolpath.lineWidth": number;
  /** Default value: `1` */
  "linetoolpath.rightEnd": number;
}
/**
 * Parameters passed to getBars
 */
export interface PeriodParams {
  /**
   * Unix timestamp (leftmost requested bar)
   */
  from: number;
  /**
   * Unix timestamp (rightmost requested bar - not inclusive)
   */
  to: number;
  /**
   * The exact amount of bars to load, should be considered a higher priority than `from` if your datafeed supports it
   */
  countBack: number;
  /**
   * Used to identify if it's the first call of getBars
   */
  firstDataRequest: boolean;
}
export interface PineJS {
  /** Standard library functions for PineJS */
  Std: PineJSStd;
}
/**
 * PineJS standard library functions.
 */
export interface PineJSStd {
  /**
   * Default maximum size of a pine series.
   */
  max_series_default_size: 10001;
  /**
   * Epsilon (machine precision)
   *
   * @returns Epsilon (machine precision). Upper bound on the relative approximation error due to rounding in floating point arithmetic.
   */
  eps(): number;
  /**
   * High Price
   *
   * @param context - PineJS execution context.
   * @returns Current high price.
   */
  high(context: IContext): number;
  /**
   * Low Price
   *
   * @param context - PineJS execution context.
   * @returns Current low price.
   */
  low(context: IContext): number;
  /**
   * Open Price
   *
   * @param context - PineJS execution context.
   * @returns Current open price.
   */
  open(context: IContext): number;
  /**
   * Close Price
   *
   * @param context - PineJS execution context.
   * @returns Current close price.
   */
  close(context: IContext): number;
  /**
   * Is a shortcut for (open + high + low + close)/4
   *
   * @param context - PineJS execution context.
   * @returns Calculated average of the current OHLC values
   */
  ohlc4(context: IContext): number;
  /**
   * Current bar volume
   *
   * @param context - PineJS execution context.
   * @returns Current bar volume
   */
  volume(context: IContext): number;
  /**
   * Current bar time
   *
   * @param context - PineJS execution context.
   * @returns UNIX time of current bar
   */
  time(context: IContext): number;
  /**
   * Current bar time
   *
   * @param context - PineJS execution context.
   * @param period - Period
   * @param spec
   * @returns UNIX time of current bar
   */
  time(context: IContext, period: string, spec: unknown): number;
  /**
   * Is a shortcut for (high + low)/2
   *
   * @param context - PineJS execution context.
   * @returns Calculated average of the current HL values
   */
  hl2(context: IContext): number;
  /**
   * Is a shortcut for (high + low + close)/3
   *
   * @param context - PineJS execution context.
   * @returns Calculated average of the current HLC values
   */
  hlc3(context: IContext): number;
  /**
   * Resolution string, e.g. 60 - 60 minutes, D - daily, W - weekly, M - monthly, 5D - 5 days, 12M - one year, 3M - one quarter
   *
   * @param context - PineJS execution context.
   * @returns The resolution string for the current context
   */
  period(context: IContext): string;
  /**
   * Ticker ID
   *
   * @param context - PineJS execution context.
   * @returns Ticker ID for the current symbol
   */
  tickerid(context: IContext): string;
  /**
   * Year of current bar time in exchange timezone.
   *
   * @param context - PineJS execution context.
   * @param time optional time. Current bar time will be used by default.
   * @returns Current bar year in exchange timezone.
   */
  year(context: IContext, time?: number): number;
  /**
   * Month of current bar time in exchange timezone.
   *
   * @param context - PineJS execution context.
   * @param time optional time. Current bar time will be used by default.
   * @returns Current bar month in exchange timezone.
   */
  month(context: IContext, time?: number): number;
  /**
   * Week number of current bar time in exchange timezone.
   *
   * @param context - PineJS execution context.
   * @param time optional time. Current bar time will be used by default.
   * @returns Week number of current bar in exchange timezone.
   */
  weekofyear(context: IContext, time?: number): number;
  /**
   * Day of month for current bar time in exchange timezone.
   *
   * @param context - PineJS execution context.
   * @param time optional time. Current bar time will be used by default.
   * @returns Day of month for current bar time in exchange timezone.
   */
  dayofmonth(context: IContext, time?: number): number;
  /**
   * Day of week for current bar time in exchange timezone.
   *
   * @param context - PineJS execution context.
   * @param time optional time. Current bar time will be used by default.
   * @returns Day of week for current bar time in exchange timezone.
   */
  dayofweek(context: IContext, time?: number): number;
  /**
   * Hour of current bar time in exchange timezone.
   *
   * @param context - PineJS execution context.
   * @param time optional time. Current bar time will be used by default.
   * @returns Current bar hour in exchange timezone.
   */
  hour(context: IContext, time?: number): number;
  /**
   * Minute of current bar time in exchange timezone.
   *
   * @param context - PineJS execution context.
   * @param time optional time. Current bar time will be used by default.
   * @returns Current bar minute in exchange timezone.
   */
  minute(context: IContext, time?: number): number;
  /**
   * Second of current bar time in exchange timezone.
   *
   * @param context - PineJS execution context.
   * @param time optional time. Current bar time will be used by default.
   * @returns Current bar second in exchange timezone.
   */
  second(context: IContext, time?: number): number;
  /**
   * Checks if `n1` is greater than or equal to `n2`
   *
   * @param n1
   * @param n2
   * @param eps - Epsilon (Optional).
   * @returns True if `n1` is greater than or equal to `n2`.
   */
  greaterOrEqual(n1: number, n2: number, eps?: number): boolean;
  /**
   * Checks if `n1` is less than or equal to `n2`
   *
   * @param n1
   * @param n2
   * @param eps - Epsilon (Optional).
   * @returns True if `n1` is less than or equal to `n2`.
   */
  lessOrEqual(n1: number, n2: number, eps?: number): boolean;
  /**
   * Checks if `n1` is equal to `n2` (within the accuracy of epsilon).
   *
   * @param n1
   * @param n2
   * @param eps - Epsilon (Optional).
   * @returns True if `n1` is equal to `n2`.
   */
  equal(n1: number, n2: number, eps?: number): boolean;
  /**
   * Checks if `n1` is greater than `n2`
   *
   * @param n1
   * @param n2
   * @param eps - Epsilon (Optional).
   * @returns True if `n1` is greater than `n2`.
   */
  greater(n1: number, n2: number, eps?: number): boolean;
  /**
   * Checks if `n1` is less than `n2`
   *
   * @param n1
   * @param n2
   * @param eps - Epsilon (Optional).
   * @returns True if `n1` is less than `n2`.
   */
  less(n1: number, n2: number, eps?: number): boolean;
  /**
   * Compare the values of `n1` and `n2`
   *
   * @param n1
   * @param n2
   * @param eps - Epsilon (Optional).
   * @returns `0` if values are equal. `1` if x1 is greater than x2. `-1` if x1 is less than x2
   */
  compare(n1: number, n2: number, eps?: number): -1 | 0 | 1;
  /**
   * Checks if `n1` is greater than or equal to `n2`
   *
   * @param n1
   * @param n2
   * @returns `1` if `n1` is greater than or equal to `n2`, `0` otherwise.
   */
  ge(n1: number, n2: number): number;
  /**
   * Checks if `n1` is less than or equal to `n2`
   *
   * @param n1
   * @param n2
   * @returns `1` if `n1` is greater than or equal to `n2`, `0` otherwise.
   */
  le(n1: number, n2: number): number;
  /**
   * Checks if `n1` is equal to `n2`.
   *
   * @param n1
   * @param n2
   * @returns `1` if `n1` is equal to `n2`, `0` otherwise.
   */
  eq(n1: number, n2: number): number;
  /**
   * Checks if `n1` is not equal to `n2`.
   *
   * @param n1
   * @param n2
   * @returns `1` if `n1` is not equal to `n2`, `0` otherwise.
   */
  neq(n1: number, n2: number): number;
  /**
   * Checks if `n1` is greater than `n2`
   *
   * @param n1
   * @param n2
   * @returns `1` if `n1` is greater than `n2`, `0` otherwise.
   */
  gt(n1: number, n2: number): number;
  /**
   * Checks if `n1` is less than `n2`
   *
   * @param n1
   * @param n2
   * @returns `1` if `n1` is less than `n2`, `0` otherwise.
   */
  lt(n1: number, n2: number): number;
  /**
   * If ... then ... else ...
   * `iff` does exactly the same thing as ternary conditional operator `?:` but in a functional style. Also `iff` is slightly less efficient than operator `?:`
   *
   * @param condition - condition to check
   * @param thenValue - value to use if condition is true
   * @param elseValue - value to use if condition is false
   * @returns either thenValue or elseValue
   */
  iff(condition: number, thenValue: number, elseValue: number): number;
  /**
   * True Range
   *
   * @param n_handleNaN - How NaN values are handled. If truthy, and previous bar's close is `NaN` then tr would be calculated as current bar `high-low`. Otherwise tr would return `NaN` in such cases. Also note, that `atr` uses `tr(true)`.
   * @param ctx - PineJS execution context.
   * @returns True range. It is `max(high - low, abs(high - close[1]), abs(low - close[1]))`
   */
  tr(n_handleNaN: number | undefined, ctx: IContext): number;
  /**
   * Function atr (average true range) returns the RMA of true range. True range is `max(high - low, abs(high - close[1]), abs(low - close[1]))`
   *
   * @param length - Length (number of bars back).
   * @param context - PineJS execution context.
   * @returns Average true range.
   */
  atr(length: number, context: IContext): number;
  /**
   * Determines whether the current resolution is a daily, weekly, or monthly resolution.
   *
   * @param context - PineJS execution context.
   * @returns true if current resolution is a daily or weekly or monthly resolution
   */
  isdwm(context: IContext): boolean;
  /**
   * Determines whether the current resolution is an intraday (minutes or seconds) resolution.
   *
   * @param context - PineJS execution context.
   * @returns true if current resolution is an intraday (minutes or seconds) resolution
   */
  isintraday(context: IContext): boolean;
  /**
   * Determines whether the current resolution is a daily resolution.
   *
   * @param context - PineJS execution context.
   * @returns true if current resolution is a daily resolution
   */
  isdaily(context: IContext): boolean;
  /**
   * Determines whether the current resolution is a weekly resolution.
   *
   * @param context - PineJS execution context.
   * @returns true if current resolution is a weekly resolution
   */
  isweekly(context: IContext): boolean;
  /**
   * Determines whether the current resolution is a monthly resolution.
   *
   * @param context - PineJS execution context.
   * @returns true if current resolution is a monthly resolution
   */
  ismonthly(context: IContext): boolean;
  /**
   * select session breaks for intraday resolutions only
   *
   * @param context - PineJS execution context.
   * @param times - An array of numbers representing the times to select session breaks from.
   * @returns session breaks for intraday resolutions only.
   */
  selectSessionBreaks(context: IContext, times: number[]): number[];
  /**
   * checks whether a new session can be created
   *
   * @param context - PineJS execution context.
   * @returns checks whether a new session can be created
   */
  createNewSessionCheck(context: IContext): (time: number) => boolean;
  /**
   * Display an error message.
   *
   * @param message - message to display for error
   */
  error(message: string): never;
  /**
   * Zig-zag pivot points
   *
   * @param n_deviation - Deviation
   * @param n_depth - Depth (integer)
   * @param context - PineJS execution context.
   * @returns the zig-zag pivot points
   */
  zigzag(n_deviation: number, n_depth: number, context: IContext): number;
  /**
   * Zig-zag pivot points
   *
   * @param n_deviation - Deviation
   * @param n_depth - Depth (integer)
   * @param context - PineJS execution context.
   * @returns the zig-zag pivot points (for bars)
   */
  zigzagbars(n_deviation: number, n_depth: number, context: IContext): number;
  /**
   * Time of the current update
   *
   * @param context - PineJS execution context.
   * @returns symbol update time
   */
  updatetime(context: IContext): number;
  /**
   * Ticker ID for the current symbol
   *
   * @param context - PineJS execution context.
   * @returns Ticker ID for the current symbol
   */
  ticker(context: IContext): string;
  /**
   * Percent rank is the percentage of how many previous values were less than or equal to the current value of given series.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @returns Percent rank of `source` for `length` bars back.
   */
  percentrank(source: IPineSeries, length: number): number;
  /**
   * Test if the series is now rising for length bars long.
   *
   * @param series - Series of values to process.
   * @param length - Number of bars (length).
   * @returns `true` if current `x` is greater than any previous `x` for length bars back, `false` otherwise.
   */
  rising(series: IPineSeries, length: number): number;
  /**
   * Test if the series is now falling for length bars long.
   *
   * @param series - Series of values to process.
   * @param length - Number of bars (length).
   * @returns `true` if current `x` is less than any previous `x` for length bars back, `false` otherwise.
   */
  falling(series: IPineSeries, length: number): number;
  /**
   * Relative strength index. It is calculated based on rma's of upward and downward change of x.
   *
   * @param upper - upward change
   * @param lower - downward change
   * @returns Relative strength index.
   */
  rsi(upper: number, lower: number): number;
  /**
   * The sum function returns the sliding sum of last y values of x.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Sum of x for y bars back.
   */
  sum(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Simple Moving Average. The sum of last `length` values of `source`, divided by `length`.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Simple moving average of x for y bars back.
   */
  sma(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Smoothed Moving Average.
   *
   * @param n_value Next value in the series to calculate.
   * @param n_length Smoothing length.
   * @param ctx PineJS execution context.
   * @returns The smoothed moving average value.
   */
  smma(n_value: number, n_length: number, ctx: IContext): number;
  /**
   * Moving average used in RSI. It is the exponentially weighted moving average with `alpha = 1 / length`.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Exponential moving average of `x` with `alpha = 1 / y`.
   */
  rma(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Exponential Moving Average. In EMA weighting factors decrease exponentially.
   *
   * It calculates by using a formula: `EMA = alpha * x + (1 - alpha) * EMA[1]`, where `alpha = 2 / (y + 1)`.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Exponential moving average of `x` with `alpha = 2 / (y + 1)`
   */
  ema(source: IPineSeries, length: number, context: IContext): number;
  /**
   * The wma function returns weighted moving average of `source` for `length` bars back. In wma weighting factors decrease in arithmetical progression.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Weighted moving average of `series` for `length` bars back.
   */
  wma(source: IPineSeries, length: number, context: IContext): number;
  /**
   * The vwma function returns volume-weighted moving average of `source` for `length` bars back. It is the same as: `sma(x * volume, y) / sma(volume, y)`
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Volume-weighted moving average of `source` for `length` bars back.
   */
  vwma(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Symmetrically weighted moving average with fixed length: 4. Weights: `[1/6, 2/6, 2/6, 1/6]`.
   *
   * @param source - Series of values to process.
   * @param context - PineJS execution context.
   * @returns Symmetrically weighted moving average
   */
  swma(source: IPineSeries, context: IContext): number;
  /**
   * For a given series replaces NaN values with previous nearest non-NaN value.
   *
   * @param n_current - Series of values to process.
   * @param context - PineJS execution context.
   * @returns Series without na gaps.
   */
  fixnan(n_current: number, context: IContext): number;
  /**
   * Lowest value offset for a given number of bars back.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Offset to the lowest bar.
   */
  lowestbars(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Lowest value for a given number of bars back.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Lowest value.
   */
  lowest(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Highest value offset for a given number of bars back.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Offset to the highest bar.
   */
  highestbars(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Highest value for a given number of bars back.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Highest value.
   */
  highest(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Cumulative (total) sum. The function tracks the previous values internally.
   *
   * @param n_value Value to add to the sum.
   * @param context PineJS execution context.
   * @returns The sum.
   */
  cum(n_value: number, context: IContext): number;
  /**
   * Accumulation/distribution index.
   *
   * @param context - PineJS execution context.
   * @returns Accumulation/distribution index.
   */
  accdist(context: IContext): number;
  /**
   * Correlation coefficient. Describes the degree to which two series tend to deviate from their `sma` values.
   *
   * @param sourceA - Source series.
   * @param sourceB - Target series.
   * @param length - Length (number of bars back).
   * @param context - PineJS execution context.
   * @returns Correlation coefficient.
   */
  correlation(
    sourceA: IPineSeries,
    sourceB: IPineSeries,
    length: number,
    context: IContext
  ): number;
  /**
   * Stochastic. It is calculated by a formula: `100 * (close - lowest(low, length)) / (highest(high, length) - lowest(low, length))`
   *
   * @param source - Source series.
   * @param high - Series of high.
   * @param low - Series of low.
   * @param length - Length (number of bars back).
   * @param context - PineJS execution context.
   * @returns Stochastic value.
   */
  stoch(
    source: IPineSeries,
    high: IPineSeries,
    low: IPineSeries,
    length: number,
    context: IContext
  ): number;
  /**
   * True strength index. It uses moving averages of the underlying momentum of a financial instrument.
   *
   * @param source - Source series.
   * @param shortLength - Length (number of bars back).
   * @param longLength - Length (number of bars back).
   * @param context - PineJS execution context.
   * @returns True strength index. A value in range `[-1, 1]`
   */
  tsi(
    source: IPineSeries,
    shortLength: number,
    longLength: number,
    context: IContext
  ): number;
  /**
   * Crossing of series.
   *
   * @param n_0 - First value.
   * @param n_1 - Second value.
   * @param context - PineJS execution context.
   * @returns `true` if two series have crossed each other, otherwise `false`.
   */
  cross(n_0: number, n_1: number, context: IContext): boolean;
  /**
   * Linear regression curve. A line that best fits the prices specified over a user-defined time period.
   * It is calculated using the least squares method. The result of this function is calculated using the formula:
   * `linreg = intercept + slope * (length - 1 - offset)`, where intercept and slope are the values calculated with
   * the least squares method on source series (x argument).
   *
   * @param source - Source series.
   * @param length - Length (number of bars back).
   * @param offset - Offset (number of bars)
   * @returns Linear regression curve point.
   */
  linreg(source: IPineSeries, length: number, offset: number): number;
  /**
   * Parabolic SAR (parabolic stop and reverse) is a method devised by J. Welles Wilder, Jr., to find potential reversals in the market price direction of traded goods.
   *
   * @param start - Start.
   * @param inc - Increment.
   * @param max - Maximum.
   * @param context - PineJS execution context.
   * @returns Parabolic SAR value.
   */
  sar(start: number, inc: number, max: number, context: IContext): number;
  /**
   * Arnaud Legoux Moving Average. It uses Gaussian distribution as weights for moving average.
   *
   * @param series - Series of values to process.
   * @param length - Number of bars (length).
   * @param offset - Controls tradeoff between smoothness (closer to 1) and responsiveness (closer to 0).
   * @param sigma - Changes the smoothness of ALMA. The larger sigma the smoother ALMA.
   */
  alma(
    series: IPineSeries,
    length: number,
    offset: number,
    sigma: number
  ): number;
  /**
   * Difference between current value and previous, `x - x[1]`.
   *
   * @param source - Series to process.
   * @returns The result of subtraction.
   */
  change(source: IPineSeries): number;
  /**
   * Rate of Change.
   *
   * Function roc (rate of change) showing the difference between current value of `source` and the value of `source` that was `length` days ago. It is calculated by the formula: `100 * change(src, length) / src[length]`.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @returns The rate of change of `source` for `length` bars back.
   */
  roc(source: IPineSeries, length: number): number;
  /**
   * Measure of difference between the series and its sma.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Deviation of source for length bars back.
   */
  dev(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Standard deviation. Note: This is a biased estimation of standard deviation.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Standard deviation.
   */
  stdev(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Variance is the expectation of the squared deviation of a series from its mean `sma`, and it informally measures how far a set of numbers are spread out from their mean. Note: This is a biased estimation of sample variance.
   *
   * @param source - Series of values to process.
   * @param length - Number of bars (length).
   * @param context - PineJS execution context.
   * @returns Variance of `source` for `length` bars back.
   */
  variance(source: IPineSeries, length: number, context: IContext): number;
  /**
   * Get time in `daysCount` number of days while taking Daylight savings time into account.
   *
   * @param timezone - Timezone
   * @param utcTime - Date (JS built-in)
   * @param daysCount - Number of days
   * @returns The time is `daysCount` number of days, taking into account Daylight savings time.
   */
  add_days_considering_dst(
    timezone: string,
    utcTime: Date,
    daysCount: number
  ): Date;
  /**
   * Get time in `yearsCount` number of years while taking Daylight savings time into account.
   *
   * @param timezone - Timezone
   * @param utcTime - Date (JS built-in)
   * @param yearsCount - Number of years
   * @returns The time is `yearsCount` number of years, taking into account Daylight savings time.
   */
  add_years_considering_dst(
    timezone: string,
    utcTime: Date,
    yearsCount: number
  ): Date;
  /**
   * Calculates the directional movement values +DI, -DI, DX, ADX, and ADXR.
   *
   * @param diLength - Number of bars (length) used when calculating the +DI and -DI values.
   * @param adxSmoothingLength - Number of bars (length) used when calculating the ADX value.
   * @param context - PineJS execution context.
   * @returns An array of the +DI, -DI, DX, ADX, and ADXR values with diLength smoothing for the (+/-)DI values and adxSmoothingLength for the ADX value.
   */
  dmi(
    diLength: number,
    adxSmoothingLength: number,
    context: IContext
  ): [number, number, number, number, number];
  /**
   * Test value if it's a NaN.
   *
   * @param n - value to test
   * @returns `1` if `n` is not a valid number (`n` is `NaN`), otherwise `0`. Returns `NaN` if `n` is undefined.
   */
  na(n?: number): number;
  /**
   * Replaces NaN values with zeros (or given value) in a series.
   *
   * @param x - value to test (and potentially replace)
   * @param y - fallback value. `0` by default.
   * @returns `x` if it's a valid (not NaN) number, otherwise `y`
   */
  nz(x: number, y?: number): number;
  /**
   * Logical AND.
   *
   * @returns `1` if both values are truthy, `0` otherwise.
   */
  and(n_0: number, n_1: number): number;
  /**
   * Logical OR.
   *
   * @returns `1` if either value is truthy, `0` otherwise.
   */
  or(n_0: number, n_1: number): number;
  /**
   * Logical negation (NOT).
   *
   * @returns `1` if value is falsy, `0` if value is truthy.
   */
  not(n_0: number): number;
  /**
   * Maximum number in the array
   *
   * @returns The greatest of multiple given values
   */
  max(...values: number[]): number;
  /**
   * Minimum number in the array
   *
   * @returns The smallest of multiple given values
   */
  min(...values: number[]): number;
  /**
   * Mathematical power function.
   *
   * @param base - Specify the base to use.
   * @param exponent - Specifies the exponent.
   * @returns `x` raised to the power of `y`.
   */
  pow(base: number, exponent: number): number;
  /**
   * Absolute value of x is x if x >= 0, or -x otherwise.
   *
   * @returns The absolute value of `x`
   */
  abs(x: number): number;
  /**
   * Natural logarithm of any `x > 0` is the unique `y` such that `e^y = x`
   *
   * @returns The natural logarithm of `x`.
   */
  log(x: number): number;
  /**
   * Base 10 logarithm of any `x > 0` is the unique `y` such that `10^y = x`
   *
   * @returns The base 10 logarithm of `x`.
   */
  log10(x: number): number;
  /**
   * Square root of any `x >= 0` is the unique `y >= 0` such that `y^2 = x`
   *
   * @returns The square root of `x`
   */
  sqrt(x: number): number;
  /**
   * Sign (signum) of `x` is `0` if the x is zero, `1.0` if the `x` is greater than zero, `-1.0` if the `x` is less than zero.
   *
   * @returns The sign of `x`
   */
  sign(x: number): number;
  /**
   * The exp function of `x` is `e^x`, where `x` is the argument and `e` is Euler's number.
   *
   * @returns A number representing `e^x`.
   */
  exp(x: number): number;
  /**
   * The sin function returns the trigonometric sine of an angle.
   *
   * @param x - Angle, in radians.
   * @returns The trigonometric sine of an angle.
   */
  sin(x: number): number;
  /**
   * The cos function returns the trigonometric cosine of an angle.
   *
   * @param x - Angle, in radians.
   * @returns The trigonometric cosine of an angle.
   */
  cos(x: number): number;
  /**
   * The tan function returns the trigonometric tangent of an angle.
   *
   * @param x - Angle, in radians.
   * @returns The trigonometric tangent of an angle.
   */
  tan(x: number): number;
  /**
   * The asin function returns the arcsine (in radians) of number such that `sin(asin(y)) = y` for `y` in range `[-1, 1]`.
   *
   * @param x - Angle, in radians.
   * @returns The arcsine of a value; the returned angle is in the range `[-Pi/2, Pi/2]`, or na if y is outside of range `[-1, 1]`.
   */
  asin(x: number): number;
  /**
   * The acos function returns the arccosine (in radians) of number such that `cos(acos(y)) = y` for `y` in range `[-1, 1]`.
   *
   * @param x - Angle, in radians.
   * @returns The arc cosine of a value; the returned angle is in the range `[0, Pi]`, or na if y is outside of range `[-1, 1]`.
   */
  acos(x: number): number;
  /**
   * The atan function returns the arctangent (in radians) of number such that `tan(atan(y)) = y` for any `y`.
   *
   * @param x - Angle, in radians.
   * @returns The arc tangent of a value; the returned angle is in the range `[-Pi/2, Pi/2]`.
   */
  atan(x: number): number;
  /**
   * Round the number down to the closest integer
   *
   * @returns The largest integer less than or equal to the given number.
   */
  floor(x: number): number;
  /**
   * The ceil function returns the smallest (closest to negative infinity) integer that is greater than or equal to the argument.
   *
   * @returns The smallest integer greater than or equal to the given number.
   */
  ceil(x: number): number;
  /**
   * Round the number to the nearest integer
   *
   * @returns The value of `x` rounded to the nearest integer, with ties rounding up. If the precision parameter is used, returns a float value rounded to that number of decimal places.
   */
  round(x: number): number;
  /**
   * Calculates average of all given series (elementwise).
   *
   * @returns the average of the values
   */
  avg(...values: number[]): number;
  /**
   * Current bar index
   *
   * @param context - PineJS execution context.
   * @returns Current bar index. Numbering is zero-based, index of the first historical bar is 0.
   */
  n(context: IContext): number;
  /**
   * Check if a value is zero.
   *
   * @param v the value to test.
   * @returns `true` if the value is zero, `false` otherwise.
   */
  isZero: (v: number) => number;
  /**
   * Convert a number to a boolean.
   *
   * @param v the value to convert.
   * @returns `true` if the number is finite and non-zero, `false` otherwise.
   */
  toBool(v: number): boolean;
  /**
   * Get the symbol currency code.
   *
   * @param ctx PineJS execution context.
   * @returns Symbol currency code.
   */
  currencyCode(ctx: IContext): string | null | undefined;
  /**
   * Get the symbol unit ID.
   *
   * @param ctx PineJS execution context.
   * @returns Symbol unit ID.
   */
  unitId(ctx: IContext): string | null | undefined;
  /**
   * Get the symbol interval. For example: if the symbol has a resolution of `1D` then this function would return `1`.
   *
   * @param ctx PineJS execution context.
   * @returns Symbol interval.
   */
  interval(ctx: IContext): number;
}
export interface PineStudyResultComposite<TPineStudyResultSimple> {
  /** Type is composite */
  type: "composite";
  /** Composite data */
  data: TPineStudyResultSimple[];
}
export interface PipValues {
  /** value of 1 pip if you buy */
  buyPipValue: number;
  /** value of 1 pip if you sell */
  sellPipValue: number;
}
/**
 * Override properties for the Pitchfan drawing tool.
 */
export interface PitchfanLineToolOverrides {
  /** Default value: `true` */
  "linetoolpitchfan.fillBackground": boolean;
  /** Default value: `0.25` */
  "linetoolpitchfan.level0.coeff": number;
  /** Default value: `#ffb74d` */
  "linetoolpitchfan.level0.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level0.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level0.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfan.level0.visible": boolean;
  /** Default value: `0.382` */
  "linetoolpitchfan.level1.coeff": number;
  /** Default value: `#81c784` */
  "linetoolpitchfan.level1.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level1.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfan.level1.visible": boolean;
  /** Default value: `0.5` */
  "linetoolpitchfan.level2.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolpitchfan.level2.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolpitchfan.level2.visible": boolean;
  /** Default value: `0.618` */
  "linetoolpitchfan.level3.coeff": number;
  /** Default value: `#089981` */
  "linetoolpitchfan.level3.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level3.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfan.level3.visible": boolean;
  /** Default value: `0.75` */
  "linetoolpitchfan.level4.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolpitchfan.level4.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level4.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfan.level4.visible": boolean;
  /** Default value: `1` */
  "linetoolpitchfan.level5.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolpitchfan.level5.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolpitchfan.level5.visible": boolean;
  /** Default value: `1.5` */
  "linetoolpitchfan.level6.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolpitchfan.level6.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level6.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfan.level6.visible": boolean;
  /** Default value: `1.75` */
  "linetoolpitchfan.level7.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolpitchfan.level7.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level7.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfan.level7.visible": boolean;
  /** Default value: `2` */
  "linetoolpitchfan.level8.coeff": number;
  /** Default value: `#F77C80` */
  "linetoolpitchfan.level8.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.level8.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfan.level8.visible": boolean;
  /** Default value: `#F23645` */
  "linetoolpitchfan.median.color": string;
  /** Default value: `0` */
  "linetoolpitchfan.median.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfan.median.linewidth": number;
  /** Default value: `true` */
  "linetoolpitchfan.median.visible": boolean;
  /** Default value: `80` */
  "linetoolpitchfan.transparency": number;
}
/**
 * Override properties for the Pitchfork drawing tool.
 */
export interface PitchforkLineToolOverrides {
  /** Default value: `false` */
  "linetoolpitchfork.extendLines": boolean;
  /** Default value: `true` */
  "linetoolpitchfork.fillBackground": boolean;
  /** Default value: `0.25` */
  "linetoolpitchfork.level0.coeff": number;
  /** Default value: `#ffb74d` */
  "linetoolpitchfork.level0.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level0.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level0.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfork.level0.visible": boolean;
  /** Default value: `0.382` */
  "linetoolpitchfork.level1.coeff": number;
  /** Default value: `#81c784` */
  "linetoolpitchfork.level1.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level1.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfork.level1.visible": boolean;
  /** Default value: `0.5` */
  "linetoolpitchfork.level2.coeff": number;
  /** Default value: `#089981` */
  "linetoolpitchfork.level2.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolpitchfork.level2.visible": boolean;
  /** Default value: `0.618` */
  "linetoolpitchfork.level3.coeff": number;
  /** Default value: `#089981` */
  "linetoolpitchfork.level3.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level3.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfork.level3.visible": boolean;
  /** Default value: `0.75` */
  "linetoolpitchfork.level4.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolpitchfork.level4.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level4.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfork.level4.visible": boolean;
  /** Default value: `1` */
  "linetoolpitchfork.level5.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolpitchfork.level5.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolpitchfork.level5.visible": boolean;
  /** Default value: `1.5` */
  "linetoolpitchfork.level6.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolpitchfork.level6.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level6.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfork.level6.visible": boolean;
  /** Default value: `1.75` */
  "linetoolpitchfork.level7.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolpitchfork.level7.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level7.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfork.level7.visible": boolean;
  /** Default value: `2` */
  "linetoolpitchfork.level8.coeff": number;
  /** Default value: `#F77C80` */
  "linetoolpitchfork.level8.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.level8.linewidth": number;
  /** Default value: `false` */
  "linetoolpitchfork.level8.visible": boolean;
  /** Default value: `#F23645` */
  "linetoolpitchfork.median.color": string;
  /** Default value: `0` */
  "linetoolpitchfork.median.linestyle": number;
  /** Default value: `2` */
  "linetoolpitchfork.median.linewidth": number;
  /** Default value: `true` */
  "linetoolpitchfork.median.visible": boolean;
  /** Default value: `0` */
  "linetoolpitchfork.style": number;
  /** Default value: `80` */
  "linetoolpitchfork.transparency": number;
}
/**
 * Overrides for the 'Pivot Points Standard' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface PivotPointsStandardIndicatorOverrides {
  [key: string]: StudyOverrideValueType;
}
export interface PlaceOrderResult {
  /** Order id */
  orderId?: string;
}
export interface PlacedOrder extends PlacedOrderBase, CustomFields {}
/**
 * An object that contains information about a placed order.
 */
export interface PlacedOrderBase {
  /** Order ID */
  id: string;
  /** Symbol name */
  symbol: string;
  /** Order type */
  type: OrderType;
  /** Order side (buy or sell) */
  side: Side;
  /** Order quantity (double) */
  qty: number;
  /** Order status */
  status: OrderStatus;
  /** Stop loss price (double). Available when Brackets are enabled */
  stopLoss?: number;
  /** Trailing stop Pips value (double). Available when Brackets are enabled */
  trailingStopPips?: number;
  /** Stop Loss type. It should be set to 1 (StopType.TrailingStop) for trailing stop orders. */
  stopType?: StopType;
  /** Take profit price (double). Available when Brackets are enabled */
  takeProfit?: number;
  /** Order duration */
  duration?: OrderDuration;
  /**
   * An object that contains the results of broker specific user inputs (for example a digital signature).
   * There are two possible kinds of custom fields: an input field with a checkbox and a custom combobox.
   */
  customFields?: CustomInputFieldsValues;
  /** Filled order quantity (double) */
  filledQty?: number;
  /** Average fulfilled price for the order (double) */
  avgPrice?: number;
  /** Last update time (unix timestamp in milliseconds) */
  updateTime?: number;
  /** Price for the limit order (double) */
  limitPrice?: number;
  /** Price for the stop order (double) */
  stopPrice?: number;
  /** Message describing the state of the order */
  message?: OrderOrPositionMessage;
}
export interface PlusClickParams extends MouseEventParams {
  /** Symbol identifier */
  symbol: string | null;
  /** Price */
  price: number;
}
export interface PnFStylePreferences {
  /** Up mark color */
  upColor: string;
  /** Down mark color */
  downColor: string;
  /** Up projection mark color */
  upColorProjection: string;
  /** Down projection mark color */
  downColorProjection: string;
}
/**
 * Polygon Preferences
 */
export interface PolygonPreferences {
  /** Transparency of the Polygon. Value between 0 and 100, where `100` -> fully transparent */
  transparency: number;
  /** Color of the Polygon */
  color: string;
}

/**
 * Override properties for the Polyline drawing tool.
 */
export interface PolylineLineToolOverrides {
  /** Default value: `rgba(0, 188, 212, 0.2)` */
  "linetoolpolyline.backgroundColor": string;
  /** Default value: `true` */
  "linetoolpolyline.fillBackground": boolean;
  /** Default value: `false` */
  "linetoolpolyline.filled": boolean;
  /** Default value: `#00bcd4` */
  "linetoolpolyline.linecolor": string;
  /** Default value: `0` */
  "linetoolpolyline.linestyle": number;
  /** Default value: `2` */
  "linetoolpolyline.linewidth": number;
  /** Default value: `80` */
  "linetoolpolyline.transparency": number;
}
export interface Position extends PositionBase, CustomFields {}
/**
 * Describes a single position.
 */
export interface PositionBase {
  /** Position ID. Usually id should be equal to brokerSymbol */
  id: string;
  /** Symbol name */
  symbol: string;
  /** Position Quantity (positive number) */
  qty: number;
  /** Short position quantity */
  shortQty?: number;
  /** Long position quantity */
  longQty?: number;
  /** Position Side */
  side: Side;
  /** Average price */
  avgPrice: number;
  /** Message describing the state of the position */
  message?: OrderOrPositionMessage;
}
export interface PositionDialogOptions extends TradingDialogOptions {}
/**
 * Override properties for the Position drawing tool.
 */
export interface PositionLineToolOverrides {
  /** Default value: `rgba(255, 255, 255, 0.25)` */
  "linetoolposition.bodyBackgroundColor": string;
  /** Default value: `25` */
  "linetoolposition.bodyBackgroundTransparency": number;
  /** Default value: `#4094e8` */
  "linetoolposition.bodyBorderBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolposition.bodyBorderSellColor": string;
  /** Default value: `true` */
  "linetoolposition.bodyFontBold": boolean;
  /** Default value: `Verdana` */
  "linetoolposition.bodyFontFamily": string;
  /** Default value: `false` */
  "linetoolposition.bodyFontItalic": boolean;
  /** Default value: `9` */
  "linetoolposition.bodyFontSize": number;
  /** Default value: `#e75656` */
  "linetoolposition.bodyTextNegativeColor": string;
  /** Default value: `#646464` */
  "linetoolposition.bodyTextNeutralColor": string;
  /** Default value: `#268c02` */
  "linetoolposition.bodyTextPositiveColor": string;
  /** Default value: `rgba(255, 255, 255, 0.25)` */
  "linetoolposition.closeButtonBackgroundColor": string;
  /** Default value: `25` */
  "linetoolposition.closeButtonBackgroundTransparency": number;
  /** Default value: `#4094e8` */
  "linetoolposition.closeButtonBorderBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolposition.closeButtonBorderSellColor": string;
  /** Default value: `#4094e8` */
  "linetoolposition.closeButtonIconBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolposition.closeButtonIconSellColor": string;
  /** Default value: `` */
  "linetoolposition.closeTooltip": string;
  /** Default value: `inherit` */
  "linetoolposition.extendLeft": string;
  /** Default value: `#4094e8` */
  "linetoolposition.lineBuyColor": string;
  /** Default value: `inherit` */
  "linetoolposition.lineLength": string;
  /** Default value: `percentage` */
  "linetoolposition.lineLengthUnit": string;
  /** Default value: `#e75656` */
  "linetoolposition.lineSellColor": string;
  /** Default value: `inherit` */
  "linetoolposition.lineStyle": string;
  /** Default value: `inherit` */
  "linetoolposition.lineWidth": string;
  /** Default value: `` */
  "linetoolposition.protectTooltip": string;
  /** Default value: `#4094e8` */
  "linetoolposition.quantityBackgroundBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolposition.quantityBackgroundSellColor": string;
  /** Default value: `#4094e8` */
  "linetoolposition.quantityBorderBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolposition.quantityBorderSellColor": string;
  /** Default value: `true` */
  "linetoolposition.quantityFontBold": boolean;
  /** Default value: `Verdana` */
  "linetoolposition.quantityFontFamily": string;
  /** Default value: `false` */
  "linetoolposition.quantityFontItalic": boolean;
  /** Default value: `9` */
  "linetoolposition.quantityFontSize": number;
  /** Default value: `#ffffff` */
  "linetoolposition.quantityTextColor": string;
  /** Default value: `0` */
  "linetoolposition.quantityTextTransparency": number;
  /** Default value: `rgba(255, 255, 255, 0.25)` */
  "linetoolposition.reverseButtonBackgroundColor": string;
  /** Default value: `25` */
  "linetoolposition.reverseButtonBackgroundTransparency": number;
  /** Default value: `#4094e8` */
  "linetoolposition.reverseButtonBorderBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolposition.reverseButtonBorderSellColor": string;
  /** Default value: `#4094e8` */
  "linetoolposition.reverseButtonIconBuyColor": string;
  /** Default value: `#e75656` */
  "linetoolposition.reverseButtonIconSellColor": string;
  /** Default value: `` */
  "linetoolposition.reverseTooltip": string;
  /** Default value: `` */
  "linetoolposition.tooltip": string;
}
/**
 * Anchored (fixed) drawing point position as a percentage from the top left of a chart.
 * For example `{ x: 0.5, y: 0.5 }` for the centre of the chart.
 */
export interface PositionPercents {
  /**
   * Position as a percentage from the left edge of the chart.
   */
  x: number;
  /**
   * Position as a percentage from the top edge of the chart.
   */
  y: number;
}
export interface PositiveBaseInputFieldValidatorResult
  extends BaseInputFieldValidatorResult {
  /** @inheritDoc */
  valid: true;
}
/**
 * Output value of the Order Ticket and input value of the broker's place order command.
 * This information is sufficient to place an order.
 */
export interface PreOrder extends OrderTemplate {
  /** @inheritDoc */
  symbol: string;
  /** @inheritDoc */
  type: OrderType;
  /** @inheritDoc */
  side: Side;
  /** @inheritDoc */
  qty: number;
  /** Current Quotes */
  currentQuotes?: AskBid;
  /**
   * It is set to `true`, if the order closes a position.
   */
  isClose?: boolean;
}
/**
 * Override properties for the Prediction drawing tool.
 */
export interface PredictionLineToolOverrides {
  /** Default value: `#202020` */
  "linetoolprediction.centersColor": string;
  /** Default value: `#F23645` */
  "linetoolprediction.failureBackground": string;
  /** Default value: `#ffffff` */
  "linetoolprediction.failureTextColor": string;
  /** Default value: `#ead289` */
  "linetoolprediction.intermediateBackColor": string;
  /** Default value: `#6d4d22` */
  "linetoolprediction.intermediateTextColor": string;
  /** Default value: `#2962FF` */
  "linetoolprediction.linecolor": string;
  /** Default value: `2` */
  "linetoolprediction.linewidth": number;
  /** Default value: `#2962FF` */
  "linetoolprediction.sourceBackColor": string;
  /** Default value: `#2962FF` */
  "linetoolprediction.sourceStrokeColor": string;
  /** Default value: `#ffffff` */
  "linetoolprediction.sourceTextColor": string;
  /** Default value: `#4caf50` */
  "linetoolprediction.successBackground": string;
  /** Default value: `#ffffff` */
  "linetoolprediction.successTextColor": string;
  /** Default value: `#2962FF` */
  "linetoolprediction.targetBackColor": string;
  /** Default value: `#2962FF` */
  "linetoolprediction.targetStrokeColor": string;
  /** Default value: `#ffffff` */
  "linetoolprediction.targetTextColor": string;
  /** Default value: `10` */
  "linetoolprediction.transparency": number;
}
/**
 * Overrides for the 'Price Channel' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface PriceChannelIndicatorOverrides {
  /** Default value: `15` */
  "highprice line.display": number;
  /** Default value: `0` */
  "highprice line.linestyle": number;
  /** Default value: `1` */
  "highprice line.linewidth": number;
  /** Default value: `line` */
  "highprice line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "highprice line.trackprice": boolean;
  /** Default value: `0` */
  "highprice line.transparency": number;
  /** Default value: `#F50057` */
  "highprice line.color": string;
  /** Default value: `15` */
  "lowprice line.display": number;
  /** Default value: `0` */
  "lowprice line.linestyle": number;
  /** Default value: `1` */
  "lowprice line.linewidth": number;
  /** Default value: `line` */
  "lowprice line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lowprice line.trackprice": boolean;
  /** Default value: `0` */
  "lowprice line.transparency": number;
  /** Default value: `#F50057` */
  "lowprice line.color": string;
  /** Default value: `15` */
  "centerprice line.display": number;
  /** Default value: `0` */
  "centerprice line.linestyle": number;
  /** Default value: `1` */
  "centerprice line.linewidth": number;
  /** Default value: `line` */
  "centerprice line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "centerprice line.trackprice": boolean;
  /** Default value: `0` */
  "centerprice line.transparency": number;
  /** Default value: `#2196F3` */
  "centerprice line.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Price Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface PriceOscillatorIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#089981` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Price Volume Trend' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface PriceVolumeTrendIndicatorOverrides {
  /** Default value: `15` */
  "pvt.display": number;
  /** Default value: `0` */
  "pvt.linestyle": number;
  /** Default value: `1` */
  "pvt.linewidth": number;
  /** Default value: `line` */
  "pvt.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "pvt.trackprice": boolean;
  /** Default value: `0` */
  "pvt.transparency": number;
  /** Default value: `#2196F3` */
  "pvt.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Position defined by a price and time.
 */
export interface PricedPoint extends TimePoint {
  /** Price */
  price: number;
}
/**
 * Override properties for the Pricelabel drawing tool.
 */
export interface PricelabelLineToolOverrides {
  /** Default value: `#2962FF` */
  "linetoolpricelabel.backgroundColor": string;
  /** Default value: `#2962FF` */
  "linetoolpricelabel.borderColor": string;
  /** Default value: `#ffffff` */
  "linetoolpricelabel.color": string;
  /** Default value: `14` */
  "linetoolpricelabel.fontsize": number;
  /** Default value: `bold` */
  "linetoolpricelabel.fontWeight": string;
  /** Default value: `0` */
  "linetoolpricelabel.transparency": number;
}
/**
 * Override properties for the Projection drawing tool.
 */
export interface ProjectionLineToolOverrides {
  /** Default value: `rgba(41, 98, 255, 0.2)` */
  "linetoolprojection.color1": string;
  /** Default value: `rgba(156, 39, 176, 0.2)` */
  "linetoolprojection.color2": string;
  /** Default value: `true` */
  "linetoolprojection.fillBackground": boolean;
  /** Default value: `1` */
  "linetoolprojection.level1.coeff": number;
  /** Default value: `#808080` */
  "linetoolprojection.level1.color": string;
  /** Default value: `0` */
  "linetoolprojection.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolprojection.level1.linewidth": number;
  /** Default value: `true` */
  "linetoolprojection.level1.visible": boolean;
  /** Default value: `2` */
  "linetoolprojection.linewidth": number;
  /** Default value: `true` */
  "linetoolprojection.showCoeffs": boolean;
  /** Default value: `80` */
  "linetoolprojection.transparency": number;
  /** Default value: `#9598A1` */
  "linetoolprojection.trendline.color": string;
  /** Default value: `0` */
  "linetoolprojection.trendline.linestyle": number;
  /** Default value: `true` */
  "linetoolprojection.trendline.visible": boolean;
}
/**
 * Quantity field step and boundaries
 */
export interface QuantityMetainfo {
  /** Minimum quantity */
  min: number;
  /** Maximum quantity */
  max: number;
  /** Quantity step size */
  step: number;
  /** Quantity step size for scrolling */
  uiStep?: number;
  /** Default quantity value */
  default?: number;
}
export interface QuoteDataResponse {
  /** Status code for symbol. Expected values: `ok` | `error` */
  s: "ok" | "error";
  /** Symbol name. This value must be **exactly the same** as in the request */
  n: string;
  /** Quote Values */
  v: unknown;
}
/** Quote Data Error Response */
export interface QuoteErrorData extends QuoteDataResponse {
  /** @inheritDoc */
  s: "error";
  /** @inheritDoc */
  v: object;
}
/** Quote Data Ok Response */
export interface QuoteOkData extends QuoteDataResponse {
  /** @inheritDoc */
  s: "ok";
  /** @inheritDoc */
  v: DatafeedQuoteValues;
}
/**
 * Options for specifying a Range which includes a resolution, and a time frame.
 */
export interface RangeOptions {
  /**
   * Time frame for the range.
   */
  val: TimeFrameValue;
  /**
   * Resolution for the range.
   */
  res: ResolutionString;
}
/**
 * Overrides for the 'Rate Of Change' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface RateOfChangeIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero line.color": string;
  /** Default value: `2` */
  "zero line.linestyle": number;
  /** Default value: `1` */
  "zero line.linewidth": number;
  /** Default value: `true` */
  "zero line.visible": boolean;
  /** Default value: `0` */
  "zero line.value": number;
  /** Default value: `15` */
  "roc.display": number;
  /** Default value: `0` */
  "roc.linestyle": number;
  /** Default value: `1` */
  "roc.linewidth": number;
  /** Default value: `line` */
  "roc.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "roc.trackprice": boolean;
  /** Default value: `0` */
  "roc.transparency": number;
  /** Default value: `#2196F3` */
  "roc.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Ratio' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface RatioIndicatorOverrides {
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `2` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `35` */
  "plot.transparency": number;
  /** Default value: `#800080` */
  "plot.color": string;
  /** Default value: `15` */
  "plot.display": number;
  [key: string]: StudyOverrideValueType;
}
export interface RawStudyMetaInfo extends RawStudyMetaInfoBase {
  /** Identifier for Study */
  readonly id: RawStudyMetaInfoId;
}
export interface RawStudyMetaInfoBase {
  /**
   * Description of the study. It will be displayed in the Indicators window and will be used as a name argument when calling the createStudy method
   */
  readonly description: string;
  /** Short description of the study. Will be displayed on the chart */
  readonly shortDescription: string;
  /** Name for the study */
  readonly name?: string;
  /** Metainfo version of the study. The current version is 53, and the default one is 0. */
  readonly _metainfoVersion?: number;
  /** Use {@link format} instead.
   * @deprecated
   */
  readonly precision?: number | string;
  /**
   * A type of data that an indicator displays, such as `volume` or `price`. Values on the [Price Scale](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Price-Scale.md) depend on this data type.
   * Additionally, you can adjust a precision of indicator values. To do this, specify the `precision` property in {@link StudyPlotValuePrecisionFormat}.
   *
   * For more information about `format`, refer to the [Metainfo](https://www.tradingview.com/charting-library-docs/latest/custom_studies/metainfo/metainfo.md) article.
   */
  readonly format: StudyPlotValueFormat;
  /** Whether the study should appear on the main series pane */
  readonly is_price_study?: boolean;
  /** should be `true` in Custom Study */
  readonly isCustomIndicator?: boolean;
  /** Whether the study price scale should be the same as the main series one. */
  readonly linkedToSeries?: boolean;
  /** Price scale to use for the study */
  readonly priceScale?: StudyTargetPriceScale;
  /** Whether the study should appear in Indicators list. */
  readonly is_hidden_study?: boolean;
  /** an object containing settings that are applied when user clicks 'Apply Defaults'. See dedicated article: [Custom Studies Defaults](https://www.tradingview.com/charting-library-docs/latest/custom_studies/metainfo/Custom-Studies-Defaults.md) */
  readonly defaults: Readonly<Partial<StudyDefaults>>;
  /** Bands */
  readonly bands?: readonly Readonly<StudyBandInfo>[];
  /** Filled area is a special object, which allows coloring an area between two plots or hlines. Please note, that it is impossible to fill the area between a band and a hline. */
  readonly filledAreas?: readonly Readonly<StudyFilledAreaInfo>[];
  /** array with inputs info depending on type. See dedicated article: [Custom Studies Inputs](https://www.tradingview.com/charting-library-docs/latest/custom_studies/metainfo/Custom-Studies-Inputs.md) */
  readonly inputs?: StudyInputInfoList;
  /** Symbol source */
  readonly symbolSource?: SymbolSource;
  /**
   * definitions of palettes that are used in plots and defaults. Palettes allows you use different styles (not only colors) for each line point.
   *
   * This object contains palette names as keys, and palette info as values: `[palette.name]: { colors, valToIndex, addDefaultColor }`, where
   * - `colors`* - an object `{ [color_id]: { name: 'name' }}`, where name is a string that will appear on Style tab of study properties dialog.
   * - `valToIndex` - an object, the mapping between the values that are returned by the script and palette colors.
   * - `addDefaultColor` - boolean, if true the defaults are used for colorer type plot, when its value is null or undefined.
   */
  readonly palettes?: MappedObject<Readonly<StudyPalettesInfo>>;
  /** array with study plots info. See dedicated article: [Custom Studies Plots](https://www.tradingview.com/charting-library-docs/latest/custom_studies/Custom-Studies-Plots.md) */
  readonly plots?: readonly Readonly<StudyPlotInfo>[];
  /** an object with plot id as keys and style info as values. */
  readonly styles?: MappedObject<Readonly<StudyStylesInfo>>;
  /** array with study plots info. See dedicated article: [Custom Studies OHLC Plots](https://www.tradingview.com/charting-library-docs/latest/custom_studies/Custom-Studies-OHLC-Plots.md) */
  readonly ohlcPlots?: MappedObject<Readonly<StudyOhlcStylesInfo>>;
  /** Financial Period */
  readonly financialPeriod?: FinancialPeriod;
  /** Key for grouping studies */
  readonly groupingKey?: string;
}
/**
 * Override properties for the Ray drawing tool.
 */
export interface RayLineToolOverrides {
  /** Default value: `false` */
  "linetoolray.alwaysShowStats": boolean;
  /** Default value: `false` */
  "linetoolray.bold": boolean;
  /** Default value: `false` */
  "linetoolray.extendLeft": boolean;
  /** Default value: `true` */
  "linetoolray.extendRight": boolean;
  /** Default value: `14` */
  "linetoolray.fontsize": number;
  /** Default value: `center` */
  "linetoolray.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetoolray.italic": boolean;
  /** Default value: `0` */
  "linetoolray.leftEnd": number;
  /** Default value: `#2962FF` */
  "linetoolray.linecolor": string;
  /** Default value: `0` */
  "linetoolray.linestyle": number;
  /** Default value: `2` */
  "linetoolray.linewidth": number;
  /** Default value: `0` */
  "linetoolray.rightEnd": number;
  /** Default value: `false` */
  "linetoolray.showAngle": boolean;
  /** Default value: `false` */
  "linetoolray.showBarsRange": boolean;
  /** Default value: `false` */
  "linetoolray.showDateTimeRange": boolean;
  /** Default value: `false` */
  "linetoolray.showDistance": boolean;
  /** Default value: `false` */
  "linetoolray.showLabel": boolean;
  /** Default value: `false` */
  "linetoolray.showMiddlePoint": boolean;
  /** Default value: `false` */
  "linetoolray.showPercentPriceRange": boolean;
  /** Default value: `false` */
  "linetoolray.showPipsPriceRange": boolean;
  /** Default value: `false` */
  "linetoolray.showPriceLabels": boolean;
  /** Default value: `false` */
  "linetoolray.showPriceRange": boolean;
  /** Default value: `2` */
  "linetoolray.statsPosition": number;
  /** Default value: `#2962FF` */
  "linetoolray.textcolor": string;
  /** Default value: `bottom` */
  "linetoolray.vertLabelsAlign": string;
}
/**
 * Override properties for the Rectangle drawing tool.
 */
export interface RectangleLineToolOverrides {
  /** Default value: `rgba(156, 39, 176, 0.2)` */
  "linetoolrectangle.backgroundColor": string;
  /** Default value: `false` */
  "linetoolrectangle.bold": boolean;
  /** Default value: `#9c27b0` */
  "linetoolrectangle.color": string;
  /** Default value: `false` */
  "linetoolrectangle.extendLeft": boolean;
  /** Default value: `false` */
  "linetoolrectangle.extendRight": boolean;
  /** Default value: `true` */
  "linetoolrectangle.fillBackground": boolean;
  /** Default value: `14` */
  "linetoolrectangle.fontSize": number;
  /** Default value: `left` */
  "linetoolrectangle.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetoolrectangle.italic": boolean;
  /** Default value: `2` */
  "linetoolrectangle.linewidth": number;
  /** Default value: `#9c27b0` */
  "linetoolrectangle.middleLine.lineColor": string;
  /** Default value: `2` */
  "linetoolrectangle.middleLine.lineStyle": number;
  /** Default value: `1` */
  "linetoolrectangle.middleLine.lineWidth": number;
  /** Default value: `false` */
  "linetoolrectangle.middleLine.showLine": boolean;
  /** Default value: `false` */
  "linetoolrectangle.showLabel": boolean;
  /** Default value: `#9c27b0` */
  "linetoolrectangle.textColor": string;
  /** Default value: `50` */
  "linetoolrectangle.transparency": number;
  /** Default value: `bottom` */
  "linetoolrectangle.vertLabelsAlign": string;
}
/**
 * Overrides for the 'Regression Trend' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface RegressionTrendIndicatorOverrides {
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Regressiontrend drawing tool.
 */
export interface RegressiontrendLineToolOverrides {
  /** Default value: `0` */
  "linetoolregressiontrend.inputs.first bar time": number;
  /** Default value: `0` */
  "linetoolregressiontrend.inputs.last bar time": number;
  /** Default value: `-2` */
  "linetoolregressiontrend.inputs.lower diviation": number;
  /** Default value: `close` */
  "linetoolregressiontrend.inputs.source": string;
  /** Default value: `2` */
  "linetoolregressiontrend.inputs.upper diviation": number;
  /** Default value: `true` */
  "linetoolregressiontrend.inputs.use lower diviation": boolean;
  /** Default value: `true` */
  "linetoolregressiontrend.inputs.use upper diviation": boolean;
  /** Default value: `0` */
  "linetoolregressiontrend.linestyle": number;
  /** Default value: `1` */
  "linetoolregressiontrend.linewidth": number;
  /** Default value: `default` */
  "linetoolregressiontrend.precision": string;
  /** Default value: `rgba(242, 54, 69, 0.3)` */
  "linetoolregressiontrend.styles.baseLine.color": string;
  /** Default value: `15` */
  "linetoolregressiontrend.styles.baseLine.display": number;
  /** Default value: `2` */
  "linetoolregressiontrend.styles.baseLine.linestyle": number;
  /** Default value: `1` */
  "linetoolregressiontrend.styles.baseLine.linewidth": number;
  /** Default value: `rgba(41, 98, 255, 0.3)` */
  "linetoolregressiontrend.styles.downLine.color": string;
  /** Default value: `15` */
  "linetoolregressiontrend.styles.downLine.display": number;
  /** Default value: `0` */
  "linetoolregressiontrend.styles.downLine.linestyle": number;
  /** Default value: `2` */
  "linetoolregressiontrend.styles.downLine.linewidth": number;
  /** Default value: `false` */
  "linetoolregressiontrend.styles.extendLines": boolean;
  /** Default value: `true` */
  "linetoolregressiontrend.styles.showPearsons": boolean;
  /** Default value: `70` */
  "linetoolregressiontrend.styles.transparency": number;
  /** Default value: `rgba(41, 98, 255, 0.3)` */
  "linetoolregressiontrend.styles.upLine.color": string;
  /** Default value: `15` */
  "linetoolregressiontrend.styles.upLine.display": number;
  /** Default value: `0` */
  "linetoolregressiontrend.styles.upLine.linestyle": number;
  /** Default value: `2` */
  "linetoolregressiontrend.styles.upLine.linewidth": number;
}
/**
 * Overrides for the 'Relative Strength Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface RelativeStrengthIndexIndicatorOverrides {
  /** Default value: `#7E57C2` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `70` */
  "upperlimit.value": number;
  /** Default value: `-1.1` */
  "upperlimit.zorder": number;
  /** Default value: `#787B86` */
  "middlelimit.color": string;
  /** Default value: `2` */
  "middlelimit.linestyle": number;
  /** Default value: `1` */
  "middlelimit.linewidth": number;
  /** Default value: `true` */
  "middlelimit.visible": boolean;
  /** Default value: `50` */
  "middlelimit.value": number;
  /** Default value: `-1.11` */
  "middlelimit.zorder": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `30` */
  "lowerlimit.value": number;
  /** Default value: `-1.111` */
  "lowerlimit.zorder": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#7E57C2` */
  "plot.color": string;
  /** Default value: `0` */
  "smoothed ma.display": number;
  /** Default value: `0` */
  "smoothed ma.linestyle": number;
  /** Default value: `1` */
  "smoothed ma.linewidth": number;
  /** Default value: `line` */
  "smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "smoothed ma.transparency": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Relative Vigor Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface RelativeVigorIndexIndicatorOverrides {
  /** Default value: `15` */
  "rvgi.display": number;
  /** Default value: `0` */
  "rvgi.linestyle": number;
  /** Default value: `1` */
  "rvgi.linewidth": number;
  /** Default value: `line` */
  "rvgi.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "rvgi.trackprice": boolean;
  /** Default value: `0` */
  "rvgi.transparency": number;
  /** Default value: `#089981` */
  "rvgi.color": string;
  /** Default value: `15` */
  "signal.display": number;
  /** Default value: `0` */
  "signal.linestyle": number;
  /** Default value: `1` */
  "signal.linewidth": number;
  /** Default value: `line` */
  "signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "signal.trackprice": boolean;
  /** Default value: `0` */
  "signal.transparency": number;
  /** Default value: `#F23645` */
  "signal.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Relative Volatility Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface RelativeVolatilityIndexIndicatorOverrides {
  /** Default value: `#7E57C2` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `80` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `20` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#7E57C2` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface RenkoStylePreferences {
  /** Up bar color */
  upColor: string;
  /** Down bar color */
  downColor: string;
  /** Up bar border color */
  borderUpColor: string;
  /** Down bar border color */
  borderDownColor: string;
  /** Projection up bar color */
  upColorProjection: string;
  /** Projection down bar color */
  downColorProjection: string;
  /** Projection up bar border color */
  borderUpColorProjection: string;
  /** Projection down bar border color */
  borderDownColorProjection: string;
  /** Up bar wick color */
  wickUpColor: string;
  /** Down bar wick color */
  wickDownColor: string;
}
export interface RestBrokerConnectionInfo {
  /** URL endpoint */
  url: string;
  /** Access token for the REST API */
  access_token: string;
}
/**
 * Override properties for the Riskrewardlong drawing tool.
 */
export interface RiskrewardlongLineToolOverrides {
  /** Default value: `1000` */
  "linetoolriskrewardlong.accountSize": number;
  /** Default value: `false` */
  "linetoolriskrewardlong.alwaysShowStats": boolean;
  /** Default value: `#667b8b` */
  "linetoolriskrewardlong.borderColor": string;
  /** Default value: `false` */
  "linetoolriskrewardlong.compact": boolean;
  /** Default value: `false` */
  "linetoolriskrewardlong.drawBorder": boolean;
  /** Default value: `true` */
  "linetoolriskrewardlong.fillBackground": boolean;
  /** Default value: `true` */
  "linetoolriskrewardlong.fillLabelBackground": boolean;
  /** Default value: `12` */
  "linetoolriskrewardlong.fontsize": number;
  /** Default value: `#585858` */
  "linetoolriskrewardlong.labelBackgroundColor": string;
  /** Default value: `#787B86` */
  "linetoolriskrewardlong.linecolor": string;
  /** Default value: `1` */
  "linetoolriskrewardlong.linewidth": number;
  /** Default value: `1` */
  "linetoolriskrewardlong.lotSize": number;
  /** Default value: `rgba(8, 153, 129, 0.2)` */
  "linetoolriskrewardlong.profitBackground": string;
  /** Default value: `80` */
  "linetoolriskrewardlong.profitBackgroundTransparency": number;
  /** Default value: `25` */
  "linetoolriskrewardlong.risk": number;
  /** Default value: `percents` */
  "linetoolriskrewardlong.riskDisplayMode": string;
  /** Default value: `true` */
  "linetoolriskrewardlong.showPriceLabels": boolean;
  /** Default value: `rgba(242, 54, 69, 0.2)` */
  "linetoolriskrewardlong.stopBackground": string;
  /** Default value: `80` */
  "linetoolriskrewardlong.stopBackgroundTransparency": number;
  /** Default value: `#ffffff` */
  "linetoolriskrewardlong.textcolor": string;
}
/**
 * Override properties for the Riskrewardshort drawing tool.
 */
export interface RiskrewardshortLineToolOverrides {
  /** Default value: `1000` */
  "linetoolriskrewardshort.accountSize": number;
  /** Default value: `false` */
  "linetoolriskrewardshort.alwaysShowStats": boolean;
  /** Default value: `#667b8b` */
  "linetoolriskrewardshort.borderColor": string;
  /** Default value: `false` */
  "linetoolriskrewardshort.compact": boolean;
  /** Default value: `false` */
  "linetoolriskrewardshort.drawBorder": boolean;
  /** Default value: `true` */
  "linetoolriskrewardshort.fillBackground": boolean;
  /** Default value: `true` */
  "linetoolriskrewardshort.fillLabelBackground": boolean;
  /** Default value: `12` */
  "linetoolriskrewardshort.fontsize": number;
  /** Default value: `#585858` */
  "linetoolriskrewardshort.labelBackgroundColor": string;
  /** Default value: `#787B86` */
  "linetoolriskrewardshort.linecolor": string;
  /** Default value: `1` */
  "linetoolriskrewardshort.linewidth": number;
  /** Default value: `1` */
  "linetoolriskrewardshort.lotSize": number;
  /** Default value: `rgba(8, 153, 129, 0.2)` */
  "linetoolriskrewardshort.profitBackground": string;
  /** Default value: `80` */
  "linetoolriskrewardshort.profitBackgroundTransparency": number;
  /** Default value: `25` */
  "linetoolriskrewardshort.risk": number;
  /** Default value: `percents` */
  "linetoolriskrewardshort.riskDisplayMode": string;
  /** Default value: `true` */
  "linetoolriskrewardshort.showPriceLabels": boolean;
  /** Default value: `rgba(242, 54, 69, 0.2)` */
  "linetoolriskrewardshort.stopBackground": string;
  /** Default value: `80` */
  "linetoolriskrewardshort.stopBackgroundTransparency": number;
  /** Default value: `#ffffff` */
  "linetoolriskrewardshort.textcolor": string;
}
/**
 * Override properties for the Rotatedrectangle drawing tool.
 */
export interface RotatedrectangleLineToolOverrides {
  /** Default value: `rgba(76, 175, 80, 0.2)` */
  "linetoolrotatedrectangle.backgroundColor": string;
  /** Default value: `#4caf50` */
  "linetoolrotatedrectangle.color": string;
  /** Default value: `true` */
  "linetoolrotatedrectangle.fillBackground": boolean;
  /** Default value: `2` */
  "linetoolrotatedrectangle.linewidth": number;
  /** Default value: `50` */
  "linetoolrotatedrectangle.transparency": number;
}
export interface RssNewsFeedInfo {
  /**
   * URL for the RSS feed.
   * Can contain tags in curly brackets that will be replaced by the terminal: `{SYMBOL}`, `{TYPE}`, `{EXCHANGE}`.
   */
  url: string;
  /** Name of the feed to be displayed underneath the news */
  name: string;
}
export interface RssNewsFeedParams {
  /** Default news feed */
  default: RssNewsFeedItem;
  /** Additional news feeds */
  [symbolType: string]: RssNewsFeedItem;
}
/**
 * Overrides for the 'SMI Ergodic Indicator/Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface SMIErgodicIndicatorOscillatorIndicatorOverrides {
  /** Default value: `15` */
  "indicator.display": number;
  /** Default value: `0` */
  "indicator.linestyle": number;
  /** Default value: `1` */
  "indicator.linewidth": number;
  /** Default value: `line` */
  "indicator.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "indicator.trackprice": boolean;
  /** Default value: `0` */
  "indicator.transparency": number;
  /** Default value: `#2196F3` */
  "indicator.color": string;
  /** Default value: `15` */
  "signal.display": number;
  /** Default value: `0` */
  "signal.linestyle": number;
  /** Default value: `1` */
  "signal.linewidth": number;
  /** Default value: `line` */
  "signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "signal.trackprice": boolean;
  /** Default value: `0` */
  "signal.transparency": number;
  /** Default value: `#FF6D00` */
  "signal.color": string;
  /** Default value: `15` */
  "oscillator.display": number;
  /** Default value: `0` */
  "oscillator.linestyle": number;
  /** Default value: `1` */
  "oscillator.linewidth": number;
  /** Default value: `histogram` */
  "oscillator.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "oscillator.trackprice": boolean;
  /** Default value: `0` */
  "oscillator.transparency": number;
  /** Default value: `#FF5252` */
  "oscillator.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Save Chart Options
 */
export interface SaveChartOptions {
  /**
   * Whether drawings should be included in the saved data.
   *
   * @default true
   */
  includeDrawings?: boolean;
}
/**
 * Options: Save Chart to Server
 */
export interface SaveChartToServerOptions {
  /** Name of chart */
  chartName?: string;
  /** Default chart name */
  defaultChartName?: string;
}
export interface SaveLoadChartRecord {
  /** Unique id for chart */
  id: string;
  /** Name of chart */
  name: string;
  /** URL of chart image */
  image_url: string;
  /** Modified ISO number for chart */
  modified_iso: number;
  /** Short symbol name */
  short_symbol: string;
  /** Chart interval */
  interval: ResolutionString;
}
export interface SavedStateMetaInfo {
  /** Unique ID */
  uid: number;
  /** Name of chart */
  name: string;
  /** Chart description */
  description: string;
}
/**
 * Override properties for the Schiffpitchfork2 drawing tool.
 */
export interface Schiffpitchfork2LineToolOverrides {
  /** Default value: `false` */
  "linetoolschiffpitchfork2.extendLines": boolean;
  /** Default value: `true` */
  "linetoolschiffpitchfork2.fillBackground": boolean;
  /** Default value: `0.25` */
  "linetoolschiffpitchfork2.level0.coeff": number;
  /** Default value: `#ffb74d` */
  "linetoolschiffpitchfork2.level0.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level0.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level0.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork2.level0.visible": boolean;
  /** Default value: `0.382` */
  "linetoolschiffpitchfork2.level1.coeff": number;
  /** Default value: `#81c784` */
  "linetoolschiffpitchfork2.level1.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level1.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork2.level1.visible": boolean;
  /** Default value: `0.5` */
  "linetoolschiffpitchfork2.level2.coeff": number;
  /** Default value: `#089981` */
  "linetoolschiffpitchfork2.level2.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolschiffpitchfork2.level2.visible": boolean;
  /** Default value: `0.618` */
  "linetoolschiffpitchfork2.level3.coeff": number;
  /** Default value: `#089981` */
  "linetoolschiffpitchfork2.level3.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level3.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork2.level3.visible": boolean;
  /** Default value: `0.75` */
  "linetoolschiffpitchfork2.level4.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolschiffpitchfork2.level4.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level4.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork2.level4.visible": boolean;
  /** Default value: `1` */
  "linetoolschiffpitchfork2.level5.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolschiffpitchfork2.level5.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolschiffpitchfork2.level5.visible": boolean;
  /** Default value: `1.5` */
  "linetoolschiffpitchfork2.level6.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolschiffpitchfork2.level6.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level6.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork2.level6.visible": boolean;
  /** Default value: `1.75` */
  "linetoolschiffpitchfork2.level7.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolschiffpitchfork2.level7.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level7.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork2.level7.visible": boolean;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level8.coeff": number;
  /** Default value: `#F77C80` */
  "linetoolschiffpitchfork2.level8.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.level8.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork2.level8.visible": boolean;
  /** Default value: `#F23645` */
  "linetoolschiffpitchfork2.median.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork2.median.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork2.median.linewidth": number;
  /** Default value: `true` */
  "linetoolschiffpitchfork2.median.visible": boolean;
  /** Default value: `3` */
  "linetoolschiffpitchfork2.style": number;
  /** Default value: `80` */
  "linetoolschiffpitchfork2.transparency": number;
}
/**
 * Override properties for the Schiffpitchfork drawing tool.
 */
export interface SchiffpitchforkLineToolOverrides {
  /** Default value: `false` */
  "linetoolschiffpitchfork.extendLines": boolean;
  /** Default value: `true` */
  "linetoolschiffpitchfork.fillBackground": boolean;
  /** Default value: `0.25` */
  "linetoolschiffpitchfork.level0.coeff": number;
  /** Default value: `#ffb74d` */
  "linetoolschiffpitchfork.level0.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level0.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level0.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork.level0.visible": boolean;
  /** Default value: `0.382` */
  "linetoolschiffpitchfork.level1.coeff": number;
  /** Default value: `#81c784` */
  "linetoolschiffpitchfork.level1.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level1.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level1.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork.level1.visible": boolean;
  /** Default value: `0.5` */
  "linetoolschiffpitchfork.level2.coeff": number;
  /** Default value: `#089981` */
  "linetoolschiffpitchfork.level2.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level2.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level2.linewidth": number;
  /** Default value: `true` */
  "linetoolschiffpitchfork.level2.visible": boolean;
  /** Default value: `0.618` */
  "linetoolschiffpitchfork.level3.coeff": number;
  /** Default value: `#089981` */
  "linetoolschiffpitchfork.level3.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level3.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level3.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork.level3.visible": boolean;
  /** Default value: `0.75` */
  "linetoolschiffpitchfork.level4.coeff": number;
  /** Default value: `#00bcd4` */
  "linetoolschiffpitchfork.level4.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level4.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level4.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork.level4.visible": boolean;
  /** Default value: `1` */
  "linetoolschiffpitchfork.level5.coeff": number;
  /** Default value: `#2962FF` */
  "linetoolschiffpitchfork.level5.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level5.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level5.linewidth": number;
  /** Default value: `true` */
  "linetoolschiffpitchfork.level5.visible": boolean;
  /** Default value: `1.5` */
  "linetoolschiffpitchfork.level6.coeff": number;
  /** Default value: `#9c27b0` */
  "linetoolschiffpitchfork.level6.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level6.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level6.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork.level6.visible": boolean;
  /** Default value: `1.75` */
  "linetoolschiffpitchfork.level7.coeff": number;
  /** Default value: `#e91e63` */
  "linetoolschiffpitchfork.level7.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level7.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level7.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork.level7.visible": boolean;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level8.coeff": number;
  /** Default value: `#F77C80` */
  "linetoolschiffpitchfork.level8.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.level8.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.level8.linewidth": number;
  /** Default value: `false` */
  "linetoolschiffpitchfork.level8.visible": boolean;
  /** Default value: `#F23645` */
  "linetoolschiffpitchfork.median.color": string;
  /** Default value: `0` */
  "linetoolschiffpitchfork.median.linestyle": number;
  /** Default value: `2` */
  "linetoolschiffpitchfork.median.linewidth": number;
  /** Default value: `true` */
  "linetoolschiffpitchfork.median.visible": boolean;
  /** Default value: `1` */
  "linetoolschiffpitchfork.style": number;
  /** Default value: `80` */
  "linetoolschiffpitchfork.transparency": number;
}
/**
 * [Symbol Search](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Symbol-Search) result item.
 * Pass the resulting array of symbols as a parameter to {@link SearchSymbolsCallback} of the [`searchSymbols`](https://www.tradingview.com/charting-library-docs/latest/connecting_data/Datafeed-API#searchsymbols) method.
 *
 * @example
 * ```
 * {
 * 	description: 'Apple Inc.',
 * 	exchange: 'NasdaqNM',
 * 	full_name: 'NasdaqNM:AAPL',
 * 	symbol: 'AAPL',
 * 	ticker: 'AAPL',
 * 	type: 'stock',
 * }
 * ```
 */
export interface SearchSymbolResultItem {
  /** Short symbol name */
  symbol: string;
  /** Full symbol name  */
  full_name: string;
  /** Description */
  description: string;
  /** Exchange name */
  exchange: string;
  /** Symbol ticker name. Should be an unique id */
  ticker?: string;
  /**
   * Type of symbol
   *
   * 'stock' | 'futures' | 'forex' | 'index'
   */
  type: string;
  /**
   * URL of image/s to be displayed as the logo/s for the symbol. The `show_symbol_logos` featureset needs to be enabled for this to be visible in the UI.
   *
   * - If a single url is returned then that url will solely be used to display the symbol logo.
   * - If two urls are provided then the images will be displayed as two partially overlapping
   * circles with the first url appearing on top. This is typically used for FOREX where you would
   * like to display two country flags as the symbol logo.
   *
   * The image/s should ideally be square in dimension. You can use any image type which
   * the browser supports natively. Simple SVG images are recommended.
   *
   * Examples:
   * - `https://yourserver.com/symbolName.svg`
   * - `/images/myImage.png`
   * - `data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3...`
   * - `data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAASABIAAD/4...`
   */
  logo_urls?: [string] | [string, string];
  /**
   * URL of image to be displayed as the logo for the exchange. The `show_exchange_logos` featureset needs to be enabled for this to be visible in the UI.
   *
   * The image should ideally be square in dimension. You can use any image type which
   * the browser supports natively. Simple SVG images are recommended.
   *
   * Examples:
   * - `https://yourserver.com/exchangeLogo.svg`
   * - `/images/myImage.png`
   * - `data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3...`
   * - `data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAASABIAAD/4...`
   */
  exchange_logo?: string;
}
/**
 * Description of a series field.
 * This is used when `includeSeries: true` is defined in `exportData`.
 */
export interface SeriesFieldDescriptor {
  /** Type is a `value` */
  type: "value";
  /** Source type is a `series` */
  sourceType: "series";
  /** The name of the plot (open, high, low, close) */
  plotTitle: string;
  /** Title of the series */
  sourceTitle: string;
}
/**
 * Style preferences map for the chart types
 */
export interface SeriesPreferencesMap {
  /** Bar Style Preferences */
  [ChartStyle.Bar]: BarStylePreferences;
  /** Candle Style Preferences */
  [ChartStyle.Candle]: CandleStylePreferences;
  /** Line Style Preferences */
  [ChartStyle.Line]: LineStylePreferences;
  /** Line With Markers Style Preferences */
  [ChartStyle.LineWithMarkers]: LineStylePreferences;
  /** Step Line Style Preferences */
  [ChartStyle.Stepline]: LineStylePreferences;
  /** Area Style Preferences */
  [ChartStyle.Area]: AreaStylePreferences;
  /** HLC Area Style Preferences */
  [ChartStyle.HLCArea]: HLCAreaStylePreferences;
  /** Renko Style Preferences */
  [ChartStyle.Renko]: RenkoStylePreferences;
  /** Kagi Style Preferences */
  [ChartStyle.Kagi]: KagiStylePreferences;
  /** Point and Figure Style Preferences */
  [ChartStyle.PnF]: PnFStylePreferences;
  /** Line Break Style Preferences */
  [ChartStyle.LineBreak]: LineBreakStylePreferences;
  /** Heikin Ashi Style Preferences */
  [ChartStyle.HeikinAshi]: HeikinAshiStylePreferences;
  /** Hollow Candle Style Preferences */
  [ChartStyle.HollowCandle]: HollowCandleStylePreferences;
  /** Baseline Style Preferences */
  [ChartStyle.Baseline]: BaselineStylePreferences;
  /** High-Low Style Preferences */
  [ChartStyle.HiLo]: HiLoStylePreferences;
  /** Columns Style Preferences */
  [ChartStyle.Column]: ColumnStylePreferences;
}
/**
 * Overrides for the 'Sessions' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface SessionsIndicatorOverrides {
  [key: string]: StudyOverrideValueType;
}
/**
 * Options for setting a chart's resolution.
 */
export interface SetResolutionOptions {
  /**
   * An optional callback function. Called when the data for the new resolution has loaded.
   */
  dataReady?: () => void;
  /**
   * A boolean flag. Allows to disable making the current chart active in the layout.
   */
  doNotActivateChart?: boolean;
}
/**
 * Options for setting a chart's symbol.
 */
export interface SetSymbolOptions {
  /**
   * An optional callback function. Called when the data for the new symbol has loaded.
   */
  dataReady?: () => void;
  /**
   * A boolean flag. Allows to disable making the current chart active in the layout.
   */
  doNotActivateChart?: boolean;
}
/**
 * Options for setting the visible range.
 *
 * Setting `applyDefaultRightMargin` or `percentRightMargin` will result in the `to` value
 * of the range specified being ignored and the timestamp of the latest bar on the chart
 * being used instead.
 */
export interface SetVisibleRangeOptions {
  /**
   * Apply the default right offset (margin) when setting the range.
   */
  applyDefaultRightMargin?: boolean;
  /**
   * Apply a percentage right offset (margin) when setting the range.
   */
  percentRightMargin?: number;
}
/**
 * Override properties for the Signpost drawing tool.
 */
export interface SignpostLineToolOverrides {
  /** Default value: `false` */
  "linetoolsignpost.bold": boolean;
  /** Default value: `🙂` */
  "linetoolsignpost.emoji": string;
  /** Default value: `12` */
  "linetoolsignpost.fontSize": number;
  /** Default value: `false` */
  "linetoolsignpost.italic": boolean;
  /** Default value: `1` */
  "linetoolsignpost.itemType": number;
  /** Default value: `#2962FF` */
  "linetoolsignpost.plateColor": string;
  /** Default value: `false` */
  "linetoolsignpost.showImage": boolean;
}
/**
 * Override properties for the Sineline drawing tool.
 */
export interface SinelineLineToolOverrides {
  /** Default value: `#159980` */
  "linetoolsineline.linecolor": string;
  /** Default value: `0` */
  "linetoolsineline.linestyle": number;
  /** Default value: `2` */
  "linetoolsineline.linewidth": number;
}
export interface SingleBrokerMetaInfo {
  /**
   * Broker Configuration Flags
   */
  configFlags: BrokerConfigFlags;
  /**
   * Optional field. You can use it if you have custom fields in orders or positions that should be taken into account when showing notifications.
   *
   * @example
   * if you have field `additionalType` in orders and you want the chart to show a notification when it is changed, you should set:
   * ```javascript
   * customNotificationFields: ['additionalType']
   * ```
   */
  customNotificationFields?: string[];
  /**
   * List of order duration options that determine how long the order remains active.
   * Specifying `durations` enables a drop-down menu in the Order Ticket for supported orders.
   * Refer to [Set order duration](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/order-ticket.md#set-order-duration) for more information.
   *
   * The objects have the following keys: `{ name, value, hasDatePicker?, hasTimePicker?, default?, supportedOrderTypes? }`.
   */
  durations?: OrderDurationMetaInfo[];
  /**
   * Order Rules
   */
  orderRules?: OrderRule[];
  /**
   * This optional field can be used to replace the standard Order Ticket and the Add Protection dialogs with your own.
   * Values of the following two fields are functions that are called by the Trading Platform to show the dialogs. Each function shows a dialog and returns a `Promise` object that should be resolved when the operation is finished or cancelled.
   *
   * **NOTE:** The returned `Promise` object should be resolved with either `true` or `false` value.
   *
   * @example
   * ```ts
   * customUI: {
   *     showOrderDialog?: (order: Order, focus?: OrderTicketFocusControl) => Promise<boolean>;
   *     showPositionDialog?: (position: Position | IndividualPosition, brackets: Brackets, focus?: OrderTicketFocusControl) => Promise<boolean>;
   *     showCancelOrderDialog?: (order: Order) => Promise<boolean>;
   *     showClosePositionDialog?: (position: Position) => Promise<boolean>;
   * }
   * ```
   */
  customUI?: BrokerCustomUI;
}
/**
 * Overrides for the 'Smoothed Moving Average' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface SmoothedMovingAverageIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#673AB7` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface SortingParameters {
  /** `property` of the data object that will be used for sorting */
  property: string;
  /** Ascending sorting order (default `true`) - If it is `false`, then initial sorting will be in descending order */
  asc?: boolean;
}
/**
 * Overrides for the 'Spread' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface SpreadIndicatorOverrides {
  /** Default value: `0` */
  "negative fill.transparency": number;
  /** Default value: `true` */
  "negative fill.visible": boolean;
  /** Default value: `0` */
  "positive fill.transparency": number;
  /** Default value: `true` */
  "positive fill.visible": boolean;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `2` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `35` */
  "plot.transparency": number;
  /** Default value: `#800080` */
  "plot.color": string;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "baseline.linestyle": number;
  /** Default value: `2` */
  "baseline.linewidth": number;
  /** Default value: `line` */
  "baseline.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "baseline.trackprice": boolean;
  /** Default value: `0` */
  "baseline.transparency": number;
  /** Default value: `rgba(0, 0, 0, 0)` */
  "baseline.color": string;
  /** Default value: `0` */
  "baseline.display": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Standard Deviation' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface StandardDeviationIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#089981` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Standard Error Bands' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface StandardErrorBandsIndicatorOverrides {
  /** Default value: `#2196F3` */
  "background.color": string;
  /** Default value: `95` */
  "background.transparency": number;
  /** Default value: `true` */
  "background.visible": boolean;
  /** Default value: `15` */
  "plot 1.display": number;
  /** Default value: `0` */
  "plot 1.linestyle": number;
  /** Default value: `1` */
  "plot 1.linewidth": number;
  /** Default value: `line` */
  "plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "plot 1.transparency": number;
  /** Default value: `false` */
  "plot 1.trackprice": boolean;
  /** Default value: `#2196F3` */
  "plot 1.color": string;
  /** Default value: `15` */
  "plot 2.display": number;
  /** Default value: `0` */
  "plot 2.linestyle": number;
  /** Default value: `1` */
  "plot 2.linewidth": number;
  /** Default value: `0` */
  "plot 2.transparency": number;
  /** Default value: `line` */
  "plot 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 2.trackprice": boolean;
  /** Default value: `#FF6D00` */
  "plot 2.color": string;
  /** Default value: `15` */
  "plot 3.display": number;
  /** Default value: `0` */
  "plot 3.linestyle": number;
  /** Default value: `1` */
  "plot 3.linewidth": number;
  /** Default value: `0` */
  "plot 3.transparency": number;
  /** Default value: `line` */
  "plot 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot 3.trackprice": boolean;
  /** Default value: `#2196F3` */
  "plot 3.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Standard Error' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface StandardErrorIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF6D00` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * The interface that describes the mapping of values in the {@link AccountManagerColumnBase.formatter} and {@link AccountManagerColumnBase.dataFields} properties of the Account Manager columns.
 * Refer to the [Value formatters](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/account-manager/value-formatters.md) section for more information.
 */

export interface StandardFormattersDependenciesMapping {
  [StandardFormatterName.Default]: string[];
  [StandardFormatterName.Symbol]:
    | [brokerSymbolProperty: string, symbolProperty: string, message: string]
    | [brokerSymbolProperty: string, symbolProperty: string];
  [StandardFormatterName.Side]: [sideProperty: string];
  [StandardFormatterName.PositionSide]: [sideProperty: string];
  [StandardFormatterName.Text]: string[];
  [StandardFormatterName.Type]: [
    orderTypeProperty: string,
    parentIdProperty: string,
    stopTypeProperty: string
  ];
  [StandardFormatterName.FormatPrice]: [priceProperty: string];
  [StandardFormatterName.FormatPriceForexSup]: [priceProperty: string];
  [StandardFormatterName.Status]: [statusProperty: string];
  [StandardFormatterName.Date]: [dateProperty: string];
  [StandardFormatterName.LocalDate]: [dateProperty: string];
  [StandardFormatterName.DateOrDateTime]: [dateProperty: string];
  [StandardFormatterName.LocalDateOrDateTime]: [dateProperty: string];
  [StandardFormatterName.Fixed]: [valueProperty: string];
  [StandardFormatterName.FixedInCurrency]: [
    valueProperty: string,
    currencyProperty: string
  ];
  [StandardFormatterName.VariablePrecision]: [valueProperty: string];
  [StandardFormatterName.Pips]: [pipsProperty: string];
  [StandardFormatterName.IntegerSeparated]: [valueProperty: string];
  [StandardFormatterName.FormatQuantity]: [qtyProperty: string];
  [StandardFormatterName.Profit]: [profitProperty: string];
  [StandardFormatterName.ProfitInInstrumentCurrency]: [
    profitProperty: string,
    currencyProperty: string
  ];
  [StandardFormatterName.Percentage]: [valueProperty: string];
  [StandardFormatterName.MarginPercent]: [valueProperty: string];
  [StandardFormatterName.Empty]: [];
}

/**
 * Position defined by an OHLC price on a bar at a specified time.
 */
export interface StickedPoint extends TimePoint {
  /** Candle stick value to 'stick' on */
  channel: "open" | "high" | "low" | "close";
}
/**
 * Override properties for the Sticker drawing tool.
 */
export interface StickerLineToolOverrides {
  /** Default value: `1.5707963267948966` */
  "linetoolsticker.angle": number;
  /** Default value: `110` */
  "linetoolsticker.size": number;
  /** Default value: `bitcoin` */
  "linetoolsticker.sticker": string;
}
/**
 * Overrides for the 'Stochastic' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface StochasticIndicatorOverrides {
  /** Default value: `#2196F3` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `80` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `20` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "%k.display": number;
  /** Default value: `0` */
  "%k.linestyle": number;
  /** Default value: `1` */
  "%k.linewidth": number;
  /** Default value: `line` */
  "%k.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "%k.trackprice": boolean;
  /** Default value: `0` */
  "%k.transparency": number;
  /** Default value: `#2196F3` */
  "%k.color": string;
  /** Default value: `15` */
  "%d.display": number;
  /** Default value: `0` */
  "%d.linestyle": number;
  /** Default value: `1` */
  "%d.linewidth": number;
  /** Default value: `line` */
  "%d.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "%d.trackprice": boolean;
  /** Default value: `0` */
  "%d.transparency": number;
  /** Default value: `#FF6D00` */
  "%d.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Stochastic RSI' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface StochasticRSIIndicatorOverrides {
  /** Default value: `#2196F3` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `80` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `20` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "%k.display": number;
  /** Default value: `0` */
  "%k.linestyle": number;
  /** Default value: `1` */
  "%k.linewidth": number;
  /** Default value: `line` */
  "%k.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "%k.trackprice": boolean;
  /** Default value: `0` */
  "%k.transparency": number;
  /** Default value: `#2196F3` */
  "%k.color": string;
  /** Default value: `15` */
  "%d.display": number;
  /** Default value: `0` */
  "%d.linestyle": number;
  /** Default value: `1` */
  "%d.linewidth": number;
  /** Default value: `line` */
  "%d.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "%d.trackprice": boolean;
  /** Default value: `0` */
  "%d.transparency": number;
  /** Default value: `#FF6D00` */
  "%d.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * A description of a study arrows plot.
 */
export interface StudyArrowsPlotInfo extends StudyPlotBaseInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.Arrows;
}
/**
 * Study arrow plot style preferences.
 */
export interface StudyArrowsPlotPreferences extends StudyPlotBasePreferences {
  /**
   * Up arrow color.
   */
  colorup: string;
  /**
   * Down arrow color.
   */
  colordown: string;
  /**
   * Minimum arrow height.
   */
  minHeight?: number;
  /**
   * Maximum arrow height.
   */
  maxHeight?: number;
}
/**
 * Preferences for adjusting the visual appearance of the background of a band area.
 */
export interface StudyBandBackgroundPreferences {
  /** Background color for the Band area */
  backgroundColor: string;
  /** Transparency of the band area */
  transparency: number;
  /** Whether the background area should be filled with the `backgroundColor` */
  fillBackground: boolean;
}
/**
 * A description of a study band.
 */
export interface StudyBandInfo {
  /**
   * Band ID. Used in {@link StudyFilledAreaInfo.objAId} and {@link StudyFilledAreaInfo.objBId}.
   *
   * @see StudyFilledAreaInfo
   */
  readonly id?: string;
  /**
   * Band name.
   */
  readonly name: string;
  /**
   * Band style inputs visibility flag. Used to hide the band from the style tab of study properties dialogs.
   */
  readonly isHidden?: boolean;
  /**
   * Band z-order.
   */
  readonly zorder?: number;
}
/**
 * Study band style preferences.
 */
export interface StudyBandPreferences extends StudyBandStyle, StudyBandInfo {}
/**
 * Study band style preferences.
 */
export interface StudyBandStyle {
  /**
   * Color.
   *
   * @example '#ffffff'.
   */
  color: string;
  /**
   * Line style.
   *
   * @example 2 // Dotted line.
   */
  linestyle: number;
  /**
   * Line width.
   */
  linewidth: number;
  /**
   * Value at which the band will be drawn.
   *
   * @example 75 // Drawn at price = 75.
   */
  value: number;
  /**
   * Band visibility flag.
   */
  visible: boolean;
}
/**
 * A description of a bar colorer plot.
 */
export interface StudyBarColorerPlotInfo extends StudyPalettedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.BarColorer;
}
export interface StudyBarTimeInputInfo extends StudyInputBaseInfo {
  /** Input type is BarTime */
  readonly type: StudyInputType.BarTime;
  /** Default value */
  readonly defval: number;
  /** Maximum time */
  readonly max: number;
  /** Minimum time */
  readonly min: number;
}
/**
 * A description of a background colorer plot.
 */
export interface StudyBgColorerPlotInfo extends StudyPalettedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.BgColorer;
}
export interface StudyBooleanInputInfo extends StudyInputBaseInfo {
  /** Input type is Boolean */
  readonly type: StudyInputType.Bool;
  /** Default value for the input */
  readonly defval: boolean;
}
/**
 * A description of a border colorer plot.
 */
export interface StudyCandleBorderColorerPlotInfo
  extends StudyPalettedPlotInfo,
    StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.CandleBorderColorer;
}
/**
 * A description of a wick colorer plot.
 */
export interface StudyCandleWickColorerPlotInfo
  extends StudyPalettedPlotInfo,
    StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.CandleWickColorer;
}
/**
 * A description of a study characters plot.
 */
export interface StudyCharsPlotInfo extends StudyPlotBaseInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.Chars;
}
export interface StudyCharsPlotPreferences extends StudyPlotBasePreferences {
  /** Character */
  char?: string;
  /** Location for the mark */
  location: MarkLocation;
  /** Color */
  color: string;
  /** Text color */
  textColor: string;
}
export interface StudyColorInputInfo extends StudyInputBaseInfo {
  /** Input type is Color */
  readonly type: StudyInputType.Color;
  /** Default value for the input */
  readonly defval: string;
}
/**
 * A description of a colorer plot.
 */
export interface StudyColorerPlotInfo
  extends StudyPalettedPlotInfo,
    StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.Colorer;
}
/**
 * A description of a study data offset plot.
 */
export interface StudyDataOffsetPlotInfo extends StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.DataOffset;
}
/**
 * A description of a study data plot.
 */
export interface StudyDataPlotInfo extends StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.Data;
}
export interface StudyDefaults {
  /** Defaults for the area background */
  areaBackground: StudyBandBackgroundPreferences;
  /** Defaults for the bands background */
  bandsBackground: StudyBandBackgroundPreferences;
  /** Defaults for the bands */
  bands: readonly Required<StudyBandStyle>[];
  /** Defaults for the filled area styles */
  filledAreasStyle: MappedObject<StudyFilledAreaStyle>;
  /** Defaults for the study inputs */
  inputs: StudyInputsSimple;
  /** Defaults for the study palette styles */
  palettes: MappedObject<StudyPaletteStyle>;
  /** Default for the study precision */
  precision: number | string;
  /** Defaults for the study styles */
  styles: MappedObject<StudyPlotPreferences>;
  /** Defaults for the OHLC plots */
  ohlcPlots: MappedObject<StudyOhlcPlotPreferences>;
  /** Defaults for the study graphics */
  graphics: StudyGraphicsDefaults;
}
/**
 * A description of a down colorer plot.
 */
export interface StudyDownColorerPlotInfo
  extends StudyPalettedPlotInfo,
    StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.DownColorer;
}
/**
 * Description of a study field.
 * This is used when `includedStudies: true` is defined in `exportData`.
 */
export interface StudyFieldDescriptor {
  /** Type is a `value` */
  type: "value";
  /** Source type is a `study` */
  sourceType: "study";
  /**
   * The ID of the source study.
   */
  sourceId: string;
  /**
   * The title of the source study.
   */
  sourceTitle: string;
  /**
   * The title of the source plot.
   */
  plotTitle: string;
}
/**
 * Study filled area gradient styles.
 */
export interface StudyFilledAreaGradientColorStyle
  extends StudyFilledAreaStyleBase {
  /** Gradient fill type */
  fillType: "gradient";
  /**
   * Gradient top color.
   */
  topColor?: string;
  /**
   * Gradient bottom color.
   */
  bottomColor?: string;
  /**
   * Value at which the top of the gradient is drawn.
   *
   * @example 75 // Drawn at price = 75
   */
  topValue?: number;
  /**
   * Value at which the bottom of the gradient is drawn.
   *
   * @example 75 // Drawn at price = 75
   */
  bottomValue?: number;
}
/**
 * A description of a study filled area.
 */
export interface StudyFilledAreaInfo {
  /**
   * Study ID.
   */
  readonly id: string;
  /**
   * Study band ID.
   *
   * @see StudyBandInfo
   */
  readonly objAId: string;
  /**
   * Study band ID.
   *
   * @see StudyBandInfo
   */
  readonly objBId: string;
  /**
   * Title that will appear in the styles tab of the study settings dialog.
   */
  readonly title: string;
  /**
   * Filled area type.
   */
  readonly type: FilledAreaType;
  /**
   * Should gaps in the area be filled?
   */
  readonly fillgaps?: boolean;
  /**
   * Filled area z-order.
   */
  readonly zorder?: number;
  /**
   * Filled area's style inputs visibility flag. Used to hide the band from the style tab of study properties dialogs.
   */
  readonly isHidden?: boolean;
  /**
   * Color palette ID.
   */
  readonly palette?: string;
  /**
   * Value at which the top of the filled area is drawn.
   *
   * @example 75 // Drawn at price = 75
   */
  readonly topValue?: number;
  /**
   * Value at which the bottom of the filled area is drawn.
   *
   * @example 75 // Drawn at price = 75
   */
  readonly bottomValue?: number;
  /**
   * Color for the top of the filled area.
   */
  readonly topColor?: string;
  /**
   * Color for the bottom of the filled area.
   */
  readonly bottomColor?: string;
  /**
   * Should the area be filled up to the point that two plots intersect, instead of by plot index?
   *
   * Used for plot_plot filled area types.
   */
  readonly fillToIntersection?: boolean;
}
/**
 * Study solid color filled area style preferences.
 */
export interface StudyFilledAreaSolidColorStyle
  extends StudyFilledAreaStyleBase {
  /** Solid Fill type */
  fillType: undefined;
  /**
   * Color.
   *
   * @example '#ffffff'
   */
  color: string;
}
/**
 * Base study filled area style preferences.
 */
export interface StudyFilledAreaStyleBase {
  /**
   * Filled area's visibility.
   */
  visible: boolean;
  /**
   * Filled area's transparency.
   *
   * @min 0
   * @max 100
   */
  transparency: number;
}
export interface StudyGraphicsDefaults {
  /** Defaults for the horizontal lines study graphics */
  horizlines?: ValueByStyleId<HorizLinePreferences>;
  /** Defaults for the polygon study graphics */
  polygons?: ValueByStyleId<PolygonPreferences>;
  /** Defaults for the horizontal histogram study graphics */
  hhists?: ValueByStyleId<HHistPreferences>;
  /** Defaults for the vertical lines study graphics */
  vertlines?: ValueByStyleId<VertLinePreferences>;
}
export interface StudyInputBaseInfo {
  /** Id for the input */
  readonly id: string;
  /** Title of the input */
  readonly name: string;
  /** default value of the input variable. It has the specific type for a given input and can be optional. */
  readonly defval?: StudyInputValue;
  /** Input type */
  readonly type: StudyInputType;
  /** if true, then user will be asked to confirm input value before indicator is added to chart. Default value is false. */
  readonly confirm?: boolean;
  /** Is the input hidden */
  readonly isHidden?: boolean;
  /** Is the input visible */
  readonly visible?: string;
  /** An array of plot ids, upon the hiding of which, this input should also be hidden within the legend */
  readonly hideWhenPlotsHidden?: string[];
}
/**
 * A description of a study input.
 */
export interface StudyInputInformation {
  /**
   * The input ID.
   */
  id: StudyInputId;
  /**
   * The input name.
   */
  name: string;
  /**
   * The input type.
   */
  type: string;
  /**
   * The localized input name.
   */
  localizedName: string;
}
export interface StudyInputOptionsTitles {
  [option: string]: string;
}
/**
 * A description of a study input value.
 */
export interface StudyInputValueItem {
  /**
   * The input ID.
   */
  id: StudyInputId;
  /**
   * The input value.
   */
  value: StudyInputValue;
}
export interface StudyInputsSimple {
  [inputId: string]: StudyInputValue;
}
/**
 * A description of a study line plot.
 */
export interface StudyLinePlotInfo extends StudyPlotBaseInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.Line;
}
/**
 * Study line plot style preferences.
 */
export interface StudyLinePlotPreferences extends StudyPlotBasePreferences {
  /**
   * Plot style.
   */
  plottype: LineStudyPlotStyle;
  /**
   * Line color.
   */
  color: string;
  /**
   * Line style.
   */
  linestyle: LineStyle;
  /**
   * Line width.
   */
  linewidth: number;
  /**
   * Price line visibility flag.
   */
  trackPrice: boolean;
  /**
   * If defined, defines the number of bars to plot on chart.
   */
  readonly showLast?: number;
}
export interface StudyNumericInputInfo extends StudyInputBaseInfo {
  /** Input type is Numeric */
  readonly type:
    | StudyInputType.Integer
    | StudyInputType.Float
    | StudyInputType.Price;
  /** Default value */
  readonly defval: number;
  /** Maximum value */
  readonly max?: number;
  /** Minimum value */
  readonly min?: number;
  /** Step size for value */
  readonly step?: number;
}
/**
 * A description of an OHLC colorer plot.
 */
export interface StudyOhlcColorerPlotInfo
  extends StudyPalettedPlotInfo,
    StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.OhlcColorer;
}
export interface StudyOhlcPlotBarsStylePreferences
  extends StudyOhlcPlotBaseStylePreferences {
  /** OHLC Plot type: Bars */
  plottype: OhlcStudyPlotStyle.OhlcBars;
}
export interface StudyOhlcPlotBaseStylePreferences {
  /** OHLC plot color */
  color: string;
  /** Bitmask with values from StudyPlotDisplayTarget */
  display: StudyPlotDisplayMode;
  /** Visibility */
  visible?: boolean;
}
export interface StudyOhlcPlotCandlesStylePreferences
  extends StudyOhlcPlotBaseStylePreferences {
  /** OHLC Plot Type: Candles */
  plottype: OhlcStudyPlotStyle.OhlcCandles;
  /** Whether to draw candle wick */
  drawWick: boolean;
  /** Whether to draw candle border */
  drawBorder: boolean;
  /** Candle wick color */
  wickColor: string;
  /** Candle border color */
  borderColor: string;
}
/**
 * A description of an OHLC plot.
 */
export interface StudyOhlcPlotInfo extends StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type:
    | StudyPlotType.OhlcOpen
    | StudyPlotType.OhlcHigh
    | StudyPlotType.OhlcLow
    | StudyPlotType.OhlcClose;
}
export interface StudyOhlcStylesInfo {
  /** Title */
  readonly title: string;
  /** Is hidden */
  readonly isHidden?: boolean;
  /** Draw border for OHLC candles */
  readonly drawBorder?: boolean;
  /** Show last value */
  readonly showLast?: number;
  /**
   * Info about the Price Scale formatting
   */
  readonly format?: Partial<StudyPlotValuePrecisionFormat>;
}
/**
 * Parameter object passed to event callback.
 */
export interface StudyOrDrawingAddedToChartEventParams {
  /**
   * Name of the added study or drawing.
   */
  value: string;
}
/**
 * Indicator overrides.
 * See [Indicator Overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md).
 *
 * Use these properties to specify default indicator style via {@link ChartingLibraryWidgetOptions.studies_overrides} and {@link IChartingLibraryWidget.applyStudiesOverrides}.
 */
export interface StudyOverrides {
  /**
   * - Default value: `close`
   * - Input type: `text`
   * - Options: `["close","high"]`
   */
  "52 week high/low.high source": string;
  /**
   * - Default value: `close`
   * - Input type: `text`
   * - Options: `["close","low"]`
   */
  "52 week high/low.low source": string;
  /** Default value: `15` */
  "accelerator oscillator.plot.display": number;
  /** Default value: `0` */
  "accelerator oscillator.plot.linestyle": number;
  /** Default value: `1` */
  "accelerator oscillator.plot.linewidth": number;
  /** Default value: `histogram` */
  "accelerator oscillator.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "accelerator oscillator.plot.trackprice": boolean;
  /** Default value: `0` */
  "accelerator oscillator.plot.transparency": number;
  /** Default value: `#000080` */
  "accelerator oscillator.plot.color": string;
  /** Default value: `15` */
  "accumulation/distribution.plot.display": number;
  /** Default value: `0` */
  "accumulation/distribution.plot.linestyle": number;
  /** Default value: `1` */
  "accumulation/distribution.plot.linewidth": number;
  /** Default value: `line` */
  "accumulation/distribution.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "accumulation/distribution.plot.trackprice": boolean;
  /** Default value: `0` */
  "accumulation/distribution.plot.transparency": number;
  /** Default value: `#2196F3` */
  "accumulation/distribution.plot.color": string;
  /** Default value: `15` */
  "accumulative swing index.asi.display": number;
  /** Default value: `0` */
  "accumulative swing index.asi.linestyle": number;
  /** Default value: `1` */
  "accumulative swing index.asi.linewidth": number;
  /** Default value: `line` */
  "accumulative swing index.asi.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "accumulative swing index.asi.trackprice": boolean;
  /** Default value: `0` */
  "accumulative swing index.asi.transparency": number;
  /** Default value: `#2196F3` */
  "accumulative swing index.asi.color": string;
  /**
   * - Default value: `10`
   * - Input type: `float`
   * - Min: `0.1`
   * - Max: `100000`
   */
  "accumulative swing index.limit move value": number;
  /** Default value: `15` */
  "advance/decline.plot.display": number;
  /** Default value: `0` */
  "advance/decline.plot.linestyle": number;
  /** Default value: `1` */
  "advance/decline.plot.linewidth": number;
  /** Default value: `line` */
  "advance/decline.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "advance/decline.plot.trackprice": boolean;
  /** Default value: `0` */
  "advance/decline.plot.transparency": number;
  /** Default value: `#2196F3` */
  "advance/decline.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "advance/decline.length": number;
  /** Default value: `15` */
  "anchored vwap.vwap.display": number;
  /** Default value: `#1e88e5` */
  "anchored vwap.vwap.color": string;
  /** Default value: `0` */
  "anchored vwap.vwap.linestyle": number;
  /** Default value: `1` */
  "anchored vwap.vwap.linewidth": number;
  /** Default value: `line` */
  "anchored vwap.vwap.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "anchored vwap.vwap.trackprice": boolean;
  /** Default value: `0` */
  "anchored vwap.vwap.transparency": number;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "anchored vwap.start time": number;
  /**
   * - Default value: `hlc3`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "anchored vwap.source": string;
  /** Default value: `15` */
  "arnaud legoux moving average.plot.display": number;
  /** Default value: `0` */
  "arnaud legoux moving average.plot.linestyle": number;
  /** Default value: `1` */
  "arnaud legoux moving average.plot.linewidth": number;
  /** Default value: `line` */
  "arnaud legoux moving average.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "arnaud legoux moving average.plot.trackprice": boolean;
  /** Default value: `0` */
  "arnaud legoux moving average.plot.transparency": number;
  /** Default value: `#2196F3` */
  "arnaud legoux moving average.plot.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `0`
   * - Max: `5000`
   */
  "arnaud legoux moving average.window size": number;
  /**
   * - Default value: `0.85`
   * - Input type: `float`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "arnaud legoux moving average.offset": number;
  /**
   * - Default value: `6`
   * - Input type: `float`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "arnaud legoux moving average.sigma": number;
  /** Default value: `15` */
  "aroon.upper.display": number;
  /** Default value: `0` */
  "aroon.upper.linestyle": number;
  /** Default value: `1` */
  "aroon.upper.linewidth": number;
  /** Default value: `line` */
  "aroon.upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "aroon.upper.trackprice": boolean;
  /** Default value: `0` */
  "aroon.upper.transparency": number;
  /** Default value: `#FB8C00` */
  "aroon.upper.color": string;
  /** Default value: `15` */
  "aroon.lower.display": number;
  /** Default value: `0` */
  "aroon.lower.linestyle": number;
  /** Default value: `1` */
  "aroon.lower.linewidth": number;
  /** Default value: `line` */
  "aroon.lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "aroon.lower.trackprice": boolean;
  /** Default value: `0` */
  "aroon.lower.transparency": number;
  /** Default value: `#2196F3` */
  "aroon.lower.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "aroon.length": number;
  /** Default value: `15` */
  "average directional index.adx.display": number;
  /** Default value: `0` */
  "average directional index.adx.linestyle": number;
  /** Default value: `1` */
  "average directional index.adx.linewidth": number;
  /** Default value: `line` */
  "average directional index.adx.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "average directional index.adx.trackprice": boolean;
  /** Default value: `0` */
  "average directional index.adx.transparency": number;
  /** Default value: `#FF5252` */
  "average directional index.adx.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "average directional index.adx smoothing": number;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "average directional index.di length": number;
  /** Default value: `15` */
  "average price.plot.display": number;
  /** Default value: `0` */
  "average price.plot.linestyle": number;
  /** Default value: `1` */
  "average price.plot.linewidth": number;
  /** Default value: `line` */
  "average price.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "average price.plot.trackprice": boolean;
  /** Default value: `0` */
  "average price.plot.transparency": number;
  /** Default value: `#2196F3` */
  "average price.plot.color": string;
  /** Default value: `15` */
  "average true range.plot.display": number;
  /** Default value: `0` */
  "average true range.plot.linestyle": number;
  /** Default value: `1` */
  "average true range.plot.linewidth": number;
  /** Default value: `line` */
  "average true range.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "average true range.plot.trackprice": boolean;
  /** Default value: `0` */
  "average true range.plot.transparency": number;
  /** Default value: `#801922` */
  "average true range.plot.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "average true range.length": number;
  /** Default value: `15` */
  "awesome oscillator.plot.display": number;
  /** Default value: `0` */
  "awesome oscillator.plot.linestyle": number;
  /** Default value: `1` */
  "awesome oscillator.plot.linewidth": number;
  /** Default value: `histogram` */
  "awesome oscillator.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "awesome oscillator.plot.trackprice": boolean;
  /** Default value: `0` */
  "awesome oscillator.plot.transparency": number;
  /** Default value: `#000080` */
  "awesome oscillator.plot.color": string;
  /** Default value: `15` */
  "balance of power.plot.display": number;
  /** Default value: `0` */
  "balance of power.plot.linestyle": number;
  /** Default value: `1` */
  "balance of power.plot.linewidth": number;
  /** Default value: `line` */
  "balance of power.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "balance of power.plot.trackprice": boolean;
  /** Default value: `0` */
  "balance of power.plot.transparency": number;
  /** Default value: `#FF5252` */
  "balance of power.plot.color": string;
  /** Default value: `#2196F3` */
  "bollinger bands.plots background.color": string;
  /** Default value: `95` */
  "bollinger bands.plots background.transparency": number;
  /** Default value: `true` */
  "bollinger bands.plots background.visible": boolean;
  /** Default value: `15` */
  "bollinger bands.median.display": number;
  /** Default value: `0` */
  "bollinger bands.median.linestyle": number;
  /** Default value: `1` */
  "bollinger bands.median.linewidth": number;
  /** Default value: `line` */
  "bollinger bands.median.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "bollinger bands.median.trackprice": boolean;
  /** Default value: `0` */
  "bollinger bands.median.transparency": number;
  /** Default value: `#FF6D00` */
  "bollinger bands.median.color": string;
  /** Default value: `15` */
  "bollinger bands.upper.display": number;
  /** Default value: `0` */
  "bollinger bands.upper.linestyle": number;
  /** Default value: `1` */
  "bollinger bands.upper.linewidth": number;
  /** Default value: `line` */
  "bollinger bands.upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "bollinger bands.upper.trackprice": boolean;
  /** Default value: `0` */
  "bollinger bands.upper.transparency": number;
  /** Default value: `#2196F3` */
  "bollinger bands.upper.color": string;
  /** Default value: `15` */
  "bollinger bands.lower.display": number;
  /** Default value: `0` */
  "bollinger bands.lower.linestyle": number;
  /** Default value: `1` */
  "bollinger bands.lower.linewidth": number;
  /** Default value: `line` */
  "bollinger bands.lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "bollinger bands.lower.trackprice": boolean;
  /** Default value: `0` */
  "bollinger bands.lower.transparency": number;
  /** Default value: `#2196F3` */
  "bollinger bands.lower.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "bollinger bands.length": number;
  /**
   * - Default value: `2`
   * - Input type: `float`
   * - Min: `0.001`
   * - Max: `50`
   */
  "bollinger bands.mult": number;
  /** Default value: `#26A69A` */
  "bollinger bands %b.hlines background.color": string;
  /** Default value: `90` */
  "bollinger bands %b.hlines background.transparency": number;
  /** Default value: `true` */
  "bollinger bands %b.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "bollinger bands %b.upperlimit.color": string;
  /** Default value: `2` */
  "bollinger bands %b.upperlimit.linestyle": number;
  /** Default value: `1` */
  "bollinger bands %b.upperlimit.linewidth": number;
  /** Default value: `true` */
  "bollinger bands %b.upperlimit.visible": boolean;
  /** Default value: `1` */
  "bollinger bands %b.upperlimit.value": number;
  /** Default value: `#787B86` */
  "bollinger bands %b.lowerlimit.color": string;
  /** Default value: `2` */
  "bollinger bands %b.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "bollinger bands %b.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "bollinger bands %b.lowerlimit.visible": boolean;
  /** Default value: `0` */
  "bollinger bands %b.lowerlimit.value": number;
  /** Default value: `15` */
  "bollinger bands %b.plot.display": number;
  /** Default value: `0` */
  "bollinger bands %b.plot.linestyle": number;
  /** Default value: `1` */
  "bollinger bands %b.plot.linewidth": number;
  /** Default value: `line` */
  "bollinger bands %b.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "bollinger bands %b.plot.trackprice": boolean;
  /** Default value: `0` */
  "bollinger bands %b.plot.transparency": number;
  /** Default value: `#22AB94` */
  "bollinger bands %b.plot.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "bollinger bands %b.length": number;
  /**
   * - Default value: `2`
   * - Input type: `float`
   * - Min: `0.001`
   * - Max: `50`
   */
  "bollinger bands %b.mult": number;
  /** Default value: `15` */
  "bollinger bands width.plot.display": number;
  /** Default value: `0` */
  "bollinger bands width.plot.linestyle": number;
  /** Default value: `1` */
  "bollinger bands width.plot.linewidth": number;
  /** Default value: `line` */
  "bollinger bands width.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "bollinger bands width.plot.trackprice": boolean;
  /** Default value: `0` */
  "bollinger bands width.plot.transparency": number;
  /** Default value: `#FF6D00` */
  "bollinger bands width.plot.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "bollinger bands width.length": number;
  /**
   * - Default value: `2`
   * - Input type: `float`
   * - Min: `0.001`
   * - Max: `50`
   */
  "bollinger bands width.mult": number;
  /** Default value: `#787B86` */
  "chaikin money flow.zero.color": string;
  /** Default value: `2` */
  "chaikin money flow.zero.linestyle": number;
  /** Default value: `1` */
  "chaikin money flow.zero.linewidth": number;
  /** Default value: `true` */
  "chaikin money flow.zero.visible": boolean;
  /** Default value: `0` */
  "chaikin money flow.zero.value": number;
  /** Default value: `15` */
  "chaikin money flow.plot.display": number;
  /** Default value: `0` */
  "chaikin money flow.plot.linestyle": number;
  /** Default value: `1` */
  "chaikin money flow.plot.linewidth": number;
  /** Default value: `line` */
  "chaikin money flow.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "chaikin money flow.plot.trackprice": boolean;
  /** Default value: `0` */
  "chaikin money flow.plot.transparency": number;
  /** Default value: `#43A047` */
  "chaikin money flow.plot.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "chaikin money flow.length": number;
  /** Default value: `#787B86` */
  "chaikin oscillator.zero.color": string;
  /** Default value: `2` */
  "chaikin oscillator.zero.linestyle": number;
  /** Default value: `1` */
  "chaikin oscillator.zero.linewidth": number;
  /** Default value: `true` */
  "chaikin oscillator.zero.visible": boolean;
  /** Default value: `0` */
  "chaikin oscillator.zero.value": number;
  /** Default value: `15` */
  "chaikin oscillator.plot.display": number;
  /** Default value: `0` */
  "chaikin oscillator.plot.linestyle": number;
  /** Default value: `1` */
  "chaikin oscillator.plot.linewidth": number;
  /** Default value: `line` */
  "chaikin oscillator.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "chaikin oscillator.plot.trackprice": boolean;
  /** Default value: `0` */
  "chaikin oscillator.plot.transparency": number;
  /** Default value: `#EC407A` */
  "chaikin oscillator.plot.color": string;
  /**
   * - Default value: `3`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "chaikin oscillator.short": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "chaikin oscillator.long": number;
  /** Default value: `#787B86` */
  "chaikin volatility.zero.color": string;
  /** Default value: `2` */
  "chaikin volatility.zero.linestyle": number;
  /** Default value: `1` */
  "chaikin volatility.zero.linewidth": number;
  /** Default value: `true` */
  "chaikin volatility.zero.visible": boolean;
  /** Default value: `0` */
  "chaikin volatility.zero.value": number;
  /** Default value: `15` */
  "chaikin volatility.plot.display": number;
  /** Default value: `0` */
  "chaikin volatility.plot.linestyle": number;
  /** Default value: `1` */
  "chaikin volatility.plot.linewidth": number;
  /** Default value: `line` */
  "chaikin volatility.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "chaikin volatility.plot.trackprice": boolean;
  /** Default value: `0` */
  "chaikin volatility.plot.transparency": number;
  /** Default value: `#AB47BC` */
  "chaikin volatility.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   */
  "chaikin volatility.periods": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   */
  "chaikin volatility.rate of change lookback": number;
  /** Default value: `15` */
  "chande kroll stop.long.display": number;
  /** Default value: `0` */
  "chande kroll stop.long.linestyle": number;
  /** Default value: `1` */
  "chande kroll stop.long.linewidth": number;
  /** Default value: `line` */
  "chande kroll stop.long.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "chande kroll stop.long.trackprice": boolean;
  /** Default value: `0` */
  "chande kroll stop.long.transparency": number;
  /** Default value: `#2196F3` */
  "chande kroll stop.long.color": string;
  /** Default value: `15` */
  "chande kroll stop.short.display": number;
  /** Default value: `0` */
  "chande kroll stop.short.linestyle": number;
  /** Default value: `1` */
  "chande kroll stop.short.linewidth": number;
  /** Default value: `line` */
  "chande kroll stop.short.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "chande kroll stop.short.trackprice": boolean;
  /** Default value: `0` */
  "chande kroll stop.short.transparency": number;
  /** Default value: `#FF6D00` */
  "chande kroll stop.short.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `4999`
   */
  "chande kroll stop.p": number;
  /**
   * - Default value: `1`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "chande kroll stop.x": number;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "chande kroll stop.q": number;
  /** Default value: `15` */
  "chande momentum oscillator.plot.display": number;
  /** Default value: `0` */
  "chande momentum oscillator.plot.linestyle": number;
  /** Default value: `1` */
  "chande momentum oscillator.plot.linewidth": number;
  /** Default value: `line` */
  "chande momentum oscillator.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "chande momentum oscillator.plot.trackprice": boolean;
  /** Default value: `0` */
  "chande momentum oscillator.plot.transparency": number;
  /** Default value: `#2196F3` */
  "chande momentum oscillator.plot.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "chande momentum oscillator.length": number;
  /** Default value: `15` */
  "chop zone.plot.display": number;
  /** Default value: `0` */
  "chop zone.plot.linestyle": number;
  /** Default value: `1` */
  "chop zone.plot.linewidth": number;
  /** Default value: `columns` */
  "chop zone.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "chop zone.plot.trackprice": boolean;
  /** Default value: `0` */
  "chop zone.plot.transparency": number;
  /** Default value: `#000080` */
  "chop zone.plot.color": string;
  /** Default value: `#2196F3` */
  "choppiness index.hlines background.color": string;
  /** Default value: `90` */
  "choppiness index.hlines background.transparency": number;
  /** Default value: `true` */
  "choppiness index.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "choppiness index.upperlimit.color": string;
  /** Default value: `2` */
  "choppiness index.upperlimit.linestyle": number;
  /** Default value: `1` */
  "choppiness index.upperlimit.linewidth": number;
  /** Default value: `true` */
  "choppiness index.upperlimit.visible": boolean;
  /** Default value: `61.8` */
  "choppiness index.upperlimit.value": number;
  /** Default value: `#787B86` */
  "choppiness index.lowerlimit.color": string;
  /** Default value: `2` */
  "choppiness index.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "choppiness index.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "choppiness index.lowerlimit.visible": boolean;
  /** Default value: `38.2` */
  "choppiness index.lowerlimit.value": number;
  /** Default value: `15` */
  "choppiness index.plot.display": number;
  /** Default value: `0` */
  "choppiness index.plot.linestyle": number;
  /** Default value: `1` */
  "choppiness index.plot.linewidth": number;
  /** Default value: `line` */
  "choppiness index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "choppiness index.plot.trackprice": boolean;
  /** Default value: `0` */
  "choppiness index.plot.transparency": number;
  /** Default value: `#2196F3` */
  "choppiness index.plot.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "choppiness index.length": number;
  /** Default value: `#2196F3` */
  "commodity channel index.hlines background.color": string;
  /** Default value: `90` */
  "commodity channel index.hlines background.transparency": number;
  /** Default value: `true` */
  "commodity channel index.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "commodity channel index.upperlimit.color": string;
  /** Default value: `2` */
  "commodity channel index.upperlimit.linestyle": number;
  /** Default value: `1` */
  "commodity channel index.upperlimit.linewidth": number;
  /** Default value: `true` */
  "commodity channel index.upperlimit.visible": boolean;
  /** Default value: `100` */
  "commodity channel index.upperlimit.value": number;
  /** Default value: `#787B86` */
  "commodity channel index.lowerlimit.color": string;
  /** Default value: `2` */
  "commodity channel index.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "commodity channel index.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "commodity channel index.lowerlimit.visible": boolean;
  /** Default value: `-100` */
  "commodity channel index.lowerlimit.value": number;
  /** Default value: `15` */
  "commodity channel index.plot.display": number;
  /** Default value: `0` */
  "commodity channel index.plot.linestyle": number;
  /** Default value: `1` */
  "commodity channel index.plot.linewidth": number;
  /** Default value: `line` */
  "commodity channel index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "commodity channel index.plot.trackprice": boolean;
  /** Default value: `0` */
  "commodity channel index.plot.transparency": number;
  /** Default value: `#2196F3` */
  "commodity channel index.plot.color": string;
  /** Default value: `0` */
  "commodity channel index.smoothed ma.display": number;
  /** Default value: `0` */
  "commodity channel index.smoothed ma.linestyle": number;
  /** Default value: `1` */
  "commodity channel index.smoothed ma.linewidth": number;
  /** Default value: `line` */
  "commodity channel index.smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "commodity channel index.smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "commodity channel index.smoothed ma.transparency": number;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "commodity channel index.length": number;
  /**
   * - Default value: `SMA`
   * - Input type: `text`
   * - Options: `["SMA","EMA","WMA"]`
   */
  "commodity channel index.smoothing line": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "commodity channel index.smoothing length": number;
  /** Default value: `15` */
  "compare.plot.display": number;
  /** Default value: `0` */
  "compare.plot.linestyle": number;
  /** Default value: `2` */
  "compare.plot.linewidth": number;
  /** Default value: `line` */
  "compare.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "compare.plot.trackprice": boolean;
  /** Default value: `0` */
  "compare.plot.transparency": number;
  /** Default value: `#9C27B0` */
  "compare.plot.color": string;
  /**
   * - Default value: `close`
   * - Input type: `text`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "compare.source": string;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   * - IsHidden: `true`
   */
  "compare.symbol": string;
  /** Default value: `#2196F3` */
  "connors rsi.hlines background.color": string;
  /** Default value: `90` */
  "connors rsi.hlines background.transparency": number;
  /** Default value: `true` */
  "connors rsi.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "connors rsi.upperlimit.color": string;
  /** Default value: `2` */
  "connors rsi.upperlimit.linestyle": number;
  /** Default value: `1` */
  "connors rsi.upperlimit.linewidth": number;
  /** Default value: `true` */
  "connors rsi.upperlimit.visible": boolean;
  /** Default value: `70` */
  "connors rsi.upperlimit.value": number;
  /** Default value: `#787B86` */
  "connors rsi.lowerlimit.color": string;
  /** Default value: `2` */
  "connors rsi.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "connors rsi.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "connors rsi.lowerlimit.visible": boolean;
  /** Default value: `30` */
  "connors rsi.lowerlimit.value": number;
  /** Default value: `15` */
  "connors rsi.crsi.display": number;
  /** Default value: `0` */
  "connors rsi.crsi.linestyle": number;
  /** Default value: `1` */
  "connors rsi.crsi.linewidth": number;
  /** Default value: `line` */
  "connors rsi.crsi.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "connors rsi.crsi.trackprice": boolean;
  /** Default value: `0` */
  "connors rsi.crsi.transparency": number;
  /** Default value: `#2196F3` */
  "connors rsi.crsi.color": string;
  /**
   * - Default value: `3`
   * - Input type: `integer`
   * - Min: `1`
   */
  "connors rsi.rsi length": number;
  /**
   * - Default value: `2`
   * - Input type: `integer`
   * - Min: `1`
   */
  "connors rsi.updown length": number;
  /**
   * - Default value: `100`
   * - Input type: `integer`
   * - Min: `1`
   */
  "connors rsi.roc length": number;
  /** Default value: `15` */
  "coppock curve.plot.display": number;
  /** Default value: `0` */
  "coppock curve.plot.linestyle": number;
  /** Default value: `1` */
  "coppock curve.plot.linewidth": number;
  /** Default value: `line` */
  "coppock curve.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "coppock curve.plot.trackprice": boolean;
  /** Default value: `0` */
  "coppock curve.plot.transparency": number;
  /** Default value: `#2196F3` */
  "coppock curve.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `-1000000000000`
   * - Max: `5000`
   */
  "coppock curve.wma length": number;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `4999`
   */
  "coppock curve.long roc length": number;
  /**
   * - Default value: `11`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `4999`
   */
  "coppock curve.short roc length": number;
  /** Default value: `15` */
  "correlation - log.plot.display": number;
  /** Default value: `0` */
  "correlation - log.plot.linestyle": number;
  /** Default value: `1` */
  "correlation - log.plot.linewidth": number;
  /** Default value: `line` */
  "correlation - log.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "correlation - log.plot.trackprice": boolean;
  /** Default value: `0` */
  "correlation - log.plot.transparency": number;
  /** Default value: `#2196F3` */
  "correlation - log.plot.color": string;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   * - Confirm: `true`
   */
  "correlation - log.instrument 1": string;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   * - Confirm: `true`
   */
  "correlation - log.instrument 2": string;
  /**
   * - Default value: `25`
   * - Input type: `integer`
   */
  "correlation - log.periods": number;
  /** Default value: `15` */
  "correlation coefficient.plot.display": number;
  /** Default value: `0` */
  "correlation coefficient.plot.linestyle": number;
  /** Default value: `1` */
  "correlation coefficient.plot.linewidth": number;
  /** Default value: `area` */
  "correlation coefficient.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "correlation coefficient.plot.trackprice": boolean;
  /** Default value: `0` */
  "correlation coefficient.plot.transparency": number;
  /** Default value: `#2196F3` */
  "correlation coefficient.plot.color": string;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   */
  "correlation coefficient.sym": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "correlation coefficient.length": number;
  /** Default value: `#787B86` */
  "detrended price oscillator.zero.color": string;
  /** Default value: `2` */
  "detrended price oscillator.zero.linestyle": number;
  /** Default value: `1` */
  "detrended price oscillator.zero.linewidth": number;
  /** Default value: `true` */
  "detrended price oscillator.zero.visible": boolean;
  /** Default value: `0` */
  "detrended price oscillator.zero.value": number;
  /** Default value: `15` */
  "detrended price oscillator.dpo.display": number;
  /** Default value: `0` */
  "detrended price oscillator.dpo.linestyle": number;
  /** Default value: `1` */
  "detrended price oscillator.dpo.linewidth": number;
  /** Default value: `line` */
  "detrended price oscillator.dpo.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "detrended price oscillator.dpo.trackprice": boolean;
  /** Default value: `0` */
  "detrended price oscillator.dpo.transparency": number;
  /** Default value: `#43A047` */
  "detrended price oscillator.dpo.color": string;
  /**
   * - Default value: `21`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "detrended price oscillator.period": number;
  /**
   * - Default value: `false`
   * - Input type: `bool`
   */
  "detrended price oscillator.iscentered": boolean;
  /** Default value: `15` */
  "directional movement.+di.display": number;
  /** Default value: `0` */
  "directional movement.+di.linestyle": number;
  /** Default value: `1` */
  "directional movement.+di.linewidth": number;
  /** Default value: `line` */
  "directional movement.+di.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "directional movement.+di.trackprice": boolean;
  /** Default value: `0` */
  "directional movement.+di.transparency": number;
  /** Default value: `#2196F3` */
  "directional movement.+di.color": string;
  /** Default value: `15` */
  "directional movement.-di.display": number;
  /** Default value: `0` */
  "directional movement.-di.linestyle": number;
  /** Default value: `1` */
  "directional movement.-di.linewidth": number;
  /** Default value: `line` */
  "directional movement.-di.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "directional movement.-di.trackprice": boolean;
  /** Default value: `0` */
  "directional movement.-di.transparency": number;
  /** Default value: `#FF6D00` */
  "directional movement.-di.color": string;
  /** Default value: `15` */
  "directional movement.adx.display": number;
  /** Default value: `0` */
  "directional movement.adx.linestyle": number;
  /** Default value: `1` */
  "directional movement.adx.linewidth": number;
  /** Default value: `line` */
  "directional movement.adx.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "directional movement.adx.trackprice": boolean;
  /** Default value: `0` */
  "directional movement.adx.transparency": number;
  /** Default value: `#F50057` */
  "directional movement.adx.color": string;
  /** Default value: `15` */
  "directional movement.dx.display": number;
  /** Default value: `0` */
  "directional movement.dx.linestyle": number;
  /** Default value: `1` */
  "directional movement.dx.linewidth": number;
  /** Default value: `line` */
  "directional movement.dx.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "directional movement.dx.trackprice": boolean;
  /** Default value: `0` */
  "directional movement.dx.transparency": number;
  /** Default value: `#FFA726` */
  "directional movement.dx.color": string;
  /** Default value: `15` */
  "directional movement.adxr.display": number;
  /** Default value: `0` */
  "directional movement.adxr.linestyle": number;
  /** Default value: `1` */
  "directional movement.adxr.linewidth": number;
  /** Default value: `line` */
  "directional movement.adxr.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "directional movement.adxr.trackprice": boolean;
  /** Default value: `0` */
  "directional movement.adxr.transparency": number;
  /** Default value: `#ab47bc` */
  "directional movement.adxr.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "directional movement.di length": number;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `50`
   */
  "directional movement.adx smoothing": number;
  /** Default value: `#2196F3` */
  "donchian channels.plots background.color": string;
  /** Default value: `95` */
  "donchian channels.plots background.transparency": number;
  /** Default value: `true` */
  "donchian channels.plots background.visible": boolean;
  /** Default value: `15` */
  "donchian channels.lower.display": number;
  /** Default value: `0` */
  "donchian channels.lower.linestyle": number;
  /** Default value: `1` */
  "donchian channels.lower.linewidth": number;
  /** Default value: `line` */
  "donchian channels.lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "donchian channels.lower.trackprice": boolean;
  /** Default value: `0` */
  "donchian channels.lower.transparency": number;
  /** Default value: `#2196F3` */
  "donchian channels.lower.color": string;
  /** Default value: `15` */
  "donchian channels.upper.display": number;
  /** Default value: `0` */
  "donchian channels.upper.linestyle": number;
  /** Default value: `1` */
  "donchian channels.upper.linewidth": number;
  /** Default value: `line` */
  "donchian channels.upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "donchian channels.upper.trackprice": boolean;
  /** Default value: `0` */
  "donchian channels.upper.transparency": number;
  /** Default value: `#2196F3` */
  "donchian channels.upper.color": string;
  /** Default value: `15` */
  "donchian channels.basis.display": number;
  /** Default value: `0` */
  "donchian channels.basis.linestyle": number;
  /** Default value: `1` */
  "donchian channels.basis.linewidth": number;
  /** Default value: `line` */
  "donchian channels.basis.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "donchian channels.basis.trackprice": boolean;
  /** Default value: `0` */
  "donchian channels.basis.transparency": number;
  /** Default value: `#FF6D00` */
  "donchian channels.basis.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "donchian channels.length": number;
  /** Default value: `15` */
  "double ema.plot.display": number;
  /** Default value: `0` */
  "double ema.plot.linestyle": number;
  /** Default value: `1` */
  "double ema.plot.linewidth": number;
  /** Default value: `line` */
  "double ema.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "double ema.plot.trackprice": boolean;
  /** Default value: `0` */
  "double ema.plot.transparency": number;
  /** Default value: `#43A047` */
  "double ema.plot.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "double ema.length": number;
  /** Default value: `15` */
  "ema cross.short:plot.display": number;
  /** Default value: `0` */
  "ema cross.short:plot.linestyle": number;
  /** Default value: `1` */
  "ema cross.short:plot.linewidth": number;
  /** Default value: `line` */
  "ema cross.short:plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ema cross.short:plot.trackprice": boolean;
  /** Default value: `0` */
  "ema cross.short:plot.transparency": number;
  /** Default value: `#FF6D00` */
  "ema cross.short:plot.color": string;
  /** Default value: `15` */
  "ema cross.long:plot.display": number;
  /** Default value: `0` */
  "ema cross.long:plot.linestyle": number;
  /** Default value: `1` */
  "ema cross.long:plot.linewidth": number;
  /** Default value: `line` */
  "ema cross.long:plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ema cross.long:plot.trackprice": boolean;
  /** Default value: `0` */
  "ema cross.long:plot.transparency": number;
  /** Default value: `#43A047` */
  "ema cross.long:plot.color": string;
  /** Default value: `15` */
  "ema cross.crosses.display": number;
  /** Default value: `0` */
  "ema cross.crosses.linestyle": number;
  /** Default value: `4` */
  "ema cross.crosses.linewidth": number;
  /** Default value: `cross` */
  "ema cross.crosses.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ema cross.crosses.trackprice": boolean;
  /** Default value: `0` */
  "ema cross.crosses.transparency": number;
  /** Default value: `#2196F3` */
  "ema cross.crosses.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "ema cross.short:input": number;
  /**
   * - Default value: `26`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "ema cross.long:input": number;
  /** Default value: `15` */
  "ease of movement.plot.display": number;
  /** Default value: `0` */
  "ease of movement.plot.linestyle": number;
  /** Default value: `1` */
  "ease of movement.plot.linewidth": number;
  /** Default value: `line` */
  "ease of movement.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ease of movement.plot.trackprice": boolean;
  /** Default value: `0` */
  "ease of movement.plot.transparency": number;
  /** Default value: `#43A047` */
  "ease of movement.plot.color": string;
  /**
   * - Default value: `10000`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000`
   */
  "ease of movement.divisor": number;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "ease of movement.length": number;
  /** Default value: `#787B86` */
  "elder's force index.zero.color": string;
  /** Default value: `2` */
  "elder's force index.zero.linestyle": number;
  /** Default value: `1` */
  "elder's force index.zero.linewidth": number;
  /** Default value: `true` */
  "elder's force index.zero.visible": boolean;
  /** Default value: `0` */
  "elder's force index.zero.value": number;
  /** Default value: `15` */
  "elder's force index.plot.display": number;
  /** Default value: `0` */
  "elder's force index.plot.linestyle": number;
  /** Default value: `1` */
  "elder's force index.plot.linewidth": number;
  /** Default value: `line` */
  "elder's force index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "elder's force index.plot.trackprice": boolean;
  /** Default value: `0` */
  "elder's force index.plot.transparency": number;
  /** Default value: `#F23645` */
  "elder's force index.plot.color": string;
  /**
   * - Default value: `13`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "elder's force index.length": number;
  /** Default value: `#2196F3` */
  "envelopes.plots background.color": string;
  /** Default value: `95` */
  "envelopes.plots background.transparency": number;
  /** Default value: `true` */
  "envelopes.plots background.visible": boolean;
  /** Default value: `15` */
  "envelopes.average.display": number;
  /** Default value: `0` */
  "envelopes.average.linestyle": number;
  /** Default value: `1` */
  "envelopes.average.linewidth": number;
  /** Default value: `line` */
  "envelopes.average.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "envelopes.average.trackprice": boolean;
  /** Default value: `0` */
  "envelopes.average.transparency": number;
  /** Default value: `#FF6D00` */
  "envelopes.average.color": string;
  /** Default value: `15` */
  "envelopes.upper.display": number;
  /** Default value: `0` */
  "envelopes.upper.linestyle": number;
  /** Default value: `1` */
  "envelopes.upper.linewidth": number;
  /** Default value: `line` */
  "envelopes.upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "envelopes.upper.trackprice": boolean;
  /** Default value: `0` */
  "envelopes.upper.transparency": number;
  /** Default value: `#2196F3` */
  "envelopes.upper.color": string;
  /** Default value: `15` */
  "envelopes.lower.display": number;
  /** Default value: `0` */
  "envelopes.lower.linestyle": number;
  /** Default value: `1` */
  "envelopes.lower.linewidth": number;
  /** Default value: `line` */
  "envelopes.lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "envelopes.lower.trackprice": boolean;
  /** Default value: `0` */
  "envelopes.lower.transparency": number;
  /** Default value: `#2196F3` */
  "envelopes.lower.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "envelopes.length": number;
  /**
   * - Default value: `10`
   * - Input type: `float`
   * - Min: `0`
   */
  "envelopes.upper percentage": number;
  /**
   * - Default value: `10`
   * - Input type: `float`
   * - Min: `0`
   */
  "envelopes.lower percentage": number;
  /**
   * - Default value: `Simple`
   * - Input type: `text`
   * - Options: `["Simple","Exponential","Weighted"]`
   */
  "envelopes.method": string;
  /**
   * - Default value: `close`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "envelopes.source": string;
  /** Default value: `#E91E63` */
  "fisher transform.level:band.color": string;
  /** Default value: `2` */
  "fisher transform.level:band.linestyle": number;
  /** Default value: `1` */
  "fisher transform.level:band.linewidth": number;
  /** Default value: `true` */
  "fisher transform.level:band.visible": boolean;
  /** Default value: `-1.5` */
  "fisher transform.level:band.value": number;
  /** Default value: `15` */
  "fisher transform.fisher.display": number;
  /** Default value: `0` */
  "fisher transform.fisher.linestyle": number;
  /** Default value: `1` */
  "fisher transform.fisher.linewidth": number;
  /** Default value: `line` */
  "fisher transform.fisher.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "fisher transform.fisher.trackprice": boolean;
  /** Default value: `0` */
  "fisher transform.fisher.transparency": number;
  /** Default value: `#2196F3` */
  "fisher transform.fisher.color": string;
  /** Default value: `15` */
  "fisher transform.trigger.display": number;
  /** Default value: `0` */
  "fisher transform.trigger.linestyle": number;
  /** Default value: `1` */
  "fisher transform.trigger.linewidth": number;
  /** Default value: `line` */
  "fisher transform.trigger.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "fisher transform.trigger.trackprice": boolean;
  /** Default value: `0` */
  "fisher transform.trigger.transparency": number;
  /** Default value: `#FF6D00` */
  "fisher transform.trigger.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "fisher transform.length": number;
  /** Default value: `#ff0000` */
  "fixed range.developing poc.color": string;
  /** Default value: `0` */
  "fixed range.developing poc.linestyle": number;
  /** Default value: `1` */
  "fixed range.developing poc.linewidth": number;
  /** Default value: `step_line` */
  "fixed range.developing poc.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "fixed range.developing poc.trackprice": boolean;
  /** Default value: `0` */
  "fixed range.developing poc.transparency": number;
  /** Default value: `0` */
  "fixed range.developing poc.display": number;
  /** Default value: `#0000ff` */
  "fixed range.developing va high.color": string;
  /** Default value: `0` */
  "fixed range.developing va high.linestyle": number;
  /** Default value: `1` */
  "fixed range.developing va high.linewidth": number;
  /** Default value: `step_line` */
  "fixed range.developing va high.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "fixed range.developing va high.trackprice": boolean;
  /** Default value: `0` */
  "fixed range.developing va high.transparency": number;
  /** Default value: `0` */
  "fixed range.developing va high.display": number;
  /** Default value: `#0000ff` */
  "fixed range.developing va low.color": string;
  /** Default value: `0` */
  "fixed range.developing va low.linestyle": number;
  /** Default value: `1` */
  "fixed range.developing va low.linewidth": number;
  /** Default value: `step_line` */
  "fixed range.developing va low.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "fixed range.developing va low.trackprice": boolean;
  /** Default value: `0` */
  "fixed range.developing va low.transparency": number;
  /** Default value: `0` */
  "fixed range.developing va low.display": number;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "fixed range.first bar time": number;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "fixed range.last bar time": number;
  /**
   * - Default value: `24`
   * - Input type: `integer`
   * - Max: `1000000`
   * - Min: `1`
   */
  "fixed range.row size": number;
  /**
   * - Default value: `Number Of Rows`
   * - Input type: `text`
   * - Options: `["Number Of Rows","Ticks Per Row"]`
   */
  "fixed range.rows layout": string;
  /**
   * - Default value: `true`
   * - Input type: `bool`
   * - IsHidden: `true`
   */
  "fixed range.subscriberealtime": boolean;
  /**
   * - Default value: `70`
   * - Input type: `integer`
   * - Max: `100`
   * - Min: `0`
   */
  "fixed range.value area volume": number;
  /**
   * - Default value: `Up/Down`
   * - Input type: `text`
   * - Options: `["Up/Down","Total","Delta"]`
   */
  "fixed range.volume": string;
  /** Default value: `15` */
  "guppy multiple moving average.trader ema 1.display": number;
  /** Default value: `#00FFFF` */
  "guppy multiple moving average.trader ema 1.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.trader ema 1.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.trader ema 1.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.trader ema 1.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.trader ema 1.trackprice": boolean;
  /** Default value: `15` */
  "guppy multiple moving average.trader ema 1.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.trader ema 2.display": number;
  /** Default value: `#00FFFF` */
  "guppy multiple moving average.trader ema 2.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.trader ema 2.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.trader ema 2.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.trader ema 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.trader ema 2.trackprice": boolean;
  /** Default value: `12` */
  "guppy multiple moving average.trader ema 2.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.trader ema 3.display": number;
  /** Default value: `#00FFFF` */
  "guppy multiple moving average.trader ema 3.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.trader ema 3.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.trader ema 3.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.trader ema 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.trader ema 3.trackprice": boolean;
  /** Default value: `9` */
  "guppy multiple moving average.trader ema 3.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.trader ema 4.display": number;
  /** Default value: `#00FFFF` */
  "guppy multiple moving average.trader ema 4.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.trader ema 4.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.trader ema 4.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.trader ema 4.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.trader ema 4.trackprice": boolean;
  /** Default value: `6` */
  "guppy multiple moving average.trader ema 4.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.trader ema 5.display": number;
  /** Default value: `#00FFFF` */
  "guppy multiple moving average.trader ema 5.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.trader ema 5.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.trader ema 5.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.trader ema 5.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.trader ema 5.trackprice": boolean;
  /** Default value: `3` */
  "guppy multiple moving average.trader ema 5.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.trader ema 6.display": number;
  /** Default value: `#00FFFF` */
  "guppy multiple moving average.trader ema 6.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.trader ema 6.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.trader ema 6.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.trader ema 6.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.trader ema 6.trackprice": boolean;
  /** Default value: `0` */
  "guppy multiple moving average.trader ema 6.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.investor ema 1.display": number;
  /** Default value: `#FF0000` */
  "guppy multiple moving average.investor ema 1.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.investor ema 1.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.investor ema 1.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.investor ema 1.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.investor ema 1.trackprice": boolean;
  /** Default value: `15` */
  "guppy multiple moving average.investor ema 1.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.investor ema 2.display": number;
  /** Default value: `#FF0000` */
  "guppy multiple moving average.investor ema 2.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.investor ema 2.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.investor ema 2.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.investor ema 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.investor ema 2.trackprice": boolean;
  /** Default value: `12` */
  "guppy multiple moving average.investor ema 2.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.investor ema 3.display": number;
  /** Default value: `#FF0000` */
  "guppy multiple moving average.investor ema 3.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.investor ema 3.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.investor ema 3.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.investor ema 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.investor ema 3.trackprice": boolean;
  /** Default value: `9` */
  "guppy multiple moving average.investor ema 3.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.investor ema 4.display": number;
  /** Default value: `#FF0000` */
  "guppy multiple moving average.investor ema 4.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.investor ema 4.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.investor ema 4.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.investor ema 4.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.investor ema 4.trackprice": boolean;
  /** Default value: `6` */
  "guppy multiple moving average.investor ema 4.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.investor ema 5.display": number;
  /** Default value: `#FF0000` */
  "guppy multiple moving average.investor ema 5.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.investor ema 5.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.investor ema 5.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.investor ema 5.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.investor ema 5.trackprice": boolean;
  /** Default value: `3` */
  "guppy multiple moving average.investor ema 5.transparency": number;
  /** Default value: `15` */
  "guppy multiple moving average.investor ema 6.display": number;
  /** Default value: `#FF0000` */
  "guppy multiple moving average.investor ema 6.color": string;
  /** Default value: `0` */
  "guppy multiple moving average.investor ema 6.linestyle": number;
  /** Default value: `1` */
  "guppy multiple moving average.investor ema 6.linewidth": number;
  /** Default value: `line` */
  "guppy multiple moving average.investor ema 6.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "guppy multiple moving average.investor ema 6.trackprice": boolean;
  /** Default value: `0` */
  "guppy multiple moving average.investor ema 6.transparency": number;
  /**
   * - Default value: `3`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.trader ema 1 length": number;
  /**
   * - Default value: `5`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.trader ema 2 length": number;
  /**
   * - Default value: `8`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.trader ema 3 length": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.trader ema 4 length": number;
  /**
   * - Default value: `12`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.trader ema 5 length": number;
  /**
   * - Default value: `15`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.trader ema 6 length": number;
  /**
   * - Default value: `30`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.investor ema 1 length": number;
  /**
   * - Default value: `35`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.investor ema 2 length": number;
  /**
   * - Default value: `40`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.investor ema 3 length": number;
  /**
   * - Default value: `45`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.investor ema 4 length": number;
  /**
   * - Default value: `50`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.investor ema 5 length": number;
  /**
   * - Default value: `60`
   * - Input type: `integer`
   * - Max: `1000`
   * - Min: `1`
   */
  "guppy multiple moving average.investor ema 6 length": number;
  /** Default value: `15` */
  "historical volatility.plot.display": number;
  /** Default value: `0` */
  "historical volatility.plot.linestyle": number;
  /** Default value: `1` */
  "historical volatility.plot.linewidth": number;
  /** Default value: `line` */
  "historical volatility.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "historical volatility.plot.trackprice": boolean;
  /** Default value: `0` */
  "historical volatility.plot.transparency": number;
  /** Default value: `#2196F3` */
  "historical volatility.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "historical volatility.length": number;
  /** Default value: `15` */
  "hull moving average.plot.display": number;
  /** Default value: `0` */
  "hull moving average.plot.linestyle": number;
  /** Default value: `1` */
  "hull moving average.plot.linewidth": number;
  /** Default value: `line` */
  "hull moving average.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "hull moving average.plot.trackprice": boolean;
  /** Default value: `0` */
  "hull moving average.plot.transparency": number;
  /** Default value: `#2196F3` */
  "hull moving average.plot.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "hull moving average.length": number;
  /** Default value: `#000080` */
  "ichimoku cloud.plots background.color": string;
  /** Default value: `90` */
  "ichimoku cloud.plots background.transparency": number;
  /** Default value: `true` */
  "ichimoku cloud.plots background.visible": boolean;
  /** Default value: `15` */
  "ichimoku cloud.conversion line.display": number;
  /** Default value: `0` */
  "ichimoku cloud.conversion line.linestyle": number;
  /** Default value: `1` */
  "ichimoku cloud.conversion line.linewidth": number;
  /** Default value: `line` */
  "ichimoku cloud.conversion line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ichimoku cloud.conversion line.trackprice": boolean;
  /** Default value: `0` */
  "ichimoku cloud.conversion line.transparency": number;
  /** Default value: `#2196F3` */
  "ichimoku cloud.conversion line.color": string;
  /** Default value: `15` */
  "ichimoku cloud.base line.display": number;
  /** Default value: `0` */
  "ichimoku cloud.base line.linestyle": number;
  /** Default value: `1` */
  "ichimoku cloud.base line.linewidth": number;
  /** Default value: `line` */
  "ichimoku cloud.base line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ichimoku cloud.base line.trackprice": boolean;
  /** Default value: `0` */
  "ichimoku cloud.base line.transparency": number;
  /** Default value: `#801922` */
  "ichimoku cloud.base line.color": string;
  /** Default value: `15` */
  "ichimoku cloud.lagging span.display": number;
  /** Default value: `0` */
  "ichimoku cloud.lagging span.linestyle": number;
  /** Default value: `1` */
  "ichimoku cloud.lagging span.linewidth": number;
  /** Default value: `line` */
  "ichimoku cloud.lagging span.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ichimoku cloud.lagging span.trackprice": boolean;
  /** Default value: `0` */
  "ichimoku cloud.lagging span.transparency": number;
  /** Default value: `#43A047` */
  "ichimoku cloud.lagging span.color": string;
  /** Default value: `15` */
  "ichimoku cloud.leading span a.display": number;
  /** Default value: `0` */
  "ichimoku cloud.leading span a.linestyle": number;
  /** Default value: `1` */
  "ichimoku cloud.leading span a.linewidth": number;
  /** Default value: `line` */
  "ichimoku cloud.leading span a.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ichimoku cloud.leading span a.trackprice": boolean;
  /** Default value: `0` */
  "ichimoku cloud.leading span a.transparency": number;
  /** Default value: `#A5D6A7` */
  "ichimoku cloud.leading span a.color": string;
  /** Default value: `15` */
  "ichimoku cloud.leading span b.display": number;
  /** Default value: `0` */
  "ichimoku cloud.leading span b.linestyle": number;
  /** Default value: `1` */
  "ichimoku cloud.leading span b.linewidth": number;
  /** Default value: `line` */
  "ichimoku cloud.leading span b.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ichimoku cloud.leading span b.trackprice": boolean;
  /** Default value: `0` */
  "ichimoku cloud.leading span b.transparency": number;
  /** Default value: `#FAA1A4` */
  "ichimoku cloud.leading span b.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "ichimoku cloud.conversion line periods": number;
  /**
   * - Default value: `26`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "ichimoku cloud.base line periods": number;
  /**
   * - Default value: `52`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "ichimoku cloud.leading span periods": number;
  /**
   * - Default value: `26`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "ichimoku cloud.lagging span periods": number;
  /**
   * - Default value: `26`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "ichimoku cloud.leading shift periods": number;
  /** Default value: `#2196F3` */
  "keltner channels.plots background.color": string;
  /** Default value: `95` */
  "keltner channels.plots background.transparency": number;
  /** Default value: `true` */
  "keltner channels.plots background.visible": boolean;
  /** Default value: `15` */
  "keltner channels.upper.display": number;
  /** Default value: `0` */
  "keltner channels.upper.linestyle": number;
  /** Default value: `1` */
  "keltner channels.upper.linewidth": number;
  /** Default value: `line` */
  "keltner channels.upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "keltner channels.upper.trackprice": boolean;
  /** Default value: `0` */
  "keltner channels.upper.transparency": number;
  /** Default value: `#2196F3` */
  "keltner channels.upper.color": string;
  /** Default value: `15` */
  "keltner channels.middle.display": number;
  /** Default value: `0` */
  "keltner channels.middle.linestyle": number;
  /** Default value: `1` */
  "keltner channels.middle.linewidth": number;
  /** Default value: `line` */
  "keltner channels.middle.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "keltner channels.middle.trackprice": boolean;
  /** Default value: `0` */
  "keltner channels.middle.transparency": number;
  /** Default value: `#2196F3` */
  "keltner channels.middle.color": string;
  /** Default value: `15` */
  "keltner channels.lower.display": number;
  /** Default value: `0` */
  "keltner channels.lower.linestyle": number;
  /** Default value: `1` */
  "keltner channels.lower.linewidth": number;
  /** Default value: `line` */
  "keltner channels.lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "keltner channels.lower.trackprice": boolean;
  /** Default value: `0` */
  "keltner channels.lower.transparency": number;
  /** Default value: `#2196F3` */
  "keltner channels.lower.color": string;
  /**
   * - Default value: `true`
   * - Input type: `bool`
   */
  "keltner channels.usetruerange": boolean;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "keltner channels.length": number;
  /**
   * - Default value: `1`
   * - Input type: `float`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "keltner channels.mult": number;
  /** Default value: `15` */
  "klinger oscillator.plot.display": number;
  /** Default value: `0` */
  "klinger oscillator.plot.linestyle": number;
  /** Default value: `1` */
  "klinger oscillator.plot.linewidth": number;
  /** Default value: `line` */
  "klinger oscillator.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "klinger oscillator.plot.trackprice": boolean;
  /** Default value: `0` */
  "klinger oscillator.plot.transparency": number;
  /** Default value: `#2196F3` */
  "klinger oscillator.plot.color": string;
  /** Default value: `15` */
  "klinger oscillator.signal.display": number;
  /** Default value: `0` */
  "klinger oscillator.signal.linestyle": number;
  /** Default value: `1` */
  "klinger oscillator.signal.linewidth": number;
  /** Default value: `line` */
  "klinger oscillator.signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "klinger oscillator.signal.trackprice": boolean;
  /** Default value: `0` */
  "klinger oscillator.signal.transparency": number;
  /** Default value: `#43A047` */
  "klinger oscillator.signal.color": string;
  /** Default value: `#787B86` */
  "know sure thing.zero.color": string;
  /** Default value: `2` */
  "know sure thing.zero.linestyle": number;
  /** Default value: `1` */
  "know sure thing.zero.linewidth": number;
  /** Default value: `true` */
  "know sure thing.zero.visible": boolean;
  /** Default value: `0` */
  "know sure thing.zero.value": number;
  /** Default value: `15` */
  "know sure thing.kst.display": number;
  /** Default value: `0` */
  "know sure thing.kst.linestyle": number;
  /** Default value: `1` */
  "know sure thing.kst.linewidth": number;
  /** Default value: `line` */
  "know sure thing.kst.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "know sure thing.kst.trackprice": boolean;
  /** Default value: `0` */
  "know sure thing.kst.transparency": number;
  /** Default value: `#089981` */
  "know sure thing.kst.color": string;
  /** Default value: `15` */
  "know sure thing.signal.display": number;
  /** Default value: `0` */
  "know sure thing.signal.linestyle": number;
  /** Default value: `1` */
  "know sure thing.signal.linewidth": number;
  /** Default value: `line` */
  "know sure thing.signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "know sure thing.signal.trackprice": boolean;
  /** Default value: `0` */
  "know sure thing.signal.transparency": number;
  /** Default value: `#F23645` */
  "know sure thing.signal.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.roclen1": number;
  /**
   * - Default value: `15`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.roclen2": number;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.roclen3": number;
  /**
   * - Default value: `30`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.roclen4": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.smalen1": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.smalen2": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.smalen3": number;
  /**
   * - Default value: `15`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.smalen4": number;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "know sure thing.siglen": number;
  /** Default value: `15` */
  "least squares moving average.plot.display": number;
  /** Default value: `0` */
  "least squares moving average.plot.linestyle": number;
  /** Default value: `1` */
  "least squares moving average.plot.linewidth": number;
  /** Default value: `line` */
  "least squares moving average.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "least squares moving average.plot.trackprice": boolean;
  /** Default value: `0` */
  "least squares moving average.plot.transparency": number;
  /** Default value: `#2196F3` */
  "least squares moving average.plot.color": string;
  /**
   * - Default value: `25`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "least squares moving average.length": number;
  /**
   * - Default value: `0`
   * - Input type: `integer`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "least squares moving average.offset": number;
  /** Default value: `15` */
  "linear regression curve.plot.display": number;
  /** Default value: `0` */
  "linear regression curve.plot.linestyle": number;
  /** Default value: `1` */
  "linear regression curve.plot.linewidth": number;
  /** Default value: `line` */
  "linear regression curve.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "linear regression curve.plot.trackprice": boolean;
  /** Default value: `0` */
  "linear regression curve.plot.transparency": number;
  /** Default value: `#2196F3` */
  "linear regression curve.plot.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "linear regression curve.length": number;
  /** Default value: `15` */
  "linear regression slope.plot.display": number;
  /** Default value: `0` */
  "linear regression slope.plot.linestyle": number;
  /** Default value: `1` */
  "linear regression slope.plot.linewidth": number;
  /** Default value: `line` */
  "linear regression slope.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "linear regression slope.plot.trackprice": boolean;
  /** Default value: `0` */
  "linear regression slope.plot.transparency": number;
  /** Default value: `#FF5252` */
  "linear regression slope.plot.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `2`
   */
  "linear regression slope.periods": number;
  /** Default value: `15` */
  "ma cross.short:plot.display": number;
  /** Default value: `0` */
  "ma cross.short:plot.linestyle": number;
  /** Default value: `1` */
  "ma cross.short:plot.linewidth": number;
  /** Default value: `line` */
  "ma cross.short:plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ma cross.short:plot.trackprice": boolean;
  /** Default value: `0` */
  "ma cross.short:plot.transparency": number;
  /** Default value: `#43A047` */
  "ma cross.short:plot.color": string;
  /** Default value: `15` */
  "ma cross.long:plot.display": number;
  /** Default value: `0` */
  "ma cross.long:plot.linestyle": number;
  /** Default value: `1` */
  "ma cross.long:plot.linewidth": number;
  /** Default value: `line` */
  "ma cross.long:plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ma cross.long:plot.trackprice": boolean;
  /** Default value: `0` */
  "ma cross.long:plot.transparency": number;
  /** Default value: `#FF6D00` */
  "ma cross.long:plot.color": string;
  /** Default value: `15` */
  "ma cross.crosses.display": number;
  /** Default value: `0` */
  "ma cross.crosses.linestyle": number;
  /** Default value: `4` */
  "ma cross.crosses.linewidth": number;
  /** Default value: `cross` */
  "ma cross.crosses.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ma cross.crosses.trackprice": boolean;
  /** Default value: `0` */
  "ma cross.crosses.transparency": number;
  /** Default value: `#2196F3` */
  "ma cross.crosses.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "ma cross.short:input": number;
  /**
   * - Default value: `26`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "ma cross.long:input": number;
  /** Default value: `15` */
  "ma with ema cross.ma.display": number;
  /** Default value: `0` */
  "ma with ema cross.ma.linestyle": number;
  /** Default value: `1` */
  "ma with ema cross.ma.linewidth": number;
  /** Default value: `line` */
  "ma with ema cross.ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ma with ema cross.ma.trackprice": boolean;
  /** Default value: `0` */
  "ma with ema cross.ma.transparency": number;
  /** Default value: `#FF6D00` */
  "ma with ema cross.ma.color": string;
  /** Default value: `15` */
  "ma with ema cross.ema.display": number;
  /** Default value: `0` */
  "ma with ema cross.ema.linestyle": number;
  /** Default value: `1` */
  "ma with ema cross.ema.linewidth": number;
  /** Default value: `line` */
  "ma with ema cross.ema.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ma with ema cross.ema.trackprice": boolean;
  /** Default value: `0` */
  "ma with ema cross.ema.transparency": number;
  /** Default value: `#43A047` */
  "ma with ema cross.ema.color": string;
  /** Default value: `15` */
  "ma with ema cross.crosses.display": number;
  /** Default value: `0` */
  "ma with ema cross.crosses.linestyle": number;
  /** Default value: `4` */
  "ma with ema cross.crosses.linewidth": number;
  /** Default value: `cross` */
  "ma with ema cross.crosses.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ma with ema cross.crosses.trackprice": boolean;
  /** Default value: `0` */
  "ma with ema cross.crosses.transparency": number;
  /** Default value: `#2196F3` */
  "ma with ema cross.crosses.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "ma with ema cross.length ma": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "ma with ema cross.length ema": number;
  /** Default value: `15` */
  "macd.histogram.display": number;
  /** Default value: `0` */
  "macd.histogram.linestyle": number;
  /** Default value: `1` */
  "macd.histogram.linewidth": number;
  /** Default value: `columns` */
  "macd.histogram.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "macd.histogram.trackprice": boolean;
  /** Default value: `0` */
  "macd.histogram.transparency": number;
  /** Default value: `#FF5252` */
  "macd.histogram.color": string;
  /** Default value: `15` */
  "macd.macd.display": number;
  /** Default value: `0` */
  "macd.macd.linestyle": number;
  /** Default value: `1` */
  "macd.macd.linewidth": number;
  /** Default value: `line` */
  "macd.macd.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "macd.macd.trackprice": boolean;
  /** Default value: `0` */
  "macd.macd.transparency": number;
  /** Default value: `#2196F3` */
  "macd.macd.color": string;
  /** Default value: `15` */
  "macd.signal.display": number;
  /** Default value: `0` */
  "macd.signal.linestyle": number;
  /** Default value: `1` */
  "macd.signal.linewidth": number;
  /** Default value: `line` */
  "macd.signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "macd.signal.trackprice": boolean;
  /** Default value: `0` */
  "macd.signal.transparency": number;
  /** Default value: `#FF6D00` */
  "macd.signal.color": string;
  /**
   * - Default value: `12`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "macd.fastlength": number;
  /**
   * - Default value: `26`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "macd.slowlength": number;
  /**
   * - Default value: `close`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "macd.source": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `50`
   */
  "macd.signallength": number;
  /** Default value: `15` */
  "majority rule.majority rule.display": number;
  /** Default value: `0` */
  "majority rule.majority rule.linestyle": number;
  /** Default value: `1` */
  "majority rule.majority rule.linewidth": number;
  /** Default value: `line` */
  "majority rule.majority rule.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "majority rule.majority rule.trackprice": boolean;
  /** Default value: `0` */
  "majority rule.majority rule.transparency": number;
  /** Default value: `#FF5252` */
  "majority rule.majority rule.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   */
  "majority rule.rolling period": number;
  /** Default value: `15` */
  "mass index.plot.display": number;
  /** Default value: `0` */
  "mass index.plot.linestyle": number;
  /** Default value: `1` */
  "mass index.plot.linewidth": number;
  /** Default value: `line` */
  "mass index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "mass index.plot.trackprice": boolean;
  /** Default value: `0` */
  "mass index.plot.transparency": number;
  /** Default value: `#2196F3` */
  "mass index.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "mass index.length": number;
  /** Default value: `15` */
  "mcginley dynamic.plot.display": number;
  /** Default value: `0` */
  "mcginley dynamic.plot.linestyle": number;
  /** Default value: `1` */
  "mcginley dynamic.plot.linewidth": number;
  /** Default value: `line` */
  "mcginley dynamic.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "mcginley dynamic.plot.trackprice": boolean;
  /** Default value: `0` */
  "mcginley dynamic.plot.transparency": number;
  /** Default value: `#2196F3` */
  "mcginley dynamic.plot.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "mcginley dynamic.length": number;
  /** Default value: `15` */
  "median price.plot.display": number;
  /** Default value: `0` */
  "median price.plot.linestyle": number;
  /** Default value: `1` */
  "median price.plot.linewidth": number;
  /** Default value: `line` */
  "median price.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "median price.plot.trackprice": boolean;
  /** Default value: `0` */
  "median price.plot.transparency": number;
  /** Default value: `#FF6D00` */
  "median price.plot.color": string;
  /** Default value: `#787B86` */
  "momentum.zero.color": string;
  /** Default value: `2` */
  "momentum.zero.linestyle": number;
  /** Default value: `1` */
  "momentum.zero.linewidth": number;
  /** Default value: `true` */
  "momentum.zero.visible": boolean;
  /** Default value: `0` */
  "momentum.zero.value": number;
  /** Default value: `15` */
  "momentum.mom.display": number;
  /** Default value: `0` */
  "momentum.mom.linestyle": number;
  /** Default value: `1` */
  "momentum.mom.linewidth": number;
  /** Default value: `line` */
  "momentum.mom.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "momentum.mom.trackprice": boolean;
  /** Default value: `0` */
  "momentum.mom.transparency": number;
  /** Default value: `#2196F3` */
  "momentum.mom.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "momentum.length": number;
  /**
   * - Default value: `close`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "momentum.source": string;
  /** Default value: `#7E57C2` */
  "money flow index.hlines background.color": string;
  /** Default value: `90` */
  "money flow index.hlines background.transparency": number;
  /** Default value: `true` */
  "money flow index.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "money flow index.upperlimit.color": string;
  /** Default value: `2` */
  "money flow index.upperlimit.linestyle": number;
  /** Default value: `1` */
  "money flow index.upperlimit.linewidth": number;
  /** Default value: `true` */
  "money flow index.upperlimit.visible": boolean;
  /** Default value: `80` */
  "money flow index.upperlimit.value": number;
  /** Default value: `#787B86` */
  "money flow index.lowerlimit.color": string;
  /** Default value: `2` */
  "money flow index.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "money flow index.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "money flow index.lowerlimit.visible": boolean;
  /** Default value: `20` */
  "money flow index.lowerlimit.value": number;
  /** Default value: `15` */
  "money flow index.plot.display": number;
  /** Default value: `0` */
  "money flow index.plot.linestyle": number;
  /** Default value: `1` */
  "money flow index.plot.linewidth": number;
  /** Default value: `line` */
  "money flow index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "money flow index.plot.trackprice": boolean;
  /** Default value: `0` */
  "money flow index.plot.transparency": number;
  /** Default value: `#7E57C2` */
  "money flow index.plot.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "money flow index.length": number;
  /** Default value: `15` */
  "moving average.plot.display": number;
  /** Default value: `0` */
  "moving average.plot.linestyle": number;
  /** Default value: `1` */
  "moving average.plot.linewidth": number;
  /** Default value: `line` */
  "moving average.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average.plot.trackprice": boolean;
  /** Default value: `0` */
  "moving average.plot.transparency": number;
  /** Default value: `#2196F3` */
  "moving average.plot.color": string;
  /** Default value: `0` */
  "moving average.smoothed ma.display": number;
  /** Default value: `0` */
  "moving average.smoothed ma.linestyle": number;
  /** Default value: `1` */
  "moving average.smoothed ma.linewidth": number;
  /** Default value: `line` */
  "moving average.smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average.smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "moving average.smoothed ma.transparency": number;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   * - Optional: `true`
   * - IsHidden: `false`
   */
  "moving average.other symbol": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average.length": number;
  /**
   * - Default value: `close`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "moving average.source": string;
  /**
   * - Default value: `0`
   * - Input type: `integer`
   * - Min: `-10000`
   * - Max: `10000`
   */
  "moving average.offset": number;
  /**
   * - Default value: `SMA`
   * - Input type: `text`
   * - Options: `["SMA","EMA","WMA"]`
   */
  "moving average.smoothing line": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average.smoothing length": number;
  /** Default value: `15` */
  "moving average adaptive.plot 1.display": number;
  /** Default value: `0` */
  "moving average adaptive.plot 1.linestyle": number;
  /** Default value: `1` */
  "moving average adaptive.plot 1.linewidth": number;
  /** Default value: `line` */
  "moving average adaptive.plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "moving average adaptive.plot 1.transparency": number;
  /** Default value: `false` */
  "moving average adaptive.plot 1.trackprice": boolean;
  /** Default value: `#AB47BC` */
  "moving average adaptive.plot 1.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `2`
   * - Max: `10000`
   */
  "moving average adaptive.period": number;
  /** Default value: `#2196F3` */
  "moving average channel.plots background.color": string;
  /** Default value: `90` */
  "moving average channel.plots background.transparency": number;
  /** Default value: `true` */
  "moving average channel.plots background.visible": boolean;
  /** Default value: `15` */
  "moving average channel.upper.display": number;
  /** Default value: `0` */
  "moving average channel.upper.linestyle": number;
  /** Default value: `1` */
  "moving average channel.upper.linewidth": number;
  /** Default value: `line` */
  "moving average channel.upper.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average channel.upper.trackprice": boolean;
  /** Default value: `0` */
  "moving average channel.upper.transparency": number;
  /** Default value: `#2196F3` */
  "moving average channel.upper.color": string;
  /** Default value: `15` */
  "moving average channel.lower.display": number;
  /** Default value: `0` */
  "moving average channel.lower.linestyle": number;
  /** Default value: `1` */
  "moving average channel.lower.linewidth": number;
  /** Default value: `line` */
  "moving average channel.lower.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average channel.lower.trackprice": boolean;
  /** Default value: `0` */
  "moving average channel.lower.transparency": number;
  /** Default value: `#FF6D00` */
  "moving average channel.lower.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average channel.upper length": number;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average channel.lower length": number;
  /**
   * - Default value: `0`
   * - Input type: `integer`
   * - Min: `-10000`
   * - Max: `10000`
   */
  "moving average channel.upper offset": number;
  /**
   * - Default value: `0`
   * - Input type: `integer`
   * - Min: `-10000`
   * - Max: `10000`
   */
  "moving average channel.lower offset": number;
  /** Default value: `15` */
  "moving average double.plot 1.display": number;
  /** Default value: `0` */
  "moving average double.plot 1.linestyle": number;
  /** Default value: `1` */
  "moving average double.plot 1.linewidth": number;
  /** Default value: `line` */
  "moving average double.plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average double.plot 1.trackprice": boolean;
  /** Default value: `0` */
  "moving average double.plot 1.transparency": number;
  /** Default value: `#FF6D00` */
  "moving average double.plot 1.color": string;
  /** Default value: `15` */
  "moving average double.plot 2.display": number;
  /** Default value: `0` */
  "moving average double.plot 2.linestyle": number;
  /** Default value: `1` */
  "moving average double.plot 2.linewidth": number;
  /** Default value: `line` */
  "moving average double.plot 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average double.plot 2.trackprice": boolean;
  /** Default value: `0` */
  "moving average double.plot 2.transparency": number;
  /** Default value: `#2196F3` */
  "moving average double.plot 2.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average double.1st period": number;
  /**
   * - Default value: `21`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average double.2nd period": number;
  /**
   * - Default value: `Simple`
   * - Input type: `text`
   * - Options: `["Simple","Exponential","Weighted"]`
   */
  "moving average double.method": string;
  /** Default value: `15` */
  "moving average exponential.plot.display": number;
  /** Default value: `0` */
  "moving average exponential.plot.linestyle": number;
  /** Default value: `1` */
  "moving average exponential.plot.linewidth": number;
  /** Default value: `line` */
  "moving average exponential.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average exponential.plot.trackprice": boolean;
  /** Default value: `0` */
  "moving average exponential.plot.transparency": number;
  /** Default value: `#2196F3` */
  "moving average exponential.plot.color": string;
  /** Default value: `0` */
  "moving average exponential.smoothed ma.display": number;
  /** Default value: `0` */
  "moving average exponential.smoothed ma.linestyle": number;
  /** Default value: `1` */
  "moving average exponential.smoothed ma.linewidth": number;
  /** Default value: `line` */
  "moving average exponential.smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average exponential.smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "moving average exponential.smoothed ma.transparency": number;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average exponential.length": number;
  /**
   * - Default value: `close`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "moving average exponential.source": string;
  /**
   * - Default value: `0`
   * - Input type: `integer`
   * - Min: `-10000`
   * - Max: `10000`
   */
  "moving average exponential.offset": number;
  /**
   * - Default value: `SMA`
   * - Input type: `text`
   * - Options: `["SMA","EMA","WMA"]`
   */
  "moving average exponential.smoothing line": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average exponential.smoothing length": number;
  /** Default value: `15` */
  "moving average hamming.plot 1.display": number;
  /** Default value: `0` */
  "moving average hamming.plot 1.linestyle": number;
  /** Default value: `1` */
  "moving average hamming.plot 1.linewidth": number;
  /** Default value: `line` */
  "moving average hamming.plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "moving average hamming.plot 1.transparency": number;
  /** Default value: `false` */
  "moving average hamming.plot 1.trackprice": boolean;
  /** Default value: `#4CAF50` */
  "moving average hamming.plot 1.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average hamming.period": number;
  /** Default value: `15` */
  "moving average multiple.plot 1.display": number;
  /** Default value: `0` */
  "moving average multiple.plot 1.linestyle": number;
  /** Default value: `1` */
  "moving average multiple.plot 1.linewidth": number;
  /** Default value: `line` */
  "moving average multiple.plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "moving average multiple.plot 1.transparency": number;
  /** Default value: `false` */
  "moving average multiple.plot 1.trackprice": boolean;
  /** Default value: `#9C27B0` */
  "moving average multiple.plot 1.color": string;
  /** Default value: `15` */
  "moving average multiple.plot 2.display": number;
  /** Default value: `0` */
  "moving average multiple.plot 2.linestyle": number;
  /** Default value: `1` */
  "moving average multiple.plot 2.linewidth": number;
  /** Default value: `0` */
  "moving average multiple.plot 2.transparency": number;
  /** Default value: `line` */
  "moving average multiple.plot 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average multiple.plot 2.trackprice": boolean;
  /** Default value: `#FF6D00` */
  "moving average multiple.plot 2.color": string;
  /** Default value: `15` */
  "moving average multiple.plot 3.display": number;
  /** Default value: `0` */
  "moving average multiple.plot 3.linestyle": number;
  /** Default value: `1` */
  "moving average multiple.plot 3.linewidth": number;
  /** Default value: `0` */
  "moving average multiple.plot 3.transparency": number;
  /** Default value: `line` */
  "moving average multiple.plot 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average multiple.plot 3.trackprice": boolean;
  /** Default value: `#43A047` */
  "moving average multiple.plot 3.color": string;
  /** Default value: `15` */
  "moving average multiple.plot 4.display": number;
  /** Default value: `0` */
  "moving average multiple.plot 4.linestyle": number;
  /** Default value: `1` */
  "moving average multiple.plot 4.linewidth": number;
  /** Default value: `0` */
  "moving average multiple.plot 4.transparency": number;
  /** Default value: `line` */
  "moving average multiple.plot 4.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average multiple.plot 4.trackprice": boolean;
  /** Default value: `#26C6DA` */
  "moving average multiple.plot 4.color": string;
  /** Default value: `15` */
  "moving average multiple.plot 5.display": number;
  /** Default value: `0` */
  "moving average multiple.plot 5.linestyle": number;
  /** Default value: `1` */
  "moving average multiple.plot 5.linewidth": number;
  /** Default value: `0` */
  "moving average multiple.plot 5.transparency": number;
  /** Default value: `line` */
  "moving average multiple.plot 5.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average multiple.plot 5.trackprice": boolean;
  /** Default value: `#F50057` */
  "moving average multiple.plot 5.color": string;
  /** Default value: `15` */
  "moving average multiple.plot 6.display": number;
  /** Default value: `0` */
  "moving average multiple.plot 6.linestyle": number;
  /** Default value: `1` */
  "moving average multiple.plot 6.linewidth": number;
  /** Default value: `0` */
  "moving average multiple.plot 6.transparency": number;
  /** Default value: `line` */
  "moving average multiple.plot 6.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average multiple.plot 6.trackprice": boolean;
  /** Default value: `#2196F3` */
  "moving average multiple.plot 6.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average multiple.1st period": number;
  /**
   * - Default value: `21`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average multiple.2nd period": number;
  /**
   * - Default value: `35`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average multiple.3rd period": number;
  /**
   * - Default value: `50`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average multiple.4th period": number;
  /**
   * - Default value: `100`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average multiple.5th period": number;
  /**
   * - Default value: `200`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average multiple.6th period": number;
  /**
   * - Default value: `Simple`
   * - Input type: `text`
   * - Options: `["Simple","Exponential","Weighted"]`
   */
  "moving average multiple.method": string;
  /** Default value: `15` */
  "moving average triple.plot 1.display": number;
  /** Default value: `0` */
  "moving average triple.plot 1.linestyle": number;
  /** Default value: `1` */
  "moving average triple.plot 1.linewidth": number;
  /** Default value: `line` */
  "moving average triple.plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "moving average triple.plot 1.transparency": number;
  /** Default value: `false` */
  "moving average triple.plot 1.trackprice": boolean;
  /** Default value: `#FF6D00` */
  "moving average triple.plot 1.color": string;
  /** Default value: `15` */
  "moving average triple.plot 2.display": number;
  /** Default value: `0` */
  "moving average triple.plot 2.linestyle": number;
  /** Default value: `1` */
  "moving average triple.plot 2.linewidth": number;
  /** Default value: `0` */
  "moving average triple.plot 2.transparency": number;
  /** Default value: `line` */
  "moving average triple.plot 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average triple.plot 2.trackprice": boolean;
  /** Default value: `#2196F3` */
  "moving average triple.plot 2.color": string;
  /** Default value: `15` */
  "moving average triple.plot 3.display": number;
  /** Default value: `0` */
  "moving average triple.plot 3.linestyle": number;
  /** Default value: `1` */
  "moving average triple.plot 3.linewidth": number;
  /** Default value: `0` */
  "moving average triple.plot 3.transparency": number;
  /** Default value: `line` */
  "moving average triple.plot 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average triple.plot 3.trackprice": boolean;
  /** Default value: `#26C6DA` */
  "moving average triple.plot 3.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average triple.1st period": number;
  /**
   * - Default value: `21`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average triple.2nd period": number;
  /**
   * - Default value: `35`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "moving average triple.3rd period": number;
  /**
   * - Default value: `Simple`
   * - Input type: `text`
   * - Options: `["Simple","Exponential","Weighted"]`
   */
  "moving average triple.method": string;
  /** Default value: `15` */
  "moving average weighted.plot.display": number;
  /** Default value: `0` */
  "moving average weighted.plot.linestyle": number;
  /** Default value: `1` */
  "moving average weighted.plot.linewidth": number;
  /** Default value: `line` */
  "moving average weighted.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "moving average weighted.plot.trackprice": boolean;
  /** Default value: `0` */
  "moving average weighted.plot.transparency": number;
  /** Default value: `#2196F3` */
  "moving average weighted.plot.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "moving average weighted.length": number;
  /**
   * - Default value: `close`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "moving average weighted.source": string;
  /**
   * - Default value: `0`
   * - Input type: `integer`
   * - Min: `-10000`
   * - Max: `10000`
   */
  "moving average weighted.offset": number;
  /** Default value: `15` */
  "net volume.plot.display": number;
  /** Default value: `0` */
  "net volume.plot.linestyle": number;
  /** Default value: `1` */
  "net volume.plot.linewidth": number;
  /** Default value: `line` */
  "net volume.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "net volume.plot.trackprice": boolean;
  /** Default value: `0` */
  "net volume.plot.transparency": number;
  /** Default value: `#2196F3` */
  "net volume.plot.color": string;
  /** Default value: `15` */
  "on balance volume.plot.display": number;
  /** Default value: `0` */
  "on balance volume.plot.linestyle": number;
  /** Default value: `1` */
  "on balance volume.plot.linewidth": number;
  /** Default value: `line` */
  "on balance volume.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "on balance volume.plot.trackprice": boolean;
  /** Default value: `0` */
  "on balance volume.plot.transparency": number;
  /** Default value: `#2196F3` */
  "on balance volume.plot.color": string;
  /** Default value: `0` */
  "on balance volume.smoothed ma.display": number;
  /** Default value: `0` */
  "on balance volume.smoothed ma.linestyle": number;
  /** Default value: `1` */
  "on balance volume.smoothed ma.linewidth": number;
  /** Default value: `line` */
  "on balance volume.smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "on balance volume.smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "on balance volume.smoothed ma.transparency": number;
  /**
   * - Default value: `SMA`
   * - Input type: `text`
   * - Options: `["SMA","EMA","WMA"]`
   */
  "on balance volume.smoothing line": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "on balance volume.smoothing length": number;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   * - IsHidden: `true`
   */
  "overlay.symbol": string;
  /**
   * - Default value: `false`
   * - Input type: `boolean`
   * - IsHidden: `true`
   */
  "overlay.extendtimescale": boolean;
  /** Default value: `15` */
  "parabolic sar.plot.display": number;
  /** Default value: `0` */
  "parabolic sar.plot.linestyle": number;
  /** Default value: `1` */
  "parabolic sar.plot.linewidth": number;
  /** Default value: `cross` */
  "parabolic sar.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "parabolic sar.plot.trackprice": boolean;
  /** Default value: `0` */
  "parabolic sar.plot.transparency": number;
  /** Default value: `#2196F3` */
  "parabolic sar.plot.color": string;
  /**
   * - Default value: `0.02`
   * - Input type: `float`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "parabolic sar.start": number;
  /**
   * - Default value: `0.02`
   * - Input type: `float`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "parabolic sar.increment": number;
  /**
   * - Default value: `0.2`
   * - Input type: `float`
   * - Min: `-1000000000000`
   * - Max: `1000000000000`
   */
  "parabolic sar.maximum": number;
  /**
   * - Default value: `Traditional`
   * - Input type: `text`
   * - Options: `["Traditional","Fibonacci","Woodie","Classic","DeMark","Camarilla","Floor"]`
   */
  "pivot points standard.type": string;
  /**
   * - Default value: `15`
   * - Input type: `integer`
   * - Max: `5000`
   * - Min: `1`
   */
  "pivot points standard.number of pivots back": number;
  /**
   * - Default value: `Auto`
   * - Input type: `text`
   * - Options: `["Auto","Daily","Weekly","Monthly","Yearly"]`
   */
  "pivot points standard.pivots timeframe": string;
  /**
   * - Default value: `true`
   * - Input type: `bool`
   */
  "pivot points standard.show historical pivots": boolean;
  /** Default value: `15` */
  "price channel.highprice line.display": number;
  /** Default value: `0` */
  "price channel.highprice line.linestyle": number;
  /** Default value: `1` */
  "price channel.highprice line.linewidth": number;
  /** Default value: `line` */
  "price channel.highprice line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "price channel.highprice line.trackprice": boolean;
  /** Default value: `0` */
  "price channel.highprice line.transparency": number;
  /** Default value: `#F50057` */
  "price channel.highprice line.color": string;
  /** Default value: `15` */
  "price channel.lowprice line.display": number;
  /** Default value: `0` */
  "price channel.lowprice line.linestyle": number;
  /** Default value: `1` */
  "price channel.lowprice line.linewidth": number;
  /** Default value: `line` */
  "price channel.lowprice line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "price channel.lowprice line.trackprice": boolean;
  /** Default value: `0` */
  "price channel.lowprice line.transparency": number;
  /** Default value: `#F50057` */
  "price channel.lowprice line.color": string;
  /** Default value: `15` */
  "price channel.centerprice line.display": number;
  /** Default value: `0` */
  "price channel.centerprice line.linestyle": number;
  /** Default value: `1` */
  "price channel.centerprice line.linewidth": number;
  /** Default value: `line` */
  "price channel.centerprice line.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "price channel.centerprice line.trackprice": boolean;
  /** Default value: `0` */
  "price channel.centerprice line.transparency": number;
  /** Default value: `#2196F3` */
  "price channel.centerprice line.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "price channel.length": number;
  /**
   * - Default value: `0`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "price channel.offset length": number;
  /** Default value: `15` */
  "price oscillator.plot.display": number;
  /** Default value: `0` */
  "price oscillator.plot.linestyle": number;
  /** Default value: `1` */
  "price oscillator.plot.linewidth": number;
  /** Default value: `line` */
  "price oscillator.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "price oscillator.plot.trackprice": boolean;
  /** Default value: `0` */
  "price oscillator.plot.transparency": number;
  /** Default value: `#089981` */
  "price oscillator.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "price oscillator.shortlen": number;
  /**
   * - Default value: `21`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "price oscillator.longlen": number;
  /** Default value: `15` */
  "price volume trend.pvt.display": number;
  /** Default value: `0` */
  "price volume trend.pvt.linestyle": number;
  /** Default value: `1` */
  "price volume trend.pvt.linewidth": number;
  /** Default value: `line` */
  "price volume trend.pvt.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "price volume trend.pvt.trackprice": boolean;
  /** Default value: `0` */
  "price volume trend.pvt.transparency": number;
  /** Default value: `#2196F3` */
  "price volume trend.pvt.color": string;
  /** Default value: `#787B86` */
  "rate of change.zero line.color": string;
  /** Default value: `2` */
  "rate of change.zero line.linestyle": number;
  /** Default value: `1` */
  "rate of change.zero line.linewidth": number;
  /** Default value: `true` */
  "rate of change.zero line.visible": boolean;
  /** Default value: `0` */
  "rate of change.zero line.value": number;
  /** Default value: `15` */
  "rate of change.roc.display": number;
  /** Default value: `0` */
  "rate of change.roc.linestyle": number;
  /** Default value: `1` */
  "rate of change.roc.linewidth": number;
  /** Default value: `line` */
  "rate of change.roc.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "rate of change.roc.trackprice": boolean;
  /** Default value: `0` */
  "rate of change.roc.transparency": number;
  /** Default value: `#2196F3` */
  "rate of change.roc.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "rate of change.length": number;
  /** Default value: `0` */
  "ratio.plot.linestyle": number;
  /** Default value: `2` */
  "ratio.plot.linewidth": number;
  /** Default value: `line` */
  "ratio.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ratio.plot.trackprice": boolean;
  /** Default value: `35` */
  "ratio.plot.transparency": number;
  /** Default value: `#800080` */
  "ratio.plot.color": string;
  /** Default value: `15` */
  "ratio.plot.display": number;
  /**
   * - Default value: `close`
   * - Input type: `text`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "ratio.source": string;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   * - Confirm: `true`
   */
  "ratio.symbol": string;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "regression trend.first bar time": number;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "regression trend.last bar time": number;
  /**
   * - Default value: `-2`
   * - Input type: `float`
   * - Max: `500`
   * - Min: `-500`
   */
  "regression trend.lower deviation": number;
  /**
   * - Default value: `close`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "regression trend.source": string;
  /**
   * - Default value: `2`
   * - Input type: `float`
   * - Max: `500`
   * - Min: `-500`
   */
  "regression trend.upper deviation": number;
  /**
   * - Default value: `true`
   * - Input type: `bool`
   */
  "regression trend.use lower deviation": boolean;
  /**
   * - Default value: `true`
   * - Input type: `bool`
   */
  "regression trend.use upper deviation": boolean;
  /** Default value: `#7E57C2` */
  "relative strength index.hlines background.color": string;
  /** Default value: `90` */
  "relative strength index.hlines background.transparency": number;
  /** Default value: `true` */
  "relative strength index.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "relative strength index.upperlimit.color": string;
  /** Default value: `2` */
  "relative strength index.upperlimit.linestyle": number;
  /** Default value: `1` */
  "relative strength index.upperlimit.linewidth": number;
  /** Default value: `true` */
  "relative strength index.upperlimit.visible": boolean;
  /** Default value: `70` */
  "relative strength index.upperlimit.value": number;
  /** Default value: `-1.1` */
  "relative strength index.upperlimit.zorder": number;
  /** Default value: `#787B86` */
  "relative strength index.middlelimit.color": string;
  /** Default value: `2` */
  "relative strength index.middlelimit.linestyle": number;
  /** Default value: `1` */
  "relative strength index.middlelimit.linewidth": number;
  /** Default value: `true` */
  "relative strength index.middlelimit.visible": boolean;
  /** Default value: `50` */
  "relative strength index.middlelimit.value": number;
  /** Default value: `-1.11` */
  "relative strength index.middlelimit.zorder": number;
  /** Default value: `#787B86` */
  "relative strength index.lowerlimit.color": string;
  /** Default value: `2` */
  "relative strength index.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "relative strength index.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "relative strength index.lowerlimit.visible": boolean;
  /** Default value: `30` */
  "relative strength index.lowerlimit.value": number;
  /** Default value: `-1.111` */
  "relative strength index.lowerlimit.zorder": number;
  /** Default value: `15` */
  "relative strength index.plot.display": number;
  /** Default value: `0` */
  "relative strength index.plot.linestyle": number;
  /** Default value: `1` */
  "relative strength index.plot.linewidth": number;
  /** Default value: `line` */
  "relative strength index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "relative strength index.plot.trackprice": boolean;
  /** Default value: `0` */
  "relative strength index.plot.transparency": number;
  /** Default value: `#7E57C2` */
  "relative strength index.plot.color": string;
  /** Default value: `0` */
  "relative strength index.smoothed ma.display": number;
  /** Default value: `0` */
  "relative strength index.smoothed ma.linestyle": number;
  /** Default value: `1` */
  "relative strength index.smoothed ma.linewidth": number;
  /** Default value: `line` */
  "relative strength index.smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "relative strength index.smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "relative strength index.smoothed ma.transparency": number;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "relative strength index.length": number;
  /**
   * - Default value: `SMA`
   * - Input type: `text`
   * - Options: `["SMA","EMA","WMA"]`
   */
  "relative strength index.smoothing line": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "relative strength index.smoothing length": number;
  /** Default value: `15` */
  "relative vigor index.rvgi.display": number;
  /** Default value: `0` */
  "relative vigor index.rvgi.linestyle": number;
  /** Default value: `1` */
  "relative vigor index.rvgi.linewidth": number;
  /** Default value: `line` */
  "relative vigor index.rvgi.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "relative vigor index.rvgi.trackprice": boolean;
  /** Default value: `0` */
  "relative vigor index.rvgi.transparency": number;
  /** Default value: `#089981` */
  "relative vigor index.rvgi.color": string;
  /** Default value: `15` */
  "relative vigor index.signal.display": number;
  /** Default value: `0` */
  "relative vigor index.signal.linestyle": number;
  /** Default value: `1` */
  "relative vigor index.signal.linewidth": number;
  /** Default value: `line` */
  "relative vigor index.signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "relative vigor index.signal.trackprice": boolean;
  /** Default value: `0` */
  "relative vigor index.signal.transparency": number;
  /** Default value: `#F23645` */
  "relative vigor index.signal.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "relative vigor index.length": number;
  /** Default value: `#7E57C2` */
  "relative volatility index.hlines background.color": string;
  /** Default value: `90` */
  "relative volatility index.hlines background.transparency": number;
  /** Default value: `true` */
  "relative volatility index.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "relative volatility index.upperlimit.color": string;
  /** Default value: `2` */
  "relative volatility index.upperlimit.linestyle": number;
  /** Default value: `1` */
  "relative volatility index.upperlimit.linewidth": number;
  /** Default value: `true` */
  "relative volatility index.upperlimit.visible": boolean;
  /** Default value: `80` */
  "relative volatility index.upperlimit.value": number;
  /** Default value: `#787B86` */
  "relative volatility index.lowerlimit.color": string;
  /** Default value: `2` */
  "relative volatility index.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "relative volatility index.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "relative volatility index.lowerlimit.visible": boolean;
  /** Default value: `20` */
  "relative volatility index.lowerlimit.value": number;
  /** Default value: `15` */
  "relative volatility index.plot.display": number;
  /** Default value: `0` */
  "relative volatility index.plot.linestyle": number;
  /** Default value: `1` */
  "relative volatility index.plot.linewidth": number;
  /** Default value: `line` */
  "relative volatility index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "relative volatility index.plot.trackprice": boolean;
  /** Default value: `0` */
  "relative volatility index.plot.transparency": number;
  /** Default value: `#7E57C2` */
  "relative volatility index.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "relative volatility index.length": number;
  /** Default value: `15` */
  "smi ergodic indicator/oscillator.indicator.display": number;
  /** Default value: `0` */
  "smi ergodic indicator/oscillator.indicator.linestyle": number;
  /** Default value: `1` */
  "smi ergodic indicator/oscillator.indicator.linewidth": number;
  /** Default value: `line` */
  "smi ergodic indicator/oscillator.indicator.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smi ergodic indicator/oscillator.indicator.trackprice": boolean;
  /** Default value: `0` */
  "smi ergodic indicator/oscillator.indicator.transparency": number;
  /** Default value: `#2196F3` */
  "smi ergodic indicator/oscillator.indicator.color": string;
  /** Default value: `15` */
  "smi ergodic indicator/oscillator.signal.display": number;
  /** Default value: `0` */
  "smi ergodic indicator/oscillator.signal.linestyle": number;
  /** Default value: `1` */
  "smi ergodic indicator/oscillator.signal.linewidth": number;
  /** Default value: `line` */
  "smi ergodic indicator/oscillator.signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smi ergodic indicator/oscillator.signal.trackprice": boolean;
  /** Default value: `0` */
  "smi ergodic indicator/oscillator.signal.transparency": number;
  /** Default value: `#FF6D00` */
  "smi ergodic indicator/oscillator.signal.color": string;
  /** Default value: `15` */
  "smi ergodic indicator/oscillator.oscillator.display": number;
  /** Default value: `0` */
  "smi ergodic indicator/oscillator.oscillator.linestyle": number;
  /** Default value: `1` */
  "smi ergodic indicator/oscillator.oscillator.linewidth": number;
  /** Default value: `histogram` */
  "smi ergodic indicator/oscillator.oscillator.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smi ergodic indicator/oscillator.oscillator.trackprice": boolean;
  /** Default value: `0` */
  "smi ergodic indicator/oscillator.oscillator.transparency": number;
  /** Default value: `#FF5252` */
  "smi ergodic indicator/oscillator.oscillator.color": string;
  /**
   * - Default value: `5`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "smi ergodic indicator/oscillator.shortlen": number;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "smi ergodic indicator/oscillator.longlen": number;
  /**
   * - Default value: `5`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "smi ergodic indicator/oscillator.siglen": number;
  /** Default value: `15` */
  "smoothed moving average.plot.display": number;
  /** Default value: `0` */
  "smoothed moving average.plot.linestyle": number;
  /** Default value: `1` */
  "smoothed moving average.plot.linewidth": number;
  /** Default value: `line` */
  "smoothed moving average.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smoothed moving average.plot.trackprice": boolean;
  /** Default value: `0` */
  "smoothed moving average.plot.transparency": number;
  /** Default value: `#673AB7` */
  "smoothed moving average.plot.color": string;
  /**
   * - Default value: `7`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "smoothed moving average.length": number;
  /**
   * - Default value: `close`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "smoothed moving average.source": string;
  /** Default value: `0` */
  "spread.negative fill.transparency": number;
  /** Default value: `true` */
  "spread.negative fill.visible": boolean;
  /** Default value: `0` */
  "spread.positive fill.transparency": number;
  /** Default value: `true` */
  "spread.positive fill.visible": boolean;
  /** Default value: `0` */
  "spread.plot.linestyle": number;
  /** Default value: `2` */
  "spread.plot.linewidth": number;
  /** Default value: `line` */
  "spread.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "spread.plot.trackprice": boolean;
  /** Default value: `35` */
  "spread.plot.transparency": number;
  /** Default value: `#800080` */
  "spread.plot.color": string;
  /** Default value: `15` */
  "spread.plot.display": number;
  /** Default value: `0` */
  "spread.baseline.linestyle": number;
  /** Default value: `2` */
  "spread.baseline.linewidth": number;
  /** Default value: `line` */
  "spread.baseline.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "spread.baseline.trackprice": boolean;
  /** Default value: `0` */
  "spread.baseline.transparency": number;
  /** Default value: `rgba(0, 0, 0, 0)` */
  "spread.baseline.color": string;
  /** Default value: `0` */
  "spread.baseline.display": number;
  /**
   * - Default value: `close`
   * - Input type: `text`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "spread.source": string;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   * - Confirm: `true`
   */
  "spread.symbol": string;
  /** Default value: `15` */
  "standard deviation.plot.display": number;
  /** Default value: `0` */
  "standard deviation.plot.linestyle": number;
  /** Default value: `1` */
  "standard deviation.plot.linewidth": number;
  /** Default value: `line` */
  "standard deviation.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "standard deviation.plot.trackprice": boolean;
  /** Default value: `0` */
  "standard deviation.plot.transparency": number;
  /** Default value: `#089981` */
  "standard deviation.plot.color": string;
  /**
   * - Default value: `5`
   * - Input type: `integer`
   */
  "standard deviation.periods": number;
  /**
   * - Default value: `1`
   * - Input type: `float`
   */
  "standard deviation.deviations": number;
  /** Default value: `15` */
  "standard error.plot.display": number;
  /** Default value: `0` */
  "standard error.plot.linestyle": number;
  /** Default value: `1` */
  "standard error.plot.linewidth": number;
  /** Default value: `line` */
  "standard error.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "standard error.plot.trackprice": boolean;
  /** Default value: `0` */
  "standard error.plot.transparency": number;
  /** Default value: `#FF6D00` */
  "standard error.plot.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `3`
   */
  "standard error.length": number;
  /** Default value: `#2196F3` */
  "standard error bands.background.color": string;
  /** Default value: `95` */
  "standard error bands.background.transparency": number;
  /** Default value: `true` */
  "standard error bands.background.visible": boolean;
  /** Default value: `15` */
  "standard error bands.plot 1.display": number;
  /** Default value: `0` */
  "standard error bands.plot 1.linestyle": number;
  /** Default value: `1` */
  "standard error bands.plot 1.linewidth": number;
  /** Default value: `line` */
  "standard error bands.plot 1.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "standard error bands.plot 1.transparency": number;
  /** Default value: `false` */
  "standard error bands.plot 1.trackprice": boolean;
  /** Default value: `#2196F3` */
  "standard error bands.plot 1.color": string;
  /** Default value: `15` */
  "standard error bands.plot 2.display": number;
  /** Default value: `0` */
  "standard error bands.plot 2.linestyle": number;
  /** Default value: `1` */
  "standard error bands.plot 2.linewidth": number;
  /** Default value: `0` */
  "standard error bands.plot 2.transparency": number;
  /** Default value: `line` */
  "standard error bands.plot 2.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "standard error bands.plot 2.trackprice": boolean;
  /** Default value: `#FF6D00` */
  "standard error bands.plot 2.color": string;
  /** Default value: `15` */
  "standard error bands.plot 3.display": number;
  /** Default value: `0` */
  "standard error bands.plot 3.linestyle": number;
  /** Default value: `1` */
  "standard error bands.plot 3.linewidth": number;
  /** Default value: `0` */
  "standard error bands.plot 3.transparency": number;
  /** Default value: `line` */
  "standard error bands.plot 3.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "standard error bands.plot 3.trackprice": boolean;
  /** Default value: `#2196F3` */
  "standard error bands.plot 3.color": string;
  /**
   * - Default value: `21`
   * - Input type: `integer`
   */
  "standard error bands.periods": number;
  /**
   * - Default value: `2`
   * - Input type: `float`
   */
  "standard error bands.standard errors": number;
  /**
   * - Default value: `Simple`
   * - Input type: `text`
   * - Options: `["Simple","Exponential","Weighted"]`
   */
  "standard error bands.method": string;
  /**
   * - Default value: `3`
   * - Input type: `integer`
   */
  "standard error bands.averaging periods": number;
  /** Default value: `#2196F3` */
  "stochastic.hlines background.color": string;
  /** Default value: `90` */
  "stochastic.hlines background.transparency": number;
  /** Default value: `true` */
  "stochastic.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "stochastic.upperlimit.color": string;
  /** Default value: `2` */
  "stochastic.upperlimit.linestyle": number;
  /** Default value: `1` */
  "stochastic.upperlimit.linewidth": number;
  /** Default value: `true` */
  "stochastic.upperlimit.visible": boolean;
  /** Default value: `80` */
  "stochastic.upperlimit.value": number;
  /** Default value: `#787B86` */
  "stochastic.lowerlimit.color": string;
  /** Default value: `2` */
  "stochastic.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "stochastic.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "stochastic.lowerlimit.visible": boolean;
  /** Default value: `20` */
  "stochastic.lowerlimit.value": number;
  /** Default value: `15` */
  "stochastic.%k.display": number;
  /** Default value: `0` */
  "stochastic.%k.linestyle": number;
  /** Default value: `1` */
  "stochastic.%k.linewidth": number;
  /** Default value: `line` */
  "stochastic.%k.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "stochastic.%k.trackprice": boolean;
  /** Default value: `0` */
  "stochastic.%k.transparency": number;
  /** Default value: `#2196F3` */
  "stochastic.%k.color": string;
  /** Default value: `15` */
  "stochastic.%d.display": number;
  /** Default value: `0` */
  "stochastic.%d.linestyle": number;
  /** Default value: `1` */
  "stochastic.%d.linewidth": number;
  /** Default value: `line` */
  "stochastic.%d.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "stochastic.%d.trackprice": boolean;
  /** Default value: `0` */
  "stochastic.%d.transparency": number;
  /** Default value: `#FF6D00` */
  "stochastic.%d.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "stochastic.%k length": number;
  /**
   * - Default value: `1`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "stochastic.%k smoothing": number;
  /**
   * - Default value: `3`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "stochastic.%d smoothing": number;
  /** Default value: `#2196F3` */
  "stochastic rsi.hlines background.color": string;
  /** Default value: `90` */
  "stochastic rsi.hlines background.transparency": number;
  /** Default value: `true` */
  "stochastic rsi.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "stochastic rsi.upperlimit.color": string;
  /** Default value: `2` */
  "stochastic rsi.upperlimit.linestyle": number;
  /** Default value: `1` */
  "stochastic rsi.upperlimit.linewidth": number;
  /** Default value: `true` */
  "stochastic rsi.upperlimit.visible": boolean;
  /** Default value: `80` */
  "stochastic rsi.upperlimit.value": number;
  /** Default value: `#787B86` */
  "stochastic rsi.lowerlimit.color": string;
  /** Default value: `2` */
  "stochastic rsi.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "stochastic rsi.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "stochastic rsi.lowerlimit.visible": boolean;
  /** Default value: `20` */
  "stochastic rsi.lowerlimit.value": number;
  /** Default value: `15` */
  "stochastic rsi.%k.display": number;
  /** Default value: `0` */
  "stochastic rsi.%k.linestyle": number;
  /** Default value: `1` */
  "stochastic rsi.%k.linewidth": number;
  /** Default value: `line` */
  "stochastic rsi.%k.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "stochastic rsi.%k.trackprice": boolean;
  /** Default value: `0` */
  "stochastic rsi.%k.transparency": number;
  /** Default value: `#2196F3` */
  "stochastic rsi.%k.color": string;
  /** Default value: `15` */
  "stochastic rsi.%d.display": number;
  /** Default value: `0` */
  "stochastic rsi.%d.linestyle": number;
  /** Default value: `1` */
  "stochastic rsi.%d.linewidth": number;
  /** Default value: `line` */
  "stochastic rsi.%d.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "stochastic rsi.%d.trackprice": boolean;
  /** Default value: `0` */
  "stochastic rsi.%d.transparency": number;
  /** Default value: `#FF6D00` */
  "stochastic rsi.%d.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "stochastic rsi.lengthrsi": number;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "stochastic rsi.lengthstoch": number;
  /**
   * - Default value: `3`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "stochastic rsi.smoothk": number;
  /**
   * - Default value: `3`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "stochastic rsi.smoothd": number;
  /** Default value: `15` */
  "supertrend.supertrend.display": number;
  /** Default value: `0` */
  "supertrend.supertrend.linestyle": number;
  /** Default value: `3` */
  "supertrend.supertrend.linewidth": number;
  /** Default value: `line` */
  "supertrend.supertrend.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "supertrend.supertrend.trackprice": boolean;
  /** Default value: `35` */
  "supertrend.supertrend.transparency": number;
  /** Default value: `#000080` */
  "supertrend.supertrend.color": string;
  /** Default value: `15` */
  "supertrend.up arrow.display": number;
  /** Default value: `0` */
  "supertrend.up arrow.linestyle": number;
  /** Default value: `3` */
  "supertrend.up arrow.linewidth": number;
  /** Default value: `shape_arrow_up` */
  "supertrend.up arrow.plottype": string;
  /** Default value: `false` */
  "supertrend.up arrow.trackprice": boolean;
  /** Default value: `BelowBar` */
  "supertrend.up arrow.location": string;
  /** Default value: `35` */
  "supertrend.up arrow.transparency": number;
  /** Default value: `#00FF00` */
  "supertrend.up arrow.color": string;
  /** Default value: `15` */
  "supertrend.down arrow.display": number;
  /** Default value: `0` */
  "supertrend.down arrow.linestyle": number;
  /** Default value: `3` */
  "supertrend.down arrow.linewidth": number;
  /** Default value: `shape_arrow_down` */
  "supertrend.down arrow.plottype": string;
  /** Default value: `false` */
  "supertrend.down arrow.trackprice": boolean;
  /** Default value: `AboveBar` */
  "supertrend.down arrow.location": string;
  /** Default value: `35` */
  "supertrend.down arrow.transparency": number;
  /** Default value: `#FF0000` */
  "supertrend.down arrow.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `100`
   */
  "supertrend.length": number;
  /**
   * - Default value: `3`
   * - Input type: `float`
   * - Min: `1`
   * - Max: `100`
   */
  "supertrend.factor": number;
  /** Default value: `#787B86` */
  "trix.zero.color": string;
  /** Default value: `2` */
  "trix.zero.linestyle": number;
  /** Default value: `1` */
  "trix.zero.linewidth": number;
  /** Default value: `true` */
  "trix.zero.visible": boolean;
  /** Default value: `0` */
  "trix.zero.value": number;
  /** Default value: `15` */
  "trix.trix.display": number;
  /** Default value: `0` */
  "trix.trix.linestyle": number;
  /** Default value: `1` */
  "trix.trix.linewidth": number;
  /** Default value: `line` */
  "trix.trix.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trix.trix.trackprice": boolean;
  /** Default value: `0` */
  "trix.trix.transparency": number;
  /** Default value: `#F23645` */
  "trix.trix.color": string;
  /**
   * - Default value: `18`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "trix.length": number;
  /** Default value: `15` */
  "trend strength index.plot.display": number;
  /** Default value: `0` */
  "trend strength index.plot.linestyle": number;
  /** Default value: `1` */
  "trend strength index.plot.linewidth": number;
  /** Default value: `line` */
  "trend strength index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trend strength index.plot.trackprice": boolean;
  /** Default value: `0` */
  "trend strength index.plot.transparency": number;
  /** Default value: `#FF5252` */
  "trend strength index.plot.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   */
  "trend strength index.periods": number;
  /** Default value: `15` */
  "triple ema.plot.display": number;
  /** Default value: `0` */
  "triple ema.plot.linestyle": number;
  /** Default value: `1` */
  "triple ema.plot.linewidth": number;
  /** Default value: `line` */
  "triple ema.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "triple ema.plot.trackprice": boolean;
  /** Default value: `0` */
  "triple ema.plot.transparency": number;
  /** Default value: `#2196F3` */
  "triple ema.plot.color": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "triple ema.length": number;
  /** Default value: `#787B86` */
  "true strength index.zero.color": string;
  /** Default value: `2` */
  "true strength index.zero.linestyle": number;
  /** Default value: `1` */
  "true strength index.zero.linewidth": number;
  /** Default value: `true` */
  "true strength index.zero.visible": boolean;
  /** Default value: `0` */
  "true strength index.zero.value": number;
  /** Default value: `15` */
  "true strength index.true strength index.display": number;
  /** Default value: `0` */
  "true strength index.true strength index.linestyle": number;
  /** Default value: `1` */
  "true strength index.true strength index.linewidth": number;
  /** Default value: `line` */
  "true strength index.true strength index.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "true strength index.true strength index.trackprice": boolean;
  /** Default value: `0` */
  "true strength index.true strength index.transparency": number;
  /** Default value: `#2196F3` */
  "true strength index.true strength index.color": string;
  /** Default value: `15` */
  "true strength index.signal.display": number;
  /** Default value: `0` */
  "true strength index.signal.linestyle": number;
  /** Default value: `1` */
  "true strength index.signal.linewidth": number;
  /** Default value: `line` */
  "true strength index.signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "true strength index.signal.trackprice": boolean;
  /** Default value: `0` */
  "true strength index.signal.transparency": number;
  /** Default value: `#E91E63` */
  "true strength index.signal.color": string;
  /**
   * - Default value: `25`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `4999`
   */
  "true strength index.long": number;
  /**
   * - Default value: `13`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `4999`
   */
  "true strength index.short": number;
  /**
   * - Default value: `13`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `4999`
   */
  "true strength index.siglen": number;
  /** Default value: `15` */
  "typical price.plot.display": number;
  /** Default value: `0` */
  "typical price.plot.linestyle": number;
  /** Default value: `1` */
  "typical price.plot.linewidth": number;
  /** Default value: `line` */
  "typical price.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "typical price.plot.trackprice": boolean;
  /** Default value: `0` */
  "typical price.plot.transparency": number;
  /** Default value: `#FF6D00` */
  "typical price.plot.color": string;
  /** Default value: `15` */
  "ultimate oscillator.uo.display": number;
  /** Default value: `0` */
  "ultimate oscillator.uo.linestyle": number;
  /** Default value: `1` */
  "ultimate oscillator.uo.linewidth": number;
  /** Default value: `line` */
  "ultimate oscillator.uo.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "ultimate oscillator.uo.trackprice": boolean;
  /** Default value: `0` */
  "ultimate oscillator.uo.transparency": number;
  /** Default value: `#F23645` */
  "ultimate oscillator.uo.color": string;
  /**
   * - Default value: `7`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "ultimate oscillator.length7": number;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "ultimate oscillator.length14": number;
  /**
   * - Default value: `28`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `1000000000000`
   */
  "ultimate oscillator.length28": number;
  /** Default value: `15` */
  "vwap.vwap.display": number;
  /** Default value: `0` */
  "vwap.vwap.linestyle": number;
  /** Default value: `1` */
  "vwap.vwap.linewidth": number;
  /** Default value: `line` */
  "vwap.vwap.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "vwap.vwap.trackprice": number;
  /** Default value: `0` */
  "vwap.vwap.transparency": number;
  /** Default value: `#2196F3` */
  "vwap.vwap.color": string;
  /**
   * - Default value: `hlc3`
   * - Input type: `source`
   * - Options: `["open","high","low","close","hl2","hlc3","ohlc4"]`
   */
  "vwap.source": string;
  /**
   * - Default value: `Session`
   * - Input type: `text`
   * - Options: `["Session","Week","Month","Quarter","Year","Decade","Century"]`
   */
  "vwap.anchor period": string;
  /** Default value: `15` */
  "vwma.plot.display": number;
  /** Default value: `0` */
  "vwma.plot.linestyle": number;
  /** Default value: `1` */
  "vwma.plot.linewidth": number;
  /** Default value: `line` */
  "vwma.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "vwma.plot.trackprice": boolean;
  /** Default value: `0` */
  "vwma.plot.transparency": number;
  /** Default value: `#2196F3` */
  "vwma.plot.color": string;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "vwma.len": number;
  /** Default value: `15` */
  "volatility close-to-close.plot.display": number;
  /** Default value: `0` */
  "volatility close-to-close.plot.linestyle": number;
  /** Default value: `1` */
  "volatility close-to-close.plot.linewidth": number;
  /** Default value: `line` */
  "volatility close-to-close.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volatility close-to-close.plot.trackprice": boolean;
  /** Default value: `0` */
  "volatility close-to-close.plot.transparency": number;
  /** Default value: `#2196F3` */
  "volatility close-to-close.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `2`
   */
  "volatility close-to-close.periods": number;
  /**
   * - Default value: `252`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `366`
   */
  "volatility close-to-close.days per year": number;
  /** Default value: `15` */
  "volatility index.plot.display": number;
  /** Default value: `0` */
  "volatility index.plot.linestyle": number;
  /** Default value: `1` */
  "volatility index.plot.linewidth": number;
  /** Default value: `line` */
  "volatility index.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volatility index.plot.trackprice": boolean;
  /** Default value: `0` */
  "volatility index.plot.transparency": number;
  /** Default value: `#FF5252` */
  "volatility index.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   */
  "volatility index.periods": number;
  /**
   * - Default value: `3`
   * - Input type: `float`
   */
  "volatility index.atr mult": number;
  /**
   * - Default value: `Wilder Smoothing`
   * - Input type: `text`
   * - Options: `["Exponential","Wilder Smoothing"]`
   */
  "volatility index.method": string;
  /** Default value: `15` */
  "volatility o-h-l-c.plot.display": number;
  /** Default value: `0` */
  "volatility o-h-l-c.plot.linestyle": number;
  /** Default value: `1` */
  "volatility o-h-l-c.plot.linewidth": number;
  /** Default value: `line` */
  "volatility o-h-l-c.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volatility o-h-l-c.plot.trackprice": boolean;
  /** Default value: `0` */
  "volatility o-h-l-c.plot.transparency": number;
  /** Default value: `#FF5252` */
  "volatility o-h-l-c.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   */
  "volatility o-h-l-c.periods": number;
  /**
   * - Default value: `0`
   * - Input type: `float`
   * - Min: `0`
   * - Max: `0.999`
   */
  "volatility o-h-l-c.market closed percentage": number;
  /**
   * - Default value: `252`
   * - Input type: `integer`
   */
  "volatility o-h-l-c.days per year": number;
  /** Default value: `15` */
  "volatility zero trend close-to-close.plot.display": number;
  /** Default value: `0` */
  "volatility zero trend close-to-close.plot.linestyle": number;
  /** Default value: `1` */
  "volatility zero trend close-to-close.plot.linewidth": number;
  /** Default value: `line` */
  "volatility zero trend close-to-close.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volatility zero trend close-to-close.plot.trackprice": boolean;
  /** Default value: `0` */
  "volatility zero trend close-to-close.plot.transparency": number;
  /** Default value: `#2196F3` */
  "volatility zero trend close-to-close.plot.color": string;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `0`
   * - Max: `10000`
   */
  "volatility zero trend close-to-close.periods": number;
  /**
   * - Default value: `252`
   * - Input type: `integer`
   */
  "volatility zero trend close-to-close.days per year": number;
  /** Default value: `15` */
  "volume.volume.display": number;
  /** Default value: `0` */
  "volume.volume.linestyle": number;
  /** Default value: `1` */
  "volume.volume.linewidth": number;
  /** Default value: `columns` */
  "volume.volume.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume.volume.trackprice": boolean;
  /** Default value: `50` */
  "volume.volume.transparency": number;
  /** Default value: `#000080` */
  "volume.volume.color": string;
  /** Default value: `0` */
  "volume.volume ma.display": number;
  /** Default value: `0` */
  "volume.volume ma.linestyle": number;
  /** Default value: `1` */
  "volume.volume ma.linewidth": number;
  /** Default value: `line` */
  "volume.volume ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume.volume ma.trackprice": boolean;
  /** Default value: `0` */
  "volume.volume ma.transparency": number;
  /** Default value: `#2196F3` */
  "volume.volume ma.color": string;
  /** Default value: `0` */
  "volume.smoothed ma.display": number;
  /** Default value: `0` */
  "volume.smoothed ma.linestyle": number;
  /** Default value: `1` */
  "volume.smoothed ma.linewidth": number;
  /** Default value: `line` */
  "volume.smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume.smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "volume.smoothed ma.transparency": number;
  /** Default value: `#2196F3` */
  "volume.smoothed ma.color": string;
  /**
   * - Default value: `false`
   * - Input type: `bool`
   * - IsHidden: `true`
   */
  "volume.show ma": boolean;
  /**
   * - Default value: `20`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "volume.ma length": number;
  /**
   * - Default value: `false`
   * - Input type: `bool`
   */
  "volume.color based on previous close": boolean;
  /**
   * - Default value: ``
   * - Input type: `symbol`
   * - Optional: `true`
   * - IsHidden: `false`
   */
  "volume.other symbol": string;
  /**
   * - Default value: `SMA`
   * - Input type: `text`
   * - Options: `["SMA","EMA","WMA"]`
   */
  "volume.smoothing line": string;
  /**
   * - Default value: `9`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `10000`
   */
  "volume.smoothing length": number;
  /** Default value: `#787B86` */
  "volume oscillator.zero.color": string;
  /** Default value: `2` */
  "volume oscillator.zero.linestyle": number;
  /** Default value: `1` */
  "volume oscillator.zero.linewidth": number;
  /** Default value: `true` */
  "volume oscillator.zero.visible": boolean;
  /** Default value: `0` */
  "volume oscillator.zero.value": number;
  /** Default value: `15` */
  "volume oscillator.plot.display": number;
  /** Default value: `0` */
  "volume oscillator.plot.linestyle": number;
  /** Default value: `1` */
  "volume oscillator.plot.linewidth": number;
  /** Default value: `line` */
  "volume oscillator.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume oscillator.plot.trackprice": boolean;
  /** Default value: `0` */
  "volume oscillator.plot.transparency": number;
  /** Default value: `#2196F3` */
  "volume oscillator.plot.color": string;
  /**
   * - Default value: `5`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `4999`
   */
  "volume oscillator.shortlen": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `4999`
   */
  "volume oscillator.longlen": number;
  /** Default value: `#ff0000` */
  "volume profile fixed range.developing poc.color": string;
  /** Default value: `0` */
  "volume profile fixed range.developing poc.linestyle": number;
  /** Default value: `1` */
  "volume profile fixed range.developing poc.linewidth": number;
  /** Default value: `step_line` */
  "volume profile fixed range.developing poc.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume profile fixed range.developing poc.trackprice": boolean;
  /** Default value: `0` */
  "volume profile fixed range.developing poc.transparency": number;
  /** Default value: `0` */
  "volume profile fixed range.developing poc.display": number;
  /** Default value: `#0000ff` */
  "volume profile fixed range.developing va high.color": string;
  /** Default value: `0` */
  "volume profile fixed range.developing va high.linestyle": number;
  /** Default value: `1` */
  "volume profile fixed range.developing va high.linewidth": number;
  /** Default value: `step_line` */
  "volume profile fixed range.developing va high.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume profile fixed range.developing va high.trackprice": boolean;
  /** Default value: `0` */
  "volume profile fixed range.developing va high.transparency": number;
  /** Default value: `0` */
  "volume profile fixed range.developing va high.display": number;
  /** Default value: `#0000ff` */
  "volume profile fixed range.developing va low.color": string;
  /** Default value: `0` */
  "volume profile fixed range.developing va low.linestyle": number;
  /** Default value: `1` */
  "volume profile fixed range.developing va low.linewidth": number;
  /** Default value: `step_line` */
  "volume profile fixed range.developing va low.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume profile fixed range.developing va low.trackprice": boolean;
  /** Default value: `0` */
  "volume profile fixed range.developing va low.transparency": number;
  /** Default value: `0` */
  "volume profile fixed range.developing va low.display": number;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "volume profile fixed range.first bar time": number;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "volume profile fixed range.last bar time": number;
  /**
   * - Default value: `24`
   * - Input type: `integer`
   * - Max: `1000000`
   * - Min: `1`
   */
  "volume profile fixed range.row size": number;
  /**
   * - Default value: `Number Of Rows`
   * - Input type: `text`
   * - Options: `["Number Of Rows","Ticks Per Row"]`
   */
  "volume profile fixed range.rows layout": string;
  /**
   * - Default value: `true`
   * - Input type: `bool`
   * - IsHidden: `true`
   */
  "volume profile fixed range.subscriberealtime": boolean;
  /**
   * - Default value: `70`
   * - Input type: `integer`
   * - Max: `100`
   * - Min: `0`
   */
  "volume profile fixed range.value area volume": number;
  /**
   * - Default value: `Up/Down`
   * - Input type: `text`
   * - Options: `["Up/Down","Total","Delta"]`
   */
  "volume profile fixed range.volume": string;
  /** Default value: `#ff0000` */
  "volume profile visible range.developing poc.color": string;
  /** Default value: `0` */
  "volume profile visible range.developing poc.linestyle": number;
  /** Default value: `1` */
  "volume profile visible range.developing poc.linewidth": number;
  /** Default value: `step_line` */
  "volume profile visible range.developing poc.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume profile visible range.developing poc.trackprice": boolean;
  /** Default value: `0` */
  "volume profile visible range.developing poc.transparency": number;
  /** Default value: `0` */
  "volume profile visible range.developing poc.display": number;
  /** Default value: `#0000ff` */
  "volume profile visible range.developing va high.color": string;
  /** Default value: `0` */
  "volume profile visible range.developing va high.linestyle": number;
  /** Default value: `1` */
  "volume profile visible range.developing va high.linewidth": number;
  /** Default value: `step_line` */
  "volume profile visible range.developing va high.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume profile visible range.developing va high.trackprice": boolean;
  /** Default value: `0` */
  "volume profile visible range.developing va high.transparency": number;
  /** Default value: `0` */
  "volume profile visible range.developing va high.display": number;
  /** Default value: `#0000ff` */
  "volume profile visible range.developing va low.color": string;
  /** Default value: `0` */
  "volume profile visible range.developing va low.linestyle": number;
  /** Default value: `1` */
  "volume profile visible range.developing va low.linewidth": number;
  /** Default value: `step_line` */
  "volume profile visible range.developing va low.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume profile visible range.developing va low.trackprice": boolean;
  /** Default value: `0` */
  "volume profile visible range.developing va low.transparency": number;
  /** Default value: `0` */
  "volume profile visible range.developing va low.display": number;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "volume profile visible range.first visible bar time": number;
  /**
   * - Default value: `0`
   * - Input type: `time`
   * - IsHidden: `true`
   * - Max: `253370764800`
   * - Min: `-253370764800`
   */
  "volume profile visible range.last visible bar time": number;
  /**
   * - Default value: `24`
   * - Input type: `integer`
   * - Max: `1000000`
   * - Min: `1`
   */
  "volume profile visible range.row size": number;
  /**
   * - Default value: `Number Of Rows`
   * - Input type: `text`
   * - Options: `["Number Of Rows","Ticks Per Row"]`
   */
  "volume profile visible range.rows layout": string;
  /**
   * - Default value: `70`
   * - Input type: `integer`
   * - Max: `100`
   * - Min: `0`
   */
  "volume profile visible range.value area volume": number;
  /**
   * - Default value: `Up/Down`
   * - Input type: `text`
   * - Options: `["Up/Down","Total","Delta"]`
   */
  "volume profile visible range.volume": string;
  /** Default value: `15` */
  "vortex indicator.vi +.display": number;
  /** Default value: `0` */
  "vortex indicator.vi +.linestyle": number;
  /** Default value: `1` */
  "vortex indicator.vi +.linewidth": number;
  /** Default value: `line` */
  "vortex indicator.vi +.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "vortex indicator.vi +.trackprice": boolean;
  /** Default value: `0` */
  "vortex indicator.vi +.transparency": number;
  /** Default value: `#2196F3` */
  "vortex indicator.vi +.color": string;
  /** Default value: `15` */
  "vortex indicator.vi -.display": number;
  /** Default value: `0` */
  "vortex indicator.vi -.linestyle": number;
  /** Default value: `1` */
  "vortex indicator.vi -.linewidth": number;
  /** Default value: `line` */
  "vortex indicator.vi -.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "vortex indicator.vi -.trackprice": boolean;
  /** Default value: `0` */
  "vortex indicator.vi -.transparency": number;
  /** Default value: `#E91E63` */
  "vortex indicator.vi -.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `2`
   * - Max: `1000000000000`
   */
  "vortex indicator.period": number;
  /** Default value: `#7E57C2` */
  "williams %r.hlines background.color": string;
  /** Default value: `90` */
  "williams %r.hlines background.transparency": number;
  /** Default value: `true` */
  "williams %r.hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "williams %r.upperlimit.color": string;
  /** Default value: `2` */
  "williams %r.upperlimit.linestyle": number;
  /** Default value: `1` */
  "williams %r.upperlimit.linewidth": number;
  /** Default value: `true` */
  "williams %r.upperlimit.visible": boolean;
  /** Default value: `-20` */
  "williams %r.upperlimit.value": number;
  /** Default value: `#787B86` */
  "williams %r.lowerlimit.color": string;
  /** Default value: `2` */
  "williams %r.lowerlimit.linestyle": number;
  /** Default value: `1` */
  "williams %r.lowerlimit.linewidth": number;
  /** Default value: `true` */
  "williams %r.lowerlimit.visible": boolean;
  /** Default value: `-80` */
  "williams %r.lowerlimit.value": number;
  /** Default value: `15` */
  "williams %r.plot.display": number;
  /** Default value: `0` */
  "williams %r.plot.linestyle": number;
  /** Default value: `1` */
  "williams %r.plot.linewidth": number;
  /** Default value: `line` */
  "williams %r.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "williams %r.plot.trackprice": boolean;
  /** Default value: `0` */
  "williams %r.plot.transparency": number;
  /** Default value: `#7E57C2` */
  "williams %r.plot.color": string;
  /**
   * - Default value: `14`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "williams %r.length": number;
  /** Default value: `15` */
  "williams alligator.jaw.display": number;
  /** Default value: `0` */
  "williams alligator.jaw.linestyle": number;
  /** Default value: `1` */
  "williams alligator.jaw.linewidth": number;
  /** Default value: `line` */
  "williams alligator.jaw.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "williams alligator.jaw.trackprice": boolean;
  /** Default value: `0` */
  "williams alligator.jaw.transparency": number;
  /** Default value: `#2196F3` */
  "williams alligator.jaw.color": string;
  /** Default value: `15` */
  "williams alligator.teeth.display": number;
  /** Default value: `0` */
  "williams alligator.teeth.linestyle": number;
  /** Default value: `1` */
  "williams alligator.teeth.linewidth": number;
  /** Default value: `line` */
  "williams alligator.teeth.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "williams alligator.teeth.trackprice": boolean;
  /** Default value: `0` */
  "williams alligator.teeth.transparency": number;
  /** Default value: `#E91E63` */
  "williams alligator.teeth.color": string;
  /** Default value: `15` */
  "williams alligator.lips.display": number;
  /** Default value: `0` */
  "williams alligator.lips.linestyle": number;
  /** Default value: `1` */
  "williams alligator.lips.linewidth": number;
  /** Default value: `line` */
  "williams alligator.lips.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "williams alligator.lips.trackprice": boolean;
  /** Default value: `0` */
  "williams alligator.lips.transparency": number;
  /** Default value: `#66BB6A` */
  "williams alligator.lips.color": string;
  /**
   * - Default value: `21`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "williams alligator.jaw length": number;
  /**
   * - Default value: `13`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "williams alligator.teeth length": number;
  /**
   * - Default value: `8`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "williams alligator.lips length": number;
  /**
   * - Default value: `8`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "williams alligator.jaw offset": number;
  /**
   * - Default value: `5`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "williams alligator.teeth offset": number;
  /**
   * - Default value: `3`
   * - Input type: `integer`
   * - Min: `1`
   * - Max: `2000`
   */
  "williams alligator.lips offset": number;
  /** Default value: `15` */
  "williams fractal.down fractals.display": number;
  /** Default value: `shape_triangle_down` */
  "williams fractal.down fractals.plottype": string;
  /** Default value: `BelowBar` */
  "williams fractal.down fractals.location": string;
  /** Default value: `0` */
  "williams fractal.down fractals.transparency": number;
  /** Default value: `#F23645` */
  "williams fractal.down fractals.color": string;
  /** Default value: `15` */
  "williams fractal.up fractals.display": number;
  /** Default value: `shape_triangle_up` */
  "williams fractal.up fractals.plottype": string;
  /** Default value: `AboveBar` */
  "williams fractal.up fractals.location": string;
  /** Default value: `0` */
  "williams fractal.up fractals.transparency": number;
  /** Default value: `#089981` */
  "williams fractal.up fractals.color": string;
  /**
   * - Default value: `2`
   * - Input type: `integer`
   * - Min: `2`
   * - Max: `1000000000000`
   */
  "williams fractal.periods": number;
  /** Default value: `15` */
  "zig zag.plot.display": number;
  /** Default value: `0` */
  "zig zag.plot.linestyle": number;
  /** Default value: `2` */
  "zig zag.plot.linewidth": number;
  /** Default value: `line` */
  "zig zag.plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "zig zag.plot.trackprice": boolean;
  /** Default value: `0` */
  "zig zag.plot.transparency": number;
  /** Default value: `#2196F3` */
  "zig zag.plot.color": string;
  /**
   * - Default value: `5`
   * - Input type: `float`
   * - Min: `0.001`
   * - Max: `100`
   */
  "zig zag.deviation": number;
  /**
   * - Default value: `10`
   * - Input type: `integer`
   * - Min: `2`
   * - Max: `1000`
   */
  "zig zag.depth": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Study palette color.
 */
export interface StudyPaletteColor {
  /**
   * Palette color.
   */
  color: string;
  /**
   * Palette style.
   */
  style: number;
  /**
   * Palette width.
   */
  width: number;
}
/**
 * Study palette style preferences.
 */
export interface StudyPaletteColorPreferences
  extends StudyPaletteColor,
    StudyPaletteInfo {}
/**
 * A description of a study palette.
 */
export interface StudyPaletteInfo {
  /**
   * Palette name.
   */
  readonly name: string;
}
/**
 * Study palette style preferences.
 */
export interface StudyPalettePreferences {
  /**
   * Palette colors.
   */
  colors: Record<string, StudyPaletteColorPreferences>;
}
/**
 * Study palette style.
 */
export interface StudyPaletteStyle {
  /**
   * Palette colors.
   */
  colors: MappedObject<StudyPaletteColor> | StudyPaletteColor[];
}
/**
 * A description of a study plot with a palette.
 */
export interface StudyPalettedPlotInfo extends StudyPlotBaseInfo {
  /**
   * A color palette ID.
   */
  readonly palette: string;
}
/**
 * A description of a study color palettes.
 */
export interface StudyPalettesInfo {
  /**
   * Palette colors.
   */
  readonly colors: MappedObject<StudyPaletteInfo> | StudyPaletteInfo[];
  /**
   * Mapping from values returned by the study to palette color index.
   */
  readonly valToIndex?: MappedObject<number>;
  /**
   * Use default color for {@link StudyPlotType.Colorer} plots when the value is `NaN`.
   */
  readonly addDefaultColor?: boolean;
}
/**
 * Base type for all study plot descriptions.
 */
export interface StudyPlotBaseInfo {
  /**
   * Plot ID.
   */
  readonly id: string;
  /**
   * Plot type.
   */
  readonly type: string;
}
/**
 * Base type for all study plot style preferences.
 */
export interface StudyPlotBasePreferences {
  /**
   * Transparency. A number between 1 and 100.
   *
   * @example 80
   */
  transparency: number;
  /**
   * Display mode. See {@link StudyPlotDisplayMode}.
   *
   * @example StudyPlotDisplayTarget.None // Do not display the plot.
   */
  display: StudyPlotDisplayMode;
  /** Visibility */
  visible?: boolean;
}
export interface StudyPlotValueInheritFormat {
  /** Plot value type */
  type: "inherit";
}
export interface StudyPlotValuePrecisionFormat {
  /** Plot value type */
  type: "price" | "volume" | "percent";
  /** Plot Value Precision */
  precision?: number;
}
export interface StudyPriceInputInfo extends StudyInputBaseInfo {
  /** Input type is Price */
  readonly type: StudyInputType.Price;
  /** Default value */
  readonly defval: number;
  /** Maximum value */
  readonly max?: number;
  /** Minimum value */
  readonly min?: number;
  /** Step size for value */
  readonly step?: number;
}
export interface StudyResolutionInputInfo extends StudyInputBaseInfo {
  /** Input type is Resolution */
  readonly type: StudyInputType.Resolution;
  /** Default value */
  readonly defval: ResolutionString;
  /** Source Input Options */
  readonly options?: string[];
  /** Options for Input Titles */
  readonly optionsTitles?: StudyInputOptionsTitles;
  /** Is Monday to Friday Resolution */
  readonly isMTFResolution?: boolean;
}
export interface StudyResultValueWithOffset {
  /**
   * Value which will be offset
   */
  value: number;
  /**
   * Allows you to override the offset of every plot (note that offset of a certain plot should always be the same)
   */
  offset: number;
}
/**
 * A description of a RGBA colorer plot.
 */
export interface StudyRgbaColorerPlotInfo extends StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.Colorer;
}
export interface StudySessionInputInfo extends StudyInputBaseInfo {
  /** Input type is Session */
  readonly type: StudyInputType.Session;
  /** Default value */
  readonly defval: string;
  /** Source Input Options */
  readonly options?: string[];
  /** Options for Input Titles */
  readonly optionsTitles?: StudyInputOptionsTitles;
}
/**
 * A description of a study shapes plot.
 */
export interface StudyShapesPlotInfo extends StudyPlotBaseInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.Shapes;
}
/**
 * Study shape plot style preferences.
 */
export interface StudyShapesPlotPreferences extends StudyPlotBasePreferences {
  /**
   * Plot type.
   */
  plottype: PlotShapeId;
  /**
   * Location relative to the bar.
   */
  location: MarkLocation;
  /**
   * Color.
   */
  color: string;
  /**
   * Text color.
   */
  textColor: string;
}
export interface StudySourceInputInfo extends StudyInputBaseInfo {
  /** Input type is Source */
  readonly type: StudyInputType.Source;
  /** Default value */
  readonly defval: StudyAvailableConstSources | string;
  /** Source Input Options */
  readonly options?: (StudyAvailableConstSources | string)[];
  /** Options for Input Titles */
  readonly optionsTitles?: StudyInputOptionsTitles;
}
/**
 * Study style description.
 */
export interface StudyStyleInfo {
  /**
   * Default study description values.
   */
  defaults?: StudyStyleInfoDefaults;
  /**
   * Study plot descriptions.
   */
  plots?: readonly Readonly<StudyPlotInfo>[];
  /**
   * Study plot style descriptions. An object with `plot id` as keys and style info as values
   */
  styles?: Record<string, Readonly<StudyStylesInfo> | undefined>;
  /**
   * Study band descriptions.
   */
  bands?: readonly Readonly<StudyBandInfo>[];
  /**
   * Study filled area descriptions. Filled area is a special object, which allows coloring an area between two plots.
   */
  filledAreas?: readonly Readonly<StudyFilledAreaInfo>[];
  /**
   * Study color palettes descriptions.
   */
  palettes?: Record<string, Readonly<StudyPalettesInfo> | undefined>;
}
/**
 * Default study style preferences.
 */
export interface StudyStyleInfoDefaults {
  /**
   * Default study bands style preferences.
   */
  bands?: readonly StudyBandStyle[];
  /**
   * Default study filled areas style preferences.
   */
  filledAreasStyle?: Record<string, StudyFilledAreaStyle | undefined>;
  /**
   * Default study paletes style preferences.
   */
  palettes?: Record<string, StudyPaletteStyle | undefined>;
  /**
   * Default study styles.
   */
  styles?: Record<string, StudyPlotPreferences | undefined>;
  /**
   * Default study OHLC plot style preferences.
   */
  ohlcPlots?: Record<string, StudyOhlcPlotPreferences | undefined>;
  /**
   * Default study graphics style preferences.
   */
  graphics?: {
    /** Horizontal line style preferences */
    horizlines?: Record<string, HorizLinePreferences | undefined>;
    /** Polygon style preferences */
    polygons?: Record<string, PolygonPreferences | undefined>;
    /** Histogram style preferences */
    hhists?: Record<string, HHistPreferences | undefined>;
    /** Vertical line style preferences */
    vertlines?: Record<string, VertLinePreferences | undefined>;
  };
}
/**
 * Study style values.
 */
export interface StudyStyleValues {
  /**
   * OHLC plot styles.
   */
  ohlcPlots: Record<string, StudyOhlcPlotPreferences | undefined>;
  /**
   * Band styles.
   */
  bands: StudyBandPreferences[];
  /**
   * Palette styles.
   */
  palettes: Record<string, StudyPalettePreferences | undefined>;
  /**
   * Plot styles.
   */
  styles: Record<string, StudyPlotPreferences | undefined>;
  /**
   * Filled area descriptions.
   */
  filledAreas: StudyFilledAreaInfo[];
  /**
   * Filled area styles.
   */
  filledAreasStyle: Record<string, StudyFilledAreaStyle | undefined>;
  /**
   * Graphics styles.
   */
  graphics: {
    /** Horizontal line style preferences */
    horizlines?: Record<string, HorizLinePreferences | undefined>;
    /** Polygon style preferences */
    polygons?: Record<string, PolygonPreferences | undefined>;
    /** Histogram style preferences */
    hhists?: Record<string, HHistPreferences | undefined>;
    /** Vertical line style preferences */
    vertlines?: Record<string, VertLinePreferences | undefined>;
  };
}
/**
 * Study styles description.
 */
export interface StudyStylesInfo {
  /**
   * Histogram base. A price value which will be considered as a start base point when rendering plot with histogram, columns or area style.
   */
  readonly histogramBase?: number;
  /**
   * If `true` then plot points will be joined with line, applicable only to `Circles` and `Cross` type plots. Default is false.
   */
  readonly joinPoints?: boolean;
  /**
   * Title used in the study dialog styles tab.
   */
  readonly title: string;
  /**
   * If `true` then the styles tab will be hidden in the study dialog.
   */
  readonly isHidden?: boolean;
  /**
   * Minimum possible plot arrow size. Applicable only to arrow plot types.
   */
  readonly minHeight?: number;
  /**
   * Maximum possible plot arrow size. Applicable only to arrow plot types.
   */
  readonly maxHeight?: number;
  /**
   * Size of characters on the chart. Possible values are: `auto`, `tiny`, `small`, `normal`, `large`,`huge`. Applicable to `chars` and `shapes` plot types.
   */
  readonly size?: PlotSymbolSize;
  /**
   * Char to display with the plot. Applicable only to chars plot types.
   */
  readonly char?: string;
  /**
   * Text to display with the plot. Applicable to `chars` and `shapes` plot types.
   */
  readonly text?: string;
  /**
   * If defined, defines the number of bars to plot on chart.
   */
  readonly showLast?: number;
  /**
   * Used to control the zorder of the plot. Control if a plot is visually behind or in front of another.
   */
  readonly zorder?: number;
  /**
   * Info about the Price Scale formatting
   */
  readonly format?: Partial<StudyPlotValuePrecisionFormat>;
}
export interface StudySymbolInputInfo extends StudyInputBaseInfo {
  /** Input type is Symbol */
  readonly type: StudyInputType.Symbol;
  /** Default value for the input */
  readonly defval?: string;
  /** Is the input optional */
  readonly optional?: boolean;
}
/**
 * A description of a study plot with a target.
 */
export interface StudyTargetedPlotInfo extends StudyPlotBaseInfo {
  /**
   * ID of another target plot.
   */
  readonly target: string;
  /**
   * Target field.
   */
  readonly targetField?:
    | "topColor"
    | "bottomColor"
    | "topValue"
    | "bottomValue";
}
/**
 * Study template data.
 */
export interface StudyTemplateData {
  /**
   * Template name.
   */
  name: string;
  /**
   * Template content.
   */
  content: string;
}
/**
 * Study template metainfo.
 */
export interface StudyTemplateMetaInfo {
  /**
   * Template name.
   */
  name: string;
}
/**
 * A description of a text colorer plot.
 */
export interface StudyTextColorerPlotInfo
  extends StudyPalettedPlotInfo,
    StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.TextColorer;
}
export interface StudyTextInputInfo extends StudyInputBaseInfo {
  /** Input type is Text */
  readonly type: StudyInputType.Text;
  /** Default value for the input */
  readonly defval: string;
  /** Options for the text input */
  readonly options?: string[];
  /** Options for the titles of the text input */
  readonly optionsTitles?: StudyInputOptionsTitles;
}
export interface StudyTextareaInputInfo extends StudyInputBaseInfo {
  /** Input type is TextArea */
  readonly type: StudyInputType.Textarea;
  /** Default value for the input */
  readonly defval: string;
}
export interface StudyTimeInputInfo extends StudyInputBaseInfo {
  /** Input type is Time */
  readonly type: StudyInputType.Time;
  /** Default value for the input */
  readonly defval: number;
  /** Maximum time */
  readonly max: number;
  /** Minimum time */
  readonly min: number;
}
/**
 * A description of a up colorer plot.
 */
export interface StudyUpColorerPlotInfo
  extends StudyPalettedPlotInfo,
    StudyTargetedPlotInfo {
  /** @inheritDoc */
  readonly type: StudyPlotType.UpColorer;
}
/**
 * Text with styles
 */
export interface StyledText {
  /**
   * Text
   */
  text: string;
  /**
   * Font
   */
  font?: string;
  /**
   * Font family
   */
  fontFamily?: string;
  /**
   * Font feature settings
   */
  fontFeatureSettings?: string;
  /**
   * Font kerning
   */
  fontKerning?: string;
  /**
   * Font optical sizing
   */
  fontOpticalSizing?: string;
  /**
   * Font palette
   */
  fontPalette?: string;
  /**
   * Font size
   */
  fontSize?: string;
  /**
   * Font size adjust
   */
  fontSizeAdjust?: string;
  /**
   * Font stretch
   */
  fontStretch?: string;
  /**
   * Font style
   */
  fontStyle?: string;
  /**
   * Font synthesis
   */
  fontSynthesis?: string;
  /**
   * Font variant
   */
  fontVariant?: string;
  /**
   * Font variant alternates
   */
  fontVariantAlternates?: string;
  /**
   * Font variant caps
   */
  fontVariantCaps?: string;
  /**
   * Font variant east asian
   */
  fontVariantEastAsian?: string;
  /**
   * Font variant ligatures
   */
  fontVariantLigatures?: string;
  /**
   * Font variant numerics
   */
  fontVariantNumeric?: string;
  /**
   * Font variant position
   */
  fontVariantPosition?: string;
  /**
   * Font variation settings
   */
  fontVariationSettings?: string;
  /**
   * Font weight
   */
  fontWeight?: string;
  /**
   * Color
   */
  color?: string;
  /**
   * Line height
   */
  lineHeight?: string;
  /**
   * Letter spacing
   */
  letterSpacing?: string;
}
export interface SubscribeEventsMap {
  /**
   * Drawing toolbar is shown/hidden
   * @param  {boolean} isHidden - is the drawing toolbar currently hidden
   */
  toggle_sidebar: (isHidden: boolean) => void;
  /**
   * Indicators dialog is shown
   */
  indicators_dialog: EmptyCallback;
  /**
   * Chart header is shown/hidden
   * @param  {boolean} isHidden - is the chart header currently hidden
   */
  toggle_header: (isHidden: boolean) => void;
  /**
   * Chart / Study Properties dialog is shown
   * @param  {EditObjectDialogEventParams} params - meta information about the dialog type and the title of the chart or study
   */
  edit_object_dialog: (params: EditObjectDialogEventParams) => void;
  /**
   * New chart is about to be loaded
   * @param  {object} savedData - chart data about to be loaded
   */
  chart_load_requested: (savedData: object) => void;
  /**
   * Chart has finished loading
   */
  chart_loaded: EmptyCallback;
  /**
   * Mouse button has been pressed
   * @param  {MouseEventParams} params
   */
  mouse_down: (params: MouseEventParams) => void;
  /**
   * Mouse button has been released
   * @param  {MouseEventParams} params
   */
  mouse_up: (params: MouseEventParams) => void;
  /**
   * A drawing has been added to a chart.
   * @param  {StudyOrDrawingAddedToChartEventParams} params - The arguments contain an object with the `value` field that corresponds with the name of the drawing.
   */
  drawing: (params: StudyOrDrawingAddedToChartEventParams) => void;
  /**
   * An indicator has been added to a chart.
   * @param  {StudyOrDrawingAddedToChartEventParams} params - The arguments contain an object with the `value` field that corresponds with the name of the indicator.
   */
  study: (params: StudyOrDrawingAddedToChartEventParams) => void;
  /** Undo action occurred */
  undo: EmptyCallback;
  /** Redo action occurred */
  redo: EmptyCallback;
  /**
   * The Undo / Redo state has been changed.
   * @param  {UndoRedoState} state - state of the Undo/Redo stack
   */
  undo_redo_state_changed: (state: UndoRedoState) => void;
  /**
   * Reset scales button has been clicked
   */
  reset_scales: EmptyCallback;
  /**
   * A compare dialog has been shown
   */
  compare_add: EmptyCallback;
  /**
   * A compare instrument has been added
   */
  add_compare: EmptyCallback;
  /**
   * A study template has been loaded
   */
  load_study_template: EmptyCallback;
  /**
   * Last bar has been updated
   * @param  {Bar} tick - data for last bar
   */
  onTick: (tick: Bar) => void;
  /**
   * User has changed the chart. `Chart change` means any user action that can be undone.
   * The callback function will not be called more than once every 5 seconds. See also `auto_save_delay` within the Widget constructor options ({@link ChartingLibraryWidgetOptions.auto_save_delay}).
   */
  onAutoSaveNeeded: EmptyCallback;
  /**
   * A screenshot URL has been returned by the server
   * @param  {string} url - url of the screenshot
   */
  onScreenshotReady: (url: string) => void;
  /**
   * User has clicked on a 'mark on a bar'.
   * @param  {Mark['id']} markId - ID of the clicked mark
   */
  onMarkClick: (markId: Mark["id"]) => void;
  /**
   * User clicked the "plus" button on the price scale.
   * @param  {PlusClickParams} params - coordinates, price and symbol information
   */
  onPlusClick: (params: PlusClickParams) => void;
  /**
   * User clicked a 'timescale mark'.
   * @param  {TimescaleMark['id']} markId - ID of the clicked timescale mark
   */
  onTimescaleMarkClick: (markId: TimescaleMark["id"]) => void;
  /** Selected drawing tool has changed */
  onSelectedLineToolChanged: EmptyCallback;
  /**
   * Amount or placement of the charts is about to be changed.
   * **Note:** this event is only applicable to Trading Platform.
   * @param  {LayoutType} newLayoutType - whether the layout is single or multi-chart
   */
  layout_about_to_be_changed: (newLayoutType: LayoutType) => void;
  /**
   * Amount or placement of the charts is changed.
   * **Note:** this event is only applicable to Trading Platform.
   */
  layout_changed: EmptyCallback;
  /**
   * Active chart has changed
   * **Note:** this event is only applicable to Trading Platform.
   * @param  {number} chartIndex - index of the active chart
   */
  activeChartChanged: (chartIndex: number) => void;
  /**
   * An event related to the series has occurred.
   * @param  {SeriesEventType} seriesEventType - series event type
   */
  series_event: (seriesEventType: SeriesEventType) => void;
  /**
   * An event related to the study has occurred.
   * @param  {EntityId} entityId - study ID
   * @param  {StudyEventType} studyEventType - study event type
   */
  study_event: (entityId: EntityId, studyEventType: StudyEventType) => void;
  /**
   * Drawing was hidden, shown, moved, removed, clicked, or created
   * @param  {EntityId} sourceId - drawing ID
   * @param  {DrawingEventType} drawingEventType - drawing event type
   */
  drawing_event: (
    sourceId: EntityId,
    drawingEventType: DrawingEventType
  ) => void;
  /**
   * Study properties have changed.
   * @param  {EntityId} id - entity ID
   */
  study_properties_changed: (id: EntityId) => void;
  /**
   * Main series properties have changed.
   * @param  {EntityId} id - entity ID
   */
  series_properties_changed: (id: EntityId) => void;
  /**
   * Panes' size has changed.
   */
  panes_height_changed: () => void;
  /**
   * Panes' order has changed.
   */
  panes_order_changed: () => void;
}
export interface SuccessFormatterParseResult<T> extends FormatterParseResult {
  /** @inheritDoc */
  res: true;
  /** Returned value once parsing is done */
  value: T;
  /** Optional value returned by the default formatter */
  suggest?: string;
}
/**
 * Overrides for the 'SuperTrend' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface SuperTrendIndicatorOverrides {
  /** Default value: `15` */
  "supertrend.display": number;
  /** Default value: `0` */
  "supertrend.linestyle": number;
  /** Default value: `3` */
  "supertrend.linewidth": number;
  /** Default value: `line` */
  "supertrend.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "supertrend.trackprice": boolean;
  /** Default value: `35` */
  "supertrend.transparency": number;
  /** Default value: `#000080` */
  "supertrend.color": string;
  /** Default value: `15` */
  "up arrow.display": number;
  /** Default value: `0` */
  "up arrow.linestyle": number;
  /** Default value: `3` */
  "up arrow.linewidth": number;
  /** Default value: `shape_arrow_up` */
  "up arrow.plottype": string;
  /** Default value: `false` */
  "up arrow.trackprice": boolean;
  /** Default value: `BelowBar` */
  "up arrow.location": string;
  /** Default value: `35` */
  "up arrow.transparency": number;
  /** Default value: `#00FF00` */
  "up arrow.color": string;
  /** Default value: `15` */
  "down arrow.display": number;
  /** Default value: `0` */
  "down arrow.linestyle": number;
  /** Default value: `3` */
  "down arrow.linewidth": number;
  /** Default value: `shape_arrow_down` */
  "down arrow.plottype": string;
  /** Default value: `false` */
  "down arrow.trackprice": boolean;
  /** Default value: `AboveBar` */
  "down arrow.location": string;
  /** Default value: `35` */
  "down arrow.transparency": number;
  /** Default value: `#FF0000` */
  "down arrow.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Extended symbol information.
 */
export interface SymbolExt {
  /**
   * Symbol name. E.g. `'AAPL'`.
   */
  symbol: string;
  /**
   * Full symbol name. E.g. `'NasdaqNM:AAPL'`.
   */
  full_name: string;
  /**
   * Exchange name. E.g. `'NasdaqNM`'
   */
  exchange: string;
  /**
   * Symbol description. E.g. `'Apple Inc.'`.
   */
  description: string;
  /**
   * Symbol type. E.g. `'stock'`.
   */
  type: string;
}
export interface SymbolInfoPriceSource {
  /** Unique ID */
  id: string;
  /** Short name */
  name: string;
}
export interface SymbolInputSymbolSource {
  /** Input type is Symbol Source */
  type: "symbolInputSymbolSource";
  /** Input ID */
  inputId: string;
}
/**
 * The time interval for a specific symbol.
 */
export interface SymbolIntervalResult {
  /** Symbol name */
  symbol: string;
  /** Time interval */
  interval: ResolutionString;
}
/** Additional information about the Symbol's currency or unit */
export interface SymbolResolveExtension {
  /**
   * Indicates the currency for conversions if `currency_codes` configuration field is set,
   * and `currency_code` is provided in the original symbol information ({@link LibrarySymbolInfo}).
   * Read more about [currency conversion](https://www.tradingview.com/charting-library-docs/latest/ui_elements/Price-Scale#currency-conversion).
   */
  currencyCode?: string;
  /**
   * Indicates the unit for conversion if `units` configuration
   * field is set and `unit_id` is provided in the original symbol information ({@link LibrarySymbolInfo}).
   */
  unitId?: string;
  /**
   * Trading session string
   */
  session?: string;
}
/**
 * Symbol override data. Passed to and returned from the symbol search override funciton.
 */
export interface SymbolSearchCompleteData {
  /**
   * The symbol (or ticker).
   */
  symbol: string;
  /**
   * The human friendly symbol name to display to users.
   */
  name: string;
}
export interface SymbolSpecificTradingOptions {
  /** Array of strings with valid duration values. You can check that in Order Ticket. */
  allowedDurations?: string[];
  /** Supported order types for the instrument. */
  allowedOrderTypes?: OrderType[];
  /**
   * Whether order brackets are supported for the symbol.
   * Defaults to the value in the config.
   */
  supportOrderBrackets?: boolean;
  /**
   * Using this flag you can disable adding brackets to the existing order.
   */
  supportAddBracketsToExistingOrder?: boolean;
  /**
   * Using this flag you can disable existing order's brackets modification. If you set it to `false`,
   * additional fields will be disabled in Order Ticket on the chart,
   */
  supportModifyBrackets?: boolean;
  /**
   * Whether position brackets are supported for the symbol.
   * Defaults to the value in the config.
   */
  supportPositionBrackets?: boolean;
  /**
   * Whether trade brackets are supported for the symbol.
   * Defaults to the value in the config.
   */
  supportIndividualPositionBrackets?: boolean;
  /**
   * Whether position reversing is supported for the symbol.
   * Defaults to the value in the config.
   */
  supportReversePosition?: boolean;
  /**
   * A symbol-specific message that can be used to warn users.
   */
  warningMessage?: string;
}
/**
 * Overrides for the 'TRIX' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface TRIXIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "trix.display": number;
  /** Default value: `0` */
  "trix.linestyle": number;
  /** Default value: `1` */
  "trix.linewidth": number;
  /** Default value: `line` */
  "trix.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "trix.trackprice": boolean;
  /** Default value: `0` */
  "trix.transparency": number;
  /** Default value: `#F23645` */
  "trix.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface TableFormatterInputs<
  T extends TableFormatterInputValues = TableFormatterInputValues
> {
  /** Array of values to be formatted. Values are obtained by extracting dependent properties from the data object. */
  values: T extends [...args: infer A] ? [...A] : never;
  /** Optional field. It is array of previous values so you can compare and format accordingly. It exists if current column has the `highlightDiff: true` key. */
  prevValues?: Partial<T extends [...args: infer A] ? [...A] : never>;
}
/**
 * Override properties for the Text drawing tool.
 */
export interface TextLineToolOverrides {
  /** Default value: `rgba(91, 133, 191, 0.3)` */
  "linetooltext.backgroundColor": string;
  /** Default value: `70` */
  "linetooltext.backgroundTransparency": number;
  /** Default value: `false` */
  "linetooltext.bold": boolean;
  /** Default value: `#667b8b` */
  "linetooltext.borderColor": string;
  /** Default value: `#2962FF` */
  "linetooltext.color": string;
  /** Default value: `false` */
  "linetooltext.drawBorder": boolean;
  /** Default value: `false` */
  "linetooltext.fillBackground": boolean;
  /** Default value: `true` */
  "linetooltext.fixedSize": boolean;
  /** Default value: `14` */
  "linetooltext.fontsize": number;
  /** Default value: `false` */
  "linetooltext.italic": boolean;
  /** Default value: `false` */
  "linetooltext.wordWrap": boolean;
  /** Default value: `200` */
  "linetooltext.wordWrapWidth": number;
}
export interface TextWithCheckboxFieldCustomInfo {
  /** Title for the checkbox */
  checkboxTitle: string;
  /**
   * Using `asterix` property you can manage input type.
   * If `asterix` is set to `true` then a password input will be rendered.
   */
  asterix?: boolean;
}
export interface TextWithCheckboxFieldMetaInfo
  extends CustomInputFieldMetaInfo {
  /** @inheritDoc */
  inputType: "TextWithCheckBox";
  /** @inheritDoc */
  value: TextWithCheckboxValue;
  /** @inheritDoc */
  customInfo: TextWithCheckboxFieldCustomInfo;
  /** @inheritDoc */
  validator?: TextInputFieldValidator;
}
export interface TextWithCheckboxValue {
  /** Checkbox text */
  text: string;
  /** Whether the checkbox is checked */
  checked: boolean;
}
/**
 * Override properties for the Textabsolute drawing tool.
 */
export interface TextabsoluteLineToolOverrides {
  /** Default value: `rgba(155, 190, 213, 0.3)` */
  "linetooltextabsolute.backgroundColor": string;
  /** Default value: `70` */
  "linetooltextabsolute.backgroundTransparency": number;
  /** Default value: `false` */
  "linetooltextabsolute.bold": boolean;
  /** Default value: `#667b8b` */
  "linetooltextabsolute.borderColor": string;
  /** Default value: `#2962FF` */
  "linetooltextabsolute.color": string;
  /** Default value: `false` */
  "linetooltextabsolute.drawBorder": boolean;
  /** Default value: `false` */
  "linetooltextabsolute.fillBackground": boolean;
  /** Default value: `false` */
  "linetooltextabsolute.fixedSize": boolean;
  /** Default value: `14` */
  "linetooltextabsolute.fontsize": number;
  /** Default value: `false` */
  "linetooltextabsolute.italic": boolean;
  /** Default value: `false` */
  "linetooltextabsolute.wordWrap": boolean;
  /** Default value: `200` */
  "linetooltextabsolute.wordWrapWidth": number;
}
/**
 * Override properties for the Threedrivers drawing tool.
 */
export interface ThreedriversLineToolOverrides {
  /** Default value: `rgba(149, 40, 204, 0.5)` */
  "linetoolthreedrivers.backgroundColor": string;
  /** Default value: `false` */
  "linetoolthreedrivers.bold": boolean;
  /** Default value: `#673ab7` */
  "linetoolthreedrivers.color": string;
  /** Default value: `true` */
  "linetoolthreedrivers.fillBackground": boolean;
  /** Default value: `12` */
  "linetoolthreedrivers.fontsize": number;
  /** Default value: `false` */
  "linetoolthreedrivers.italic": boolean;
  /** Default value: `2` */
  "linetoolthreedrivers.linewidth": number;
  /** Default value: `#ffffff` */
  "linetoolthreedrivers.textcolor": string;
  /** Default value: `50` */
  "linetoolthreedrivers.transparency": number;
}
/**
 * Used in the schema defined in exportData API to describe the time field.
 * This is used when `includeTime: true` is defined in `exportData` to add time to exported data.
 */
export interface TimeFieldDescriptor {
  /** time field descriptor */
  type: "time";
}
/**
 * Definition of visible time frames that can be selected at the bottom of the chart
 * @example
 * ```javascript
 * { text: "3y", resolution: "1W", description: "3 Years", title: "3yr" }
 * ```
 */
export interface TimeFrameItem {
  /** Defines the range to be set for the given resolution. It has the `<integer><y|m|d>` ( \d+(y|m|d) as Regex ) format. */
  text: string;
  /** Resolution to be set */
  resolution: ResolutionString;
  /** Optional text displayed in the pop-up menu. If not set, `title` wil be used instead. */
  description?: string;
  /** Optional text representing the time frame. If not set a generated string will be set based on `text` property. */
  title?: string;
}
/** Defines a time frame at a specific date */
export interface TimeFramePeriodBack {
  /** Time frame period is `period-back` */
  type: TimeFrameType.PeriodBack;
  /** Time frame string. For example `'1D'` or `'6M'`. */
  value: string;
}
/** Defines a time frame between 2 dates */
export interface TimeFrameTimeRange {
  /** Time frame period is `time-range` */
  type: TimeFrameType.TimeRange;
  /**
   * A UNIX timestamp. The start of the range
   */
  from: number;
  /**
   * A UNIX timestamp. The end of the range
   */
  to: number;
}
/** Position defined by time. */
export interface TimePoint {
  /** A UNIX timestamp */
  time: number;
}
/**
 * Widget Constructor option (`time_scale`) to add more/less on screen
 */
export interface TimeScaleOptions {
  /** Minimum allowed space between bars. Should be greater than 0. */
  min_bar_spacing?: number;
}
/**
 * Override properties for the Timecycles drawing tool.
 */
export interface TimecyclesLineToolOverrides {
  /** Default value: `rgba(106, 168, 79, 0.5)` */
  "linetooltimecycles.backgroundColor": string;
  /** Default value: `true` */
  "linetooltimecycles.fillBackground": boolean;
  /** Default value: `#159980` */
  "linetooltimecycles.linecolor": string;
  /** Default value: `0` */
  "linetooltimecycles.linestyle": number;
  /** Default value: `2` */
  "linetooltimecycles.linewidth": number;
  /** Default value: `50` */
  "linetooltimecycles.transparency": number;
}
export interface TimescaleMark {
  /** ID of the timescale mark */
  id: string | number;
  /**
   * Time for the mark.
   * Unix timestamp in seconds.
   */
  time: number;
  /** Color for the timescale mark */
  color: MarkConstColors | string;
  /**
   * Color for the timescale mark text label.
   * If undefined then the value provided for `color` will be used.
   */
  labelFontColor?: MarkConstColors | string;
  /** Label for the timescale mark */
  label: string;
  /** Tooltip content */
  tooltip: string[];
  /** Shape of the timescale mark */
  shape?: TimeScaleMarkShape;
  /**
   * Optional URL for an image to be displayed within the timescale mark.
   *
   * The image should ideally be square in dimension. You can use any image type which
   * the browser supports natively.
   *
   * Examples:
   * - `https://s3-symbol-logo.tradingview.com/crypto/XTVCBTC.svg`
   * - `/images/myImage.png`
   * - `data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3...`
   * - `data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAASABIAAD/4...`
   */
  imageUrl?: string;
  /**
   * Continue to show text label even when an image has
   * been loaded for the timescale mark.
   *
   * Defaults to `false` if undefined.
   */
  showLabelWhenImageLoaded?: boolean;
}
/**
 * Supported timezone identifier are {@link LibrarySymbolInfo.timezones} and {@link LibrarySymbolInfo.exchange}.
 * `exchange` is a special "timezone" that means the timezone of a currently active symbol.
 * Thus the actual timezone will be calculated every time a symbol changes.
 */
export interface TimezoneInfo {
  /** Timezone identifier {@link TimezoneId} */
  id: TimezoneId | CustomTimezoneId;
  /** Name of the timezone */
  title: string;
  /** Optional number to indicate an offset */
  offset?: number;
  /**
   * Id of supported default timezone to use for the actual timezone calculations, see {@link TimezoneId}
   */
  alias?: TimezoneId | GmtTimezoneId;
}
export interface TradeContext {
  /** Symbol name */
  symbol: string;
  /** Symbol display name */
  displaySymbol: string;
  /** Price value */
  value: number | null;
  /** Formatted value */
  formattedValue: string;
  /** Previous value */
  last: number;
}
export interface TradingCustomization {
  /** Overrides for Positions */
  position: Overrides;
  /** Overrides for Orders */
  order: Overrides;
}
export interface TradingDialogOptions {
  /** Custom fields that are displayed in the Order Ticket.
   * Refer to the [Add custom fields](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/order-ticket.md#add-custom-fields) section for more information.
   *
   * **Example**
   * ```javascript
   * customFields: [
   *     {
   *         inputType: 'TextWithCheckBox',
   *         id: '2410',
   *         title: 'Digital Signature',
   *         placeHolder: 'Enter your personal digital signature',
   *         value: {
   *             text: '',
   *             checked: false,
   *         },
   *         customInfo: {
   *             asterix: true,
   *             checkboxTitle: 'Save',
   *         },
   *     }
   * ]
   * ```
   *
   */
  customFields?: TradingDialogCustomField[];
}
export interface TradingQuotes {
  /** Trade */
  trade?: number;
  /** Quote size */
  size?: number;
  /** Bid price */
  bid?: number;
  /** Bid quantity */
  bid_size?: number;
  /** Ask price */
  ask?: number;
  /** Ask quantity */
  ask_size?: number;
  /** Price spread */
  spread?: number;
  /** Whether quotes are delayed */
  isDelayed?: boolean;
  /** Whether quotes are halted */
  isHalted?: boolean;
  /** Whether quotes are hard to borrow */
  isHardToBorrow?: boolean;
  /** Whether quotes are can not be shorted */
  isNotShortable?: boolean;
}
export interface TradingTerminalWidgetOptions
  extends Omit<
    ChartingLibraryWidgetOptions,
    "enabled_features" | "disabled_features" | "favorites"
  > {
  /**
   * The array containing names of features that should be disabled by default. `Feature` means part of the functionality of the chart (part of the UI/UX). Supported features are listed in [Featuresets](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md).
   *
   * Example:
   * ```javascript
   * disabled_features: ["header_widget", "left_toolbar"],
   * ```
   */
  disabled_features?: TradingTerminalFeatureset[];
  /**
   * The array containing names of features that should be enabled by default. `Feature` means part of the functionality of the chart (part of the UI/UX). Supported features are listed in [Featuresets](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md).
   *
   * Example:
   * ```javascript
   * enabled_features: ["move_logo_to_main_pane"],
   * ```
   */
  enabled_features?: TradingTerminalFeatureset[];
  /**
   * See {@link ChartingLibraryWidgetOptions.favorites}
   */
  favorites?: Favorites<TradingTerminalChartTypeFavorites>;
  /** configuration flags for the Trading Platform. */
  brokerConfig?: SingleBrokerMetaInfo;
  /** configuration flags for the Trading Platform. */
  broker_config?: SingleBrokerMetaInfo;
  /** Connection configuration settings for Rest Broker API */
  restConfig?: RestBrokerConnectionInfo;
  /**
   * Settings for the widget panel on the right side of the chart.
   * Watchlist, news, details and data window widgets on the right side of the chart can be enabled using the `widgetbar` field in Widget Constructor
   */
  widgetbar?: WidgetBarParams;
  /**
   * Use this property to change the RSS feed for news. You can set a different RSS for each symbol type or use a single RSS for all symbols. The object should have the `default` property, other properties are optional. The names of the properties match the symbol types. Each property is an object (or an array of objects) with the following properties:
   *
   * 1. `url` - is a URL to be requested. It can contain tags in curly brackets that will be replaced by the terminal: `{SYMBOL}`, `{TYPE}`, `{EXCHANGE}`.
   * 1. `name` - is a name of the feed to be displayed underneath the news.
   *
   * @example
   * ```javascript
   * rss_news_feed: {
   *     default: [ {
   *         url: "https://articlefeeds.nasdaq.com/nasdaq/symbols?symbol={SYMBOL}",
   *         name: "NASDAQ"
   *       }, {
   *         url: "http://feeds.finance.yahoo.com/rss/2.0/headline?s={SYMBOL}&region=US&lang=en-US",
   *         name: "Yahoo Finance"
   *       } ]
   * },
   * ```
   *
   * @example
   * ```javascript
   * rss_news_feed: {
   *     "default": {
   *         url: "https://articlefeeds.nasdaq.com/nasdaq/symbols?symbol={SYMBOL}",
   *         name: "NASDAQ"
   *     }
   * }
   * ```
   *
   * @example
   * ```javascript
   * rss_news_feed: {
   *     "default": {
   *         url: "https://articlefeeds.nasdaq.com/nasdaq/symbols?symbol={SYMBOL}",
   *         name: "NASDAQ"
   *      },
   *     "stock": {
   *         url: "http://feeds.finance.yahoo.com/rss/2.0/headline?s={SYMBOL}&region=US&lang=en-US",
   *         name: "Yahoo Finance"
   *     }
   * }
   * ```
   */
  rss_news_feed?: RssNewsFeedParams;
  /**
   * Title for the News Widget
   */
  rss_news_title?: string;
  /**
   * Use this property to set your own news getter function. Both the `symbol` and `callback` will be passed to the function.
   *
   * The callback function should be called with an object. The object should have two properties: `title` which is a optional string, and `newsItems` which is an array of news objects that have the following structure:
   *
   * * `title` (required) - the title of news item.
   * * `published` (required) - the time of news item in ms (UTC).
   * * `source` (optional) - source of the news item title.
   * * `shortDescription` (optional) - Short description of a news item that will be displayed under the title.
   * * `link` (optional) - URL to the news story.
   * * `fullDescription` (optional) - full description (body) of a news item.
   *
   * **NOTE:** Only `title` and `published` are the main properties used to compare what has already been published and what's new.
   *
   * **NOTE 2:** When a user clicks on a news item a new tab with the `link` URL will be opened. If `link` is not specified then a pop-up dialog with `fullDescription` will be shown.
   *
   * **NOTE 3:** If both `news_provider` and `rss_news_feed` are available then the `rss_news_feed` will be ignored.
   *
   * See [News API examples](https://www.tradingview.com/charting-library-docs/latest/trading_terminal/news/News-Api-Examples.md) for usage examples.
   */
  news_provider?: GetNewsFunction;
  /** Override customizations for trading */
  trading_customization?: TradingCustomization;
  /**
   * Use this field to pass the function that returns a new object which implements Broker API. This is a function that accepts the Trading Host ({@link IBrokerConnectionAdapterHost}).
   *
   * @example
   * ```javascript
   * broker_factory: function(host) { ... }
   * ```
   * @param host - Trading Host
   */
  broker_factory?(
    host: IBrokerConnectionAdapterHost
  ): IBrokerWithoutRealtime | IBrokerTerminal;
}
/**
 * Overrides for the 'Trend Strength Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface TrendStrengthIndexIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF5252` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Override properties for the Trendangle drawing tool.
 */
export interface TrendangleLineToolOverrides {
  /** Default value: `false` */
  "linetooltrendangle.alwaysShowStats": boolean;
  /** Default value: `false` */
  "linetooltrendangle.bold": boolean;
  /** Default value: `false` */
  "linetooltrendangle.extendLeft": boolean;
  /** Default value: `false` */
  "linetooltrendangle.extendRight": boolean;
  /** Default value: `12` */
  "linetooltrendangle.fontsize": number;
  /** Default value: `false` */
  "linetooltrendangle.italic": boolean;
  /** Default value: `#2962FF` */
  "linetooltrendangle.linecolor": string;
  /** Default value: `0` */
  "linetooltrendangle.linestyle": number;
  /** Default value: `2` */
  "linetooltrendangle.linewidth": number;
  /** Default value: `false` */
  "linetooltrendangle.showBarsRange": boolean;
  /** Default value: `false` */
  "linetooltrendangle.showMiddlePoint": boolean;
  /** Default value: `false` */
  "linetooltrendangle.showPercentPriceRange": boolean;
  /** Default value: `false` */
  "linetooltrendangle.showPipsPriceRange": boolean;
  /** Default value: `false` */
  "linetooltrendangle.showPriceLabels": boolean;
  /** Default value: `false` */
  "linetooltrendangle.showPriceRange": boolean;
  /** Default value: `2` */
  "linetooltrendangle.statsPosition": number;
  /** Default value: `#2962FF` */
  "linetooltrendangle.textcolor": string;
}
/**
 * Override properties for the Trendbasedfibextension drawing tool.
 */
export interface TrendbasedfibextensionLineToolOverrides {
  /** Default value: `false` */
  "linetooltrendbasedfibextension.coeffsAsPercents": boolean;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.extendLines": boolean;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.extendLinesLeft": boolean;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.fibLevelsBasedOnLogScale": boolean;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.fillBackground": boolean;
  /** Default value: `left` */
  "linetooltrendbasedfibextension.horzLabelsAlign": string;
  /** Default value: `12` */
  "linetooltrendbasedfibextension.labelFontSize": number;
  /** Default value: `0` */
  "linetooltrendbasedfibextension.level1.coeff": number;
  /** Default value: `#787B86` */
  "linetooltrendbasedfibextension.level1.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level1.visible": boolean;
  /** Default value: `3.618` */
  "linetooltrendbasedfibextension.level10.coeff": number;
  /** Default value: `#9c27b0` */
  "linetooltrendbasedfibextension.level10.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level10.visible": boolean;
  /** Default value: `4.236` */
  "linetooltrendbasedfibextension.level11.coeff": number;
  /** Default value: `#e91e63` */
  "linetooltrendbasedfibextension.level11.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level11.visible": boolean;
  /** Default value: `1.272` */
  "linetooltrendbasedfibextension.level12.coeff": number;
  /** Default value: `#FF9800` */
  "linetooltrendbasedfibextension.level12.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level12.visible": boolean;
  /** Default value: `1.414` */
  "linetooltrendbasedfibextension.level13.coeff": number;
  /** Default value: `#F23645` */
  "linetooltrendbasedfibextension.level13.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level13.visible": boolean;
  /** Default value: `2.272` */
  "linetooltrendbasedfibextension.level14.coeff": number;
  /** Default value: `#FF9800` */
  "linetooltrendbasedfibextension.level14.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level14.visible": boolean;
  /** Default value: `2.414` */
  "linetooltrendbasedfibextension.level15.coeff": number;
  /** Default value: `#4caf50` */
  "linetooltrendbasedfibextension.level15.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level15.visible": boolean;
  /** Default value: `2` */
  "linetooltrendbasedfibextension.level16.coeff": number;
  /** Default value: `#089981` */
  "linetooltrendbasedfibextension.level16.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level16.visible": boolean;
  /** Default value: `3` */
  "linetooltrendbasedfibextension.level17.coeff": number;
  /** Default value: `#00bcd4` */
  "linetooltrendbasedfibextension.level17.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level17.visible": boolean;
  /** Default value: `3.272` */
  "linetooltrendbasedfibextension.level18.coeff": number;
  /** Default value: `#787B86` */
  "linetooltrendbasedfibextension.level18.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level18.visible": boolean;
  /** Default value: `3.414` */
  "linetooltrendbasedfibextension.level19.coeff": number;
  /** Default value: `#2962FF` */
  "linetooltrendbasedfibextension.level19.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level19.visible": boolean;
  /** Default value: `0.236` */
  "linetooltrendbasedfibextension.level2.coeff": number;
  /** Default value: `#F23645` */
  "linetooltrendbasedfibextension.level2.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level2.visible": boolean;
  /** Default value: `4` */
  "linetooltrendbasedfibextension.level20.coeff": number;
  /** Default value: `#F23645` */
  "linetooltrendbasedfibextension.level20.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level20.visible": boolean;
  /** Default value: `4.272` */
  "linetooltrendbasedfibextension.level21.coeff": number;
  /** Default value: `#9c27b0` */
  "linetooltrendbasedfibextension.level21.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level21.visible": boolean;
  /** Default value: `4.414` */
  "linetooltrendbasedfibextension.level22.coeff": number;
  /** Default value: `#e91e63` */
  "linetooltrendbasedfibextension.level22.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level22.visible": boolean;
  /** Default value: `4.618` */
  "linetooltrendbasedfibextension.level23.coeff": number;
  /** Default value: `#FF9800` */
  "linetooltrendbasedfibextension.level23.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level23.visible": boolean;
  /** Default value: `4.764` */
  "linetooltrendbasedfibextension.level24.coeff": number;
  /** Default value: `#089981` */
  "linetooltrendbasedfibextension.level24.color": string;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.level24.visible": boolean;
  /** Default value: `0.382` */
  "linetooltrendbasedfibextension.level3.coeff": number;
  /** Default value: `#FF9800` */
  "linetooltrendbasedfibextension.level3.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level3.visible": boolean;
  /** Default value: `0.5` */
  "linetooltrendbasedfibextension.level4.coeff": number;
  /** Default value: `#4caf50` */
  "linetooltrendbasedfibextension.level4.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level4.visible": boolean;
  /** Default value: `0.618` */
  "linetooltrendbasedfibextension.level5.coeff": number;
  /** Default value: `#089981` */
  "linetooltrendbasedfibextension.level5.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level5.visible": boolean;
  /** Default value: `0.786` */
  "linetooltrendbasedfibextension.level6.coeff": number;
  /** Default value: `#00bcd4` */
  "linetooltrendbasedfibextension.level6.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level6.visible": boolean;
  /** Default value: `1` */
  "linetooltrendbasedfibextension.level7.coeff": number;
  /** Default value: `#787B86` */
  "linetooltrendbasedfibextension.level7.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level7.visible": boolean;
  /** Default value: `1.618` */
  "linetooltrendbasedfibextension.level8.coeff": number;
  /** Default value: `#2962FF` */
  "linetooltrendbasedfibextension.level8.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level8.visible": boolean;
  /** Default value: `2.618` */
  "linetooltrendbasedfibextension.level9.coeff": number;
  /** Default value: `#F23645` */
  "linetooltrendbasedfibextension.level9.color": string;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.level9.visible": boolean;
  /** Default value: `0` */
  "linetooltrendbasedfibextension.levelsStyle.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibextension.levelsStyle.linewidth": number;
  /** Default value: `false` */
  "linetooltrendbasedfibextension.reverse": boolean;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.showCoeffs": boolean;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.showPrices": boolean;
  /** Default value: `80` */
  "linetooltrendbasedfibextension.transparency": number;
  /** Default value: `#787B86` */
  "linetooltrendbasedfibextension.trendline.color": string;
  /** Default value: `2` */
  "linetooltrendbasedfibextension.trendline.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibextension.trendline.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibextension.trendline.visible": boolean;
  /** Default value: `bottom` */
  "linetooltrendbasedfibextension.vertLabelsAlign": string;
}
/**
 * Override properties for the Trendbasedfibtime drawing tool.
 */
export interface TrendbasedfibtimeLineToolOverrides {
  /** Default value: `true` */
  "linetooltrendbasedfibtime.fillBackground": boolean;
  /** Default value: `right` */
  "linetooltrendbasedfibtime.horzLabelsAlign": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level1.coeff": number;
  /** Default value: `#787B86` */
  "linetooltrendbasedfibtime.level1.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level1.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level1.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level1.visible": boolean;
  /** Default value: `2.618` */
  "linetooltrendbasedfibtime.level10.coeff": number;
  /** Default value: `#9c27b0` */
  "linetooltrendbasedfibtime.level10.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level10.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level10.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level10.visible": boolean;
  /** Default value: `3` */
  "linetooltrendbasedfibtime.level11.coeff": number;
  /** Default value: `#673ab7` */
  "linetooltrendbasedfibtime.level11.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level11.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level11.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level11.visible": boolean;
  /** Default value: `0.382` */
  "linetooltrendbasedfibtime.level2.coeff": number;
  /** Default value: `#F23645` */
  "linetooltrendbasedfibtime.level2.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level2.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level2.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level2.visible": boolean;
  /** Default value: `0.5` */
  "linetooltrendbasedfibtime.level3.coeff": number;
  /** Default value: `#81c784` */
  "linetooltrendbasedfibtime.level3.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level3.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level3.linewidth": number;
  /** Default value: `false` */
  "linetooltrendbasedfibtime.level3.visible": boolean;
  /** Default value: `0.618` */
  "linetooltrendbasedfibtime.level4.coeff": number;
  /** Default value: `#4caf50` */
  "linetooltrendbasedfibtime.level4.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level4.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level4.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level4.visible": boolean;
  /** Default value: `1` */
  "linetooltrendbasedfibtime.level5.coeff": number;
  /** Default value: `#089981` */
  "linetooltrendbasedfibtime.level5.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level5.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level5.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level5.visible": boolean;
  /** Default value: `1.382` */
  "linetooltrendbasedfibtime.level6.coeff": number;
  /** Default value: `#00bcd4` */
  "linetooltrendbasedfibtime.level6.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level6.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level6.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level6.visible": boolean;
  /** Default value: `1.618` */
  "linetooltrendbasedfibtime.level7.coeff": number;
  /** Default value: `#787B86` */
  "linetooltrendbasedfibtime.level7.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level7.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level7.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level7.visible": boolean;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level8.coeff": number;
  /** Default value: `#2962FF` */
  "linetooltrendbasedfibtime.level8.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level8.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level8.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level8.visible": boolean;
  /** Default value: `2.382` */
  "linetooltrendbasedfibtime.level9.coeff": number;
  /** Default value: `#e91e63` */
  "linetooltrendbasedfibtime.level9.color": string;
  /** Default value: `0` */
  "linetooltrendbasedfibtime.level9.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.level9.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.level9.visible": boolean;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.showCoeffs": boolean;
  /** Default value: `80` */
  "linetooltrendbasedfibtime.transparency": number;
  /** Default value: `#787B86` */
  "linetooltrendbasedfibtime.trendline.color": string;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.trendline.linestyle": number;
  /** Default value: `2` */
  "linetooltrendbasedfibtime.trendline.linewidth": number;
  /** Default value: `true` */
  "linetooltrendbasedfibtime.trendline.visible": boolean;
  /** Default value: `bottom` */
  "linetooltrendbasedfibtime.vertLabelsAlign": string;
}
/**
 * Override properties for the Trendline drawing tool.
 */
export interface TrendlineLineToolOverrides {
  /** Default value: `false` */
  "linetooltrendline.alwaysShowStats": boolean;
  /** Default value: `false` */
  "linetooltrendline.bold": boolean;
  /** Default value: `false` */
  "linetooltrendline.extendLeft": boolean;
  /** Default value: `false` */
  "linetooltrendline.extendRight": boolean;
  /** Default value: `14` */
  "linetooltrendline.fontsize": number;
  /** Default value: `center` */
  "linetooltrendline.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetooltrendline.italic": boolean;
  /** Default value: `0` */
  "linetooltrendline.leftEnd": number;
  /** Default value: `#2962FF` */
  "linetooltrendline.linecolor": string;
  /** Default value: `0` */
  "linetooltrendline.linestyle": number;
  /** Default value: `2` */
  "linetooltrendline.linewidth": number;
  /** Default value: `0` */
  "linetooltrendline.rightEnd": number;
  /** Default value: `false` */
  "linetooltrendline.showAngle": boolean;
  /** Default value: `false` */
  "linetooltrendline.showBarsRange": boolean;
  /** Default value: `false` */
  "linetooltrendline.showDateTimeRange": boolean;
  /** Default value: `false` */
  "linetooltrendline.showDistance": boolean;
  /** Default value: `false` */
  "linetooltrendline.showLabel": boolean;
  /** Default value: `false` */
  "linetooltrendline.showMiddlePoint": boolean;
  /** Default value: `false` */
  "linetooltrendline.showPercentPriceRange": boolean;
  /** Default value: `false` */
  "linetooltrendline.showPipsPriceRange": boolean;
  /** Default value: `false` */
  "linetooltrendline.showPriceLabels": boolean;
  /** Default value: `false` */
  "linetooltrendline.showPriceRange": boolean;
  /** Default value: `2` */
  "linetooltrendline.statsPosition": number;
  /** Default value: `#2962FF` */
  "linetooltrendline.textcolor": string;
  /** Default value: `bottom` */
  "linetooltrendline.vertLabelsAlign": string;
}
/**
 * Override properties for the Triangle drawing tool.
 */
export interface TriangleLineToolOverrides {
  /** Default value: `rgba(8, 153, 129, 0.2)` */
  "linetooltriangle.backgroundColor": string;
  /** Default value: `#089981` */
  "linetooltriangle.color": string;
  /** Default value: `true` */
  "linetooltriangle.fillBackground": boolean;
  /** Default value: `2` */
  "linetooltriangle.linewidth": number;
  /** Default value: `80` */
  "linetooltriangle.transparency": number;
}
/**
 * Override properties for the Trianglepattern drawing tool.
 */
export interface TrianglepatternLineToolOverrides {
  /** Default value: `#673ab7` */
  "linetooltrianglepattern.backgroundColor": string;
  /** Default value: `false` */
  "linetooltrianglepattern.bold": boolean;
  /** Default value: `#673ab7` */
  "linetooltrianglepattern.color": string;
  /** Default value: `true` */
  "linetooltrianglepattern.fillBackground": boolean;
  /** Default value: `12` */
  "linetooltrianglepattern.fontsize": number;
  /** Default value: `false` */
  "linetooltrianglepattern.italic": boolean;
  /** Default value: `2` */
  "linetooltrianglepattern.linewidth": number;
  /** Default value: `#ffffff` */
  "linetooltrianglepattern.textcolor": string;
  /** Default value: `85` */
  "linetooltrianglepattern.transparency": number;
}
/**
 * Overrides for the 'Triple EMA' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface TripleEMAIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'True Strength Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface TrueStrengthIndexIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "true strength index.display": number;
  /** Default value: `0` */
  "true strength index.linestyle": number;
  /** Default value: `1` */
  "true strength index.linewidth": number;
  /** Default value: `line` */
  "true strength index.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "true strength index.trackprice": boolean;
  /** Default value: `0` */
  "true strength index.transparency": number;
  /** Default value: `#2196F3` */
  "true strength index.color": string;
  /** Default value: `15` */
  "signal.display": number;
  /** Default value: `0` */
  "signal.linestyle": number;
  /** Default value: `1` */
  "signal.linewidth": number;
  /** Default value: `line` */
  "signal.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "signal.trackprice": boolean;
  /** Default value: `0` */
  "signal.transparency": number;
  /** Default value: `#E91E63` */
  "signal.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Typical Price' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface TypicalPriceIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF6D00` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Ultimate Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface UltimateOscillatorIndicatorOverrides {
  /** Default value: `15` */
  "uo.display": number;
  /** Default value: `0` */
  "uo.linestyle": number;
  /** Default value: `1` */
  "uo.linewidth": number;
  /** Default value: `line` */
  "uo.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "uo.trackprice": boolean;
  /** Default value: `0` */
  "uo.transparency": number;
  /** Default value: `#F23645` */
  "uo.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Undo options.
 */
export interface UndoOptions {
  /**
   * A boolean flag. Controls if undo should be disabled.
   */
  disableUndo?: boolean;
}
/** State of the Undo/Redo stack. This object has the same structure as the result of {@link IChartingLibraryWidget.undoRedoState} method */
export interface UndoRedoState {
  /** Undo is enabled */
  readonly enableUndo: boolean;
  /** Undo text */
  readonly undoText: string | undefined;
  /** Redo is enabled */
  readonly enableRedo: boolean;
  /** Redo text */
  readonly redoText: string | undefined;
  /** Original text for undo action - without being translated */
  readonly originalUndoText: string | undefined;
  /** Original text for redo action - without being translated */
  readonly originalRedoText: string | undefined;
}
export interface Unit {
  /** Unique ID */
  id: string;
  /** Short name */
  name: string;
  /** Description */
  description: string;
}
export interface UnitInfo {
  /** Unit displayed on the price scale if any is specified */
  selectedUnit: string | null;
  /** Groups of units (for example weight, energy, ...) */
  availableGroups: string[];
}
/**
 * Used in the schema defined in exportData API to describe the user time field.
 * This is used when `includeUserTime: true` is defined in `exportData` to add user time (aka time that is displayed to the user on the chart) to exported data.
 */
export interface UserTimeFieldDescriptor {
  /** user time field descriptor */
  type: "userTime";
}
/**
 * Overrides for the 'VWAP' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VWAPIndicatorOverrides {
  /** Default value: `15` */
  "vwap.display": number;
  /** Default value: `0` */
  "vwap.linestyle": number;
  /** Default value: `1` */
  "vwap.linewidth": number;
  /** Default value: `line` */
  "vwap.plottype": LineStudyPlotStyleName;
  /** Default value: `0` */
  "vwap.trackprice": number;
  /** Default value: `0` */
  "vwap.transparency": number;
  /** Default value: `#2196F3` */
  "vwap.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'VWMA' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VWMAIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface ValueByStyleId<TValue> {
  [styleId: string]: TValue | undefined;
}
export interface VertLinePreferences {
  /** Is visible if set to `true` */
  visible: boolean;
  /** Width of the vertical line */
  width: number;
  /** Color of the horizontal line */
  color: string;
  /** Line style */
  style: LineStyle;
}

/**
 * Override properties for the Vertline drawing tool.
 */
export interface VertlineLineToolOverrides {
  /** Default value: `false` */
  "linetoolvertline.bold": boolean;
  /** Default value: `true` */
  "linetoolvertline.extendLine": boolean;
  /** Default value: `14` */
  "linetoolvertline.fontsize": number;
  /** Default value: `right` */
  "linetoolvertline.horzLabelsAlign": string;
  /** Default value: `false` */
  "linetoolvertline.italic": boolean;
  /** Default value: `#2962FF` */
  "linetoolvertline.linecolor": string;
  /** Default value: `0` */
  "linetoolvertline.linestyle": number;
  /** Default value: `2` */
  "linetoolvertline.linewidth": number;
  /** Default value: `false` */
  "linetoolvertline.showLabel": boolean;
  /** Default value: `true` */
  "linetoolvertline.showTime": boolean;
  /** Default value: `#2962FF` */
  "linetoolvertline.textcolor": string;
  /** Default value: `vertical` */
  "linetoolvertline.textOrientation": string;
  /** Default value: `top` */
  "linetoolvertline.vertLabelsAlign": string;
}
/**
 * Boundaries of the price scale visible range in main series area
 */
export interface VisiblePriceRange {
  /**
   * A UNIX timestamp. The start of the range.
   */
  from: number;
  /**
   * A UNIX timestamp. The end of the range.
   */
  to: number;
}
/**
 * A time range.
 */
export interface VisibleTimeRange {
  /**
   * A UNIX timestamp. The start of the range.
   */
  from: number;
  /**
   * A UNIX timestamp. The end of the range.
   */
  to: number;
}
/**
 * Overrides for the 'Volatility Close-to-Close' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VolatilityClosetoCloseIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Volatility Index' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VolatilityIndexIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF5252` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Volatility O-H-L-C' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VolatilityOHLCIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#FF5252` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Volatility Zero Trend Close-to-Close' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VolatilityZeroTrendClosetoCloseIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Volume' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VolumeIndicatorOverrides {
  /** Default value: `15` */
  "volume.display": number;
  /** Default value: `0` */
  "volume.linestyle": number;
  /** Default value: `1` */
  "volume.linewidth": number;
  /** Default value: `columns` */
  "volume.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume.trackprice": boolean;
  /** Default value: `50` */
  "volume.transparency": number;
  /** Default value: `#000080` */
  "volume.color": string;
  /** Default value: `0` */
  "volume ma.display": number;
  /** Default value: `0` */
  "volume ma.linestyle": number;
  /** Default value: `1` */
  "volume ma.linewidth": number;
  /** Default value: `line` */
  "volume ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "volume ma.trackprice": boolean;
  /** Default value: `0` */
  "volume ma.transparency": number;
  /** Default value: `#2196F3` */
  "volume ma.color": string;
  /** Default value: `0` */
  "smoothed ma.display": number;
  /** Default value: `0` */
  "smoothed ma.linestyle": number;
  /** Default value: `1` */
  "smoothed ma.linewidth": number;
  /** Default value: `line` */
  "smoothed ma.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "smoothed ma.trackprice": boolean;
  /** Default value: `0` */
  "smoothed ma.transparency": number;
  /** Default value: `#2196F3` */
  "smoothed ma.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Volume Oscillator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VolumeOscillatorIndicatorOverrides {
  /** Default value: `#787B86` */
  "zero.color": string;
  /** Default value: `2` */
  "zero.linestyle": number;
  /** Default value: `1` */
  "zero.linewidth": number;
  /** Default value: `true` */
  "zero.visible": boolean;
  /** Default value: `0` */
  "zero.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Volume Profile Fixed Range' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VolumeProfileFixedRangeIndicatorOverrides {
  /** Default value: `#ff0000` */
  "developing poc.color": string;
  /** Default value: `0` */
  "developing poc.linestyle": number;
  /** Default value: `1` */
  "developing poc.linewidth": number;
  /** Default value: `step_line` */
  "developing poc.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing poc.trackprice": boolean;
  /** Default value: `0` */
  "developing poc.transparency": number;
  /** Default value: `0` */
  "developing poc.display": number;
  /** Default value: `#0000ff` */
  "developing va high.color": string;
  /** Default value: `0` */
  "developing va high.linestyle": number;
  /** Default value: `1` */
  "developing va high.linewidth": number;
  /** Default value: `step_line` */
  "developing va high.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing va high.trackprice": boolean;
  /** Default value: `0` */
  "developing va high.transparency": number;
  /** Default value: `0` */
  "developing va high.display": number;
  /** Default value: `#0000ff` */
  "developing va low.color": string;
  /** Default value: `0` */
  "developing va low.linestyle": number;
  /** Default value: `1` */
  "developing va low.linewidth": number;
  /** Default value: `step_line` */
  "developing va low.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing va low.trackprice": boolean;
  /** Default value: `0` */
  "developing va low.transparency": number;
  /** Default value: `0` */
  "developing va low.display": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Volume Profile Visible Range' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VolumeProfileVisibleRangeIndicatorOverrides {
  /** Default value: `#ff0000` */
  "developing poc.color": string;
  /** Default value: `0` */
  "developing poc.linestyle": number;
  /** Default value: `1` */
  "developing poc.linewidth": number;
  /** Default value: `step_line` */
  "developing poc.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing poc.trackprice": boolean;
  /** Default value: `0` */
  "developing poc.transparency": number;
  /** Default value: `0` */
  "developing poc.display": number;
  /** Default value: `#0000ff` */
  "developing va high.color": string;
  /** Default value: `0` */
  "developing va high.linestyle": number;
  /** Default value: `1` */
  "developing va high.linewidth": number;
  /** Default value: `step_line` */
  "developing va high.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing va high.trackprice": boolean;
  /** Default value: `0` */
  "developing va high.transparency": number;
  /** Default value: `0` */
  "developing va high.display": number;
  /** Default value: `#0000ff` */
  "developing va low.color": string;
  /** Default value: `0` */
  "developing va low.linestyle": number;
  /** Default value: `1` */
  "developing va low.linewidth": number;
  /** Default value: `step_line` */
  "developing va low.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "developing va low.trackprice": boolean;
  /** Default value: `0` */
  "developing va low.transparency": number;
  /** Default value: `0` */
  "developing va low.display": number;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Vortex Indicator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface VortexIndicatorIndicatorOverrides {
  /** Default value: `15` */
  "vi +.display": number;
  /** Default value: `0` */
  "vi +.linestyle": number;
  /** Default value: `1` */
  "vi +.linewidth": number;
  /** Default value: `line` */
  "vi +.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "vi +.trackprice": boolean;
  /** Default value: `0` */
  "vi +.transparency": number;
  /** Default value: `#2196F3` */
  "vi +.color": string;
  /** Default value: `15` */
  "vi -.display": number;
  /** Default value: `0` */
  "vi -.linestyle": number;
  /** Default value: `1` */
  "vi -.linewidth": number;
  /** Default value: `line` */
  "vi -.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "vi -.trackprice": boolean;
  /** Default value: `0` */
  "vi -.transparency": number;
  /** Default value: `#E91E63` */
  "vi -.color": string;
  [key: string]: StudyOverrideValueType;
}
export interface WatchListSymbolList extends WatchListSymbolListData {
  /** Symbol ID */
  id: string;
}
export interface WatchListSymbolListData {
  /** Symbol IDs in watchlist */
  symbols: string[];
  /** Title for the watchlist */
  title: string;
}
export interface WatchListSymbolListMap {
  /** Symbol watchlist */
  [listId: string]: WatchListSymbolList;
}
export interface WatchedValueSubscribeOptions {
  /** Subscribe for only one update, and remove subscription afterwards. (the callback will be executed only once) */
  once?: boolean;
  /** if it is set to true then the callback will be executed with the previous value (if available) */
  callWithLast?: boolean;
}
/**
 * Data provided to the {@link WatermarkContentProvider}.
 */
export interface WatermarkContentData {
  /**
   * Symbol Information.
   */
  symbolInfo: LibrarySymbolInfo;
  /**
   * Current interval string.
   */
  interval: string;
}
/**
 * Defines the text and font properties for a line of the watermark.
 *
 * The default values for sizing and placement are as follows:
 * - 1st line: \{ fontSize: 96, lineHeight: 117, vertOffset: 0, \}
 * - 2nd line: \{ fontSize: 48, lineHeight: 58, vertOffset: 5, \}
 */
export interface WatermarkLine {
  /**
   * Text to be displayed.
   */
  text: string;
  /**
   * Font size to be used (defined in pixels).
   */
  fontSize: number;
  /**
   * Line height (defined in pixels).
   */
  lineHeight: number;
  /**
   * Vertical offset distance (defined in pixels).
   */
  vertOffset: number;
}
export interface WidgetBarParams {
  /**
   * Enables details widget in the widget panel on the right.
   * @default false
   */
  details?: boolean;
  /**
   * Enables watchlist widget in the widget panel on the right.
   * @default false
   */
  watchlist?: boolean;
  /**
   * Enables news widget in the widget panel on the right.
   * @default false
   */
  news?: boolean;
  /**
   * Enables data window widget in the widget panel on the right.
   * @default false
   */
  datawindow?: boolean;
  /** Watchlist settings */
  watchlist_settings?: {
    /**
     * Sets the list of default symbols for watchlist.
     *
     * Any item in the list which is prefixed with `###` will be considered a
     * section divider in the watchlist.
     * @default []
     *
     * **Example:**
     * ```
     * default_symbols: ['###TOP SECTION', 'AAPL', 'IBM', '###SECOND SECTION', 'MSFT']
     * ```
     */
    default_symbols: string[];
    /**
     * Enables read-only mode for the watchlist
     * @default false
     */
    readonly?: boolean;
  };
}
/**
 * Overrides for the 'Williams Alligator' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface WilliamsAlligatorIndicatorOverrides {
  /** Default value: `15` */
  "jaw.display": number;
  /** Default value: `0` */
  "jaw.linestyle": number;
  /** Default value: `1` */
  "jaw.linewidth": number;
  /** Default value: `line` */
  "jaw.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "jaw.trackprice": boolean;
  /** Default value: `0` */
  "jaw.transparency": number;
  /** Default value: `#2196F3` */
  "jaw.color": string;
  /** Default value: `15` */
  "teeth.display": number;
  /** Default value: `0` */
  "teeth.linestyle": number;
  /** Default value: `1` */
  "teeth.linewidth": number;
  /** Default value: `line` */
  "teeth.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "teeth.trackprice": boolean;
  /** Default value: `0` */
  "teeth.transparency": number;
  /** Default value: `#E91E63` */
  "teeth.color": string;
  /** Default value: `15` */
  "lips.display": number;
  /** Default value: `0` */
  "lips.linestyle": number;
  /** Default value: `1` */
  "lips.linewidth": number;
  /** Default value: `line` */
  "lips.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "lips.trackprice": boolean;
  /** Default value: `0` */
  "lips.transparency": number;
  /** Default value: `#66BB6A` */
  "lips.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Williams Fractal' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface WilliamsFractalIndicatorOverrides {
  /** Default value: `15` */
  "down fractals.display": number;
  /** Default value: `shape_triangle_down` */
  "down fractals.plottype": string;
  /** Default value: `BelowBar` */
  "down fractals.location": string;
  /** Default value: `0` */
  "down fractals.transparency": number;
  /** Default value: `#F23645` */
  "down fractals.color": string;
  /** Default value: `15` */
  "up fractals.display": number;
  /** Default value: `shape_triangle_up` */
  "up fractals.plottype": string;
  /** Default value: `AboveBar` */
  "up fractals.location": string;
  /** Default value: `0` */
  "up fractals.transparency": number;
  /** Default value: `#089981` */
  "up fractals.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Williams %R' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface WilliamsRIndicatorOverrides {
  /** Default value: `#7E57C2` */
  "hlines background.color": string;
  /** Default value: `90` */
  "hlines background.transparency": number;
  /** Default value: `true` */
  "hlines background.visible": boolean;
  /** Default value: `#787B86` */
  "upperlimit.color": string;
  /** Default value: `2` */
  "upperlimit.linestyle": number;
  /** Default value: `1` */
  "upperlimit.linewidth": number;
  /** Default value: `true` */
  "upperlimit.visible": boolean;
  /** Default value: `-20` */
  "upperlimit.value": number;
  /** Default value: `#787B86` */
  "lowerlimit.color": string;
  /** Default value: `2` */
  "lowerlimit.linestyle": number;
  /** Default value: `1` */
  "lowerlimit.linewidth": number;
  /** Default value: `true` */
  "lowerlimit.visible": boolean;
  /** Default value: `-80` */
  "lowerlimit.value": number;
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `1` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#7E57C2` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
/**
 * Overrides for the 'Zig Zag' indicator.
 *
 * Use these properties to customize indicator via {@link IChartWidgetApi.createStudy} and {@link IStudyApi.applyOverrides}.
 */
export interface ZigZagIndicatorOverrides {
  /** Default value: `15` */
  "plot.display": number;
  /** Default value: `0` */
  "plot.linestyle": number;
  /** Default value: `2` */
  "plot.linewidth": number;
  /** Default value: `line` */
  "plot.plottype": LineStudyPlotStyleName;
  /** Default value: `false` */
  "plot.trackprice": boolean;
  /** Default value: `0` */
  "plot.transparency": number;
  /** Default value: `#2196F3` */
  "plot.color": string;
  [key: string]: StudyOverrideValueType;
}
export type AccountId = Nominal<string, "AccountID">;
export type AccountManagerColumn = {
  [K in StandardFormatterName | FormatterName]: AccountManagerColumnBase<K>;
}[StandardFormatterName | FormatterName];
/**
 * Describes a single action to put it into a dropdown or a context menu.
 */
export type ActionMetaInfo = ActionDescriptionWithCallback | MenuSeparator;
/**
 * The Ask and Bid quotes.
 */
export type AskBid = Required<Pick<TradingQuotes, "ask" | "bid">>;
export type AvailableSaveloadVersions = "1.0" | "1.1";
export type CellAlignment = "left" | "right";
/**
 * A chart action ID.
 */
export type ChartActionId =
  | "chartProperties"
  | "compareOrAdd"
  | "scalesProperties"
  | "paneObjectTree"
  | "insertIndicator"
  | "symbolSearch"
  | "changeInterval"
  | "timeScaleReset"
  | "chartReset"
  | "seriesHide"
  | "studyHide"
  | "lineToggleLock"
  | "lineHide"
  | "scaleSeriesOnly"
  | "drawingToolbarAction"
  | "stayInDrawingModeAction"
  | "hideAllMarks"
  | "showCountdown"
  | "showSeriesLastValue"
  | "showSymbolLabelsAction"
  | "showStudyLastValue"
  | "showStudyPlotNamesAction"
  | "undo"
  | "redo"
  | "paneRemoveAllStudiesDrawingTools"
  | "showSymbolInfoDialog";
/**
 * Function to provide a description of the chart described by the context data
 */
export type ChartDescriptorFunction = (
  context: ChartDescriptionContext
) => Promise<string | null>;
/**
 * Chart type names for use within the `favorites` Widget Constructor option. This type is for Advanced Charts, if you are looking for the Trading Platform type then please see {@link TradingTerminalChartTypeFavorites}.
 *
 * See {@link Favorites} for the Widget Constructor option where you can define these favorites, and {@link ChartingLibraryWidgetOptions.favorites} for the Widget Constructor option.
 */
export type ChartTypeFavorites =
  | "Area"
  | "Bars"
  | "Candles"
  | "Heiken Ashi"
  | "Hollow Candles"
  | "Line"
  | "Line Break"
  | "Baseline"
  | "LineWithMarkers"
  | "Stepline"
  | "Columns"
  | "High-low";
/** This is the list of all [featuresets](https://www.tradingview.com/charting-library-docs/latest/customization/Featuresets.md) that work in Advanced Charts */
export type ChartingLibraryFeatureset =
  /** Allows storing all properties (including favorites) to the localstorage @default true */
  | "use_localstorage_for_settings"
  /** Disabling this feature hides "Favorite this item" icon for Drawings and Intervals @default true */
  | "items_favoriting"
  /** Can be disabled to forbid storing chart properties to the localstorage while allowing to save other properties. The other properties are favorites in the Advanced Charts and Watchlist symbols and some panels states in the Trading Platform @default true @default true */
  | "save_chart_properties_to_local_storage"
  /** Add the volume indicator upon initialisation of the chart @default true */
  | "create_volume_indicator_by_default"
  /** Prevent the volume indicator from being recreated when an instrument or a resolution is switched @default true */
  | "create_volume_indicator_by_default_once"
  /** Places Volume indicator on the same pane with the main series @default true */
  | "volume_force_overlay"
  /** Determines the behavior of Zoom feature: bar under the mouse cursor stays in the same place if this feature is disabled @default true */
  | "right_bar_stays_on_scroll"
  /** Keeps the dialogs within the chart @default true */
  | "constraint_dialogs_movement"
  /** Enables logs @default false */
  | "charting_library_debug_mode"
  /** This enables Drawings Toolbar in the fullscreen mode @default false */
  | "side_toolbar_in_fullscreen_mode"
  /** Enables header widget DOM element in the fullscreen mode @default false */
  | "header_in_fullscreen_mode"
  /** Shows bar time exactly as provided by the data feed with no adjustments @default false */
  | "disable_resolution_rebuild"
  /** Allows chart scrolling @default true */
  | "chart_scroll"
  /** Allows chart zooming @default true */
  | "chart_zoom"
  /** If enabled, the chart handles horizontal pointer movements on touch screens. In this case the webpage is not scrolled. If disabled, the webpage is scrolled instead. Keep in mind that if the user starts scrolling the chart vertically or horizontally, scrolling is continued in any direction until the user releases the finger @default true */
  | "horz_touch_drag_scroll"
  /** If enabled, the chart handles vertical pointer movements on touch screens. In this case the webpage is not scrolled. If disabled, the webpage is scrolled instead. Keep in mind that if the user starts scrolling the chart vertically or horizontally, scrolling is continued in any direction until the user releases the finger @default true */
  | "vert_touch_drag_scroll"
  /** If enabled, chart scrolling with horizontal mouse wheel is enabled @default true */
  | "mouse_wheel_scroll"
  /** If enabled, chart scrolling with left mouse button pressed is allowed @default true */
  | "pressed_mouse_move_scroll"
  /** If enabled, series scaling with a mouse wheel is enabled @default true */
  | "mouse_wheel_scale"
  /** If enabled, series scaling with pinch/zoom gestures (this option is supported on touch devices) is enabled @default true */
  | "pinch_scale"
  /** If enabled, axis scaling with left mouse button pressed is allowed @default true */
  | "axis_pressed_mouse_move_scale"
  /** Allows zooming in to show up to one bar in the viewport @default false */
  | "low_density_bars"
  /** Disabling this feature allows a user to enter case-sensitive symbols @default true */
  | "uppercase_instrument_names"
  /** Disables minimum chart width limitation @default false */
  | "no_min_chart_width"
  /** Prevents scrolling to the left of the first historical bar @default false */
  | "fix_left_edge"
  /** Prevents changing visible time area on chart resizing @default false */
  | "lock_visible_time_range_on_resize"
  /** If disabled, adding a new bar zooms out the chart preserving the first visible point. Otherwise the chart is scrolled one point to the left when a new bar comes @default true */
  | "shift_visible_range_on_new_bar"
  /** If enabled, there is a possibility to add custom resolutions @default false */
  | "custom_resolutions"
  /** Toggles the timeline marks to display the bar's end time @default false */
  | "end_of_period_timescale_marks"
  /** If disabled, partially visible price labels on price axis will be hidden @default true */
  | "cropped_tick_marks"
  /** Applies symbol display mode (ticker/description) to overlay/compare studies in the status line @default false */
  | "study_overlay_compare_legend_option"
  /** Applies symbol display mode (ticker/description) to indicator inputs in the status line @default false */
  | "study_symbol_ticker_description"
  /** Displays Symbol Name Label when comparing Symbols @default true */
  | "auto_enable_symbol_labels"
  /** Enables insert indicator dialog shortcut (/) @default true */
  | "insert_indicator_dialog_shortcut"
  /** Display at most two characters in bar marks. The default behavior is to only display one character @default false */
  | "two_character_bar_marks_labels"
  /** By default many chart layouts can be saved with the same name. If this feature is enabled then the library will prompt to confirm overwriting chart layouts with the same name when saving, renaming, or cloning ("Save as") @default false */
  | "confirm_overwrite_if_chart_layout_with_name_exists"
  /** By default the chart will request a small (fixed) number of bars for the initial data request when the chart is first created. If this feature is enabled then the library will rather calculate the request size based on the amount of bars which will be visible on the chart @default false */
  | "determine_first_data_request_size_using_visible_range"
  /** Places the logo on the main series pane instead of the bottom pane @default false */
  | "move_logo_to_main_pane"
  /** Enables a button in the header to load/save `Indicator template` @default false */
  | "study_templates"
  /** Enables copying of drawings and studies @default true */
  | "datasource_copypaste"
  /** Enables the support of resolutions that start from 1 second @default false */
  | "seconds_resolution"
  /** Enables the support of tick resolution @default false */
  | "tick_resolution"
  /** Enables a feature to allow an additional series to extend the time scale @default false */
  | "secondary_series_extend_time_scale"
  /** Removes the header from the chart @default true */
  | "header_widget"
  /** Hides the symbol search button from the header @default true */
  | "header_symbol_search"
  /** Symbol search by pressing any key @default true */
  | "symbol_search_hot_key"
  /** Hides the resolution button from the header @default true */
  | "header_resolutions"
  /** Displays a `Change interval` dialog to specify another resolution @default true */
  | "show_interval_dialog_on_key_press"
  /** Hides the chart type button from the header @default true */
  | "header_chart_type"
  /** Relates to Chart Properties button @default true */
  | "header_settings"
  /** Hides the indicators button from the header @default true */
  | "header_indicators"
  /** Hides the compare button from the header @default true */
  | "header_compare"
  /** Hides the undo/redo button from the header @default true */
  | "header_undo_redo"
  /** Hides the quick search button from the header @default true */
  | "header_quick_search"
  /** Hides the screenshot button from the header @default true */
  | "header_screenshot"
  /** Hides the fullscreen button from the header @default true */
  | "header_fullscreen_button"
  /** Adds a 2px padding to the chart @default true */
  | "border_around_the_chart"
  /** Hides save/load buttons (the feature is not part of `header_widget` featureset) @default true */
  | "header_saveload"
  /** Hides the left toolbar aka drawings toolbar @default true */
  | "left_toolbar"
  /** Relates to the navigation buttons at the bottom of the chart @default true */
  | "control_bar"
  /** Hide the timeframe toolbar at the bottom of the chart @default true */
  | "timeframes_toolbar"
  /** Disabling this feature hides the legend widget @default true */
  | "legend_widget"
  /** Display legend on all diagrams regardless of crosshair synchronization @default false */
  | "display_legend_on_all_charts"
  /** Display object tree button in the legend at a small width @default true */
  | "object_tree_legend_mode"
  /** Removes all buttons from the legend except the ellipsis menu @default true */
  | "edit_buttons_in_legend"
  /** Removes the eye button that hides/shows a chart @default true */
  | "show_hide_button_in_legend"
  /** Removes the cog icon for accessing chart/indicator's settings @default true */
  | "format_button_in_legend"
  /** Removes the delete button @default true */
  | "delete_button_in_legend"
  /** Doesn't display any context menu when right clicking anywhere in the UI @default true */
  | "context_menus"
  /** Doesn't display the context menu when right clicking on the chart @default true */
  | "pane_context_menu"
  /** Doesn't display the context menu when right clicking on either price scale or timescale @default true */
  | "scales_context_menu"
  /** Doesn't display the context menu when right clicking on the legend @default true */
  | "legend_context_menu"
  /** Displays the settings button in the bottom right corner of the chart @default true */
  | "main_series_scale_menu"
  /** Hides the market status from the legend @default true */
  | "display_market_status"
  /** Sets the border style to 0px & padding to 1px @default true */
  | "remove_library_container_border"
  /** Disables all property pages @default true */
  | "property_pages"
  /** Turning this feature off disables Properties @default true */
  | "show_chart_property_page"
  /** Allows overrides for the price scale @default true */
  | "chart_property_page_scales"
  /** This feature is for the Trading Platform only @default true */
  | "chart_property_page_trading"
  /** Shows the right margin editor in the setting dialog @default true */
  | "chart_property_page_right_margin_editor"
  /** Displays a countdown label on a price scale @default true */
  | "countdown"
  /** Hides true/false study arguments @default false */
  | "dont_show_boolean_study_arguments"
  /** Hides last n/a study output data @default false */
  | "hide_last_na_study_output"
  /** Enables the symbol info dialog @default true */
  | "symbol_info"
  /** Disables timezone context menu @default true */
  | "timezone_menu"
  /** Includes orders/positions/executions in the screenshot @default false */
  | "snapshot_trading_drawings"
  /** Disables selection markers for series and indicators @default true */
  | "source_selection_markers"
  /** Allows you to jump to a particular bar using 'Go to' dialog @default true */
  | "go_to_date"
  /** Allows you to hide 'charts by TradingView' text on small-screen devices @default true */
  | "adaptive_logo"
  /** Shows DOM panel when a user opens the Chart for the first time @default false */
  | "show_dom_first_time"
  /** Hides left toolbar when a user opens the Chart for the first time @default false */
  | "hide_left_toolbar_by_default"
  /** Adds High-low option to chart style controls @default true */
  | "chart_style_hilo"
  /** Enables last price line and price axis label on High-low chart style @default false */
  | "chart_style_hilo_last_price"
  /** Displays the currency in which the instrument is traded on the price axes @default false */
  | "pricescale_currency"
  /** Displays the unit in which the instrument is traded on the price axes @default false */
  | "pricescale_unit"
  /** Displays Date Format selector in Chart Settings @default true */
  | "scales_date_format"
  /** Displays popup hints about possible mouse/shortcuts/UI actions @default true */
  | "popup_hints"
  /** Enables the save shortcut @default true */
  | "save_shortcut"
  /** Opens right widget toolbar on first launch @default true */
  | "show_right_widgets_panel_by_default"
  /** Shows the object tree button in the left or right panel depending on the product and configuration @default true */
  | "show_object_tree"
  /** Shows the spread operators in the Symbol Search dialog @default false */
  | "show_spread_operators"
  /** Hide exponentiation spread operator (^) in the Symbol Search dialog @default false */
  | "hide_exponentiation_spread_operator"
  /** Hide reciprocal spread operator (1/x) in the Symbol Search dialog @default false */
  | "hide_reciprocal_spread_operator"
  /** Shows the spread operators in the Compare Search dialog - needs to be used in conjunction to show_spread_operators @default false */
  | "compare_symbol_search_spread_operators"
  /** Shows the spread operators for Studies - needs to be used in conjunction to show_spread_operators @default false */
  | "studies_symbol_search_spread_operators"
  /** Hide the interval (D, 2D, W, M, etc.) in the chart legend and the data window @default false */
  | "hide_resolution_in_legend"
  /** Hide unresolved symbols in the chart legend and the data window @default false */
  | "hide_unresolved_symbols_in_legend"
  /** On touch device show the zoom and move buttons at the bottom of the chart @default false */
  | "show_zoom_and_move_buttons_on_touch"
  /** Hide the optional symbol input value from the indicator's legend if 'Main chart symbol' option is selected @default true */
  | "hide_main_series_symbol_from_indicator_legend"
  /** Hide the global last price label on price scale if last bar is outside of visible range @default false */
  | "hide_price_scale_global_last_bar_value"
  /** Hide the visibility settings of the label and the average close price line @default false */
  | "show_average_close_price_line_and_label"
  /** Hide image shown to illustrate symbol is invalid @default false */
  | "hide_image_invalid_symbol"
  /** Show/Hide the exchange label from the displayed label @default false */
  | "hide_object_tree_and_price_scale_exchange_label"
  /** Displays Time Format selector in Chart Settings @default true */
  | "scales_time_hours_format"
  /** Show a literal "n/a" for not available values instead of "∅" @default false */
  | "use_na_string_for_not_available_values"
  /** Enable pre and post market session support @default false */
  | "pre_post_market_sessions"
  /** Show the option to specify the default right margin in percentage within chart settings dialog @default false */
  | "show_percent_option_for_right_margin"
  /**
   * Lock the visible range when adjusting the percentage right margin via the settings dialog.
   * This applies when the chart is already at the current default margin position.
   * @default false
   */
  | "lock_visible_time_range_when_adjusting_percentage_right_margin"
  /**
   * Alternative loading mode for the library, which can be used to support
   * older browsers and a few non-standard browsers.
   * @default false
   */
  | "iframe_loading_compatibility_mode"
  /** Use the last (rightmost) visible bar value in the legend  @default false */
  | "use_last_visible_bar_value_in_legend"
  /** Enable long symbol descriptions to be shown in the main series and compare studies legends, if provided in the symbol info data. */
  | "symbol_info_long_description"
  /** Enable symbol price source to be shown in the main series and compare studies legends, if provided in the symbol info data. */
  | "symbol_info_price_source"
  /** Enable saving/loading of chart templates. */
  | "chart_template_storage"
  /**
   * When chart data is reset, then re-request data for just the visible range (instead of the entire range of the existing data loaded).
   * @default false
   */
  | "request_only_visible_range_on_reset"
  /** Clear pane price scales when the main series has an error or has no bars. @default true */
  | "clear_price_scale_on_error_or_empty_bars"
  /** Enables the ability to in-place edit of studies or series in legend. @default true */
  | "legend_inplace_edit"
  /**
   * Display logos for the symbols within the symbol search dialog, and the watchlist widget. The datafeed should provide the image url within the search result item, and the SymbolInfo. {@link LibrarySymbolInfo.logo_urls}, {@link SearchSymbolResultItem.logo_urls}
   * @default false
   */
  | "show_symbol_logos"
  /**
   * Display logos for the exchanges within the symbol search dialog. The datafeed should provide the image url within the search result item. {@link SearchSymbolResultItem.exchange_logo}
   * @default false
   */
  | "show_exchange_logos"
  /**
   * Display the main symbol's logo within the legend. This requires that `show_symbol_logos` is enabled.
   * @default true
   */
  | "show_symbol_logo_in_legend"
  /**
   * Display the symbol's logo within the legend for compare studies. This requires that `show_symbol_logos` and `show_symbol_logo_in_legend` are enabled.
   * @default true
   */
  | "show_symbol_logo_for_compare_studies"
  /**
   * Display legend values when on mobile.
   * @default false
   */
  | "always_show_legend_values_on_mobile"
  /** Enable studies to extend the time scale, if enabled in the study metainfo */
  | "studies_extend_time_scale"
  /** Replace Alt + Z with Tab, Tab with Shift + Arrow right, Shift + Tab with Shift + Arrow left @default false */
  | "accessible_keyboard_shortcuts"
  /**
   * Enable accessibility features. Adds a keyboard shortcut which turns on keyboard navigation (alt/opt + z).
   * @default true
   */
  | "accessibility"
  /**
   * Generates a more detailed ARIA description of the chart for screen readers when the active chart is changed
   * by the user. The more detailed description includes a brief description of the price values for the main series.
   * ARIA descriptions are currently only provided for the English language, however you can use the
   * {@link ChartingLibraryWidgetOptions.custom_chart_description_function} constructor option if you wish to add
   * support for additional languages.
   * @default false
   */
  | "aria_detailed_chart_descriptions"
  /**
   * Announces, via the screen reader, the price when the crosshair is moved on the chart.
   * Currently only supported for the English language.
   * @default false
   */
  | "aria_crosshair_price_description"
  /**
   * Enables an [alternative saving and loading mode](https://www.tradingview.com/charting-library-docs/latest/saving_loading/saving_loading.md#saving-drawings-separately) for the library. This mode saves the state of the drawings separately from the chart layout.
   * @default false
   */
  | "saveload_separate_drawings_storage";
/** These are defining the types for a background */
export type ColorTypes = "solid" | "gradient";
/**
 * Context menu items processor signature
 * @param  {readonlyIActionVariant[]} items - an array of items the library wants to display
 * @param  {ActionsFactory} actionsFactory - factory you could use to create a new items for the context menu.
 * @param  {CreateContextMenuParams} params - an object representing additional information about the context menu, such as the menu name.
 */
export type ContextMenuItemsProcessor = (
  items: readonly IActionVariant[],
  actionsFactory: ActionsFactory,
  params: CreateContextMenuParams
) => Promise<readonly IActionVariant[]>;
/**
 * @param  {readonlyIActionVariant[]} items - an array of items the library wants to display
 * @param  {CreateContextMenuParams} params - an object representing where the user right-clicked on (only if there is an existing menu)
 * @param  {()=>void} onDestroy - function that you should call once a created menu is hidden/destroyed
 * @returns {Promise<IContextMenuRenderer | null>} - promise for a renderer or null. If the promise resolves with null, default chart menu is used
 */
export type ContextMenuRendererFactory = (
  items: readonly IActionVariant[],
  params: CreateContextMenuParams,
  onDestroy: () => void
) => Promise<IContextMenuRenderer | null>;
export type CreateButtonOptions =
  | CreateHTMLButtonOptions
  | CreateTradingViewStyledButtonOptions;
export type CustomStudyFormatter = Omit<INumberFormatter, "parse">;
/**
 * Factory function that can be implemented to create custom study formatters.
 */
export type CustomStudyFormatterFactory = (
  format: CustomStudyFormatterFormat,
  symbolInfo: LibrarySymbolInfo | null,
  precision: string | undefined
) => CustomStudyFormatter | null;
/**
 * A function that takes an {@link TableFormatterInputs} object and returns a `string` or an `HTMLElement`.
 */
export type CustomTableFormatElementFunction<
  T extends TableFormatterInputValues = TableFormatterInputValues
> = (inputs: TableFormatterInputs<T>) => undefined | string | HTMLElement;
/**
 * Identifier for a custom timezone (string).
 */
export type CustomTimezoneId = Nominal<"CustomTimezoneId", string>;
export type CustomTimezones =
  | "Africa/Cairo"
  | "Africa/Casablanca"
  | "Africa/Johannesburg"
  | "Africa/Lagos"
  | "Africa/Nairobi"
  | "Africa/Tunis"
  | "America/Anchorage"
  | "America/Argentina/Buenos_Aires"
  | "America/Bogota"
  | "America/Caracas"
  | "America/Chicago"
  | "America/El_Salvador"
  | "America/Juneau"
  | "America/Lima"
  | "America/Los_Angeles"
  | "America/Mexico_City"
  | "America/New_York"
  | "America/Phoenix"
  | "America/Santiago"
  | "America/Sao_Paulo"
  | "America/Toronto"
  | "America/Vancouver"
  | "Asia/Almaty"
  | "Asia/Ashkhabad"
  | "Asia/Bahrain"
  | "Asia/Bangkok"
  | "Asia/Chongqing"
  | "Asia/Colombo"
  | "Asia/Dhaka"
  | "Asia/Dubai"
  | "Asia/Ho_Chi_Minh"
  | "Asia/Hong_Kong"
  | "Asia/Jakarta"
  | "Asia/Jerusalem"
  | "Asia/Karachi"
  | "Asia/Kathmandu"
  | "Asia/Kolkata"
  | "Asia/Kuwait"
  | "Asia/Manila"
  | "Asia/Muscat"
  | "Asia/Nicosia"
  | "Asia/Qatar"
  | "Asia/Riyadh"
  | "Asia/Seoul"
  | "Asia/Shanghai"
  | "Asia/Singapore"
  | "Asia/Taipei"
  | "Asia/Tehran"
  | "Asia/Tokyo"
  | "Asia/Yangon"
  | "Atlantic/Reykjavik"
  | "Australia/Adelaide"
  | "Australia/Brisbane"
  | "Australia/Perth"
  | "Australia/Sydney"
  | "Europe/Amsterdam"
  | "Europe/Athens"
  | "Europe/Belgrade"
  | "Europe/Berlin"
  | "Europe/Bratislava"
  | "Europe/Brussels"
  | "Europe/Bucharest"
  | "Europe/Budapest"
  | "Europe/Copenhagen"
  | "Europe/Dublin"
  | "Europe/Helsinki"
  | "Europe/Istanbul"
  | "Europe/Lisbon"
  | "Europe/London"
  | "Europe/Luxembourg"
  | "Europe/Madrid"
  | "Europe/Malta"
  | "Europe/Moscow"
  | "Europe/Oslo"
  | "Europe/Paris"
  | "Europe/Prague"
  | "Europe/Riga"
  | "Europe/Rome"
  | "Europe/Stockholm"
  | "Europe/Tallinn"
  | "Europe/Vienna"
  | "Europe/Vilnius"
  | "Europe/Warsaw"
  | "Europe/Zurich"
  | "Pacific/Auckland"
  | "Pacific/Chatham"
  | "Pacific/Fakaofo"
  | "Pacific/Honolulu"
  | "Pacific/Norfolk"
  | "US/Mountain";
/**
 * Custom translation function
 * @param  {string} key - key for string to be translated
 * @param  {CustomTranslateOptions} [options] - additional translation options
 * @param  {boolean} [isTranslated] - True, if the provide key is already translated
 */
export type CustomTranslateFunction = (
  key: string,
  options?: CustomTranslateOptions,
  isTranslated?: boolean
) => string | null;
export type DOMCallback = (data: DOMData) => void;
export type DateFormat = keyof typeof dateFormatFunctions;
export type DeepWriteable<T> = {
  -readonly [P in keyof T]: DeepWriteable<T[P]>;
};
/**
 * The direction of an execution line. Either buy or sell.
 */
export type Direction = "buy" | "sell";
/**
 * A event related to a drawing.
 *
 * - Note that the `properties_changed` event can be emitted before `create` event, and that the
 * event isn't debounced (for example dragging a slider for a property will result in this event
 * firing for each movement on the slider), you may want to debounce this within your code.
 * - The `move` event is emitted when a drawing is moved as a whole, whilst the `points_changed`
 * event is emitted when a single point of the drawing is moved. `points_changed` will always fire
 * when `move` fires but not vice-versa.
 */
export type DrawingEventType =
  | "click"
  | "move"
  | "remove"
  | "hide"
  | "show"
  | "create"
  | "properties_changed"
  | "points_changed";
/**
 * Override properties for drawings.
 * Refer to the [Drawing Overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Drawings-Overrides.md) article for information on how to customize drawings.
 *
 * The following constants are used within the default properties. You cannot use these names directly.
 *
 * - LINESTYLE
 *   - SOLID = 0
 *   - DOTTED = 1
 *   - DASHED = 2
 *   - LARGE_DASHED = 3
 * - LINEEND
 *   - NORMAL = 0
 *   - ARROW  = 1
 *   - CIRCLE = 2
 * - MODE
 *   - BARS = 0
 *   - LINE = 1
 *   - OPENCLOSE = 2;
 *   - LINEOPEN = 3;
 *   - LINEHIGH = 4;
 *   - LINELOW = 5;
 *   - LINEHL2 = 6;
 * - PITCHFORK_STYLE
 *   - ORIGINAL = 0
 *   - SCHIFF = 1
 *   - SCHIFF2 = 2
 *   - INSIDE = 3
 * - STATS_POSITION
 *   - LEFT = 0
 *   - CENTER = 1
 *   - RIGHT = 2
 * - RISK_DISPLAY_MODE
 *   - PERCENTAGE = 'percents'
 *   - MONEY = 'money'
 */
export type DrawingOverrides =
  | FivepointspatternLineToolOverrides
  | AbcdLineToolOverrides
  | AnchoredvwapLineToolOverrides
  | ArcLineToolOverrides
  | ArrowLineToolOverrides
  | ArrowmarkdownLineToolOverrides
  | ArrowmarkerLineToolOverrides
  | ArrowmarkleftLineToolOverrides
  | ArrowmarkrightLineToolOverrides
  | ArrowmarkupLineToolOverrides
  | BalloonLineToolOverrides
  | BarspatternLineToolOverrides
  | BeziercubicLineToolOverrides
  | BezierquadroLineToolOverrides
  | BrushLineToolOverrides
  | CalloutLineToolOverrides
  | CircleLineToolOverrides
  | CommentLineToolOverrides
  | CrosslineLineToolOverrides
  | CypherpatternLineToolOverrides
  | DisjointangleLineToolOverrides
  | ElliottcorrectionLineToolOverrides
  | ElliottdoublecomboLineToolOverrides
  | ElliottimpulseLineToolOverrides
  | ElliotttriangleLineToolOverrides
  | ElliotttriplecomboLineToolOverrides
  | EllipseLineToolOverrides
  | EmojiLineToolOverrides
  | ExecutionLineToolOverrides
  | ExtendedLineToolOverrides
  | FibchannelLineToolOverrides
  | FibcirclesLineToolOverrides
  | FibretracementLineToolOverrides
  | FibspeedresistancearcsLineToolOverrides
  | FibspeedresistancefanLineToolOverrides
  | FibtimezoneLineToolOverrides
  | FibwedgeLineToolOverrides
  | FlagmarkLineToolOverrides
  | FlatbottomLineToolOverrides
  | GanncomplexLineToolOverrides
  | GannfanLineToolOverrides
  | GannfixedLineToolOverrides
  | GannsquareLineToolOverrides
  | GhostfeedLineToolOverrides
  | HeadandshouldersLineToolOverrides
  | HighlighterLineToolOverrides
  | HorzlineLineToolOverrides
  | HorzrayLineToolOverrides
  | IconLineToolOverrides
  | ImageLineToolOverrides
  | InfolineLineToolOverrides
  | InsidepitchforkLineToolOverrides
  | NoteLineToolOverrides
  | NoteabsoluteLineToolOverrides
  | OrderLineToolOverrides
  | ParallelchannelLineToolOverrides
  | PathLineToolOverrides
  | PitchfanLineToolOverrides
  | PitchforkLineToolOverrides
  | PolylineLineToolOverrides
  | PositionLineToolOverrides
  | PredictionLineToolOverrides
  | PricelabelLineToolOverrides
  | ProjectionLineToolOverrides
  | RayLineToolOverrides
  | RectangleLineToolOverrides
  | RegressiontrendLineToolOverrides
  | RiskrewardlongLineToolOverrides
  | RiskrewardshortLineToolOverrides
  | RotatedrectangleLineToolOverrides
  | SchiffpitchforkLineToolOverrides
  | Schiffpitchfork2LineToolOverrides
  | SignpostLineToolOverrides
  | SinelineLineToolOverrides
  | StickerLineToolOverrides
  | TextLineToolOverrides
  | TextabsoluteLineToolOverrides
  | ThreedriversLineToolOverrides
  | TimecyclesLineToolOverrides
  | TrendangleLineToolOverrides
  | TrendbasedfibextensionLineToolOverrides
  | TrendbasedfibtimeLineToolOverrides
  | TrendlineLineToolOverrides
  | TriangleLineToolOverrides
  | TrianglepatternLineToolOverrides
  | VertlineLineToolOverrides;
export type DrawingToolIdentifier =
  | "arrow"
  | "cursor"
  | "dot"
  | "eraser"
  | "LineTool5PointsPattern"
  | "LineToolABCD"
  | "LineToolArc"
  | "LineToolArrow"
  | "LineToolArrowMarkDown"
  | "LineToolArrowMarker"
  | "LineToolArrowMarkLeft"
  | "LineToolArrowMarkRight"
  | "LineToolArrowMarkUp"
  | "LineToolBarsPattern"
  | "LineToolBezierCubic"
  | "LineToolBezierQuadro"
  | "LineToolBrush"
  | "LineToolCallout"
  | "LineToolCircle"
  | "LineToolCircleLines"
  | "LineToolComment"
  | "LineToolCrossLine"
  | "LineToolCypherPattern"
  | "LineToolDateAndPriceRange"
  | "LineToolDateRange"
  | "LineToolDisjointAngle"
  | "LineToolElliottCorrection"
  | "LineToolElliottDoubleCombo"
  | "LineToolElliottImpulse"
  | "LineToolElliottTriangle"
  | "LineToolElliottTripleCombo"
  | "LineToolEllipse"
  | "LineToolExtended"
  | "LineToolFibChannel"
  | "LineToolFibCircles"
  | "LineToolFibRetracement"
  | "LineToolFibSpeedResistanceArcs"
  | "LineToolFibSpeedResistanceFan"
  | "LineToolFibSpiral"
  | "LineToolFibTimeZone"
  | "LineToolFibWedge"
  | "LineToolFixedRangeVolumeProfile"
  | "LineToolFlagMark"
  | "LineToolFlatBottom"
  | "LineToolGannComplex"
  | "LineToolGannFan"
  | "LineToolGannFixed"
  | "LineToolGannSquare"
  | "LineToolGhostFeed"
  | "LineToolHeadAndShoulders"
  | "LineToolHighlighter"
  | "LineToolHorzLine"
  | "LineToolHorzRay"
  | "LineToolInfoLine"
  | "LineToolInsidePitchfork"
  | "LineToolNote"
  | "LineToolNoteAbsolute"
  | "LineToolParallelChannel"
  | "LineToolPath"
  | "LineToolPitchfan"
  | "LineToolPitchfork"
  | "LineToolPolyline"
  | "LineToolPrediction"
  | "LineToolPriceLabel"
  | "LineToolPriceNote"
  | "LineToolPriceRange"
  | "LineToolProjection"
  | "LineToolRay"
  | "LineToolRectangle"
  | "LineToolRegressionTrend"
  | "LineToolRiskRewardLong"
  | "LineToolRiskRewardShort"
  | "LineToolRotatedRectangle"
  | "LineToolSchiffPitchfork"
  | "LineToolSchiffPitchfork2"
  | "LineToolSignpost"
  | "LineToolSineLine"
  | "LineToolText"
  | "LineToolTextAbsolute"
  | "LineToolThreeDrivers"
  | "LineToolTimeCycles"
  | "LineToolTrendAngle"
  | "LineToolTrendBasedFibExtension"
  | "LineToolTrendBasedFibTime"
  | "LineToolTrendLine"
  | "LineToolTriangle"
  | "LineToolTrianglePattern"
  | "LineToolVertLine";
/** Dropdown options which can be adjusted on an existing menu. */
export type DropdownUpdateParams = Partial<Omit<DropdownParams, "align">>;
export type EditObjectDialogObjectType =
  | "mainSeries"
  | "drawing"
  | "study"
  | "other";
export type EmptyCallback = () => void;
export type EntityId = Nominal<string, "EntityId">;
export type ErrorCallback = (reason: string) => void;
/**
 * Description of each field of exported data from the chart
 */
export type FieldDescriptor =
  | TimeFieldDescriptor
  | UserTimeFieldDescriptor
  | SeriesFieldDescriptor
  | StudyFieldDescriptor;
export type FinancialPeriod = "FY" | "FQ" | "FH" | "TTM";
export type FormatterName = Nominal<string, "FormatterName">;
export type GetMarksCallback<T> = (marks: T[]) => void;
export type GetNewsFunction = (
  symbol: string,
  callback: (response: GetNewsResponse) => void
) => void;
/**
 * GMT timezone ID.
 *
 * In order to conform with the POSIX style, those zone names
 * beginning with "Etc/GMT" have their sign reversed from the
 * standard ISO 8601 convention. In the "Etc" area, zones west
 * of GMT have a positive sign and those east have a negative
 * sign in their name (e.g "Etc/GMT-14" is 14 hours ahead of GMT).
 */
export type GmtTimezoneId = `Etc/GMT${"+" | "-"}${number}${`:${number}` | ""}`;
export type GroupLockState = "Locked" | "Unlocked" | "Partial";
export type GroupVisibilityState = "Visible" | "Invisible" | "Partial";
/**
 * Mode can be of the following:
 *
 * * `fullsize`: always full-size buttons on the top toolbar
 * * `adaptive`: adaptive/auto mode (fullsize if the window width allows and icons on small windows).
 * * `compact`: icons only buttons on the top toolbar (favorites won't be shown)
 */
export type HeaderWidgetButtonsMode = "fullsize" | "compact" | "adaptive";
export type HistoryCallback = (bars: Bar[], meta?: HistoryMetadata) => void;
/** Item variants within a context menu */
export type IActionVariant = IAction | ISeparator;
export type IBarArray = [number, number, number, number, number, number];
export type IBasicDataFeed = IDatafeedChartApi & IExternalDatafeed;
export type IPineStudyResult = IPineStudyResultTypes<IPineStudyResultSimple>;
export type IPineStudyResultSimple =
  | StudyPrimitiveResult
  | ISeriesStudyResult
  | INonSeriesStudyBarsResult
  | IProjectionStudyResult
  | INonSeriesStudyResult;
export type IPineStudyResultTypes<TPineStudyResultSimple> =
  | TPineStudyResultSimple
  | PineStudyResultComposite<TPineStudyResultSimple>;
export type IProjectionBar =
  | [number, number, number, number, number, number]
  | [number, number, number, number, number, number, number];
/**
 * An array of bar values.
 *
 * [time, open, high, low, close, volume, updatetime, isBarClosed, emptyBars, emptyBarsPrice]
 */
export type ISeriesStudyResult = [
  time: number,
  open: number,
  high: number,
  low: number,
  close: number,
  volume: number,
  updatetime: number | undefined,
  isBarClosed: boolean | undefined,
  emptyBars: number[] | undefined,
  emptyBarsPrice: number | undefined
];
/**
 * Input field validator
 * @param  {any} value - value to be validated
 */
export type InputFieldValidator = (value: any) => InputFieldValidatorResult;
export type InputFieldValidatorResult =
  | PositiveBaseInputFieldValidatorResult
  | NegativeBaseInputFieldValidatorResult;
export type LanguageCode =
  | "ar"
  | "zh"
  | "ca_ES"
  | "en"
  | "fr"
  | "de"
  | "he_IL"
  | "id_ID"
  | "it"
  | "ja"
  | "ko"
  | "pl"
  | "pt"
  | "ru"
  | "es"
  | "sv"
  | "th"
  | "tr"
  | "vi"
  | "ms_MY"
  | "zh_TW";
export type LayoutType = SingleChartLayoutType | MultipleChartsLayoutType;
export type LegendMode = "horizontal" | "vertical";
export type LibrarySessionId =
  | "regular"
  | "extended"
  | "premarket"
  | "postmarket";
/**
 * Plot Style. Used for `plottype` properties within [Indicator overrides](https://www.tradingview.com/charting-library-docs/latest/customization/overrides/Studies-Overrides.md).
 */
export type LineStudyPlotStyleName =
  | "line"
  | "histogram"
  | "cross"
  | "area"
  | "columns"
  | "circles"
  | "line_with_breaks"
  | "area_with_breaks"
  | "step_line"
  | "step_line_with_breaks"
  | "step_line_with_diamonds";
/**
 * The type of data being requested from the {@link IExternalSaveLoadAdapter.loadLineToolsAndGroups} method.
 *
 * Usually, the 'mainSeriesLineTools' is the requested type that is important for implementing the restoration of drawings associated with a chart.
 */
export type LineToolsAndGroupsLoadRequestType =
  | "allLineTools"
  | "lineToolsWithoutSymbol"
  | "studiesLineTools"
  | "mainSeriesLineTools";
export type MarkConstColors = "red" | "green" | "blue" | "yellow";
export type MultipleChartsLayoutType =
  | "2h"
  | "2v"
  | "2-1"
  | "3s"
  | "3h"
  | "3v"
  | "4"
  | "6"
  | "8"
  | "1-2"
  | "3r"
  | "4h"
  | "4v"
  | "4s"
  | "5h"
  | "6h"
  | "7h"
  | "8h"
  | "1-3"
  | "2-2"
  | "2-3"
  | "1-4"
  | "5s"
  | "6c"
  | "8c";
export type OmitActionId<
  T extends {
    actionId: ActionId;
  }
> = Omit<T, "actionId">;
export type OnActionExecuteHandler = (action: IAction) => void;
export type OnActionUpdateHandler = (action: IAction) => void;
export type OnReadyCallback = (configuration: DatafeedConfiguration) => void;
export type Order = PlacedOrder | BracketOrder;
export type OrderLineLengthUnit = "pixel" | "percentage";
export type OrderTableColumn = AccountManagerColumn & {
  /**
   * An optional numeric array of order statuses that is applied to order columns only. If it is available then the column will be displayed in the specified tabs of the status filter only.
   *
   * Here is the list of possible order statuses:
   *
   * 0 - All
   * 1 - Canceled
   * 2 - Filled
   * 3 - Inactive
   * 5 - Rejected,
   * 6 - Working
   */
  supportedStatusFilters?: OrderStatusFilter[];
};
export type PageName = "watchlist_details_news" | "data_window" | "object_tree";
/**
 * Plot shape ID.
 */
export type PlotShapeId =
  | "shape_arrow_down"
  | "shape_arrow_up"
  | "shape_circle"
  | "shape_cross"
  | "shape_xcross"
  | "shape_diamond"
  | "shape_flag"
  | "shape_square"
  | "shape_label_down"
  | "shape_label_up"
  | "shape_triangle_down"
  | "shape_triangle_up";
export type PositionLineLengthUnit = "pixel" | "percentage";
/** A price scale can either have a specific currency (string) or be a 'mix' of if multiple symbols with different currencies share the same scale. */
export type PriceScaleSelectedCurrency = "Mixed" | string;
export type PriceSource = "open" | "high" | "low" | "close";
export type QuoteData = QuoteOkData | QuoteErrorData;
/**
 * Callback to provide Quote data.
 * @param  {QuoteData[]} data - Quote Data
 */
export type QuotesCallback = (data: QuoteData[]) => void;
/**
 * Error callback for quote data request.
 * @param  {QuoteData[]} reason - message describing the reason for the error
 */
export type QuotesErrorCallback = (reason: string) => void;
export type RawStudyMetaInfoId = Nominal<string, "RawStudyMetaInfoId">;
export type RawStudyMetaInformation = Omit<
  RawStudyMetaInfo,
  "defaults" | "plots"
> & {
  /** array with study plots info. See dedicated article: [Custom Studies Plots](https://www.tradingview.com/charting-library-docs/latest/custom_studies/Custom-Studies-Plots.md) */
  readonly plots?: readonly Readonly<StudyPlotInformation>[];
  /** an object containing settings that are applied when user clicks 'Apply Defaults'. See dedicated article: [Custom Studies Defaults](https://www.tradingview.com/charting-library-docs/latest/custom_studies/metainfo/Custom-Studies-Defaults.md) */
  readonly defaults?: Readonly<DeepPartial<StudyDefaults>>;
};
/**
 * Resolution or time interval is a time period of one bar. Advanced Charts supports tick, intraday (seconds, minutes, hours), and DWM (daily, weekly, monthly) resolutions. The table below describes how to specify different types of resolutions:
 *
 * Resolution | Format | Example
 * ---------|----------|---------
 * Ticks | `xT` | `1T` — one tick
 * Seconds | `xS` | `1S` — one second
 * Minutes | `x` | `1` — one minute
 * Hours | `x` minutes | `60` — one hour
 * Days | `xD` | `1D` — one day
 * Weeks | `xW` | `1W` — one week
 * Months | `xM` | `1M` — one month
 * Years | `xM` months | `12M` — one year
 *
 * Refer to [Resolution](https://www.tradingview.com/charting-library-docs/latest/core_concepts/Resolution) for more information.
 */
export type ResolutionString = Nominal<string, "ResolutionString">;
export type ResolveCallback = (symbolInfo: LibrarySymbolInfo) => void;
/** RSS news feed. */
export type RssNewsFeedItem = RssNewsFeedInfo | RssNewsFeedInfo[];
export type SearchSymbolsCallback = (items: SearchSymbolResultItem[]) => void;
/** An event related to the series. Currently the only possible value for this argument is `price_scale_changed` */
export type SeriesEventType = "price_scale_changed";
export type SeriesFormat = "price" | "volume";
export type SeriesFormatterFactory = (
  symbolInfo: LibrarySymbolInfo | null,
  minTick: string
) => ISymbolValueFormatter | null;
/**
 * Where to attach the price scale.
 * Options are either to the `left`, `right`, next to an already existing price axis using a reference or `no scale` if there are no other scales on the main pane.
 */
export type SeriesPriceScale = "new-left" | "new-right" | "no-scale" | EntityId;
export type SeriesStatusViewSymbolTextSource =
  | "ticker"
  | "description"
  | "ticker-and-description"
  | "long-description";
export type ServerTimeCallback = (serverTime: number) => void;
/**
 * A time range to set. The end `to` value is optional.
 *
 * When the optional `to` value is omitted then the value will
 * fallback to the timestamp of the latest bar on the chart.
 */
export type SetVisibleTimeRange = Omit<VisibleTimeRange, "to"> &
  Partial<Pick<VisibleTimeRange, "to">>;
/** Drawing point */
export type ShapePoint = StickedPoint | PricedPoint | TimePoint;
export type ShapesGroupId = Nominal<string, "ShapesGroupId">;
export type SingleChartLayoutType = "s";
export type SingleIndicatorOverrides =
  | FiftyTwoWeekHighLowIndicatorOverrides
  | AcceleratorOscillatorIndicatorOverrides
  | AccumulationDistributionIndicatorOverrides
  | AccumulativeSwingIndexIndicatorOverrides
  | AdvanceDeclineIndicatorOverrides
  | AnchoredVWAPIndicatorOverrides
  | ArnaudLegouxMovingAverageIndicatorOverrides
  | AroonIndicatorOverrides
  | AverageDirectionalIndexIndicatorOverrides
  | AveragePriceIndicatorOverrides
  | AverageTrueRangeIndicatorOverrides
  | AwesomeOscillatorIndicatorOverrides
  | BalanceofPowerIndicatorOverrides
  | BollingerBandsIndicatorOverrides
  | BollingerBandsBIndicatorOverrides
  | BollingerBandsWidthIndicatorOverrides
  | ChaikinMoneyFlowIndicatorOverrides
  | ChaikinOscillatorIndicatorOverrides
  | ChaikinVolatilityIndicatorOverrides
  | ChandeKrollStopIndicatorOverrides
  | ChandeMomentumOscillatorIndicatorOverrides
  | ChopZoneIndicatorOverrides
  | ChoppinessIndexIndicatorOverrides
  | CommodityChannelIndexIndicatorOverrides
  | CompareIndicatorOverrides
  | ConnorsRSIIndicatorOverrides
  | CoppockCurveIndicatorOverrides
  | CorrelationLogIndicatorOverrides
  | CorrelationCoefficientIndicatorOverrides
  | DetrendedPriceOscillatorIndicatorOverrides
  | DirectionalMovementIndicatorOverrides
  | DonchianChannelsIndicatorOverrides
  | DoubleEMAIndicatorOverrides
  | EMACrossIndicatorOverrides
  | EaseOfMovementIndicatorOverrides
  | EldersForceIndexIndicatorOverrides
  | EnvelopesIndicatorOverrides
  | FisherTransformIndicatorOverrides
  | FixedRangeIndicatorOverrides
  | GuppyMultipleMovingAverageIndicatorOverrides
  | HistoricalVolatilityIndicatorOverrides
  | HullMovingAverageIndicatorOverrides
  | IchimokuCloudIndicatorOverrides
  | KeltnerChannelsIndicatorOverrides
  | KlingerOscillatorIndicatorOverrides
  | KnowSureThingIndicatorOverrides
  | LeastSquaresMovingAverageIndicatorOverrides
  | LinearRegressionCurveIndicatorOverrides
  | LinearRegressionSlopeIndicatorOverrides
  | MACrossIndicatorOverrides
  | MAwithEMACrossIndicatorOverrides
  | MACDIndicatorOverrides
  | MajorityRuleIndicatorOverrides
  | MassIndexIndicatorOverrides
  | McGinleyDynamicIndicatorOverrides
  | MedianPriceIndicatorOverrides
  | MomentumIndicatorOverrides
  | MoneyFlowIndexIndicatorOverrides
  | MovingAverageIndicatorOverrides
  | MovingAverageAdaptiveIndicatorOverrides
  | MovingAverageChannelIndicatorOverrides
  | MovingAverageDoubleIndicatorOverrides
  | MovingAverageExponentialIndicatorOverrides
  | MovingAverageHammingIndicatorOverrides
  | MovingAverageMultipleIndicatorOverrides
  | MovingAverageTripleIndicatorOverrides
  | MovingAverageWeightedIndicatorOverrides
  | NetVolumeIndicatorOverrides
  | OnBalanceVolumeIndicatorOverrides
  | OverlayIndicatorOverrides
  | ParabolicSARIndicatorOverrides
  | PivotPointsStandardIndicatorOverrides
  | PriceChannelIndicatorOverrides
  | PriceOscillatorIndicatorOverrides
  | PriceVolumeTrendIndicatorOverrides
  | RateOfChangeIndicatorOverrides
  | RatioIndicatorOverrides
  | RegressionTrendIndicatorOverrides
  | RelativeStrengthIndexIndicatorOverrides
  | RelativeVigorIndexIndicatorOverrides
  | RelativeVolatilityIndexIndicatorOverrides
  | SMIErgodicIndicatorOscillatorIndicatorOverrides
  | SessionsIndicatorOverrides
  | SmoothedMovingAverageIndicatorOverrides
  | SpreadIndicatorOverrides
  | StandardDeviationIndicatorOverrides
  | StandardErrorIndicatorOverrides
  | StandardErrorBandsIndicatorOverrides
  | StochasticIndicatorOverrides
  | StochasticRSIIndicatorOverrides
  | SuperTrendIndicatorOverrides
  | TRIXIndicatorOverrides
  | TrendStrengthIndexIndicatorOverrides
  | TripleEMAIndicatorOverrides
  | TrueStrengthIndexIndicatorOverrides
  | TypicalPriceIndicatorOverrides
  | UltimateOscillatorIndicatorOverrides
  | VWAPIndicatorOverrides
  | VWMAIndicatorOverrides
  | VolatilityClosetoCloseIndicatorOverrides
  | VolatilityIndexIndicatorOverrides
  | VolatilityOHLCIndicatorOverrides
  | VolatilityZeroTrendClosetoCloseIndicatorOverrides
  | VolumeIndicatorOverrides
  | VolumeOscillatorIndicatorOverrides
  | VolumeProfileFixedRangeIndicatorOverrides
  | VolumeProfileVisibleRangeIndicatorOverrides
  | VortexIndicatorIndicatorOverrides
  | WilliamsRIndicatorOverrides
  | WilliamsAlligatorIndicatorOverrides
  | WilliamsFractalIndicatorOverrides
  | ZigZagIndicatorOverrides;
export type StudyAvailableConstSources =
  | "open"
  | "high"
  | "low"
  | "close"
  | "hl2"
  | "hlc3"
  | "ohlc4"
  | "hlcc4";
/** An event related to a study. */
export type StudyEventType =
  | "create"
  | "remove"
  | "price_scale_changed"
  | "paste_study";
export type StudyFilledAreaStyle =
  | StudyFilledAreaSolidColorStyle
  | StudyFilledAreaGradientColorStyle;
export type StudyInputId = Nominal<string, "StudyInputId">;
export type StudyInputInfo =
  | StudyBooleanInputInfo
  | StudyTextInputInfo
  | StudySymbolInputInfo
  | StudyResolutionInputInfo
  | StudySessionInputInfo
  | StudySourceInputInfo
  | StudyNumericInputInfo
  | StudyPriceInputInfo
  | StudyColorInputInfo
  | StudyTimeInputInfo
  | StudyBarTimeInputInfo
  | StudyTextareaInputInfo;
export type StudyInputInfoList = readonly Readonly<StudyInputInfo>[];
/**
 * The value of a study input.
 */
export type StudyInputValue = string | number | boolean;
export type StudyMetaInfo = DeepWriteable<RawStudyMetaInformation> & {
  /** Identifier for the Study */
  id: string;
};
export type StudyOhlcPlotPreferences =
  | StudyOhlcPlotBarsStylePreferences
  | StudyOhlcPlotCandlesStylePreferences;
export type StudyOverrideValueType = string | number | boolean;
export type StudyPlotDisplayMode =
  | Nominal<number, "StudyPlotDisplayTarget">
  | StudyPlotDisplayTarget;
export type StudyPlotInfo = StudyPlotInformation;
/**
 * A description of a study plot.
 */
export type StudyPlotInformation =
  | StudyArrowsPlotInfo
  | StudyCharsPlotInfo
  | StudyColorerPlotInfo
  | StudyRgbaColorerPlotInfo
  | StudyDataPlotInfo
  | StudyDataOffsetPlotInfo
  | StudyLinePlotInfo
  | StudyOhlcPlotInfo
  | StudyShapesPlotInfo
  | StudyBarColorerPlotInfo
  | StudyBgColorerPlotInfo
  | StudyTextColorerPlotInfo
  | StudyOhlcColorerPlotInfo
  | StudyCandleWickColorerPlotInfo
  | StudyCandleBorderColorerPlotInfo
  | StudyUpColorerPlotInfo
  | StudyDownColorerPlotInfo;
/**
 * Study plot style preferences.
 */
export type StudyPlotPreferences =
  | StudyLinePlotPreferences
  | StudyShapesPlotPreferences
  | StudyCharsPlotPreferences
  | StudyArrowsPlotPreferences;
export type StudyPlotValueFormat =
  | StudyPlotValueInheritFormat
  | StudyPlotValuePrecisionFormat;
/**
 * Price scale to display a study on.
 *
 * Possible values are:
 * * `new-left` - attach the study to a new left price scale
 * * `new-right` - attach the study to a new right price scale
 * * `no-scale` - do not attach the study to any price scale. The study will be added in 'No Scale' mode
 * * `as-series` - attach the study to the price scale where the main series is attached (it is only applicable the study is added to the pane with the main series)
 */
export type StudyPriceScale =
  | "new-left"
  | "new-right"
  | "no-scale"
  | "as-series";
export type StudyPrimitiveResult = (number | StudyResultValueWithOffset)[];
export type SubscribeBarsCallback = (bar: Bar) => void;
export type SuggestedQtyChangedListener = (newQty: number) => void;
export type SupportedLineTools =
  | "text"
  | "anchored_text"
  | "note"
  | "anchored_note"
  | "signpost"
  | "double_curve"
  | "arc"
  | "icon"
  | "emoji"
  | "sticker"
  | "arrow_up"
  | "arrow_down"
  | "arrow_left"
  | "arrow_right"
  | "price_label"
  | "price_note"
  | "arrow_marker"
  | "flag"
  | "vertical_line"
  | "horizontal_line"
  | "cross_line"
  | "horizontal_ray"
  | "trend_line"
  | "info_line"
  | "trend_angle"
  | "arrow"
  | "ray"
  | "extended"
  | "parallel_channel"
  | "disjoint_angle"
  | "flat_bottom"
  | "anchored_vwap"
  | "pitchfork"
  | "schiff_pitchfork_modified"
  | "schiff_pitchfork"
  | "balloon"
  | "comment"
  | "inside_pitchfork"
  | "pitchfan"
  | "gannbox"
  | "gannbox_square"
  | "gannbox_fixed"
  | "gannbox_fan"
  | "fib_retracement"
  | "fib_trend_ext"
  | "fib_speed_resist_fan"
  | "fib_timezone"
  | "fib_trend_time"
  | "fib_circles"
  | "fib_spiral"
  | "fib_speed_resist_arcs"
  | "fib_channel"
  | "xabcd_pattern"
  | "cypher_pattern"
  | "abcd_pattern"
  | "callout"
  | "triangle_pattern"
  | "3divers_pattern"
  | "head_and_shoulders"
  | "fib_wedge"
  | "elliott_impulse_wave"
  | "elliott_triangle_wave"
  | "elliott_triple_combo"
  | "elliott_correction"
  | "elliott_double_combo"
  | "cyclic_lines"
  | "time_cycles"
  | "sine_line"
  | "long_position"
  | "short_position"
  | "forecast"
  | "date_range"
  | "price_range"
  | "date_and_price_range"
  | "bars_pattern"
  | "ghost_feed"
  | "projection"
  | "rectangle"
  | "rotated_rectangle"
  | "circle"
  | "ellipse"
  | "triangle"
  | "polyline"
  | "path"
  | "curve"
  | "cursor"
  | "dot"
  | "arrow_cursor"
  | "eraser"
  | "measure"
  | "zoom"
  | "brush"
  | "highlighter"
  | "regression_trend"
  | "fixed_range_volume_profile";
/**
 * function to override the symbol input from symbol search dialogs
 * @param  {SymbolSearchCompleteData} symbol - input from the symbol search
 */
export type SymbolSearchCompleteOverrideFunction = (
  symbol: string,
  searchResultItem?: SearchSymbolResultItem
) => Promise<SymbolSearchCompleteData>;
export type SymbolSource = SymbolInputSymbolSource;
export type SymbolType =
  | "stock"
  | "index"
  | "forex"
  | "futures"
  | "bitcoin"
  | "crypto"
  | "undefined"
  | "expression"
  | "spread"
  | "cfd"
  | "economic"
  | "equity"
  | "dr"
  | "bond"
  | "right"
  | "warrant"
  | "fund"
  | "structured"
  | "commodity"
  | "fundamental"
  | "spot"
  | "swap";
/**
 * A function that takes an {@link TableFormatterInputs} object and returns a `string`.
 */
export type TableFormatTextFunction<
  T extends TableFormatterInputValues = TableFormatterInputValues
> = (inputs: TableFormatterInputs<T>) => string;
export type TableFormatterInputValue = any;
export type TableFormatterInputValues = TableFormatterInputValue[];
export type TextInputFieldValidator = (
  value: string
) => InputFieldValidatorResult;
export type ThemeName = "light" | "dark";
export type TickMarkType =
  /**
   * The start of the year (e.g. it's the first tick mark in a year).
   */
  | "Year"
  /**
   * The start of the month (e.g. it's the first tick mark in a month).
   */
  | "Month"
  /**
   * A day of the month.
   */
  | "DayOfMonth"
  /**
   * A time without seconds.
   */
  | "Time"
  /**
   * A time with seconds.
   */
  | "TimeWithSeconds"
  /**
   * A time with milliseconds.
   */
  | "TimeWithMilliseconds";
/**
 * Type of timeframe defined in the UI.
 * Can either be a single one {@link TimeFramePeriodBack} or a range {@link TimeFrameTimeRange}
 *
 * Examples:
 * 1. a timeframe object, `{type, value}`:
 *     * `type`: `period-back`.
 *     * `value`: valid timeframe is a number with letter D for days and M for months.
 * 2. a range object, `{type, from, to}`
 *     * `type`: `time-range`.
 *     * `from`, `to`: UNIX timestamps, UTC.
 */
export type TimeFrameValue = TimeFramePeriodBack | TimeFrameTimeRange;
export type TimeScaleMarkShape =
  | "circle"
  | "earningUp"
  | "earningDown"
  | "earning";
export type TimeframeOption =
  | string
  | {
      /** From date timestamp */
      from: number;
      /** To date timestamp */
      to: number;
    };
export type Timezone = "Etc/UTC" | CustomTimezones;
export type TimezoneId = CustomTimezones | "Etc/UTC" | "exchange";
/**
 * `TradableSolutions` has one of the following keys:
 * - `changeAccount` - id of a sub-account suitable for trading the symbol
 * - `changeSymbol` - the symbol suitable for trading with current sub-account
 * - `openUrl` - the object with URL to be opened and text for solution button
 */
export type TradableSolutions =
  | ChangeAccountSolution
  | ChangeSymbolSolution
  | OpenUrlSolution;
export type TradingDialogCustomField =
  | CheckboxFieldMetaInfo
  | TextWithCheckboxFieldMetaInfo
  | CustomComboBoxMetaInfo;
/**
 * Chart type names for use within the `favorites` Widget Constructor option. This type is for Trading Platform, if you are looking for the Advanced Charts type then please see {@link ChartTypeFavorites}.
 *
 * See {@link Favorites} for the Widget Constructor option where you can define these favorites, and {@link TradingTerminalWidgetOptions.favorites} for the Widget Constructor option.
 */
export type TradingTerminalChartTypeFavorites =
  | ChartTypeFavorites
  | "Renko"
  | "Kagi"
  | "Point & figure"
  | "Line Break";
/** This is the list of all featuresets that work on Trading Platform (which is an extension of Advanced Charts) */
export type TradingTerminalFeatureset =
  | ChartingLibraryFeatureset
  /** Enables the "plus" button on the price scale for quick trading @default true */
  | "chart_crosshair_menu"
  /** Enables context menu actions (Clone, Sync) related to Multiple Chart Layout @default true */
  | "support_multicharts"
  /** Shows the Select Layout button in the header @default true */
  | "header_layouttoggle"
  /** Enables "Add symbol to Watchlist" item in the menu @default true */
  | "add_to_watchlist"
  /** Keeps the Account Manager opened by default @default true */
  | "open_account_manager"
  /** Shows trading notifications on the chart @default true */
  | "trading_notifications"
  /** Enables creating of multiple watchlists @default true */
  | "multiple_watchlists"
  /** Enables the Notifications Log tab in the bottom panel @default true */
  | "show_trading_notifications_history"
  /** If a bracket order is modified, the terminal passes its parent order to `modifyOrder`. The featureset disables this behavior @default false */
  | "always_pass_called_order_to_modify"
  /** Enables Drawing Templates on Drawing toolbar. If disabled users will still be able to apply the default settings for their selection. @default true */
  | "drawing_templates"
  /** Shows the Account Manager Widget @default true */
  | "trading_account_manager"
  /** Shows the right buttons toolbar @default true */
  | "right_toolbar"
  /** Shows the Order Panel @default true */
  | "order_panel"
  /** Shows the Order info section in the Order dialog @default true */
  | "order_info"
  /** Shows the Buy/Sell Buttons in Legend @default true */
  | "buy_sell_buttons"
  /** Shows the Broker Button in Legend @default true */
  | "broker_button"
  /** Order Panel is visible when the chart opens @default false */
  | "show_order_panel_on_start"
  /** Shows close Order Panel button @default true */
  | "order_panel_close_button"
  /** Shows the Undock button in the Order Panel Settings @default true */
  | "order_panel_undock"
  /** Hide the close button for position @default false */
  | "chart_hide_close_position_button"
  /** Hide the close button for order @default false */
  | "chart_hide_close_order_button"
  /** Enables watchlist export and import @default true */
  | "watchlist_import_export"
  /** Enables DOM widget visibility @default false */
  | "dom_widget"
  /** Keeps Object Tree widget in the right toolbar. If the right toolbar is not enabled this feature will have no effect. @default false */
  | "keep_object_tree_widget_in_right_toolbar"
  /** Show only the last price and change values in the main series legend @default false */
  | "show_last_price_and_change_only_in_series_legend"
  /** Adds the _Last day change values_ option to the _Chart Settings_ dialog in the UI. This option allows users to show/hide the last day change values in the main series legend. @default false */
  | "legend_last_day_change"
  /** Enable context menu support in the watchlist. */
  | "watchlist_context_menu "
  /** Hide the right_toolbar when initialising the chart. Can be expanded using the widgetBar API {@link IWidgetbarApi}  @default false */
  | "hide_right_toolbar"
  /** Hide the tabs within the right toolbar @default false */
  | "hide_right_toolbar_tabs"
  /** Hide price scales when all sources attached to the price scale are hidden. */
  | "hide_price_scale_if_all_sources_hidden"
  /**
   * Display the symbol's logo within the account manager panel. This requires that `show_symbol_logos` is enabled.
   * @default true
   */
  | "show_symbol_logo_in_account_manager"
  /**
   * Display UI (buttons and context menu options) for creating sections within the watchlist.
   * @default true
   */
  | "watchlist_sections";
export type VisiblePlotsSet = "ohlcv" | "ohlc" | "c";
export type WatchListSymbolListAddedCallback = (
  listId: string,
  symbols: string[]
) => void;
export type WatchListSymbolListChangedCallback = (listId: string) => void;
export type WatchListSymbolListRemovedCallback = (listId: string) => void;
export type WatchListSymbolListRenamedCallback = (
  listId: string,
  oldName: string,
  newName: string
) => void;
export type WatchedValueCallback<T> = (value: T) => void;
/**
 * Custom watermark content provider which should return an array of watermark lines to be displayed.
 * Return `null` if you would like to use the default content.
 */
export type WatermarkContentProvider = (
  data: WatermarkContentData
) => WatermarkLine[] | null;
export type WidgetOverrides = DrawingOverrides & {
  [key: string]: string | number | boolean;
};

export as namespace TradingView;

export {};

declare type DeepPartial<T> = {
  [P in keyof T]?: T[P] extends (infer U)[]
    ? DeepPartial<U>[]
    : T[P] extends readonly (infer X)[]
    ? readonly DeepPartial<X>[]
    : DeepPartial<T[P]>;
};
